! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Auxiliary Routines File
! 
! Generated by KPP-2.2.3 symbolic chemistry Kinetics PreProcessor
!       (http://www.cs.vt.edu/~asandu/Software/KPP)
! KPP is distributed under GPL, the general public licence
!       (http://www.gnu.org/copyleft/gpl.html)
! (C) 1995-1997, V. Damian & A. Sandu, CGRER, Univ. Iowa
! (C) 1997-2005, A. Sandu, Michigan Tech, Virginia Tech
!     With important contributions from:
!        M. Damian, Villanova University, USA
!        R. Sander, Max-Planck Institute for Chemistry, Mainz, Germany
! 
! File                 : model_Util.f90
! Time                 : Wed Oct 28 11:54:56 2015
! Working directory    : /work/home/mje516/DSMACC_teaching
! Equation file        : model.kpp
! Output root filename : model
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



MODULE model_Util

  USE model_Parameters
  IMPLICIT NONE

CONTAINS



! User INLINED Utility Functions


! ****************************************************************
!                            
! InitSaveData - Opens the data file for writing
!   Parameters :                                                  
!
! ****************************************************************

      SUBROUTINE NewInitSaveData(counter, outputname)

      USE model_Parameters
      USE model_monitor
      USE model_GLOBAL

      Integer counter, length, ierr
      character*20 filename1, filename
      character*50 outputname

      open(10, file=outputname)
 
      write (10,'(100000(a25,","))') 'TIME','LAT','LON','PRESS','TEMP','H2O', &
	'M', 'JNO2FACT','JO1DFACT','RO2', SPC_NAMES

      END SUBROUTINE NewInitSaveData

! End of InitSaveData function
! ****************************************************************
! ****************************************************************
!                            
! SaveData - Write LOOKAT species in the data file 
!   Parameters :                                                  
!
! ****************************************************************

      SUBROUTINE NewSaveData ()

      USE model_Global
      USE model_Monitor
      USE model_Integrator

      INTEGER i
      
      	WRITE(10,'(10000(E25.16,","))') TIME,LAT,LON,PRESS,TEMP,H2O,CFACTOR,&
	JFACTNO2, JFACTO1D,RO2,C


      END SUBROUTINE NewSaveData

! End of SaveData function
! ****************************************************************

! ****************************************************************
!                            
! CloseSaveData - Close the data file 
!   Parameters :                                                  
!
! ****************************************************************

      SUBROUTINE NewCloseData ()

      USE model_Parameters

      CLOSE(10)


      END SUBROUTINE NewCloseData

! End of CloseSaveData function
! ****************************************************************

      SUBROUTINE ICNVRT(WAY,NUM,STRING,LENGTH,IERR)
!
!       FUNCTION:
!F
!F        This subroutine does an integer-to-character conversion
!F        or a characater-to-integer conversion depending on the
!F        integer WAY:
!F                If WAY = 0 then an integer-to-character conversion
!F                is done. If WAY .NE. 0 then a character-to-integer
!F                conversion is done.
!F
!       USAGE:
!U
!U        !ALL I!NVRT(WAY,NUM,STRING)
!U             where WAY, NUM, STRING, and LENGTH are defined below.
!U
!U        Example: !ALL I!NVRT(0,1000,STRING,LENGTH)
!U                 on return STRING = '1000' and
!U                 LENGTH = 4.
!U         
!       INPUTS:
!I
!I        WAY - INTEGER; Determines which way the conversion goes:
!I              if WAY = 0 then an integer-to-character conversion
!I                         is performed;
!I              if WAY.NE.0 then a character-to-integer conversion
!I                         is performed.
!I
!I         NUM - INTEGER; an input only if WAY = 0. NUM is the integer
!I               number to be converted to a character expression.
!I
!I         STRING - !HARACTER; an input only if WAY .NE. 0. STRING
!I                is the character expression to be converted to an
!CI                integer value. It contain no decimal points or 
!I                non-numeric characters other than possibly a
!I                sign. If STRING contains  a '+' sign, it will be
!I                stripped of it on return.
!I
!       OUTPUTS:
!O
!O         NUM - INTEGER; contains the INTEGER representation of 
!O                STRING.
!O
!O         STRING - !HARA!TER; contains the CHARACTER representation of
!O                  NUM.
!CO
!CO         LENGTH - INTEGER; The length of STRING to the first blank.
!CO                  The significant part of STRING can be accessed with
!CO                  the declaration STRING(1:LENGTH).
!CO
!CO         IERR - INTEGER variable giving return condition:
!CO                IERR = 0 for normal return;
!CO                IERR = 1 if NUM cannot be converted to STRING because
!CO                       STRING is too short or STRING cannot be
!CO                       converted to NUM because STRING is too long.
!CO                IERR = 2 if STRING contained a non-numeric character
!CO                       other than a leading sign or something went
!CO                       wrong with an integer-to-character conversion.
!CO
!C       ALGORITHM:
!CA
!CA         Nothing noteworthy, except that this subroutine will work
!CA          for strange character sets where the character '1' doesn't
!CA          follow '0', etc.
!CA
!C       MACHINE DEPENDENCIES:
!CM
!CM          The parameter MAXINT (below) should be set to the
!CM          number of digits that an INTEGER data type can have
!CM          not including leading signs. For VAX FORTRAN V4.4-177
!CM          MAXINT = 10.
!CM
!CM          NOTE: Under VAX FORTRAN V4.4-177, the
!CM          error condition IERR = 1 will never occur for an
!CM          integer-to-character conversion if STRING
!CM          is allocated at least 11 bytes (CHARACTER*11).
!CM
!C       HISTORY:
!CH
!CH      written by:             bobby bodenheimer
!CH      date:                   september 1986
!CH      current version:        1.0
!CH      modifications:          none
!CH
!C       ROUTINES CALLED:
!CC
!CC          NONE.
!CC
!C----------------------------------------------------------------------
!C       written for:    The CASCADE Project
!C                       Oak Ridge National Laboratory
!C                       U.S. Department of Energy
!C                       contract number DE-AC05-840R21400
!C                       subcontract number 37B-7685 S13
!C                       organization:  The University of Tennessee
!C----------------------------------------------------------------------
!C       THIS SOFTWARE IS IN THE PUBLIC DOMAIN
!C       NO RESTRICTIONS ON ITS USE ARE IMPLIED
!C----------------------------------------------------------------------
!C
!C Global Variables.
!C
      INTEGER       WAY
      INTEGER       LENGTH
      INTEGER       NUM
      INTEGER       IERR
      CHARACTER*(*) STRING
!C
!C Local Variables
!C
      INTEGER       I
      INTEGER       MAXINT
      INTEGER       MNUM
      INTEGER       M
      LOGICAL       NEG
!C
      PARAMETER(MAXINT=10)
!C
      NEG = .FALSE.
      IERR = 0
!C
!C  Integer-to-character conversion.
!C
      IF (WAY.EQ.0) THEN
         STRING = ' '
         IF (NUM.LT.0) THEN
            NEG = .TRUE.
            MNUM = -NUM
            LENGTH = INT(LOG10(REAL(MNUM))) + 1
         ELSE IF (NUM.EQ.0) THEN
            MNUM = NUM
            LENGTH = 1
         ELSE
            MNUM = NUM
            LENGTH = INT(LOG10(REAL(MNUM))) + 1
         END IF
         IF (LENGTH.GT.LEN(STRING)) THEN
            IERR = 1
            RETURN
         END IF
         DO 10, I=LENGTH,1,-1
            M=INT(REAL(MNUM)/10**(I-1))
            IF (M.EQ.0) THEN
               STRING(LENGTH-I+1:LENGTH-I+1) = '0'
            ELSE IF (M.EQ.1) THEN
               STRING(LENGTH-I+1:LENGTH-I+1) = '1'
            ELSE IF (M.EQ.2) THEN
               STRING(LENGTH-I+1:LENGTH-I+1) = '2'
            ELSE IF (M.EQ.3) THEN
               STRING(LENGTH-I+1:LENGTH-I+1) = '3'
            ELSE IF (M.EQ.4) THEN
               STRING(LENGTH-I+1:LENGTH-I+1) = '4'
            ELSE IF (M.EQ.5) THEN
               STRING(LENGTH-I+1:LENGTH-I+1) = '5'
            ELSE IF (M.EQ.6) THEN
               STRING(LENGTH-I+1:LENGTH-I+1) = '6'
            ELSE IF (M.EQ.7) THEN
               STRING(LENGTH-I+1:LENGTH-I+1) = '7'
            ELSE IF (M.EQ.8) THEN
               STRING(LENGTH-I+1:LENGTH-I+1) = '8'
            ELSE IF (M.EQ.9) THEN
               STRING(LENGTH-I+1:LENGTH-I+1) = '9'
            ELSE
               IERR = 2
               RETURN
            END IF
            MNUM = MNUM - M*10**(I-1)
10       CONTINUE
         IF (NEG) THEN
            STRING = '-'//STRING
            LENGTH = LENGTH + 1
         END IF
!C
!C  Character-to-integer conversion.
!!C
      ELSE
         IF (STRING(1:1).EQ.'-') THEN
            NEG = .TRUE.
            STRING = STRING(2:LEN(STRING))
         END IF
         IF (STRING(1:1).EQ.'+') STRING = STRING(2:LEN(STRING))
         NUM = 0
         LENGTH = INDEX(STRING,' ') - 1
         IF (LENGTH.GT.MAXINT) THEN
            IERR = 1
            RETURN
         END IF
         DO 20, I=LENGTH,1,-1
            IF (STRING(LENGTH-I+1:LENGTH-I+1).EQ.'0') THEN
               M = 0
            ELSE IF (STRING(LENGTH-I+1:LENGTH-I+1).EQ.'1') THEN
               M = 1
            ELSE IF (STRING(LENGTH-I+1:LENGTH-I+1).EQ.'2') THEN
               M = 2
            ELSE IF (STRING(LENGTH-I+1:LENGTH-I+1).EQ.'3') THEN
               M = 3
            ELSE IF (STRING(LENGTH-I+1:LENGTH-I+1).EQ.'4') THEN
               M = 4
            ELSE IF (STRING(LENGTH-I+1:LENGTH-I+1).EQ.'5') THEN
               M = 5
            ELSE IF (STRING(LENGTH-I+1:LENGTH-I+1).EQ.'6') THEN
               M = 6
            ELSE IF (STRING(LENGTH-I+1:LENGTH-I+1).EQ.'7') THEN
               M = 7
            ELSE IF (STRING(LENGTH-I+1:LENGTH-I+1).EQ.'8') THEN
               M = 8
            ELSE IF (STRING(LENGTH-I+1:LENGTH-I+1).EQ.'9') THEN
               M = 9
            ELSE
               IERR = 2
               RETURN
            END IF
            NUM = NUM + INT(10**(I-1))*M
20       CONTINUE
         IF (NEG) THEN
            NUM = -NUM
            STRING = '-'//STRING
            LENGTH = LENGTH + 1
         END IF
      END IF
!C
!C  Last lines of ICNVRT
!C
      RETURN
      END SUBROUTINE
         

! End INLINED Utility Functions

! Utility Functions from KPP_HOME/util/util
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! UTIL - Utility functions
!   Arguments :
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

! ****************************************************************
!                            
! InitSaveData - Opens the data file for writing
!   Parameters :                                                  
!
! ****************************************************************

      SUBROUTINE InitSaveData ()

      USE model_Parameters

      open(10, file='model.dat')

      END SUBROUTINE InitSaveData

! End of InitSaveData function
! ****************************************************************

! ****************************************************************
!                            
! SaveData - Write LOOKAT species in the data file 
!   Parameters :                                                  
!
! ****************************************************************

      SUBROUTINE SaveData ()

      USE model_Global
      USE model_Monitor

      INTEGER i

      WRITE(10,999) (TIME-TSTART)/3600.D0,  &
                   (C(LOOKAT(i))/CFACTOR, i=1,NLOOKAT)
999   FORMAT(E24.16,100(1X,E24.16))

      END SUBROUTINE SaveData

! End of SaveData function
! ****************************************************************

! ****************************************************************
!                            
! CloseSaveData - Close the data file 
!   Parameters :                                                  
!
! ****************************************************************

      SUBROUTINE CloseSaveData ()

      USE model_Parameters

      CLOSE(10)

      END SUBROUTINE CloseSaveData

! End of CloseSaveData function
! ****************************************************************

! ****************************************************************
!                            
! GenerateMatlab - Generates MATLAB file to load the data file 
!   Parameters : 
!                It will have a character string to prefix each 
!                species name with.                                                 
!
! ****************************************************************

      SUBROUTINE GenerateMatlab ( PREFIX )

      USE model_Parameters
      USE model_Global
      USE model_Monitor

      
      CHARACTER(LEN=8) PREFIX 
      INTEGER i

      open(20, file='model.m')
      write(20,*) 'load model.dat;'
      write(20,990) PREFIX
990   FORMAT(A1,'c = model;')
      write(20,*) 'clear model;'
      write(20,991) PREFIX, PREFIX
991   FORMAT(A1,'t=',A1,'c(:,1);')
      write(20,992) PREFIX
992   FORMAT(A1,'c(:,1)=[];')

      do i=1,NLOOKAT
        write(20,993) PREFIX, SPC_NAMES(LOOKAT(i)), PREFIX, i
993     FORMAT(A1,A6,' = ',A1,'c(:,',I2,');')
      end do
      
      CLOSE(20)

      END SUBROUTINE GenerateMatlab

! End of GenerateMatlab function
! ****************************************************************


! ****************************************************************
!                            
! tag2num - convert equation tags to kpp reaction number
!   Arguments :
!      id        - string with the equation tag
!
! ****************************************************************

ELEMENTAL INTEGER FUNCTION tag2num ( id )

  USE model_Monitor, ONLY: EQN_TAGS

  CHARACTER(LEN=*), INTENT(IN) :: id
  INTEGER i

  tag2num = 0 ! mz_rs_20050115
  DO i = 1, SIZE(EQN_TAGS)
    IF (TRIM(EQN_TAGS(i)) == TRIM(id)) THEN
      tag2num = i ! mz_rs_20050115
      EXIT
    ENDIF
  END DO

END FUNCTION tag2num

! End of tag2num function
! ****************************************************************

! End Utility Functions from KPP_HOME/util/util
! End of UTIL function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Shuffle_user2kpp - function to copy concentrations from USER to KPP
!   Arguments :
!      V_USER    - Concentration of variable species in USER's order
!      V         - Concentrations of variable species (local)
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE Shuffle_user2kpp ( V_USER, V )

! V_USER - Concentration of variable species in USER's order
  REAL(kind=dp) :: V_USER(NVAR)
! V - Concentrations of variable species (local)
  REAL(kind=dp) :: V(NVAR)

  V(301) = V_USER(1)
  V(360) = V_USER(2)
  V(139) = V_USER(3)
  V(303) = V_USER(4)
  V(304) = V_USER(5)
  V(341) = V_USER(6)
  V(525) = V_USER(7)
  V(439) = V_USER(8)
  V(414) = V_USER(9)
  V(305) = V_USER(10)
  V(299) = V_USER(11)
  V(122) = V_USER(12)
  V(145) = V_USER(13)
  V(166) = V_USER(14)
  V(377) = V_USER(15)
  V(55) = V_USER(16)
  V(86) = V_USER(17)
  V(33) = V_USER(18)
  V(419) = V_USER(19)
  V(498) = V_USER(20)
  V(196) = V_USER(21)
  V(231) = V_USER(22)
  V(87) = V_USER(23)
  V(203) = V_USER(24)
  V(490) = V_USER(25)
  V(225) = V_USER(26)
  V(340) = V_USER(27)
  V(314) = V_USER(28)
  V(264) = V_USER(29)
  V(61) = V_USER(30)
  V(429) = V_USER(31)
  V(463) = V_USER(32)
  V(127) = V_USER(33)
  V(163) = V_USER(34)
  V(128) = V_USER(35)
  V(390) = V_USER(36)
  V(182) = V_USER(37)
  V(69) = V_USER(38)
  V(345) = V_USER(39)
  V(73) = V_USER(40)
  V(192) = V_USER(41)
  V(108) = V_USER(42)
  V(110) = V_USER(43)
  V(133) = V_USER(44)
  V(347) = V_USER(45)
  V(283) = V_USER(46)
  V(564) = V_USER(47)
  V(567) = V_USER(48)
  V(357) = V_USER(49)
  V(120) = V_USER(50)
  V(402) = V_USER(51)
  V(391) = V_USER(52)
  V(51) = V_USER(53)
  V(160) = V_USER(54)
  V(266) = V_USER(55)
  V(253) = V_USER(56)
  V(191) = V_USER(57)
  V(470) = V_USER(58)
  V(440) = V_USER(59)
  V(23) = V_USER(60)
  V(459) = V_USER(61)
  V(319) = V_USER(62)
  V(562) = V_USER(63)
  V(130) = V_USER(64)
  V(170) = V_USER(65)
  V(491) = V_USER(66)
  V(365) = V_USER(67)
  V(478) = V_USER(68)
  V(184) = V_USER(69)
  V(343) = V_USER(70)
  V(263) = V_USER(71)
  V(354) = V_USER(72)
  V(52) = V_USER(73)
  V(194) = V_USER(74)
  V(24) = V_USER(75)
  V(235) = V_USER(76)
  V(549) = V_USER(77)
  V(224) = V_USER(78)
  V(115) = V_USER(79)
  V(230) = V_USER(80)
  V(15) = V_USER(81)
  V(327) = V_USER(82)
  V(403) = V_USER(83)
  V(237) = V_USER(84)
  V(250) = V_USER(85)
  V(497) = V_USER(86)
  V(53) = V_USER(87)
  V(279) = V_USER(88)
  V(54) = V_USER(89)
  V(161) = V_USER(90)
  V(232) = V_USER(91)
  V(240) = V_USER(92)
  V(241) = V_USER(93)
  V(530) = V_USER(94)
  V(569) = V_USER(95)
  V(129) = V_USER(96)
  V(543) = V_USER(97)
  V(336) = V_USER(98)
  V(399) = V_USER(99)
  V(482) = V_USER(100)
  V(25) = V_USER(101)
  V(180) = V_USER(102)
  V(181) = V_USER(103)
  V(359) = V_USER(104)
  V(315) = V_USER(105)
  V(560) = V_USER(106)
  V(450) = V_USER(107)
  V(16) = V_USER(108)
  V(199) = V_USER(109)
  V(388) = V_USER(110)
  V(449) = V_USER(111)
  V(218) = V_USER(112)
  V(222) = V_USER(113)
  V(26) = V_USER(114)
  V(290) = V_USER(115)
  V(294) = V_USER(116)
  V(367) = V_USER(117)
  V(421) = V_USER(118)
  V(297) = V_USER(119)
  V(333) = V_USER(120)
  V(300) = V_USER(121)
  V(27) = V_USER(122)
  V(140) = V_USER(123)
  V(374) = V_USER(124)
  V(480) = V_USER(125)
  V(443) = V_USER(126)
  V(162) = V_USER(127)
  V(522) = V_USER(128)
  V(323) = V_USER(129)
  V(247) = V_USER(130)
  V(56) = V_USER(131)
  V(57) = V_USER(132)
  V(369) = V_USER(133)
  V(81) = V_USER(134)
  V(206) = V_USER(135)
  V(452) = V_USER(136)
  V(277) = V_USER(137)
  V(234) = V_USER(138)
  V(302) = V_USER(139)
  V(544) = V_USER(140)
  V(466) = V_USER(141)
  V(507) = V_USER(142)
  V(123) = V_USER(143)
  V(249) = V_USER(144)
  V(82) = V_USER(145)
  V(448) = V_USER(146)
  V(262) = V_USER(147)
  V(372) = V_USER(148)
  V(269) = V_USER(149)
  V(271) = V_USER(150)
  V(493) = V_USER(151)
  V(124) = V_USER(152)
  V(141) = V_USER(153)
  V(363) = V_USER(154)
  V(281) = V_USER(155)
  V(551) = V_USER(156)
  V(142) = V_USER(157)
  V(500) = V_USER(158)
  V(469) = V_USER(159)
  V(143) = V_USER(160)
  V(83) = V_USER(161)
  V(532) = V_USER(162)
  V(84) = V_USER(163)
  V(434) = V_USER(164)
  V(512) = V_USER(165)
  V(432) = V_USER(166)
  V(455) = V_USER(167)
  V(523) = V_USER(168)
  V(383) = V_USER(169)
  V(495) = V_USER(170)
  V(144) = V_USER(171)
  V(483) = V_USER(172)
  V(85) = V_USER(173)
  V(540) = V_USER(174)
  V(370) = V_USER(175)
  V(13) = V_USER(176)
  V(426) = V_USER(177)
  V(17) = V_USER(178)
  V(252) = V_USER(179)
  V(312) = V_USER(180)
  V(413) = V_USER(181)
  V(28) = V_USER(182)
  V(555) = V_USER(183)
  V(425) = V_USER(184)
  V(417) = V_USER(185)
  V(361) = V_USER(186)
  V(552) = V_USER(187)
  V(393) = V_USER(188)
  V(146) = V_USER(189)
  V(147) = V_USER(190)
  V(148) = V_USER(191)
  V(29) = V_USER(192)
  V(373) = V_USER(193)
  V(558) = V_USER(194)
  V(346) = V_USER(195)
  V(362) = V_USER(196)
  V(58) = V_USER(197)
  V(59) = V_USER(198)
  V(268) = V_USER(199)
  V(60) = V_USER(200)
  V(356) = V_USER(201)
  V(149) = V_USER(202)
  V(465) = V_USER(203)
  V(125) = V_USER(204)
  V(150) = V_USER(205)
  V(394) = V_USER(206)
  V(152) = V_USER(207)
  V(153) = V_USER(208)
  V(274) = V_USER(209)
  V(496) = V_USER(210)
  V(278) = V_USER(211)
  V(154) = V_USER(212)
  V(364) = V_USER(213)
  V(427) = V_USER(214)
  V(155) = V_USER(215)
  V(156) = V_USER(216)
  V(520) = V_USER(217)
  V(126) = V_USER(218)
  V(324) = V_USER(219)
  V(508) = V_USER(220)
  V(499) = V_USER(221)
  V(157) = V_USER(222)
  V(158) = V_USER(223)
  V(366) = V_USER(224)
  V(379) = V_USER(225)
  V(457) = V_USER(226)
  V(458) = V_USER(227)
  V(30) = V_USER(228)
  V(407) = V_USER(229)
  V(31) = V_USER(230)
  V(159) = V_USER(231)
  V(32) = V_USER(232)
  V(472) = V_USER(233)
  V(88) = V_USER(234)
  V(527) = V_USER(235)
  V(62) = V_USER(236)
  V(334) = V_USER(237)
  V(89) = V_USER(238)
  V(535) = V_USER(239)
  V(236) = V_USER(240)
  V(547) = V_USER(241)
  V(550) = V_USER(242)
  V(90) = V_USER(243)
  V(378) = V_USER(244)
  V(464) = V_USER(245)
  V(474) = V_USER(246)
  V(349) = V_USER(247)
  V(533) = V_USER(248)
  V(386) = V_USER(249)
  V(91) = V_USER(250)
  V(18) = V_USER(251)
  V(311) = V_USER(252)
  V(34) = V_USER(253)
  V(238) = V_USER(254)
  V(415) = V_USER(255)
  V(239) = V_USER(256)
  V(63) = V_USER(257)
  V(461) = V_USER(258)
  V(351) = V_USER(259)
  V(352) = V_USER(260)
  V(489) = V_USER(261)
  V(92) = V_USER(262)
  V(477) = V_USER(263)
  V(422) = V_USER(264)
  V(488) = V_USER(265)
  V(164) = V_USER(266)
  V(93) = V_USER(267)
  V(392) = V_USER(268)
  V(94) = V_USER(269)
  V(242) = V_USER(270)
  V(35) = V_USER(271)
  V(243) = V_USER(272)
  V(165) = V_USER(273)
  V(95) = V_USER(274)
  V(96) = V_USER(275)
  V(97) = V_USER(276)
  V(513) = V_USER(277)
  V(244) = V_USER(278)
  V(245) = V_USER(279)
  V(396) = V_USER(280)
  V(542) = V_USER(281)
  V(14) = V_USER(282)
  V(518) = V_USER(283)
  V(454) = V_USER(284)
  V(561) = V_USER(285)
  V(246) = V_USER(286)
  V(167) = V_USER(287)
  V(98) = V_USER(288)
  V(168) = V_USER(289)
  V(19) = V_USER(290)
  V(169) = V_USER(291)
  V(384) = V_USER(292)
  V(412) = V_USER(293)
  V(64) = V_USER(294)
  V(376) = V_USER(295)
  V(99) = V_USER(296)
  V(65) = V_USER(297)
  V(248) = V_USER(298)
  V(66) = V_USER(299)
  V(171) = V_USER(300)
  V(172) = V_USER(301)
  V(173) = V_USER(302)
  V(389) = V_USER(303)
  V(36) = V_USER(304)
  V(503) = V_USER(305)
  V(501) = V_USER(306)
  V(174) = V_USER(307)
  V(175) = V_USER(308)
  V(176) = V_USER(309)
  V(486) = V_USER(310)
  V(462) = V_USER(311)
  V(358) = V_USER(312)
  V(100) = V_USER(313)
  V(539) = V_USER(314)
  V(517) = V_USER(315)
  V(342) = V_USER(316)
  V(251) = V_USER(317)
  V(526) = V_USER(318)
  V(541) = V_USER(319)
  V(177) = V_USER(320)
  V(178) = V_USER(321)
  V(519) = V_USER(322)
  V(548) = V_USER(323)
  V(67) = V_USER(324)
  V(485) = V_USER(325)
  V(310) = V_USER(326)
  V(411) = V_USER(327)
  V(557) = V_USER(328)
  V(481) = V_USER(329)
  V(510) = V_USER(330)
  V(101) = V_USER(331)
  V(531) = V_USER(332)
  V(179) = V_USER(333)
  V(476) = V_USER(334)
  V(353) = V_USER(335)
  V(68) = V_USER(336)
  V(416) = V_USER(337)
  V(102) = V_USER(338)
  V(554) = V_USER(339)
  V(387) = V_USER(340)
  V(424) = V_USER(341)
  V(313) = V_USER(342)
  V(131) = V_USER(343)
  V(435) = V_USER(344)
  V(103) = V_USER(345)
  V(254) = V_USER(346)
  V(255) = V_USER(347)
  V(256) = V_USER(348)
  V(104) = V_USER(349)
  V(37) = V_USER(350)
  V(397) = V_USER(351)
  V(514) = V_USER(352)
  V(423) = V_USER(353)
  V(473) = V_USER(354)
  V(409) = V_USER(355)
  V(105) = V_USER(356)
  V(233) = V_USER(357)
  V(509) = V_USER(358)
  V(257) = V_USER(359)
  V(521) = V_USER(360)
  V(420) = V_USER(361)
  V(183) = V_USER(362)
  V(38) = V_USER(363)
  V(306) = V_USER(364)
  V(467) = V_USER(365)
  V(185) = V_USER(366)
  V(186) = V_USER(367)
  V(316) = V_USER(368)
  V(350) = V_USER(369)
  V(70) = V_USER(370)
  V(400) = V_USER(371)
  V(546) = V_USER(372)
  V(536) = V_USER(373)
  V(187) = V_USER(374)
  V(537) = V_USER(375)
  V(258) = V_USER(376)
  V(188) = V_USER(377)
  V(570) = V_USER(378)
  V(344) = V_USER(379)
  V(259) = V_USER(380)
  V(317) = V_USER(381)
  V(453) = V_USER(382)
  V(260) = V_USER(383)
  V(261) = V_USER(384)
  V(335) = V_USER(385)
  V(189) = V_USER(386)
  V(318) = V_USER(387)
  V(190) = V_USER(388)
  V(39) = V_USER(389)
  V(132) = V_USER(390)
  V(410) = V_USER(391)
  V(71) = V_USER(392)
  V(106) = V_USER(393)
  V(72) = V_USER(394)
  V(40) = V_USER(395)
  V(320) = V_USER(396)
  V(107) = V_USER(397)
  V(559) = V_USER(398)
  V(41) = V_USER(399)
  V(20) = V_USER(400)
  V(401) = V_USER(401)
  V(265) = V_USER(402)
  V(441) = V_USER(403)
  V(193) = V_USER(404)
  V(42) = V_USER(405)
  V(446) = V_USER(406)
  V(267) = V_USER(407)
  V(74) = V_USER(408)
  V(195) = V_USER(409)
  V(21) = V_USER(410)
  V(553) = V_USER(411)
  V(8) = V_USER(412)
  V(565) = V_USER(413)
  V(197) = V_USER(414)
  V(198) = V_USER(415)
  V(442) = V_USER(416)
  V(355) = V_USER(417)
  V(326) = V_USER(418)
  V(109) = V_USER(419)
  V(200) = V_USER(420)
  V(201) = V_USER(421)
  V(307) = V_USER(422)
  V(202) = V_USER(423)
  V(43) = V_USER(424)
  V(75) = V_USER(425)
  V(204) = V_USER(426)
  V(270) = V_USER(427)
  V(205) = V_USER(428)
  V(272) = V_USER(429)
  V(506) = V_USER(430)
  V(44) = V_USER(431)
  V(404) = V_USER(432)
  V(444) = V_USER(433)
  V(134) = V_USER(434)
  V(475) = V_USER(435)
  V(566) = V_USER(436)
  V(135) = V_USER(437)
  V(207) = V_USER(438)
  V(273) = V_USER(439)
  V(111) = V_USER(440)
  V(208) = V_USER(441)
  V(321) = V_USER(442)
  V(209) = V_USER(443)
  V(136) = V_USER(444)
  V(210) = V_USER(445)
  V(505) = V_USER(446)
  V(395) = V_USER(447)
  V(45) = V_USER(448)
  V(322) = V_USER(449)
  V(275) = V_USER(450)
  V(276) = V_USER(451)
  V(571) = V_USER(452)
  V(137) = V_USER(453)
  V(468) = V_USER(454)
  V(524) = V_USER(455)
  V(211) = V_USER(456)
  V(138) = V_USER(457)
  V(212) = V_USER(458)
  V(213) = V_USER(459)
  V(280) = V_USER(460)
  V(430) = V_USER(461)
  V(451) = V_USER(462)
  V(515) = V_USER(463)
  V(214) = V_USER(464)
  V(215) = V_USER(465)
  V(431) = V_USER(466)
  V(528) = V_USER(467)
  V(348) = V_USER(468)
  V(216) = V_USER(469)
  V(217) = V_USER(470)
  V(76) = V_USER(471)
  V(516) = V_USER(472)
  V(428) = V_USER(473)
  V(471) = V_USER(474)
  V(112) = V_USER(475)
  V(408) = V_USER(476)
  V(77) = V_USER(477)
  V(487) = V_USER(478)
  V(282) = V_USER(479)
  V(219) = V_USER(480)
  V(433) = V_USER(481)
  V(502) = V_USER(482)
  V(46) = V_USER(483)
  V(504) = V_USER(484)
  V(220) = V_USER(485)
  V(484) = V_USER(486)
  V(221) = V_USER(487)
  V(113) = V_USER(488)
  V(382) = V_USER(489)
  V(494) = V_USER(490)
  V(47) = V_USER(491)
  V(284) = V_USER(492)
  V(534) = V_USER(493)
  V(48) = V_USER(494)
  V(492) = V_USER(495)
  V(511) = V_USER(496)
  V(285) = V_USER(497)
  V(223) = V_USER(498)
  V(286) = V_USER(499)
  V(568) = V_USER(500)
  V(325) = V_USER(501)
  V(287) = V_USER(502)
  V(288) = V_USER(503)
  V(337) = V_USER(504)
  V(405) = V_USER(505)
  V(78) = V_USER(506)
  V(289) = V_USER(507)
  V(445) = V_USER(508)
  V(308) = V_USER(509)
  V(309) = V_USER(510)
  V(418) = V_USER(511)
  V(406) = V_USER(512)
  V(49) = V_USER(513)
  V(151) = V_USER(514)
  V(338) = V_USER(515)
  V(114) = V_USER(516)
  V(545) = V_USER(517)
  V(79) = V_USER(518)
  V(436) = V_USER(519)
  V(291) = V_USER(520)
  V(437) = V_USER(521)
  V(292) = V_USER(522)
  V(380) = V_USER(523)
  V(479) = V_USER(524)
  V(456) = V_USER(525)
  V(438) = V_USER(526)
  V(328) = V_USER(527)
  V(226) = V_USER(528)
  V(227) = V_USER(529)
  V(293) = V_USER(530)
  V(398) = V_USER(531)
  V(116) = V_USER(532)
  V(228) = V_USER(533)
  V(329) = V_USER(534)
  V(563) = V_USER(535)
  V(460) = V_USER(536)
  V(375) = V_USER(537)
  V(229) = V_USER(538)
  V(117) = V_USER(539)
  V(556) = V_USER(540)
  V(118) = V_USER(541)
  V(529) = V_USER(542)
  V(330) = V_USER(543)
  V(538) = V_USER(544)
  V(80) = V_USER(545)
  V(295) = V_USER(546)
  V(296) = V_USER(547)
  V(371) = V_USER(548)
  V(119) = V_USER(549)
  V(298) = V_USER(550)
  V(385) = V_USER(551)
  V(331) = V_USER(552)
  V(447) = V_USER(553)
  V(339) = V_USER(554)
  V(381) = V_USER(555)
  V(332) = V_USER(556)
  V(368) = V_USER(557)
  V(11) = V_USER(558)
  V(22) = V_USER(559)
  V(50) = V_USER(560)
  V(121) = V_USER(561)
  V(12) = V_USER(562)
  V(9) = V_USER(563)
  V(10) = V_USER(566)
  V(1) = V_USER(567)
  V(2) = V_USER(568)
  V(3) = V_USER(569)
  V(4) = V_USER(570)
      
END SUBROUTINE Shuffle_user2kpp

! End of Shuffle_user2kpp function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Shuffle_kpp2user - function to restore concentrations from KPP to USER
!   Arguments :
!      V         - Concentrations of variable species (local)
!      V_USER    - Concentration of variable species in USER's order
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE Shuffle_kpp2user ( V, V_USER )

! V - Concentrations of variable species (local)
  REAL(kind=dp) :: V(NVAR)
! V_USER - Concentration of variable species in USER's order
  REAL(kind=dp) :: V_USER(NVAR)

  V_USER(1) = V(301)
  V_USER(2) = V(360)
  V_USER(3) = V(139)
  V_USER(4) = V(303)
  V_USER(5) = V(304)
  V_USER(6) = V(341)
  V_USER(7) = V(525)
  V_USER(8) = V(439)
  V_USER(9) = V(414)
  V_USER(10) = V(305)
  V_USER(11) = V(299)
  V_USER(12) = V(122)
  V_USER(13) = V(145)
  V_USER(14) = V(166)
  V_USER(15) = V(377)
  V_USER(16) = V(55)
  V_USER(17) = V(86)
  V_USER(18) = V(33)
  V_USER(19) = V(419)
  V_USER(20) = V(498)
  V_USER(21) = V(196)
  V_USER(22) = V(231)
  V_USER(23) = V(87)
  V_USER(24) = V(203)
  V_USER(25) = V(490)
  V_USER(26) = V(225)
  V_USER(27) = V(340)
  V_USER(28) = V(314)
  V_USER(29) = V(264)
  V_USER(30) = V(61)
  V_USER(31) = V(429)
  V_USER(32) = V(463)
  V_USER(33) = V(127)
  V_USER(34) = V(163)
  V_USER(35) = V(128)
  V_USER(36) = V(390)
  V_USER(37) = V(182)
  V_USER(38) = V(69)
  V_USER(39) = V(345)
  V_USER(40) = V(73)
  V_USER(41) = V(192)
  V_USER(42) = V(108)
  V_USER(43) = V(110)
  V_USER(44) = V(133)
  V_USER(45) = V(347)
  V_USER(46) = V(283)
  V_USER(47) = V(564)
  V_USER(48) = V(567)
  V_USER(49) = V(357)
  V_USER(50) = V(120)
  V_USER(51) = V(402)
  V_USER(52) = V(391)
  V_USER(53) = V(51)
  V_USER(54) = V(160)
  V_USER(55) = V(266)
  V_USER(56) = V(253)
  V_USER(57) = V(191)
  V_USER(58) = V(470)
  V_USER(59) = V(440)
  V_USER(60) = V(23)
  V_USER(61) = V(459)
  V_USER(62) = V(319)
  V_USER(63) = V(562)
  V_USER(64) = V(130)
  V_USER(65) = V(170)
  V_USER(66) = V(491)
  V_USER(67) = V(365)
  V_USER(68) = V(478)
  V_USER(69) = V(184)
  V_USER(70) = V(343)
  V_USER(71) = V(263)
  V_USER(72) = V(354)
  V_USER(73) = V(52)
  V_USER(74) = V(194)
  V_USER(75) = V(24)
  V_USER(76) = V(235)
  V_USER(77) = V(549)
  V_USER(78) = V(224)
  V_USER(79) = V(115)
  V_USER(80) = V(230)
  V_USER(81) = V(15)
  V_USER(82) = V(327)
  V_USER(83) = V(403)
  V_USER(84) = V(237)
  V_USER(85) = V(250)
  V_USER(86) = V(497)
  V_USER(87) = V(53)
  V_USER(88) = V(279)
  V_USER(89) = V(54)
  V_USER(90) = V(161)
  V_USER(91) = V(232)
  V_USER(92) = V(240)
  V_USER(93) = V(241)
  V_USER(94) = V(530)
  V_USER(95) = V(569)
  V_USER(96) = V(129)
  V_USER(97) = V(543)
  V_USER(98) = V(336)
  V_USER(99) = V(399)
  V_USER(100) = V(482)
  V_USER(101) = V(25)
  V_USER(102) = V(180)
  V_USER(103) = V(181)
  V_USER(104) = V(359)
  V_USER(105) = V(315)
  V_USER(106) = V(560)
  V_USER(107) = V(450)
  V_USER(108) = V(16)
  V_USER(109) = V(199)
  V_USER(110) = V(388)
  V_USER(111) = V(449)
  V_USER(112) = V(218)
  V_USER(113) = V(222)
  V_USER(114) = V(26)
  V_USER(115) = V(290)
  V_USER(116) = V(294)
  V_USER(117) = V(367)
  V_USER(118) = V(421)
  V_USER(119) = V(297)
  V_USER(120) = V(333)
  V_USER(121) = V(300)
  V_USER(122) = V(27)
  V_USER(123) = V(140)
  V_USER(124) = V(374)
  V_USER(125) = V(480)
  V_USER(126) = V(443)
  V_USER(127) = V(162)
  V_USER(128) = V(522)
  V_USER(129) = V(323)
  V_USER(130) = V(247)
  V_USER(131) = V(56)
  V_USER(132) = V(57)
  V_USER(133) = V(369)
  V_USER(134) = V(81)
  V_USER(135) = V(206)
  V_USER(136) = V(452)
  V_USER(137) = V(277)
  V_USER(138) = V(234)
  V_USER(139) = V(302)
  V_USER(140) = V(544)
  V_USER(141) = V(466)
  V_USER(142) = V(507)
  V_USER(143) = V(123)
  V_USER(144) = V(249)
  V_USER(145) = V(82)
  V_USER(146) = V(448)
  V_USER(147) = V(262)
  V_USER(148) = V(372)
  V_USER(149) = V(269)
  V_USER(150) = V(271)
  V_USER(151) = V(493)
  V_USER(152) = V(124)
  V_USER(153) = V(141)
  V_USER(154) = V(363)
  V_USER(155) = V(281)
  V_USER(156) = V(551)
  V_USER(157) = V(142)
  V_USER(158) = V(500)
  V_USER(159) = V(469)
  V_USER(160) = V(143)
  V_USER(161) = V(83)
  V_USER(162) = V(532)
  V_USER(163) = V(84)
  V_USER(164) = V(434)
  V_USER(165) = V(512)
  V_USER(166) = V(432)
  V_USER(167) = V(455)
  V_USER(168) = V(523)
  V_USER(169) = V(383)
  V_USER(170) = V(495)
  V_USER(171) = V(144)
  V_USER(172) = V(483)
  V_USER(173) = V(85)
  V_USER(174) = V(540)
  V_USER(175) = V(370)
  V_USER(176) = V(13)
  V_USER(177) = V(426)
  V_USER(178) = V(17)
  V_USER(179) = V(252)
  V_USER(180) = V(312)
  V_USER(181) = V(413)
  V_USER(182) = V(28)
  V_USER(183) = V(555)
  V_USER(184) = V(425)
  V_USER(185) = V(417)
  V_USER(186) = V(361)
  V_USER(187) = V(552)
  V_USER(188) = V(393)
  V_USER(189) = V(146)
  V_USER(190) = V(147)
  V_USER(191) = V(148)
  V_USER(192) = V(29)
  V_USER(193) = V(373)
  V_USER(194) = V(558)
  V_USER(195) = V(346)
  V_USER(196) = V(362)
  V_USER(197) = V(58)
  V_USER(198) = V(59)
  V_USER(199) = V(268)
  V_USER(200) = V(60)
  V_USER(201) = V(356)
  V_USER(202) = V(149)
  V_USER(203) = V(465)
  V_USER(204) = V(125)
  V_USER(205) = V(150)
  V_USER(206) = V(394)
  V_USER(207) = V(152)
  V_USER(208) = V(153)
  V_USER(209) = V(274)
  V_USER(210) = V(496)
  V_USER(211) = V(278)
  V_USER(212) = V(154)
  V_USER(213) = V(364)
  V_USER(214) = V(427)
  V_USER(215) = V(155)
  V_USER(216) = V(156)
  V_USER(217) = V(520)
  V_USER(218) = V(126)
  V_USER(219) = V(324)
  V_USER(220) = V(508)
  V_USER(221) = V(499)
  V_USER(222) = V(157)
  V_USER(223) = V(158)
  V_USER(224) = V(366)
  V_USER(225) = V(379)
  V_USER(226) = V(457)
  V_USER(227) = V(458)
  V_USER(228) = V(30)
  V_USER(229) = V(407)
  V_USER(230) = V(31)
  V_USER(231) = V(159)
  V_USER(232) = V(32)
  V_USER(233) = V(472)
  V_USER(234) = V(88)
  V_USER(235) = V(527)
  V_USER(236) = V(62)
  V_USER(237) = V(334)
  V_USER(238) = V(89)
  V_USER(239) = V(535)
  V_USER(240) = V(236)
  V_USER(241) = V(547)
  V_USER(242) = V(550)
  V_USER(243) = V(90)
  V_USER(244) = V(378)
  V_USER(245) = V(464)
  V_USER(246) = V(474)
  V_USER(247) = V(349)
  V_USER(248) = V(533)
  V_USER(249) = V(386)
  V_USER(250) = V(91)
  V_USER(251) = V(18)
  V_USER(252) = V(311)
  V_USER(253) = V(34)
  V_USER(254) = V(238)
  V_USER(255) = V(415)
  V_USER(256) = V(239)
  V_USER(257) = V(63)
  V_USER(258) = V(461)
  V_USER(259) = V(351)
  V_USER(260) = V(352)
  V_USER(261) = V(489)
  V_USER(262) = V(92)
  V_USER(263) = V(477)
  V_USER(264) = V(422)
  V_USER(265) = V(488)
  V_USER(266) = V(164)
  V_USER(267) = V(93)
  V_USER(268) = V(392)
  V_USER(269) = V(94)
  V_USER(270) = V(242)
  V_USER(271) = V(35)
  V_USER(272) = V(243)
  V_USER(273) = V(165)
  V_USER(274) = V(95)
  V_USER(275) = V(96)
  V_USER(276) = V(97)
  V_USER(277) = V(513)
  V_USER(278) = V(244)
  V_USER(279) = V(245)
  V_USER(280) = V(396)
  V_USER(281) = V(542)
  V_USER(282) = V(14)
  V_USER(283) = V(518)
  V_USER(284) = V(454)
  V_USER(285) = V(561)
  V_USER(286) = V(246)
  V_USER(287) = V(167)
  V_USER(288) = V(98)
  V_USER(289) = V(168)
  V_USER(290) = V(19)
  V_USER(291) = V(169)
  V_USER(292) = V(384)
  V_USER(293) = V(412)
  V_USER(294) = V(64)
  V_USER(295) = V(376)
  V_USER(296) = V(99)
  V_USER(297) = V(65)
  V_USER(298) = V(248)
  V_USER(299) = V(66)
  V_USER(300) = V(171)
  V_USER(301) = V(172)
  V_USER(302) = V(173)
  V_USER(303) = V(389)
  V_USER(304) = V(36)
  V_USER(305) = V(503)
  V_USER(306) = V(501)
  V_USER(307) = V(174)
  V_USER(308) = V(175)
  V_USER(309) = V(176)
  V_USER(310) = V(486)
  V_USER(311) = V(462)
  V_USER(312) = V(358)
  V_USER(313) = V(100)
  V_USER(314) = V(539)
  V_USER(315) = V(517)
  V_USER(316) = V(342)
  V_USER(317) = V(251)
  V_USER(318) = V(526)
  V_USER(319) = V(541)
  V_USER(320) = V(177)
  V_USER(321) = V(178)
  V_USER(322) = V(519)
  V_USER(323) = V(548)
  V_USER(324) = V(67)
  V_USER(325) = V(485)
  V_USER(326) = V(310)
  V_USER(327) = V(411)
  V_USER(328) = V(557)
  V_USER(329) = V(481)
  V_USER(330) = V(510)
  V_USER(331) = V(101)
  V_USER(332) = V(531)
  V_USER(333) = V(179)
  V_USER(334) = V(476)
  V_USER(335) = V(353)
  V_USER(336) = V(68)
  V_USER(337) = V(416)
  V_USER(338) = V(102)
  V_USER(339) = V(554)
  V_USER(340) = V(387)
  V_USER(341) = V(424)
  V_USER(342) = V(313)
  V_USER(343) = V(131)
  V_USER(344) = V(435)
  V_USER(345) = V(103)
  V_USER(346) = V(254)
  V_USER(347) = V(255)
  V_USER(348) = V(256)
  V_USER(349) = V(104)
  V_USER(350) = V(37)
  V_USER(351) = V(397)
  V_USER(352) = V(514)
  V_USER(353) = V(423)
  V_USER(354) = V(473)
  V_USER(355) = V(409)
  V_USER(356) = V(105)
  V_USER(357) = V(233)
  V_USER(358) = V(509)
  V_USER(359) = V(257)
  V_USER(360) = V(521)
  V_USER(361) = V(420)
  V_USER(362) = V(183)
  V_USER(363) = V(38)
  V_USER(364) = V(306)
  V_USER(365) = V(467)
  V_USER(366) = V(185)
  V_USER(367) = V(186)
  V_USER(368) = V(316)
  V_USER(369) = V(350)
  V_USER(370) = V(70)
  V_USER(371) = V(400)
  V_USER(372) = V(546)
  V_USER(373) = V(536)
  V_USER(374) = V(187)
  V_USER(375) = V(537)
  V_USER(376) = V(258)
  V_USER(377) = V(188)
  V_USER(378) = V(570)
  V_USER(379) = V(344)
  V_USER(380) = V(259)
  V_USER(381) = V(317)
  V_USER(382) = V(453)
  V_USER(383) = V(260)
  V_USER(384) = V(261)
  V_USER(385) = V(335)
  V_USER(386) = V(189)
  V_USER(387) = V(318)
  V_USER(388) = V(190)
  V_USER(389) = V(39)
  V_USER(390) = V(132)
  V_USER(391) = V(410)
  V_USER(392) = V(71)
  V_USER(393) = V(106)
  V_USER(394) = V(72)
  V_USER(395) = V(40)
  V_USER(396) = V(320)
  V_USER(397) = V(107)
  V_USER(398) = V(559)
  V_USER(399) = V(41)
  V_USER(400) = V(20)
  V_USER(401) = V(401)
  V_USER(402) = V(265)
  V_USER(403) = V(441)
  V_USER(404) = V(193)
  V_USER(405) = V(42)
  V_USER(406) = V(446)
  V_USER(407) = V(267)
  V_USER(408) = V(74)
  V_USER(409) = V(195)
  V_USER(410) = V(21)
  V_USER(411) = V(553)
  V_USER(412) = V(8)
  V_USER(413) = V(565)
  V_USER(414) = V(197)
  V_USER(415) = V(198)
  V_USER(416) = V(442)
  V_USER(417) = V(355)
  V_USER(418) = V(326)
  V_USER(419) = V(109)
  V_USER(420) = V(200)
  V_USER(421) = V(201)
  V_USER(422) = V(307)
  V_USER(423) = V(202)
  V_USER(424) = V(43)
  V_USER(425) = V(75)
  V_USER(426) = V(204)
  V_USER(427) = V(270)
  V_USER(428) = V(205)
  V_USER(429) = V(272)
  V_USER(430) = V(506)
  V_USER(431) = V(44)
  V_USER(432) = V(404)
  V_USER(433) = V(444)
  V_USER(434) = V(134)
  V_USER(435) = V(475)
  V_USER(436) = V(566)
  V_USER(437) = V(135)
  V_USER(438) = V(207)
  V_USER(439) = V(273)
  V_USER(440) = V(111)
  V_USER(441) = V(208)
  V_USER(442) = V(321)
  V_USER(443) = V(209)
  V_USER(444) = V(136)
  V_USER(445) = V(210)
  V_USER(446) = V(505)
  V_USER(447) = V(395)
  V_USER(448) = V(45)
  V_USER(449) = V(322)
  V_USER(450) = V(275)
  V_USER(451) = V(276)
  V_USER(452) = V(571)
  V_USER(453) = V(137)
  V_USER(454) = V(468)
  V_USER(455) = V(524)
  V_USER(456) = V(211)
  V_USER(457) = V(138)
  V_USER(458) = V(212)
  V_USER(459) = V(213)
  V_USER(460) = V(280)
  V_USER(461) = V(430)
  V_USER(462) = V(451)
  V_USER(463) = V(515)
  V_USER(464) = V(214)
  V_USER(465) = V(215)
  V_USER(466) = V(431)
  V_USER(467) = V(528)
  V_USER(468) = V(348)
  V_USER(469) = V(216)
  V_USER(470) = V(217)
  V_USER(471) = V(76)
  V_USER(472) = V(516)
  V_USER(473) = V(428)
  V_USER(474) = V(471)
  V_USER(475) = V(112)
  V_USER(476) = V(408)
  V_USER(477) = V(77)
  V_USER(478) = V(487)
  V_USER(479) = V(282)
  V_USER(480) = V(219)
  V_USER(481) = V(433)
  V_USER(482) = V(502)
  V_USER(483) = V(46)
  V_USER(484) = V(504)
  V_USER(485) = V(220)
  V_USER(486) = V(484)
  V_USER(487) = V(221)
  V_USER(488) = V(113)
  V_USER(489) = V(382)
  V_USER(490) = V(494)
  V_USER(491) = V(47)
  V_USER(492) = V(284)
  V_USER(493) = V(534)
  V_USER(494) = V(48)
  V_USER(495) = V(492)
  V_USER(496) = V(511)
  V_USER(497) = V(285)
  V_USER(498) = V(223)
  V_USER(499) = V(286)
  V_USER(500) = V(568)
  V_USER(501) = V(325)
  V_USER(502) = V(287)
  V_USER(503) = V(288)
  V_USER(504) = V(337)
  V_USER(505) = V(405)
  V_USER(506) = V(78)
  V_USER(507) = V(289)
  V_USER(508) = V(445)
  V_USER(509) = V(308)
  V_USER(510) = V(309)
  V_USER(511) = V(418)
  V_USER(512) = V(406)
  V_USER(513) = V(49)
  V_USER(514) = V(151)
  V_USER(515) = V(338)
  V_USER(516) = V(114)
  V_USER(517) = V(545)
  V_USER(518) = V(79)
  V_USER(519) = V(436)
  V_USER(520) = V(291)
  V_USER(521) = V(437)
  V_USER(522) = V(292)
  V_USER(523) = V(380)
  V_USER(524) = V(479)
  V_USER(525) = V(456)
  V_USER(526) = V(438)
  V_USER(527) = V(328)
  V_USER(528) = V(226)
  V_USER(529) = V(227)
  V_USER(530) = V(293)
  V_USER(531) = V(398)
  V_USER(532) = V(116)
  V_USER(533) = V(228)
  V_USER(534) = V(329)
  V_USER(535) = V(563)
  V_USER(536) = V(460)
  V_USER(537) = V(375)
  V_USER(538) = V(229)
  V_USER(539) = V(117)
  V_USER(540) = V(556)
  V_USER(541) = V(118)
  V_USER(542) = V(529)
  V_USER(543) = V(330)
  V_USER(544) = V(538)
  V_USER(545) = V(80)
  V_USER(546) = V(295)
  V_USER(547) = V(296)
  V_USER(548) = V(371)
  V_USER(549) = V(119)
  V_USER(550) = V(298)
  V_USER(551) = V(385)
  V_USER(552) = V(331)
  V_USER(553) = V(447)
  V_USER(554) = V(339)
  V_USER(555) = V(381)
  V_USER(556) = V(332)
  V_USER(557) = V(368)
  V_USER(558) = V(11)
  V_USER(559) = V(22)
  V_USER(560) = V(50)
  V_USER(561) = V(121)
  V_USER(562) = V(12)
  V_USER(563) = V(9)
  V_USER(566) = V(10)
  V_USER(567) = V(1)
  V_USER(568) = V(2)
  V_USER(569) = V(3)
  V_USER(570) = V(4)
      
END SUBROUTINE Shuffle_kpp2user

! End of Shuffle_kpp2user function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! GetMass - compute total mass of selected atoms
!   Arguments :
!      CL        - Concentration of all species (local)
!      Mass      - value of mass balance
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE GetMass ( CL, Mass )

! CL - Concentration of all species (local)
  REAL(kind=dp) :: CL(NSPEC)
! Mass - value of mass balance
  REAL(kind=dp) :: Mass(1)

      
END SUBROUTINE GetMass

! End of GetMass function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



END MODULE model_Util

