! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! The Reaction Rates File
! 
! Generated by KPP-2.2.3 symbolic chemistry Kinetics PreProcessor
!       (http://www.cs.vt.edu/~asandu/Software/KPP)
! KPP is distributed under GPL, the general public licence
!       (http://www.gnu.org/copyleft/gpl.html)
! (C) 1995-1997, V. Damian & A. Sandu, CGRER, Univ. Iowa
! (C) 1997-2005, A. Sandu, Michigan Tech, Virginia Tech
!     With important contributions from:
!        M. Damian, Villanova University, USA
!        R. Sander, Max-Planck Institute for Chemistry, Mainz, Germany
! 
! File                 : model_Rates.f90
! Time                 : Wed Oct 28 11:54:56 2015
! Working directory    : /work/home/mje516/DSMACC_teaching
! Equation file        : model.kpp
! Output root filename : model
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



MODULE model_Rates

  USE model_Parameters
  USE model_Global
  IMPLICIT NONE

CONTAINS



! Begin Rate Law Functions from KPP_HOME/util/UserRateLaws

!~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!  User-defined Rate Law functions
!  Note: the default argument type for rate laws, as read from the equations file, is single precision
!        but all the internal calculations are performed in double precision
!~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

!~~~>  Arrhenius
   REAL(kind=dp) FUNCTION ARR( A0,B0,C0 )
      REAL A0,B0,C0      
      ARR =  DBLE(A0) * EXP(-DBLE(B0)/TEMP) * (TEMP/300.0_dp)**DBLE(C0)
   END FUNCTION ARR        

!~~~> Simplified Arrhenius, with two arguments
!~~~> Note: The argument B0 has a changed sign when compared to ARR
   REAL(kind=dp) FUNCTION ARR2( A0,B0 )
      REAL A0,B0           
      ARR2 =  DBLE(A0) * EXP( DBLE(B0)/TEMP )              
   END FUNCTION ARR2          

   REAL(kind=dp) FUNCTION EP2(A0,C0,A2,C2,A3,C3)
      REAL A0,C0,A2,C2,A3,C3
      REAL(kind=dp) K0,K2,K3            
      K0 = DBLE(A0) * EXP(-DBLE(C0)/TEMP)
      K2 = DBLE(A2) * EXP(-DBLE(C2)/TEMP)
      K3 = DBLE(A3) * EXP(-DBLE(C3)/TEMP)
      K3 = K3*CFACTOR*1.0E6_dp
      EP2 = K0 + K3/(1.0_dp+K3/K2 )
   END FUNCTION EP2

   REAL(kind=dp) FUNCTION EP3(A1,C1,A2,C2) 
      REAL A1, C1, A2, C2
      REAL(kind=dp) K1, K2      
      K1 = DBLE(A1) * EXP(-DBLE(C1)/TEMP)
      K2 = DBLE(A2) * EXP(-DBLE(C2)/TEMP)
      EP3 = K1 + K2*(1.0E6_dp*CFACTOR)
   END FUNCTION EP3 

   REAL(kind=dp) FUNCTION FALL ( A0,B0,C0,A1,B1,C1,CF)
      REAL A0,B0,C0,A1,B1,C1,CF
      REAL(kind=dp) K0, K1     
      K0 = DBLE(A0) * EXP(-DBLE(B0)/TEMP)* (TEMP/300.0_dp)**DBLE(C0)
      K1 = DBLE(A1) * EXP(-DBLE(B1)/TEMP)* (TEMP/300.0_dp)**DBLE(C1)
      K0 = K0*CFACTOR*1.0E6_dp
      K1 = K0/K1
      FALL = (K0/(1.0_dp+K1))*   &
           DBLE(CF)**(1.0_dp/(1.0_dp+(LOG10(K1))**2))
   END FUNCTION FALL

  !---------------------------------------------------------------------------

  ELEMENTAL REAL(kind=dp) FUNCTION k_3rd(temp,cair,k0_300K,n,kinf_300K,m,fc)

    INTRINSIC LOG10

    REAL(kind=dp), INTENT(IN) :: temp      ! temperature [K]
    REAL(kind=dp), INTENT(IN) :: cair      ! air concentration [molecules/cm3]
    REAL, INTENT(IN) :: k0_300K   ! low pressure limit at 300 K
    REAL, INTENT(IN) :: n         ! exponent for low pressure limit
    REAL, INTENT(IN) :: kinf_300K ! high pressure limit at 300 K
    REAL, INTENT(IN) :: m         ! exponent for high pressure limit
    REAL, INTENT(IN) :: fc        ! broadening factor (usually fc=0.6)
    REAL(kind=dp) :: zt_help, k0_T, kinf_T, k_ratio

    zt_help = 300._dp/temp
    k0_T    = k0_300K   * zt_help**(n) * cair ! k_0   at current T
    kinf_T  = kinf_300K * zt_help**(m)        ! k_inf at current T
    k_ratio = k0_T/kinf_T
    k_3rd   = k0_T/(1._dp+k_ratio)*fc**(1._dp/(1._dp+LOG10(k_ratio)**2))

  END FUNCTION k_3rd

  !---------------------------------------------------------------------------

  ELEMENTAL REAL(kind=dp) FUNCTION k_arr (k_298,tdep,temp)
    ! Arrhenius function

    REAL,     INTENT(IN) :: k_298 ! k at T = 298.15K
    REAL,     INTENT(IN) :: tdep  ! temperature dependence
    REAL(kind=dp), INTENT(IN) :: temp  ! temperature

    INTRINSIC EXP

    k_arr = k_298 * EXP(tdep*(1._dp/temp-3.3540E-3_dp)) ! 1/298.15=3.3540e-3

  END FUNCTION k_arr

!~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!  End of User-defined Rate Law functions
!~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

! End Rate Law Functions from KPP_HOME/util/UserRateLaws


! Begin INLINED Rate Law Functions


! End INLINED Rate Law Functions

! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Update_SUN - update SUN light using TIME
!   Arguments :
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  SUBROUTINE Update_SUN()
      !USE model_Parameters
      !USE model_Global

    IMPLICIT NONE

    REAL(kind=dp) :: SunRise, SunSet
    REAL(kind=dp) :: Thour, Tlocal, Ttmp 
    ! PI - Value of pi
    REAL(kind=dp), PARAMETER :: PI = 3.14159265358979d0
    
    SunRise = 4.5_dp 
    SunSet  = 19.5_dp 
    Thour = TIME/3600.0_dp 
    Tlocal = Thour - (INT(Thour)/24)*24

    IF ((Tlocal>=SunRise).AND.(Tlocal<=SunSet)) THEN
       Ttmp = (2.0*Tlocal-SunRise-SunSet)/(SunSet-SunRise)
       IF (Ttmp.GT.0) THEN
          Ttmp =  Ttmp*Ttmp
       ELSE
          Ttmp = -Ttmp*Ttmp
       END IF
       SUN = ( 1.0_dp + COS(PI*Ttmp) )/2.0_dp 
    ELSE
       SUN = 0.0_dp 
    END IF

 END SUBROUTINE Update_SUN

! End of Update_SUN function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Update_RCONST - function to update rate constants
!   Arguments :
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE Update_RCONST ( )




! Begin INLINED RCONST

 
 USE constants
 !end of USE statements 
 !
 ! start of executable statements
 RO2 = & 
 C(ind_C2H5O2) + C(ind_IC3H7O2) + C(ind_NC3H7O2) + C(ind_NC4H9O2) + & 
   C(ind_SC4H9O2) + C(ind_PRONO3AO2) + C(ind_PRONO3BO2) + C(ind_HYPROPO2) &  
   + C(ind_IPROPOLO2) + C(ind_NISOPO2) + C(ind_ISOPAO2) + C(ind_ISOPBO2) &  
   + C(ind_ISOPCO2) + C(ind_ISOPDO2) + C(ind_CH3O2) + C(ind_CH3CO3) + &  
   C(ind_HCOCH2O2) + C(ind_CH3C2H2O2) + C(ind_MACO3) + C(ind_MACRO2) + &  
   C(ind_MACROHO2) + C(ind_HMVKAO2) + C(ind_HMVKBO2) + C(ind_MVKO2) + &  
   C(ind_HOCH2CH2O2) + C(ind_CH3COCH2O2) + C(ind_C2H5CO3) + &  
   C(ind_HO1C3O2) + C(ind_HO1C4O2) + C(ind_C3H7CO3) + C(ind_BUTALO2) + &  
   C(ind_NBUTOLAO2) + C(ind_NBUTOLBO2) + C(ind_BUT2OLO2) + C(ind_MEKAO2) &  
   + C(ind_MEKBO2) + C(ind_MEKCO2) + C(ind_PRNO3CO3) + C(ind_CH3CHOHCO3) &  
   + C(ind_INCO2) + C(ind_NC4CO3) + C(ind_C510O2) + C(ind_INAO2) + &  
   C(ind_C524O2) + C(ind_HC4ACO3) + C(ind_C58O2) + C(ind_INB1O2) + &  
   C(ind_INB2O2) + C(ind_HC4CCO3) + C(ind_C57O2) + C(ind_INDO2) + &  
   C(ind_HOCH2CO3) + C(ind_C59O2) + C(ind_ETHENO3O2) + C(ind_HCOCO3) + &  
   C(ind_CHOMOHCO3) + C(ind_CO2H3CO3) + C(ind_ACO3) + C(ind_MVKOHAO2) + &  
   C(ind_MVKOHBO2) + C(ind_NO3CH2CO3) + C(ind_IEB1O2) + C(ind_IEB2O2) + &  
   C(ind_MACRNCO3) + C(ind_IEC1O2) + C(ind_HOC2H4CO3) + C(ind_HOC3H6CO3) &  
   + C(ind_CO2C3CO3) + C(ind_HO2C3CO3) + C(ind_HO1CO3C4O2) + &  
   C(ind_BIACETO2) + C(ind_IPRHOCO3) + C(ind_IEACO3) + C(ind_NC524O2) + &  
   C(ind_C525O2) + C(ind_C58NO3CO3) + C(ind_CONM2CO3) + C(ind_IECCO3) + &  
   C(ind_CO2N3CO3) + C(ind_INCNCO3) + C(ind_MACRNBCO3) + C(ind_H13CO2CO3) &  
   + C(ind_ACO3B) + C(ind_OCCOHCO2) + C(ind_INAHPCO3) + C(ind_INANCO3) + &  
   C(ind_INAHCO3) + C(ind_HIEB1O2) + C(ind_HIEB2O2) + C(ind_HMACO3) + &  
   C(ind_HMACRO2) + C(ind_INB1HPCO3) + C(ind_INB1NACO3) + &  
   C(ind_INB1NBCO3) + C(ind_C57NO3CO3) + C(ind_INDHPCO3) + C(ind_INDHCO3) &  
   + C(ind_INANCOCO3) + C(ind_MMALNACO3) + C(ind_MMALNBCO3) + &  
   C(ind_A2PANOO) + C(ind_HCOCOHCO3) + C(ind_CH3COCO3) + C(ind_COHM2CO3) &  
   + C(ind_C3DIOLO2 ) 
 CALL mcm_constants(time, temp, M, N2, O2, RO2, H2O) 
 
! End INLINED RCONST

  RCONST(1) = (8.3D-11*EXP(-100/TEMP))
  RCONST(2) = (6.9D-12*EXP(-1000/TEMP))
  RCONST(3) = (1.4D-10*0.43*EXP(75/TEMP))
  RCONST(4) = (1.4D-10*0.59*EXP(-90/TEMP))
  RCONST(5) = (7.6D-12*EXP(-585/TEMP)*0.736)
  RCONST(6) = (7.6D-12*EXP(-585/TEMP)*0.264)
  RCONST(7) = (2.05D-10*0.44*EXP(-120/TEMP))
  RCONST(8) = (2.05D-10*0.59*EXP(55/TEMP))
  RCONST(9) = (9.8D-12*EXP(-425/TEMP)*0.127)
  RCONST(10) = (9.8D-12*EXP(-425/TEMP)*0.873)
  RCONST(11) = (4.6D-13*EXP(-1155/TEMP)*0.35)
  RCONST(12) = (4.6D-13*EXP(-1155/TEMP)*0.65)
  RCONST(13) = (5.5D-15*EXP(-1880/TEMP)*0.5)
  RCONST(14) = (5.5D-15*EXP(-1880/TEMP)*0.5)
  RCONST(15) = (KMT16*0.87)
  RCONST(16) = (KMT16*0.13)
  RCONST(17) = (3.15D-12*EXP(-450/TEMP))
  RCONST(18) = (1.03D-14*EXP(-1995/TEMP)*0.3)
  RCONST(19) = (1.03D-14*EXP(-1995/TEMP)*0.2)
  RCONST(20) = (1.03D-14*EXP(-1995/TEMP)*0.3)
  RCONST(21) = (1.03D-14*EXP(-1995/TEMP)*0.2)
  RCONST(22) = (2.7D-11*EXP(390/TEMP)*0.148)
  RCONST(23) = (2.7D-11*EXP(390/TEMP)*0.444)
  RCONST(24) = (2.7D-11*EXP(390/TEMP)*0.102)
  RCONST(25) = (2.7D-11*EXP(390/TEMP)*0.306)
  RCONST(26) = (4.3D-13*EXP(870/TEMP))
  RCONST(27) = (2.55D-12*EXP(380/TEMP)*0.009)
  RCONST(28) = (2.55D-12*EXP(380/TEMP)*0.991)
  RCONST(29) = (KRO2NO3)
  RCONST(30) = (2*(KCH3O2*6.4D-14*(TEMP/300)**0*EXP(0/TEMP))**0.5*RO2*0.6)
  RCONST(31) = (2*(KCH3O2*6.4D-14*(TEMP/300)**0*EXP(0/TEMP))**0.5*RO2*0.2)
  RCONST(32) = (2*(KCH3O2*6.4D-14*(TEMP/300)**0*EXP(0/TEMP))**0.5*RO2*0.2)
  RCONST(33) = (KRO2HO2*0.520)
  RCONST(34) = (2.7D-12*EXP(360/TEMP)*0.042)
  RCONST(35) = (2.7D-12*EXP(360/TEMP)*0.958)
  RCONST(36) = (KRO2NO3)
  RCONST(37) = (2*(KCH3O2*1.6D-12*EXP(-2200/TEMP))**0.5*RO2*0.2)
  RCONST(38) = (2*(KCH3O2*1.6D-12*EXP(-2200/TEMP))**0.5*RO2*0.6)
  RCONST(39) = (2*(KCH3O2*1.6D-12*EXP(-2200/TEMP))**0.5*RO2*0.2)
  RCONST(40) = (KRO2HO2*0.520)
  RCONST(41) = (2.9D-12*EXP(350/TEMP)*0.020)
  RCONST(42) = (2.9D-12*EXP(350/TEMP)*0.980)
  RCONST(43) = (KRO2NO3)
  RCONST(44) = (2*(K298CH3O2*3D-13)**0.5*RO2*0.2)
  RCONST(45) = (2*(K298CH3O2*3D-13)**0.5*RO2*0.6)
  RCONST(46) = (2*(K298CH3O2*3D-13)**0.5*RO2*0.2)
  RCONST(47) = (KRO2HO2*0.625)
  RCONST(48) = (KRO2NO*0.033)
  RCONST(49) = (KRO2NO*0.967)
  RCONST(50) = (KRO2NO3)
  RCONST(51) = (1.30D-12*0.2*RO2)
  RCONST(52) = (1.30D-12*0.2*RO2)
  RCONST(53) = (1.30D-12*0.6*RO2)
  RCONST(54) = (KRO2HO2*0.625)
  RCONST(55) = (KRO2NO*0.090)
  RCONST(56) = (KRO2NO*0.910)
  RCONST(57) = (KRO2NO3)
  RCONST(58) = (2.50D-13*0.2*RO2)
  RCONST(59) = (2.50D-13*0.2*RO2)
  RCONST(60) = (2.50D-13*0.6*RO2)
  RCONST(61) = (KRO2HO2*0.520)
  RCONST(62) = (KRO2NO)
  RCONST(63) = (KRO2NO3)
  RCONST(64) = (6.00D-13*0.2*RO2)
  RCONST(65) = (6.00D-13*0.6*RO2)
  RCONST(66) = (6.00D-13*0.2*RO2)
  RCONST(67) = (KRO2HO2*0.520)
  RCONST(68) = (KRO2NO)
  RCONST(69) = (KRO2NO3)
  RCONST(70) = (4.00D-14*0.2*RO2)
  RCONST(71) = (4.00D-14*0.2*RO2)
  RCONST(72) = (4.00D-14*0.6*RO2)
  RCONST(73) = (KDEC*0.24)
  RCONST(74) = (KDEC*0.40)
  RCONST(75) = (KDEC*0.36)
  RCONST(76) = (J(13))
  RCONST(77) = (1.4D-12*EXP(-1860/TEMP))
  RCONST(78) = (4.7D-12*EXP(345/TEMP)*0.95)
  RCONST(79) = (4.7D-12*EXP(345/TEMP)*0.05)
  RCONST(80) = (KDEC*0.24)
  RCONST(81) = (KDEC*0.36)
  RCONST(82) = (KDEC*0.20)
  RCONST(83) = (KDEC*0.20)
  RCONST(84) = (J(11))
  RCONST(85) = (J(12))
  RCONST(86) = (5.5D-16)
  RCONST(87) = (5.4D-12*EXP(135/TEMP))
  RCONST(88) = (KRO2HO2*0.520)
  RCONST(89) = (KRO2NO3)
  RCONST(90) = (8.80D-13*0.2*RO2)
  RCONST(91) = (8.80D-13*0.6*RO2)
  RCONST(92) = (8.80D-13*0.2*RO2)
  RCONST(93) = (KRO2NO*0.977)
  RCONST(94) = (KRO2NO*0.023)
  RCONST(95) = (KRO2HO2*0.520)
  RCONST(96) = (KRO2NO*0.991)
  RCONST(97) = (KRO2NO*0.009)
  RCONST(98) = (KRO2NO3)
  RCONST(99) = (2.00D-12*0.2*RO2)
  RCONST(100) = (2.00D-12*0.6*RO2)
  RCONST(101) = (2.00D-12*0.2*RO2)
  RCONST(102) = (KRO2HO2*0.706)
  RCONST(103) = (KRO2NO*0.052)
  RCONST(104) = (KRO2NO*0.948)
  RCONST(105) = (KRO2NO3)
  RCONST(106) = (1.30D-12*0.2*RO2)
  RCONST(107) = (1.30D-12*0.2*RO2)
  RCONST(108) = (1.30D-12*0.6*RO2)
  RCONST(109) = (KDEC*0.22)
  RCONST(110) = (KDEC*0.51)
  RCONST(111) = (KDEC*0.27)
  RCONST(112) = (J(18))
  RCONST(113) = (J(19))
  RCONST(114) = (3.4D-15)
  RCONST(115) = (1.4D-15*EXP(-2100/TEMP)*0.12)
  RCONST(116) = (1.4D-15*EXP(-2100/TEMP)*0.88)
  RCONST(117) = (8.0D-12*EXP(380/TEMP)*0.45)
  RCONST(118) = (8.0D-12*EXP(380/TEMP)*0.47)
  RCONST(119) = (8.0D-12*EXP(380/TEMP)*0.08)
  RCONST(120) = (J(23))
  RCONST(121) = (J(24))
  RCONST(122) = (8.5D-16*EXP(-1520/TEMP)*0.5)
  RCONST(123) = (8.5D-16*EXP(-1520/TEMP)*0.5)
  RCONST(124) = (2.6D-12*EXP(610/TEMP)*0.3)
  RCONST(125) = (2.6D-12*EXP(610/TEMP)*0.7)
  RCONST(126) = (KDEC*0.255)
  RCONST(127) = (KDEC*0.255)
  RCONST(128) = (KDEC*0.22)
  RCONST(129) = (KDEC*0.27)
  RCONST(130) = (KDEC*0.255)
  RCONST(131) = (KDEC*0.255)
  RCONST(132) = (KDEC*0.22)
  RCONST(133) = (KDEC*0.27)
  RCONST(134) = (KRO2HO2*0.706)
  RCONST(135) = (KRO2NO*0.100)
  RCONST(136) = (KRO2NO*0.900)
  RCONST(137) = (KRO2NO3)
  RCONST(138) = (2.40D-12*0.1*RO2)
  RCONST(139) = (2.40D-12*0.8*RO2)
  RCONST(140) = (2.40D-12*0.1*RO2)
  RCONST(141) = (KRO2HO2*0.706)
  RCONST(142) = (KRO2NO*0.066)
  RCONST(143) = (KRO2NO*0.934)
  RCONST(144) = (KRO2NO3)
  RCONST(145) = (8.00D-13*0.8*RO2)
  RCONST(146) = (8.00D-13*0.2*RO2)
  RCONST(147) = (KRO2HO2*0.706)
  RCONST(148) = (KRO2NO*0.100)
  RCONST(149) = (KRO2NO*0.900)
  RCONST(150) = (KRO2NO3)
  RCONST(151) = (2.00D-12*0.1*RO2)
  RCONST(152) = (2.00D-12*0.1*RO2)
  RCONST(153) = (2.00D-12*0.8*RO2)
  RCONST(154) = (KRO2HO2*0.706)
  RCONST(155) = (KRO2NO*0.134)
  RCONST(156) = (KRO2NO*0.866)
  RCONST(157) = (KRO2NO3)
  RCONST(158) = (2.90D-12*0.1*RO2)
  RCONST(159) = (2.90D-12*0.8*RO2)
  RCONST(160) = (2.90D-12*0.1*RO2)
  RCONST(161) = (J(41))
  RCONST(162) = (1.90D-12*EXP(190/TEMP))
  RCONST(163) = (8.01D-12)
  RCONST(164) = (J(52))
  RCONST(165) = (6.7D-13*EXP(-395/TEMP))
  RCONST(166) = (2.4D-14*EXP(-325/TEMP)*O2)
  RCONST(167) = (3.0D-12*EXP(20/TEMP)*0.05)
  RCONST(168) = (3.0D-12*EXP(20/TEMP)*0.9)
  RCONST(169) = (3.0D-12*EXP(20/TEMP)*0.05)
  RCONST(170) = (J(41))
  RCONST(171) = (1.66D-11)
  RCONST(172) = (1.90D-12*EXP(190/TEMP))
  RCONST(173) = (J(54))
  RCONST(174) = (6.2D-13*EXP(-230/TEMP))
  RCONST(175) = (1.5D-14*EXP(-230/TEMP)*O2)
  RCONST(176) = (8.8D-12*EXP(-1320/TEMP)+1.7D-14*EXP(423/TEMP))
  RCONST(177) = (J(21))
  RCONST(178) = (2.6D-12*EXP(200/TEMP)*0.861)
  RCONST(179) = (2.6D-12*EXP(200/TEMP)*0.139)
  RCONST(180) = (J(41))
  RCONST(181) = (1.10D-11)
  RCONST(182) = (1.90D-12*EXP(190/TEMP))
  RCONST(183) = (J(53))
  RCONST(184) = (5.8D-13)
  RCONST(185) = (2.6D-14*EXP(-255/TEMP)*O2)
  RCONST(186) = (3.24D-12*EXP(-1860/TEMP))
  RCONST(187) = (4.9D-12*EXP(405/TEMP))
  RCONST(188) = (J(14))
  RCONST(189) = (4.6D-12*EXP(70/TEMP)*0.494)
  RCONST(190) = (4.6D-12*EXP(70/TEMP)*0.063)
  RCONST(191) = (4.6D-12*EXP(70/TEMP)*0.443)
  RCONST(192) = (J(41))
  RCONST(193) = (1.24D-11)
  RCONST(194) = (1.90D-12*EXP(190/TEMP))
  RCONST(195) = (J(53))
  RCONST(196) = (1.6D-12)
  RCONST(197) = (8.9D-14*EXP(-550/TEMP)*O2)
  RCONST(198) = (4.6D10*EXP(-3570/TEMP))
  RCONST(199) = (1.7D-12*EXP(-1500/TEMP))
  RCONST(200) = (6.0D-12*EXP(410/TEMP)*0.151)
  RCONST(201) = (6.0D-12*EXP(410/TEMP)*0.849)
  RCONST(202) = (J(16))
  RCONST(203) = (J(15))
  RCONST(204) = (5.3D-12*EXP(140/TEMP)*0.358)
  RCONST(205) = (5.3D-12*EXP(140/TEMP)*0.321)
  RCONST(206) = (5.3D-12*EXP(140/TEMP)*0.321)
  RCONST(207) = (2.15D-11)
  RCONST(208) = (1.90D-12*EXP(190/TEMP))
  RCONST(209) = (J(41))
  RCONST(210) = (8.6D-13)
  RCONST(211) = (J(54))
  RCONST(212) = (5.6D12*EXP(-5780/TEMP))
  RCONST(213) = (1.5D-14*EXP(-200/TEMP)*O2)
  RCONST(214) = (8.7D-12*0.361)
  RCONST(215) = (8.7D-12*0.639)
  RCONST(216) = (1.5D-12*EXP(-90/TEMP)*0.459)
  RCONST(217) = (1.5D-12*EXP(-90/TEMP)*0.462)
  RCONST(218) = (1.5D-12*EXP(-90/TEMP)*0.079)
  RCONST(219) = (J(22))
  RCONST(220) = (1.69D-12)
  RCONST(221) = (1.90D-12*EXP(190/TEMP))
  RCONST(222) = (J(41))
  RCONST(223) = (KROPRIM*O2)
  RCONST(224) = (7.00D+03)
  RCONST(225) = (KNO3AL*2.4)
  RCONST(226) = (3.55D-12)
  RCONST(227) = (J(57))
  RCONST(228) = (J(56))
  RCONST(229) = (9.16D-13)
  RCONST(230) = (3.47D-12)
  RCONST(231) = (1.90D-12*EXP(190/TEMP))
  RCONST(232) = (J(41))
  RCONST(233) = (7.00D+03)
  RCONST(234) = (KROSEC*O2)
  RCONST(235) = (1D-12)
  RCONST(236) = (J(57))
  RCONST(237) = (J(56))
  RCONST(238) = (1.71D-12)
  RCONST(239) = (1.20D-15)
  RCONST(240) = (1.00D-14)
  RCONST(241) = (1.00D-15)
  RCONST(242) = (7.00D-14)
  RCONST(243) = (6.00D-18*H2O)
  RCONST(244) = (1.00D-17*H2O)
  RCONST(245) = (3.8D-13*EXP(780/TEMP)*(1-1/(1+498*EXP(-1160/TEMP))))
  RCONST(246) = (3.8D-13*EXP(780/TEMP)*(1/(1+498*EXP(-1160/TEMP))))
  RCONST(247) = (2.3D-12*EXP(360/TEMP)*0.001)
  RCONST(248) = (2.3D-12*EXP(360/TEMP)*0.999)
  RCONST(249) = (KMT13)
  RCONST(250) = (1.2D-12)
  RCONST(251) = (2*KCH3O2*RO2*7.18*EXP(-885/TEMP))
  RCONST(252) = (2*KCH3O2*RO2*0.5*(1-7.18*EXP(-885/TEMP)))
  RCONST(253) = (2*KCH3O2*RO2*0.5*(1-7.18*EXP(-885/TEMP)))
  RCONST(254) = (KAPHO2*0.15)
  RCONST(255) = (KAPHO2*0.41)
  RCONST(256) = (KAPHO2*0.44)
  RCONST(257) = (7.5D-12*EXP(290/TEMP))
  RCONST(258) = (KFPAN)
  RCONST(259) = (4.0D-12)
  RCONST(260) = (2*(K298CH3O2*2.9D-12*EXP(500/TEMP))**0.5*RO2*0.3)
  RCONST(261) = (2*(K298CH3O2*2.9D-12*EXP(500/TEMP))**0.5*RO2*0.7)
  RCONST(262) = (KRO2HO2*0.387)
  RCONST(263) = (KRO2NO)
  RCONST(264) = (KRO2NO3)
  RCONST(265) = (2.00D-12*0.2*RO2)
  RCONST(266) = (2.00D-12*0.6*RO2)
  RCONST(267) = (2.00D-12*0.2*RO2)
  RCONST(268) = (1.20D-15)
  RCONST(269) = (1.00D-14)
  RCONST(270) = (1.00D-15)
  RCONST(271) = (7.00D-14)
  RCONST(272) = (6.00D-18*H2O)
  RCONST(273) = (1.00D-17*H2O)
  RCONST(274) = (6.6D-12*EXP(-1240/TEMP))
  RCONST(275) = (1.85D-12*EXP(-1690/TEMP))
  RCONST(276) = (2.44D-11)
  RCONST(277) = (1.90D-12*EXP(190/TEMP))
  RCONST(278) = (J(41))
  RCONST(279) = (2.00D+14*EXP(-6410/TEMP))
  RCONST(280) = (1.6D-12*EXP(305/TEMP))
  RCONST(281) = (J(22))
  RCONST(282) = (1.20D-11*0.613)
  RCONST(283) = (1.20D-11*0.387)
  RCONST(284) = (1.83D-11)
  RCONST(285) = (1.90D-12*EXP(190/TEMP))
  RCONST(286) = (J(41))
  RCONST(287) = (2.00D+14*EXP(-5505/TEMP))
  RCONST(288) = (KNO3AL*2.4)
  RCONST(289) = (1.7D-11)
  RCONST(290) = (J(17))
  RCONST(291) = (J(41))
  RCONST(292) = (1.03D-10)
  RCONST(293) = (J(53)*2.0)
  RCONST(294) = (8.55D-11)
  RCONST(295) = (KROPRIM*O2)
  RCONST(296) = (J(53))
  RCONST(297) = (5.30D-17*0.5)
  RCONST(298) = (5.30D-17*0.5)
  RCONST(299) = (6.93D-11)
  RCONST(300) = (J(18))
  RCONST(301) = (KNO3AL*4.25)
  RCONST(302) = (2.40D-17*0.5)
  RCONST(303) = (2.40D-17*0.5)
  RCONST(304) = (4.16D-11*0.52)
  RCONST(305) = (4.16D-11*0.48)
  RCONST(306) = (KDEC*0.35)
  RCONST(307) = (KDEC*0.65)
  RCONST(308) = (KAPHO2*0.44)
  RCONST(309) = (KAPHO2*0.15)
  RCONST(310) = (KAPHO2*0.41)
  RCONST(311) = (8.70D-12*EXP(290/TEMP))
  RCONST(312) = (KFPAN)
  RCONST(313) = (KRO2NO3*1.74)
  RCONST(314) = (1.00D-11*0.7*RO2)
  RCONST(315) = (1.00D-11*0.3*RO2)
  RCONST(316) = (KDEC*0.18)
  RCONST(317) = (KDEC*0.82)
  RCONST(318) = (J(34))
  RCONST(319) = (KNO3AL*2.4)
  RCONST(320) = (1.9D-12*EXP(575/TEMP))
  RCONST(321) = (KDEC*0.37)
  RCONST(322) = (KDEC*0.47)
  RCONST(323) = (KDEC*0.16)
  RCONST(324) = (KRO2HO2*0.625)
  RCONST(325) = (KRO2NO)
  RCONST(326) = (KRO2NO3)
  RCONST(327) = (9.20D-14*0.7*RO2)
  RCONST(328) = (9.20D-14*0.3*RO2)
  RCONST(329) = (KRO2HO2*0.625)
  RCONST(330) = (KRO2NO*0.017)
  RCONST(331) = (KRO2NO*0.983)
  RCONST(332) = (KRO2NO3)
  RCONST(333) = (1.4D-12*0.2*RO2)
  RCONST(334) = (1.4D-12*0.2*RO2)
  RCONST(335) = (1.4D-12*0.6*RO2)
  RCONST(336) = (KDEC*0.20)
  RCONST(337) = (KDEC*0.20)
  RCONST(338) = (KDEC*0.24)
  RCONST(339) = (KDEC*0.36)
  RCONST(340) = (KRO2HO2*0.625)
  RCONST(341) = (KRO2NO*0.017)
  RCONST(342) = (KRO2NO*0.983)
  RCONST(343) = (KRO2NO3)
  RCONST(344) = (2.00D-12*0.2*RO2)
  RCONST(345) = (2.00D-12*0.6*RO2)
  RCONST(346) = (2.00D-12*0.2*RO2)
  RCONST(347) = (KRO2HO2*0.625)
  RCONST(348) = (KRO2NO)
  RCONST(349) = (KRO2NO3)
  RCONST(350) = (8.80D-13*0.2*RO2)
  RCONST(351) = (8.80D-13*0.6*RO2)
  RCONST(352) = (8.80D-13*0.2*RO2)
  RCONST(353) = (1.2D-15)
  RCONST(354) = (1.0D-14)
  RCONST(355) = (1.0D-15)
  RCONST(356) = (7.0D-14)
  RCONST(357) = (1.0D-17*H2O)
  RCONST(358) = (6.0D-18*H2O)
  RCONST(359) = (1.2D-15)
  RCONST(360) = (1.0D-14)
  RCONST(361) = (1.0D-15)
  RCONST(362) = (7.0D-14)
  RCONST(363) = (6.0D-18*H2O)
  RCONST(364) = (KRO2HO2*0.625)
  RCONST(365) = (KRO2NO)
  RCONST(366) = (KRO2NO3)
  RCONST(367) = (2.00D-12*0.6*RO2)
  RCONST(368) = (2.00D-12*0.2*RO2)
  RCONST(369) = (2.00D-12*0.2*RO2)
  RCONST(370) = (J(41))
  RCONST(371) = (1.54D-10*0.05)
  RCONST(372) = (1.54D-10*0.93)
  RCONST(373) = (1.54D-10*0.02)
  RCONST(374) = (J(53))
  RCONST(375) = (5.30D-17*0.5)
  RCONST(376) = (5.30D-17*0.5)
  RCONST(377) = (6.93D-11)
  RCONST(378) = (KDEC*0.25)
  RCONST(379) = (KDEC*0.75)
  RCONST(380) = (J(18))
  RCONST(381) = (J(19))
  RCONST(382) = (KNO3AL*4.25)
  RCONST(383) = (2.40D-17*0.5)
  RCONST(384) = (2.40D-17*0.5)
  RCONST(385) = (4.52D-11*0.52)
  RCONST(386) = (4.52D-11*0.48)
  RCONST(387) = (9.30D-11*0.5)
  RCONST(388) = (9.30D-11*0.5)
  RCONST(389) = (J(41))
  RCONST(390) = (5.00D-11*0.92)
  RCONST(391) = (5.00D-11*0.08)
  RCONST(392) = (J(55))
  RCONST(393) = (1.06D-16*0.50)
  RCONST(394) = (1.06D-16*0.50)
  RCONST(395) = (1.36D-11*0.72)
  RCONST(396) = (1.36D-11*0.28)
  RCONST(397) = (KDEC)
  RCONST(398) = (3.85D-11)
  RCONST(399) = (J(41))
  RCONST(400) = (1.54D-10*0.05)
  RCONST(401) = (1.54D-10*0.93)
  RCONST(402) = (1.54D-10*0.02)
  RCONST(403) = (KDEC*0.75)
  RCONST(404) = (KDEC*0.25)
  RCONST(405) = (J(18))
  RCONST(406) = (J(19))
  RCONST(407) = (KNO3AL*4.25)
  RCONST(408) = (2.40D-17*0.5)
  RCONST(409) = (2.40D-17*0.5)
  RCONST(410) = (4.52D-11*0.52)
  RCONST(411) = (4.52D-11*0.48)
  RCONST(412) = (J(41))
  RCONST(413) = (1.15D-10*0.22)
  RCONST(414) = (1.15D-10*0.75)
  RCONST(415) = (1.15D-10*0.03)
  RCONST(416) = (J(54))
  RCONST(417) = (1.06D-16*0.50)
  RCONST(418) = (1.06D-16*0.50)
  RCONST(419) = (2.54D-11)
  RCONST(420) = (KDEC)
  RCONST(421) = (J(24))
  RCONST(422) = (3.81D-11)
  RCONST(423) = (7.38D-11)
  RCONST(424) = (1.53D-13*EXP(1300/TEMP))
  RCONST(425) = (KRO2NO*0.005)
  RCONST(426) = (KRO2NO*0.995)
  RCONST(427) = (KRO2NO3)
  RCONST(428) = (2*(KCH3O2*7.8D-14*EXP(1000/TEMP))**0.5*RO2*0.2)
  RCONST(429) = (2*(KCH3O2*7.8D-14*EXP(1000/TEMP))**0.5*RO2*0.6)
  RCONST(430) = (2*(KCH3O2*7.8D-14*EXP(1000/TEMP))**0.5*RO2*0.2)
  RCONST(431) = (1.36D-13*EXP(1250/TEMP)*0.15)
  RCONST(432) = (1.36D-13*EXP(1250/TEMP)*0.85)
  RCONST(433) = (KRO2NO)
  RCONST(434) = (KRO2NO3)
  RCONST(435) = (2*(K298CH3O2*8.0D-12)**0.5*RO2*0.2)
  RCONST(436) = (2*(K298CH3O2*8.0D-12)**0.5*RO2*0.6)
  RCONST(437) = (2*(K298CH3O2*8.0D-12)**0.5*RO2*0.2)
  RCONST(438) = (KAPHO2*0.44)
  RCONST(439) = (KAPHO2*0.41)
  RCONST(440) = (KAPHO2*0.15)
  RCONST(441) = (6.7D-12*EXP(340/TEMP))
  RCONST(442) = (KFPAN)
  RCONST(443) = (KRO2NO3*1.74)
  RCONST(444) = (1.00D-11*0.7*RO2)
  RCONST(445) = (1.00D-11*0.3*RO2)
  RCONST(446) = (KRO2HO2*0.520)
  RCONST(447) = (KRO2NO*0.019)
  RCONST(448) = (KRO2NO*0.981)
  RCONST(449) = (KRO2NO3)
  RCONST(450) = (6.00D-13*0.6*RO2)
  RCONST(451) = (6.00D-13*0.2*RO2)
  RCONST(452) = (6.00D-13*0.2*RO2)
  RCONST(453) = (KRO2HO2*0.625)
  RCONST(454) = (KRO2NO*0.013)
  RCONST(455) = (KRO2NO*0.987)
  RCONST(456) = (KRO2NO3)
  RCONST(457) = (1.30D-12*0.6*RO2)
  RCONST(458) = (1.30D-12*0.2*RO2)
  RCONST(459) = (1.30D-12*0.2*RO2)
  RCONST(460) = (KAPHO2*0.15)
  RCONST(461) = (KAPHO2*0.44)
  RCONST(462) = (KAPHO2*0.41)
  RCONST(463) = (KAPNO)
  RCONST(464) = (KFPAN)
  RCONST(465) = (KRO2NO3*1.74)
  RCONST(466) = (1.00D-11*0.3*RO2)
  RCONST(467) = (1.00D-11*0.7*RO2)
  RCONST(468) = (KRO2HO2*0.625)
  RCONST(469) = (KRO2NO*0.083)
  RCONST(470) = (KRO2NO*0.917)
  RCONST(471) = (KRO2NO3)
  RCONST(472) = (2.50D-13*0.6*RO2)
  RCONST(473) = (2.50D-13*0.2*RO2)
  RCONST(474) = (2.50D-13*0.2*RO2)
  RCONST(475) = (3.3D-12*EXP(-2880/TEMP))
  RCONST(476) = (9.1D-15*EXP(-2580/TEMP))
  RCONST(477) = (KMT15)
  RCONST(478) = (KRO2HO2*0.625)
  RCONST(479) = (KRO2NO*0.042)
  RCONST(480) = (KRO2NO*0.958)
  RCONST(481) = (KRO2NO3)
  RCONST(482) = (8.80D-13*0.2*RO2)
  RCONST(483) = (8.80D-13*0.6*RO2)
  RCONST(484) = (8.80D-13*0.2*RO2)
  RCONST(485) = (KRO2HO2*0.625)
  RCONST(486) = (KRO2NO*0.083)
  RCONST(487) = (KRO2NO*0.917)
  RCONST(488) = (KRO2NO3)
  RCONST(489) = (8.80D-13*0.2*RO2)
  RCONST(490) = (8.80D-13*0.2*RO2)
  RCONST(491) = (8.80D-13*0.6*RO2)
  RCONST(492) = (KRO2HO2*0.625)
  RCONST(493) = (KRO2NO*0.959)
  RCONST(494) = (KRO2NO*0.041)
  RCONST(495) = (KRO2NO3)
  RCONST(496) = (8.80D-13*0.6*RO2)
  RCONST(497) = (8.80D-13*0.2*RO2)
  RCONST(498) = (8.80D-13*0.2*RO2)
  RCONST(499) = (KRO2HO2*0.625)
  RCONST(500) = (KRO2NO*0.033)
  RCONST(501) = (KRO2NO*0.967)
  RCONST(502) = (KRO2NO3)
  RCONST(503) = (2.00D-12*0.2*RO2)
  RCONST(504) = (2.00D-12*0.6*RO2)
  RCONST(505) = (2.00D-12*0.2*RO2)
  RCONST(506) = (KRO2HO2*0.625)
  RCONST(507) = (KRO2NO)
  RCONST(508) = (KRO2NO3)
  RCONST(509) = (8.80D-13*0.2*RO2)
  RCONST(510) = (8.80D-13*0.2*RO2)
  RCONST(511) = (8.80D-13*0.6*RO2)
  RCONST(512) = (KRO2HO2*0.625)
  RCONST(513) = (KRO2NO)
  RCONST(514) = (KRO2NO3)
  RCONST(515) = (2.00D-12*0.2*RO2)
  RCONST(516) = (2.00D-12*0.6*RO2)
  RCONST(517) = (2.00D-12*0.2*RO2)
  RCONST(518) = (KAPHO2*0.44)
  RCONST(519) = (KAPHO2*0.15)
  RCONST(520) = (KAPHO2*0.41)
  RCONST(521) = (KAPNO)
  RCONST(522) = (KFPAN)
  RCONST(523) = (KRO2NO3*1.74)
  RCONST(524) = (1.00D-11*0.7*RO2)
  RCONST(525) = (1.00D-11*0.3*RO2)
  RCONST(526) = (KDEC)
  RCONST(527) = (KDEC)
  RCONST(528) = (4.5D-13)
  RCONST(529) = (J(41))
  RCONST(530) = (5.3D-12*EXP(190/TEMP)*0.6)
  RCONST(531) = (5.3D-12*EXP(190/TEMP)*0.4)
  RCONST(532) = (J(51))
  RCONST(533) = (4.0D-13*EXP(-845/TEMP))
  RCONST(534) = (7.2D-14*EXP(-1080/TEMP)*O2)
  RCONST(535) = (KMT14)
  RCONST(536) = (2.85D-12*EXP(-345/TEMP))
  RCONST(537) = (8.00D-13)
  RCONST(538) = (3.70D-12)
  RCONST(539) = (J(41))
  RCONST(540) = (3D-14)
  RCONST(541) = (KBPAN)
  RCONST(542) = (2.91D-11)
  RCONST(543) = (1.90D-12*EXP(190/TEMP))
  RCONST(544) = (J(41))
  RCONST(545) = (J(15))
  RCONST(546) = (KDEC)
  RCONST(547) = (J(31))
  RCONST(548) = (J(33))
  RCONST(549) = (J(32))
  RCONST(550) = (KNO3AL*0.6)
  RCONST(551) = (KNO3AL*0.4)
  RCONST(552) = (3.1D-12*EXP(340/TEMP)*0.6)
  RCONST(553) = (3.1D-12*EXP(340/TEMP)*0.4)
  RCONST(554) = (KNO3AL)
  RCONST(555) = (1.00D-11*0.200)
  RCONST(556) = (1.00D-11*0.800)
  RCONST(557) = (J(15))
  RCONST(558) = (KAPHO2*0.44)
  RCONST(559) = (KAPHO2*0.56)
  RCONST(560) = (KAPNO)
  RCONST(561) = (KFPAN)
  RCONST(562) = (KRO2NO3*1.74)
  RCONST(563) = (1.00D-11*RO2)
  RCONST(564) = (KDEC*0.11)
  RCONST(565) = (KDEC*0.89)
  RCONST(566) = (KDEC*0.11)
  RCONST(567) = (KDEC*0.89)
  RCONST(568) = (KRO2HO2*0.706)
  RCONST(569) = (KRO2NO*0.145)
  RCONST(570) = (KRO2NO*0.855)
  RCONST(571) = (KRO2NO3)
  RCONST(572) = (2.90D-12*0.1*RO2)
  RCONST(573) = (2.90D-12*0.8*RO2)
  RCONST(574) = (2.90D-12*0.1*RO2)
  RCONST(575) = (KAPHO2*0.15)
  RCONST(576) = (KAPHO2*0.41)
  RCONST(577) = (KAPHO2*0.44)
  RCONST(578) = (KAPNO)
  RCONST(579) = (KFPAN)
  RCONST(580) = (KRO2NO3*1.74)
  RCONST(581) = (1.00D-11*0.3*RO2)
  RCONST(582) = (1.00D-11*0.7*RO2)
  RCONST(583) = (KDEC*0.11)
  RCONST(584) = (KDEC*0.89)
  RCONST(585) = (KDEC*0.11)
  RCONST(586) = (KDEC*0.89)
  RCONST(587) = (KRO2HO2*0.706)
  RCONST(588) = (KRO2NO)
  RCONST(589) = (KRO2NO3)
  RCONST(590) = (9.20D-14*0.7*RO2)
  RCONST(591) = (9.20D-14*0.3*RO2)
  RCONST(592) = (1.51D-11)
  RCONST(593) = (J(41))
  RCONST(594) = (1.661D-11)
  RCONST(595) = (1.6D+16*EXP(-13500/TEMP))
  RCONST(596) = (8.2D-18)
  RCONST(597) = (2.9D-11)
  RCONST(598) = (1.2D-15)
  RCONST(599) = (1.0D-14)
  RCONST(600) = (1.0D-15)
  RCONST(601) = (7.0D-14)
  RCONST(602) = (6.0D-18*H2O)
  RCONST(603) = (J(17))
  RCONST(604) = (J(41))
  RCONST(605) = (3.77D-11)
  RCONST(606) = (KDEC)
  RCONST(607) = (J(17))
  RCONST(608) = (3.42D-11)
  RCONST(609) = (5.55D-11)
  RCONST(610) = (J(17))
  RCONST(611) = (J(41))
  RCONST(612) = (2.18D-11)
  RCONST(613) = (J(55))
  RCONST(614) = (J(17))
  RCONST(615) = (KDEC)
  RCONST(616) = (1.32D-10)
  RCONST(617) = (J(17)*2)
  RCONST(618) = (1.2D-15)
  RCONST(619) = (1.0D-14)
  RCONST(620) = (1.0D-15)
  RCONST(621) = (7.0D-14)
  RCONST(622) = (1.0D-17*H2O)
  RCONST(623) = (6.0D-18*H2O)
  RCONST(624) = (J(41))
  RCONST(625) = (5.77D-11)
  RCONST(626) = (2.23D-12)
  RCONST(627) = (KDEC)
  RCONST(628) = (J(15))
  RCONST(629) = (KNO3AL*4.0)
  RCONST(630) = (2.45D-11)
  RCONST(631) = (J(22))
  RCONST(632) = (1.88D-11)
  RCONST(633) = (J(41))
  RCONST(634) = (3.95D-11)
  RCONST(635) = (KDEC)
  RCONST(636) = (J(35))
  RCONST(637) = (2.69D-12)
  RCONST(638) = (J(24))
  RCONST(639) = (J(41))
  RCONST(640) = (1.90D-12*EXP(190/TEMP))
  RCONST(641) = (2.55D-11)
  RCONST(642) = (KDEC)
  RCONST(643) = (7.51D-16*EXP(-1521/TEMP)*0.5)
  RCONST(644) = (7.51D-16*EXP(-1521/TEMP)*0.5)
  RCONST(645) = (4.60D-12*EXP(452/TEMP)*0.3)
  RCONST(646) = (4.60D-12*EXP(452/TEMP)*0.7)
  RCONST(647) = (J(23))
  RCONST(648) = (J(24))
  RCONST(649) = (KNO3AL*2.0)
  RCONST(650) = (2.95D-11)
  RCONST(651) = (J(34))
  RCONST(652) = (5.23D-12)
  RCONST(653) = (KDEC*0.11)
  RCONST(654) = (KDEC*0.89)
  RCONST(655) = (KDEC*0.11)
  RCONST(656) = (KDEC*0.89)
  RCONST(657) = (KNO3AL)
  RCONST(658) = (3.40D-12)
  RCONST(659) = (J(57))
  RCONST(660) = (J(56))
  RCONST(661) = (KRO2HO2*0.706)
  RCONST(662) = (KRO2NO*0.072)
  RCONST(663) = (KRO2NO*0.928)
  RCONST(664) = (KRO2NO3)
  RCONST(665) = (8.00D-13*0.8*RO2)
  RCONST(666) = (8.00D-13*0.2*RO2)
  RCONST(667) = (KRO2HO2*0.706)
  RCONST(668) = (KRO2NO*0.134)
  RCONST(669) = (KRO2NO*0.866)
  RCONST(670) = (KRO2NO3)
  RCONST(671) = (2.90D-12*RO2*0.1)
  RCONST(672) = (2.90D-12*RO2*0.8)
  RCONST(673) = (2.90D-12*RO2*0.1)
  RCONST(674) = (KAPHO2*0.44)
  RCONST(675) = (KAPHO2*0.15)
  RCONST(676) = (KAPHO2*0.41)
  RCONST(677) = (KAPNO)
  RCONST(678) = (KFPAN)
  RCONST(679) = (KRO2NO3*1.74)
  RCONST(680) = (1.00D-11*0.7*RO2)
  RCONST(681) = (1.00D-11*0.3*RO2)
  RCONST(682) = (KRO2HO2*0.706)
  RCONST(683) = (KRO2NO*0.019)
  RCONST(684) = (KRO2NO*0.981)
  RCONST(685) = (KRO2NO3)
  RCONST(686) = (9.20D-14*0.7*RO2)
  RCONST(687) = (9.20D-14*0.3*RO2)
  RCONST(688) = (9.05D-12*0.5)
  RCONST(689) = (9.05D-12*0.5)
  RCONST(690) = (KDEC*0.36)
  RCONST(691) = (KDEC*0.20)
  RCONST(692) = (KDEC*0.24)
  RCONST(693) = (KDEC*0.20)
  RCONST(694) = (4.34D-12*0.16)
  RCONST(695) = (4.34D-12*0.84)
  RCONST(696) = (J(17))
  RCONST(697) = (KRO2HO2*0.706)
  RCONST(698) = (KRO2NO*0.145)
  RCONST(699) = (KRO2NO*0.855)
  RCONST(700) = (KRO2NO3)
  RCONST(701) = (2.90D-12*0.1*RO2)
  RCONST(702) = (2.90D-12*0.8*RO2)
  RCONST(703) = (2.90D-12*0.1*RO2)
  RCONST(704) = (KRO2HO2*0.706)
  RCONST(705) = (KRO2NO*0.064)
  RCONST(706) = (KRO2NO*0.936)
  RCONST(707) = (8.80D-13*0.2*RO2)
  RCONST(708) = (8.80D-13*0.2*RO2)
  RCONST(709) = (8.80D-13*0.6*RO2)
  RCONST(710) = (1.50D-11*0.719)
  RCONST(711) = (1.50D-11*0.281)
  RCONST(712) = (KAPHO2*0.44)
  RCONST(713) = (KAPHO2*0.15)
  RCONST(714) = (KAPHO2*0.41)
  RCONST(715) = (KAPNO)
  RCONST(716) = (KFPAN)
  RCONST(717) = (KRO2NO3*1.74)
  RCONST(718) = (1.00D-11*0.7*RO2)
  RCONST(719) = (1.00D-11*0.3*RO2)
  RCONST(720) = (KDEC*0.11)
  RCONST(721) = (KDEC*0.89)
  RCONST(722) = (KRO2HO2*0.706)
  RCONST(723) = (KRO2NO)
  RCONST(724) = (KRO2NO3)
  RCONST(725) = (9.20D-14*0.7*RO2)
  RCONST(726) = (9.20D-14*0.3*RO2)
  RCONST(727) = (KDEC*0.18)
  RCONST(728) = (KDEC*0.82)
  RCONST(729) = (1.33D-12*0.33)
  RCONST(730) = (1.33D-12*0.67)
  RCONST(731) = (J(56)+J(57))
  RCONST(732) = (KDEC*0.18)
  RCONST(733) = (KDEC*0.82)
  RCONST(734) = (KRO2HO2*0.706)
  RCONST(735) = (KRO2NO*0.072)
  RCONST(736) = (KRO2NO*0.928)
  RCONST(737) = (KRO2NO3)
  RCONST(738) = (8.00D-13*0.8*RO2)
  RCONST(739) = (8.00D-13*0.2*RO2)
  RCONST(740) = (KAPHO2*0.44)
  RCONST(741) = (KAPHO2*0.15)
  RCONST(742) = (KAPHO2*0.41)
  RCONST(743) = (KAPNO)
  RCONST(744) = (KFPAN)
  RCONST(745) = (KRO2NO3*1.74)
  RCONST(746) = (1.00D-11*0.7*RO2)
  RCONST(747) = (1.00D-11*0.3*RO2)
  RCONST(748) = (KRO2HO2*0.706)
  RCONST(749) = (KRO2NO)
  RCONST(750) = (KRO2NO3)
  RCONST(751) = (9.20D-14*RO2)
  RCONST(752) = (1.90D-12*EXP(190/TEMP))
  RCONST(753) = (1.38D-11)
  RCONST(754) = (J(41))
  RCONST(755) = (8.40D-13)
  RCONST(756) = (9.50D+13*EXP(-5988/TEMP))
  RCONST(757) = (KROPRIM*O2)
  RCONST(758) = (1.45D-11)
  RCONST(759) = (1.90D-12*EXP(190/TEMP))
  RCONST(760) = (8.39D-12)
  RCONST(761) = (J(22))
  RCONST(762) = (J(41))
  RCONST(763) = (4.42D-12)
  RCONST(764) = (J(41))
  RCONST(765) = (1.2D-12)
  RCONST(766) = (1.27D-12)
  RCONST(767) = (KBPAN)
  RCONST(768) = (J(41))
  RCONST(769) = (1.90D-12*EXP(190/TEMP))
  RCONST(770) = (1.52D-11)
  RCONST(771) = (J(53))
  RCONST(772) = (4.44D-12)
  RCONST(773) = (KROPRIM*O2)
  RCONST(774) = (J(15))
  RCONST(775) = (KNO3AL*2.4)
  RCONST(776) = (3.06D-11)
  RCONST(777) = (9.73D-12)
  RCONST(778) = (J(41))
  RCONST(779) = (1.90D-12*EXP(190/TEMP))
  RCONST(780) = (1.66D-11)
  RCONST(781) = (J(53))
  RCONST(782) = (5.85D-12)
  RCONST(783) = (8.74D+11*EXP(-3430/TEMP))
  RCONST(784) = (J(15))
  RCONST(785) = (KNO3AL*4.0)
  RCONST(786) = (2.64D-11)
  RCONST(787) = (1.11D-11)
  RCONST(788) = (1.8D-12)
  RCONST(789) = (8.29D-12)
  RCONST(790) = (J(41))
  RCONST(791) = (4.70D-12)
  RCONST(792) = (KBPAN)
  RCONST(793) = (1.90D-12*EXP(190/TEMP))
  RCONST(794) = (1.27D-10)
  RCONST(795) = (J(41))
  RCONST(796) = (J(15))
  RCONST(797) = (2.25D-11)
  RCONST(798) = (J(54)+J(15))
  RCONST(799) = (2.70D+14*EXP(-7398/TEMP))
  RCONST(800) = (KROSEC*O2)
  RCONST(801) = (KNO3AL*4.0)
  RCONST(802) = (7.15D-11)
  RCONST(803) = (J(15))
  RCONST(804) = (J(15))
  RCONST(805) = (KNO3AL*4.0)
  RCONST(806) = (4.88D-11*0.561)
  RCONST(807) = (4.88D-11*0.439)
  RCONST(808) = (KRO2HO2*0.387)
  RCONST(809) = (KRO2NO)
  RCONST(810) = (KRO2NO3)
  RCONST(811) = (6.00D-13*0.6*RO2)
  RCONST(812) = (6.00D-13*0.2*RO2)
  RCONST(813) = (6.00D-13*0.2*RO2)
  RCONST(814) = (KDEC*0.37)
  RCONST(815) = (KDEC*0.50)
  RCONST(816) = (KDEC*0.13)
  RCONST(817) = (3.01D-11)
  RCONST(818) = (1.90D-12*EXP(190/TEMP))
  RCONST(819) = (J(41))
  RCONST(820) = (1.27D-12)
  RCONST(821) = (2.00D+14*EXP(-6354/TEMP))
  RCONST(822) = (3.44D-12)
  RCONST(823) = (J(22))
  RCONST(824) = (1.59D-11)
  RCONST(825) = (2.58D-11)
  RCONST(826) = (1.90D-12*EXP(190/TEMP))
  RCONST(827) = (J(41))
  RCONST(828) = (4.51D-12)
  RCONST(829) = (J(54))
  RCONST(830) = (2.70D+14*EXP(-7398/TEMP))
  RCONST(831) = (KROSEC*O2)
  RCONST(832) = (1.42D-11)
  RCONST(833) = (1.35D-11)
  RCONST(834) = (J(22))
  RCONST(835) = (2.89D-11)
  RCONST(836) = (1.90D-12*EXP(190/TEMP))
  RCONST(837) = (J(41))
  RCONST(838) = (2.00D+14*EXP(-4714/TEMP))
  RCONST(839) = (1.79D-12)
  RCONST(840) = (5.86D-12)
  RCONST(841) = (J(22))
  RCONST(842) = (1.73D-11)
  RCONST(843) = (4.88D-11)
  RCONST(844) = (1.90D-12*EXP(190/TEMP))
  RCONST(845) = (J(41)+J(22))
  RCONST(846) = (9.64D-13)
  RCONST(847) = (J(53)+J(22))
  RCONST(848) = (KROPRIM*O2)
  RCONST(849) = (1.30D+11*EXP(-4127/TEMP))
  RCONST(850) = (1.88D-11)
  RCONST(851) = (1.90D-12*EXP(190/TEMP))
  RCONST(852) = (J(22))
  RCONST(853) = (J(41))
  RCONST(854) = (KDEC)
  RCONST(855) = (J(35))
  RCONST(856) = (1.40D-18*TEMP**2*EXP(194/TEMP))
  RCONST(857) = (9.55D-12)
  RCONST(858) = (1.90D-12*EXP(190/TEMP))
  RCONST(859) = (J(22))
  RCONST(860) = (J(41))
  RCONST(861) = (KDEC)
  RCONST(862) = (J(34))
  RCONST(863) = (KNO3AL*4.0)
  RCONST(864) = (1.39D-11)
  RCONST(865) = (3.14D-13)
  RCONST(866) = (3.77D-12)
  RCONST(867) = (J(41))
  RCONST(868) = (1.43D-13)
  RCONST(869) = (KBPAN)
  RCONST(870) = (KAPHO2*0.15)
  RCONST(871) = (KAPHO2*0.41)
  RCONST(872) = (KAPHO2*0.44)
  RCONST(873) = (KAPNO)
  RCONST(874) = (KFPAN)
  RCONST(875) = (KRO2NO3*1.74)
  RCONST(876) = (1.00D-11*0.7*RO2)
  RCONST(877) = (1.00D-11*0.3*RO2)
  RCONST(878) = (9.34D-12)
  RCONST(879) = (J(41))
  RCONST(880) = (2.34D-12)
  RCONST(881) = (KBPAN)
  RCONST(882) = (1.2D-15)
  RCONST(883) = (1.0D-14)
  RCONST(884) = (1.0D-15)
  RCONST(885) = (7.0D-14)
  RCONST(886) = (6.0D-18*H2O)
  RCONST(887) = (1.0D-17*H2O)
  RCONST(888) = (1.2D-15)
  RCONST(889) = (1.0D-14)
  RCONST(890) = (1.0D-15)
  RCONST(891) = (7.0D-14)
  RCONST(892) = (6.0D-18*H2O)
  RCONST(893) = (J(41))
  RCONST(894) = (3.31D-11*0.89)
  RCONST(895) = (3.31D-11*0.11)
  RCONST(896) = (1.98D-12*0.445)
  RCONST(897) = (1.98D-12*0.414)
  RCONST(898) = (1.98D-12*0.141)
  RCONST(899) = (KDEC)
  RCONST(900) = (3.30D-12)
  RCONST(901) = (1.53D-11)
  RCONST(902) = (2.16D-11)
  RCONST(903) = (J(41))
  RCONST(904) = (2.52D-11)
  RCONST(905) = (KBPAN)
  RCONST(906) = (2.16D-11)
  RCONST(907) = (1.2D-15)
  RCONST(908) = (1.0D-14)
  RCONST(909) = (1.0D-15)
  RCONST(910) = (7.0D-14)
  RCONST(911) = (6.0D-18*H2O)
  RCONST(912) = (1.0D-17*H2O)
  RCONST(913) = (1.2D-15)
  RCONST(914) = (1.0D-14)
  RCONST(915) = (1.0D-15)
  RCONST(916) = (7.0D-14)
  RCONST(917) = (6.0D-18*H2O)
  RCONST(918) = (J(41))
  RCONST(919) = (2.81D-11)
  RCONST(920) = (KDEC)
  RCONST(921) = (2.69D-11)
  RCONST(922) = (1.4D-11)
  RCONST(923) = (J(17))
  RCONST(924) = (KAPHO2*0.56)
  RCONST(925) = (KAPHO2*0.44)
  RCONST(926) = (KAPNO)
  RCONST(927) = (KFPAN)
  RCONST(928) = (KRO2NO3*1.74)
  RCONST(929) = (1.00D-11*RO2)
  RCONST(930) = (J(34))
  RCONST(931) = (8.0D-13)
  RCONST(932) = (KAPHO2*0.56)
  RCONST(933) = (KAPHO2*0.44)
  RCONST(934) = (KAPNO)
  RCONST(935) = (KFPAN)
  RCONST(936) = (KRO2NO3*1.74)
  RCONST(937) = (1.00D-11*RO2)
  RCONST(938) = (J(34))
  RCONST(939) = (J(35))
  RCONST(940) = (KNO3AL*4.0)
  RCONST(941) = (1.23D-11)
  RCONST(942) = (KAPHO2*0.15)
  RCONST(943) = (KAPHO2*0.41)
  RCONST(944) = (KAPHO2*0.44)
  RCONST(945) = (KAPNO)
  RCONST(946) = (KFPAN)
  RCONST(947) = (KRO2NO3*1.74)
  RCONST(948) = (1.00D-11*0.3*RO2)
  RCONST(949) = (1.00D-11*0.7*RO2)
  RCONST(950) = (KDEC*0.24)
  RCONST(951) = (KDEC*0.20)
  RCONST(952) = (KDEC*0.20)
  RCONST(953) = (KDEC*0.36)
  RCONST(954) = (J(34))
  RCONST(955) = (KNO3AL*2.4)
  RCONST(956) = (1.44D-11)
  RCONST(957) = (KRO2HO2*0.625)
  RCONST(958) = (KRO2NO*0.017)
  RCONST(959) = (KRO2NO*0.983)
  RCONST(960) = (KRO2NO3)
  RCONST(961) = (2.00D-12*RO2*0.2)
  RCONST(962) = (2.00D-12*RO2*0.6)
  RCONST(963) = (2.00D-12*RO2*0.2)
  RCONST(964) = (KRO2HO2*0.625)
  RCONST(965) = (KRO2NO)
  RCONST(966) = (KRO2NO3)
  RCONST(967) = (8.80D-13*RO2*0.2)
  RCONST(968) = (8.80D-13*RO2*0.2)
  RCONST(969) = (8.80D-13*RO2*0.6)
  RCONST(970) = (2.59D-11)
  RCONST(971) = (J(17))
  RCONST(972) = (KNO3AL*7.5)
  RCONST(973) = (2.20D-11)
  RCONST(974) = (1.2D-15)
  RCONST(975) = (1.0D-14)
  RCONST(976) = (1.0D-15)
  RCONST(977) = (7.0D-14)
  RCONST(978) = (6.0D-18*H2O)
  RCONST(979) = (1.0D-17*H2O)
  RCONST(980) = (1.2D-15)
  RCONST(981) = (1.0D-14)
  RCONST(982) = (1.0D-15)
  RCONST(983) = (7.0D-14)
  RCONST(984) = (6.0D-18*H2O)
  RCONST(985) = (KAPHO2*0.44)
  RCONST(986) = (KAPHO2*0.15)
  RCONST(987) = (KAPHO2*0.41)
  RCONST(988) = (KAPNO)
  RCONST(989) = (KFPAN)
  RCONST(990) = (KRO2NO3*1.74)
  RCONST(991) = (1.00D-11*0.7*RO2)
  RCONST(992) = (1.00D-11*0.3*RO2)
  RCONST(993) = (J(41))
  RCONST(994) = (1.01D-11*0.65)
  RCONST(995) = (1.01D-11*0.35)
  RCONST(996) = (2.00D-12*0.07)
  RCONST(997) = (2.00D-12*0.39)
  RCONST(998) = (2.00D-12*0.07)
  RCONST(999) = (2.00D-12*0.33)
  RCONST(1000) = (2.00D-12*0.14)
  RCONST(1001) = (KDEC)
  RCONST(1002) = (6.68D-12)
  RCONST(1003) = (1.18D-10*0.22)
  RCONST(1004) = (1.18D-10*0.03)
  RCONST(1005) = (1.18D-10*0.75)
  RCONST(1006) = (J(41))
  RCONST(1007) = (J(54))
  RCONST(1008) = (2.94D-11)
  RCONST(1009) = (KDEC)
  RCONST(1010) = (4.21D-11)
  RCONST(1011) = (J(24))
  RCONST(1012) = (7.78D-11)
  RCONST(1013) = (2.52D-11)
  RCONST(1014) = (J(41))
  RCONST(1015) = (2.88D-11)
  RCONST(1016) = (KBPAN)
  RCONST(1017) = (2.52D-11)
  RCONST(1018) = (J(41))
  RCONST(1019) = (3.16D-11)
  RCONST(1020) = (J(15))
  RCONST(1021) = (2.32D-11)
  RCONST(1022) = (KDEC)
  RCONST(1023) = (3.04D-11)
  RCONST(1024) = (KRO2HO2*0.706)
  RCONST(1025) = (KRO2NO)
  RCONST(1026) = (KRO2NO3)
  RCONST(1027) = (9.20D-14*RO2)
  RCONST(1028) = (KRO2HO2*0.706)
  RCONST(1029) = (KRO2NO)
  RCONST(1030) = (KRO2NO3)
  RCONST(1031) = (8.80D-13*RO2)
  RCONST(1032) = (1.2D-15)
  RCONST(1033) = (1.0D-14)
  RCONST(1034) = (1.0D-15)
  RCONST(1035) = (7.0D-14)
  RCONST(1036) = (1.0D-17*H2O)
  RCONST(1037) = (6.0D-18*H2O)
  RCONST(1038) = (6.78D-12)
  RCONST(1039) = (J(56)+J(57)*2)
  RCONST(1040) = (KAPHO2*0.44)
  RCONST(1041) = (KAPHO2*0.15)
  RCONST(1042) = (KAPHO2*0.41)
  RCONST(1043) = (KAPNO)
  RCONST(1044) = (KFPAN)
  RCONST(1045) = (KRO2NO3*1.74)
  RCONST(1046) = (1.00D-11*0.7*RO2)
  RCONST(1047) = (1.00D-11*0.3*RO2)
  RCONST(1048) = (1.27D-11*0.35)
  RCONST(1049) = (1.27D-11*0.34)
  RCONST(1050) = (1.27D-11*0.31)
  RCONST(1051) = (J(41))
  RCONST(1052) = (1.63D-12*0.50)
  RCONST(1053) = (1.63D-12*0.50)
  RCONST(1054) = (KDEC)
  RCONST(1055) = (3.27D-12)
  RCONST(1056) = (J(56)+J(57))
  RCONST(1057) = (6.65D-12*0.71)
  RCONST(1058) = (6.65D-12*0.29)
  RCONST(1059) = (1.59D-11*0.73)
  RCONST(1060) = (1.59D-11*0.27)
  RCONST(1061) = (J(41))
  RCONST(1062) = (KDEC)
  RCONST(1063) = (KRO2HO2*0.706)
  RCONST(1064) = (KRO2NO)
  RCONST(1065) = (KRO2NO3)
  RCONST(1066) = (9.20D-14*RO2)
  RCONST(1067) = (J(15))
  RCONST(1068) = (KNO3AL*7.5)
  RCONST(1069) = (2.76D-11)
  RCONST(1070) = (2.52D-11)
  RCONST(1071) = (J(41))
  RCONST(1072) = (2.88D-11)
  RCONST(1073) = (KBPAN)
  RCONST(1074) = (2.52D-11)
  RCONST(1075) = (J(41))
  RCONST(1076) = (3.16D-11)
  RCONST(1077) = (KDEC)
  RCONST(1078) = (3.04D-11)
  RCONST(1079) = (7.20D-12)
  RCONST(1080) = (J(15))
  RCONST(1081) = (1.2D-15)
  RCONST(1082) = (1.0D-14)
  RCONST(1083) = (1.0D-15)
  RCONST(1084) = (7.0D-14)
  RCONST(1085) = (6.0D-18*H2O)
  RCONST(1086) = (9.20D-12*0.61)
  RCONST(1087) = (9.20D-12*0.39)
  RCONST(1088) = (J(41))
  RCONST(1089) = (1.80D+13*(TEMP/298)**1.7*EXP(-4733/TEMP))
  RCONST(1090) = (1.80D+13*(TEMP/298)**1.7*EXP(-4079/TEMP))
  RCONST(1091) = (5.60D-12)
  RCONST(1092) = (2.73D-12)
  RCONST(1093) = (6.19D-12)
  RCONST(1094) = (J(41))
  RCONST(1095) = (1.12D-12)
  RCONST(1096) = (KBPAN)
  RCONST(1097) = (J(41))
  RCONST(1098) = (J(22))
  RCONST(1099) = (9.70D-12)
  RCONST(1100) = (KDEC)
  RCONST(1101) = (KAPHO2*0.15)
  RCONST(1102) = (KAPHO2*0.41)
  RCONST(1103) = (KAPHO2*0.44)
  RCONST(1104) = (KAPNO)
  RCONST(1105) = (KFPAN)
  RCONST(1106) = (KRO2NO3*1.74)
  RCONST(1107) = (1.00D-11*0.3*RO2)
  RCONST(1108) = (1.00D-11*0.7*RO2)
  RCONST(1109) = (KAPHO2*0.44)
  RCONST(1110) = (KAPHO2*0.15)
  RCONST(1111) = (KAPHO2*0.41)
  RCONST(1112) = (KAPNO*4.0)
  RCONST(1113) = (KFPAN)
  RCONST(1114) = (KRO2NO3*1.74)
  RCONST(1115) = (1.00D-11*0.7*RO2)
  RCONST(1116) = (1.00D-11*0.3*RO2)
  RCONST(1117) = (KAPHO2*0.44)
  RCONST(1118) = (KAPHO2*0.56)
  RCONST(1119) = (KAPNO)
  RCONST(1120) = (KFPAN)
  RCONST(1121) = (KRO2NO3*1.74)
  RCONST(1122) = (1.00D-11*RO2)
  RCONST(1123) = (KAPHO2*0.15)
  RCONST(1124) = (KAPHO2*0.41)
  RCONST(1125) = (KAPHO2*0.44)
  RCONST(1126) = (KAPNO)
  RCONST(1127) = (KFPAN)
  RCONST(1128) = (KRO2NO3*1.74)
  RCONST(1129) = (1.00D-11*0.3*RO2)
  RCONST(1130) = (1.00D-11*0.7*RO2)
  RCONST(1131) = (1.90D-12*EXP(190/TEMP))
  RCONST(1132) = (1.62D-12)
  RCONST(1133) = (J(41))
  RCONST(1134) = (7.00D+03)
  RCONST(1135) = (KROPRIM*O2)
  RCONST(1136) = (KRO2HO2*0.625)
  RCONST(1137) = (KRO2NO)
  RCONST(1138) = (KRO2NO3)
  RCONST(1139) = (2.00D-12*0.2*RO2)
  RCONST(1140) = (2.00D-12*0.6*RO2)
  RCONST(1141) = (2.00D-12*0.2*RO2)
  RCONST(1142) = (KRO2HO2*0.625)
  RCONST(1143) = (KRO2NO)
  RCONST(1144) = (KRO2NO3)
  RCONST(1145) = (2.00D-12*0.6*RO2)
  RCONST(1146) = (2.00D-12*0.2*RO2)
  RCONST(1147) = (2.00D-12*0.2*RO2)
  RCONST(1148) = (J(34))
  RCONST(1149) = (1.23D-11)
  RCONST(1150) = (J(41)+J(15))
  RCONST(1151) = (1.58D-11)
  RCONST(1152) = (KBPAN)
  RCONST(1153) = (1.22D-11)
  RCONST(1154) = (4.52D-12*0.19)
  RCONST(1155) = (4.52D-12*0.81)
  RCONST(1156) = (J(15))
  RCONST(1157) = (J(34))
  RCONST(1158) = (1.34D-11)
  RCONST(1159) = (KAPHO2*0.44)
  RCONST(1160) = (KAPHO2*0.15)
  RCONST(1161) = (KAPHO2*0.41)
  RCONST(1162) = (KAPNO)
  RCONST(1163) = (KFPAN)
  RCONST(1164) = (KRO2NO3*1.74)
  RCONST(1165) = (1.00D-11*RO2*0.7)
  RCONST(1166) = (1.00D-11*RO2*0.3)
  RCONST(1167) = (6.99D-11)
  RCONST(1168) = (J(41)+J(17))
  RCONST(1169) = (6.64D-11)
  RCONST(1170) = (KBPAN)
  RCONST(1171) = (J(22))
  RCONST(1172) = (J(41))
  RCONST(1173) = (7.34D-12)
  RCONST(1174) = (KBPAN)
  RCONST(1175) = (3.74D-12)
  RCONST(1176) = (8.66D-12)
  RCONST(1177) = (J(41))
  RCONST(1178) = (1.22D-11)
  RCONST(1179) = (KBPAN)
  RCONST(1180) = (8.63D-12)
  RCONST(1181) = (1.20D-15)
  RCONST(1182) = (1.00D-14)
  RCONST(1183) = (1.00D-15)
  RCONST(1184) = (7.00D-14)
  RCONST(1185) = (6.00D-18*H2O)
  RCONST(1186) = (1.00D-17*H2O)
  RCONST(1187) = (5.98D-11)
  RCONST(1188) = (J(41)+J(22))
  RCONST(1189) = (4.37D-12)
  RCONST(1190) = (KDEC)
  RCONST(1191) = (J(15))
  RCONST(1192) = (KNO3AL*4.0)
  RCONST(1193) = (2.66D-11)
  RCONST(1194) = (2.10D-11)
  RCONST(1195) = (J(22))
  RCONST(1196) = (4.39D-12)
  RCONST(1197) = (J(22))
  RCONST(1198) = (J(41))
  RCONST(1199) = (KDEC)
  RCONST(1200) = (4.44D-12)
  RCONST(1201) = (J(35))
  RCONST(1202) = (1.72D-13*EXP(-1190/TEMP))
  RCONST(1203) = (0.68*2.00E-11)
  RCONST(1204) = (0.255*2.00E-11)
  RCONST(1205) = (0.065*2.00E-11)
  RCONST(1206) = (0.3*J(18))
  RCONST(1207) = (0.4*J(18))
  RCONST(1208) = (0.3*J(18))
  RCONST(1209) = (0.5*2.9E-19)
  RCONST(1210) = (0.5*2.9E-19)
  RCONST(1211) = (KAPHO2*0.44)
  RCONST(1212) = (KAPHO2*0.56)
  RCONST(1213) = (KAPNO)
  RCONST(1214) = (KFPAN)
  RCONST(1215) = (KRO2NO3*1.74)
  RCONST(1216) = (1.00D-11*RO2)
  RCONST(1217) = (1.68D-13)
  RCONST(1218) = (3.63D-12)
  RCONST(1219) = (J(41))
  RCONST(1220) = (1.12D-14)
  RCONST(1221) = (KBPAN)
  RCONST(1222) = (J(17)+J(41))
  RCONST(1223) = (2.67D-11)
  RCONST(1224) = (J(17))
  RCONST(1225) = (4.22D-12)
  RCONST(1226) = (J(56)+J(57))
  RCONST(1227) = (1.21D-12*0.56)
  RCONST(1228) = (1.21D-12*0.44)
  RCONST(1229) = (J(17))
  RCONST(1230) = (2.29D-11)
  RCONST(1231) = (1.31D-11*0.667)
  RCONST(1232) = (1.31D-11*0.333)
  RCONST(1233) = (KRO2HO2*0.706)
  RCONST(1234) = (KRO2NO*0.072)
  RCONST(1235) = (KRO2NO*0.928)
  RCONST(1236) = (KRO2NO3)
  RCONST(1237) = (8.00D-13*RO2*0.8)
  RCONST(1238) = (8.00D-13*RO2*0.2)
  RCONST(1239) = (3.40D-15)
  RCONST(1240) = (7.80D-19*0.5)
  RCONST(1241) = (7.80D-19*0.5)
  RCONST(1242) = (4.83D-11*0.376)
  RCONST(1243) = (4.83D-11*0.624)
  RCONST(1244) = (KRO2HO2*0.706)
  RCONST(1245) = (KRO2NO)
  RCONST(1246) = (KRO2NO3)
  RCONST(1247) = (9.20D-14*RO2)
  RCONST(1248) = (KAPHO2*0.15)
  RCONST(1249) = (KAPHO2*0.41)
  RCONST(1250) = (KAPHO2*0.44)
  RCONST(1251) = (KAPNO)
  RCONST(1252) = (KFPAN)
  RCONST(1253) = (1.00D-11*0.3*RO2)
  RCONST(1254) = (1.00D-11*0.7*RO2)
  RCONST(1255) = (J(17))
  RCONST(1256) = (J(41))
  RCONST(1257) = (3.90D-11)
  RCONST(1258) = (KDEC)
  RCONST(1259) = (J(41))
  RCONST(1260) = (J(15))
  RCONST(1261) = (5.34D-11)
  RCONST(1262) = (KDEC)
  RCONST(1263) = (1.34D-12*0.44)
  RCONST(1264) = (1.34D-12*0.15)
  RCONST(1265) = (KAPHO2*0.15)
  RCONST(1266) = (KAPHO2*0.41)
  RCONST(1267) = (KAPHO2*0.44)
  RCONST(1268) = (KAPNO)
  RCONST(1269) = (KFPAN)
  RCONST(1270) = (KRO2NO3*1.74)
  RCONST(1271) = (1.00D-11*0.3*RO2)
  RCONST(1272) = (1.00D-11*0.7*RO2)
  RCONST(1273) = (4.42D-12*0.15)
  RCONST(1274) = (4.42D-12*0.85)
  RCONST(1275) = (J(41))
  RCONST(1276) = (8.21D-13)
  RCONST(1277) = (KBPAN)
  RCONST(1278) = (J(15))
  RCONST(1279) = (2.41D-11)
  RCONST(1280) = (J(15))
  RCONST(1281) = (1.85D-11)
  RCONST(1282) = (J(17))
  RCONST(1283) = (1.85D-11)
  RCONST(1284) = (1.35D-11)
  RCONST(1285) = (J(34))
  RCONST(1286) = (9.37D-12*0.54)
  RCONST(1287) = (9.37D-12*0.46)
  RCONST(1288) = (J(17))
  RCONST(1289) = (J(22))
  RCONST(1290) = (J(41))
  RCONST(1291) = (3.60D-12)
  RCONST(1292) = (1.57D-11)
  RCONST(1293) = (KDEC)
  RCONST(1294) = (KAPHO2*0.56)
  RCONST(1295) = (KAPHO2*0.44)
  RCONST(1296) = (KAPNO)
  RCONST(1297) = (KFPAN)
  RCONST(1298) = (KRO2NO3*1.74)
  RCONST(1299) = (1.00D-11*RO2)
  RCONST(1300) = (KAPHO2*0.56)
  RCONST(1301) = (KAPHO2*0.44)
  RCONST(1302) = (KAPNO)
  RCONST(1303) = (KFPAN)
  RCONST(1304) = (KRO2NO3*1.74)
  RCONST(1305) = (1.00D-11*RO2)
  RCONST(1306) = (2.58D-11)
  RCONST(1307) = (J(17)+J(41))
  RCONST(1308) = (2.27D-11)
  RCONST(1309) = (J(17))
  RCONST(1310) = (1.39D-11)
  RCONST(1311) = (J(41))
  RCONST(1312) = (1.73D-11)
  RCONST(1313) = (KBPAN)
  RCONST(1314) = (4.51D-12)
  RCONST(1315) = (9.64D-12)
  RCONST(1316) = (J(41))
  RCONST(1317) = (1.31D-11)
  RCONST(1318) = (KBPAN)
  RCONST(1319) = (5.92D-12)
  RCONST(1320) = (4.18D-12)
  RCONST(1321) = (J(41)+J(22))
  RCONST(1322) = (5.93D-13)
  RCONST(1323) = (KBPAN)
  RCONST(1324) = (2.78D-11)
  RCONST(1325) = (J(41))
  RCONST(1326) = (3.12D-11)
  RCONST(1327) = (KBPAN)
  RCONST(1328) = (9.00D-12)
  RCONST(1329) = (1.90D-12*EXP(190/TEMP))
  RCONST(1330) = (2.16D-11)
  RCONST(1331) = (J(41)+J(22))
  RCONST(1332) = (KDEC)
  RCONST(1333) = (1.57D-11)
  RCONST(1334) = (J(22))
  RCONST(1335) = (KNO3AL*4.0)
  RCONST(1336) = (2.56D-11)
  RCONST(1337) = (J(34))
  RCONST(1338) = (J(41)+J(35))
  RCONST(1339) = (1.90D-12*EXP(190/TEMP))
  RCONST(1340) = (5.99D-12)
  RCONST(1341) = (KDEC)
  RCONST(1342) = (KAPHO2*0.15)
  RCONST(1343) = (KAPHO2*0.41)
  RCONST(1344) = (KAPHO2*0.44)
  RCONST(1345) = (KAPNO)
  RCONST(1346) = (KFPAN)
  RCONST(1347) = (KRO2NO3*1.74)
  RCONST(1348) = (1.00D-11*0.3*RO2)
  RCONST(1349) = (1.00D-11*0.7*RO2)
  RCONST(1350) = (J(17))
  RCONST(1351) = (2.15D-11)
  RCONST(1352) = (KAPHO2*0.15)
  RCONST(1353) = (KAPHO2*0.41)
  RCONST(1354) = (KAPHO2*0.44)
  RCONST(1355) = (KAPNO)
  RCONST(1356) = (KFPAN)
  RCONST(1357) = (KRO2NO3*1.74)
  RCONST(1358) = (1.00D-11*0.3*RO2)
  RCONST(1359) = (1.00D-11*0.7*RO2)
  RCONST(1360) = (1.72D-12)
  RCONST(1361) = (J(41))
  RCONST(1362) = (4.80D-12)
  RCONST(1363) = (KBPAN)
  RCONST(1364) = (4.75D-13)
  RCONST(1365) = (2.89D-12)
  RCONST(1366) = (J(34))
  RCONST(1367) = (KAPHO2*0.56)
  RCONST(1368) = (KAPHO2*0.44)
  RCONST(1369) = (KAPNO)
  RCONST(1370) = (KFPAN)
  RCONST(1371) = (KRO2NO3*1.74)
  RCONST(1372) = (1.00D-11*RO2)
  RCONST(1373) = (1.44D-11)
  RCONST(1374) = (J(34)+J(35))
  RCONST(1375) = (KRO2HO2*0.52)
  RCONST(1376) = (KRO2NO)
  RCONST(1377) = (KRO2NO3)
  RCONST(1378) = (8.8D-13*RO2*0.6)
  RCONST(1379) = (8.8D-13*RO2*0.2)
  RCONST(1380) = (8.8D-13*RO2*0.2)
  RCONST(1381) = (0.4*0.52*KRO2HO2)
  RCONST(1382) = (0.6*0.52*KRO2HO2)
  RCONST(1383) = (0.05*KRO2NO)
  RCONST(1384) = (0.95*KRO2NO)
  RCONST(1385) = (KRO2NO3)
  RCONST(1386) = (2.0D-12*RO2*0.2)
  RCONST(1387) = (2.0D-12*RO2*0.6)
  RCONST(1388) = (2.0D-12*RO2*0.2)
  RCONST(1389) = (KDEC*0.24)
  RCONST(1390) = (KDEC*0.20)
  RCONST(1391) = (KDEC*0.20)
  RCONST(1392) = (KDEC*0.36)
  RCONST(1393) = (J(41))
  RCONST(1394) = (4.81D-12)
  RCONST(1395) = (KBPAN)
  RCONST(1396) = (1.21D-12)
  RCONST(1397) = (KAPHO2*0.44)
  RCONST(1398) = (KAPHO2*0.15)
  RCONST(1399) = (KAPHO2*0.41)
  RCONST(1400) = (KAPNO)
  RCONST(1401) = (KFPAN)
  RCONST(1402) = (KRO2NO3*1.74)
  RCONST(1403) = (1.00D-11*0.7*RO2)
  RCONST(1404) = (1.00D-11*0.3*RO2)
  RCONST(1405) = (KAPHO2*0.44)
  RCONST(1406) = (KAPHO2*0.15)
  RCONST(1407) = (KAPHO2*0.41)
  RCONST(1408) = (KAPNO)
  RCONST(1409) = (KFPAN)
  RCONST(1410) = (KRO2NO3*1.74)
  RCONST(1411) = (1.00D-11*0.7*RO2)
  RCONST(1412) = (1.00D-11*0.3*RO2)
  RCONST(1413) = (3.79D-12)
  RCONST(1414) = (KAPHO2*0.44)
  RCONST(1415) = (KAPHO2*0.15)
  RCONST(1416) = (KAPHO2*0.41)
  RCONST(1417) = (KAPNO)
  RCONST(1418) = (KFPAN)
  RCONST(1419) = (KRO2NO3*1.74)
  RCONST(1420) = (1.00D-11*0.7*RO2)
  RCONST(1421) = (1.00D-11*0.3*RO2)
  RCONST(1422) = (KRO2HO2*0.706)
  RCONST(1423) = (KRO2NO)
  RCONST(1424) = (KRO2NO3)
  RCONST(1425) = (9.20D-14*RO2)
  RCONST(1426) = (KRO2HO2*0.706)
  RCONST(1427) = (KRO2NO)
  RCONST(1428) = (KRO2NO3)
  RCONST(1429) = (8.80D-13*RO2)
  RCONST(1430) = (1.32D-11*0.728)
  RCONST(1431) = (1.32D-11*0.272)
  RCONST(1432) = (J(41))
  RCONST(1433) = (2.43D-12)
  RCONST(1434) = (1.80D+13*(TEMP/298)**1.7*EXP(-4079/TEMP))
  RCONST(1435) = (1.80D+13*(TEMP/298)**1.7*EXP(-4733/TEMP))
  RCONST(1436) = (9.60D-12)
  RCONST(1437) = (KAPHO2*0.15)
  RCONST(1438) = (KAPHO2*0.41)
  RCONST(1439) = (KAPHO2*0.44)
  RCONST(1440) = (KAPNO)
  RCONST(1441) = (KFPAN)
  RCONST(1442) = (KRO2NO3*1.74)
  RCONST(1443) = (1.00D-11*RO2*0.3)
  RCONST(1444) = (1.00D-11*RO2*0.7)
  RCONST(1445) = (KDEC*0.18)
  RCONST(1446) = (KDEC*0.82)
  RCONST(1447) = (KRO2HO2*0.625)
  RCONST(1448) = (KRO2NO)
  RCONST(1449) = (KRO2NO3)
  RCONST(1450) = (9.20D-14*RO2*0.7)
  RCONST(1451) = (9.20D-14*RO2*0.3)
  RCONST(1452) = (1.37D-11)
  RCONST(1453) = (J(41))
  RCONST(1454) = (KDEC)
  RCONST(1455) = (2.49D-12)
  RCONST(1456) = (J(41))
  RCONST(1457) = (5.57D-12*0.68)
  RCONST(1458) = (5.57D-12*0.32)
  RCONST(1459) = (KBPAN)
  RCONST(1460) = (1.97D-12)
  RCONST(1461) = (3.70D-12)
  RCONST(1462) = (J(56)+J(57))
  RCONST(1463) = (6.78D-12)
  RCONST(1464) = (J(56)+J(57))
  RCONST(1465) = (J(41))
  RCONST(1466) = (3.18D-12)
  RCONST(1467) = (J(56)+J(57))
  RCONST(1468) = (KBPAN)
  RCONST(1469) = (KAPHO2*0.15)
  RCONST(1470) = (KAPHO2*0.41)
  RCONST(1471) = (KAPHO2*0.44)
  RCONST(1472) = (KAPNO)
  RCONST(1473) = (KFPAN)
  RCONST(1474) = (KRO2NO3*1.74)
  RCONST(1475) = (1.00D-11*0.3*RO2)
  RCONST(1476) = (1.00D-11*0.7*RO2)
  RCONST(1477) = (KAPHO2*0.15)
  RCONST(1478) = (KAPHO2*0.41)
  RCONST(1479) = (KAPHO2*0.44)
  RCONST(1480) = (KAPNO)
  RCONST(1481) = (KFPAN)
  RCONST(1482) = (KRO2NO3*1.74)
  RCONST(1483) = (1.00D-11*0.3*RO2)
  RCONST(1484) = (1.00D-11*0.7*RO2)
  RCONST(1485) = (KAPHO2*0.15)
  RCONST(1486) = (KAPHO2*0.41)
  RCONST(1487) = (KAPHO2*0.44)
  RCONST(1488) = (KAPNO)
  RCONST(1489) = (KFPAN)
  RCONST(1490) = (KRO2NO3*1.74)
  RCONST(1491) = (1.00D-11*0.3*RO2)
  RCONST(1492) = (1.00D-11*0.7*RO2)
  RCONST(1493) = (2.53D-11*0.86)
  RCONST(1494) = (2.53D-11*0.14)
  RCONST(1495) = (J(17))
  RCONST(1496) = (J(15))
  RCONST(1497) = (KAPHO2*0.15)
  RCONST(1498) = (KAPHO2*0.41)
  RCONST(1499) = (KAPHO2*0.44)
  RCONST(1500) = (KAPNO)
  RCONST(1501) = (KFPAN)
  RCONST(1502) = (KRO2NO3*1.74)
  RCONST(1503) = (KRO2NO3*1.74)
  RCONST(1504) = (1.00D-11*0.3*RO2)
  RCONST(1505) = (1.00D-11*0.7*RO2)
  RCONST(1506) = (J(17))
  RCONST(1507) = (J(22))
  RCONST(1508) = (2.73D-11)
  RCONST(1509) = (J(41))
  RCONST(1510) = (1.04D-11)
  RCONST(1511) = (KBPAN)
  RCONST(1512) = (6.80D-12)
  RCONST(1513) = (4.11D-12)
  RCONST(1514) = (J(41))
  RCONST(1515) = (5.10D-13)
  RCONST(1516) = (KBPAN)
  RCONST(1517) = (J(41))
  RCONST(1518) = (KAPHO2*0.56)
  RCONST(1519) = (KAPHO2*0.44)
  RCONST(1520) = (KAPNO)
  RCONST(1521) = (KFPAN)
  RCONST(1522) = (KRO2NO3*1.74)
  RCONST(1523) = (1.00D-11*RO2)
  RCONST(1524) = (KAPHO2*0.56)
  RCONST(1525) = (KAPHO2*0.44)
  RCONST(1526) = (KAPNO)
  RCONST(1527) = (KFPAN)
  RCONST(1528) = (KRO2NO3*1.74)
  RCONST(1529) = (1.00D-11*RO2)
  RCONST(1530) = (1.66D-12)
  RCONST(1531) = (J(41))
  RCONST(1532) = (4.74D-12)
  RCONST(1533) = (KBPAN)
  RCONST(1534) = (1.14D-12)
  RCONST(1535) = (1.23D-12*0.32)
  RCONST(1536) = (1.23D-12*0.68)
  RCONST(1537) = (4.31D-12*0.09)
  RCONST(1538) = (4.31D-12*0.91)
  RCONST(1539) = (J(41))
  RCONST(1540) = (7.10D-13)
  RCONST(1541) = (KBPAN)
  RCONST(1542) = (J(41))
  RCONST(1543) = (9.43D-12)
  RCONST(1544) = (KBPAN)
  RCONST(1545) = (5.83D-12)
  RCONST(1546) = (4.77D-11)
  RCONST(1547) = (J(41))
  RCONST(1548) = (KDEC)
  RCONST(1549) = (6.22D-11)
  RCONST(1550) = (1.36D-10)
  RCONST(1551) = (J(15)*2)
! RCONST(1552) = constant rate coefficient
  RCONST(1553) = (J(41))
  RCONST(1554) = (J(15))
  RCONST(1555) = (2.92D-11)
  RCONST(1556) = (KDEC)
  RCONST(1557) = (J(41))
  RCONST(1558) = (6.50D-12)
  RCONST(1559) = (J(41)*2)
  RCONST(1560) = (9.58D-12)
  RCONST(1561) = (J(41))
  RCONST(1562) = (KBPAN)
  RCONST(1563) = (5.98D-12)
  RCONST(1564) = (1.36D-12)
  RCONST(1565) = (J(41))
  RCONST(1566) = (4.08D-12)
  RCONST(1567) = (KBPAN)
  RCONST(1568) = (4.85D-13)
  RCONST(1569) = (KAPHO2*0.15)
  RCONST(1570) = (KAPHO2*0.41)
  RCONST(1571) = (KAPHO2*0.44)
  RCONST(1572) = (KAPNO)
  RCONST(1573) = (KFPAN)
  RCONST(1574) = (KRO2NO3*1.74)
  RCONST(1575) = (1.00D-11*0.3*RO2)
  RCONST(1576) = (1.00D-11*0.7*RO2)
  RCONST(1577) = (3.04D-12)
  RCONST(1578) = (J(41))
  RCONST(1579) = (6.12D-12)
  RCONST(1580) = (KBPAN)
  RCONST(1581) = (2.52D-12)
  RCONST(1582) = (4.30D-11)
  RCONST(1583) = (J(41))
  RCONST(1584) = (J(17))
  RCONST(1585) = (KDEC)
  RCONST(1586) = (5.74D-11)
  RCONST(1587) = (J(41))
  RCONST(1588) = (J(15))
  RCONST(1589) = (KDEC)
  RCONST(1590) = (2.98D-11)
  RCONST(1591) = (J(17))
  RCONST(1592) = (1.93D-11)
  RCONST(1593) = (J(17))
  RCONST(1594) = (3.85D-12)
  RCONST(1595) = (J(56)+J(57))
  RCONST(1596) = (5.25D-12)
  RCONST(1597) = (J(22))
  RCONST(1598) = (2.67D-11)
  RCONST(1599) = (J(17))
  RCONST(1600) = (1.84D-11)
  RCONST(1601) = (1.99D-11)
  RCONST(1602) = (J(41))
  RCONST(1603) = (2.90D-11)
  RCONST(1604) = (KBPAN)
  RCONST(1605) = (1.20D-15)
  RCONST(1606) = (1.00D-14)
  RCONST(1607) = (1.00D-15)
  RCONST(1608) = (7.00D-14)
  RCONST(1609) = (6.00D-18*H2O)
  RCONST(1610) = (4.17D-11)
  RCONST(1611) = (J(17))
  RCONST(1612) = (J(41))
  RCONST(1613) = (KDEC)
  RCONST(1614) = (3.82D-11)
  RCONST(1615) = (J(17))
  RCONST(1616) = (4.93D-12)
  RCONST(1617) = (J(56)+J(57))
  RCONST(1618) = (8.01D-12)
  RCONST(1619) = (J(41))
  RCONST(1620) = (J(56)+J(57))
  RCONST(1621) = (4.41D-12)
  RCONST(1622) = (J(56)+J(57))
  RCONST(1623) = (KBPAN)
  RCONST(1624) = (3.69D-12)
  RCONST(1625) = (J(41)+J(35))
  RCONST(1626) = (1.02D-13)
  RCONST(1627) = (KBPAN)
  RCONST(1628) = (7.40D-12)
  RCONST(1629) = (1.09D-11)
  RCONST(1630) = (J(41))
  RCONST(1631) = (7.26D-12)
  RCONST(1632) = (KBPAN)
  RCONST(1633) = (1.72D-12)
  RCONST(1634) = (5.18D-12)
  RCONST(1635) = (J(41))
  RCONST(1636) = (1.58D-12)
  RCONST(1637) = (KBPAN)
  RCONST(1638) = (1.73D-12)
  RCONST(1639) = (5.19D-12)
  RCONST(1640) = (J(41))
  RCONST(1641) = (1.59D-12)
  RCONST(1642) = (KBPAN)
  RCONST(1643) = (KAPHO2*0.44)
  RCONST(1644) = (KAPHO2*0.15)
  RCONST(1645) = (KAPHO2*0.41)
  RCONST(1646) = (KAPNO)
  RCONST(1647) = (KFPAN)
  RCONST(1648) = (KRO2NO3*1.74)
  RCONST(1649) = (1.00D-11*0.7*RO2)
  RCONST(1650) = (1.00D-11*0.3*RO2)
  RCONST(1651) = (KAPHO2*0.44)
  RCONST(1652) = (KAPHO2*0.15)
  RCONST(1653) = (KAPHO2*0.41)
  RCONST(1654) = (KAPNO)
  RCONST(1655) = (KFPAN)
  RCONST(1656) = (KRO2NO3*1.74)
  RCONST(1657) = (1.00D-11*0.7*RO2)
  RCONST(1658) = (1.00D-11*0.3*RO2)
  RCONST(1659) = (6.52D-12)
  RCONST(1660) = (6.52D-12*0.39)
  RCONST(1661) = (6.52D-12*0.61)
  RCONST(1662) = (J(41))
  RCONST(1663) = (6.00D-12)
  RCONST(1664) = (KBPAN)
  RCONST(1665) = (8.64D-12)
  RCONST(1666) = (J(41)*2)
  RCONST(1667) = (5.04D-12)
  RCONST(1668) = (KBPAN)
  RCONST(1669) = (J(41))
  RCONST(1670) = (5.66D-12)
  RCONST(1671) = (J(41))
  RCONST(1672) = (1.96D-12)
  RCONST(1673) = (KBPAN)
  RCONST(1674) = (2.16D-11)
  RCONST(1675) = (J(17))
  RCONST(1676) = (2.47D-11)
  RCONST(1677) = (J(41))
  RCONST(1678) = (J(17))
  RCONST(1679) = (2.11D-11)
  RCONST(1680) = (KBPAN)
  RCONST(1681) = (J(17))
  RCONST(1682) = (KAPHO2*0.44)
  RCONST(1683) = (KAPHO2*0.15)
  RCONST(1684) = (KAPHO2*0.41)
  RCONST(1685) = (KAPNO)
  RCONST(1686) = (KFPAN)
  RCONST(1687) = (KRO2NO3*1.74)
  RCONST(1688) = (1.00E-11*0.7*RO2)
  RCONST(1689) = (1.00E-11*0.3*RO2)
  RCONST(1690) = (KAPHO2*0.44)
  RCONST(1691) = (KAPHO2*0.56)
  RCONST(1692) = (KAPNO)
  RCONST(1693) = (KFPAN)
  RCONST(1694) = (KRO2NO3*1.74)
  RCONST(1695) = (1.00D-11*RO2)
  RCONST(1696) = (J(53))
  RCONST(1697) = (J(34))
  RCONST(1698) = (KNO3AL*2.4)
  RCONST(1699) = (1.24D-11)
  RCONST(1700) = (J(56)+J(57))
  RCONST(1701) = (9.35D-13)
  RCONST(1702) = (J(41))
  RCONST(1703) = (J(56)+J(57))
  RCONST(1704) = (4.02D-12)
  RCONST(1705) = (1.30D-13)
  RCONST(1706) = (J(56))
  RCONST(1707) = (J(57))
  RCONST(1708) = (J(35))
  RCONST(1709) = (KBPAN)
  RCONST(1710) = (J(56)+J(57))
  RCONST(1711) = (4.15D-13)
  RCONST(1712) = (1.36D-11)
  RCONST(1713) = (J(34))
  RCONST(1714) = (KAPHO2*0.44)
  RCONST(1715) = (KAPHO2*0.56)
  RCONST(1716) = (KAPNO)
  RCONST(1717) = (KFPAN)
  RCONST(1718) = (KRO2NO3*1.74)
  RCONST(1719) = (1.00D-11*RO2)
  RCONST(1720) = (2.23D-11)
  RCONST(1721) = (J(15))
  RCONST(1722) = (2.59D-11)
  RCONST(1723) = (J(41))
  RCONST(1724) = (J(15))
  RCONST(1725) = (2.18D-11)
  RCONST(1726) = (J(15))
  RCONST(1727) = (KBPAN)
  RCONST(1728) = (KAPHO2*0.15)
  RCONST(1729) = (KAPHO2*0.41)
  RCONST(1730) = (KAPHO2*0.44)
  RCONST(1731) = (KAPNO)
  RCONST(1732) = (KFPAN)
  RCONST(1733) = (KRO2NO3*1.74)
  RCONST(1734) = (1.00D-11*0.3*RO2)
  RCONST(1735) = (1.00D-11*0.7*RO2)
  RCONST(1736) = (KDEC)
! RCONST(1737) = constant rate coefficient
! RCONST(1738) = constant rate coefficient
  RCONST(1739) = (J(41))
! RCONST(1740) = constant rate coefficient
  RCONST(1741) = (KBPAN)
  RCONST(1742) = (7.33D-11)
  RCONST(1743) = (J(41))
  RCONST(1744) = (6.97D-11)
  RCONST(1745) = (KBPAN)
  RCONST(1746) = (KRO2HO2*0.520)
  RCONST(1747) = (KRO2NO)
  RCONST(1748) = (KRO2NO3)
  RCONST(1749) = (2.00D-12*RO2)
  RCONST(1750) = (2.78D-11)
  RCONST(1751) = (J(41))
  RCONST(1752) = (KDEC)
  RCONST(1753) = (6.00E-34*O2*O2*((TEMP/300)**-2.6)+5.60E-34*O2*N2*((TEMP/300)**-2.6))
  RCONST(1754) = (8.00E-12*EXP(-2060/TEMP))
  RCONST(1755) = (KMT01)
  RCONST(1756) = (5.50E-12*EXP(188/TEMP))
  RCONST(1757) = (KMT02)
  RCONST(1758) = (3.20E-11*O2*EXP(67/TEMP)+1.80E-11*N2*EXP(107/TEMP))
  RCONST(1759) = (1.40E-12*EXP(-1310/TEMP))
  RCONST(1760) = (1.40E-13*EXP(-2470/TEMP))
  RCONST(1761) = (3.30E-39*EXP(530/TEMP)*O2)
  RCONST(1762) = (1.80E-11*EXP(110/TEMP))
  RCONST(1763) = (4.50E-14*EXP(-1260/TEMP))
  RCONST(1764) = (KMT03)
  RCONST(1765) = (KMT04)
  RCONST(1766) = (2.20E-10*H2O)
  RCONST(1767) = (1.70E-12*EXP(-940/TEMP))
  RCONST(1768) = (7.70E-12*EXP(-2100/TEMP))
  RCONST(1769) = (1.44E-13*KMT05)
  RCONST(1770) = (2.90E-12*EXP(-160/TEMP))
  RCONST(1771) = (2.03E-16*((TEMP/300)**4.57)*EXP(693/TEMP))
  RCONST(1772) = (4.80E-11*EXP(250/TEMP))
  RCONST(1773) = (2.20E-13*KMT06*EXP(600/TEMP)+1.90E-33*M*KMT06*EXP(980/TEMP))
  RCONST(1774) = (KMT07)
  RCONST(1775) = (KMT08)
  RCONST(1776) = (2.00E-11*EXP(0./TEMP))
  RCONST(1777) = (3.60E-12*EXP(270/TEMP))
  RCONST(1778) = (KMT09)
  RCONST(1779) = (KMT10+j(1300))
  RCONST(1780) = (3.20E-12*EXP(690/TEMP))
  RCONST(1781) = (4.00E-12*EXP(0./TEMP))
  RCONST(1782) = (2.50E-12*EXP(260/TEMP))
  RCONST(1783) = (KMT11)
  RCONST(1784) = (4.00E-32*EXP(-1000/TEMP)*M)
  RCONST(1785) = (KMT12)
  RCONST(1786) = (1.30E-12*EXP(-330/TEMP)*O2)
  RCONST(1787) = (J(1))
  RCONST(1788) = (J(2))
  RCONST(1789) = (J(3))
  RCONST(1790) = (J(4))
  RCONST(1791) = (J(5))
  RCONST(1792) = (J(6))
  RCONST(1793) = (J(7))
  RCONST(1794) = (J(8))
  RCONST(1795) = (1./BLH)
  RCONST(1796) = (1./BLH)
  RCONST(1797) = (1./BLH)
  RCONST(1798) = (1./BLH)
  RCONST(1799) = (1./BLH)
  RCONST(1800) = (1./BLH)
  RCONST(1801) = (1./BLH)
  RCONST(1802) = (DEPVEL/BLH)
  RCONST(1803) = (DEPVEL*0.5/BLH)
  RCONST(1804) = (DEPVEL*2/BLH)
  RCONST(1805) = (DEPVEL*0.5/BLH)
      
END SUBROUTINE Update_RCONST

! End of Update_RCONST function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Update_PHOTO - function to update photolytical rate constants
!   Arguments :
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE Update_PHOTO ( )


   USE model_Global

      
END SUBROUTINE Update_PHOTO

! End of Update_PHOTO function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



END MODULE model_Rates

