C***********************************************************************
C
C                     HFODD Main Source
C
C***********************************************************************
C
      BLOCK DATA List_of_modules
C=======================================================================
      USE hfodd_sizes
C=======================================================================
      CHARACTER NAMODU*16,NAMMOD*16
      COMMON /LIMODU/ MODORD(NDMODU),NAMODU(NDMODU),MODVER(NDMODU),
     *                MODTOT
      COMMON /VERMOD/ NAMMOD(NDMODU),MODUVE(NDMODU),MODSET(NDMODU)
      DATA  MODTOT /18/
      DATA (MODORD(NUMODU),NAMODU(NUMODU),MODVER(NUMODU),
     *      NUMODU=1,NDMODU)
C
C***********************************************************************
C    This version requires the following versions of modules:
C***********************************************************************
C                    Module number, Module name      , Module version
     *              /      1      ,'hfodd_sizes     ',    9  ,
     *                     2      ,'hfodd_modules   ',    68 ,
     *                     3      ,'hfodd_hfbtho    ',    201,
     *                     4      ,'hfodd_interface ',    5  ,
     *                     5      ,'hfodd_functional',    5  ,
     *                     6      ,'hfodd_mpiio     ',    6  ,
     *                     7      ,'hfodd_mpimanager',    6  ,
     *                     8      ,'hfodd_shell     ',    6  ,
     *                     9      ,'hfodd_SLsiz     ',    4  ,
     *                    10      ,'hfodd_fission   ',    23 ,
     *                    11      ,'hfodd_pairs     ',    2  ,
     *                    12      ,'hfodd_pnp       ',    16 ,
     *                    13      ,'hfodd_fits      ',    16 ,
     *                    14      ,'hfodd_lipcorr   ',    54 ,
     *                    15      ,'hfodd_tgrad     ',    25 ,
     *                    16      ,'hfodd_wigner    ',    6  ,
     *                    17      ,'hfodd_adiabatic ',    19 ,
     *                    18,      'hfodd_twocen    ',    55 ,
     *                    19,      '                ',    0  ,
     *                    20,      '                ',    0  /
C
      END BLOCK DATA List_of_modules
C
C***********************************************************************
C
C    Copyright 2021, J. Dobaczewski, P. Baczyk, P. Becker, M. Bender,
C                    K. Bennaceur, J. Bonnard, Y. Gao, A. Idini,
C                    M. Konieczka, M. Kortelainen, L. Prochniak,
C                    A.M. Romero, W. Satula, Y. Shi, T.R. Werner, and
c                    L.F. Yu
C    Copyright 2016, N. Schunck, J. Dobaczewski, W. Satula, P. Baczyk,
C                    J. Dudek, Y. Gao, M. Konieczka, K. Sato, Y. Shi,
C                    X.B. Wang, T.R. Werner
C    Copyright 2012, N. Schunck, J. Dobaczewski, J. McDonnell,
C                    W. Satula, J.A. Sheikh, A. Staszczak,
C                    M. Stoitsov, P. Toivanen
C    Copyright 2009, J. Dobaczewski, W. Satula, B.G. Carlsson, J. Engel,
C                    P. Olbratowski, P. Powalowski, M. Sadziak,
C                    J. Sarich, N. Schunck, A. Staszczak, M. Stoitsov,
C                    M. Zalewski, H. Zdunczuk
C    Copyright 2004, 2005, J. Dobaczewski, P. Olbratowski
C    Copyright 1997, 2000, J. Dobaczewski, J. Dudek
C
C    This file is part of HFODD.
C
C    HFODD is free software: you can redistribute it and/or modify it
C    under the terms of the GNU General Public License as published by
C    the Free Software Foundation, either version 3 of the License, or
C    (at your option) any later version.
C
C    HFODD is distributed in the hope that it will be useful, but
C    WITHOUT ANY WARRANTY; without even the implied warranty of
C    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
C    GNU General Public License for more details.
C
C    You should have received a copy of the GNU General Public License
C    along with HFODD. If not, see <http://www.gnu.org/licenses/>.
C
C***********************************************************************
C                                                                      !
C Authors:                                                             !
C                                                                      !
C   J. Dobaczewski, P. Baczyk, P. Becker, M. Bender,                   !
C   K. Bennaceur, J. Bonnard, B.G. Carlsson, J. Dudek,                 !
C   J. Engel, Y. Gao, A. Idini, M. Konieczka,                          !
C   M. Kortelainen, T. Lesinski, J. Mcdonnell,                         !
C   P. Olbratowski, P. Powalowski, L. Prochniak,                       !
C   A.M. Romero, M. Sadziak, J. Sarich, K. Sato,                       !
C   A. Sanchez Fernandez, W. Satula, N. Schunck,                       !
C   J.A. Sheikh, Y. Shi, A. Staszczak, M. Stoitsov,                    !
C   X. Sun, P. Toivanen, B.C. Tumelero Backes,                         !
C   X.B. Wang, T.R. Werner, H. Wibowo, L.F. Yu,                        !
C   M. Zalewski, and H. Zdunczuk                                       !
C                                                                      !
C Publications:                                                        !
C                                                                      !
C  [1] J. Dobaczewski and J. Dudek,                                    !
C      Comput. Phys. Commun. 102, 166 (1997).                          !
C  [2] J. Dobaczewski and J. Dudek,                                    !
C      Comput. Phys. Commun. 102, 183 (1997).                          !
C  [3] J. Dobaczewski and J. Dudek,                                    !
C      Comput. Phys. Commun. 131, 164 (2000).                          !
C  [4] J. Dobaczewski and P. Olbratowski,                              !
C      Comput. Phys. Commun. 158, 158 (2004).                          !
C  [5] J. Dobaczewski and P. Olbratowski,                              !
C      Comput. Phys. Commun. 167, 214 (2005).                          !
C  [6] J. Dobaczewski, W. Satula, B.G. Carlsson, J. Engel,             !
C      P. Olbratowski, P. Powalowski, M. Sadziak, J. Sarich,           !
C      N. Schunck, A. Staszczak, M. Stoitsov, M. Zalewski,             !
C      and H. Zdunczuk,                                                !
C      Comput. Phys. Commun. 180, 2361 (2009).                         !
C  [7] N. Schunck, J. Dobaczewski, J. McDonnell, W. Satula,            !
C      J.A. Sheikh, A. Staszczak, M. Stoitsov, and P. Toivanen,        !
C      Comput. Phys. Commun. 183, 166 (2012).                          !
C  [8] N. Schunck, J. Dobaczewski, W. Satula, P. Baczyk, J. Dudek,     !
C      Y. Gao, M. Konieczka, K. Sato, Y. Shi, X.B. Wang, T.R. Werner,  !
C      Comput. Phys. Commun. 216, 145 (2017).                          !
C  [9] J. Dobaczewski, P. Baczyk, P. Becker, M. Bender, K. Bennaceur,  !
C      J. Bonnard, Y. Gao, A. Idini, M. Konieczka, M. Kortelainen,     !
C      L. Prochniak, A.M. Romero, W. Satula, Y. Shi, T.R. Werner,      !
C      L.F. Yu, submitted to J. Phys. G, arXiv:2104.08255              !
C                                                                      !
C User's Guide (v.240h)                                                !
C                                                                      !
C      J. Dobaczewski, W. Satula, B.G. Carlsson, J. Engel,             !
C      P. Olbratowski, P. Powalowski, M. Sadziak, J. Sarich,           !
C      N. Schunck, A. Staszczak, M. Stoitsov, M. Zalewski, and         !
C      H. Zdunczuk, HFODD (v2.40h) User's Guide: arXiv:0909.3626 (2009)!
C                                                                      !
C=======================================================================
C      HFODD     HFODD     HFODD     HFODD     HFODD     HFODD     HFODD
C=======================================================================
C
C      HFODD  SOLVES THE NUCLEAR HARTREE-FOCK OR HARTREE-FOCK-BOGOLYUBOV
C             PROBLEM WITHOUT ASSUMING PLANE-REFLECTION OR TIME-REVERSAL
C             SYMMETRIES
C
C=======================================================================
C
C         HFODD - HISTORY OF DEVELOPMENT
C
C         WERSJA118.DATA0212 - NAGRANA PRZED WYJAZDEM ZE STRASBURGA
C         WERSJA119.DATA0221 - ROZNE DROBNE POPRAWKI
C         WERSJA120.DATA0225 - URUCHOMIENIE SPIN-ORBITY
C         WERSJA121.DATA0228 - CALKOWANIE Z KWADRATURA RZEDU 2*N+2
C         WERSJA122.DATA0311 - ELEMENTY MACIERZOWE KULOMBA
C         WERSJA123.DATA0320 - CZLON POWIERZCHNIOWY KULOMBA
C         WERSJA124.DATA0604 - ZMIANA ORGANIZACJI ITERACJI ORAZ JY
C         WERSJA125.DATA0605 - KRECENIE W BLOKU "+"
C         WERSJA126.DATA0608 - POCZATEK PROGRAMOWANIA DWU BLOKOW "T"
C         WERSJA127.DATA0626 - PRZENIESIENIE NA CRAYA I WEKTORYZACJA
C         WERSJA128.DATA0702 - URUCHOMIENIE PELNEGO HF ODDT
C         WERSJA129.DATA0822 - WERSJA POSREDNIA UZYWANA W OAK RIDGE
C         WERSJA130.DATA1028 - LICZENIE MOMENTOW MULTIPOLOWYCH
C         WERSJA131.DATA1105 - MULTIPOLE W KULOMBIE NA POWIERZCHNI PUDLA
C         WERSJA132.DATA1110 - PRZETESTOWANIE KULOMBA
C         WERSJA133.DATA1120 - SREDNI JOT I PELNA SAMOZGODNOSC ODD-T
C
C                             N O W Y    R O K    1 9 9 4
C
C         WERSJA134.DATA0113 - CZYTANIE DANYCH I ROZPEMPIENIE ENERGII
C         WERSJA135.DATA0120 - KWADRATOWY WIONZ NA SPIN I LICZNE WYDRUKI
C         WERSJA136.DATA0122 - WYDRUK ALIGNMENTOW
C         WERSJA137.DATA0123 - POPRAWIENIE WEKTORYZACJI SKFILD I DENMAT
C         WERSJA138.DATA0126 - WPROWADZENIE OPCJI BEZROTACYJNEJ
C         WERSJA139.DATA0130 - URUCHOMIENIE PAIRINGU
C         WERSJA140.DATA0131 - WYPUSZCZANIE WYNIKOW NA REVIEW FILE
C         WERSJA141.DATA0215 - LABELKI NILSONA I WYLONCZANIE CZLONOW ODD
C         WERSJA142.DATA0608 - BLOKOWANIE KONFIGURACJI W BLOKACH P-S
C         WERSJA143.DATA0613 - WYDRUK ENERGII S-P W JEDNYM FLAKU
C         WERSJA144.DATA0624 - KOPIOWANIE GESTOSCI W PUDLE 1/8 NA 7/8
C         WERSJA145.DATA0625 - WYDRUK I ZAPIS W REVIEW LABELEK "SPORDE"
C         WERSJA146.DATA0714 - ZMIANA NAZWY NA HFODD I INNE MALE ZMIANY
C
C                             N O W Y    R O K    1 9 9 5
C
C         PROGRAM BYL TAK DOBRY, ZE A.D. 1995 NICZEGO NIE ZMIENIONO!
C
C                             N O W Y    R O K    1 9 9 6
C
C         WERSJA147.DATA0112 - UNIFIKACJA OKTUPOLA Z NIEOKTUPOLEM
C         WERSJA148.DATA0123 - SYMETRYZACJA PUDLA DLA ROZNYCH SYMETRII
C         WERSJA149.DATA0124 - DODANIE PIONTEGO MULTIPOLA
C         WERSJA150.DATA0129 - DODANIE SREDNICH PROMIENI I XYZ-ROZMIAROW
C         WERSJA151.DATA0131 - WEKTORYZACJA PROCEDUR INTCEN, INTSOR, ...
C         WERSJA152.DATA0202 - BLOKOWANIE HAMILTONIANU DLA ISIGNY=1
C         WERSJA153.DATA0204 - PORZONDNE WYDRUKI CZASOW CPU
C         WERSJA154.DATA0208 - WSTAWIENIE PREDEFINICJI DO SUBRUTYNY
C         WERSJA155.DATA0215 - START Z POTENCJALU NILSSONA
C         WERSJA156.DATA0303 - ZMNIEJSZENIE PAMIECI
C         WERSJA157.DATA0320 - ROZPEMPIENIE TRZECH LICZB MULTIPOLI
C         WERSJA158.DATA0322 - WCZYTYWANIE PARAMETROW NILSSONA (JACEK)
C         WERSJA158.DATA0322 - LICZENIE MULTIPOLI DO RZENDU=9 (JUREK)
C         WERSJA160.DATA0412 - UZGODNIENIE DWU WERSJI 1.58
C         WERSJA161.DATA???? - TEJ WERSJI NIKT NIGDY NIGDZIE NIE WIDZIAL
C         WERSJA162.DATA???? - POPRAWIANIE WIENZOW METODOM NEWTONA
C         WERSJA163.DATA1117 - WERSJA Z FAJLU Cray_hf/hf63.vect.big.f
C         WERSJA164.DATA1119 - WERSJA ROBOCZA UZGADNIANA Z CPC HF60P.F
C         WERSJA165.DATA1210 - WERSJA UZGODNIONA Z CPC HF60P.F & CLEANED
C         WERSJA166.DATA1214 - WERSJA REFERENCE PRZED HFB I/LUB TILTED J
C
C                             N O W Y    R O K    1 9 9 7
C
C         WERSJA167.DATA0102 - ZAPIS FAJLU FILCOU+ZAPIS DP_RHO NA FILREC
C         WERSJA168.DATA0517 - UNIKANIE PING-PONGU I DIABATYCZNOSC
C         WERSJA169.DATA0523 - LICZENIE G-PAIRING JAK W FUNNY HILLS
C         WERSJA170.DATA0527 - ZBIEZNOSC SRODKOW MASY I Q21 DO ZERA
C
C         BIFURKACJA WERSJI !!!!!
C
C         WERSJA170A.DATA0829- DIABATYCZNOSC Z OKTUPOLEM
C         WERSJA170D.DATA0901- DIABATYCZNOSC WE WSZYSTKICH BLOKACH NARAZ
C         WERSJA170E.DATA0903- REDUKCJA LICZBY WYWOLAN ANGYSP
C         WERSJA170F.DATA1020- JEDNOCZASTKOWE MOMENTY I PROMIENIE
C         WERSJA170G.DATA1021- BEZPIECZNIK NA OBSERWABLE W DIA-BLOKCKING
C         WERSJA170H.DATA1031- SKROCENIE LINII NA FAJLU FILREV
C         WERSJA170I.DATA1112- POPRAWIENIE BYKA W LICZENIU DENLPS
C         WERSJA170J.DATA1129- DODANIE ZHPEV Z NETLIB
C         WERSJA170K.DATA1202- UNIKANIE CHAOTYCZNEJ NIEZBIEZNOSCI
C
C                             N O W Y    R O K    1 9 9 8
C
C         WERSJA175F.DATA0725- OPARTA NA 1.77D, DO PUBLIKACJI W CPC
C
C         WERSJA175.DATA0709 - OPARTA NA 1.70K, DO PUBLIKACJI W CPC
C         WERSJA176.DATA0709 - IDENTYCZNA Z 1.75, PRZED ZROBIENIEM HFB
C         WERSJA177.DATA0714 - POPRAWIENIE "PHASES" I ZROBIENIE "DIAMAT"
C         WERSJA178.DATA0723 - URUCHOMIENIE HFB
C
C                             N O W Y    R O K    1 9 9 9
C
C         WERSJA175I.DATA0702- WYDRUK BET
C         WERSJA175L.DATA0903- POPRAWIENIE WOLANIA MACIERZY PRZEZ GLOWE
C         WERSJA175M.DATA0915- POPRAWIENIE BYKA W SKALOWANIU
C         WERSJA175N.DATA1126- UAKTUALNIENIE ZAPISOW W RECORD
C         WERSJA175O.DATA1214- USUNIECIE NEWTONA
C         WERSJA175P.DATA1216- USUNIECIE FILNEW I FILQLM
C
C         WERSJA179.DATA0702 - WYDRUK BET
C         WERSJA180.DATA1015 - UZGODNIONA Z WERSJA 1.75M
C         WERSJA181.DATA1127 - USUNIECIE MACIERZY IPHASE
C         WERSJA182.DATA1216 - USUNIECIE NEWTONA
C
C                             N O W Y    R O K    2 0 0 0
C
C         WERSJA183.DATA0211 - POCHYLENIE OSI
C         WERSJA184.DATA0304 - PELNE ZLAMANIE WSZYSTKICH SYMETRII
C         WERSJA185.DATA0703 - MULTIPOLE W UKLADZIE SRODKA MASY
C         WERSJA186.DATA0704 - MOMENTY PEDU W UKLADZIE SRODKA MASY
C         WERSJA187.DATA0710 - USUNIECIE BYKOW W LAMANIU SYMPLEKSU
C         WERSJA188.DATA1221 - MULTIPOLE W UKLADZIE WEWNETRZNYM
C
C                             N O W Y    R O K    2 0 0 1
C
C         WERSJA189.DATA0717 - MOMENTY SCHIFFA
C         WERSJA190.DATA0718 - CALKI GESTOSCI LAMIACYCH SYMETRIE
C         WERSJA191.DATA0722 - BETY W UKLADZIE SRODKA MASY I WEWNETRZNYM
C         WERSJA192.DATA1126 - ZACHOWANA TYLKO PARZYSTOSC - KADLUBEK
C         WERSJA193.DATA1220 - PELNA SPIN-ORBITA ORAZ PARAMETRY LANDAUA
C         WERSJA194.DATA1220 - MASA HBMASS ROZNA DLA ROZNYCH SIL SKYRMA
C         WERSJA195.DATA1228 - DWUCIALOWA POPRAWKA NA SRODEK MASY
C         WERSJA196.DATA1228 - KWADRATOWE WIENZY NA SPIN W 3 KIERUNKACH
C
C                             N O W Y    R O K    2 0 0 2
C
C         WERSJA197.DATA0122 - ZACHOWANA TYLKO PARZYSTOSC - PELNA WERSJA
C         WERSJA198.DATA0430 - ROZNE POPRAWKI I PRZEROBIENIE LANDAUA
C         WERSJA199.DATA0625 - CUTOFF PAIRINGU HFB W WIDMIE ROWNOWAZNYM
C         WERSJA200.DATA0711 - 8 NOWYCH OBSERWABLI W DIABATIC I HFBSIG
C         WERSJA201.DATA1108 - WIONZ NA OMEGA TIMES SPIN
C
C                             N O W Y    R O K    2 0 0 3
C
C         WERSJA202.DATA0113 - MOMENTY MAGNETYCZNE
C         WERSJA203.DATA0314 - WERSJA ZBIFURKOWANA OD WERSJI 2.02
C         WERSJA204.DATA0322 - PRZEORGANIZOWANIE PAMIECI NA F90
C         WERSJA205.DATA0407 - DODANIE ZHPEVX Z NETLIB
C         WERSJA206.DATA1219 - ZACHOWANIE SYGNATURY W COPDEN
C
C                             N O W Y    R O K    2 0 0 4
C
C         WERSJA207.DATA0102 - RUCHOMA OMEGA - OPCJA "IMOVAX"
C         WERSJA208.DATA0206 - OPARTA NA 2.07J, DO PUBLIKACJI W CPC
C         WERSJA209.DATA0211 - ELEMENTY MACIERZOWE POTENCJALU YUKAWY
C         WERSJA210.DATA0311 - WIENZY SKALARNE
C         WERSJA211.DATA0715 - LICZENIE ELEMENTOW MACIERZOWYCH PAIRINGU
C         WERSJA212.DATA1202 - LICZENIE 1D ELEMENTOW MACIERZOWYCH GOGNY
C         WERSJA213.DATA1226 - ENERGIA WPROST I WYMIENNA YUKAWY
C
C                             N O W Y    R O K    2 0 0 5
C
C         WERSJA214.DATA0126 - DELTY PAIRINGOWE ZALEZNE OD STANU
C         WERSJA215.DATA0208 - OBRACANIE FUNKCJI FALOWYCH
C         WERSJA216.DATA0322 - PENSURFACE MOMENTS OBLICZANE DLA IDOPLM=1
C         WERSJA217.DATA0407 - HFB BEZ ZADNYCH ZACHOWANYCH SYMETRII
C         WERSJA218.DATA0520 - OBRACANIE MOMENTOW I MOMENTOW PEDU
C         WERSJA219.DATA0522 - DOKLADNE DEFORAMCJE BETA BOHRA
C         WERSJA220.DATA1027 - WIENZY NA MOMENTY SCHIFFA
C         WERSJA221.DATA1215 - RZUTOWANIE NA MOMENT PEDU
C
C                             N O W Y    R O K    2 0 0 6
C
C         WERSJA222.DATA0203 - ZREDUKOWANE ELEMENTY MACIERZOWE PRZEJSC
C         WERSJA223.DATA0217 - TRANSFORMACJE D2H FUNKCJI FALOWYCH
C         WERSJA224.DATA0224 - ROWNOLEGLE OBLICZENIA KERNELI
C         WERSJA225.DATA0330 - MIESZANIE K
C
C                             N O W Y    R O K    2 0 0 7
C
C         WERSJA226.DATA0226 - BLOKOWANIE KWAZICZASTEK W WERSJI SIMPLEKS
C         WERSJA227.DATA0322 - BLOKOWANIE I HFB WE WSZYSTKICH SYMETRIACH
C         WERSJA228.DATA0619 - IMPLEMENTACJA PROCEDUR BLAS==JASON SARICH
C         WERSJA229.DATA0628 - WPROWADZENIE NUMEROW FAJLI INPUT I OUTPUT
C         WERSJA230.DATA0803 - POPRAWKI LIPKINA-NOGAMI
C         WERSJA231.DATA0808 - IMPLEMENTACJA ZHEEVR, AUTOR==JASON SARICH
C         WERSJA232.DATA1119 - FILLING APPROXIMATION
C
C                             N O W Y    R O K    2 0 0 8
C
C         WERSJA233.DATA0207 - REDUCED MATRIX ELEMENTS OF SCHIFF MOMENTS
C         WERSJA234.DATA0321 - DOKLADNA WYMIANA KULOMBOWSKA PROGRAMOWANA
C         WERSJA235.DATA0322 - BROYDEN METHOD==N. SCHUNCK & M. STOITSOV
C         WERSJA236.DATA0929 - DOKLADNA WYMIANA KULOMBOWSKA  WYTESTOWANA
C         WERSJA237.DATA1018 - BLOKOWANIE WZGL USTALONEJ FUNKCJI FALOWEJ
C         WERSJA238.DATA1216 - PRZYSPIESZENIE DELT  ZALEZNYCH  OD  STANU
C
C                             N O W Y    R O K    2 0 0 9
C
C         WERSJA239.DATA0306 - IDENTYCZNA Z 2.38J, POSLANA DO PUBLIKACJI
C         WERSJA240.DATA0611 - BROYDEN METHOD DEBUGGED FOR LIPKIN-NOGAMI
C         WERSJA241.DATA0813 - IDENTYCZNA Z 2.40H, POSLANA DO PUBLIKACJI
C         WERSJA242.DATA0816 - USUNIETA  MOZLIWOSC  UZYWANIA  FORTRAN-77
C         WERSJA243.DATA1020 - METODA DWU BAZ (TWO-BASIS) W HFB NO--SYMM
C         WERSJA244.DATA1109 - AUGMENTED LAGRANGIAN (STOITSOV&STASZCZAK)
C         WERSJA245.DATA1225 - POPRAWIONE PARAMETRY SIL SLY4, SLY5, SLY7
C
C                             N O W Y    R O K    2 0 1 0
C
C         WERSJA246.DATA0310 - OAK RIDGE FEATURES ADDED, NICOLAS SCHUNCK
C         WERSJA247.DATA0314 - CoM CORRECTIONS WITH PAIRING, P. TOIVANEN
C         WERSJA248.DATA0507 - ROTATIONAL CORRECTION - PROGRAMING STARTD
C         WERSJA249.DATA0720 - OAK RIDGE FEATURES ADDED, NICOLAS SCHUNCK
C
C                             N O W Y    R O K    2 0 1 1
C
C         WERSJA250.DATA0625 - IDENTYCZNA Z OPUBLIKOWANA 249S 26/02/2011
C         WERSJA251.DATA0830 - THE PROTON-NEUTRON MIXING WITHOUT PAIRING
C         WERSJA252.DATA1216 - THE PROTON-NEUTRON MIXING &SIMPLEX BROKEN
C
C                             N O W Y    R O K    2 0 1 2
C
C         WERSJA253.DATA0320 - URUCHOMIENIE I WYTESTOWANIE SIL GOGNY'EGO
C         WERSJA254.DATA0520 - ZAKODOWANIE REGULARYZOWANYCH SIL SKYRME'A
C         WERSJA255.DATA0716 - TROJWYMIAROWE RZUTOWANIE NA DOBRY IZOSPIN
C         WERSJA256.DATA1107 - TESTOWANIE RZUTOWANIA 3D NA DOBRY IZOSPIN
C
C                             N O W Y    R O K    2 0 1 3
C
C         WERSJA265.DATA0620 - FULL NLO REGULARIZED INTERACTION EXCPT SO
C         WERSJA266.DATA0714 - FULL N2LO REGULARIZED INTERACTION & NO SO
C         WERSJA267.DATA0809 - PARTICLE NUMBER PROJECTION BY T. LESINSKI
C         WERSJA268.DATA0815 - AVERAGE VALUES OF THE ISOSPINS BY K. SATO
C         WERSJA269.DATA1207 - ROTATIONAL AND TRANSLAT. CORR. BY Y.  GAO
C
C                             N O W Y    R O K    2 0 1 4
C
C         WERSJA270.DATA1002 - HIGHER-ORDER LIPKIN CORRECTIONS, X.B.WANG
C
C                             N O W Y    R O K    2 0 1 5
C
C         WERSJA271.DATA0113 - PRZYGOTOWYWANA DO PUBLIKACJI,  270V+270AD
C         WERSJA272.DATA0419 - CHARGE SYMMETRY BREAKING,BACZYK-KONIECZKA
C         WERSJA273.DATA0504 - PAIRING CHANNEL  FOR  REGULARIZED  FORCES
C         WERSJA274.DATA0509 - PFAFFIAN PROJECTION OF HFB STATES, Y. GAO
C         WERSJA275.DATA0606 - SKYRME TENSOR INTERACTION AND "F" DENSITY
C
C                             N O W Y    R O K    2 0 1 6
C
C         WERSJA276.DATA0316 - PAIRING FOR REGULARIZED  FORCES  DEBUGGED
C         WERSJA277.DATA0320 - SKYRME TENSOR DEBUGGED BACZYK & KONIECZKA
C         WERSJA278.DATA1011 - PAIRING FOR NO SYMMETR. AND REGUL. FORCES
C
C                             N O W Y    R O K    2 0 1 7
C
C         WERSJA279.DATA0408 - TESTING THE SKYRME - PAIRING  BY  LINGFEI
C         WERSJA280.DATA0415 - SUM OF PROTON AND NEUTRON MAGNETIC MOMENT
C         WERSJA281.DATA0701 - REDUCED SCHIFF ME'S FOR PROJECTED  STATES
C         WERSJA282.DATA0717 - KARIM'S QUASPARTCLE FORMULA FOR STABILITY
C         WERSJA283.DATA0729 - VERSNS. 248WF AND 282 SUCCESSFULLY MERGED
C         WERSJA284.DATA1212 - ALIGNMENT OCCUPATIONS AND PARITY OVERLAPS
C
C                             N O W Y    R O K    2 0 1 8
C
C         WERSJA285.DATA0416 - AXIALIZATION OF THE CODE BY PIERRE BECKER
C         WERSJA286.DATA0916 - 3-BODY GRADIENTS AND ISB NLO SKYRME TERMS
C         WERSJA287.DATA1126 - PROJECTION OF BLOCKED HFB STATE, YUAN GAO
C
C                             N O W Y    R O K    2 0 1 9
C
C         WERSJA288.DATA0215 - BETAS IN REVIEW FILE, NON-DOMINANT LABELS
C         WERSJA289.DATA0310 - SEPARABLE GENERATORS WITH  ANTONIO ROMERO
C         WERSJA290.DATA0426 - WIGNER D FUNCTIONS BY Y.SHI&PRE 92,043307
C         WERSJA291.DATA0709 - WIGNER AND SEPARABLE GENERATORS  DEBUGGED
C         WERSJA292.DATA1123 - MULTI-GAUSS SEPARAB FORCE & BASIS(CONSTR)
C
C                             N O W Y    R O K    2 0 2 0
C
C         WERSJA293.DATA0212 - POCZATEK PRACY NAD  PN-MIXING FOR PAIRING
C         WERSJA294.DATA0328 - WIECEJ   PRACY NAD  PN-MIXING FOR PAIRING
C         WERSJA295.DATA0406 - PLUS WIECEJ PRACY W PN-MIXING FOR PAIRING
C         WERSJA296.DATA0608 - PROJEKTY ROZWIJANE: PN-MIX, J2, AMP4BLOCK
C         WERSJA297.DATA0713 - SKONCZONE J2 PO RZUTOWANIU NA MOMENT PEDU
C         WERSJA298.DATA0803 - HFB/HF JEDYNIE DLA NEUTRONOW LUB PROTONOW
C         WERSJA299.DATA0813 - PNP (TOTAL) IN PROANG WITH JEREMY BONNARD
C         WERSJA300.DATA1007 - MULTI-QUASIP BLOCKING WITH JEREMY BONNARD
C         WERSJA301.DATA1125 - PRZYGOTOWYWANA DO PUBLIKACJI, KOPIA 3.00U
C
C                             N O W Y    R O K    2 0 2 1
C
C         WERSJA302.DATA0118 - PNP (TOTAL) IN PROANG DEBUGGED & FINISHED
C         WERSJA303.DATA0124 - ZAPIS/CZYTANIE DEFORMACJI BAZY NA/Z DYSKU
C         WERSJA304.DATA0316 - NIEDIAGONALNY KERNEL/BLOCKING (J.BONNARD)
C         WERSJA305.DATA0513 - PRZYGOTOWYWANA DO PUBLIKACJI, KOPIA 3.04S
C         WERSJA306.DATA0517 - PRZYGOTOWYWANA DO PUBLIKACJI, KOPIA 3.05E
C         WERSJA307.DATA0908 - KOPIA OMYLKOWO WERSJI 3.06A ZAMIAST 3.06H
C         WERSJA308.DATA1127 - ZGRANIE 3.07U Z ROZNICAMI 3.06A --- 3.06H
C         WERSJA309.DATA1212 - PRZYSPIESZENIE AXIALIZACJI: CZYNNIK OSIEM
C
C                             N O W Y    R O K    2 0 2 2
C
C         WERSJA310.DATA0108 - MOMENTY MAGNETYZACJI >HYPERFINE SPLITTING
C         WERSJA311.DATA0125 - DIAGONALIZACJA MULTI-REFERENCE(J.BONNARD)
C         WERSJA312.DATA0422 - PFAFFIANS FOR CONSERVED PARITY(J.BONNARD)
C         WERSJA313.DATA0516 - CONSTRAINTS ON ISOVECT. MULTIPOLE MOMENTS
C         WERSJA314.DATA0823 - MULTI-REFERENCE MIXING (1) WITH J.BONNARD
C         WERSJA315.DATA1019 - BEGIN TWO-CENTRE WORK W/ A. SANCHEZ ET AL
C         WERSJA316.DATA1202 - BEGIN ADIABATIC WORK  WITH  X. SUN  ET AL
C
C                             N O W Y    R O K    2 0 2 3
C
C         WERSJA317.DATA0203 - THE TWO-CENTRE & ADIABATIC WORK CONTINUES
C         WERSJA318.DATA0307 - INTRINSIC & SPECT. SPIN-ASYMMETRY MOMENTS
C         WERSJA319.DATA0525 - THE TWO-CENTRE & ADIABATIC WORK CONTINUES
C         WERSJA320.DATA0731 - MULTI-REFERENCE MIXING (2) WITH J.BONNARD
C         WERSJA321.DATA1030 - THE 3D-AMP AND <J_Y> BUGS HAVE BEEN FIXED
C         WERSJA322.DATA1127 - NEW GOGNY & PAIRING NO-SIMPLEX B.T.BACKES
C
C                             N O W Y    R O K    2 0 2 4
C
C         WERSJA323.DATA0207 - INTRINSIC TWO-BODY-CURRENTS WIBOWO&BACKES
C         WERSJA324.DATA0221 - FINITE-RANGE SO&TENSOR ENERGY K.BENNACEUR
C         WERSJA325.DATA0428 - NILSSON LABELS  FOR  QUASIPARTICLE STATES
C         WERSJA326.DATA0621 - COAXIAL TWO-CENTER HO A.SANCHEZ-FERNANDEZ
C         WERSJA327.DATA0627 - QUADRUPLE PRECISION FOR GOGNY N0>20 CALC.
C         WERSJA328.DATA0823 - COMPLETE  TWO-BODY CURRENTS WIBOWO&BACKES
C         WERSJA329.DATA1020 - MULTI-REFERENCE MIXING DEBUGGED BY  X.SUN
C         WERSJA330.DATA1123 - FINITE-RANGE SPIN-ORBIT&TENSOR PROGRAMMED
C         WERSJA331.DATA1127 - FINITE-RANGE SPIN-ORBIT & TENSOR DEBUGGED
C         WERSJA332.DATA1206 - TWO-BODY CURRENTS DEBUGGED  WIBOWO&BACKES
C
C                             N O W Y    R O K    2 0 2 5
C
C         WERSJA333.DATA0215 - TWO-BODY CURRENTS FINAL HAN&WIBOWO&BACKES
C
C=======================================================================
C         ATTENTION: BUGS KNOWN IN THE PUBLISHED VERSION HF306H
C=======================================================================
C                 1. BETWEEN  VERSIONS  (3.00K)  AND  (3.07),  CHARACTER
C                    VARIABLES  "ERRSTR"  WERE  WRITTEN   WITH   STRINGS
C                    CONTAINING "FIXED/INITLZD" THAT  WERE  69-CHARACTER
C                    LONG WHILE "ERRSTR" WAS DECLARED 68-CHARACTER LONG.
C                    THIS WAS CRASHING  THE  CODE  WHEN  THESE  SPECIFIC
C                    ERROR MESSAGES WERE SUPPOSED TO BE PRINTED. THE BUG
C                    WAS CORRECTED ON 09/09/2021 IN VERSION (3.07A).
C                    MORE SIMILAR BUGS WERE  CORRECTED  ON  27/01/24  IN
C                    VERSION (3.22P).
C
C                 2. BETWEEN VERSIONS (2.97J) AND (3.07B), THE CONDITION
C                    TO CALL  "SAVLIP"  DID  NOT  INCLUDE  THE  TEST  OF
C                    "MPAHFB".  AS  A  RESULT,  AFTER  IMPLEMENTING  THE
C                    DYNAMIC DOWNGRADE OF HFB TO HF, "SAVLIP"  COULD  BE
C                    CALLED IN AN HF RUN, WHICH WAS CAUSING THE CODE  TO
C                    CRASH  ON  THE  SEGMENTATION  FAULT. THIS  BUG  WAS
C                    CORRECTED ON 25/09/2021 IN VERSIONS (3.07C).
C
C                 3. BETWEEN VERSIONS (2.97J) AND (3.07B), THE CONDITION
C                    BELOW TO  GRAB  THE  LIKIN-NOGAMI  ARRAYS  DID  NOT
C                    INCLUDE THE TEST OF "MPAHFB". AS  A  RESULT,  AFTER
C                    IMPLEMENTING THE DYNAMIC DOWNGRADE OF  HFB  TO  HF,
C                    IN AN HF RUN THE CODE WAS  STOPPING. THIS  BUG  WAS
C                    PRESENT IN SEVEN INSTANCES HERE AND BELOW, AND  WAS
C                    CORRECTED ON 25/09/2021 IN VERSIONS (3.07C).
C
C                 4. BETWEEN VERSIONS (2.83G) AND (3.07C), ARRAY  M_OCCU
C                    WAS OVERWRITEN IN CONSIZ AFTER THE CALL TO  AXISIZ.
C                    THIS COULD HAVE CAUSED  PROBLEMS  WHEN  M_OCCU  WAS
C                    USED AGAIN IN AXISIZ IN THE NEXT ITERATION. THE BUG
C                    WAS CORRECTED ON 19/10/2021 IN VERSION (3.07D).
C
C                 5. BETWEEN VERSIONS (2.80B) AND (3.07C), ARRAY  K_OCCU
C                    WAS OVERWRITEN IN CONSIQ AFTER THE CALL TO  AXISIQ.
C                    THIS COULD HAVE CAUSED  PROBLEMS  WHEN  K_OCCU  WAS
C                    USED AGAIN IN AXISIQ IN THE NEXT ITERATION. THE BUG
C                    WAS CORRECTED ON 19/10/2021 IN VERSION (3.07D).
C
C                 6. THE PUBLICATION OF VERSION (3.06H) IN J.  Phys.  G:
C                    Nucl. Part. Phys. 48 102001 CONTAINS ON PAGE 41  AN
C                    INCORRECT DESCRIPTION OF  THE  KERNEL  FILE  NAMES,
C                    WHICH SHOULD READ:
C                    For ISAKER = 2 and IPAKER = 1 (see section VI-3.2
C                    [6]), for all values of indices 't' the code
C                    attempts to read the kernel files
C                    Nxxxxxt-LyyRzz-//FILKER,
C                    where // denotes concatenated strings. The one-,
C                    two- or five-digit indices are:
C                    > 'xxxxx' is the consecutive index of the kernel
C                      file, which is equal to KFIKER (see section
C                      VII-3.2 [7]).
C                    > 't' is the number from 0 to 9 of the consecutive
C                      file having the given index 'xxxxx'.
C                    > 'yy' is the number of the  left wave function.
C                    > 'zz' is the number of the right wave function.
C
C                 7. AFTER THE  MAGNETIC  MOMENTS  WERE  INPLEMENTED  IN
C                    VERSION (2.02), VARIABLE "NMUPOW" WAS NOT  PROPERLY
C                    UPDATED AND IT WAS LEFT  EQUAL  TO  THE  NUMBER  OF
C                    MULTIPOLE MOMENTS "NMUMAX",  WHEREAS  TO  DETERMINE
C                    THE ORBITAL ANGULAR MOMENTUM IN "INTORB", IT SHOULD
C                    HAVE BEEN EQUAL TO AT LEAST "NMAMAX"+1.  THEREFORE,
C                    FOR "NMUMAX"<="NMAMAX"  THE  CODE  COULD  NOT  WORK
C                    CORRECTLY. THIS BUG WAS CORRECTED ON 15/12/2021  IN
C                    VERSION (3.09H).
C
C                 8. UP TO VERSION (3.10B), FOR PARITY  PROJECTION,  THE
C                    REDUCED MATRIX ELEMENTS OF THE PARITY-ODD MULTIPOLE
C                    AND SURFACE OPERATORS (THOSE FOR THE ODD VALUES  OF
C                    LAMBDA), AND  THOSE  OF  THE  PARITY-EVEN  MAGNETIC
C                    OPERATORS (THOSE FOR THE EVEN  VALUES  OF  LAMBDA),
C                    WERE INCORRECTLY CALCULATED INSTEAD  OF  BEING  SET
C                    TO ZERO. THIS BUG WAS CORRECTED  ON  25/01/2022  IN
C                    VERSION (3.10C).
C
C                 9. BETWEEN VERSIONS (3.06A) AND (3.10K), SAVING OF THE
C                    DATA UNDER KEYWORD 'GYROSC' IN SUBROUTINE  'REVIEW'
C                    WAS  CORRUPTING  THE  DATA  SAVED   UNDER   KEYWORD
C                    'QMULTI'. THIS BUG WAS CORRECTED ON  10/02/2022  IN
C                    VERSION (3.10L).
C
C                10. BETWEEN VERSIONS (2.49T) AND  (3.12A),  CALCULATION
C                    OF THE TRANSITION MATRIX ELEMENTS  OF  THE  SURFACE
C                    MOMENTS FOR LAMBDA=0 WAS  IMPLEMENTED  INCORRECTLY,
C                    BECAUSE SUBROUTINE MOMSIF WAS NOT SET TO  CALCULATE
C                    THEM. THIS  BUG  WAS  CORRECTED IN VERSION  (3.12D)
C                    ON 24/04/2022.
C
C                11. BETWEEN VERSIONS (3.06A) AND  (3.13N),  INFORMATION
C                    ON THE EFFECTIVE G-FACTORS  ("IGYROS")  USED  IN  A
C                    GIVEN RUN WAS NOT STORED ON THE KERNEL FILE.  AS  A
C                    CONSEQUENCE, THE FOLLOWING RUN THAT WAS READING THE
C                    THE KERNEL FILE AND USING DIFFERENT VALUES  OF  THE
C                    G-FACTORS WAS GIVING THE  PREVIOUS  VALUES  OF  THE
C                    MAGNETIC MOMENTS WITHOUT NOTIFYING  THE  USER. THIS
C                    BUG WAS CORRECTED ON 02/08/2022 IN VERSION (3.13O).
C
C                12. BETWEEN VERSIONS (2.99R) AND (3.15P), THE TREATMENT
C                    OF "NUQUVE" IN "QUABCS" WAS ACTIVE FOR ITWOBA=1 TOO
C                    AND ACTED ON TOP OF THAT IMPLEMENTED IN HFBSI_ WHEN
C                    THE TWO-BASIS METHOD WAS ACTIVE. ON  RARE  ANNOYING
C                    OCCASIONS, THIS WAS  CAUSING  PROBLEMS  IN  PROANG.
C                    THIS BUG WAS CORRECTED  ON  29/11/2022  IN  VERSION
C                    (3.15Q) WHEN THE ADDITIONAL "OCCLIM" CUTOFF WAS FOR
C                    ITWOBA=1 SWITCHED OFF ENTIRELY.  IN  ADDITION,  FOR
C                    ITWOBA=0, THE TREATMENT OF "NUQUVE" IN "QUABCS"  IS
C                    NOW  PERFORMED  INDEPENDENTLY  OF  "IPRGCM",  WHICH
C                    ENSURES A SMOOTH CONTINUATION BETWEEN THE RUNS WITH
C                    AND WITHOUT PROJECTION. THIS LATTER CORRECTION  MAY
C                    BECOME  RELEVANT  ONLY  IF  PROJECTIONS  COULD   BE
C                    PERFORMED WITHOUT THE TWO-BASIS METHOD.
C
C                13. BETWEEN VERSIONS (3.04Q) AND (3.16M), THE TREATMENT
C                    OF "NUQUVE" IN "HFBSIQ" WAS IMPLEMENTED  SO  AS  TO
C                    ENSURE AN EVEN TOTAL NUMBER  OF  STATES,  WITH  THE
C                    CASE OF ODD NUMBERS OF STATES IN BOTH PARITY BLOCKS
C                    LEFT TO BE ALLOWED. THAT CASE WAS  CAUSING  STRANGE
C                    WRONG RESULTS FOR THE PFAFFIAN NORMS OF AN  UNKNOWN
C                    ETIOLOGY. THIS BUG WAS CORRECTED ON  28/12/2022  IN
C                    VERSION (3.16N).
C
C                14. BETWEEN VERSIONS (2.50J) AND (3.18E),  THE  INDICES
C                    "IREVER" (THE THIRD INDICES) OF "BIG_PM" BELOW WERE
C                    ERRONOUSLY EXCHANGED. THIS BUG  WAS  AFFECTING  THE
C                    PROTON-NEUTRON-MIXING  CALCULATIONS  PERFORMED  FOR
C                    THE BROKEN SIMPLEX SYMMETRY. THIS BUG WAS FOUND  BY
C                    ADRIAN SANCHEZ AND CORRECTED IN VERSION (3.18F)  ON
C                    31/03/2023.
C
C                15. BETWEEN VERSIONS 3.04K AND  3.18U,  THE  TRUE-SPACE
C                    POSITIONS DEFINED IN  SUBROUTINE  "REVIEW"  IN  THE
C                    VARIABLES "POSIT." WERE INCORRECTLY DIVIDED BY  THE
C                    FACTOR OF SQRT(2), WHILE THIS  FACTOR  HAS  ALREADY
C                    BEEN INCLUDED IN ARRAYS  "FOURPT"  DEFINED IN ARRAY
C                    "PNTACT" OF SUBROUTINE "DEFINT" FOR NOBODY=2.  THIS
C                    BUG WAS CORRECTED IN VERSION 3.18V ON 19/05/2023.
C
C                16. BETWEEN VERSIONS (2.98B) AND (3.20S), FOR IPAKER=1,
C                    AND AFTER READING THE KERNEL FILES IN "PROANG", THE
C                    KERNEL ARRAYS WERE NOT ZEROED.  HOWEVER,  BEGINNING
C                    WITH VERSION (2.98B), THE KERNELS WERE NOT  DEFINED
C                    BUT ADDITIONALLY SUMMED UP, SO AS TO INTEGRATE OVER
C                    THE PARTICLE NUMBERS AND PARITY. AS A  RESULT,  FOR
C                    IPAKER=1, THEIR VALUES STORED AT M=1 AND  K=1  WERE
C                    ERRONOUSLY PILING UP. THIS BUG WENT UNDETECTED  FOR
C                    A LONG TIME BECAUSE FOR THE  IPAKER=1  CALCULATIONS
C                    PERFORMED FOR SEPARATE VALUES OF M AND K,  THE  BUG
C                    WAS NOT  SHOWING  UP.  THE  BUG  WAS  CORRECTED  ON
C                    28/10/2023 IN VERSION (3.20T).
C
C                17. BETWEEN VERSIONS (2.78H) AND (3.22S), BUT  ALSO  IN
C                    THE PUBLISHED VERSION (2.73Y), SUBROUTINE ZDOTU  IN
C                    MODULES  "HFODD_LIPCORR_NN.F90"  WAS  CALLED   WITH
C                    INCORRECT ARGUMENTS AND THUS  COULD  WORK  PROPERLY
C                    ONLY FOR LDBASE=NDBASE. THIS  BUG  WAS  ERRATICALLY
C                    CAUSING SEGMENTATION FAULT FOR CALCULATIONS DONE IN
C                    SUBROUTINES  "LINAVR"  AND  "ROTAVR"  BELOW.  AFTER
C                    REMOVING ALL CALLS TO ZDOTU, THIS BUG WAS CORRECTED
C                    ON  06/02/2024  IN  VERSION  (3.22T),  WHICH   USES
C                    MODULE HFODD_LIPCORR_53.F90.
C
C                18. BETWEEN VERSIONS (1.91Z) AND (3.27L), THAT IS, ALSO
C                    IN ALL PUBLISHED VERSIONS AFTER (1.75R), THERE  WAS
C                    A POSSIBLE CONFLICT IN READING THE  SPIN-CONSTRAINT
C                    DATA FOR THE Y DIRECTION  (KARTEZ=2)  AS  THE  SAME
C                    DATA WERE READ UNDER  TWO  DIFFERENT  KEYWORDS.  IN
C                    ADDITION, UNDER BOTH KEYWORDS, THE VALUES WERE READ
C                    INDEPENDENTLY OF WHETHER THE CONSTRAINT WAS  ACTIVE
C                    OR NOT. THOSE  INCONSISTENCIES  WERE  CORRECTED  ON
C                    20/07/2024  IN  VERSION  (3.27M)  BY  REMOVING  THE
C                    POSSIBILITY TO USE KEYWORDS SPINCONSTR & SPICON_XYZ
C                    FOR KARTEZ=2 SIMULTANEOUSLY.
C
C                19. BETWEEN VERSIONS (2.87C) AND (3.33),  THERE  WAS  A
C                    BUG IN SAVING ON THE REVIEW FILE THE NILSSON LABELS
C                    FOR NON-DOMINATING NILSSON COMPONENTS, SEE  KEYWORD
C                    "ALLNILABS"
C                    THIS BUG WAW CORRECTED  ON
C                    15/02/2025  IN  VERSION  (3.33A).
C
C                20. BETWEEN VERSIONS (2.87C) AND (3.33),  THERE  WAS  A
C                    BUG IN SAVING ON THE REVIEW FILE THE NILSSON LABELS
C                    FOR NON-DOMINATING NILSSON COMPONENTS, SEE  KEYWORD
C                    "ALLNILABS". THE BUG WAS  IN  SUBROUTINE  "NILASP",
C                    WHERE THOSE LABELS WERE  INCORRECTLY  STORED.  THIS
C                    BUG WAS CORRECTED ON 15/02/2025 IN VERSION (3.33A).
C=======================================================================
C
#if(USE_FITS==1)
      SUBROUTINE HF_ODD(PARINP,NUMINP,PAROUT,NUMOUT, JADRO_NAME,
     *                  I_TYPE, DAT_SUFFIX)
      USE HFODD_FITS
#else
      PROGRAM HF_ODD
#endif
C=======================================================================
#if(USE_OPENMP==1)
      USE omp_lib
#endif
C=======================================================================
#if(USE_MPI==1)
      USE hfodd_mpiio
      USE hfodd_mpiManager
#endif
C=======================================================================
      USE hfodd_sizes
      USE HE_DEN
      USE FRAGFL
      USE WAVR_L
      USE SAVRIG
      USE hfodd_interface
      USE hfodd_hfbtho
      USE hfodd_fission_fragments
      USE hfodd_fission_interaction
      USE hfodd_fission_rotated_qp
      USE hfodd_fission_print
      USE hfodd_fission_version
      USE hfodd_pnp
      USE hfodd_tgrad
      USE hfodd_twocen
      USE BLOSAV
      USE colcoord
C=======================================================================
      PARAMETER (NDMORD=3)
      PARAMETER (NDF2BC=5)
      PARAMETER (NDFSTA=3)
C=======================================================================
#if(USE_SCALAPACK==1)
      USE hfodd_SLsiz
#endif
C=======================================================================
      IMPLICIT INTEGER(I-N)
      IMPLICIT REAL(A-H,O-Z)
C=======================================================================
C
      CHARACTER
     *          SKYRME*4,GOGNAM*4,VERSIO*5
      CHARACTER
     *          FILREP*68,FILREC*68,FILWOO*68,
     *          FILREV*68,FILCOU*68,FILISO*68,FILWAV*68,FILKER*68,
     *          FILYUP*68,FILYUC*68,
     *          FILGOP*68,FILGOC*68,
     *          FILGPP*68,FILGPC*68,
     *          FILROP*68,FILROC*68,
     *          FILLIP*68,FILLIC*68,
     *          FILFIP*68,FILFIC*68,
     *          FILFER*68,FILQUA*68,
     *          FILBAP*68,FILBAC*68,
     *          FILRED*68
      CHARACTER
     *          NAMMUL*45,NAMSIF*45,NAMSUR*45,NAMSCH*45,
     *          NAMPLM*45,NAMMAG*45,NAMASM*45
      CHARACTER
     *          NAMHAR*17,NAMSHI*17,NAMROT*17
      CHARACTER
     *          NAMEPN*8
      CHARACTER
     *          SPMODL*14,ANGLEC*8,ESTABC*12,QROT2C*8
      CHARACTER
     *          MYDATE*8,MYTIME*10,MYZONE*5
C@@@ HFBTHO - HFBTHO - HFBTHO - HFBTHO - HFBTHO - HFBTHO - HFBTHO
      CHARACTER
     *          FILTHO*30
C@@@ HFBTHO - HFBTHO - HFBTHO - HFBTHO - HFBTHO - HFBTHO - HFBTHO
C
      LOGICAL
     *          PRINIT,PRIYUK,PRIBET
      LOGICAL
     *          TERMNT,COR_CM,CORROT
      LOGICAL
     *          DOPUSH,DOSYMM,do_debug,name_file,do_symmetrize
      LOGICAL
     *          REA2PP
C
      COMPLEX
     *          ALPHAC(0:NDLAMB,-NDLAMB:+NDLAMB)
      COMPLEX
     *          EKEKIN,EKEPAI,EKESKY,EKECOD,EKECOE,EKESCA,EKEVEC,EKEGOG,
     *          EKEREG,EKESEP,EKPSCA,EKPVEC,EKEFSO,EKEFTO,EKEFTE
      COMPLEX
     *          QMUT_N,QMUT_P,QMUT_T
      COMPLEX
     *          AMUT_N,AMUT_P,AMUT_T
      COMPLEX
     *          SMUT_N,SMUT_P,SMUT_T
      COMPLEX
     *          WMUT_N,WMUT_P,WMUT_T
      COMPLEX
     *          A2BCIN,A2BCSA
      COMPLEX
     *          QMUT_I
      COMPLEX
     *          CERMTS,CHRMTS,CDHRMT
      COMPLEX
     *          DKINSN,DKINSP,DKINST,
     *          EKINSN,EKINSP,EKINST,
     *          PKINSN,PKINSP,PKINST,
     *          TKINSN,TKINSP,TKINST,
     *          AKINLN,AKINLP,AKINLT,
     *          PKINLN,PKINLP,PKINLT,
     *          PKINKN,PKINKP,PKINKT
      COMPLEX
     *          DKOTSN,DKOTSP,DKOTST,
     *          EKOTSN,EKOTSP,EKOTST,
     *          PKOTSN,PKOTSP,PKOTST,
     *          TKOTSN,TKOTSP,TKOTST,
     *          AKOTLN,AKOTLP,AKOTLT,
     *          PKOTLN,PKOTLP,PKOTLT,
     *          PKOTKN,PKOTKP,PKOTKT
      COMPLEX
     *          EGOGSP,EGOGVP
      COMPLEX
     *          EREGSP,EREGVP
      COMPLEX
     *          ESEPSP,ESEPVP
      COMPLEX
     *          EFSOSP,EFTOSP,EFTESP
      COMPLEX
     *          E3BEVE,E3BODD
      COMPLEX
     *          E4BEVE,E4BODD
      COMPLEX
     *          FR2CBR,FS2CBR,FR3CBR,FS3CBR,
     *          FT2CBR,FK2CBR,FT3CBR,FK3CBR,
     *          FL2CBR,FP2CBR,FL3CBR,FP3CBR,
     *          FC2CBR,FJ2CBR,FC3CBR,FJ3CBR
      COMPLEX
     *          F_KT_L,F_KT_R,C_KT_L
      COMPLEX
     *          C_ZERO
C
      DIMENSION
     *          QMUT_I(0:NDMULT,-NDMULT:NDMULT)
      DIMENSION
     *          QMUL_I(0:NDMULT,-NDMULT:NDMULT)
      DIMENSION
     *          MYVALU(8)
      DIMENSION
     *          IN_EXC(ND_EXC)
      DIMENSION
     *          Q_COPY(0:NDMULT,-NDMULT:NDMULT)
      DIMENSION
     *          QACTUA(0:NDMULT,-NDMULT:NDMULT),
     *          QORIGI(0:NDMULT,-NDMULT:NDMULT),
     *          QINCRE(0:NDMULT,-NDMULT:NDMULT)
      DIMENSION
     *          IND2HF(0:NDISOS)
      DIMENSION
     *          INSIZN(1:NDBLOC),IDSIZN(1:NDBLOC),
     *          INSIZP(1:NDBLOC),IDSIZP(1:NDBLOC)
      DIMENSION
     *          INSIQN(1:NDBLOC),IPSIQN(1:NDBLOC),IDSIQN(1:NDBLOC),
     *          INSIQP(1:NDBLOC),IPSIQP(1:NDBLOC),IDSIQP(1:NDBLOC)
      DIMENSION
     *          INMIZA(1:NDBLOC),IDMIZA(1:NDBLOC)
      DIMENSION
     *          INMIQA(1:NDBLOC),IPMIQA(1:NDBLOC),IDMIQA(1:NDBLOC)
      DIMENSION
     *          IREMQB(1:NDBLOC),INUMQB(1:NDBLOC),JNUMQB(1:NDBLOC)
      DIMENSION
     *          KPAHFB(0:NDISOS)
C=======================================================================
      allocatable SFACTO(:,:)
C=======================================================================
C@@@ SHELL - SHELL - SHELL - SHELL - SHELL - SHELL - SHELL - SHELL
      DIMENSION
     *          IZNUCL(1:NDNUCL),INNUCL(1:NDNUCL)
      DIMENSION
     *          DSHELP(1:NDNUCL),DSHELN(1:NDNUCL)
C@@@ SHELL - SHELL - SHELL - SHELL - SHELL - SHELL - SHELL - SHELL
C@@@ HFBTHO - HFBTHO - HFBTHO - HFBTHO - HFBTHO - HFBTHO - HFBTHO
      Logical :: initial_pair_THO, set_temper_THO, force_parity_THO,
     *           HFODD_to_HFBTHO
C
      Integer :: Nshell_THO, neutron_THO, proton_THO, type_THO,
     *           niter_THO, restart_THO, coulomb_THO, useTHO_THO,
     *           gauge_THO, projection_THO, dN_THO, dZ_THO, output_THO,
     *           numGauss_THO, numLaguerre_THO, numLegendre_THO,
     *           nstate_THO, unit_tho
      Integer :: n_blocking_THO(1:5), p_blocking_THO(1:5),
     *           lambda_THO(1:8), active_THO(1:8)
C
      Real :: b0_THO, bz_THO, bp_THO, beta0_THO,
     *        accuracy_THO, VpairN_THO, VpairP_THO,
     *        temper_THO, b2_THO, b4_THO, Ecut_THO,
     *        V1_THO
      Real :: expect_THO(1:8), multLag_tho(1:8)
C
      Character(Len=30) :: functional_THO
C
      Character(Len=30) :: file_THO
C@@@ HFBTHO - HFBTHO - HFBTHO - HFBTHO - HFBTHO - HFBTHO - HFBTHO
C@@@ OPENMP - OPENMP - OPENMP - OPENMP - OPENMP - OPENMP - OPENMP
#if(USE_OPENMP==1)
      integer :: numThreads
#endif
C@@@ OPENMP - OPENMP - OPENMP - OPENMP - OPENMP - OPENMP - OPENMP
C=======================================================================
C@@@ MPI - MPI - MPI - MPI - MPI - MPI - MPI - MPI - MPI - MPI - MPI
C
      integer, dimension(:), pointer :: LAMPUS, MIUPUS
C
      REAL, dimension(:), pointer :: QMOPUS
C
      integer, dimension(:), pointer :: LAM_WS, MIU_WS
      integer, dimension(:), pointer :: L_COLL, M_COLL
C
#if(USE_MPI==1)
      integer :: mpi_err, n_proc, mpi_activ
      integer :: color, intkey, printTopology
      integer :: escapeSignal
      integer :: batch_init
C
      integer :: worldGroup, groupMasters, mastersCOMM,
     *                       groupSlaves, slavesCOMM, tribeCOMM
      integer :: tribeRank, slaveRank, masterRank, worldRank
      integer :: tribeSize, slaveSize, masterSize, worldSize
      integer :: counter_eval, syst_cnt, syst_rate
C
      integer, dimension(:), pointer :: LAMBAS, MIUBAS
C
      integer, dimension(:), allocatable :: my_evals, all_evals
      integer, dimension(:), allocatable :: rankMasters
#if(USE_SCALAPACK==1)
      integer :: n_tribe, n_color
      integer, dimension(:), allocatable :: all_tribeRank, all_color,
     *                                      all_worldRank
#endif
C
      Real :: cput_start, cput_end, syst_start, syst_end
      Real, dimension(:), allocatable ::
     *                  my_cputime, all_cputimes
C
      Real, dimension(:), pointer :: BETBAS
C
      character(len=16) :: FILOUT
      character(len=18) :: filsum
      character(len=68) :: optimal, courant
      character(len=150) :: commande
C
      COMMON
     *       /MPICOM/ worldGroup, groupMasters, groupSlaves,
     *                mastersCOMM, slavesCOMM, tribeCOMM
      COMMON
     *       /MPIPRO/ numberMasters, numberHFODDproc, color,
     *                tribeRank, slaveRank, masterRank, worldRank,
     *                tribeSize, slaveSize, masterSize, worldSize
#endif
C@@@  - MPI - MPI - MPI - MPI - MPI - MPI - MPI - MPI - MPI - MPI
C=======================================================================
C
#if(USE_FITS==1)
      DIMENSION :: PARINP(NUMINP),PAROUT(NUMOUT)
      CHARACTER :: JADRO_NAME*5
      CHARACTER :: DAT_SUFFIX*7
      INTEGER :: I_TYPE
#endif
      DIMENSION
     *          GOG_SD(NDGOGA,0:NDISOS,0:NDISOS),
     *          GOG_VD(NDGOGA,0:NDISOS,0:NDISOS),
     *          GOG_SE(NDGOGA,0:NDISOS,0:NDISOS),
     *          GOG_VE(NDGOGA,0:NDISOS,0:NDISOS)
      COMMON
     *       /GOGFOR/ GOGSTR(NDGOGA,NDFORC),GOGWID(NDGOGA),NUGOGA
      COMMON
     *       /GAUSIN/ GAU_X0(0:NDOSCI,0:NDOSCI,0:NDOSCI,0:NDOSCI),
     *                GAU_Y0(0:NDOSCI,0:NDOSCI,0:NDOSCI,0:NDOSCI),
     *                GAU_Z0(0:NDOSCI,0:NDOSCI,0:NDOSCI,0:NDOSCI),
     *
     *                GAU_X1(0:NDOSCI,0:NDOSCI,0:NDOSCI,0:NDOSCI),
     *                GAU_Y1(0:NDOSCI,0:NDOSCI,0:NDOSCI,0:NDOSCI),
     *                GAU_Z1(0:NDOSCI,0:NDOSCI,0:NDOSCI,0:NDOSCI),
     *
     *                GAU_X2(0:NDOSCI,0:NDOSCI,0:NDOSCI,0:NDOSCI),
     *                GAU_Y2(0:NDOSCI,0:NDOSCI,0:NDOSCI,0:NDOSCI),
     *                GAU_Z2(0:NDOSCI,0:NDOSCI,0:NDOSCI,0:NDOSCI),
     *
     *                GAU_X4(0:NDOSCI,0:NDOSCI,0:NDOSCI,0:NDOSCI),
     *                GAU_Y4(0:NDOSCI,0:NDOSCI,0:NDOSCI,0:NDOSCI),
     *                GAU_Z4(0:NDOSCI,0:NDOSCI,0:NDOSCI,0:NDOSCI),
     *
     *                GAU_X6(0:NDOSCI,0:NDOSCI,0:NDOSCI,0:NDOSCI),
     *                GAU_Y6(0:NDOSCI,0:NDOSCI,0:NDOSCI,0:NDOSCI),
     *                GAU_Z6(0:NDOSCI,0:NDOSCI,0:NDOSCI,0:NDOSCI),
     *
     *                GAUX21(0:NDOSCI,0:NDOSCI,0:NDOSCI,0:NDOSCI),
     *                GAUY21(0:NDOSCI,0:NDOSCI,0:NDOSCI,0:NDOSCI),
     *                GAUZ21(0:NDOSCI,0:NDOSCI,0:NDOSCI,0:NDOSCI),
     *
     *                GAUX22(0:NDOSCI,0:NDOSCI,0:NDOSCI,0:NDOSCI),
     *                GAUY22(0:NDOSCI,0:NDOSCI,0:NDOSCI,0:NDOSCI),
     *                GAUZ22(0:NDOSCI,0:NDOSCI,0:NDOSCI,0:NDOSCI),
     *
     *                GAUX41(0:NDOSCI,0:NDOSCI,0:NDOSCI,0:NDOSCI),
     *                GAUY41(0:NDOSCI,0:NDOSCI,0:NDOSCI,0:NDOSCI),
     *                GAUZ41(0:NDOSCI,0:NDOSCI,0:NDOSCI,0:NDOSCI),
     *
     *                GAUX42(0:NDOSCI,0:NDOSCI,0:NDOSCI,0:NDOSCI),
     *                GAUY42(0:NDOSCI,0:NDOSCI,0:NDOSCI,0:NDOSCI),
     *                GAUZ42(0:NDOSCI,0:NDOSCI,0:NDOSCI,0:NDOSCI),
     *
     *                GAUX43(0:NDOSCI,0:NDOSCI,0:NDOSCI,0:NDOSCI),
     *                GAUY43(0:NDOSCI,0:NDOSCI,0:NDOSCI,0:NDOSCI),
     *                GAUZ43(0:NDOSCI,0:NDOSCI,0:NDOSCI,0:NDOSCI)
      COMMON
     *       /HERSTO/ HERMTS(0:ND2MAX,1:NDGAUS,1:NDKART)
      COMMON
     *       /HERMEM/ HERONE(0:ND2MAX,1:NDGAUS,1:NDKART)
      COMMON
     *       /DIVSTO/ DHRMTS(0:ND2MAX,1:NDGAUS,1:NDKART),
     *                DDHRMT(0:ND2MAX,1:NDGAUS,1:NDKART)
      COMMON
     *       /DIVMEM/ DHRONE(0:ND2MAX,1:NDGAUS,1:NDKART),
     *                DDHONE(0:ND2MAX,1:NDGAUS,1:NDKART)
      COMMON
     *       /HERCOM/ CERMTS(0:ND2MAX,1:NDGAUS,1:NDKART),
     *                CHRMTS(0:ND2MAX,1:NDGAUS,1:NDKART),
     *                CDHRMT(0:ND2MAX,1:NDGAUS,1:NDKART)
      COMMON
     *       /INTSTO/ FOURWG(1:NDGAUS,1:NDKART),
     *                FOURPT(1:NDGAUS,1:NDKART)
      COMMON
     *       /INTMEM/ TWOWGT(1:NDGAUS,1:NDKART),
     *                TWOPNT(1:NDGAUS,1:NDKART)
      COMMON
     *       /RMSRAD/ RADI_N(0:NDKART),
     *                RADI_P(0:NDKART),
     *                RADI_T(0:NDKART)
      COMMON
     *       /RMSRAH/ RMSRAN(1:NDMORD),
     *                RMSRAP(1:NDMORD),
     *                RMSRAT(1:NDMORD)
      COMMON
     *       /RMSSHI/ RSHI_N(0:NDKART),
     *                RSHI_P(0:NDKART),
     *                RSHI_T(0:NDKART)
      COMMON
     *       /COEMUL/ COMULT(0:NDMULT,0:NDOSCI,0:NDOSCI,1:NDKART)
      COMMON
     *       /FRAMUL/ QLMNEU(0:NDMULT,-NDMULT:NDMULT,0:1),
     *                QLMPRO(0:NDMULT,-NDMULT:NDMULT,0:1),
     *                QLMTOT(0:NDMULT,-NDMULT:NDMULT,0:1)
      COMMON
     *       /FRAORI/ QORNEU(0:NDMULT,-NDMULT:NDMULT,0:1),
     *                QORPRO(0:NDMULT,-NDMULT:NDMULT,0:1),
     *                QORTOT(0:NDMULT,-NDMULT:NDMULT,0:1)
      COMMON
     *       /QMUTTI/ QMUT_N(0:NDMULT,-NDMULT:NDMULT),
     *                QMUT_P(0:NDMULT,-NDMULT:NDMULT),
     *                QMUT_T(0:NDMULT,-NDMULT:NDMULT)
      COMMON
     *       /QMULTI/ QMUL_N(0:NDMULT,-NDMULT:NDMULT),
     *                QMUL_P(0:NDMULT,-NDMULT:NDMULT),
     *                QMUL_T(0:NDMULT,-NDMULT:NDMULT)
      COMMON
     *       /BMULTI/ BMUL_N(0:NDMULT,-NDMULT:NDMULT),
     *                BMUL_P(0:NDMULT,-NDMULT:NDMULT),
     *                BMUL_T(0:NDMULT,-NDMULT:NDMULT)
      COMMON
     *       /SMUTTI/ SMUT_N(0:NDMULT,-NDMULT:NDMULT),
     *                SMUT_P(0:NDMULT,-NDMULT:NDMULT),
     *                SMUT_T(0:NDMULT,-NDMULT:NDMULT)
      COMMON
     *       /SMULTI/ SMUL_N(0:NDMULT,-NDMULT:NDMULT),
     *                SMUL_P(0:NDMULT,-NDMULT:NDMULT),
     *                SMUL_T(0:NDMULT,-NDMULT:NDMULT)
      COMMON
     *       /PMULTI/ PMUL_N(0:NDMULT,-NDMULT:NDMULT),
     *                PMUL_P(0:NDMULT,-NDMULT:NDMULT),
     *                PMUL_T(0:NDMULT,-NDMULT:NDMULT)
      COMMON
     *       /VMULTI/ VMUL_N(0:NDMULT,-NDMULT:NDMULT,1:NDKART),
     *                VMUL_P(0:NDMULT,-NDMULT:NDMULT,1:NDKART),
     *                VMUL_T(0:NDMULT,-NDMULT:NDMULT,1:NDKART)
      COMMON
     *       /QSHIFT/ QSHI_N(0:NDMULT,-NDMULT:NDMULT),
     *                QSHI_P(0:NDMULT,-NDMULT:NDMULT),
     *                QSHI_T(0:NDMULT,-NDMULT:NDMULT)
      COMMON
     *       /BSHIFT/ BSHI_N(0:NDMULT,-NDMULT:NDMULT),
     *                BSHI_P(0:NDMULT,-NDMULT:NDMULT),
     *                BSHI_T(0:NDMULT,-NDMULT:NDMULT)
      COMMON
     *       /SSHIFT/ SSHI_N(0:NDMULT,-NDMULT:NDMULT),
     *                SSHI_P(0:NDMULT,-NDMULT:NDMULT),
     *                SSHI_T(0:NDMULT,-NDMULT:NDMULT)
      COMMON
     *       /QROTAT/ QROT_N(0:NDMULT,-NDMULT:NDMULT),
     *                QROT_P(0:NDMULT,-NDMULT:NDMULT),
     *                QROT_T(0:NDMULT,-NDMULT:NDMULT)
      COMMON
     *       /BROTAT/ BROT_N(0:NDMULT,-NDMULT:NDMULT),
     *                BROT_P(0:NDMULT,-NDMULT:NDMULT),
     *                BROT_T(0:NDMULT,-NDMULT:NDMULT)
      COMMON
     *       /SROTAT/ SROTNN(0:NDMULT,-NDMULT:NDMULT),
     *                SROTNP(0:NDMULT,-NDMULT:NDMULT),
     *                SROTNT(0:NDMULT,-NDMULT:NDMULT)
      COMMON
     *       /AROTAT/ AROTNN(0:NDMULT,-NDMULT:NDMULT),
     *                AROTNP(0:NDMULT,-NDMULT:NDMULT),
     *                AROTNT(0:NDMULT,-NDMULT:NDMULT)
      COMMON
     *       /AROTXX/ AROTXN(0:NDMULT,-NDMULT:NDMULT,0:NDMORD),
     *                AROTXP(0:NDMULT,-NDMULT:NDMULT,0:NDMORD),
     *                AROTXT(0:NDMULT,-NDMULT:NDMULT,0:NDMORD)
      COMMON
     *       /AMUTTI/ AMUT_N(0:NDMULT,-NDMULT:NDMULT,0:NDMORD),
     *                AMUT_P(0:NDMULT,-NDMULT:NDMULT,0:NDMORD),
     *                AMUT_T(0:NDMULT,-NDMULT:NDMULT,0:NDMORD)
      COMMON
     *       /AMULTI/ AMUL_N(0:NDMULT,-NDMULT:NDMULT,0:NDMORD),
     *                AMUL_P(0:NDMULT,-NDMULT:NDMULT,0:NDMORD),
     *                AMUL_T(0:NDMULT,-NDMULT:NDMULT,0:NDMORD)
      COMMON
     *       /ASHIFT/ ASHI_N(0:NDMULT,-NDMULT:NDMULT),
     *                ASHI_P(0:NDMULT,-NDMULT:NDMULT),
     *                ASHI_T(0:NDMULT,-NDMULT:NDMULT)
      COMMON
     *       /ASHIXX/ ASHIXN(0:NDMULT,-NDMULT:NDMULT,0:NDMORD),
     *                ASHIXP(0:NDMULT,-NDMULT:NDMULT,0:NDMORD),
     *                ASHIXT(0:NDMULT,-NDMULT:NDMULT,0:NDMORD)
      COMMON
     *       /WMUTTI/ WMUT_N(0:NDMULT,-NDMULT:NDMULT,0:NDMORD),
     *                WMUT_P(0:NDMULT,-NDMULT:NDMULT,0:NDMORD),
     *                WMUT_T(0:NDMULT,-NDMULT:NDMULT,0:NDMORD)
      COMMON
     *       /WMULTI/ WMUL_N(0:NDMULT,-NDMULT:NDMULT,0:NDMORD),
     *                WMUL_P(0:NDMULT,-NDMULT:NDMULT,0:NDMORD),
     *                WMUL_T(0:NDMULT,-NDMULT:NDMULT,0:NDMORD)
      COMMON
     *       /A2BCTI/ A2BCIN(-1:+1),A2BCSA(-1:+1)
      COMMON
     *       /QLASTR/ GALMUQ(0:NDMULT,-NDMULT:NDMULT),
     *                QLINEA(0:NDMULT,-NDMULT:NDMULT),
     *                IFLALQ(0:NDMULT,-NDMULT:NDMULT)
      COMMON
     *       /VLASTR/ GALMUV(0:NDMULT,-NDMULT:NDMULT),
     *                VLINEA(0:NDMULT,-NDMULT:NDMULT),
     *                IFLALV(0:NDMULT,-NDMULT:NDMULT)
      COMMON
     *       /SLASTR/ GALMUS(0:NDMULT,-NDMULT:NDMULT),
     *                SLINEA(0:NDMULT,-NDMULT:NDMULT),
     *                IFLALS(0:NDMULT,-NDMULT:NDMULT)
      COMMON
     *       /ILASTR/ GALSPI(1:NDKART),
     *                DALSPI(1:NDKART),
     *                IFLALI(1:NDKART)
      COMMON
     *       /TLASTR/ GALISO(1:NDKART),
     *                DALISO(1:NDKART),
     *                IFLALT(1:NDKART)
      COMMON
     *       /RLASTR/ RALMUQ(0:NDMULT,-NDMULT:NDMULT),
     *                RALMUS(0:NDMULT,-NDMULT:NDMULT),
     *                RALMUV(0:NDMULT,-NDMULT:NDMULT)
      COMMON
     *       /JLASTR/ RALSPI(1:NDKART)
      COMMON
     *       /ULASTR/ RALISO(1:NDKART)
      COMMON
     *       /TSTQPR/ ISQPRO
      COMMON
     *       /OURUNI/ QUNITS(0:NDMULT,0:NDMULT)
      COMMON
     *       /SIFUNI/ SUNITS(0:NDMULT,0:NDMULT)
      COMMON
     *       /MAGUNI/ AUNITS(0:NDMULT,0:NDMULT)
      COMMON
     *       /CONVER/ ETOTFI(1:NDITER+1),ETOTSI(1:NDITER+1),
     *                                   ESTABI(1:NDITER+1),
     *                QUA20I(1:NDITER+1),QUA22I(1:NDITER+1),
     *                ANGUTI(1:NDITER+1)
      COMMON
     *       /SPNUMS/ NUMBSP(0:NDREVE,0:NDISOS)
      COMMON
     *       /ANGANG/ ANGU_N(1:NDKART),ANGU_P(1:NDKART),ANGU_T(1:NDKART)
      COMMON
     *       /ANGSPI/ SPIN_N(1:NDKART),SPIN_P(1:NDKART),SPIN_T(1:NDKART)
      COMMON
     *       /LINMOM/ DLINSN(0:NDKART),DLINSP(0:NDKART),DLINST(0:NDKART)
     *               ,ELINSN(0:NDKART),ELINSP(0:NDKART),ELINST(0:NDKART)
     *               ,TLINSN(0:NDKART),TLINSP(0:NDKART),TLINST(0:NDKART)
     *               ,ALINLN(0:NDKART),ALINLP(0:NDKART),ALINLT(0:NDKART)
      COMMON
     *       /KINMOM/ DKINSN(0:NDKART),DKINSP(0:NDKART),DKINST(0:NDKART)
     *               ,EKINSN(0:NDKART),EKINSP(0:NDKART),EKINST(0:NDKART)
     *               ,TKINSN(0:NDKART),TKINSP(0:NDKART),TKINST(0:NDKART)
     *               ,AKINLN(0:NDKART),AKINLP(0:NDKART),AKINLT(0:NDKART)
      COMMON
     *       /LINPAI/ PLINSN(0:NDKART),PLINSP(0:NDKART),PLINST(0:NDKART)
     *               ,PLINLN(0:NDKART),PLINLP(0:NDKART),PLINLT(0:NDKART)
     *               ,PLINKN(0:NDKART),PLINKP(0:NDKART),PLINKT(0:NDKART)
      COMMON
     *       /KINPAI/ PKINSN(0:NDKART),PKINSP(0:NDKART),PKINST(0:NDKART)
     *               ,PKINLN(0:NDKART),PKINLP(0:NDKART),PKINLT(0:NDKART)
     *               ,PKINKN(0:NDKART),PKINKP(0:NDKART),PKINKT(0:NDKART)
      COMMON
     *       /ROTMOM/ DROTSN(0:NDKART),DROTSP(0:NDKART),DROTST(0:NDKART)
     *               ,EROTSN(0:NDKART),EROTSP(0:NDKART),EROTST(0:NDKART)
     *               ,TROTSN(0:NDKART),TROTSP(0:NDKART),TROTST(0:NDKART)
     *               ,AROTLN(0:NDKART),AROTLP(0:NDKART),AROTLT(0:NDKART)
      COMMON
     *       /KOTMOM/ DKOTSN(0:NDKART),DKOTSP(0:NDKART),DKOTST(0:NDKART)
     *               ,EKOTSN(0:NDKART),EKOTSP(0:NDKART),EKOTST(0:NDKART)
     *               ,TKOTSN(0:NDKART),TKOTSP(0:NDKART),TKOTST(0:NDKART)
     *               ,AKOTLN(0:NDKART),AKOTLP(0:NDKART),AKOTLT(0:NDKART)
      COMMON
     *       /ROTPAI/ PROTSN(0:NDKART),PROTSP(0:NDKART),PROTST(0:NDKART)
     *               ,PROTLN(0:NDKART),PROTLP(0:NDKART),PROTLT(0:NDKART)
     *               ,PROTKN(0:NDKART),PROTKP(0:NDKART),PROTKT(0:NDKART)
      COMMON
     *       /KOTPAI/ PKOTSN(0:NDKART),PKOTSP(0:NDKART),PKOTST(0:NDKART)
     *               ,PKOTLN(0:NDKART),PKOTLP(0:NDKART),PKOTLT(0:NDKART)
     *               ,PKOTKN(0:NDKART),PKOTKP(0:NDKART),PKOTKT(0:NDKART)
      COMMON
     *       /SHIANG/ ANGS_N(1:NDKART),ANGS_P(1:NDKART),ANGS_T(1:NDKART)
      COMMON
     *       /ROTANG/ ANGR_N(1:NDKART),ANGR_P(1:NDKART),ANGR_T(1:NDKART)
      COMMON
     *       /ROTSPI/ SPIR_N(1:NDKART),SPIR_P(1:NDKART),SPIR_T(1:NDKART)
      COMMON
     *       /DATPAN/ GPAIRN,FACTGN,EFERMN,DELTAN,EFER2N
     *       /DATPAP/ GPAIRP,FACTGP,EFERMP,DELTAP,EFER2P
     *       /DATPAA/               EFERMA,DELTAA
      COMMON
     *       /CCPPAI/ PRHO_N,PRHODN,PRHOSN,POWERN,
     *                PRHO_P,PRHODP,PRHOSP,POWERP
      COMMON
     *       /CCPRHD/ PRHD_N,PRHDDN,PRHDSN,POWDRN,
     *                PRHD_P,PRHDDP,PRHDSP,POWDRP
      COMMON
     *       /PAIINI/ FERINI(0:NDISOS),DELINI(0:NDISOS),FE2INI(0:NDISOS)
      COMMON
     *       /ISOFER/ FERISO(0:NDKART)
      COMMON
     *       /MOVFER/ FERMOV(0:NDKART)
      COMMON
     *       /ISOTOT/ TOTISO(0:NDKART),TOTIS2(0:NDKART)
      COMMON
     *       /ISOFE_/ FE_RAD,FE_THE,FE_PHI,FE_OFF
      COMMON
     *       /ALLENE/ EKIN_N,EKIN_P,EKIN_T,
     *                EPOT_N,EPOT_P,EPOT_T,
     *                ESUM_N,ESUM_P,ESUM_T,
     *                EPAI_N,EPAI_P,EPAI_T,
     *                EREA_N,EREA_P,EREA_T,
     *                ELIP_N,ELIP_P,ELIP_T,
     *
     *                ECOULD,ECOULE,ECOULT,
     *                       ECOULS,ECOULV,
     *
     *                EMULCO,EMUSLO,EMUREA,
     *                ESIFCO,ESISLO,ESIREA,
     *                ESPICO,ESPSLO,ESPREA,
     *
     *                ENREAR,ECORCM,ECOR_R,
     *
     *                EEVEW0,EODDW0,ENE_W0,
     *                ENEVEN,ENEODD,ENESKY,
     *                ESTABN,ETOTSP,ETOTFU
      COMMON
     *       /ISOENE/ EISOCO,EISSLO,EISREA
      COMMON
     *       /EYUKTT/ EYUKDT,EYUKD0,EYUKD1,EYUKD2,
     *                EYUKET,EYUKE0,EYUKE1,EYUKE2
      COMMON
     *       /EGOGTT/ EGOGDT,EGOGET
      COMMON
     *       /PN_GOG/ EGOGSP(0:NDISOS),EGOGVP(0:NDISOS)
      COMMON
     *       /EREGTT/ EREGDT,EREGET
      COMMON
     *       /ESEPTT/ ESEPDT,ESEPET
      COMMON
     *       /EFSOTT/ EFSODT,EFSOET
      COMMON
     *       /EFTOTT/ EFTODT,EFTOET
      COMMON
     *       /EFTETT/ EFTEDT,EFTEET
      COMMON
     *       /PN_REG/ EREGSP(0:NDISOS),EREGVP(0:NDISOS)
      COMMON
     *       /PN_SEP/ ESEPSP(0:NDISOS),ESEPVP(0:NDISOS)
      COMMON
     *       /PN_COU/ EKPSCA,EKPVEC
      COMMON
     *       /PN_FST/ EFSOSP(0:NDISOS),EFTOSP(0:NDISOS),EFTESP(0:NDISOS)
      COMMON
     *       /ITERTS/ ITESTA,ITESTO,NOITER,NUMITE
      COMMON
     *       /IPRITE/ PRINIT
      COMMON
     *       /SIZNVA/ NVASIZ(0:NDISOS)
      COMMON
     *       /SIZMVA/ MVASIZ(0:NDISOS)
      COMMON
     *       /SIZKVA/ KVASIZ(                  0:NDISOS)
      COMMON
     *       /MIZNVA/ NVAMIZ
      COMMON
     *       /N_FLIG/ NPFLIG(0:NDPARI,0:NDREVE,0:NDISOS),
     *                NHFLIG(0:NDPARI,0:NDREVE,0:NDISOS),
     *                NOFLIG(0:NDPARI,0:NDREVE,0:NDISOS)
      COMMON
     *       /N_FLIM/ NPFLIM(         0:NDREVE,0:NDISOS),
     *                NHFLIM(         0:NDREVE,0:NDISOS),
     *                NOFLIM(         0:NDREVE,0:NDISOS)
      COMMON
     *       /N_FLIQ/ NPFLIQ(0:NDPARI,         0:NDISOS),
     *                NHFLIQ(0:NDPARI,         0:NDISOS),
     *                NOFLIQ(0:NDPARI,         0:NDISOS)
      COMMON
     *       /N_FLIZ/ NPFLIZ(                  0:NDISOS),
     *                NHFLIZ(                  0:NDISOS),
     *                NOFLIZ(                  0:NDISOS)
      COMMON
     *       /N_MLIG/ NPMLIG(0:NDPARI,0:NDREVE),
     *                NHMLIG(0:NDPARI,0:NDREVE),
     *                NOMLIG(0:NDPARI,0:NDREVE)
      COMMON
     *       /N_MLIM/ NPMLIM(0:NDREVE),
     *                NHMLIM(0:NDREVE),
     *                NOMLIM(0:NDREVE)
      COMMON
     *       /N_MLIQ/ NPMLIQ(0:NDPARI),
     *                NHMLIQ(0:NDPARI),
     *                NOMLIQ(0:NDPARI)
      COMMON
     *       /N_MLIZ/ NPMLIZ,
     *                NHMLIZ,
     *                NOMLIZ
      COMMON
     *       /OMEGAS/ OMEGAX,OMEGAY,OMEGAZ
      COMMON
     *       /OMOVAS/ OMOVAX,OMOVAY,OMOVAZ
      COMMON
     *       /EANGLE/ ALPEUL,BETEUL,GAMEUL
      COMMON
     *       /SCALNG/ HOMSCA(NDKART,NDTWCE)
      COMMON
     *       /PLANCK/ HBMASS,HBMRPA,HBMINP
      COMMON
     *       /ATHRGR/ TGRA10,TGRA11,TGRA20,TGRA21,TGRA22,IGRAIN
      COMMON
     *       /ETHREE/ E3BEVE,E3BODD
      COMMON
     *       /ETHRGR/ ETGRAF,ETGRAP
      COMMON
     *       /EFOURB/ E4BEVE,E4BODD
      COMMON
     *       /PAIBOD/ EPAI3N,EPAI3P,EPAI4N,EPAI4P
      COMMON
     *       /RENORM/ HBMREN(NDKART)
      COMMON
     *       /RENROT/ ROTREN(NDKART)
      COMMON
     *       /RINORM/ HBMRIN(NDKART)
      COMMON
     *       /RINROT/ ROTRIN(NDKART)
      COMMON
     *       /BROINI/ IBROYD,N_ITER
     *       /BROMIX/ ALPHAM,BROTRI
     *       /BROMAT/ NOIINP,MIXMAT
      COMMON
     *       /HEREPS/ EPSHER
      COMMON
     *       /CFIREA/ NFIREA
      COMMON
     *       /CFIPRI/ NFIPRI
C@@@ MULTIPOLE - MULTIPOLE - MULTIPOLE - MULTIPOLE
      COMMON
     *       /CNSOLD/ VECOLD(1:NDCONS)
      COMMON
     *       /CNSCOR/ LAMCNS(1:NDCONS),MIUCNS(1:NDCONS)
     *       /CNSNUM/ NOFCNS
      COMMON
     *       /REALPH/ ALPHAR(0:NDLAMB,0:NDLAMB)
      COMMON
     *       /READAL/ ALPHRE(0:NDLAMB,0:NDLAMB)
      COMMON
     *       /QCNSTR/ STIFFQ(0:NDMULT,-NDMULT:NDMULT),
     *                QASKED(0:NDMULT,-NDMULT:NDMULT),
     *                IFLAGQ(0:NDMULT,-NDMULT:NDMULT)
C@@@ MULTIPOLE - MULTIPOLE - MULTIPOLE - MULTIPOLE
C SL - SL - SL - SL - SL - SL - SL - SL - SL - SL - SL - SL - SL - SL
      COMMON
     *       /SCALAPACK_INP/ NBLOCK,MBLOCK,NPGRID,MPGRID,KZHPEV
C SL - SL - SL - SL - SL - SL - SL - SL - SL - SL - SL - SL - SL - SL
C@@@ SHELL - SHELL - SHELL - SHELL - SHELL - SHELL - SHELL - SHELL
      COMMON
     *       /DIMSTA/ LDTOTS(0:NDISOS),LDSTAT(0:NDISOS),
     *                LDUPPE(0:NDISOS),LDTIMU(0:NDISOS)
      COMMON
     *       /DIMENS/ LDBASE
      COMMON
     *       /STRUTI_PARAMS/ GSTRUN,GSTRUP,HOMFAC,EPSRTN
     *       /STRUTI_POLYNO/ NPOLYN
C@@@ SHELL - SHELL - SHELL - SHELL - SHELL - SHELL - SHELL - SHELL
C@@@ TEMP -TEMP - TEMP - TEMP - TEMP - TEMP - TEMP - TEMP - TEMP
      COMMON
     *       /T_FLAG/ IFTEMP
      COMMON
     *       /GCTEMP/ TEMP_T
      COMMON
     *       /SENTRO/ ENTRPY(0:NDISOS)
C@@@ TEMP -TEMP - TEMP - TEMP - TEMP - TEMP - TEMP - TEMP - TEMP
C@@@ NECK - NECK - NECK - NECK - NECK - NECK - NECK - NECK - NECK
      COMMON
     *       /NCKVAL/ Q0NECK,G_NECK
     *       /NCKFLA/ IFNECK
C@@@ NECK - NECK - NECK - NECK - NECK - NECK - NECK - NECK - NECK
      COMMON
     *       /FRASYM/ DOSYMM,do_symmetrize
      COMMON
     *       /DEFORM/ ALPHAC,IREALA
      COMMON
     *       /AUTOBA/ IBASIS
      COMMON
     *       /EDFINP/ IF_EDF
     *       /EDFPAR/ V0NEFF,V0PEFF,COUSCA
      COMMON
     *       /MINDEF/ LAMINP(1:NDSEAR),MIUINP(1:NDSEAR)
     *       /MINLIM/ NUMINP,LMXINP,ITEINP
     *       /MINSTP/ STPINP
      COMMON
     *       /HFMEAN/ IHFPOT
#if(USE_MPI==1)
      COMMON
     *       /SIGNAL/ escapeSignal
      COMMON
     *       /OUTPUT/ nfisum
#endif
C
C=======================================================================
CXIAOBAO added for Lipkin method of particle number restoration.
C=======================================================================
C
      REAL
     *       LAM2_N,LAM2_P,LAM4_N,LAM4_P,LAM6_N,LAM6_P
      COMMON
     *       /LIPLAM/
     *       LAM2_N,LAM2_P,LAM4_N,LAM4_P,LAM6_N,LAM6_P
      REAL
     *       ELIP2N,ELIP2P,ELIP4N,ELIP4P,ELIP6N,ELIP6P,
     *       ELAM4N,ELAM6N,ELAM4P,ELAM6P
      COMMON
     *       /LIPADE/
     *       ELIP2N,ELIP2P,ELIP4N,ELIP4P,ELIP6N,ELIP6P,
     *       ELAM4N,ELAM6N,ELAM4P,ELAM6P
C
      INTEGER,PARAMETER :: NODGAU = 1000
      COMPLEX
     *        RLIPNU,NLIPNU
      COMMON
     *       /LIPNUM/
     *          RLIPNU(0:6,0:NODGAU,0:NDISOS),
     *          NLIPNU(0:6,0:NODGAU,0:NDISOS)
C
      COMMON
     *       /FC_CBR/ FR2CBR,FS2CBR,FR3CBR,FS3CBR,
     *                FT2CBR,FK2CBR,FT3CBR,FK3CBR,
     *                FL2CBR,FP2CBR,FL3CBR,FP3CBR,
     *                FC2CBR,FJ2CBR,FC3CBR,FJ3CBR
      COMMON
     *       /FERMIL/ F_KT_L(-NDPROI:NDPROI,0:NDPROT,-NDPROT:NDPROT),
     *                EIGE_L,IDIM_L,IIFERL,ITFERL,ISFERL
      COMMON
     *       /FERMIR/ F_KT_R(-NDPROI:NDPROI,0:NDPROT,-NDPROT:NDPROT),
     *                EIGE_R,IDIM_R,IIFERR,ITFERR,ISFERR
      COMMON
     *       /FERMLL/ C_KT_L(-NDPROI:NDPROI,NDPROT,NDCONF),
     *                EIGINI(NDCONF),MIXIND(NDCONF,2)
      COMMON
     *       /ISDLIP/ IS_DLI(0:NDISOS)
      COMMON
     *       /AXILIZ/ NOSCIL,IF_THO,IAXIAP
      COMMON
     *       /ASYPAI/ KAPASY
      COMMON
     *       /SEPDON/ ISEPDO(NDKART,NDSEGA,NDSEGA)
      COMMON
     *       /SEPBIN/ SEPVIC(NDSEPA,NDFORC),IVISEP
      COMMON
     *       /SEPVER/ SEPERR(NDSEPA,NDFORC),IERSEP
      COMMON
     *       /SEPFAC/ SEPFAC(NDSEPA,NDFORC),IFASEP
      COMMON
     *       /SEPVIN/ SEPVCC(NDSEPA,NDFORC),IRESEP
      COMMON
     *       /SEPTIN/ SEPTCC(NDSEPA,NDFORC)
      COMMON
     *       /SKYDAT/ T0_DAT,X0_DAT,T1_DAT,X1_DAT,T2_DAT,X2_DAT,
     *                T3_DAT,X3_DAT,WW_DAT,PO_DAT
      COMMON
     *       /SKYERR/ T0_ERR,X0_ERR,T1_ERR,X1_ERR,T2_ERR,X2_ERR,
     *                T3_ERR,X3_ERR,WW_ERR,PO_ERR
      COMMON
     *       /SKYFAC/ T0_FAC,X0_FAC,T1_FAC,X1_FAC,T2_FAC,X2_FAC,
     *                T3_FAC,X3_FAC,WW_FAC,PO_FAC
      COMMON
     *       /SKYINP/ T0_INP,X0_INP,T1_INP,X1_INP,T2_INP,X2_INP,
     *                T3_INP,X3_INP,WW_INP,PO_INP
      COMMON
     *       /JPA2HF/ DEL2HF(0:NDISOS),IPA2HF(0:NDISOS)
      COMMON
     *       /IDENTU/ IDENSU,JDENSU
      COMMON
     *       /LIMITL/ LAMMAX,NMUCON
      COMMON
     *       /ALLAST/ LASTAL(0:NDISOS)
      COMMON
     *       /REGPAR/ REGWID
      COMMON
     *       /REJVIN/ REJVCC(NDREGA,NDFORC)
      COMMON
     *       /REJVER/ REJERR(NDREGA,NDFORC)
      COMMON
     *       /REJVAC/ REJFAC(NDREGA,NDFORC)
      COMMON
     *       /REJTIN/ REJTCC(NDREGA,NDFORC)
      COMMON
     *       /JREJAL/ IREREJ(4),NREREJ(4)
      COMMON
     *       /REGBIN/ REGBCC(NDREGA,NDFORC),IREREG
      COMMON
     *       /REGVIN/ REGVCC(NDREGA,NDFORC)
      COMMON
     *       /REGTIN/ REGTCC(NDREGA,NDFORC)
      COMMON
     *       /COLMIX/ MIXCOL(0:NDPROI,0:NDISOM,NDCONF)
      COMMON
     *       /GYROSC/ GYRORP,GYRSPN,GYRSPP,IGYROS
      COMMON
     *       /GEFACT/ GESPIN(0:NDISOS),GEORBI(0:NDISOS)
      COMMON
     *       /G_FACT/ G_SPIN(0:NDISOS),G_ORBI(0:NDISOS)
      COMMON
     *      /danelip/ LIPKIP,LIPKIN
C
C=======================================================================
C
      DATA
     *       NAMMUL /'MULTIPOLE MOMENTS [UNITS:  (10 FERMI)^LAMBDA]'/,
     *       NAMSUR /'SURFACE MOMENTS, UNITS: (10 FERMI)^(LAMBDA+2)'/,
     *       NAMSCH /'SCHIFF MOMENTS,  UNITS: (10 FERMI)^(LAMBDA+2)'/,
     *       NAMPLM /'PENSURFACE MOMENTS, IN: (10 FERMI)^(LAMBDA+4)'/,
     *       NAMMAG /'MAGNETIC MOMENTS      [MGNT*FERMI^(LAMBDA-1)]'/,
     *       NAMASM /'SPIN-ASYMMETRY MOMNTS [HBAR*FERMI^(LAMBDA+1)]'/
      DATA
     *       NAMHAR /'                 '/,
     *       NAMSHI /'[CENT-MASS FRAME]'/,
     *       NAMROT /'[INTRINSIC FRAME]'/
C
      CHARACTER
     *          NAMODU*16,NAMMOD*16
      COMMON
     *       /LIMODU/ MODORD(NDMODU),NAMODU(NDMODU),MODVER(NDMODU),
     *                MODTOT
      COMMON
     *       /VERMOD/ NAMMOD(NDMODU),MODUVE(NDMODU),MODSET(NDMODU)
      COMMON
     *       /PARFIX/ ISIQTY
      COMMON
     *       /POWNMU/ NMUPOW
      COMMON
     *       /ALCONF/ INCONF(NDCONF),ILCONF,MICONF(NDCONF),MIXNUM
      COMMON
     *       /BLIMS3/ NXMAXV(1:NDTWCE),NYMAXV(1:NDTWCE),
     *                NZMAXV(1:NDTWCE)
      COMMON
     *       /GAUMAX/ NXHERM,NYHERM,NZHERM
      COMMON
     *       /CENPOS/ CENCOR(1:NDKART,1:NDTWCE)
      COMMON
     *      /HERMIN/  INTWHE(1:NDTWCE,1:NDTWCE,1:NDTWCE,1:NDTWCE)
      COMMON
     *       /TWCEIN/ IND4HI(1:NDTWHE),IND4HJ(1:NDTWHE),
     *                IND4HK(1:NDTWDD),IND4HL(1:NDTWDD),
     *                IND2HR(1:NDTWBL),IND2HL(1:NDTWBL)
      COMMON
     *      /INFAST/  IDCOPY(1:NDTWDD,0:1),IDCOCO(1:NDTWDD,0:1)
      COMMON
     *       /FRCONS/ FRGSTF(0:NDISOS,1:NDTWCE),
     *                FRGASK(0:NDISOS,1:NDTWCE),
     *                IFLFRG(0:NDISOS,1:NDTWCE),
     *                CLMFRA(0:NDISOS,1:NDTWCE),
     *                AVEFRA(0:NDISOS,1:NDTWCE)
      COMMON
     *       /QMUTWC/ QFRA_N(0:NDMULT,-NDMULT:NDMULT,1:NDTWCE),
     *                QFRA_P(0:NDMULT,-NDMULT:NDMULT,1:NDTWCE),
     *                QFRA_T(0:NDMULT,-NDMULT:NDMULT,1:NDTWCE)
      COMMON
     *       /QTWCNS/ STQTWC(0:NDMULT,-NDMULT:NDMULT,1:NDTWCE),
     *                QTWCAS(0:NDMULT,-NDMULT:NDMULT,1:NDTWCE),
     *                IFLQTW(0:NDMULT,-NDMULT:NDMULT,1:NDTWCE),
     *                GALMTW(0:NDMULT,-NDMULT:NDMULT,1:NDTWCE)
C     -- USED IN ATDHF CALCULATION --
      COMMON
     *       /SWSING/ I_SING
C     -- USED IN ATDHF CALCULATION --
      COMMON
     *       /PHYPIO/ PIMASS,G_AXIC,PIDECA
      COMMON
     *       /FOR2BC/ MAG2BC(NDF2BC)
      COMMON
     *       /SWFSTA/ I_FSTA(NDFSTA)
      COMMON
     *       /SFSTPA/ IFSTPA(NDFSTA)
C
C=======================================================================
C      UPON REQUEST, INITIALIZING THE MPI ENVIRONMENT AND SETTING UP
C      MPI GROUP STRUCTURE
C=======================================================================
C
      do_debug = .False.
C
#if(USE_MPI==1)
      call mpi_init(mpi_err)
      call mpi_comm_size(MPI_COMM_WORLD, worldSize, mpi_err)
      call mpi_comm_rank(MPI_COMM_WORLD, worldRank, mpi_err)
C
      nofpro = worldSize
C
      allocate(my_cputime(0:0), my_evals(0:0))
      if (worldRank == 0 ) then
          allocate(all_cputimes(0:worldSize-1),
     *                all_evals(0:worldSize-1))
C
          nfisum=89
          write(filsum,'(''hf256a_summary.txt'')')
C
          open(nfisum,file=filsum,status='unknown',form='formatted')
C
      else
          allocate(all_cputimes(0:0), all_evals(0:0))
      end if
C
      ! Record system and CPU starting times
      call system_clock(syst_cnt, syst_rate)
C
      syst_start = real(syst_cnt)
     *           / real(syst_rate)
C
      call cpu_time(cput_start)
C
      printTopology = 0
      counter_eval = 0
      iprint = 1
C
      numberHFODDproc = 1
C
      ! Attention: M_GRID and N_GRID below are passed through pre-processor
      !            not by standard NAMELI routine. This is because we need
      !            them even before we call NAMELI (or its likes)
#if(USE_SCALAPACK==1)
      numberHFODDproc = M_GRID * N_GRID
      NPGRID = N_GRID
      MPGRID = M_GRID
#endif
C
      n_proc = worldRank
      numberMasters = worldSize / numberHFODDproc
C
      ! Get handle on world group
      call mpi_comm_group(MPI_COMM_WORLD, worldGroup, mpi_err)
C
      ! Define the rank of the masters
      allocate(rankMasters(0:(numberMasters-1)))
C
      do ii = 0, numberMasters - 1
         rankMasters(ii) = ii
      end do
C
      ! Define new group of masters: the oligarchy
      call mpi_group_incl(worldGroup, numberMasters, rankMasters,
     *                                     groupMasters, mpi_err)
      call mpi_comm_create(MPI_COMM_WORLD, groupMasters,
     *                             mastersCOMM, mpi_err)
C
      ! Everybody else is a stupid slave
      if (numberHFODDproc > 1) then
          call mpi_group_excl(worldGroup, numberMasters, rankMasters,
     *                                          groupSlaves, mpi_err)
          call mpi_comm_create(MPI_COMM_WORLD, groupSlaves,
     *                             slavesCOMM, mpi_err)
      end if
C
      ! Second grouping: define tribes of slaves associated with every
      ! oligarch. Since they are many such groups (as many as masters),
      ! and they all have the same size, it is simpler to just split
      ! the communicator into many sub-communicators
C
      color = mod(worldRank, numberMasters)
      intkey = worldRank
C
      call mpi_comm_split(MPI_COMM_WORLD, color, intkey, tribeCOMM,
     *                                                     mpi_err)
C
      call mpi_comm_rank(tribeCOMM, tribeRank, mpi_err)
C
#if(USE_SCALAPACK==1)
C
      allocate(all_tribeRank(0:(worldSize-1)))
      allocate(all_color(0:(worldSize-1)))
      allocate(all_worldRank(0:(worldSize-1)))
C
      call MPI_Allgather(tribeRank, 1, MPI_INTEGER, all_tribeRank, 1,
     *                                 MPI_INTEGER,
     *                                 MPI_COMM_WORLD, mpi_err)
C
      call MPI_Allgather(color, 1, MPI_INTEGER, all_color, 1,
     *                             MPI_INTEGER,
     *                             MPI_COMM_WORLD, mpi_err)
C
      call MPI_Allgather(worldRank, 1, MPI_INTEGER, all_worldRank, 1,
     *                                 MPI_INTEGER,
     *                                 MPI_COMM_WORLD, mpi_err)
C
      allocate(rankTribe(0:(numberHFODDproc-1),
     *                     0:(numberMasters-1)))
C
      do n_proc = 0, worldSize - 1
         n_tribe = all_tribeRank(n_proc)
         n_color = all_color(n_proc)
         rankTribe(n_tribe, n_color) = all_worldRank(n_proc)
      end do
C
      deallocate(all_tribeRank,all_color,all_worldRank)
C
      if ( worldRank == 0) then
          do n_color = 0, numberMasters-1
             do n_tribe = 0, numberHFODDproc-1
                write(nfisum,'("n_tribe = ",i4," n_color = ",i4,
     *                    " my_rank = ",i4)')
     *                      n_tribe, n_color,
     *                      rankTribe(n_tribe, n_color)
             end do
          end do
      end if
C
#endif
C
      if ( printTopology == 1 ) then
C
          if ( worldRank < numberMasters ) then
               write(nfisum,'(''AFTER GROUPS - Processor: '',i7,
     *                   '' of color = '',i7,'' is master = '',i7,
     *                   '' Communicator handle: '',i12)')
     *                      worldRank, color, masterRank, mastersCOMM
          end if
C
          if (worldRank >= numberMasters) then
               write(nfisum,'(''AFTER GROUPS - Processor: '',i7,
     *                   '' of color = '',i7,'' is slave = '',i7,
     *                   '' Communicator handle: '',i12)')
     *                      worldRank, color, slaveRank, slavesCOMM
          end if
C
          write(nfisum,'(''AFTER GROUPS - Processor: '',i7,
     *              '' of color = '',i7,'' has rank = '',i7,
     *              '' in its tribe'')')
     *              worldRank, color, tribeRank
C
      end if
C
#endif
C
C=======================================================================
C
      CALL CPUTIM('HFODD ',1)
C
C=======================================================================
C
      C_ZERO=CMPLX(0.0D0,0.0D0)
C
C      Flag that triggers the clean exit from this process (QUABCS)
C
#if(USE_MPI==1)
      escapeSignal = 0
#endif
C
C=======================================================================
C         DEFINING  THE   V E R S I O N   N U M B E R   OF THE CODE
C=======================================================================
C
C                           ------------------
C                          |                  |
                              VERSIO='3.33B'
C                          |                  |
C                           ------------------
C
C=======================================================================
C         DEFINING  THE   I N P U T   A N D   O U T P U T   FILE NUMBERS
C=======================================================================
C
#if(USE_MPI==1)
      NFIPRI=88
      WRITE(FILOUT,'(''hfodd_'',i6.6,''.out'')') worldRank+1
      OPEN(NFIPRI,FILE=FILOUT,STATUS='UNKNOWN',FORM='FORMATTED')
#else
#if(USE_FITS==1)
      CALL FITJAD(JADRO_NAME, DAT_SUFFIX)
#else
      NFIREA=05
      NFIPRI=06
#endif
#endif
C
C=======================================================================
C      DISPLAYING THE CHARACTERISTICS OF THE PARALLEL MODEL:
C       - SIMPLE MPI STRUCTURE WITH/WITHOUT OPENMP
C       - ADVANCED MPI STRUCTURE WITH/WITHOUT OPENMP
C=======================================================================
C
#if( USE_MPI==1 || USE_OPENMP==1)
      WRITE(NFIPRI,'(79(''*''),/,''*'',77X,''*'',/,
     *      ''*                       P A R A L L E L    '',
     *      ''M O D E L                          *'',/,
     *      ''*'',77X,''*'')')
#else
      WRITE(NFIPRI,'(79(''*''),/,''*'',77X,''*'',/,
     *      ''*                   S I N G L E - C O R E     '',
     *      ''V E R S I O N                   *'')')
#endif
C
#if(USE_MPI==1)
#if(USE_SCALAPACK==0)
      WRITE(NFIPRI,'(''*  SIMPLE MPI FRAMEWORK (1 COMMUNICATOR)'',
     *      ''    :  1 CORE per HFODD TASK          *'')')
#else
      WRITE(NFIPRI,'(''*  ADVANCED MPI FRAMEWORK (3 COMMUNICATORS)'',
     *      '' : '',I2,'' CORES per HFODD TASK         *'')')
     *      numberHFODDproc
#endif
#endif
C
#if(USE_OPENMP==1)
!$OMP PARALLEL
!$OMP& SHARED(NFIPRI)
!$OMP& PRIVATE(numThreads,idThread)
      numThreads = omp_get_num_threads()
      idThread = omp_get_thread_num()
      IF (idThread .EQ. 0) THEN
          WRITE(NFIPRI,'(''*  MULTI-THREADING FRAMEWORK WITH '',
     *    ''OPENMP    : '',I2,'' THREADS per HFODD TASK       *'')')
     *                numThreads
      END IF
!$OMP END PARALLEL
#endif
C
      WRITE(NFIPRI,'(''*'',77X,''*'')')
C
C=======================================================================
C         PRINTING THE OUTPUT HEADER
C=======================================================================
C
      WRITE(NFIPRI,'(79(1H*),/,               1H*,77X,1H*,/,
     * 1H*, 19X, "     __  __ _____  ___   ____   ____   ",   19X,1H*,/,
     * 1H*, 19X, "    / / / // ___/.'' _ \ / __ \ / __ \  ",  19X,1H*,/,
     * 1H*, 19X, "   / /_/ // /_  / / / // / / // / / /  ",   19X,1H*,/,
     * 1H*, 19X, "  / __  // __/ / / / // / / // / / /   ",   19X,1H*,/,
     * 1H*, 19X, " / / / // /   / /_/ // /_/ // /_/ /    ",   19X,1H*,/,
     * 1H*, 19X, "/_/ /_//_/    \___.''/____.''/____.''     ",19X,1H*,/,
     * 1H*, 77X, 1H*,/,
     *                              1H*,77X,1H*,/,
     *                              79(1H*),/,1H*,77X,1H*,/,1H*, 9X,
     *     ''UNIVERSAL NON-RELATIVISTIC NUCLEAR DFT CODE VERSION: '',A5,
     *                              10X,1H*,/,1H*,77X,1H*,/,1H*,13X,
     *      '' NO SYMMETRY-PLANES AND NO TIME-REVERSAL SYMMETRY  '',
     *                              13X,1H*,/,1H*,77X,1H*,/,1H*,13X,
     *      ''   DEFORMED CARTESIAN HARMONIC-OSCILLATOR BASIS    '',
     *                              13X,1H*,/,1H*,77X,1H*,/,
     *                              79(1H*),/,1H*,77X,1H*,/,1H*,13X,
     *      '' J. DOBACZEWSKI, B.C. BACKES, P. BACZYK, P. BECKER '',
     *                              13X,1H*,/,              1H*,13X,
     *      '' M. BENDER, K. BENNACEUR, J. BONNARD, B.G. CARLSSON'',
     *                              13X,1H*,/,              1H*,13X,
     *      '' J. DUDEK, J. ENGEL, Y. GAO, A. IDINI, M. KONIECZKA'',
     *                              13X,1H*,/,              1H*,13X,
     *      ''     M. KORTELAINEN, T. LESINSKI, J. MCDONNELL     '',
     *                              13X,1H*,/,              1H*,13X,
     *      ''    P. OLBRATOWSKI, P. POWALOWSKI, L. PROCHNIAK    '',
     *                              13X,1H*,/,              1H*,13X,
     *      ''    A.M. ROMERO, M. SADZIAK, J. SARICH, K. SATO    '',
     *                              13X,1H*,/,              1H*,13X,
     *      ''    A. SANCHEZ-FERNANDEZ, W. SATULA, N. SCHUNCK    '',
     *                              13X,1H*,/,              1H*,13X,
     *      ''  J.A. SHEIKH, Y. SHI, A. STASZCZAK, M. STOITSOV   '',
     *                              13X,1H*,/,              1H*,13X,
     *      ''    X. SUN, P. TOIVANEN, X.B. WANG, T.R. WERNER    '',
     *                              13X,1H*,/,              1H*,13X,
     *      ''  H. WIBOWO, L.F. YU, M. ZALEWSKI AND H. ZDUNCZUK  '',
     *                              13X,1H*,/,1H*,77X,1H*,/,1H*,13X,
     *      ''  INSTYTUT FIZYKI TEORETYCZNEJ, WARSZAWA, POLSKA   '',
     *                                            13X,1H*,/,1H*,13X,
     *      ''           UNIVERSITY OF YORK, YORK, UK            '',
     *                              13X,1H*,/,1H*,77X,1H*,/,1H*,13X,
     *      ''                     1993-2024                     '',
     *                              13X,1H*,/,1H*,77X,1H*,/,79(1H*))')
     *
     *       VERSIO
C
C=======================================================================
C         PRINTING THE ARRAY DIMENSIONS
C=======================================================================
C
      WRITE(NFIPRI,'(/,79(1H*),/,             1H*,77X,1H*,/,1H*,2X,
     *      ''CODE COMPILED WITH THE FOLLOWING ARRAY DIMENSIONS '',
     *      ''AND SWITCHES:'',
     *                              12X,1H*,/,1H*,77X,1H*,/
     *                              79(1H*),/,1H*,77X,1H*,/,1H*,2X,
     *      ''NDBASE ='',I5,2X,''NDSTAT ='',I5,2X,
     *      ''NDXHRM ='',I5,2X,''NDYHRM ='',I5,2X,
     *      ''NDZHRM ='',I5,2X,
     *                                  1H*,/,1H*,77X,1H*,/,1H*,2X,
     *      ''NDMAIN ='',I5,2X,''NDMULT ='',I5,2X,
     *      ''NDMULR ='',I5,2X,''NDLAMB ='',I5,2X,
     *      ''NDITER ='',I5,2X,
     *                                  1H*,/,1H*,77X,1H*,/,1H*,2X,
     *      ''NDAKNO ='',I5,2X,''NDBKNO ='',I5,2X,
     *      ''NDPROI ='',I5,2X,''        '',5X,2X,
     *      ''        '',5X,2X,
     *                                  1H*,/,1H*,77X,1H*,/,1H*,2X,
     *      ''NDATKN ='',I5,2X,''NDBTKN ='',I5,2X,
     *      ''NDPROT ='',I5,2X,''        '',5X,2X,
     *      ''        '',5X,2X,
     *                                  1H*,/,1H*,77X,1H*,/,1H*,2X,
     *      ''IPARAL ='',I5,2X,''IPARAT ='',I5,2X,
     *      ''I_CRAY ='',I5,2X,''NDCOUL ='',I5,2X,
     *      ''NDPOLS ='',I5,2X,
     *                                  1H*,/,1H*,77X,1H*,/,1H*,2X,
     *      ''ISWTWC ='',I5,2X,''NDTWCE ='',I5,2X,
     *      ''NDTWBL ='',I5,2X,''NDTWHE ='',I5,2X,
     *      ''NDCONF ='',I5,2X,
     *                                  1H*,/,1H*,77X,1H*,/,1H*,2X,
     *      ''NDPROM ='',I7,3X,''NDISOM ='',I7,3X,
     *      ''NDPROD ='',I7,3X,''        '',7X,6X,
     *                                  1H*)')
     *
     *      NDBASE,NDSTAT,NDXHRM,NDYHRM,NDZHRM,
     *      NDMAIN,NDMULT,NDMULR,NDLAMB,NDITER,
     *      NDAKNO,NDBKNO,NDPROI,
     *      NDATKN,NDBTKN,NDPROT,
     *      IPARAL,IPARAT,I_CRAY,NDCOUL,NDPOLS,
     *      ISWTWC,NDTWCE,NDTWBL,NDTWHE,NDCONF,
     *      NDPROM,NDISOM,NDPROD
C
C=======================================================================
C      DISPLAYING VARIOUS PREPROCESSOR OPTIONS
C=======================================================================
C
      I_SWITCH_PORT=0
      I_SWITCH_DIAG=0
      I_SWITCH_ESSL=0
      I_SWITCH_QUAD=0
      I_SWITCH_VECT=0
#if(SWITCH_PORT==1)
      I_SWITCH_PORT=1
#endif
#if(SWITCH_DIAG==1)
      I_SWITCH_DIAG=1
#endif
#if(SWITCH_DIAG==2)
      I_SWITCH_DIAG=2
#endif
#if(SWITCH_DIAG==3)
      I_SWITCH_DIAG=3
#endif
#if(SWITCH_DIAG==4)
      I_SWITCH_DIAG=4
#endif
#if(SWITCH_ESSL==1)
      I_SWITCH_ESSL=1
#endif
#if(SWITCH_QUAD==1)
      I_SWITCH_QUAD=1
#endif
#if(SWITCH_VECT==1)
      I_SWITCH_VECT=1
#endif
C
      WRITE(NFIPRI,'(''*'',77X,''*'',/,''*  PRE-PROCESSOR OPTIONS:'',
     *             53X,''*'',/,''*'',77X,''*'',/,
     *             ''*       switch_port = '',I1,
     *             ''     switch_diag = '',I1,
     *             ''     switch_essl = '',I1,15X,''*'',/,
     *             ''*'',77X,''*'',/,''*       '',15X,
     *             ''     switch_quad = '',I1,
     *             ''     switch_vect = '',I1,15X,''*'',/,
     *             ''*'',77X,''*'',/,79(''*''))')
     *             I_SWITCH_PORT,I_SWITCH_DIAG,I_SWITCH_ESSL,
     *                           I_SWITCH_QUAD,I_SWITCH_VECT
C
C=======================================================================
C         PRINTING THE DATE AND TIME
C=======================================================================
C
      CALL DATE_AND_TIME(MYDATE,MYTIME,MYZONE,MYVALU)
C
      WRITE(NFIPRI,'(                         1H*,77X,1H*,/,1H*,2X,
     *      ''EXECUTION BEGINS ON '',A4,''.'',A2,''.'',A2,'' AT '',
     *                               A2,'':'',A2,'':'',A6,
     *                              29X,1H*,/,1H*,77X,1H*,/,79(1H*))')
     *
     *      MYDATE(1:4),MYDATE(5:6),MYDATE(7:8),
     *      MYTIME(1:2),MYTIME(3:4),MYTIME(5:10)
C
C=======================================================================
C      CHECKING THE CONSISTENCY OF THE LODED MODULES
C=======================================================================
C      ATTENTION FUTURE DEVELOPERS:
C      TO PROPERLY MAINTAIN THE MODULE VERSION-NUMBER CHECKING, AT EVERY
C      MODIFICATION OF A MODULE ONE SHOULD UPDATE ITS VERSION NUMBER:
C      1. IN THE NAME OF THE FILE CONTAINING THE MODULE
C      2. IN THE SUBROUTINE Set_version_hfodd_[NAME] INSIDE THE MODULE
C      2. IN THE MAKEFILE
C      3. IN THE BLOCK DATA List_of_modules @ THE BEGINNING OF THIS FILE
C
C      ANY NEW MODULE SHOULD BE ADDED TO THE MAKEFILE AND TO THE LIST OF
C      MODULES @ THE BEGINNING OF THIS FILE, WHERE THE VALUE OF VARIABLE
C      "MODTOT" SHOULD BE, IN ADDITION, INCREASED BY ONE.
C=======================================================================
C
      MODSET(:)=0
C
      CALL Set_version_hfodd_sizes
      CALL Set_version_hfodd_modules
      CALL Set_version_hfodd_hfbtho
      CALL Set_version_hfodd_interface
      CALL Set_version_hfodd_functional
#if(USE_MPI==1)
      CALL Set_version_hfodd_mpiio
      CALL Set_version_hfodd_mpimanager
#endif
      CALL Set_version_hfodd_shell
#if(USE_SCALAPACK==1)
      CALL Set_version_hfodd_SLsiz
#endif
      CALL Set_version_hfodd_fission
      CALL Set_version_hfodd_pairs
      CALL Set_version_hfodd_pnp
#if(USE_FITS==1)
      CALL Set_version_hfodd_fits
#endif
      CALL Set_version_hfodd_lipcorr
      CALL Set_version_hfodd_tgrad
      CALL Set_version_hfodd_wigner
      CALL Set_version_hfodd_twocen
      CALL Set_version_hfodd_adiabatic
C
      IMODOK=1
C
      DO NUMODU=1,MODTOT
C
         IF (MODSET(NUMODU).GE.1.AND.
     *      (MODSET(NUMODU).NE.MODORD(NUMODU).OR.
     *       NAMODU(NUMODU).NE.NAMMOD(NUMODU).OR.
     *       MODVER(NUMODU).NE.MODUVE(NUMODU))) THEN
C
             IF (IMODOK.EQ.1)
     *           WRITE(NFIPRI,'(                1H*,77X,1H*,/,
     *        1H*,2X,''INCORRECT VERSIONS OF LOADED MODULES'',
     *               '' -- THE CODE CANNOT RUN AND STOPS NOW'',2X,1H*,/,
     *                                          1H*,77X,1H*,/,
     *        1H*,2X,'' -----------------------------------'',
     *               ''------------------------------------ '',2X,1H*,/,
     *        1H*,2X,''|            | MODULE   R E Q U I R '',
     *               ''E D   || MODULE     L O A D E D     |'',2X,1H*,/,
     *        1H*,2X,''|   MODULE   |----------------------'',
     *               ''------||----------------------------|'',2X,1H*,/,
     *        1H*,2X,''| NUM1  NUM2 | NAME             | VE'',
     *               ''RSION || NAME             | VERSION |'',2X,1H*,/,
     *        1H*,2X,''|------------|------------------|---'',
     *               ''------||------------------|---------|'',2X,1H*)')
C
             IMODOK=0
C
             WRITE (NFIPRI,'(''*  |  '',I2,4X,I2,''  | '',
     *                        A16,'' |  '',I3,''    || '',
     *                        A16,'' |  '',I3,''    |  *'')')
     *              MODSET(NUMODU),MODORD(NUMODU),
     *              NAMODU(NUMODU),MODVER(NUMODU),
     *              NAMMOD(NUMODU),MODUVE(NUMODU)
C
         END IF
C
      END DO
C
      IF (IMODOK.EQ.0) THEN
C
          WRITE(NFIPRI,'(
     *        1H*,2X,'' -----------------------------------'',
     *               ''------------------------------------ '',2X,1H*,/,
     *                                          1H*,77X,1H*,/,79(1H*))')
          STOP 'INCORRECT VERSIONS OF LOADED MODULES'
C
      END IF
C
      WRITE(NFIPRI,*)
C
C=======================================================================
C         P R E S E T T I N G   T H E   D E F A U L T   V A L U E S
C=======================================================================
C
      CALL PREDEF(IN_FIX,IZ_FIX,SKYRME,GOGNAM,ISTAND,
     *            KETA_J,KETA_W,KETACM,KETA_M,KETA_P,
     *                          KETA_T,KETAPA,NOZEPA,
     *                          ITWOLI,KETA_R,
     *                          KETAJ2,KETAT2,
     *     LANODD,LANSCA,HBMSAT,RHOSAT,EFFSAT,
     *     ILIBAS,INBASI,IZBASI,FCHOM0,R0PARM,
     *                                 IOPTGS,
     *     IPAIRI,IPAHFB,ITWOBA,IPABCS,IMFHFB,
     *                                 IPNMIX,
     *                          LIPKIN,LIPKIP,
     *                          LIPNON,LIPNOP,
     *                   IPNPRJ,NPPNPN,NPPNPP,
     *            IROTAT,ITIREP,IREVIE,IQPSTA,
     *            DELFIN,DELFIP,IDEFIN,IDEFIP,
     *            FERFIN,FERFIP,IFEFIN,IFEFIP,
     *            FE2FIN,FE2FIP,IF2FIN,IF2FIP,
     *            FERALN,FERALP,IFERAN,IFERAP,
     *                                 NUQEVE,
     *            INSIGN,IPSIGN,ISSIGN,IDSIGN,
     *            INSIGP,IPSIGP,ISSIGP,IDSIGP,
     *                   INSIMN,IRSIMN,IDSIMN,
     *                   INSIMP,IRSIMP,IDSIMP,
     *                   INSIQN,IPSIQN,IDSIQN,
     *                   INSIQP,IPSIQP,IDSIQP,
     *                          INSIZN,IDSIZN,
     *                          INSIZP,IDSIZP,
     *                          IFIBLN,INIBLN,
     *                          IFIBLP,INIBLP,
     *                                 IREAWS,
     *                   ICONTI,IPCONT,IOCONT,
     *                   ISCONT,ITCONT,IACONT,
     *            IYCONT,IGCONT,IGPCON,IECONT,
     *     ILCONT,IFCONT,IMCONT,IRCONT,IBCONT,
     *     NUCHAO,NUPING,EPSPNG,EPSITE,EPSCON,
     *            ISPHER,ISIMPY,ISIGNY,IPARTY,
     *                   ISIMTX,ISIMTY,ISIMTZ,
     *            IMOVAX,ITILAX,ITISAX,NO_ORB,
     *                   NOITER,NULAST,NUCONS,
     *            ISYMDE,INIROT,INIINV,INIKAR,
     *                   IRENMA,IRENIN,IDOGOA,
     *                   IFRWAV,ITOWAV,IWRWAV,
     *                          ISAKER,ICHKER,
     *                   IPRROT,IPRISO,IPRIS3,
     *                   IPRNUM,IPRVEC,IPRPTY,
     *                          IPROMI,IPROMA,
     *                   NUAKNO,NUBKNO,KPROJE,
     *                   NATKNO,NBTKNO,KSOSTZ,
     *            NPNKNO,NTZKNO,NPAKNO,IPAPRO,
     *                          KSOSMI,KSOSMA,
     *                   ISOSAD,EPSISO,ICSKIP,
     *     IFERME,IBETME,IIFERR,ITFERR,ISFERR,
     *            IPAKER,IPAK3D,IPAALL,KFIKER,
     *            NUASTA,NUASTO,NUGSTA,NUGSTO,
     *            NATSTA,NATSTO,NGTSTA,NGTSTO,
     *            NUBSTA,NUBSTO,NUTSTA,NUTSTO,
     *                   ICUTOV,CUTOVE,CUTOVF,
     *                   IONISH,ISLPRI,ISUPRI,
     *                   IENPRI,ISRPRI,IMIPRI,
     *                   IKEPRI,IRMPRI,IELPRI,
     *            QMUCUT,QMACUT,QASCUT,QSICUT,
     *                   NOSCIL,NLIMIT,ENECUT,
     *                   NUMCOU,NUMETA,FURMAX,
     *            ICOTYP,ICOUDI,ICOUEX,E_EFFE,
     *            PIMASS,PNMASS,IYUTYP,I_YUKA,
     *            YUKAGT,YUKAG0,YUKAG1,YUKAG2,
     *                          I_GOGA,IGOGPA,
     *                          I_REGA,IREGPA,
     *                          I_SEPA,ISEPPA,
     *                          I_COUA,ICOUPA,
     *                          N3SERD,IDOTHC,
     *            I1LINE,IPRSTA,IPRMID,IPRSTO,
     *            IDESTA,IDEMID,IDESTO,IDEDIS,
     *                          INTRIP,IVIPRI,
     *                   IPRI_N,IPRI_P,IPRI_T,
     *                   NMUCON,NMUCOU,NMUPRI,
     *                   ISCHIF,NSICON,NSIPRI,
     *                   NMACON,NMAPRI,NMAORD,
     *                   NASCON,NASPRI,NASORD,
     *                                 NRAORD,
     *            NMURED,NMARED,NASRED,NSIRED,
     *                   NEXBET,IPRIBE,IPRIBL,
     *            IWRIOL,IWRISO,IWRIRE,IWRIBA,
     *                   IWRIYU,IWRIGO,IWRIRO,
     *            IWRILI,IWRIFI,IWRIQU,IWRIRM,
     *                   FILISO,FILREP,FILREC,
     *                   FILWOO,FILREV,FILCOU,
     *                          FILWAV,FILKER,
     *                          FILYUP,FILYUC,
     *                          FILGOP,FILGOC,
     *                          FILGPP,FILGPC,
     *                          FILROP,FILROC,
     *                          FILLIP,FILLIC,
     *                   FILFIP,FILFIC,FILFER,
     *                          FILQUA,FILRED,
     *                          FILBAP,FILBAC,
     *                   ICHFLI,IPAFLI,IREFLI,
     *                   ISPFLI,ISHFLI,IFLIPI,
     *            SLOWEV,SLOWOD,SLOWPA,SLOWLI,
     *                          ICOULI,ICOULO,
     *                          FACTGN,FACTGP,
     *                          EMINAL,EMAXAL,
     *            EMAXQU,ECUTOF,LIMQUA,LAMCUT,
     *                          IQUNIL,NILXYZ,
     *                                 IAVRGG,
     *                                 IPOTHO,
     *                                 EPSHER,
     *                   ICOMIX,INLKER,INRKER,
     *                   ICMPRI,IN_EXC,EPSMIX,
     *                          ISOADD,NBTKNT,
     *                   IFSHEL,IF_RPA,IFRTHO,
     *            PRHD_T,PRHDDT,PRHDST,POWDRT,
     *                   IFRAGM,NUMPUS,IFPUSH,
     *     DELTAE,XLOCMX,V2_MIN,ITRMAX,NTHETA,
     *            MIN_QP,IDEALL,IDELOC,IDECON,
     *                   ILIPON,ILIPOP,GAUSHI,
     *                          I_SLOW,SLOWAL,
     *            SLOWLD,SLOWTP,SLOWRP,SLOWLM,
     *     NLSIGN,NLSIMN,NLSIQN,NLSIZN,MXALIN,
     *     NLSIGP,NLSIMP,NLSIQP,NLSIZP,MXALIP,
     *                          LASTAN,LASTAP,
     *                   IAXIAP,KAPASY,INUNIL,
     *                                 IADBAT,
     *                          NEWGOG,NEWCOU,
     *                                 ITWCEN,
     *                          IEIGCU,EIGCUT,
     *                          NLIMTW,ENECTW,
     *                                 IFRCNT)
C
C=======================================================================
C         I N I T I A L I Z I N G   O U T P U T   T O   Z E R O
C=======================================================================
C
      CALL ZEROUT
C
C=======================================================================
C         DEFINING THE NEWTON BINOMIAL COEFFICIENTS, FACTORIALS, SIMPLE
C         GAUSS  INTEGRALS,  AND  ORTHOGONAL  POLYNOMIAL  NORMALIZATION
C         FACTORS
C=======================================================================
C
      CALL DEFBIN
      CALL DEFBIR
      CALL DEFGAU
      CALL DEFFAC
      CALL NORHER
C
C=======================================================================
C         HERE STARTS CALCULATION FOR ONE INPUT-DATA SET
C=======================================================================
C
      batch_init=1
C
      IF_THO=IFRTHO
C
#if(USE_MPI==0)
C
      NUDATA=0
C
    3 CONTINUE
C
      NUDATA=NUDATA+1
C
#endif
C
C=======================================================================
C         READING THE INPUT DATA
C=======================================================================
#if(USE_MPI==1)
C
C     - master processor reads the common input and broadcasts the
C       data, which are then passed to local HFODD variables
C     - master processor reads the parallel input and broadcasts
C       the data which are then used by all processors to construct
C       list of jobs
C
      CALL mpi_getSequentialData()
C
      ! Get sequential data
C
C=======================================================================
C
      CALL mpi_setSequentialData(IOPTGS,NXHERM,NYHERM,NZHERM,
     *                           IPAIRI,IPAHFB,IPABCS,IMFHFB,
     *                                         LIPKIN,LIPKIP,
     *                           FE2FIN,IF2FIN,FE2FIP,IF2FIP,
     *                                         IROTAT,IREVIE,
     *                           ICONTI,IPCONT,IGCONT,IGPCON,
     *                                  ILCONT,IFCONT,IACONT,
     *                           NUCHAO,NUPING,EPSPNG,EPSITE,
     *                                  ISIMPY,ISIGNY,IPARTY,
     *                                  ISIMTX,ISIMTY,ISIMTZ,
     *                                         NOITER,NULAST,
     *                                  NOSCIL,NLIMIT,ENECUT,
     *                                  ICOTYP,ICOUDI,ICOUEX,
     *                                         I_GOGA,IGOGPA,
     *                                                I1LINE,
     *                           SLOWEV,SLOWOD,SLOWPA,SLOWLI,
     *                                                ECUTOF,
     *                                                NILXYZ,
     *                           IBROYD,N_ITER,BROTRI,ALPHAM,
     *                                  PRHO_T,PRHOST,POWERT,
     *                                                OMEGAY,
     *                    IFSHEL,MPOLYN,G_STUN,G_STUP,H_OMFA,
     *                           LAMBAS,MIUBAS,BETBAS,NUMDEF,
     *                    LAM_WS,MIU_WS,NUM_WS,ITE_WS,STP_WS,
     *                    LAMPUS,MIUPUS,NUMPUS,QMOPUS,IFPUSH,
     *                                         NITPUS,IREAWS,
     *                    ISTAND,KETA_J,KETA_W,KETACM,KETA_M,
     *                           IF_RPA,IF_EDF,IF_THO,CBETHO,
     *                                  IBASIS,IHFPOT,IFRAGM,
     *                                  NMUCON,NMUCOU,NMUPRI,
     *                                  NEXBET,IPRIBE,IPRIBL,
     *                                                FCHOM0,
     *                                  L_COLL,M_COLL,N_COLL,
     *                                                IWRIFI,
     *                                  INBASI,IZBASI,R0PARM,
     *                    DELTAE,XLOCMX,V2_MIN,ITRMAX,NTHETA,
     *                           MIN_QP,IDEALL,IDELOC,IDECON)
C
      ! Deformation of the basis: fixed or automatically
      ! adjusted on requested value of Q2
C
      IF (ASSOCIATED(LAMBAS)) THEN
C
          DO I=1,NUMDEF
             LAMACT=ABS(LAMBAS(I))
             MIUACT=MIUBAS(I)
             ALPHAR(LAMACT,MIUACT)=BETBAS(I)
          END DO
C
      END IF
C
      ! data for shell correction
C
      NPOLYN=MPOLYN
      GSTRUN=G_STUN
      GSTRUP=G_STUP
      HOMFAC=H_OMFA
C
      ! By default, computing pairing properties separately
      ! for neutrons and protons
C
      CALL RHODEP(2,PRHO_N,PRHODN,PRHOSN,POWERN)
C
      CALL RHODEP(2,PRHO_P,PRHODP,PRHOSP,POWERP)
C
      ! If the user set the keyword PAIR_INTER in the input file
      ! neutron and proton pairing properties are the same and
      ! overwritten here (same mechanism as NAMELI)
C
      IF (ABS(PRHO_T).GT.1.E-10) THEN
C
          PRHO_N=PRHO_T
          PRHOSN=PRHOST
          POWERN=POWERT
C
          CALL RHODEP(2,PRHO_N,PRHODN,PRHOSN,POWERN)
C
          PRHO_P=PRHO_T
          PRHOSP=PRHOST
          POWERP=POWERT
C
          CALL RHODEP(2,PRHO_P,PRHODP,PRHOSP,POWERP)
C
      END IF
C
      ! Get parallel data (I/O done only by root processor)
C
      CALL mpi_initializeParallelData()
C
      CALL mpi_getParallelData()
C
      CALL mpi_setParallelData()
C
      CALL mpi_printParallelData()
C
      ! Construct job list based on parallel data (all processors)
C
      IERROR=0
      CALL mpi_constructJobList(NUMITE,NXHERM,NYHERM,NZHERM,
     *                          IPCONT,ILCONT,IACONT,IMCONT,IRCONT,
     *                                               IRENMA,IRENIN,
     *                                               LIPKIN,LIPKIP,
     *                                        REFERN,REFERP,REDELN,
     *                                        REDELP,REFE2N,REFE2P,
     *                                 IFIBLN,INIBLN,IFIBLP,INIBLP,
     *                                 NMUMAX,NSIMAX,NMUCON,ISHIFT,
     *                                                      IF_THO,
     *                                                      IERROR)
C
      ! Construct job list based on parallel data (all processors)
C
      procLoop: DO INDJOB=1,NOFJOB
C
         ! Execute only if
         IF (color .EQ. MOD(INDJOB-1, numberMasters)) THEN
C
             MNSIQN=INSIQN(1)
             MPSIQN=IPSIQN(1)
             MDSIQN=IDSIQN(1)
             MNSIQP=INSIQP(1)
             MPSIQP=IPSIQP(1)
             MDSIQP=IDSIQP(1)
C
             CALL mpi_getCurrentData(INDJOB,IN_FIX,IZ_FIX,
     *                                             SKYRME,GOGNAM,
     *                                      MNSIQN,MPSIQN,MDSIQN,
     *                                      MNSIQP,MPSIQP,MDSIQP,
     *                               INSIGN,IPSIGN,ISSIGN,IDSIGN,
     *                               INSIGP,IPSIGP,ISSIGP,IDSIGP,
     *                               ICONTI,IPCONT,ILCONT,IFCONT,
     *                                                    I_GOGA,
     *                               SLOWEV,SLOWOD,SLOWPA,SLOWLI,
     *                                                    IROTAT,
     *                                                    NILXYZ,
     *                                                    N_EXIT,
     *                                                    NOITER,
     *                                      FCHOM0,NOSCIL,NLIMIT,
     *                                             LIPKIN,LIPKIP,
     *                               NXHERM,NYHERM,NZHERM,IOPTGS,
     *                                      IPAIRI,IPAHFB,IMFHFB,
     *                                                    IWRILI,
     *                                                    EPSITE,
     *                                                    INIROT,
     *                                                    IGAMMA,
     *                                                    LANODD,
     *                               IFIBLN,INIBLN,IFIBLP,INIBLP,
     *                                                    NMUCON,
     *                                                    IFSHEL,
     *                                                    IF_RPA,
     *                                                    INDFIL,
     *                                                    TEMP_T)
C
             IF (ABS(TEMP_T).GT.1.D-12) IFTEMP=1
C
             CALL mpi_printSequentialData(IOPTGS,NXHERM,NYHERM,NZHERM,
     *                                    IPAIRI,IPAHFB,IPABCS,IMFHFB,
     *                                                  LIPKIN,LIPKIP,
     *                                    FE2FIN,IF2FIN,FE2FIP,IF2FIP,
     *                                                  IROTAT,IREVIE,
     *                                    ICONTI,IPCONT,IGCONT,IGPCON,
     *                                           ILCONT,IFCONT,IACONT,
     *                                    NUCHAO,NUPING,EPSPNG,EPSITE,
     *                                           ISIMPY,ISIGNY,IPARTY,
     *                                           ISIMTX,ISIMTY,ISIMTZ,
     *                                                  NOITER,NULAST,
     *                                           NOSCIL,NLIMIT,ENECUT,
     *                                           ICOTYP,ICOUDI,ICOUEX,
     *                                                  I_GOGA,IGOGPA,
     *                                                         I1LINE,
     *                                    SLOWEV,SLOWOD,SLOWPA,SLOWLI,
     *                                                         ECUTOF,
     *                                                         NILXYZ,
     *                                    IBROYD,N_ITER,BROTRI,ALPHAM,
     *                                           PRHO_T,PRHOST,POWERT,
     *                                    PRHO_N,PRHOSN,PRHODN,POWERN,
     *                                    PROD_P,PRHOSP,PRHODP,POWERP,
     *                                                         OMEGAY,
     *                             IFSHEL,NPOLYN,GSTRUN,GSTRUP,HOMFAC,
     *                                    LAMBAS,MIUBAS,BETBAS,NUMDEF,
     *                             LAM_WS,MIU_WS,NUM_WS,ITE_WS,STP_WS,
     *                                           LMXINP,IFPUSH,IREAWS,
     *                             ISTAND,KETA_J,KETA_W,KETACM,KETA_M,
     *                                    IF_RPA,IF_EDF,IF_THO,CBETHO,
     *                                                  IBASIS,IFRAGM,
     *                                           NMUCON,NMUCOU,NMUPRI,
     *                                           NEXBET,IPRIBE,IPRIBL,
     *                                                         FCHOM0,
     *                                           IWRIFI,IFTEMP,IFNECK,
     *                                           INBASI,IZBASI,R0PARM,
     *                             DELTAE,XLOCMX,V2_MIN,NTHETA,MIN_QP,
     *                                           IDEALL,IDELOC,IDECON,
     *                                                     batch_init)
C
#else
C
      ALLOCATE(LAMPUS(1:NDMULT))
      ALLOCATE(MIUPUS(1:NDMULT))
      ALLOCATE(QMOPUS(1:NDMULT))
C
      CALL NAMELI(IN_FIX,IZ_FIX,SKYRME,GOGNAM,ISTAND,
     *            KETA_J,KETA_W,KETACM,KETA_M,KETA_P,
     *                          KETA_T,KETAPA,NOZEPA,
     *                          ITWOLI,KETA_R,
     *                          KETAJ2,KETAT2,
     *     LANODD,LANSCA,HBMSAT,RHOSAT,EFFSAT,
     *     ILIBAS,INBASI,IZBASI,FCHOM0,R0PARM,
     *                                 IOPTGS,
     *     IPAIRI,IPAHFB,ITWOBA,IPABCS,IMFHFB,
     *                                 IPNMIX,
     *                          LIPKIN,LIPKIP,
     *                          LIPNON,LIPNOP,
     *                   IPNPRJ,NPPNPN,NPPNPP,
     *            IROTAT,ITIREP,IREVIE,IQPSTA,
     *            DELFIN,DELFIP,IDEFIN,IDEFIP,
     *            FERFIN,FERFIP,IFEFIN,IFEFIP,
     *            FE2FIN,FE2FIP,IF2FIN,IF2FIP,
     *            FERALN,FERALP,IFERAN,IFERAP,
     *                                 NUQEVE,
     *            INSIGN,IPSIGN,ISSIGN,IDSIGN,
     *            INSIGP,IPSIGP,ISSIGP,IDSIGP,
     *                   INSIMN,IRSIMN,IDSIMN,
     *                   INSIMP,IRSIMP,IDSIMP,
     *                   INSIQN,IPSIQN,IDSIQN,
     *                   INSIQP,IPSIQP,IDSIQP,
     *                          INSIZN,IDSIZN,
     *                          INSIZP,IDSIZP,
     *                          IFIBLN,INIBLN,
     *                          IFIBLP,INIBLP,
     *                                 IREAWS,
     *                   ICONTI,IPCONT,IOCONT,
     *                   ISCONT,ITCONT,IACONT,
     *            IYCONT,IGCONT,IGPCON,IECONT,
     *     ILCONT,IFCONT,IMCONT,IRCONT,IBCONT,
     *     NUCHAO,NUPING,EPSPNG,EPSITE,EPSCON,
     *            ISPHER,ISIMPY,ISIGNY,IPARTY,
     *                   ISIMTX,ISIMTY,ISIMTZ,
     *            IMOVAX,ITILAX,ITISAX,NO_ORB,
     *                   NOITER,NULAST,NUCONS,
     *            ISYMDE,INIROT,INIINV,INIKAR,
     *                   IRENMA,IRENIN,IDOGOA,
     *                   IFRWAV,ITOWAV,IWRWAV,
     *                          ISAKER,ICHKER,
     *                   IPRROT,IPRISO,IPRIS3,
     *                   IPRNUM,IPRVEC,IPRPTY,
     *                          IPROMI,IPROMA,
     *                   NUAKNO,NUBKNO,KPROJE,
     *                   NATKNO,NBTKNO,KSOSTZ,
     *            NPNKNO,NTZKNO,NPAKNO,IPAPRO,
     *                          KSOSMI,KSOSMA,
     *                   ISOSAD,EPSISO,ICSKIP,
     *     IFERME,IBETME,IIFERR,ITFERR,ISFERR,
     *            IPAKER,IPAK3D,IPAALL,KFIKER,
     *            NUASTA,NUASTO,NUGSTA,NUGSTO,
     *            NATSTA,NATSTO,NGTSTA,NGTSTO,
     *            NUBSTA,NUBSTO,NUTSTA,NUTSTO,
     *                   ICUTOV,CUTOVE,CUTOVF,
     *                   IONISH,ISLPRI,ISUPRI,
     *                   IENPRI,ISRPRI,IMIPRI,
     *                   IKEPRI,IRMPRI,IELPRI,
     *            QMUCUT,QMACUT,QASCUT,QSICUT,
     *                   NOSCIL,NLIMIT,ENECUT,
     *                   NUMCOU,NUMETA,FURMAX,
     *            ICOTYP,ICOUDI,ICOUEX,E_EFFE,
     *            PIMASS,PNMASS,IYUTYP,I_YUKA,
     *            YUKAGT,YUKAG0,YUKAG1,YUKAG2,
     *                          I_GOGA,IGOGPA,
     *                          I_REGA,IREGPA,
     *                          I_SEPA,ISEPPA,
     *                          I_COUA,ICOUPA,
     *                          N3SERD,IDOTHC,
     *            I1LINE,IPRSTA,IPRMID,IPRSTO,
     *            IDESTA,IDEMID,IDESTO,IDEDIS,
     *                          INTRIP,IVIPRI,
     *                   IPRI_N,IPRI_P,IPRI_T,
     *                   NMUCON,NMUCOU,NMUPRI,
     *                   ISCHIF,NSICON,NSIPRI,
     *                   NMACON,NMAPRI,NMAORD,
     *                   NASCON,NASPRI,NASORD,
     *                                 NRAORD,
     *            NMURED,NMARED,NASRED,NSIRED,
     *                   NEXBET,IPRIBE,IPRIBL,
     *            IWRIOL,IWRISO,IWRIRE,IWRIBA,
     *                   IWRIYU,IWRIGO,IWRIRO,
     *            IWRILI,IWRIFI,IWRIQU,IWRIRM,
     *                   FILISO,FILREP,FILREC,
     *                   FILWOO,FILREV,FILCOU,
     *                          FILWAV,FILKER,
     *                          FILYUP,FILYUC,
     *                          FILGOP,FILGOC,
     *                          FILGPP,FILGPC,
     *                          FILROP,FILROC,
     *                          FILLIP,FILLIC,
     *                   FILFIP,FILFIC,FILFER,
     *                          FILQUA,FILRED,
     *                          FILBAP,FILBAC,
     *                   ICHFLI,IPAFLI,IREFLI,
     *                   ISPFLI,ISHFLI,IFLIPI,
     *            SLOWEV,SLOWOD,SLOWPA,SLOWLI,
     *                          ICOULI,ICOULO,
     *                          FACTGN,FACTGP,
     *                          EMINAL,EMAXAL,
     *            EMAXQU,ECUTOF,LIMQUA,LAMCUT,
     *                          IQUNIL,NILXYZ,
     *                                 IAVRGG,
     *                                 IPOTHO,
     *                                 EPSHER,
     *                   ICOMIX,INLKER,INRKER,
     *                   ICMPRI,IN_EXC,EPSMIX,
     *                          ISOADD,NBTKNT,
     *                   IFSHEL,IF_RPA,IFRTHO,
     *            PRHD_T,PRHDDT,PRHDST,POWDRT,
     *                                 IFRAGM,
     *     DELTAE,XLOCMX,V2_MIN,ITRMAX,NTHETA,
     *            MIN_QP,IDEALL,IDELOC,IDECON,
     *                   ILIPON,ILIPOP,GAUSHI,
     *                          I_SLOW,SLOWAL,
     *            SLOWLD,SLOWTP,SLOWRP,SLOWLM,
     *     NLSIGN,NLSIMN,NLSIQN,NLSIZN,MXALIN,
     *     NLSIGP,NLSIMP,NLSIQP,NLSIZP,MXALIP,
     *                          LASTAN,LASTAP,
     *                   IAXIAP,KAPASY,INUNIL,
     *                                 IADBAT,
     *                          NEWGOG,NEWCOU,
     *                                 ITWCEN,
     *                          IEIGCU,EIGCUT,
     *                          NLIMTW,ENECTW,
     *                                 IFRCNT)
C
      INDFIL=0
      INDJOB=1
C
      IF_THO=IFRTHO
C
C=======================================================================
C         SETTING THE BASIS DEFORMATIONS TO THOSE READ FROM THE INPUT
C=======================================================================
C
      ALPHAR(:,:)=ALPHRE(:,:)
C
#endif
C
C=======================================================================
C         HERE STARTS THE LOOP OVER BATCH NUMBER (PARALLEL MODE ONLY)
C=======================================================================
#if(USE_MPI==1)
C
C      Backup copy of IF_THO
      ITHOBK=IF_THO
      NUDATA=1
C
      DO
C
C         Restoring the IF_THO flag that has been set to 0 after the
C         first iteration
         IF (NUDATA.GT.1) IF_THO=ITHOBK
C
#endif
C
C      By default, symmetrize the calculation of the densities in
C      the routine DENSHF
      do_symmetrize = .True.
C
      TERMNT=.FALSE.
      IS_YES=0
      IS_PIN=0
      IS_CHA=0
      IS_CON=0
      ITERUN=0
      ISHIFT=0
C
      ISGOGA=0 ! Gogny mean field
      ISGOGP=0 ! Gogny pairing field
      ISREGA=0 ! Regularized mean field
      ISREGP=0 ! Regularized pairing field
      ISSEPA=0 ! Separable mean field
      ISSEPP=0 ! Separable pairing field
      ISFSTA=0 ! Spin-orbit and tensor mean field
      ISFSTP=0 ! Spin-orbit and tensor pairing field
C
      LDPNMX=1 ! default for no proton-neutron mixing
C
C      Mixing of matrix elements (p and n separated)
      NOFBRN=0
      NOFBRP=0
      NSWBRN=1000000
      NSWBRP=1000000
      ITAK_N=0
      ITAK_P=0
      NOICAN=NOIINP
C
C      Mixing of fields (p and n combined)
      NOFBRO=0
      NSWBRO=1000
      ITAKEN=0
      KEPTES=0
C
      IS_DLI=0
C
C      Counting and defining the active constraints
C
                       DOPUSH=.FALSE.
      IF (IFPUSH.EQ.1) DOPUSH=.TRUE.
C
C REMOVED INTERFACES 170407
C     CALL NUMCON(LAMPUS,MIUPUS,QMOPUS,NUMPUS,IF_RPA,IFPUSH,DOPUSH)
C
C=======================================================================
C      AUTOMATIC ADJUSTMENT OF THE BASIS DEFORMATION AND FREQUENCIES
C      BASED ON REQUESTED VALUE OF THE QUADRUPOLE MOMENT.  FCHOM0 IS
C      A MULTIPLICATIVE  FACTOR OF  BASIC FREQUENCY  41/A^(1/3). THE
C      DEFORMATION OF THE BASIS PASSED THROUGH COMMON BLOCK.
C=======================================================================
C
CLP@+
      CALL NUMCON(IF_RPA)
CLP@-
      IF (IBASIS.EQ.1.AND.batch_init.EQ.1)
     *    CALL ADJBAS(FCHOM0,IN_FIX,IZ_FIX)
C
C=======================================================================
C
      IDOPLM=0
C
C=======================================================================
C
      ISQPRO=0
C
C=======================================================================
C      OPENING ALL RELEVANT FILES FOR I/O
C=======================================================================
C
      IF (batch_init.EQ.1) THEN
          CALL IOFILE(IREAWS,ICONTI,IFCONT,IYCONT,ILCONT,IGCONT,
     *                IGPCON,IECONT,IWRIRE,IWRILI,IWRIYU,IWRIGO,
     *                IWRIRO,IWRIFI,IWRISO,IWRIQU,IWRIRM,
     *
     *                LIPKIN,LIPKIP,I_YUKA,I_GOGA,IGOGPA,I_REGA,
     *                INDFIL,INDJOB,IREVIE,IF_THO,NEWGOG,
     *
     *                NFIWOO,NFIREP,NFIREC,NFIREV,NFICOU,NFIWAV,
     *                NFIKER,NFIYUP,NFIYUC,NFIGOP,NFIGOC,NFIGPC,
     *                NFIGPP,NFIROP,NFIROC,NFILIP,NFILIC,NFIFIP,
     *                NFIFIC,NFIISO,NFIQUA,NFIRED,NFIBAC,NFIBAP,
     *                NFIFER,
     *
     *                FILWOO,FILREP,FILREC,FILREV,FILCOU,FILWAV,
     *                FILKER,FILYUP,FILYUC,FILGOP,FILGOC,FILGPC,
     *                FILGPP,FILROP,FILROC,FILLIP,FILLIC,FILFIP,
     *                FILFIC,FILISO,FILQUA,FILRED)
      END IF
C
C=======================================================================
C         INPUT-RELATED PREDEFINITIONS
C=======================================================================
C
      NVASIZ(0)=IN_FIX+MVASIZ(0)
      NVASIZ(1)=IZ_FIX+MVASIZ(1)
C
      IF (KVASIZ(0).NE.0) NVASIZ(0)=KVASIZ(0)
      IF (KVASIZ(1).NE.0) NVASIZ(1)=KVASIZ(1)
C
      NVAMIZ=IN_FIX+IZ_FIX
C
      IA_FIX=IN_FIX+IZ_FIX
C
                                      INNUMB=INBASI
      IF (ILIBAS.EQ.1.OR.ILIBAS.EQ.3) INNUMB=IN_FIX
                                      IZNUMB=IZBASI
      IF (ILIBAS.EQ.2.OR.ILIBAS.EQ.3) IZNUMB=IZ_FIX
C
C=======================================================================
C         SETTING "ISIQTY" ACCORDING TO THE ADOPTED COMPATIBILITY MODE
C=======================================================================
C
      IF (IPARTY.NE.-1) THEN
C
          ISIQTY=IPARTY
C
      ELSE
C
          IF (ISIGNY.EQ.1.AND.ISIMPY.EQ.1) THEN
C
              ISIQTY=1
          ELSE
              ISIQTY=0
C
          END IF
C
      END IF
C
C=======================================================================
C         SETTING "JSIMTY" ACCORDING TO THE ADOPTED COMPATIBILITY MODE
C=======================================================================
C
      IF (ISIMTY.NE.-1) THEN
C
          JSIMTY=ISIMTY
C
      ELSE
C
          IF (IROTAT.EQ.1) THEN
              JSIMTY=0
          ELSE
              JSIMTY=1
          END IF
C
      END IF
C
C=======================================================================
C         SETTING "JPABCS" ACCORDING TO THE ADOPTED COMPATIBILITY MODE
C=======================================================================
C
      IF (IPABCS.NE.-1) THEN
C
          JPABCS=IPABCS
C
      ELSE
C
          IF (IPAHFB.GE.1) THEN
              JPABCS=0
          ELSE
              JPABCS=IPAIRI
          END IF
C
      END IF
C
C=======================================================================
C         SETTING THE ANGULAR FREQUENCY COMPONENTS TO THE INITIAL VALUES
C=======================================================================
C
      OMOVAX=OMEGAX
      OMOVAY=OMEGAY
      OMOVAZ=OMEGAZ
C
C=======================================================================
C         SETTING THE FERMI ENERGY COMPONENTS TO THE INITIAL VALUES
C=======================================================================
C
      FERMOV=FERISO
C
C=======================================================================
C         CLEARING THE STORAGE SWITCH OF THE SEPARABLE INTERATION
C=======================================================================
C
      ISEPDO=0
C
C=======================================================================
C         CHANGING THE PARITY/SIGNATURE NOTATION INTO THE
C         PARITY/TIME-REVERSAL NOTATION
C=======================================================================
C
      CALL SIGREV
C
C=======================================================================
C         SETTING THE ABSOLUTE CONFIGURATIONS
C=======================================================================
C
      IF (IPNMIX.NE.1) THEN
C
          IF (ISIMPY.EQ.1) THEN
C
              IF (ISIGNY.EQ.1) THEN
C
                  CALL SETSIG(IPAIRI)
              ELSE
                  CALL SETSIM(IPAIRI)
C
              END IF
C
          ELSE
C
              IF (ISIQTY.EQ.1) THEN
C
                  CALL SETSIQ(IPAIRI)
              ELSE
                  CALL SETSIZ(IPAIRI)
C
              END IF
C
          END IF
C
C=======================================================================
C         SETTING THE ABSOLUTE CONFIGURATIONS FOR PROTON-NEUTRON MIXING
C=======================================================================
C
      ELSE
C
          IF (ISIMPY.EQ.1) THEN
C
              IF (ISIGNY.EQ.1) THEN
C
                  CALL SETMIG(IPAIRI)
              ELSE
                  CALL SETMIM(IPAIRI)
C
              END IF
C
          ELSE
C
              IF (ISIQTY.EQ.1) THEN
C
                  CALL SETMIQ(IPAIRI)
              ELSE
                  CALL SETMIZ(IPAIRI)
C
              END IF
C
          END IF
C
      END IF
C
C=======================================================================
C         SETTING THE COULOMB, PHASE SPACE, AND PAIRING DATA
C=======================================================================
C
      BOUCOU=FURMAX*NUMCOU
C
      IF (NUMBSP(0,0).EQ.0) NUMBSP(0,0)=IN_FIX
      IF (NUMBSP(1,0).EQ.0) NUMBSP(1,0)=IN_FIX
C
      IF (NUMBSP(0,1).EQ.0) NUMBSP(0,1)=IZ_FIX
      IF (NUMBSP(1,1).EQ.0) NUMBSP(1,1)=IZ_FIX
C
      IF (IF_THO.EQ.0) THEN
C
          EFERMN=FERINI(0)
          DELTAN=DELINI(0)
          EFER2N=FE2INI(0)
C
          EFENIN=0.0D0
          EFENOU=EFERMN
          EF2NIN=0.0D0
          EF2NOU=EFER2N
C
          EFERMP=FERINI(1)
          DELTAP=DELINI(1)
          EFER2P=FE2INI(1)
C
          EFEPIN=0.0D0
          EFEPOU=EFERMP
          EF2PIN=0.0D0
          EF2POU=EFER2P
C
          EFERMA=FERINA
          DELTAA=DELINA
C
      END IF
C
C=======================================================================
C         SETTING SWITCH "NOSHIM" THAT BLOCKS PRINTING OF SHIFTED
C         MAGNETIC MOMENTS UNTIL THEIR CALCULATION IS  DEVELOPED.
C         WHEN THE PARITY IS BROKEN, THE ROTATED MAGNETIC MOMENTS
C         CANNOT BE PRINTED EITHER BECAUSE THEY SHOULD CORRESPOND
C         TO A ROTATION OF SHIFTED MOMENTS.
C=======================================================================
C
      NOSHIM=0
      IF (ISIQTY.NE.1) NOSHIM=1
C
C=======================================================================
C         WITHOUT ROTATION (IROTAT=0) AND WITHOUT BREAKING THE Y-SIMPLEX
C         SYMMETRY (ISIMPY=1), THE TIME-REVERSED BLOCK IS NOT EXPLICITLY
C         CALCULATED. THIS IS DONE BY USING MREVER=0, I.E. BY PERFORMING
C         THE LOOPS OVER IREVER ONLY FOR IREVER=0.  IN SUCH A CASE,  THE
C         ARRAYS FOR IREVER=1 REMAIN UNDEFINED.
C
C
C         IROTAT:    0  1
C         ISIMPY: 0  1  1  <--- MREVER
C                 1  0  1  <-'
C
C=======================================================================
C
      MREVER=1
      IF (ISIMPY.EQ.1.AND.IROTAT.NE.1) MREVER=0
C
C=======================================================================
C         SETTING THE VALUES OF LIMITS FOR ISOSPIN PROJECTION
C=======================================================================
C          ATTENTION!  KSOSTZ AND ISOSTZ BOTH DENOTE THE  FIXED  ISOSPIN
C                      PROJECTION  USED  IN  THE   1D-ISOSPIN-PROJECTION
C                      CALCULATIONS. HOWEVER:
C                      KSOSTZ IS READ IN THE INPUT DATA AND THUS IS  NOT
C                             SUPPOSED TO BE LATER CHANGED BY THE  CODE.
C                      ISOSTZ IS INITIALIZED TO KSOSTZ OR  IN_FIX-IZ_FIX
C                             AND THEN  USED  INTERNALLY  BY  THE  CODE.
C=======================================================================
C            ATTENTION: BETWEEN VERSIONS (2.66H)  AND (2.84),  VARIABLES
C                       ISOSTZ, ISOSMI, AND ISOSMA, WHERE NOT GIVEN  ANY
C                       VALUE UNLESS IPRISO=1 OR IPRIS3=1. THIS HAS BEEN
C                       CAUSING PROBLEMS IN PROANG WHENEVER THE  ANGULAR
C                       MOMENTUM PROJECTION WAS REQUESTED THROUGH  USING
C                       IPRROT=1. THIS BUG WAS CORRECTED  ON  11/01/2018
C                       IN VERSION (2.84A).
C=======================================================================
C
      ISOSTZ=KSOSTZ
      ISOSMI=KSOSMI
      ISOSMA=KSOSMA
      IPRGCM=0
C
      IF (IPRROT.GE.1) THEN
          IPRGCM=IPRROT
      END IF
C
      IF (IPRISO.GE.1) THEN
          ISOSTZ=IN_FIX-IZ_FIX
          ISOSMI=ABS(ISOSTZ)
          ISOSMA=ISOSMI+ISOSAD
          IPRGCM=IPRISO
      END IF
C
      IF (IPRIS3.GE.1) THEN
          ISOSTZ=KSOSTZ
          ISOSMI=KSOSMI
          ISOSMA=KSOSMA
          IPRGCM=IPRIS3
      END IF
C
      IF (IPRNUM.GE.1) THEN
          IPRGCM=IPRNUM
      END IF
C
      IF (IPRVEC.GE.1) THEN
          IPRGCM=IPRVEC
      END IF
C
      IF (IPRPTY.GE.1) THEN
          IPRGCM=IPRPTY
      END IF
C
C=======================================================================
C         TESTING THE CONSISTENCY OF THE PROJECTION SWITCHES
C=======================================================================
C
      INCONS=0
C
      IF (IPRROT.GE.1.AND.IPRROT.NE.IPRGCM) INCONS=1
      IF (IPRISO.GE.1.AND.IPRISO.NE.IPRGCM) INCONS=1
      IF (IPRIS3.GE.1.AND.IPRIS3.NE.IPRGCM) INCONS=1
      IF (IPRNUM.GE.1.AND.IPRNUM.NE.IPRGCM) INCONS=1
      IF (IPRVEC.GE.1.AND.IPRVEC.NE.IPRGCM) INCONS=1
      IF (IPRPTY.GE.1.AND.IPRPTY.NE.IPRGCM) INCONS=1
C
      IF (INCONS.EQ.1) THEN
C
          WRITE(NFIPRI,'(/,20(1H/),
     *        '' INCONSISTENT PROJECTION SWITCHES  '',20(1H/),/,20(1H/),
     *        '' FOUND ON THE INPUT FILE           '',20(1H/),/)')
C
          WRITE(NFIPRI,'(/,20(1H/),'' IPRROT ='',I2,
     *                             '' IPRISO ='',I2,
     *                             '' IPRIS3 ='',I2,2X,20(1H/),/,
     *                     20(1H/),'' IPRNUM ='',I2,
     *                             '' IPRVEC ='',I2,
     *                             '' IPRPTY ='',I2,2X,20(1H/),/,
     *                     20(1H/),''         '',2X,
     *                             ''         '',2X,
     *                             '' IPRGCM ='',I2,2X,20(1H/),/)')
     *    IPRROT,IPRISO,IPRIS3,
     *    IPRNUM,IPRVEC,IPRPTY,
     *                  IPRGCM
C
          STOP 'INCONSISTENT PROJECTION SWITCHES FOUND ON INPUT FILE'
C
      END IF
C
C=======================================================================
C         SETTING THE SWITCH THAT HANDLES SAVING ARRAYS "WAVOCC" AND
C         "V_OCCU"
C=======================================================================
C
      ISAOCC=0
      IF (IADBAT.EQ.1) ISAOCC=1
C
C=======================================================================
C         SETTING THE PARAMETERS THAT HANDLE THE ANGULAR-MOMENTUM
C         PROJECTION AND CALCULATION OF THE GCM KERNELS
C=======================================================================
C
      ISAWAV=0
      IF (IPRGCM.GE.1.OR.IRENMA.GE.1.OR.IRENIN.GE.1.OR.IWRWAV.GE.1)
     *    ISAWAV=1
      IKERNE=0
C
C=======================================================================
C         SETTING THE PARAMETER THAT HANDLES ANGULAR-MOMENTUM PROJECTION
C         OF BLOCKED STATES
C=======================================================================
C
      CALL INIADD
      IF ((       IABS(IDSIGN) .EQ.1.OR.       IABS(IDSIMN) .EQ.1.OR.
     *     MAXVAL(IABS(IDSIQN)).EQ.1.OR.MAXVAL(IABS(IDSIZN)).EQ.1)
     *     .AND.IPRGCM.GE.1) THEN
C
         LPRODR(0)=1
      ELSE
         LPRODR(0)=0
C
      END IF
C
      IF ((       IABS(IDSIGP) .EQ.1.OR.       IABS(IDSIMP) .EQ.1.OR.
     *     MAXVAL(IABS(IDSIQP)).EQ.1.OR.MAXVAL(IABS(IDSIZP)).EQ.1)
     *    .AND.IPRGCM.GE.1) THEN
C
         LPRODR(1)=1
      ELSE
         LPRODR(1)=0
C
      END IF
      IPRODD=MAXVAL(LPRODR)
C
C=======================================================================
C         SETTING THE NAMES OF SURFACE OR SCHIFF MOMENTS
C=======================================================================
C
                       NAMSIF=NAMSUR
      IF (ISCHIF.EQ.1) NAMSIF=NAMSCH
C
C=======================================================================
C         SETTING THE VALUES OF LINEAR LAGRANGE PARAMETERS
C=======================================================================
C
      DO LAMBDA=0,NDMULT
         DO MIU=-LAMBDA,LAMBDA
C
            GALMUQ(LAMBDA,MIU)=QLINEA(LAMBDA,MIU)
            GALMUS(LAMBDA,MIU)=SLINEA(LAMBDA,MIU)
C
            GALMUV(LAMBDA,MIU)=VLINEA(LAMBDA,MIU)
C
            GALMTW(LAMBDA,MIU,:)=0.0D0
C
         END DO
      END DO
C
C=======================================================================
C         SETTING THE VALUES OF SPIN LAGRANGE PARAMETERS
C=======================================================================
C
      GALSPI=DALSPI
C
C=======================================================================
C         SETTING THE VALUES OF ISOSPIN LAGRANGE PARAMETERS
C=======================================================================
C
      GALISO=DALISO
C
C=======================================================================
C         SETTING THE PARTICLE NUMBERS
C=======================================================================
C
      PARNUN=IN_FIX
      PARNUP=IZ_FIX
      PARNUA=IN_FIX+IZ_FIX
C
C=======================================================================
C         SETTING THE FLAG THAT STOPS THE SYMMETRIZATION OF DENSITIES
C         IN "DENSHF" WHEN VARIOUS FINITE-RANGE FIELDS ARE USED.
C=======================================================================
C      ATTENTION: BETWEEN VERSIONS 2.72C AND 3.00T,  THE  SYMMETRIZATION
C                 OF DENSITIES WAS IN "DENSHF" ENFORCED FOR FINITE-RANGE
C                 FUNCTIONALS BY DEFINING AND TRANSFERRING THE  VARIABLE
C                 "DOSYMM". THIS PREVENTED COLLAPSES  OF  ITERATIONS  IN
C                 CASES WHEN THE ZERO-RANGE AND FINITE-RANGE TERMS  WERE
C                 SIMULTANEOUSLY INCLUDED.  HOWEVER,  THE  EXACT-COULOMB
C                 CASE WAS THEN ALSO ADDED TO THE SAME CONDITION. AS  IT
C                 TURNS OUT, THE COLLAPSES IN QUESTION DO NOT HAPPEN FOR
C                 THE EXACT-COULOMB CASE; THEREFORE,  ON  25/11/2020  IN
C                 VERSION 3.00U, THE EXACT-COULOMB CASE WAS REMOVED FROM
C                 THE VARIABLE "DOSYMM". ALTHOUGH THIS WAS NOT REALLY  A
C                 BUG, THE ABSENCE OF SYMMETRIZATION COULD RESULT IN THE
C                 CODE DEPARTING FROM  THE  PRINCIPAL-AXIS  ORIENTATION.
C                 MOREOVER, THE ABSENCE OF SYMMETRIZATION WAS NOT AT ALL
C                 COMMUNICATED TO THE USER.
C=======================================================================
C
      DOSYMM=I_YUKA.LE.1        .AND.
     *       I_GOGA.LE.1        .AND.       IGOGPA.LE. 1.AND.
     *       I_REGA.LE.1        .AND.       IREGPA.LE. 1.AND.
     *       I_SEPA.LE.1        .AND.       ISEPPA.LE. 1.AND.
     *       MAXVAL(I_FSTA).LE.1.AND.MAXVAL(IFSTPA).LE.1
C
C=======================================================================
C         SETTING THE PARAMETERS OF THE SEPARABLE INTERACTION.
C=======================================================================
C
      IRESEP=IVISEP
C
      DO INSEPA=1,IRESEP
C
         SEPVCC(INSEPA,1)=SEPVIC(INSEPA,1)+SEPFAC(INSEPA,1)
     *                                    *SEPERR(INSEPA,1)
         SEPVCC(INSEPA,2)=SEPVIC(INSEPA,2)+SEPFAC(INSEPA,2)
     *                                    *SEPERR(INSEPA,2)
         SEPVCC(INSEPA,3)=SEPVIC(INSEPA,3)+SEPFAC(INSEPA,3)
     *                                    *SEPERR(INSEPA,3)
         SEPVCC(INSEPA,4)=SEPVIC(INSEPA,4)+SEPFAC(INSEPA,4)
     *                                    *SEPERR(INSEPA,4)
C
         SEPTCC(INSEPA,1)=SEPVCC(INSEPA,1)
         SEPTCC(INSEPA,2)=SEPVCC(INSEPA,2)/SEPVCC(INSEPA,1)
         SEPTCC(INSEPA,3)=SEPVCC(INSEPA,3)/SEPVCC(INSEPA,1)
         SEPTCC(INSEPA,4)=SEPVCC(INSEPA,4)/SEPVCC(INSEPA,1)
C
      END DO
C
C=======================================================================
C         SETTING THE PARAMETERS OF THE SKYRME INTERACTION "INPU".
C=======================================================================
C
      T0_INP = T0_DAT + T0_ERR * T0_FAC
      X0_INP = X0_DAT + X0_ERR * X0_FAC
C
      T1_INP = T1_DAT + T1_ERR * T1_FAC
      X1_INP = X1_DAT + X1_ERR * X1_FAC
C
      T2_INP = T2_DAT + T2_ERR * T2_FAC
      X2_INP = X2_DAT + X2_ERR * X2_FAC
C
      T3_INP = T3_DAT + T3_ERR * T3_FAC
      X3_INP = X3_DAT + X3_ERR * X3_FAC
C
      WW_INP = WW_DAT + WW_ERR * WW_FAC
      PO_INP = PO_DAT + PO_ERR * PO_FAC
C
C=======================================================================
C         SETTING PARAMETER "LDPNMX" THAT DEFINES THE NUMBER OF ISOSPIN
C         BLOCKS OF DENSITIES AND FIELDS
C=======================================================================
C
                                       LDPNMX=1
      IF (IPNMIX.NE.1.AND.IPRGCM.GE.1) LDPNMX=3
      IF (IPNMIX.EQ.1)                 LDPNMX=3
C
C=======================================================================
C         SETTING THE PAIRING STRENGTH PARAMETERS
C=======================================================================
C
      IF (NOZEPA.EQ.1) THEN
C
          PRHO_N=0.0D0
          PRHODN=0.0D0
          PRHOSN=0.16
          POWERN=1.0
C
          PRHO_P=0.0D0
          PRHODP=0.0D0
          PRHOSP=0.16
          POWERP=1.0
C
          PRHO_T=0.0D0
          PRHODT=0.0D0
          PRHOST=0.16
          POWERT=1.0
C
      ELSE
C
          PRHO_N=PRHD_N
          PRHODN=PRHDDN
          PRHOSN=PRHDSN
          POWERN=POWDRN
C
          PRHO_P=PRHD_P
          PRHODP=PRHDDP
          PRHOSP=PRHDSP
          POWERP=POWDRP
C
          PRHO_T=PRHD_T
          PRHODT=PRHDDT
          PRHOST=PRHDST
          POWERT=POWDRT
C
      END IF
C
C=======================================================================
C         SETTING THE INDEX OF HFB DEGRADED TO HF
C=======================================================================
C
      IND2HF(:)=0
C
C=======================================================================
C         SETTING THE ARRAY CONTAINING THE SWITCHES RELATED TO THE
C         OCCUPATIONS OF LAST ORBITALS IN OMEGA BLOCKS
C=======================================================================
C
      LASTAL(0)=LASTAN
      LASTAL(1)=LASTAP
C
C=======================================================================
C         SETTING THE ARRAYS CONTAINING REGULARIZED COUPLING CONSTANTS
C=======================================================================
C
      IREREG=100
      N3LORD=1
C
      INCONS=0
C
      DO KREJAL=1,4
         IF (IREREJ(KREJAL).NE.100) THEN
             DO LREJAL=1,4
                IF (IREREJ(LREJAL).NE.100) THEN
                    IF (IREREJ(KREJAL).EQ.IREREJ(LREJAL).AND.
     *                  NREREJ(KREJAL).EQ.NREREJ(LREJAL)) THEN
                        IF (IREREG.EQ.100) THEN
                            IREREG=IREREJ(KREJAL)
                            N3LORD=NREREJ(KREJAL)
                        ELSE
                            IF (IREREJ(KREJAL).NE.IREREG.OR.
     *                          NREREJ(KREJAL).NE.N3LORD) INCONS=1
                        END IF
                    ELSE
                        INCONS=1
                    END IF
                END IF
             END DO
         END IF
      END DO
C
      IF (IREREG.EQ.100) IREREG=0
C
      IF (INCONS.EQ.1) THEN
C
          WRITE(NFIPRI,'(/,20(1H/),
     *        '' INCONSISTENT REGULARIZED COUPLING '',20(1H/),/,20(1H/),
     *        '' CONSTANTS FOUND ON THE INPUT FILE '',20(1H/),/)')
          DO KREJAL=1,4
             IF (IREREJ(KREJAL).NE.100) THEN
C
                WRITE(NFIPRI,'(/,20(1H/),'' IREREJ('',I1,'') = '',I3,2X,
     *                                   '' NREREJ('',I1,'') = '',I3,1X,
     *                                                        20(1H/))')
     *           KREJAL,IREREJ(KREJAL),
     *           KREJAL,NREREJ(KREJAL)
C
             END IF
          END DO
C
          STOP 'INCONSISTENT REGULARIZED COUPLING CONSTANTS FOUND'
C
      END IF
C
      IF (IREREJ(1).NE.100.AND.IREREJ(4).NE.100)
     *
     *    STOP 'IREREJ(1)<>100 NOT ALLOWED TOGETHER WITH IREREJ(4)<>100'
C
      IF (IREREJ(1).NE.100) THEN
C
          IF (IREREG.GE.1) THEN
C
              IF (IREREG.GT.NDREGA) STOP ' INCREASE NDREGA IN HFODD 1'
C
              REGVCC=REJVCC
C
          END IF
C
      END IF
C
      IF (IREREJ(4).NE.100) THEN
C
          IF (IREREG.GE.1) THEN
C
              IF (IREREG.GT.NDREGA) STOP ' INCREASE NDREGA IN HFODD 2'
C
              REGTCC=REJTCC
C
              DO INREGA=1,IREREG
C
                 REGVCC(INREGA,1)=REGTCC(INREGA,1)
                 REGVCC(INREGA,2)=REGTCC(INREGA,1)*REGTCC(INREGA,2)
                 REGVCC(INREGA,3)=REGTCC(INREGA,1)*REGTCC(INREGA,3)
                 REGVCC(INREGA,4)=REGTCC(INREGA,1)*REGTCC(INREGA,4)
C
              END DO
C
          END IF
C
      END IF
C
      IF (IREREJ(1).NE.100.OR.IREREJ(4).NE.100) THEN
C
          DO INREGA=1,IREREG
C
             REGVCC(INREGA,1)=REGVCC(INREGA,1)+REJFAC(INREGA,1)
     *                                        *REJERR(INREGA,1)
             REGVCC(INREGA,2)=REGVCC(INREGA,2)+REJFAC(INREGA,2)
     *                                        *REJERR(INREGA,2)
             REGVCC(INREGA,3)=REGVCC(INREGA,3)+REJFAC(INREGA,3)
     *                                        *REJERR(INREGA,3)
             REGVCC(INREGA,4)=REGVCC(INREGA,4)+REJFAC(INREGA,4)
     *                                        *REJERR(INREGA,4)
C
             REGTCC(INREGA,1)=REGVCC(INREGA,1)
             REGTCC(INREGA,2)=REGVCC(INREGA,2)/REGVCC(INREGA,1)
             REGTCC(INREGA,3)=REGVCC(INREGA,3)/REGVCC(INREGA,1)
             REGTCC(INREGA,4)=REGVCC(INREGA,4)/REGVCC(INREGA,1)
C
                                    FACTOR= REGWID**(2*INREGA-2)
                                    FACTOR= FACTOR*2**(INREGA-1)
             IF (MOD(INREGA,2).EQ.0)FACTOR=-FACTOR
C
             IF (N3LORD.GE.0) THEN
C
                 DO INFORC=1,NDFORC
C
                    REGBCC(INREGA,INFORC)=REGVCC(INREGA,INFORC)/FACTOR
C
                 END DO
C
             ELSE
C
                 REGBCC=0.0D0
C
             END IF
C
         END DO
C
      END IF
C
C=======================================================================
C         SETTING THE ARRAY CONTAINING THE LIST OF MIXED CONFIGURATIONS
C=======================================================================
C
      MIXNUM=0
      MICONF(:)=0
C
      DO IUCONF=1,ILCONF
C
         IF (INCONF(IUCONF).GT.0) THEN
C
             MIXNUM=MIXNUM+1
             MICONF(MIXNUM)=IUCONF
C
         END IF
C
      END DO
C
C=======================================================================
C         SETTING THE SWITCH THAT DEFINES THE ATFHF(B) CALCULATION IN
C         "DENSHF"
C=======================================================================
C
      I_SING=0
C
C=======================================================================
C         HERE WE INITIALIZE THE SWITCHES THAT GOVERN THE CALCULATION OF
C         THE WIGNER D FUNCTIONS IN "DSMALH".
C=======================================================================
C
      ISWIND=0
      NUANGU=0
C
C=======================================================================
C         INCLUDING THE EFFECTIVE GYROSCOPIC FACTORS
C=======================================================================
C
      GESPIN(0)=G_SPIN(0)*GYRSPN
      GEORBI(0)=G_ORBI(0)
C
      GESPIN(1)=G_SPIN(1)*GYRSPP
      GEORBI(1)=G_ORBI(1)*GYRORP
C
C=======================================================================
C         END OF INPUT-RELATED PREDEFINITIONS
C=======================================================================
C
C=======================================================================
C         READING THE INPUT DATA FROM THE WOODS-SAXON FILE
C=======================================================================
C
      IF (IREAWS.EQ.1.AND.batch_init.EQ.1) THEN
C
          OPEN(NFIWOO,FILE=FILWOO,STATUS='OLD',IOSTAT=IERROR,
     *                                         FORM='UNFORMATTED')
C
          CALL READWS(INNUMB,IZNUMB,FCHOM0,R0PARM,HOMEGA,
     *                       NFIWOO,EPSHER,NOSCIL,NLIMIT,
     *                       ENECUT,LAMMAX,ISOTRO,CVOLFC,
     *                       CMSXFC,CMSYFC,CMSZFC,XMOMFC,
     *                              YMOMFC,ZMOMFC,GPAIRN,
     *                                            GPAIRP)
C
          CLOSE(NFIWOO)
C
          CALL DEFPRI(LAMMAX,INNUMB,IZBASI)
C
      ELSE
C
C=======================================================================
C         OPENING THE COMMON FILBAP AND FILBAC FILE
C=======================================================================
C
          IF (FILBAP.EQ.FILBAC) THEN
C
              NFIBAP=NFIBAC
C
              IF (IBCONT.GE.1) THEN
C
                  IERROR=0
                  OPEN(NFIBAP,FILE=FILBAP,STATUS='OLD',IOSTAT=IERROR,
     *                        FORM='FORMATTED')
C
                  IF (IERROR.NE.0) THEN
C
                      WRITE(NFIPRI,'(/,1X,26(1H/),2X,
     *                             ''FILE NOT FOUND ON DISC'',
     *                                                     2X,26(1H/),/,
     *                         1X, 3(1H/),2X,68X,          2X, 3(1H/),/,
     *                         1X, 3(1H/),2X,A68,          2X, 3(1H/),/,
     *                         1X, 3(1H/),2X,68X,          2X, 3(1H/),/,
     *                         1X,26(1H/),2X,''FILE NOT FOUND ON DISC'',
     *                                                     2X,26(1H/))')
     *                     FILBAP
C
                      STOP ' FILE FILBAP NOT FOUND ON DISC'
C
                  END IF
C
              ELSE
C
                  IF (IWRIBA.NE.-1) THEN
                      OPEN(NFIBAC,FILE=FILBAC,STATUS='UNKNOWN',
     *                            FORM='FORMATTED')
                  END IF
C
              END IF
C
          ELSE
C
C=======================================================================
C         OPENING THE FILBAP FILE
C=======================================================================
C
              IF (IBCONT.GE.1) THEN
C
                  IERROR=0
                  OPEN(NFIBAP,FILE=FILBAP,STATUS='OLD',IOSTAT=IERROR,
     *                        FORM='FORMATTED')
C
                  IF (IERROR.NE.0) THEN
C
                      WRITE(NFIPRI,'(/,1X,26(1H/),2X,
     *                             ''FILE NOT FOUND ON DISC'',
     *                                                     2X,26(1H/),/,
     *                         1X, 3(1H/),2X,68X,          2X, 3(1H/),/,
     *                         1X, 3(1H/),2X,A68,          2X, 3(1H/),/,
     *                         1X, 3(1H/),2X,68X,          2X, 3(1H/),/,
     *                         1X,26(1H/),2X,''FILE NOT FOUND ON DISC'',
     *                                                     2X,26(1H/))')
     *                     FILBAP
C
                      STOP ' FILE FILBAP NOT FOUND ON DISC'
C
                  END IF
C
              END IF
C
C=======================================================================
C         OPENING THE FILBAC FILE
C=======================================================================
C
              IF (IWRIBA.NE.-1) THEN
                  OPEN(NFIBAC,FILE=FILBAC,STATUS='UNKNOWN',
     *                        FORM='FORMATTED')
              END IF
C
          END IF
C
C=======================================================================
C         READING THE BASIS DEFORMATIONS FROM THE BASIS FILE
C=======================================================================
C
          IF (IBCONT.GE.1) THEN
C
C             INPFLD=1 => THE FILE WITH THE UNIT NUMBER  NFIBEP WILL BE
C                         USED TO  R E A D  BETA DEFORMATIONS FROM  THE
C                                                          PREVIOUS RUN
              WRITE(NFIPRI,'(79(1H*),/,1H*,77X,1H*,/,
     *            1H*,''  CALLING SUBROUTINE "RECBAS" TO READ'',
     *                '' THE BASIS FILE OBTAINED PREVIOUSLY'',5X,1H*,/,
     *            1H*,2X,A68,                   7X,1H*,/,1H*,77X,1H*)')
     *
     *                FILBAP
C
              INPFLD=1
              IERROR=0
C
              CALL RECBAS(NFIBAP,NFIBAC,INPFLD,IERROR)
C
              IF (IERROR.NE.0) STOP 'BASIS FILE CORRUPTED - STOP HERE'
C
          END IF
C
C=======================================================================
C         NEW VERSION, LESZEK PROCHNIAK, ON 11/12/2020, FROM (3.01I)
C=======================================================================
C
              CALL GEOMFC(INNUMB,IZNUMB,FCHOM0,R0PARM,HOMEGA,
     *                                  LAMMAX,ISOTRO,CVOLFC,
     *                                  CMSXFC,CMSYFC,CMSZFC,
     *                                  XMOMFC,YMOMFC,ZMOMFC,
     *                                                ITWCEN)
C
      END IF
C
C=======================================================================
C         HERE BEGINS THE INITIALIZATION PHASE OF THE PROGRAM
C=======================================================================
C
C=======================================================================
C         CHOICE OF THE SKYRME FORCE PARAMETERS
C=======================================================================
C
      CALL PARAMS(SKYRME,LANODD,LANSCA,HBMSAT,RHOSAT,EFFSAT,ISTAND,
     *            KETA_J,KETA_W,KETACM,KETA_M,KETA_P,KETA_T,KETAPA,
     *            JETA_J,JETA_W,JETACM,JETA_M,JETA_P,JETA_T,JETAPA)
C
C=======================================================================
C         ALLOCATING SPACE FOR SKYRME DENSITIES AND FIELDS
C=======================================================================
C         TWO-CENTRE BASIS OPTION:
C
C         LDTWCE: NUMBER OF TERMS NEEDED TO COMPUTE THE HAMILTONIAN AND
C         ENERGY OF THE FUNCTIONAL, WHERE FOUR WAVE FUNCTION ARE INVOL-
C         VED (SEE COMMENTS BEFORE DENSHF).
C
C         NBLDEN: NUMBER OF TWO-CENTRE BASIS BLOCKS NEEDED TO BUILD THE
C         HAMILTONIAN AND THE DENSITY MATRIX.
C
C                           |        |        |
C                           |  C1C1  |  C1C2  |
C                           |        |        |
C                            -----------------
C                           |        |        |
C                           |  C2C1  |  C2C2  |
C                           |        |        |
C
C          WHERE C STANDS FOR CENTRE. ONLY THREE ARE COMPUTED DUE TO
C          HERMITICITY.
C=======================================================================
C
      CALL TWC_INDGEN(ITWCEN)
C
      IF (ITWCEN.EQ.1) THEN
C
          LDTWCE=1
          NBLDEN=1
          LDTWDD=1  !EXTRA TERMS DENSITY-DEPENDENT INTERACTIONS
C
      ELSEIF (ITWCEN.EQ.2) THEN
C
          LDTWCE=16
          NBLDEN=3
                            LDTWDD=22
          IF (IPAIRI.EQ.1)  LDTWDD=24
C
          IF (LDTWDD.GT.NDTWDD) STOP 'LDTWDD > NDTWDD'
C
      END IF
C
      CALL ALLODE(LDPNMX,IGRAIN,LDTWCE,LDTWDD)
C
      CALL ALLOVF(LDPNMX,LDTWCE)
C
C=======================================================================
C         ALLOCATING SPACE FOR SAVING DENSITY MATRIX AND PAIRING TENSOR
C=======================================================================
C
      IF (I_YUKA.GE.1.OR.I_GOGA.GE.1.OR.I_REGA.GE.1.OR.I_SEPA.GE.1.OR.
     *    I_COUA.GE.1.OR.MAXVAL(I_FSTA).GE.1.OR.MAXVAL(MAG2BC).GE.1.OR.
     *    ICOUDI.EQ.2.OR.ICOUEX.EQ.2.OR.
     *    JETACM.GE.1.OR.KETA_R.GE.1)
     *
     *    CALL ALLORH(LDPNMX,ISIMPY)
C
      IF (IGOGPA.GE.1.OR.IREGPA.GE.1.OR.ISEPPA.GE.1.OR.
     *    ICOUPA.GE.1.OR.MAXVAL(IFSTPA)       .GE.1.OR.
     *  ((JETACM.GE.1.OR.KETA_R.GE.1).AND.IPAHFB.GE.1))
     *
     *    CALL ALLOKA(LDPNMX,ISIMPY)
C
C=======================================================================
C         CALCULATING THE THREE-BODY-GRADIENT COUPLING CONSTANTS BASED
C         ON THE EV4 SUBROUTINES
C=======================================================================
C
      IF (IGRAIN.EQ.1) CALL TRACPL
C
C=======================================================================
C        LOGICAL VARIABLE "REA2PP" DECIDES ON WHETHER OR NOT WE NEED THE
C        SECOND ARRAY "FIP2DE", WHICH CONTAINS ADDITIONAL PAIRING FIELDS
C        REQUIRED ONLY FOR TRANSLATIONAL AND ROTATIONAL CORRECTIONS  AND
C        FOR THE FINITE-RANGE PAIRING
C=======================================================================
C
      REA2PP=JETACM.EQ.2.OR.KETA_R.EQ.2.OR.
     *       IGOGPA.GE.2.OR.IREGPA.GE.2.OR.ISEPPA.GE.2.OR.
     *       ICOUPA.GE.2.OR.MAXVAL(IFSTPA).GE.2
C
C=======================================================================
C         CHOICE OF THE GOGNY FORCE PARAMETERS
C=======================================================================
C
      CALL PARGOG(I_GOGA,IGOGPA,I_REGA,GOGNAM)
C
C=======================================================================
#if(USE_FITS==1)
      CALL FITINP(PARINP,NUMINP,I_TYPE,N3LORD)
#endif
C=======================================================================
C         CHOICE OF THE REGULARIZED-DELTA FORCE PARAMETERS
C=======================================================================
C
      CALL PARREG(I_REGA,N3LORD)
C
C=======================================================================
C         CHOICE OF THE SEPARABLE FORCE PARAMETERS
C=======================================================================
C
      IF (I_SEPA.GE.1.OR.ISEPPA.GE.1) CALL PARSEP
C
C=======================================================================
C         CHOICE OF THE FINITE-RANGE SPIN-ORBIT AND TENSOR FORCE
C         PARAMETERS
C=======================================================================
C
      IF (MAXVAL(I_FSTA).GE.1.OR.MAXVAL(IFSTPA).GE.1) CALL PARFST
C
C=======================================================================
C         TESTING INTEGRITY OF THE INPUT DATA
C=======================================================================
C
      CALL TESDAT(IOPTGS,NOSCIL,NLIMIT,ISTAND,
     *            KETA_J,KETA_W,KETACM,KETA_M,
     *                   KETA_P,KETA_T,KETAPA,
     *                   JETACM,JETA_T,JETAPA,
     *                                 NOZEPA,
     *                          ITWOLI,KETA_R,
     *                          KETAJ2,KETAT2,
     *                   ISIMPY,ISIGNY,ISIQTY,
     *                   ISIMTX,JSIMTY,ISIMTZ,
     *                                 IAXIAP,
     *                   NMUCON,NMUCOU,NMUPRI,
     *            ISCHIF,NSICON,NSIPRI,IDOPLM,
     *                   NMACON,NMAPRI,NMAORD,
     *                   NASCON,NASPRI,NASORD,
     *                                 NRAORD,
     *            NMURED,NMARED,NASRED,NSIRED,
     *                   NEXBET,IPRIBE,IPRIBL,
     *            NUPING,EPSPNG,EPSITE,EPSCON,
     *                          NULAST,NUCONS,
     *            ISYMDE,INIROT,INIINV,INIKAR,
     *                          IWRIOL,IWRIBA,
     *                          IRENMA,IRENIN,
     *            IFRWAV,ITOWAV,IWRWAV,ISAKER,
     *     ISLPRI,ISUPRI,IENPRI,ISRPRI,IMIPRI,
     *                   IKEPRI,IRMPRI,IELPRI,
     *            QMUCUT,QMACUT,QASCUT,QSICUT,
     *                   IPRGCM,IPROMI,IPROMA,
     *                   NUAKNO,NUBKNO,KPROJE,
     *                   NATKNO,NBTKNO,ISOSTZ,
     *            NPNKNO,NTZKNO,NPAKNO,IPAPRO,
     *     IFERME,IBETME,IIFERR,ITFERR,ISFERR,
     *     ISOSAD,ISOSMI,ISOSMA,EPSISO,ICSKIP,
     *            IPAKER,IPAK3D,IPAALL,KFIKER,
     *            NUASTA,NUASTO,NUGSTA,NUGSTO,
     *            NATSTA,NATSTO,NGTSTA,NGTSTO,
     *            NUBSTA,NUBSTO,NUTSTA,NUTSTO,
     *                   ICHFLI,IPAFLI,IREFLI,
     *                   ISPFLI,ISHFLI,IFLIPI,
     *                          NOITER,IREAWS,
     *                   ILIBAS,IN_FIX,IZ_FIX,
     *                          INNUMB,IZNUMB,
     *                                 IDESTA,
     *            IMOVAX,ITILAX,ITISAX,NO_ORB,
     *                          IQUNIL,NILXYZ,
     *                   MREVER,IROTAT,IQPSTA,
     *                   IPAIRI,IPAHFB,JPABCS,
     *            IONISH,ITWOBA,NUQEVE,IMFHFB,
     *                   ECUTOF,LIMQUA,LAMCUT,
     *                                 IPNMIX,
     *                          LIPKIN,LIPKIP,
     *                          LIPNON,LIPNOP,
     *                   IPNPRJ,NPPNPN,NPPNPP,
     *     I_SLOW,SLOWEV,SLOWOD,SLOWPA,SLOWLM,
     *                          IFEFIN,IFEFIP,
     *                          IF2FIN,IF2FIP,
     *                          IFERAN,IFERAP,
     *                          IDEFIN,IDEFIP,
     *            INSIGN,IPSIGN,ISSIGN,IDSIGN,
     *            INSIGP,IPSIGP,ISSIGP,IDSIGP,
     *                   INSIMN,IRSIMN,IDSIMN,
     *                   INSIMP,IRSIMP,IDSIMP,
     *                   INSIQN,IPSIQN,IDSIQN,
     *                   INSIQP,IPSIQP,IDSIQP,
     *                          INSIZN,IDSIZN,
     *                          INSIZP,IDSIZP,
     *                          IFIBLN,INIBLN,
     *                          IFIBLP,INIBLP,
     *            ICOTYP,ICOUDI,ICOUEX,ICOULO,
     *                          IYUTYP,I_YUKA,
     *                          I_GOGA,IGOGPA,
     *                          I_REGA,IREGPA,
     *                          I_SEPA,ISEPPA,
     *                          I_COUA,ICOUPA,
     *                          N3LORD,N3SERD,
     *                   ICONTI,IPCONT,IOCONT,
     *                   ISCONT,ITCONT,IACONT,
     *            IYCONT,IGCONT,IGPCON,IECONT,
     *            ILCONT,IFCONT,IMCONT,IRCONT,
     *     IFSHEL,IF_RPA,IWRIQU,IWRIRM,IF_THO,
     *                          LDPNMX,SKYRME,
     *                          IFRAGM,MIN_QP,
     *                   ILIPON,ILIPOP,GAUSHI,
     *     NLSIGN,NLSIMN,NLSIQN,NLSIZN,MXALIN,
     *     NLSIGP,NLSIMP,NLSIQP,NLSIZP,MXALIP,
     *                          LASTAN,LASTAP,
     *                                 ITWCEN,
     *                                 IADBAT,
     *                          NEWGOG,NEWCOU,
     *                          IPOTHO,IVIPRI,
     *                                 IFRCNT)
C
C=======================================================================
C         CALCULATING  THE  HARMONIC - OSCILLATOR  BASIS  PARAMETERS
C=======================================================================
C
      CALL SETBAS(IN_FIX,IZ_FIX,IREAWS,NOSCIL,NLIMIT,ENECUT,
     *                          IOPTGS,JETACM,ISPHER,INIROT,
     *                          IPRGCM,NUAKNO,ICOUDI,ICOUEX,
     *                                 E_EFFE,IF_THO,ITWCEN,
     *                                        NLIMTW,ENECTW)
C
C@@@ HFBTHO - HFBTHO - HFBTHO - HFBTHO - HFBTHO - HFBTHO - HFBTHO
C=======================================================================
C      RUNNING HFBTHO
C=======================================================================
C
      IF (IF_THO.GE.1) THEN
C
          I_FAIL=0
C
#if(USE_MPI==1)
          WRITE(FILTHO,'(''t'',I6.6,''.hel'')') INDJOB
#else
          WRITE(FILTHO,'(''t'',I3.3,''_'',I3.3,''.hel'')')
     *                             IZ_FIX,IN_FIX
#endif
C
C          Read HFODD field file and transform the matrix of the mean-field
C          and pairing field into HFBTHO basis convention
C
          IF (IF_THO.EQ.2) THEN
C
C              First read traditional record file, which contains many
C              useful quantities at convergence
C
              WRITE(NFIPRI,'(79(''*''),/,''*'',77X,''*'',/,
     *           ''*  CALLING SUBROUTINE "RECORD" TO READ'',
     *           '' THE REPLAY FILE OBTAINED PREVIOUSLY    *'',/,
     *           ''*'',2X,A68,7X,''*'')') FILREP
C
              INPFLD=1
              IERROR=0
C
              CALL RECORD(NFIREP,NFIREC,INPFLD,NUMITE,
     *                    IVEREP,NXHERM,NYHERM,NZHERM,
     *                                  IPCONT,ILCONT,
     *                           ISCONT,ITCONT,IACONT,
     *                                  IMCONT,IRCONT,
     *                                  IRENMA,IRENIN,
     *                                  LIPKIN,LIPKIP,
     *                                  REFERN,REFERP,
     *                                  REDELN,REDELP,
     *                                  REFE2N,REFE2P,
     *                                  IDSIGN,IDSIGP,
     *                                  IDSIMN,IDSIMP,
     *                                  IDSIQN,IDSIQP,
     *                                  IDSIZN,IDSIZP,
     *                                         INIBLN,
     *                                         INIBLP,
     *                                  NMUMAX,NSIMAX,
     *                                  IPNMIX,ISHIFT,
     *                                  JETA_T,JETAPA,IERROR,
     *                                         LDTWCE,LDTWDD,
     *                                                IFRCNT)
C
              IF (IERROR.NE.0) THEN
C
                  WRITE(NFIPRI,'(
     *              '' ////////////////////////////////////////'',
     *              ''/////////////////////////////////////'',/,
     *              '' ////       WARNING: RECORD FILE IS CORRUPTED'',
     *              '' !                          /////'',/,
     *              '' ////                 - RESTART IS CANCELLED '',
     *              ''                            /////'',/,
     *              '' ////                 - CALCULATIONS WILL RES'',
     *              ''TART FROM SCRATCH           /////'',/,
     *              '' ////////////////////////////////////////'',
     *              ''/////////////////////////////////////'')')
C
              END IF
C
              WRITE(NFIPRI,'(''*'',77X,''*'',/,
     *            ''*  CALLING SUBROUTINE "RECFIL" TO READ'',
     *            '' THE FIELDS FILE OBTAINED PREVIOUSLY    *'',/,
     *            ''*'',2X,A68,7X,''*'',/,''*'',77X,''*'')')
     *              FILFIP
C
              INPFIL=1
              IFNTHO=0
C
              CALL RECFIL(NFIFIP,NFIFIC,INPFIL,ISIMPY,IPAHFB,
     *                                  IPNMIX,NOSCIL,NUMITE,
     *                           EFERMN,EFERMP,EFER2N,EFER2P,
     *                                  DELTAN,DELTAP,IFNTHO,
     *                                         NLIMIT,FILTHO,
     *                           ISGOGP,ISREGP,REA2PP,IVEFIP)
C
              WRITE(NFIPRI,'(79(''*''),/,''*'',77X,''*'',/,
     *           ''*  CALLING SUBROUTINE  CARCYL  TO TRANSFORM '',
     *           ''THE HFB MATRIX READ  FROM HFODD   *'',/,
     *           ''*  INTO THE CYLINDRICAL BASIS USED IN HFBTHO.'',
     *                33X,''*'')')
C
C              Strip the phase from the matrix and move into cylindrical
C              coordinates
C
              bz_THO = 1.0/HOMSCA(3,1)
              bp_THO = 1.0/SQRT(HOMSCA(1,1)*HOMSCA(2,1))
C
                                    force_parity_THO = .False.
              IF (ABS(ISIGNY).EQ.1) force_parity_THO = .True.
C
              CALL CARCYL(NOSCIL,IF_THO,bz_THO,bp_THO,
     *                        force_parity_THO,ITWCEN)
C
C              Change ordering of basis states
              CALL ToHFBTHO(NDTRAN,NDSPIN,NOSCIL,LDBASE,NOFCNS)
C
C              Write results in HFBTHO format
              unit_tho  = 92
              beta0_THO = ALPHAR(2,0)
C              Lagrange parameters
              DO L=1,8
                 multLag_tho(L) = RALMUQ(L,0)
              END DO
              CALL WriteHFBTHO(unit_tho,FILTHO,IN_FIX,IZ_FIX,NOSCIL,
     *                           REFERN,REFERP,REDELN,REDELP,REFE2N,
     *                           REFE2P,PRHO_N,PRHO_P,BZ_THO,BP_THO,
     *                           beta0_THO,multLag_tho)
C
              ITESTA=NUMITE+1
C
          END IF
C
C@@@ HFBTHO -HFBTHO - HFBTHO - HFBTHO - HFBTHO - HFBTHO - HFBTHO
#if(USE_MPI==1)
          IF (batch_mode.EQ.1) THEN
              CALL batch(NFIREP,NFIREC,NFILIP,NFILIC,
     *                   FILREP,FILREC,FILLIP,FILLIC,
     *                   NUDATA,IF_THO,
     *                          NXHERM,NYHERM,NZHERM,IRENMA,IRENIN,
     *                   REFERN,REFERP,REDELN,REDELP,REFE2N,REFE2P,
     *                   IFIBLN,INIBLN,IFIBLP,INIBLP,NMUMAX,NSIMAX,
     *                                               NMUCON,ISHIFT,
     *                   ICONTI,IPCONT,ILCONT,IACONT,IGCONT,IGPCON,
     *                                 ISCONT,ITCONT,IMCONT,IRCONT,
     *                   IPAIRI,LIPKIN,LIPKIP,I_GOGA,IGOGPA,I_YUKA,
     *                                        ITWOLI,JETACM,KETA_R,
     *                   IPNMIX,Q_NECK,QACTUA,QORIGI,QINCRE,INDJOB,
     *                   batch_init)
          END IF
#endif
C
C          Input parameters for HFBTHO
C
          file_THO    = FILTHO
          output_THO  = NFIPRI
C
          Nshell_THO  = NOSCIL
          b0_THO      = (HOMSCA(1,1)*HOMSCA(2,1)*HOMSCA(3,1))
     *                  **(-1.0D0/3.0D0)
          bz_THO      = 1.0D0/HOMSCA(3,1)
          bp_THO      = 1.0D0/SQRT(HOMSCA(1,1)*HOMSCA(2,1))
          beta0_THO   = ALPHAR(2,0)
          b2_THO      = REAL(ALPHAC(2,0)) ! Deformation of the WS potential
          b4_THO      = REAL(ALPHAC(4,0)) ! Deformation of the WS potential
          neutron_THO = IN_FIX
          proton_THO  = IZ_FIX
          type_THO    = 1
          IF (LIPKIN.EQ.1.OR.LIPKIP.EQ.1) type_THO=-1
C
          niter_THO    = 400
          accuracy_THO = 1.D-5
          restart_THO  = -1
C
          functional_THO   = TRIM(SKYRME)
          initial_pair_THO = .False.
                                           coulomb_THO = 2
          IF (ICOUDI.EQ.0.AND.ICOUEX.EQ.0) coulomb_THO = 0
          IF (ICOUDI.EQ.1.AND.ICOUEX.EQ.0) coulomb_THO = 1
          IF (ICOUDI.EQ.1.AND.ICOUEX.EQ.1) coulomb_THO = 2
C
          VpairN_THO = PRHO_N
          VpairP_THO = PRHO_P
          Ecut_THO   = ECUTOF
          V1_THO     = 0.5D0
C
          n_blocking_THO = (/ 0, 0, 0, 0, 0 /)
          p_blocking_THO = (/ 0, 0, 0, 0, 0 /)
C
          DO L=1,8
             lambda_THO(L) = L
             active_THO(L) = IFLAGQ(L,0)
             expect_THO(L) = QASKED(L,0)
          END DO
C
          useTHO_THO     = 0
          gauge_THO      = 1
          projection_THO = 0
          dN_THO         = 0
          dZ_THO         = 0
C
                           set_temper_THO = .False.
          IF (IFTEMP.EQ.1) set_temper_THO = .True.
          temper_THO=TEMP_T
C
          numGauss_THO    = 40
          numLaguerre_THO = 40
          numLegendre_THO = 80
          HFODD_to_HFBTHO = .True.
          nstate_THO      = NLIMIT
                                force_parity_THO = .False.
          IF (ABS(ISIGNY).EQ.1) force_parity_THO = .True.
C
          WRITE(NFIPRI,'(79(''*''),/,''*'',77X,''*'',/,
     *      ''*          SMOOTH CONTINUATION FROM HFBTHO'',
     *      '' RUN HAS BEEN REQUESTED             *'',/,
     *      ''*'',77X,''*'',/,
     *      ''*  WARNING: THE RESTART WILL BE SMOOTH '',
     *      ''IF AND ONLY IF:                        *'',/,
     *      ''*            - AXIAL-, REFLECTION, AND '',
     *      ''TIME_REVERSAL SYMMETRIES ARE CONSERVED *'',/,
     *      ''*            - CALCULATIONS ARE UNCONSTRAINED'',
     *      ''                                 *'',/,
     *      ''*            - BASIS IS SPHERICAL OR DEFORMED'',
     *      '' ONLY ALONG BETA_2               *'',/,
     *      ''*            - HFB SOLUTION AT THE G.S. IS '',
     *      ''REQUESTED (NO HF CRANKING  ETC.)   *'',/,
     *      ''*           ANY OTHER CASE WILL RESULT IN '',
     *      ''THE STABILITY CONDITION AT FIRST    *'',/,
     *      ''*           ITERATION TO BE SIGNIFICANTLY '',
     *      ''GREATER THAN PERHAPS ANTICIPATED    *'',/,
     *      ''*'',77X,''*'',/,79(''*''))')
C
          CALL Main_Program(Nshell_THO, b0_THO, bz_THO, bp_THO,
     *                      beta0_THO, b2_THO, b4_THO, neutron_THO,
     *                      proton_THO, type_THO, niter_THO,
     *                      accuracy_THO, restart_THO,
     *                      functional_THO, initial_pair_THO,
     *                      coulomb_THO, VpairN_THO, VpairP_THO,
     *                      Ecut_THO, V1_THO, n_blocking_THO,
     *                      p_blocking_THO, lambda_THO, active_THO,
     *                      expect_THO, useTHO_THO, gauge_THO,
     *                      projection_THO, dN_THO, dZ_THO,
     *                      set_temper_THO, temper_THO, numGauss_THO,
     *                      numLaguerre_THO, numLegendre_THO,
     *                      HFODD_to_HFBTHO, nstate_THO,
     *                      force_parity_THO, file_THO, output_THO)
C
          IF (I_FAIL.EQ.1) THEN
              IF_THO=0
              WRITE(NFIPRI,'(79(''!''),/,
     *              ''!!   PROGRAM HFBTHO FAILED... LIKELY REASON: '',
     *              ''UNKNOWN INTERACTION             !!'',/,
     *              ''!!   HFODD WILL RESUME FROM SCRATCH - '',
     *              ''FORECAST MORE ITERATIONS NEEDED        !!'',/,
     *                       79(''!''))')
          END IF
C
          WRITE(NFIPRI,'(79(''*''),/,''*'',77X,''*'',/,
     *          ''*  CALLING SUBROUTINE "RECFIL" TO READ'',
     *          '' THE FIELDS FILE GENERATED BY HFBTHO    *'',/,
     *          ''*'',77X,''*'',/,79(''*''),/)')
C
          DO ITPNMX=0,LDPNMX
             CALL ZEDENS(ITPNMX)
          END DO
C
          NUMITE=-1
C
          INPFIL=1
C
          CALL RECFIL(NFIFIP,NFIFIC,INPFIL,ISIMPY,IPAHFB,
     *                              IPNMIX,NOSCIL,NUMITE,
     *                       EFERMN,EFERMP,EFER2N,EFER2P,
     *                              DELTAN,DELTAP,IF_THO,
     *                                     NLIMIT,FILTHO,
     *                       ISGOGP,ISREGP,REA2PP,IVEFIP)
C
          REFERN=EFERMN
          REDELN=DELTAN
          REFE2N=EFER2N
C
          REFERP=EFERMP
          REDELP=DELTAP
          REFE2P=EFER2P
C
          ITESTA=NUMITE+1
C
      END IF
C
C@@@ HFBTHO - HFBTHO - HFBTHO - HFBTHO - HFBTHO - HFBTHO - HFBTHO
C=======================================================================
C         COMPUTING THE SIZE OF THE BROYDEN VECTOR DEPENDING ON
C         THE USER'S CHOICE OF HFODD OPTIONS
C=======================================================================
C
      IF (MIXMAT.EQ.0) THEN
          CALL CALBRO_FIELDS(IROTAT,ISIMPY,IPAHFB,LIPKIN,LIPKIP,
     *                       NXHERM,NYHERM,NZHERM,IBROYD,NOFBRO)
      END IF
C
      IF (MIXMAT.EQ.1) THEN
          CALL CALBRO_MATRIX(MREVER,IROTAT,ISIMPY,IPAHFB,NOFBRN,
     *                              NOFBRP,LIPKIN,LIPKIP,IBROYD)
      END IF
C
C@@@ SHELL -SHELL - SHELL - SHELL - SHELL - SHELL - SHELL - SHELL
C=======================================================================
C         ENFORCING THE SIZE OF PHASE SPACE SO THAT THERE ARE ENOUGH
C         SINGLE - PARTICLE STATES FOR THE  COMPUTATION OF THE SHELL
C         CORRECTION
C=======================================================================
C
      IF (IFSHEL.GE.1) THEN
C
              LDPHAS=LDBASE
          IF (LDPHAS.GT.NDSTAT .OR. LDPHAS.EQ.0) LDPHAS=NDSTAT
C
          DO IREVER=0,NDREVE
             DO ICHARG=0,NDISOS
                NUMBSP(IREVER,ICHARG)=LDPHAS
             END DO
          END DO
C
      END IF
C
C@@@ SHELL -SHELL - SHELL - SHELL - SHELL - SHELL - SHELL - SHELL
C@@@ HFBTHO - HFBTHO - HFBTHO - HFBTHO - HFBTHO - HFBTHO - HFBTHO
C=======================================================================
C         REORDERING THE MATRICES OF THE MEAN-FIELD AND THE PAIRING
C         FIELD OBTAINED FROM  HFBTHO  TO COMPLY WITH  HFODD LABELS
C         CONVENTIONS. RESULTS HAVE BEEN READ PREVIOUSLY IN RECFIL.
C=======================================================================
C
      IF (IF_THO.GE.1) CALL FromHFBTHO(NDTRAN,NDSPIN)
C
C@@@ HFBTHO - HFBTHO - HFBTHO - HFBTHO - HFBTHO - HFBTHO - HFBTHO
C=======================================================================
C         SETTING THE INITIAL VALUES OF THE RENORMALIZED MASSES
C=======================================================================
C
      TRAMAS=HBMASS/(IN_FIX+IZ_FIX)
C
      HBMREN(1)=-TRAMAS*HBMRIN(1)
      HBMREN(2)=-TRAMAS*HBMRIN(2)
      HBMREN(3)=-TRAMAS*HBMRIN(3)
C
C=======================================================================
C         SETTING THE INITIAL VALUES OF THE RENORMALIZED INERTIA
C=======================================================================
C
      ROTMAS=1 ! TEMPORARY !
C
      ROTREN(1)=-ROTMAS*ROTRIN(1)
      ROTREN(2)=-ROTMAS*ROTRIN(2)
      ROTREN(3)=-ROTMAS*ROTRIN(3)
C
C=======================================================================
C         DEFINITION (IN DEVHER) OF THE AUXILIARY EXPANSION COEFFICIENTS
C         TO EXPRESS  THE  PRODUCTS OF  T W O  HERMITE POLYNOMIALS, OR A
C         PRODUCT OF ONE POLYNOMIAL AND A DERIVATIVE ETC.  BY  A  SERIES
C         OF SINGLE HERMITE POLYNOMIALS
C=======================================================================
C         DEFINITION ( IN DEFINT ) OF HARMONIC OSCILLATOR WAVE FUNCTIONS
C         AND GAUSS-HERMITE INTEGRATION POINTS AND WEIGHTS
C=======================================================================
C         DEFINITION ( IN DEFYLM ) OF SOLID      HARMONICS
C         DEFINITION ( IN DEFSLM ) OF SURFACE    HARMONICS
C         DEFINITION ( IN DEFPLM ) OF PENSURFACE HARMONICS
C=======================================================================
C         THE PENSURFACE MOMENTS ARE CALCULATED ONLY IF "IDOPLM" IS  SET
C         ABOVE TO 1. THE CALCULATION OF  THE  PENSURFACE  MOMENTS  THEN
C         STRICTLY FOLLOWS THAT OF THE SURFACE MOMENTS, ALTHOUGH NOT ALL
C         OPTIONS AND TESTS ARE IMPEMENTED YET; YOU SHOULD PROCEED  WITH
C         EXTREME CAUTION!
C=======================================================================
C
      NOBODY=2
      NBDONE=1
C
      NMUMAX=1
      NMUMAX=MAX(NMUMAX,NMUCON,NMUCOU,NMUPRI)
C
      NMAMAX=0
      NMAMAX=MAX(NMAMAX,NMACON,NMAPRI)
C
      NSIMAX=0
      NSIMAX=MAX(NSIMAX,NSICON,NSIPRI)
C
      NASMAX=0
      NASMAX=MAX(NASMAX,NASCON,NASPRI)
C
C=======================================================================
C         ATTENTION: AFTER THE  MAGNETIC  MOMENTS  WERE  INPLEMENTED  IN
C                    VERSION (2.02), VARIABLE "NMUPOW" WAS NOT  PROPERLY
C                    UPDATED AND IT WAS LEFT  EQUAL  TO  THE  NUMBER  OF
C                    MULTIPOLE MOMENTS "NMUMAX",  WHEREAS  TO  DETERMINE
C                    THE ORBITAL ANGULAR MOMENTUM IN "INTORB", IT SHOULD
C                    HAVE BEEN EQUAL TO AT LEAST "NMAMAX"+1.  THEREFORE,
C                    FOR "NMUMAX"<="NMAMAX"  THE  CODE  COULD  NOT  WORK
C                    CORRECTLY. THIS BUG WAS CORRECTED ON 15/12/2021  IN
C                    VERSION (3.09H).
C=======================================================================
C
      NMUPOW=NMUMAX
      IF (NMAMAX.GT.0)                 NMUPOW=MAX(NMUPOW,NMAMAX+1)
      IF (NASMAX.GT.0)                 NMUPOW=MAX(NMUPOW,NASMAX+1)
      IF (NMAORD.GT.0)                 NMUPOW=MAX(NMUPOW,NMAMAX+1+
     *                                                   2*NMAORD)
      IF (NASORD.GT.0)                 NMUPOW=MAX(NMUPOW,NASMAX+1+
     *                                                   2*NASORD)
      IF (NRAORD.GT.0)                 NMUPOW=MAX(NMUPOW,2*NRAORD)
      IF (NSIMAX.GT.0)                 NMUPOW=MAX(NMUPOW,NSIMAX+2)
      IF (NSIMAX.GT.0.AND.IDOPLM.EQ.1) NMUPOW=MAX(NMUPOW,NSIMAX+4)
C
C=======================================================================
C         IN THE TWO-CENTRE BASIS OPTION DIFFERENT SUBROUTINES (TWC_)
C         ARE USED TO COMPUTE WAVE FUNCTIONS AND COEFFICIENTS. SEE
C         THE MODULE HFODD_TWOCEN FOR MORE INFORMATION.
C=======================================================================
C
      NXMAXX=NXMAXV(1)
      NGAUSS=NXHERM
      NOSACT=NOSCIL
      KARTEZ=1
C
      CALL SCAHER(NOSACT,KARTEZ)
C
      CALL DEVHER(NOSACT,KARTEZ)
C
      CALL DEFINT(NOSACT,KARTEZ,NGAUSS,NOBODY,
     *     HERMTS,DHRMTS,DDHRMT,FOURWG,FOURPT)
C
      CALL COPHER(NOSACT,KARTEZ,NGAUSS,HERMTS,DHRMTS,DDHRMT,
     *                                 CERMTS,CHRMTS,CDHRMT)
C
      CALL DEFINT(NOSACT,KARTEZ,NGAUSS,NBDONE,
     *     HERONE,DHRONE,DDHONE,TWOWGT,TWOPNT)
C
      CALL DEVMUL(NOSACT,NGAUSS,KARTEZ)
C
      CALL DEFMOS(NXMAXX,KARTEZ)
C
      IF (ITWCEN.EQ.2) THEN
C
         CALL TWC_DEFINT(NOSACT,KARTEZ,NGAUSS,ITWCEN)
C
         CALL TWC_DEVHER(NOSACT,KARTEZ,ITWCEN)
C
         CALL TWC_DEVMUL(NOSACT,NGAUSS,KARTEZ,ITWCEN)
C
         CALL TWC_COPHER(NOSACT,KARTEZ,NGAUSS,ITWCEN)
C
      END IF
C
C=======================================================================
C
      NYMAXX=NYMAXV(1)
      NGAUSS=NYHERM
      NOSACT=NOSCIL
      KARTEZ=2
C
      CALL DEVHER(NOSACT,KARTEZ)
C
      CALL DEFINT(NOSACT,KARTEZ,NGAUSS,NOBODY,
     *     HERMTS,DHRMTS,DDHRMT,FOURWG,FOURPT)
C
      CALL COPHER(NOSACT,KARTEZ,NGAUSS,HERMTS,DHRMTS,DDHRMT,
     *                                 CERMTS,CHRMTS,CDHRMT)
C
      CALL DEFINT(NOSACT,KARTEZ,NGAUSS,NBDONE,
     *     HERONE,DHRONE,DDHONE,TWOWGT,TWOPNT)
C
      CALL DEVMUL(NOSACT,NGAUSS,KARTEZ)
C
      CALL DEFMOS(NYMAXX,KARTEZ)
C
      IF (ITWCEN.EQ.2) THEN
C
         CALL TWC_DEFINT(NOSACT,KARTEZ,NGAUSS,ITWCEN)
C
         CALL TWC_DEVHER(NOSACT,KARTEZ,ITWCEN)
C
         CALL TWC_DEVMUL(NOSACT,NGAUSS,KARTEZ,ITWCEN)
C
         CALL TWC_COPHER(NOSACT,KARTEZ,NGAUSS,ITWCEN)
C
      END IF
C
C=======================================================================
C
      NZMAXX=NZMAXV(1)
      NGAUSS=NZHERM
      NOSACT=NOSCIL
      KARTEZ=3
C
      CALL DEVHER(NOSACT,KARTEZ)
C
      CALL DEFINT(NOSACT,KARTEZ,NGAUSS,NOBODY,
     *     HERMTS,DHRMTS,DDHRMT,FOURWG,FOURPT)
C
      CALL COPHER(NOSACT,KARTEZ,NGAUSS,HERMTS,DHRMTS,DDHRMT,
     *                                 CERMTS,CHRMTS,CDHRMT)
C
      CALL DEFINT(NOSACT,KARTEZ,NGAUSS,NBDONE,
     *     HERONE,DHRONE,DDHONE,TWOWGT,TWOPNT)
C
      CALL DEVMUL(NOSACT,NGAUSS,KARTEZ)
C
      CALL DEFMOS(NZMAXX,KARTEZ)
C
      IF (ITWCEN.EQ.2) THEN
C
         CALL TWC_DEFINT(NOSACT,KARTEZ,NGAUSS,ITWCEN)
C
         CALL TWC_DEVHER(NOSACT,KARTEZ,ITWCEN)
C
         CALL TWC_DEVMUL(NOSACT,NGAUSS,KARTEZ,ITWCEN)
C
         CALL TWC_COPHER(NOSACT,KARTEZ,NGAUSS,ITWCEN)
C
      END IF
C
C=======================================================================
C
C      IF (ITWCEN.EQ.2) CALL TWC_ROTBAS(ITWCEN,LDTWCE)
C
C=======================================================================
C
      CALL DEFEXP(ITWCEN,LDTWDD)
C
C=======================================================================
C
      CALL DEFYLM
      CALL DEFSLM
      CALL DEFVLM
      IF (IDOPLM.EQ.1)
     *CALL DEFPLM
C
      CALL DEFUNI(NMUMAX,NSIMAX,NMAMAX,NASMAX)
C
C=======================================================================
C         BUILDING ARRAYS PERTAINING TO THE SPHERICAL HO BASIS
C=======================================================================
C
      IF (ISPHER.EQ.1) THEN
C
C         CALL DOSPHE(NOSACT,NGAUSS,NXHERM,NYHERM,NZHERM)
C
      END IF
C
C=======================================================================
C         DEFINING THE SPHERICAL HARMONICS REQUIRED FOR A CALCULATION OF
C         EXACT BOHR DEFORMATION PARAMETERS
C=======================================================================
C
      IF (NEXBET.GT.0.AND.IPRIBE.EQ.1) CALL LOADIN(NEXBET)
C
C=======================================================================
C         DEFINING THE MULTIPOLES TO BE USED IN THE COULOMB POTENTIAL
C=======================================================================
C
      CALL MULCOU(ISIMPY,ISIGNY,ISIQTY,NMUCOU)
C
C=======================================================================
C         DEFINING THE FOURIER INTEGRALS  FOR  THE  COULOMB POTENTIAL
C=======================================================================
C
      CALL PRECOU(NOSCIL,NUMCOU,NUMETA,BOUCOU,
     *            NFICOU,FILCOU,ICOULI,ICOULO)
C
C=======================================================================
C         CALCULATING THE PHASES ACCORDING TO SOME INGENIOUS CONVENTION
C=======================================================================
C
      CALL PHASES(ITWCEN)
C
C=======================================================================
C         CALCULATING THE NORM OVERLAP MATRIX FOR THE TWO-CENTRE OPTION
C=======================================================================
C
      IF (ITWCEN.EQ.2) CALL TWC_NORMAT(IEIGCU,EIGCUT)
C
C=======================================================================
C         PRINTING THE INFORMATION CONCERNING THE CURRENT RUN
C=======================================================================
C
      CALL INFPRI(IN_FIX,IZ_FIX,
     *                   NUMCOU,NUMETA,FURMAX,
     *                   ICOTYP,ICOUDI,ICOUEX,
     *            PIMASS,PNMASS,IYUTYP,I_YUKA,
     *            YUKAGT,YUKAG0,YUKAG1,YUKAG2,
     *                          I_GOGA,IGOGPA,
     *                          I_REGA,IREGPA,
     *                          I_SEPA,ISEPPA,
     *                          I_COUA,ICOUPA,
     *                   N3LORD,N3SERD,IDOTHC,
     *     NUCHAO,NUPING,EPSPNG,EPSITE,EPSCON,
     *                   NOITER,NULAST,NUCONS,
     *            DELFIN,DELFIP,IDEFIN,IDEFIP,
     *            FERFIN,FERFIP,IFEFIN,IFEFIP,
     *            FE2FIN,FE2FIP,IF2FIN,IF2FIP,
     *            FERALN,FERALP,IFERAN,IFERAP,
     *                                 NUQEVE,
     *            INSIGN,IPSIGN,ISSIGN,IDSIGN,
     *            INSIGP,IPSIGP,ISSIGP,IDSIGP,
     *                   INSIMN,IRSIMN,IDSIMN,
     *                   INSIMP,IRSIMP,IDSIMP,
     *                   INSIQN,IPSIQN,IDSIQN,
     *                   INSIQP,IPSIQP,IDSIQP,
     *                          INSIZN,IDSIZN,
     *                          INSIZP,IDSIZP,
     *                          IFIBLN,INIBLN,
     *                          IFIBLP,INIBLP,
     *                   ECUTOF,LIMQUA,LAMCUT,
     *            ISPHER,ISIMPY,ISIGNY,ISIQTY,
     *                   ISIMTX,JSIMTY,ISIMTZ,
     *            ISYMDE,INIROT,INIINV,INIKAR,
     *                   IRENMA,IRENIN,IDOGOA,
     *                   ITWOLI,JETACM,KETA_R,
     *                                 NOZEPA,
     *                          KETAJ2,KETAT2,
     *                          JETA_T,JETAPA,
     *                   IFRWAV,ITOWAV,IWRWAV,
     *                   IONISH,ISAKER,ICHKER,
     *                   IPRGCM,IPROMI,IPROMA,
     *                   NUAKNO,NUBKNO,KPROJE,
     *                   NATKNO,NBTKNO,ISOSTZ,
     *            NPNKNO,NTZKNO,NPAKNO,IPAPRO,
     *            ISOSMI,ISOSMA,EPSISO,ICSKIP,
     *            IPAKER,IPAK3D,IPAALL,KFIKER,
     *            NUASTA,NUASTO,NUGSTA,NUGSTO,
     *            NATSTA,NATSTO,NGTSTA,NGTSTO,
     *            NUBSTA,NUBSTO,NUTSTA,NUTSTO,
     *                          ISLPRI,ISUPRI,
     *                   IENPRI,ISRPRI,IMIPRI,
     *                   IKEPRI,IRMPRI,IELPRI,
     *            QMUCUT,QMACUT,QASCUT,QSICUT,
     *            IMOVAX,ITILAX,ITISAX,NO_ORB,
     *                   IPRSTA,IPRMID,IPRSTO,
     *            IDESTA,IDEMID,IDESTO,IDEDIS,
     *                          INTRIP,IVIPRI,
     *                   IPRI_N,IPRI_P,IPRI_T,
     *     IPAIRI,IPAHFB,ITWOBA,JPABCS,IMFHFB,
     *                                 IPNMIX,
     *                          LIPKIN,LIPKIP,
     *                          LIPNON,LIPNOP,
     *                          IQUNIL,NILXYZ,
     *                   IROTAT,ITIREP,IQPSTA,
     *                   NMUCON,NMUCOU,NMUPRI,
     *            ISCHIF,NSIMAX,NSICON,NSIPRI,
     *                                 IDOPLM,
     *            NMAMAX,NMACON,NMAPRI,NMAORD,
     *            NASMAX,NASCON,NASPRI,NASORD,
     *                                 NRAORD,
     *            NMURED,NMARED,NASRED,NSIRED,
     *            SLOWEV,SLOWOD,SLOWPA,SLOWLI,
     *                   ICONTI,IPCONT,IOCONT,
     *                   ISCONT,ITCONT,IACONT,
     *            IYCONT,IGCONT,IGPCON,IECONT,
     *     ILCONT,IFCONT,IMCONT,IRCONT,IBCONT,
     *                                 IPOTHO,
     *                   BOUCOU,IFSHEL,IF_RPA,
     *                          I_SLOW,SLOWAL,
     *            SLOWLD,SLOWTP,SLOWRP,SLOWLM,
     *            NLSIGN,NLSIMN,NLSIQN,NLSIZN,
     *            NLSIGP,NLSIMP,NLSIQP,NLSIZP,
     *                   IAXIAP,KAPASY,INUNIL,
     *                                 IADBAT,
     *                          NEWGOG,NEWCOU,
     *                                 ITWCEN)
C
C=======================================================================
C         PRINTING THE INFORMATION CONCERNING THE CONFIGURATIONS
C=======================================================================
C
      IF (IPAIRI.NE.1.OR.IPA2HF(0).GE.1.OR.IPA2HF(1).GE.1) THEN
C
          IF (IPNMIX.NE.1) THEN
C
              IF (ISIMPY.EQ.1) THEN
C
                  IF (ISIGNY.EQ.1) THEN
C
                      CALL SIGPRI(ICHFLI,IPAFLI,IREFLI,
     *                            ISPFLI,ISHFLI,IFLIPI)
                  ELSE
C
                      CALL SIMPRI(ICHFLI,       IREFLI,
     *                            ISPFLI,ISHFLI,IFLIPI)
                  END IF
C
              ELSE
C
                  IF (ISIQTY.EQ.1) THEN
C
                      CALL SIQPRI(ICHFLI,IPAFLI,
     *                            ISPFLI,ISHFLI,IFLIPI)
                  ELSE
C
                      CALL SIZPRI(ICHFLI,
     *                            ISPFLI,ISHFLI,IFLIPI)
                  END IF
C
              END IF
C
          ELSE
C
              IF (ISIMPY.EQ.1) THEN
C
                  IF (ISIGNY.EQ.1) THEN
C
                      CALL MIGPRI(       IPAFLI,IREFLI,
     *                            ISPFLI,ISHFLI,IFLIPI)
                  ELSE
C
                      CALL MIMPRI(              IREFLI,
     *                            ISPFLI,ISHFLI,IFLIPI)
                  END IF
C
              ELSE
C
                  IF (ISIQTY.EQ.1) THEN
C
                      CALL MIQPRI(       IPAFLI,
     *                            ISPFLI,ISHFLI,IFLIPI)
                  ELSE
C
                      CALL MIZPRI(
     *                            ISPFLI,ISHFLI,IFLIPI)
                  END IF
C
              END IF
          END IF
C
      END IF
C
C=======================================================================
C         ZEROING THE HARTREE-FOCK FIELDS
C=======================================================================
C
      DO ITPNMX=0,LDPNMX
         CALL ZEFILD(ITPNMX)
      END DO
C
C=======================================================================
C=======================================================================
C         HERE STARTS THE    H A R T R E E - F O C K   I T E R A T I O N
C=======================================================================
C         T H R E E  DIFFERENT VARIABLES KEEP TRACK  OF  THE  NUMBER  OF
C         ITERATIONS:
C
C         NOITER = THE REQUESTED NUMBER OF THE HARTREE-FOCK  ITERATIONS.
C                  IT CAN BE EQUAL TO ZERO WHEN THE STARTING POINT  IS A
C                  NILSSON OR WOODS-SAXON POTENTIAL. IT CANNOT BE  EQUAL
C                  TO ZERO WHEN THE  CODE  STARTS  FROM  THE  PREVIOUSLY
C                  RECORDED HARTREE-FOCK SOLUTION.
C         NUMITE = THE EFFECTUATED NUMBER OF THE HARTREE-FOCK ITERATIONS
C                  THAT TAKES INTO ACCOUNT ALL THE  PREVIOUSLY  RECORDED
C                  HARTREE-FOCK SOLUTIONS.
C         ITERUN = THE NUMBER OF THE HARTREE-FOCK  ITERATIONS  PERFORMED
C                  IN THE CURRENT RUN.
C=======================================================================
C      TEST DEFGOG AHEAD OF DOING THE FIRST ITERATION
C=======================================================================
C
C     CALL PHCHAN(GOGSTR,GOG_SD,GOG_VD,GOG_SE,GOG_VE,NDGOGA,NUGOGA)
C
C     GOGWI0=GOGWID(1)
C
C     CALL DEFGOG(NXMAXX,NXHERM,1,GOGWI0,
C    *            GAU_X0,GAU_X1,GAU_X2,GAU_X4,GAU_X6,GAUX21,GAUX22,
C    *                                        GAUX41,GAUX42,GAUX43)
C=======================================================================
C
      ITESTA=0
      ITESTO=NOITER
      IF (NOITER.EQ.0) TERMNT=.TRUE.
C
      IF (ITESTO.LT.ITESTA) STOP 'NO ITERATIONS 1'
C
C=======================================================================
C
      IF (IF_THO.EQ.0) NUMITE=-1
C
C=======================================================================
C      PRINTING OUT INFORMATION ON INFORMATION RECORDED ON DISK
C=======================================================================
C
      CALL RESPRI(IWRIRE,IWRIYU,IWRIFI,IWRIGO,IWRIRO,IWRILI,
     *            IWRIBA,I_YUKA,JETACM,KETA_R,LIPKIN,LIPKIP,
     *                          I_GOGA,IGOGPA,I_REGA,IREGPA,
     *                                        ICOUDI,ICOUEX)
C
C=======================================================================
C      ALLOCATING  AND ZEROING THE MATRICES OF THE COULOMB, YUKAWA
C      AND GOGNY FIELDS,  AS WELL AS THE DENSITY MATRICES PRIOR TO
C      EXECUTION. RESTART OPTIONS WILL SIMPLY OVERWRITE THESE ZERO
C      MATRICES WITH ACTUAL VALUES READ FROM FILES.
C=======================================================================
C     ATTENTION: FOR THE REGULARIZED SKYRME INTERACTION,  SAVING  OF
C                THE PAIRING FIELDS IN A SEPARATE FILE, WHICH EXISTS
C                FOR THE GOGNY INTERACTION, IS NOT IMPLEMENTED. THUS
C                FOR  SAVING  RESULTS  OBTAINED  IN  THIS  CASE  AND
C                RESTARTING CALCULATIONS, ONE SHOULD USE THE GENERIC
C                SAVING OF FIELDS, GOVERNED BY "IWRIFI".
C=======================================================================
C
      CALL ZERCOU(ICOUDI,ICOUEX,I_COUA,ICOUPA,NEWCOU)
C
      IF (I_YUKA.GE.2) CALL ZERYUK
C
      IF (LIPKIN.EQ.1.OR.LIPKIP.EQ.1) CALL ZERLIP(ISIMPY,IFCONT)
C
      IF (I_GOGA.GE.2.AND.NEWGOG.EQ.0) CALL ZERGOG
C
      IF (IGOGPA.GE.2.AND.NEWGOG.EQ.0) CALL ZERGPA
C
      IF (I_REGA.GE.2.OR.(I_GOGA.GE.2.AND.NEWGOG.EQ.1)) CALL ZERREG
C
      IF (IREGPA.GE.2.OR.(IGOGPA.GE.2.AND.NEWGOG.EQ.1)) CALL ZERRPA
C
      IF (I_SEPA.GE.2) CALL ZERSEP(LDPNMX)
C
      IF (ISEPPA.GE.2) CALL ZERSPA(LDPNMX)
C
      IF (MAXVAL(I_FSTA).GE.2) CALL ZERFST
C
      IF (MAXVAL(IFSTPA).GE.2) CALL ZERFPA
C
C=======================================================================
C         ZEROING THE AVERAGE VALUES AND MEAN FIELDS OF  LINEAR  MOMENTA
C=======================================================================
C
      IF (JETACM.EQ.2) THEN
C
          ALINLT(:)=0.0D0
C
          CALL ZERLIN(ISIMPY,IPAIRI)
C
      END IF
C
C=======================================================================
C         ZEROING THE AVERAGE VALUES AND MEAN FIELDS OF ANGULAR  MOMENTA
C=======================================================================
C
      IF (KETA_R.EQ.2) THEN
C
          AROTLT(:)=0.0D0
C
          CALL ZERROT(ISIMPY,IPAIRI)
C
      END IF
C
C=======================================================================
C               C O N T I N U A T I O N   M O D E S
C=======================================================================
C
      IF (ICONTI.EQ.1) THEN
C
C         INPFLD=1 => THE FILE WITH THE UNIT NUMBER  NFIREP WILL BE
C                     USED TO  R E A D  THE RESULTS OF THE PREVIOUS
C                                                               RUN
          WRITE(NFIPRI,'(79(1H*),/,1H*,77X,1H*,/,
     *            1H*,''  CALLING SUBROUTINE "RECORD" TO READ'',
     *                '' THE REPLAY FILE OBTAINED PREVIOUSLY'',4X,1H*,/,
     *            1H*,2X,A68,                                  7X,1H*)')
     *
     *            FILREP
C
          INPFLD=1
          IERROR=0
C
          CALL RECORD(NFIREP,NFIREC,INPFLD,NUMITE,
     *                IVEREP,NXHERM,NYHERM,NZHERM,
     *                              IPCONT,ILCONT,
     *                       ISCONT,ITCONT,IACONT,
     *                              IMCONT,IRCONT,
     *                              IRENMA,IRENIN,
     *                              LIPKIN,LIPKIP,
     *                              REFERN,REFERP,
     *                              REDELN,REDELP,
     *                              REFE2N,REFE2P,
     *                              IDSIGN,IDSIGP,
     *                              IDSIMN,IDSIMP,
     *                              IDSIQN,IDSIQP,
     *                              IDSIZN,IDSIZP,
     *                                     INIBLN,
     *                                     INIBLP,
     *                              NMUMAX,NSIMAX,
     *                              IPNMIX,ISHIFT,
     *                              JETA_T,JETAPA,IERROR,
     *                                     LDTWCE,LDTWDD,
     *                                            IFRCNT)
C
          IF (IERROR.NE.0) THEN
C
#if(USE_MPI==1)
C
              IPCONT=0
              IFCONT=0
              IACONT=0
              IYCONT=0
              IGCONT=0
              IGPCON=0
              ILCONT=0
C
              WRITE(NFIPRI,'(
     *              '' ////////////////////////////////////////'',
     *              ''/////////////////////////////////////'',/,
     *              '' ////       WARNING: RECORD FILE IS CORRUPTED'',
     *              '' !                          /////'',/,
     *              '' ////                 - RESTART IS CANCELLED '',
     *              ''                            /////'',/,
     *              '' ////                 - CALCULATIONS WILL RES'',
     *              ''TART FROM SCRATCH           /////'',/,
     *              '' ////////////////////////////////////////'',
     *              ''/////////////////////////////////////'')')
C
#else
              STOP 'RECORD FILE CORRUPTED - STOP HERE'
#endif
C
          END IF
C
C@@@ NECK - NECK - NECK - NECK - NECK - NECK - NECK - NECK - NECK
           IF (IFNECK.GE.1) THEN
C
C              Computing the total density
              CALL TRUTOD(1,1)
C              Computing the charge density (here proton density)
              CALL TRUCHD
C
C              We find the position of the neck
              ITEBIS=0
              CALL QNFIND(NXHERM,NYHERM,NZHERM,SLOWOD,ITEBIS,ISIMPY,
     *                                                ISIGNY,IPARTY)
C
           END IF
C@@@ NECK - NECK - NECK - NECK - NECK - NECK - NECK - NECK - NECK
C
#if(USE_MPI==1)
          CALL mpi_pathExploration(IERROR,NMUCON)
#endif
C
          IF (NOITER.EQ.1) TERMNT=.TRUE.
C
          ITESTA=NUMITE + 1
          ITESTO=NUMITE + NOITER
          ITERUN=0
C
          IF (ITESTO.LT.ITESTA) STOP 'NO ITERATIONS 2'
C
C=======================================================================
C         RECALCULATING THE COULOMB MATRIX ELEMENTS FROM THE PROTON
C         DENSITY THAT HAS JUST BEEN  READ  FROM  THE  REPLAY  FILE
C=======================================================================
C
          IF (ICOUDI.EQ.1) THEN
C
              CALL COUMAT(NUMCOU,BOUCOU,ISIMPY,IKERNE)
C
          END IF
C
C=======================================================================
C         RECALCULATING THE TOTAL DENSITY AND  THE  CHARGE  DENSITY
C         FROM NEUTRON AND PROTON DENSITIES  THAT  HAVE  JUST  BEEN
C         READ FROM THE REPLAY FILE
C
C         ATTENTION: IN THE VERSIONS OF THE CODE EARLIER THAN 1.98J,
C                    THE TOTAL DENSITY WAS NOT  RECALCULATED,  WHICH
C                    RESULTED IN INCORRECT  VALUES  OF  THE  PAIRING
C                    ENERGY AND PAIRING REARRANGEMENT ENERGY  (FOR A
C                    DENSITY-DEPENDENT HFB PAIRING ONLY, AND IN  THE
C                    FIRST ITERATION AFTER A RESTART ONLY). THIS BUG
C                    HAD NO EFFECT ON THE CONVERGENCE,  BECAUSE  THE
C                    CORRESPONDING  PAIRING  FIELDS  ARE  CALCULATED
C                    AFTER THE REGULAR CALL TO THE "TRUTOD" ROUTINE.
C=======================================================================
C
          CALL TRUTOD(ITWCEN,LDTWCE)
C
C=======================================================================
C         RESETTING THE HFB PAIRING PROPERTIES TO THOSE FOUND ON  REPLAY
C         FILE PROVIDED SUCH COURSE OF ACTION IS ALLOWED BY THE RELEVANT
C         DATA PARAMETER "IPCONT". THUS:
C            FOR IPCONT=0 PAIRING PROPERTIES ARE  TAKEN  FROM  THE  DATA
C                         (FROM THE FERINI, DELINI, AND  FE2INI  ARRAYS)
C            FOR IPCONT=1 PAIRING PROPERTIES ARE TAKEN FROM  THE  REPLAY
C                         FILE.
C=======================================================================
C
          IF (IPCONT.EQ.1) THEN
C
              EFERMN=REFERN
              DELTAN=REDELN
              IF (ILCONT.GE.1) EFER2N=REFE2N
C
              EFENIN=EFERMN
              EFENOU=0.0D0
C
              EFERMP=REFERP
              DELTAP=REDELP
              IF (ILCONT.GE.1) EFER2P=REFE2P
C
              EFEPIN=EFERMP
              EFEPOU=0.0D0
C
              EFERMA=REFERA
              DELTAA=REDELA
C
          ELSE
C
              IF (IPNMIX.NE.1) THEN
C
                  CALL INIPAI(0,IPNMIX,ITWCEN,LDTWCE)
                  CALL INIPAI(1,IPNMIX,ITWCEN,LDTWCE)
              ELSE
                  CALL INIPAI(2,IPNMIX,1,1)
C
              END IF
C
          END IF
C
C=======================================================================
C         RESETTING THE LINEAR CONSTRAINTS  OF  THE  AUGMENTED  LAGRANGE
C         METHOD TO THOSE READ FROM THE RECORD FILE PROVIDED SUCH COURSE
C         OF ACTION IS ALLOWED BY THE RELEVANT DATA PARAMETER "IACONT".
C=======================================================================
C
          IF (IACONT.EQ.1) THEN
C
              DO LAMBDA=0,NDMULT
                 DO MIU=-LAMBDA,LAMBDA
C
                    GALMUQ(LAMBDA,MIU)=RALMUQ(LAMBDA,MIU)
                    GALMUS(LAMBDA,MIU)=RALMUS(LAMBDA,MIU)
C
                    GALMUV(LAMBDA,MIU)=RALMUV(LAMBDA,MIU)
C
                 END DO
              END DO
C
          END IF
C
C=======================================================================
C         RESETTING THE  SPIN  CONSTRAINTS  OF  THE  AUGMENTED  LAGRANGE
C         METHOD TO THOSE READ FROM THE RECORD FILE PROVIDED SUCH COURSE
C         OF ACTION IS ALLOWED BY THE RELEVANT DATA PARAMETER "ISCONT".
C=======================================================================
C
          IF (ISCONT.EQ.1) THEN
C
              GALSPI=RALSPI
              OMOVAX=OMEGAX+GALSPI(1)
              OMOVAY=OMEGAY+GALSPI(2)
              OMOVAZ=OMEGAZ+GALSPI(3)
C
          END IF
C
C=======================================================================
C         RESETTING THE ISOSPIN CONSTRAINTS OF  THE  AUGMENTED  LAGRANGE
C         METHOD TO THOSE READ FROM THE RECORD FILE PROVIDED SUCH COURSE
C         OF ACTION IS ALLOWED BY THE RELEVANT DATA PARAMETER "ITCONT".
C=======================================================================
C
          IF (ITCONT.EQ.1) THEN
C
              GALISO=RALISO
              FERMOV(1)=FERISO(1)+GALISO(1)
              FERMOV(2)=FERISO(2)+GALISO(2)
              FERMOV(3)=FERISO(3)+GALISO(3)
C
          END IF
C
C=======================================================================
C         RESETTING THE YUKAWA MEAN FIELDS TO THOSE FOUND ON THE  YUKAWA
C         FILE PROVIDED THE FIELDS FILE IS NOT USED. THUS:
C           FOR IYCONT=0 THE YUKAWA MEAN FIELDS ARE SET TO ZERO,
C           FOR IYCONT=1 THE YUKAWA MEAN FIELDS ARE READ FROM THE YUKAWA
C                        FILE.
C=======================================================================
C
          IF (IYCONT.EQ.1.AND.IFCONT.NE.1) THEN
C
              WRITE(NFIPRI,'(1H*,77X,1H*,/,
     *            1H*,''  CALLING SUBROUTINE "RECYUK" TO READ'',
     *                '' THE YUKAWA FILE OBTAINED PREVIOUSLY'',4X,1H*,/,
     *            1H*,2X,A68,                                  7X,1H*)')
     *
     *            FILYUP
C
              INPYUK=1
C
              CALL RECYUK(NFIYUP,NFIYUC,INPYUK)
C
          END IF
C
C=======================================================================
C         RESETTING THE GOGNY MEAN FIELDS TO THOSE FOUND ON  THE  GOGNY
C         FILE PROVIDED THE FIELDS FILE IS NOT USED. THUS:
C           FOR IGCONT=0 THE GOGNY MEAN FIELDS ARE SET TO ZERO,
C           FOR IGCONT=1 THE GOGNY MEAN FIELDS ARE READ FROM THE YGOGNY
C                        FILE.
C=======================================================================
C
          IF (IGCONT.EQ.1.AND.IFCONT.NE.1) THEN
C
              WRITE(NFIPRI,'(1H*,77X,1H*,/,
     *            1H*,''  CALLING SUBROUTINE "RECGOG" TO READ'',
     *                '' THE GOGNY FILE OBTAINED PREVIOUSLY '',4X,1H*,/,
     *            1H*,2X,A68,                                  7X,1H*)')
     *
     *            FILGOP
C
              INPGOG=1
C
              CALL RECGOG(NFIGOP,NFIGOC,INPGOG)
C
              ISGOGA=1
C
          ELSE
C
              ISGOGA=0
C
          END IF
C
C=======================================================================
C         RESETTING THE GOGNY PAIRING FIELDS TO THOSE FOUND ON THE GOGNY
C         PAIRING FILE PROVIDED THE FIELDS FILE IS NOT USED. THUS:
C           FOR IGPCON=0 THE GOGNY PAIRING FIELDS ARE SET TO ZERO,
C           FOR IGPCON=1 THE GOGNY PAIRING FIELDS ARE READ FROM THE
C                        GOGNY FILE.
C=======================================================================
C
          IF (IGPCON.EQ.1.AND.IFCONT.NE.1) THEN
C
              WRITE(NFIPRI,'(1H*,77X,1H*,/,
     *            1H*,''  CALLING SUBROUTINE "RECGPA" TO READ'',
     *                '' THE GOGNY FILE OBTAINED PREVIOUSLY '',4X,1H*,/,
     *            1H*,2X,A68,                                  7X,1H*)')
     *
     *            FILGPA
C
              INPGPA=1
C
              CALL RECGPA(NFIGPP,NFIGPC,INPGPA)
C
              ISGOGP=1
C
          ELSE
C
              ISGOGP=0
C
          END IF
C
C=======================================================================
C         RESETTING THE REGUL MEAN FIELDS TO THOSE FOUND  ON  THE  REGUL
C         FILE PROVIDED THE FIELDS FILE IS NOT USED. THUS:
C           FOR IECONT=0 THE REGUL MEAN FIELDS ARE SET TO ZERO,
C           FOR IECONT=1 THE REGUL MEAN FIELDS ARE READ FROM THE REGUL
C                        FILE.
C=======================================================================
C
          IF (IECONT.EQ.1.AND.IFCONT.NE.1) THEN
C
              WRITE(NFIPRI,'(1H*,77X,1H*,/,
     *            1H*,''  CALLING SUBROUTINE "RECREG" TO READ'',
     *                '' THE REGUL FILE OBTAINED PREVIOUSLY '',4X,1H*,/,
     *            1H*,2X,A68,                                  7X,1H*)')
     *
     *            FILROP
C
              INPREG=1
C
              CALL RECREG(NFIROP,NFIROC,INPREG)
C
              ISREGA=1
C
          ELSE
C
              ISREGA=0
C
          END IF
C
C=======================================================================
C         RESETTING THE DENSITY MATRICES TO THOSE FOUND ON  THE  LIPKIN
C         FILE PROVIDED THE FIELDS FILE IS NOT USED. THUS:
C           FOR ILCONT=0 THE DENSITY MATRICES ARE SET TO ZERO,
C           FOR ILCONT=1 THE DENSITY MATRICES ARE READ FROM  THE  LIPKIN
C                        FILE.
C=======================================================================
C
          IF (ILCONT.EQ.1.AND.IFCONT.NE.1) THEN
C
              WRITE(NFIPRI,'(1H*,77X,1H*,/,
     *            1H*,''  CALLING SUBROUTINE "RECLIP" TO READ'',
     *                '' THE LIPKIN FILE OBTAINED PREVIOUSLY'',4X,1H*,/,
     *            1H*,2X,A68,                                  7X,1H*)')
     *
     *            FILLIP
C
              INPLIP=1
C
              CALL RECLIP(NFILIP,NFILIC,INPLIP,ISIMPY)
C
          END IF
C
C=======================================================================
C         ZEROING THE AVERAGE VALUES AND MEAN FIELDS OF  LINEAR  MOMENTA
C         WHEN THE CALCULATION OF CM CORRECTION BEFORE VARIATION IS  NOT
C         RESTARTED FROM THE DISK
C=======================================================================
C
          IF (JETACM.EQ.2.AND.IMCONT.NE.1) THEN
C
              DO KARTEZ=0,NDKART
C
                 ALINLT(KARTEZ)=0.0D0
C
              END DO
C
              CALL ZERLIN(ISIMPY,IPAIRI)
C
          END IF
C
C=======================================================================
C         ZEROING THE AVERAGE VALUES AND MEAN FIELDS OF ANGULAR  MOMENTA
C         WHEN THE CALCULATION OF ROT CORRECTION BEFORE VARIATION IS NOT
C         RESTARTED FROM THE DISK
C=======================================================================
C
          IF (KETA_R.EQ.2.AND.IRCONT.NE.1) THEN
C
              DO KARTEZ=0,NDKART
C
                 AROTLT(KARTEZ)=0.0D0
C
              END DO
C
              CALL ZERROT(ISIMPY,IPAIRI)
C
          END IF
C
C=======================================================================
C         READING THE FIELDS FROM THE FIELD FILE
C=======================================================================
C
          IF (IFCONT.EQ.1.AND.IF_THO.EQ.0) THEN
C
              WRITE(NFIPRI,'(1H*,77X,1H*,/,
     *            1H*,''  CALLING SUBROUTINE "RECFIL" TO READ'',
     *                '' THE FIELDS FILE OBTAINED PREVIOUSLY'',4X,1H*,/,
     *            1H*,2X,A68,                                  7X,1H*)')
     *
     *            FILFIP
C
              INPFIL=1
C
              CALL RECFIL(NFIFIP,NFIFIC,INPFIL,ISIMPY,IPAHFB,
     *                                  IPNMIX,NOSCIL,NUMITE,
     *                           EFERMN,EFERMP,EFER2N,EFER2P,
     *                                  DELTAN,DELTAP,IF_THO,
     *                                         NLIMIT,FILTHO,
     *                           ISGOGP,ISREGP,REA2PP,IVEFIP)
C
          END IF
C
          WRITE(NFIPRI,'(1H*,77X,1H*,/,79(1H*),/)')
C
      END IF
C
C@@@ HFBTHO -HFBTHO - HFBTHO - HFBTHO - HFBTHO - HFBTHO - HFBTHO
C
      IF (IF_THO.GE.1) THEN
C
          WRITE(NFIPRI,'(79(''*''),/,''*'',77X,''*'',/,
     *          ''*  CALLING SUBROUTINE  CYLCAR  TO TRANSFORM '',
     *          ''THE HFB MATRIX READ FROM HFBTHO   *'',/,
     *          ''*  INTO THE CARTESIAN BASIS USED IN HFODD.'',
     *          36X,''*'')')
C
          CALL CYLCAR(NOSCIL,ISIMPY,IF_THO)
C
          ITESTA=NUMITE+1
C
          WRITE(NFIPRI,'(''*'',77X,''*'',/,79(''*''),/)')
C
      END IF
C
C@@@ HFBTHO -HFBTHO - HFBTHO - HFBTHO - HFBTHO - HFBTHO - HFBTHO
C=======================================================================
#if(USE_MPI==1)
      IF (IF_THO.EQ.0.AND.batch_mode.EQ.1) THEN
          CALL batch(NFIREP,NFIREC,NFILIP,NFILIC,
     *               FILREP,FILREC,FILLIP,FILLIC,
     *               NUDATA,IF_THO,
     *                      NXHERM,NYHERM,NZHERM,IRENMA,IRENIN,
     *               REFERN,REFERP,REDELN,REDELP,REFE2N,REFE2P,
     *               IFIBLN,INIBLN,IFIBLP,INIBLP,NMUMAX,NSIMAX,
     *                                           NMUCON,ISHIFT,
     *               ICONTI,IPCONT,ILCONT,IACONT,IGCONT,IGPCON,
     *                             ISCONT,ITCONT,IMCONT,IRCONT,
     *               IPAIRI,LIPKIN,LIPKIP,I_GOGA,IGOGPA,I_YUKA,
     *                                    ITWOLI,JETACM,KETA_R,
     *               IPNMIX,Q_NECK,QACTUA,QORIGI,QINCRE,INDJOB,
     *               batch_init)
      END IF
#endif
C
      EF2NIN=EFER2N
      EF2NOU=EFER2N
C
      EF2PIN=EFER2P
      EF2POU=EFER2P
C
C=======================================================================
C=======================================================================
C=======================================================================
C
C         HERE WE ENTER ANY NEW ITERATION OF THE HARTREE-FOCK:
C
C=======================================================================
C=======================================================================
C=======================================================================
C
   1  NUMITE=NUMITE+1
      ITERUN=ITERUN+1
C
C      If extra constraints are used to push the iterations in a
C      certain direction, thee constraints are released after NITPUS
C      iterations. We set the corresponding flag to 0 and re-define
C      the actual constraints
C
C REMOVED INTERFACES 170407
C     IF (IFPUSH.EQ.1.AND.IREAWS.EQ.0.AND.ITERUN.GT.NITPUS) THEN
C
C         DOPUSH = .FALSE.
C
C     END IF
C
C         CALL NUMCON(LAMPUS,MIUPUS,QMOPUS,NUMPUS,IF_RPA,IFPUSH,
C    *                                                   DOPUSH)
C
      IF (ITERUN.GT.NDITER+1) THEN
C
          WRITE(NFIPRI,'(/,1X,20(1H/),
     *                '' ALLOWED NUMBER OF ITERATIONS '',5X,20(1H/),/,
     *                1X,20(1H/),'' NDITER='',I5,'' EXCEEDED'',
     *                                 15X,20(1H/),/)') NDITER
C
          STOP 'ITERUN.GT.NDITER+1 IN MAIN'
C
      END IF
C
C=======================================================================
C         RESETTING  THE PARAMETERS THAT  HANDLE  THE  ANGULAR-MOMENTUM
C         PROJECTION AND CALCULATION OF THE GCM KERNELS FOR THE CURRENT
C         ITERATION
C=======================================================================
C
      ISAWAV=0
      IF (IPRGCM.GE.1.OR.IRENMA.GE.1.OR.IRENIN.GE.1.OR.IWRWAV.GE.1)
     *    ISAWAV=1
      IKERNE=0
C
C=======================================================================
C         HERE WE DEFINE THE LOGICAL SWITCH "PRINIT" THAT DECIDES  ON
C         WHETHER OR NOT THE RESULTS OF THE CURRENT ITERATION WILL BE
C         PRINTED
C=======================================================================
C
      IF ((NUMITE.EQ.ITESTA                     .AND.IPRSTA.EQ.1).OR.
     *    (NUMITE.GT.ITESTA.AND.NUMITE.LT.ITESTO.AND.IPRMID.EQ.1).OR.
     *   ((NUMITE.EQ.ITESTO.OR.TERMNT)          .AND.IPRSTO.EQ.1)) THEN
C
           PRINIT=.TRUE.
      ELSE
           PRINIT=.FALSE.
      END IF
C
C=======================================================================
C         HERE WE DEFINE SWITCHES "ISABLN" AND "ISABLP"  THAT  DECIDE
C         ON WHETHER OR NOT THE SINGLE-PARTICLE STATES  USED  IN  THE
C         QUASIPARTICLE BLOCKING WILL BE SAVED IN THE FIRST ITERATION
C=======================================================================
C
                                                       ISABLN=0
      IF (IFIBLN.EQ.1.AND.INIBLN.EQ.1.AND.ITERUN.EQ.1) ISABLN=1
                                                       ISABLP=0
      IF (IFIBLP.EQ.1.AND.INIBLP.EQ.1.AND.ITERUN.EQ.1) ISABLP=1
C
C=======================================================================
C         HERE WE DEFINE THE LOGICAL SWITCH "PRIYUK" THAT DECIDES  ON
C         WHETHER OR NOT THE TIME-REVERSAL-VIOLATING MATRIX  ELEMENTS
C         OF THE YUKAWA POTENTIAL WILL BE PRINTED.  NOTE  THAT  THESE
C         MATRIX ELEMENTS CAN ONLY BE CALCULATED ONCE THE YUKAWA MEAN
C         FIELD IS KNOWN FOR THE "DIV S" SOURCE DENSITY.  SINCE  THIS
C         DENSITY IS CALCULATED IN THE PREVIOUS ITERATION, THE MATRIX
C         ELEMENTS IN  QUESTION  C A N N O T  BE  CALCULATED  IN  THE
C         F I R S T  ITERATION OF THE CURRENT RUN.
C=======================================================================
C
      PRIYUK=PRINIT.AND.I_YUKA.GE.1.AND.ITERUN.GT.1
C
C=======================================================================
C         HERE WE DEFINE THE LOGICAL SWITCH  "PRIBET"  THAT  DECIDES  ON
C         WHETHER OR NOT THE BOHR DEFORMATION PARAMETERS WILL BE PRINTED
C=======================================================================
C
      PRIBET=PRINIT.AND.(IPRIBE.EQ.1.OR.IPRIBL.EQ.1)
C
C=======================================================================
C         HERE WE DEFINE THE INTEGER VARIABLES THAT DECIDE ON  HOW  MANY
C         MULTIPOLE, SURFACE  OR  SCHIFF,  MAGNETIC,  OR  SPIN-ASYMMETRY
C         MOMENTS IN ONE OF THE REFERENCE FRAMES HAVE TO  BE  CALCULATED
C         IN THE CURRENT ITERATION. THE NAMING CONVENTION IS AS FOLLOWS:
C
C         KXXXYY DENOTES THE NUMBER OF "YY" MOMENTS IN THE "XXX"  FRAME,
C                WHERE YY AND XXX READ:
C
C         XXX = MUL  -->  LABORATORY FRAME
C         XXX = SHI  -->  C-O-M FRAME
C         XXX = ROT  -->  INTRINSIC FRAME
C
C         YY  = MO   -->  MULTIPOLE MOMENTS
C         YY  = SI   -->  SURFACE OR SCHIFF MOMENTS
C         YY  = MA   -->  MAGNETIC MOMENTS
C         YY  = AS   -->  SPIN-ASYMMETRY MOMENTS
C
C         THE NUMBERS OF MULTIPOLE, SURFACE  OR  SCHIFF,  AND  MAGNETIC
C         MOMENTS ARE SET  INDEPENDENTLY  FROM  ONE  ANOTHER,  HOWEVER,
C         FOR ISCHIF=1 THE NUMBER OF SCHIFF MOMENTS MUST NOT BE  LARGER
C         THAN THAT OF THE MULTIPOLE MOMENTS, THAT IS, KMULMO >= KMULSI
C
C         SINCE ALL THE MOMENTS IN THE INTRINSIC FRAME  ARE  CALCULATED
C         IN THE C-O-M FRAME, THE NUMBERS THEREOF MUST OBEY:
C         KMULMO >= KSHIMO >= KROTMO
C         KMULSI >= KSHISI >= KROTSI
C         KMULMA >= KSHIMA >= KROTMA (NOT IMPLEMENTED YET)
C         KMULAS >= KSHIAS >= KROTAS (NOT IMPLEMENTED YET)
C
C         IN ADDITION, ALL CALCULATED LABORATORY MOMENTS MUST BE  LARGER
C         THEN THE CORRESPONDING  REDUCED  MOMENTS  CALCULATED  FOR  THE
C         ANGULAR-MOMENTUM-PROJECTED (AMP) STATES
C=======================================================================
C
                  KROTMO=2
      IF (PRINIT) KROTMO=MAX(KROTMO,NMUPRI)
      IF (TERMNT) KROTMO=MAX(KROTMO,NMUMAX)
C
                  KSHIMO=KROTMO
C
                  KMULMO=KSHIMO
                  KMULMO=MAX(KMULMO,NMUCON)
                  KMULMO=MAX(KMULMO,NMUCOU)
C
C=======================================================================
C
                  KROTSI=0
      IF (PRINIT) KROTSI=MAX(KROTSI,NSIPRI)
      IF (TERMNT) KROTSI=MAX(KROTSI,NSIMAX)
C
                  KSHISI=KROTSI
C
                  KMULSI=KSHISI
                  KMULSI=MAX(KMULSI,NSICON)
C
      IF (ISCHIF.EQ.1) KMULMO=MAX(KMULMO,KMULSI)
C
C=======================================================================
C
                  KROTMA=0
      IF (PRINIT) KROTMA=MAX(KROTMA,NMAPRI)
      IF (TERMNT) KROTMA=MAX(KROTMA,NMAMAX)
C
                  KSHIMA=KROTMA
C
                  KMULMA=KSHIMA
                  KMULMA=MAX(KMULMA,NMACON)
C
C=======================================================================
C
                  KROTAS=0
      IF (PRINIT) KROTAS=MAX(KROTAS,NASPRI)
      IF (TERMNT) KROTAS=MAX(KROTAS,NASMAX)
C
                  KSHIAS=KROTAS
C
                  KMULAS=KSHIAS
                  KMULAS=MAX(KMULAS,NASCON)
C
C=======================================================================
C
      IF (IPRGCM.GE.1) THEN
C
          KMULMO=MAX(KMULMO,NMURED)
          KMULSI=MAX(KMULSI,NSIRED)
          KMULMA=MAX(KMULMA,NMARED)
          KMULAS=MAX(KMULAS,NASRED)
C
      END IF
C
C=======================================================================
C         HERE WE DEFINE THE LOGICAL SWITCH "COR_CM" THAT DECIDES ON
C         WHETHER OR NOT THE QUADRATIC CORRECTION FOR THE CENTER  OF
C         MASS MOTION WILL BE CALCULATED IN THE  CURRENT  ITERATION.
C         SINCE SUCH A CALCULATION IS FAIRLY TIME CONSUMING,  IT  IS
C         PERFORMED ONLY WHEN NECESSARY. FOR EXAMPLE, WHEN THE C-O-M
C         CORRECTION NEEDS TO BE ADDED ONLY AFTER THE VARIATION,  IT
C         IS CALCULATED ONLY IN THE LAST ITERATION. ATTENTION:  SUCH
C         A PROCEDURE RESULTS IN THE TOTAL ENERGY BEING DIFFERENT IN
C         THE LAST BUT ONE AND LAST ITERATIONS.
C=======================================================================
C
      COR_CM=(JETACM.EQ.1.AND.(PRINIT.OR.TERMNT)).OR.
     *        JETACM.EQ.2
C
C=======================================================================
C         SAME AS ABOVE FOR THE LOGICAL SWITCH "CORROT" THAT DECIDES
C         ON THE QUADRATIC CORRECTION FOR THE ROTATIONAL MOTION.
C=======================================================================
C
      CORROT=(KETA_R.EQ.1.AND.(PRINIT.OR.TERMNT)).OR.
     *        KETA_R.EQ.2
C
C=======================================================================
C         HERE WE SET PARAMETER  "IDEVAR"  WHICH REQUESTS CALCULATION OF
C         THE PAIRING MATRIX ELEMENTS IN THE CURRENT ITERATION.
C         THE TRICK WITH IDEAUX IS USED ONLY FOR THE PURPOSE OF AVOIDING
C         DIVISION BY 0 WITHIN MOD(NUMITE,IDEAUX) FOR IDEDIS=0
C=======================================================================
C
      IDEAUX=IDEDIS
      IF (IDEDIS.LT.1) IDEAUX=1
C
      IF (JPABCS.EQ.3.AND.
     *   ((NUMITE.EQ.ITESTA.AND.                     IDESTA.EQ.1).OR.
     *    (NUMITE.GT.ITESTA.AND.NUMITE.LT.ITESTO.AND.IDEMID.EQ.1).OR.
     *   ((NUMITE.EQ.ITESTO.OR.TERMNT)          .AND.IDESTO.EQ.1).OR.
     *    (MOD(NUMITE,IDEAUX).EQ.0              .AND.IDEDIS.GE.1))) THEN
C
           IDEVAR=1
      ELSE
           IDEVAR=0
C
      END IF
C
C=======================================================================
C        SAVING THE SINGLE-PARTICLE DATA THAT HAVE BEEN OBTAINED
C        IN THE PREVIOUS ITERATION
C=======================================================================
C
      IF (ITERUN.GT.1) CALL OLSTOR
C
C=======================================================================
C         ZEROING THE SINGLE-PARTICLE MATRICES
C=======================================================================
C
      CALL SPZERO
C
C=======================================================================
C         HERE BEGINS THE CALCULATION WITHOUT THE PROTON-NEUTRON MIXING
C=======================================================================
C
      IF (IPNMIX.EQ.1) GO TO 8972
C
C=======================================================================
C         FOR IN_FIX=0 WE DO NOT PERFORM ANY CALCULATIONS FOR NEUTRONS
C=======================================================================
C
      IF (IN_FIX.EQ.0) GO TO 8970
C
C=======================================================================
C         HERE STARTS THE BLOCK FOR  N E U T R O N S
C=======================================================================
C
      NAMEPN='NEUTRONS'
C
      ICHARG=0
      ITPNMX=0
C
C=======================================================================
C         SETTING THE SWITCHES THAT DOWNGRADE HFB TO HF IF NEEDED
C=======================================================================
C
      IF (IPA2HF(ICHARG).EQ.1.OR.
     *    IPA2HF(ICHARG).EQ.2.AND.ABS(DELTAN).LT.DEL2HF(ICHARG)) THEN
C
          IF (IPA2HF(ICHARG).EQ.2.AND.ABS(DELTAN).LT.DEL2HF(ICHARG).AND.
     *        IND2HF(ICHARG).NE.1) THEN
C
              WRITE(NFIPRI,'(                                 79(1H*),/,
     *              1H*,7X,'' FROM NOW ON, THE HFB MODE FOR NEUTRONS'',
     *                     '' IS SWITCHED OVER TO HF '',      7X,1H*)')
              IND2HF(ICHARG)=1
C
          END IF
C
          MPAHFB=0
          MPABCS=0
          MPAIRI=0
      ELSE
          MPAHFB=IPAHFB
          MPABCS=JPABCS
          MPAIRI=IPAIRI
C
      END IF
C
      KPAHFB(ICHARG)=MPAHFB
C
C=======================================================================
C        CALCULATING THE MATRIX ELEMENTS OF THE NEUTRON MEAN FIELD
C=======================================================================
C            ATTENTION: BETWEEN VERSIONS (2.50G) AND (2.552) THE CALL TO
C                       "INTEGH"  BELOW  WAS  PERFORMED  FOR  UNDECLARED
C                       ARRAYS "ALINLI" AND "AROTLI" INSTEAD OF "ALINLT"
C                       AND "AROTLT". THIS COULD GIVE INCORRECT  RESULTS
C                       FOR THE EXACT C-O-M CORRECTION BEFORE VARIATION.
C                       THIS BUG WAS CORRECTED ON 06/11/2012 IN  VERSION
C                       (2.553). THE SAME COMMENT APPLIES TO  TWO  OTHER
C                       CALLS TO "INTEGH" BELOW.
C=======================================================================
C        TWO-CENTRE BASIS OPTION: THE MATRIX ELEMENTS OF THE SKYRME
C        HAMILTONIAN ARE GIVEN BY
C
C                    H_IJ= SUM_KL <I|O_KL|J>
C
C        WHERE I,J,K,L REFER TO THE INDEX OF THE CENTRE AND O_KL STANDS
C        FOR AN ARBRITARY MEAN FIELD TERM DEPENDING ON THE W.F'S. THE
C        ORDER OF THE INDEXES IS GIVEN BY THE TABLE
C
C                            I | J | K | L
C                           ---------------
C                       1.   1   1   1   1
C                       2.   1   1   1   2
C                       3.   1   1   2   1
C                       4.   1   1   2   2
C                       5.   1   2   1   1
C                       6.   1   2   1   2
C                       7.   1   2   2   1
C                       8.   1   2   2   2
C                       9.   2   1   1   1
C                      10.   2   1   1   2
C                      11.   2   1   2   1
C                      12.   2   1   2   2
C                      13.   2   2   1   1
C                      14.   2   2   1   2
C                      15.   2   2   2   1
C                      16.   2   2   2   2
C
C        HENCE, THE PAIR IJ SPECIFIES THE BLOCK OF THE HAMILTONIAN, AND
C        IS DETERMINED BY THE OUTER LOOP AS
C
C            LTWCEN=1 --> C1C1
C            LTWCEN=2 --> C2C2
C            LTWCEN=3 --> C2C1 (THE BLOCK C1C2 IS THE COMPLEX
C                              CONJUGATE AND IS BUILD IN TWCCCOP)
C
C        THEN, INNERK/INNERL SPECIFIES THE INDEX FOR THE FIELDS AND FOUR
C        DIFFERENT TERMS ARE SUMMED UP INSIDE INTEGH.    ONCE THE SUM IS
C        DONE, FOR EVERY LTWCEN WE BUILD THE HAMILTONIAN IN TWCCOP AS
C
C
C              (++) | C1C1 | C1C2  |  C1C1 | C1C2 | (+-)
C                   | C2C1 | C2C2  |  C2C1 | C2C2 |
C                      -------------------------
C              (-+) | C1C1 | C1C2  |  C1C1 | C1C2 | (--)
C                   | C2C1 | C2C2  |  C2C1 | C2C2 |
C
C        WHERE +/- STANDS FOR THE SIMPLEX BLOCK.
C
C=======================================================================
C
      IF (NUMITE.GT.0) THEN
C
          IF (NUMITE.GT.ITESTA.OR.(IFCONT.NE.1.AND.IF_THO.EQ.0)) THEN
C
              DO LTWCEN=1,NBLDEN
C
                 INNERI=IND2HL(LTWCEN)
                 INNERJ=IND2HR(LTWCEN)
C
                 DO INNERK=1,ITWCEN
                    DO INNERL=1,ITWCEN
C
                       INDCOE=INTWHE(INNERI,INNERJ,INNERK,INNERL)
C
                       CALL INTEGH(IMOVAX,ITILAX,ITISAX,NO_ORB,
     *                      IPNMIX,ITPNMX,IROTAT,ICHARG,ISIMPY,
     *                             MPAHFB,IPOTHO,ISCHIF,IOCONT,
     *                                           NMUCON,NSICON,
     *                             I_YUKA,I_GOGA,I_REGA,I_SEPA,
     *                                    ITWOLI,JETACM,ALINLT,
     *                                           KETA_R,AROTLT,
     *                                           ICOUDI,ICOUEX,
     *                                           LIPKIN,LIPKIP,
     *                                           EFER2N,EFER2P,
     *                                                  IF_RPA,
     *                                           ILIPON,ILIPOP,
     *                                                  NEWGOG,
     *                                           LTWCEN,ITWCEN,
     *                                                  INDCOE)
C
                    END DO
                 END DO
C
C=======================================================================
C            ATTENTION: BETWEEN VERSIONS (2.78A) AND (2.83Q) THE CALL TO
C                       "MIXFIL"  BELOW  WAS  IN  THE  FIRST   ITERATION
C                       PERFORMED FOR UNDEFINED ARRAYS FIL_PP AND FIL_PM
C                       UNLESS A RESTART FROM FIELDS WAS IN EFFECT.
C                       THIS BUG WAS CORRECTED ON 23/11/2017 IN  VERSION
C                       (2.83R). THE SAME COMMENT APPLIES TO  TWO  OTHER
C                       CALLS TO "MIXFIL" BELOW.
C=======================================================================
C
                 IF (NUMITE.GT.ITESTA.OR.
     *              (IFCONT.EQ.1.OR.IF_THO.EQ.1)) THEN
C
                     IF (I_SLOW.EQ.1)
     *               CALL MIXFIL(ISIMPY,ICHARG,SLOWAL,ITWCEN,LTWCEN)
C
                 END IF
C
                 IF (ITWCEN.EQ.2) THEN
C
                     CALL TWCCOP(ICHARG,LTWCEN)
                     IF (I_SLOW.EQ.1) CALL TWC_SAVFIL(0,ICHARG,LTWCEN)
C
                 END IF
C
              END DO
C
          ELSE
C
              CALL GETFIL(ISIMPY,ICHARG)
C
          END IF
C
          SPMODL='HARTREE-FOCK  '
C
C=======================================================================
C        CALCULATING THE MATRIX ELEMENTS OF THE NEUTRON PAIRING FIELD
C=======================================================================
C
          IF (MPAHFB.GE.1) THEN
C
              IF (NUMITE.GT.ITESTA.OR.(IFCONT.NE.1.AND.IF_THO.EQ.0))
     *        THEN
C
                  DO LTWCEN=1,NBLDEN
C
                     INNERI=IND2HL(LTWCEN)
                     INNERJ=IND2HR(LTWCEN)
C
C=======================================================================
C        TWO-CENTRE BASIS OPTION: THE FIXED DELTA CASE DOESN'T REQUIRE
C        INNER LOOPS AND INDCOE IS IGNORED WITHIN INTEGD.
C=======================================================================
C
                                                      ITWCE2=     1
                     IF (IDEFIN.EQ.0.AND.ITWCEN.EQ.2) ITWCE2=ITWCEN
C
                     DO INNERK=1,ITWCE2
                        DO INNERL=1,ITWCE2
C
                           INDCOE=INTWHE(INNERI,INNERJ,INNERK,INNERL)
C
                           CALL INTEGD(ITPNMX,ISIMPY,ICHARG,
     *                          DELFIN,DELFIP,IDEFIN,IDEFIP,
     *                                        JETACM,KETA_R,
     *                          IGOGPA,IREGPA,ISEPPA,ICOUPA,
     *                                        NEWGOG,NEWCOU,
     *                                 LTWCEN,ITWCEN,INDCOE)
                        END DO
                     END DO
C
C=======================================================================
C            ATTENTION: BETWEEN VERSIONS (2.78A) AND (2.83Q) THE CALL TO
C                       "MIXPAI"  BELOW  WAS  IN  THE  FIRST   ITERATION
C                       PERFORMED FOR UNDEFINED ARRAYS FIPIDE AND FIP2DE
C                       UNLESS A RESTART  FROM  FIELDS  WAS  IN  EFFECT.
C                       MOREOVER, IN THE CALL TO "MIXPAI", THE  NAME  OF
C                       VARIABLE "SLOWAL"  WAS  MISSPELLED.  THESE  BUGS
C                       WERE CORRECTED ON 23/11/2017 IN VERSION (2.83R).
C                       THE SAME COMMENT APPLIES TO THREE OTHER CALLS TO
C                       "MIXPAI" BELOW.
C=======================================================================
C
                     IF (NUMITE.GT.ITESTA.OR.
     *                  (IFCONT.EQ.1.OR.IF_THO.EQ.1)) THEN
C
                          IF (I_SLOW.EQ.1) CALL MIXPAI(ICHARG,REA2PP,
     *                                          SLOWAL,ITWCEN,LTWCEN)
C
                     END IF
C
                     IF (ITWCEN.EQ.2) THEN
C
                         CALL TWDECO(ICHARG,LTWCEN)
C
                         IF (I_SLOW.EQ.1)
     *                   CALL TWC_SAVFIL(1,ICHARG,LTWCEN)
C
                     END IF
C
                  END DO
C
              ELSE
C
                  CALL GETPAI(ICHARG,REA2PP)
C
              END IF
C
              IF (IMFHFB.EQ.1) THEN
C
                  SPMODL='HFB MEAN FIELD'
              ELSE
                  SPMODL='CANONICAL     '
C
              END IF
C
          END IF
C
      ELSE
C
C=======================================================================
C        INITIALIZING THE MATRIX ELEMENTS OF THE NEUTRON MEAN FIELD
C=======================================================================
C        TWO-CENTRE BASIS OPTION: THE INITIAL WAVE FUNCTIONS ARE GIVEN
C        BY THE DIAGONALISATION OF THE NILSON HAMILTONIAN WHICH IS
C        BUILT ONLY FOR DIAGONAL TERMS.
C=======================================================================
C
          IF (IREAWS.EQ.1) THEN
C
              CALL WSHAMI(ITILAX,ITISAX,NO_ORB,ICHARG,ISIMPY)
C
              SPMODL='WOODS-SAXON   '
C
          ELSE
C
              DO LTWCEN=1,ITWCEN
C
                 CALL NILSON(ITILAX,ITISAX,NO_ORB,INNUMB,IZNUMB,
     *                              ICHARG,NAMEPN,HOMEGA,ISIMPY,
     *                                            ITWCEN,LTWCEN)
                 SPMODL='NILSSON       '
C
                 IF (ITWCEN.EQ.2) THEN
C
                     CALL TWCCOP(ICHARG,LTWCEN)
                     IF (I_SLOW.EQ.1) CALL TWC_SAVFIL(0,ICHARG,LTWCEN)
C
                 END IF
C
              END DO
C
          END IF
C
C=======================================================================
C        INITIALIZING THE MATRIX ELEMENTS OF THE NEUTRON PAIRING FIELD
C=======================================================================
C
          IF (MPAHFB.GE.1) THEN
C
              CALL INIPAI(ITPNMX,IPNMIX,ITWCEN,LDTWCE)
C
              IF (JETACM.EQ.2) CALL ZERLIN(ISIMPY,MPAIRI)
              IF (KETA_R.EQ.2) CALL ZERROT(ISIMPY,MPAIRI)
C
              DO LTWCEN=1,ITWCEN
C
                 INNERI=IND2HL(LTWCEN)
                 INNERJ=IND2HR(LTWCEN)
C
                                                  ITWCE2=     1
                 IF (IDEFIN.EQ.0.AND.ITWCEN.EQ.2) ITWCE2=ITWCEN
C
                 DO INNERK=1,ITWCE2
                    DO INNERL=1,ITWCE2
C
                       INDCOE=INTWHE(INNERI,INNERJ,INNERK,INNERL)
C
                       CALL INTEGD(ITPNMX,ISIMPY,ICHARG,
     *                      DELFIN,DELFIP,IDEFIN,IDEFIP,
     *                                    JETACM,KETA_R,
     *                      IGOGPA,IREGPA,ISEPPA,ICOUPA,
     *                                    NEWGOG,NEWCOU,
     *                             LTWCEN,ITWCEN,INDCOE)
C
                    END DO
                 END DO
C
                 IF (ITWCEN.EQ.2) THEN
C
                     CALL TWDECO(ICHARG,LTWCEN)
                     IF (I_SLOW.EQ.1) CALL TWC_SAVFIL(1,ICHARG,LTWCEN)
C
                 END IF
C
              END DO
C
          END IF
C
      END IF
C
C=======================================================================
C        MIXING OF THE MATRIX ELEMENTS OF THE HFB MATRIX. USUAL LINEAR
C        MIXING IS HANDLED BY THE ROUTINE DOBROY_MATRIX(), THE BROYDEN
C        CORRECTION BEING SIMPLY NOT ADDED
C=======================================================================
C
      IF (MIXMAT.EQ.1) THEN
C
          IF (ITERUN.GT.1) THEN
C
              CALL HPH_IN(ISIMPY,MREVER,ICHARG)
              IF (MPAHFB.GE.1) CALL DEL_IN(MREVER,IROTAT,ICHARG)
C
C              Evolving the Broyden and affecting the ouput
C
              CALL DOBROY_MATRIX(ITERUN,NSWBRN,ITAK_N,
     *                           NOICAN,SLOWEV,ESTABN,
     *                           EFERMN,EFENIN,EFENOU,
     *                           EFER2N,EF2NIN,EF2NOU,
     *                           LIPKIN,NOFBRN,ICHARG,
     *                                         MPAHFB)
C
              CALL HPH_OU(ISIMPY,MREVER,ICHARG)
              CALL GETFIL(ISIMPY,ICHARG)
C
              IF (MPAHFB.GE.1) THEN
                  CALL DEL_OU(MREVER,IROTAT,ICHARG)
                  CALL GETPAI(ICHARG,REA2PP)
              END IF
C
          ELSE
              CALL SAVFIL(ISIMPY,MPAHFB,ICHARG,REA2PP)
          END IF
C
      END IF
C
C=======================================================================
C        SAVING  THE   N E U T R O N   MEAN FIELDS
C=======================================================================
C            ATTENTION: BETWEEN  VERSIONS  (2.78T)  AND   (2.80J),   FOR
C                       I_SLOW=1, THE CALLS TO SAVFIL BELOW AND  FURTHER
C                       DOWN, WERE NOT PERFORMED. AS A RESULT, THE  CODE
C                       WAS ITERATING WITH  OLD  FIELDS  NOT  STORED  IN
C                       FIL_PP & FIL_PM, AND DID NOT CONVERGE. THIS  BUG
C                       WAS CORRECTED ON 11/06/2017 IN VERSION  (2.80K).
C
C                       NOTE THAT IN VERSIONS FROM (2.78D)  TO  (2.78S),
C                       THE STORING WAS NOT PERFOREMD EITHER, BUT THERE,
C                       THE  OLD  FIELDS  FIL_PP & FIL_PM  WERE  UPDATED
C                       DIRECTLY IN "MIXFIL". ALTHOUGH, SUCH A  SOLUTION
C                       WAS  INCONSISITENT,  AND  IT  WAS  CORRECTED  IN
C                       VERSION (2.78T), BUT THIS CORRECTION  LED  TO  A
C                       PROBLEM OF FIL_PP & FIL_PM BEING NEVER UPDATED.
C=======================================================================
C
      IF ((IWRIFI.NE.-1.OR.I_SLOW.EQ.1).AND.MIXMAT.EQ.0.AND.ITWCEN.EQ.1)
     *    CALL SAVFIL(ISIMPY,MPAHFB,ICHARG,REA2PP)
C
C=======================================================================
C        DIAGONALIZING THE MATRIX OF THE NEUTRON   H F B   HAMILTONIAN
C=======================================================================
C
      IF (MPAHFB.GE.1) THEN
C
          IREMQB(:)=0
          INUMQB(:)=0
          JNUMQB(:)=0
C
          IF (ISIMPY.EQ.1) THEN
C
              IF (ISIGNY.EQ.1) THEN
C
                  CALL HFBSIG(EFERMN,ECUTOF,LIMQUA,LAMCUT,ICHARG,IMFHFB,
     *                               FERALN,IFERAN,PARNUN,IN_FIX,
     *                                             ITWOBA,IWRIQU,
     *                               INSIGN,IPSIGN,ISSIGN,IDSIGN,
     *                                             IFIBLN,ISABLN,
     *                               IREQPB,INUQPB,JNUQPB,IF_RPA)
C
                  IREMQB(1)=IREQPB
                  INUMQB(1)=INUQPB
                  JNUMQB(1)=JNUQPB
C
              ELSE
C
                  IF (IFERAN.EQ.1) STOP ' ALM METHD NOT IMPLEMENTED YET'
C
                  CALL HFBSIM(EFERMN,ECUTOF,LIMQUA,LAMCUT,ICHARG,IMFHFB,
     *                               FERALN,IFERAN,PARNUN,IN_FIX,
     *                                             ITWOBA,IWRIQU,
     *                                      INSIMN,IRSIMN,IDSIMN,
     *                                             IFIBLN,ISABLN,
     *                               IREQPB,INUQPB,JNUQPB,IF_RPA)
C
                  IREMQB(1)=IREQPB
                  INUMQB(1)=INUQPB
                  JNUMQB(1)=JNUQPB
C
              END IF
C
          ELSE
C
              IF (ISIQTY.EQ.1) THEN
C
                  IF (IFERAN.EQ.1) STOP ' ALM METHD NOT IMPLEMENTED YET'
C
                  CALL HFBSIQ(EFERMN,ECUTOF,LIMQUA,LAMCUT,ICHARG,IMFHFB,
     *                               FERALN,IFERAN,PARNUN,IN_FIX,
     *                                             ITWOBA,NUQEVE,
     *                                      INSIQN,IPSIQN,IDSIQN,
     *                                             IFIBLN,ISABLN,
     *                                      IREQPB,INUQPB,JNUQPB)
C
                  IREMQB(1)=IREQPB
                  INUMQB(1)=INUQPB
                  JNUMQB(1)=JNUQPB
C
              ELSE
C
                  IF (IFERAN.EQ.1) STOP ' ALM METHD NOT IMPLEMENTED YET'
C
                  IF (ITWCEN.EQ.1) THEN
C
                  CALL HFBSIZ(EFERMN,ECUTOF,LIMQUA,LAMCUT,ICHARG,IMFHFB,
     *                               FERALN,IFERAN,PARNUN,IN_FIX,
     *                                             ITWOBA,NUQEVE,
     *                                             INSIZN,IDSIZN,
     *                                             IFIBLN,ISABLN,
     *                               IREMQB,INUMQB,JNUMQB,ISAOCC)
C
                  ELSEIF (ITWCEN.EQ.2) THEN
C
                      CALL TWCSIZ_NATBAS(ICHARG,LDMEFI,MPAHFB,EFERMN,
     *                                   ECUTOF,LAMCUT,INSIZN,IDSIZN,
     *                                   IFIBLN,ISABLN,IREMQB,INUMQB,
     *                                                        JNUMQB)
C
                  END IF
C
              END IF
C
          END IF
C
#if(USE_MPI==1)
          IF (escapeSignal.Eq.1) THEN
C
              WRITE(6,'(''Process '',i6,
     *                  '' - HFBSIM failed for neutrons. '',
     *                  ''Closing all files and exiting...'')')
     *                    WorldRank
C
              ! Properly close all files that could have been left
              ! opened (with the exclusion of the output unit NFIPRI)
              CALL IOCLOS(NFIWOO,NFIREP,NFIREV,NFIREC,NFICOU,NFIWAV,
     *                    NFIKER,NFIYUP,NFIYUC,NFIGOC,NFIGOP,NFIGPC,
     *                    NFIGPP,NFIROP,NFIROC,NFILIP,NFILIC,NFIFIP,
     *                    NFIFIC,NFIISO,NFIQUA,NFIRED,NFIBAC,NFIBAP)
C
              EXIT procLoop
C
          END IF
#endif
C
          EFENIN=EFERMN
C
          CALL QUABCS(EFERMN,IN_FIX,FERFIN,IFEFIN,ICHARG,
     *                       IDSIGN,IDSIMN,IDSIQN,IDSIZN,
     *                              IPRGCM,NUQEVE,ITWOBA,
     *                              FERALN,IFERAN,PARNUN,
     *                              IREMQB,INUMQB,JNUMQB,
     *                                     ISIMPY,ISIQTY)
C
#if(USE_MPI==1)
          IF (escapeSignal.Eq.1) THEN
C
              WRITE(6,'(''Process '',i6,
     *                  '' - QUABCS failed for neutrons. '',
     *                  ''Closing all files and exiting...'')')
     *                    WorldRank
C
              ! Properly close all files that could have been left
              ! opened (with the exclusion of the output unit NFIPRI)
              CALL IOCLOS(NFIWOO,NFIREP,NFIREV,NFIREC,NFICOU,NFIWAV,
     *                    NFIKER,NFIYUP,NFIYUC,NFIGOC,NFIGOP,NFIGPC,
     *                    NFIGPP,NFIROP,NFIROC,NFILIP,NFILIC,NFIFIP,
     *                    NFIFIC,NFIISO,NFIQUA,NFIRED,NFIBAC,NFIBAP)
C
              EXIT procLoop
C
          END IF
#endif
C
          EFENOU=EFERMN
C
          IF (PRINIT) THEN
C
              IF (IQUNIL.GE.1) CALL NILAQP(NOSCIL,MREVER,ICHARG,
     *                                            ISIMPY,NILXYZ)
C
              CALL SPTQUA(EMAXQU,ICHARG,NAMEPN,NILXYZ,
     *                    IQUNIL,ISIGNY,ISIMPY,ISIQTY,
     *                    IDSIGN,IDSIMN,IDSIQN,IDSIZN,
     *                           IREMQB,INUMQB,JNUMQB)
C
          END IF
C
      END IF
C
C=======================================================================
C        DIAGONALIZING THE MATRIX OF THE   N E U T R O N   MEAN FIELD
C=======================================================================
C
      DISLIN=0.0D0
C
      IF (MPAHFB.GE.1) THEN
C
          IF (ITWCEN.EQ.1) THEN
C
              IF (ISIMPY.EQ.1) THEN
C
                  CALL CANQUA(MREVER,ICHARG,IMFHFB,IREQPB,
     *                        LIPNON,PARLIN,DISLIN,ESUM_N)
              ELSE
                  CALL CANQUZ(ICHARG,IMFHFB,LIPNON,PARLIN,DISLIN,ESUM_N)
C
              END IF
C
          END IF
C
      ELSE
C
          LIMPAR=0
          IF (ISIMPY.EQ.1) THEN
C
              IF (ISIGNY.EQ.1) THEN
C
                  CALL DIASIG(MREVER,ICHARG,LIMPAR,ECUTOF)
C
              ELSE
C
                  CALL DIASIM(MREVER,ICHARG,LIMPAR,ECUTOF)
C
              END IF
C
          ELSE
C
              IF (ISIQTY.EQ.1) THEN
C
                  CALL DIASIQ(ICHARG,LIMPAR,ECUTOF)
C
              ELSE
C
                  IF (ITWCEN.EQ.1) THEN
C
                      CALL DIASIZ(ICHARG,LIMPAR,ECUTOF,LDMEFI,ISAOCC)
C
                  ELSEIF(ITWCEN.EQ.2) THEN
C
                      CALL TWCSIZ_NATBAS(ICHARG,LDMEFI,MPAHFB,EFERMN,
     *                                   ECUTOF,LAMCUT,INSIZN,IDSIZN,
     *                                   IFIBLN,ISABLN,IREMQB,INUMQB,
     *                                                        JNUMQB)
C
                  END IF
C
              END IF
C
          END IF
C
      END IF
C
C=======================================================================
C        CALCULATING VARIOUS SINGLE-PARTICLE AVERAGES FOR NEUTRONS
C=======================================================================
C=======================================================================
C        THESE CALLS TO SUBROUTINES CALCULATING VARIOUS SINGLE-PARTICLE
C        AVERAGES ARE PERFORMED ONLY WHEN IT IS  ABSOLUTELY  NECESSARY:
C                              1. FOR THE DIABATIC BLOCKING CALCULATION
C                              2. WHEN THE PING-PONG  HAS BEEN DETECTED
C                              3. WHEN THE DIVERGENCE HAS BEEN DETECTED
C                              4. IN THE LAST ITERATION (TERMNT=.TRUE.)
C                              5. TO PRINT THE RESULTS  (PRINIT=.TRUE.)
C=======================================================================
C
      IF (ITWCEN.EQ.1) THEN
C
          IF((ISIMPY.EQ.1.AND.IFLIPI.NE.0.AND.ICHFLI.EQ.ICHARG)     .OR.
     *
     *   (ISIMPY.EQ.1.AND.ISIGNY.EQ.1.AND.(NOFLIG(0,0,ICHARG).NE.0  .OR.
     *                                     NOFLIG(0,1,ICHARG).NE.0  .OR.
     *                                     NOFLIG(1,0,ICHARG).NE.0  .OR.
     *                                     NOFLIG(1,1,ICHARG).NE.0)).OR.
     *
     *   (ISIMPY.EQ.1.AND.ISIGNY.NE.1.AND.(NOFLIM(  0,ICHARG).NE.0  .OR.
     *                                     NOFLIM(  1,ICHARG).NE.0)).OR.
     *
     *   (ISIMPY.NE.1.AND.ISIQTY.EQ.1.AND.(NOFLIQ(  0,ICHARG).NE.0  .OR.
     *                                     NOFLIQ(  1,ICHARG).NE.0)).OR.
     *
     *   (ISIMPY.NE.1.AND.ISIQTY.NE.1.AND.(NOFLIZ(    ICHARG).NE.0)).OR.
     *
     *    IS_CON.EQ.1                                               .OR.
     *
     *    IS_PIN.EQ.1                                               .OR.
     *
     *    IS_CHA.EQ.1                                               .OR.
     *
     *    TERMNT                                                    .OR.
     *
     *    PRINIT)                                                   THEN
C
          CALL AVOBSE(MREVER,ICHARG,IPNMIX,NRAORD)
C
          END IF
C
      END IF
C
      CALL AVANGY(MREVER,ICHARG,IPNMIX,ISIMPY,ITWCEN)
C
C=======================================================================
C        CALCULATING SINGLE-PARTICLE AVERAGES FOR NEUTRONS
C=======================================================================
C
      IF (ITWCEN.EQ.1) THEN
C
          CALL AVPARI(MREVER,ICHARG,IPNMIX)
C
          IF (TERMNT.OR.PRINIT) THEN
C
              CALL AVSIMP(MREVER,ICHARG,IPNMIX)
C
              CALL NILASP(NOSCIL,MREVER,ICHARG,ISIMPY,NILXYZ)
C
          END IF
C
      END IF
C
C=======================================================================
C        CALCULATING THE NEUTRON PAIRING AND DEFINING OCCUPATION FACTORS
C=======================================================================
C
      EPAI_N=0.0
      EREA_N=0.0
      ELIP_N=0.0
C
      IF (MPAIRI.EQ.1) THEN
C
          IF (MPABCS.GT.0) THEN
C
              IF (MPABCS.EQ.1.OR.
     *           (MPABCS.EQ.3.AND.ITERUN.EQ.1))  THEN
C
                  IF (IAVRGG.NE.1) THEN
C
                      CALL SETPAI(IN_FIX,IZ_FIX,FACTGN,ICHARG,GPAIRN)
C
                  ELSE
C
                      CALL GAVRAG(IN_FIX,IZ_FIX,FACTGN,ICHARG,GPAIRN)
C
                  END IF
C
              END IF
C
              EFENIN=EFERMN
              CALL DELPAI (ICHARG,MREVER,MPABCS,IN_FIX,ITERUN,
     *                     DELFIN,GPAIRN,EPAI_N,EFERMN,DELTAN)
              EFENOU=EFERMN
C
              IF (PRINIT)
     *
     *            CALL PAIPRI(NAMEPN,GPAIRN,EPAI_N,EFERMN,DELTAN,
     *                                      LIPKIN,EFER2N,ELIP_N,
     *                                      MPAHFB,MPABCS,IAVRGG,
     *                               IGOGPA,IREGPA,ISEPPA,ICOUPA)
C
          END IF
C
      ELSE
C
          IF (ISIMPY.EQ.1) THEN
C
              IF (ISIGNY.EQ.1) THEN
C
                  CALL CONSIG(MREVER,ICHARG,IN_FIX,EFERMN,
     *                               ICHFLI,IPAFLI,IREFLI,
     *                               ISPFLI,ISHFLI,IFLIPI)
              ELSE
C
                  CALL CONSIM(MREVER,ICHARG,IN_FIX,EFERMN,
     *                               ICHFLI,       IREFLI,
     *                               ISPFLI,ISHFLI,IFLIPI)
C
              END IF
C
          ELSE
C
              IF (ISIQTY.EQ.1) THEN
C
                  CALL CONSIQ(ICHARG,IN_FIX,EFERMN,
     *                        ICHFLI,IPAFLI,
     *                        INSIQN,IPSIQN,IDSIQN,
     *                               IFIBLN,ISABLN,
     *                        ISPFLI,ISHFLI,IFLIPI,
     *                               NLSIQN,MXALIN)
              ELSE
C
                  CALL CONSIZ(ICHARG,IN_FIX,EFERMN,
     *                        ICHFLI,INSIZN,IDSIZN,
     *                               IFIBLN,ISABLN,
     *                        ISPFLI,ISHFLI,IFLIPI,
     *                               NLSIZN,MXALIN,
     *                                      ISAOCC,
     *                                      ITWCEN)
C
              END IF
C
          END IF
C
          DELTAN=0.0D0
C
      END IF
C
C=======================================================================
C       PRINTING SINGLE-PARTICLE SPECTRA FOR NEUTRONS
C=======================================================================
C
      IF (PRINIT) THEN
C
          CALL SPTALL(EMINAL,EMAXAL,SPMODL,NAMEPN,
     *                ISIGNY,ISIMPY,ISIQTY,MPAHFB,
     *                       MREVER,ICHARG,NILXYZ,
     *                IDSIGN,IDSIMN,IDSIQN,IDSIZN,NRAORD,
     *                                            ITWCEN)
C
      END IF
C
C=======================================================================
C        CALCULATING THE SUM OF NEUTRON SINGLE-PARTICLE ENERGIES
C=======================================================================
C
      IF (MPAHFB.LT.1)
     *
     *    CALL SPENSU(MREVER,ESUM_N,ICHARG,ISIMPY,ITWCEN)
C
C=======================================================================
C        CALCULATING THE SUM OF NEUTRON QUASIPARTICLE ENERGIES
C=======================================================================
C
      IF (MPAHFB.GE.1.AND.IQPSTA.EQ.1)
     *
     *    CALL QPENSU(MREVER,ESUM_N,EFERMN,ICHARG)
C
C=======================================================================
C        ZEROING THE NEUTRON DENSITIES
C=======================================================================
C
      CALL ZEDENS(ITPNMX)
C
C=======================================================================
C        CALCULATING THE NEUTRON DENSITIES AND CURRENTS
C=======================================================================
C        TWO-CENTRE BASIS OPTION: FOR INTEGRATING THE HAMILTONIAN MATRIX
C        ELEMENTS AND THE ENERGY OF THE FUNCTIONAL WE DEAL WITH THE PRO-
C        DUCT OF FOUR WAVE FUNCTIONS. TO PROPERLY USE GAUSS-HERMITE QUA-
C        TURE, DENSITIES MUST BE EVALUATED IN SIXTEEN DIFFERENT SETS OF
C        POINTS WHICH INVOLVE THE CENTRE PARAMETERS (FREQUENCIES OF THE
C        BASIS AND POSITION OF THE CENTRES) OF ALL FOUR WAVE FUNCTIONS.
C        THEN, THE DENSITIES DE_() WILL DEPEND NOT ONLY IN KL (SEE
C        COMMENTS BEFORE INTEGH) BUT ALSO IN IJ.
C
C        TO USE THE PROPER COEFFICIENTS (WARIGH) RELATED TO ONE CENTRE
C        OR THE OTHER, WE CALL DENSHF AS FOLLOWS
C            1. LTWCEN=1 COMPUTES DENSITIES FOR I=J=K=L=1. WARIGH
C               OF THE FIRST CENTRE IS STORED IN SARIGH(:,:,:,:,1).
C            2. LTWCEN=16 (VALUE OF NDTWHE) COMPUTES DENSITIES FOR
C               I=J=K=L=2. WARIGH OF THE SECOND CENTRE IS STORED IN
C               SARIGH(:,:,:,:,2).
C            3. LTWCEN= 2 -> 15 WILL USE FIRST OR SECOND CENTRE COEFFI-
C               CIENTS IN FUNCTION OF THE INDEXES KL. E.G.:
C               K=1,L=2 --> WALEFT: SARIGH(...,1), WARIGH: SARIGH(...,2)
C
C        ATTENTION: THE NEXT PROCEDURE IS NOT IMPLEMENTED YET.
C        COMMENT ON ACCELERATION OF THIS PART: ONLY NINE OF THE SIXTEEN
C        DENSITIES ARE DIFFERENT.THIS IS DUE TO:
C            1. SWAPPING INDEXES I AND J DOESN'T CHANGE NEITHER THE
C            WARIGH COEFFIENTS (ONLY RELATED TO K AND L) NOR THE TOTAL
C            GAUSSIAN FUNCTION (WHICH DETERMINES THE POINTS WHERE
C            DENSITIES ARE EVALUATED).
C            2. SWAPPING INDEXES K AND L INTERCHANGES WARIGH AND WALEFT
C            BUT MAINTAIN THE SAME TOTAL GAUSSIAN FUNCTION, SO IT WILL
C            PRODUCE THE CONJUGATE OF THE ORIGINAL DENSITY.
C
C        THEN, WE CALL DENSHF FOR NINE SPECIFIC VALUES OF LTWCEN AND
C        THE REST OF DENSITIES (OR THEIR CONJUGATES) ARE COPIED USING
C        TWC_MORDEN.
C=======================================================================
C
      IF (ITWCEN.EQ.2) THEN
C
          ISAWAV=1
          IKERNE=0
C
      END IF
C
C=======================================================================
C     CALLING DENSHF FOR I=J=K=L=1 (SAME AS IN ONE-CENTRE OPTION)
C=======================================================================
C
      CALL DENSHF(ISIMTX,JSIMTY,ISIMTZ,
     *            ISIGNY,ISIMPY,ISIQTY,MPAHFB,MREVER,ICHARG,
     *                                 MIN_QP,IPNMIX,ITPNMX,
     *                   ITIREP,NAMEPN,PRINIT,IDEVAR,ITERUN,
     *            ISYMDE,INIROT,INIINV,INIKAR,ISAWAV,IKERNE,
     *                                             ITWCEN,1)
C
      IF (ITWCEN.EQ.2) THEN
C
C=======================================================================
C     CALLING DENSHF FOR I=J=K=L=2
C=======================================================================
C
          CALL DENSHF(ISIMTX,JSIMTY,ISIMTZ,
     *            ISIGNY,ISIMPY,ISIQTY,MPAHFB,MREVER,ICHARG,
     *                                 MIN_QP,IPNMIX,ITPNMX,
     *                   ITIREP,NAMEPN,PRINIT,IDEVAR,ITERUN,
     *            ISYMDE,INIROT,INIINV,INIKAR,ISAWAV,IKERNE,
     *                                        ITWCEN,NDTWHE)
C
          IKERNE=1
          ISAWAV=0
C
          IALLOC=0
C
          IF (.NOT.ALLOCATED(WALEFT)) THEN
          ALLOCATE (WALEFT(1:NDBASE,1:4*NDSTAT,0:NDSPIN),
     *                                                   STAT=IALLOC)
          IF (IALLOC.NE.0) CALL NOALLO('WALEFT','HFODD ')
          END IF
C
          IF (ITWCEN.GT.NDTWCE) STOP ' ITWCEN.GT.NDTWCE IN HFODD'
C
          DO LTWCEN=1,LDTWDD
C
             IF (LTWCEN.EQ.1.OR.LTWCEN.EQ.16) CYCLE
C
C=======================================================================
C     CONDITION TO AVOID CALLING DENSHF UNNECCESARY TIMES
C=======================================================================
C
             IF (IDCOPY(LTWCEN,IPAIRI).EQ.0) THEN
C
C=======================================================================
C     SELECTING THE COEFFICIENTS FOR THE REST OF DENSITIES
C=======================================================================
C
                 WALEFT(:,:,:)=SARIGH(:,:,:,ICHARG,IND4HK(LTWCEN))
                 WARIGH(:,:,:)=SARIGH(:,:,:,ICHARG,IND4HL(LTWCEN))
C
C=======================================================================
C     CALLING DENSHF FOR THE REST OF THE CASES
C=======================================================================
C
                 CALL DENSHF(ISIMTX,JSIMTY,ISIMTZ,
     *            ISIGNY,ISIMPY,ISIQTY,MPAHFB,MREVER,ICHARG,
     *                                 MIN_QP,IPNMIX,ITPNMX,
     *                   ITIREP,NAMEPN,PRINIT,IDEVAR,ITERUN,
     *            ISYMDE,INIROT,INIINV,INIKAR,ISAWAV,IKERNE,
     *                                        ITWCEN,LTWCEN)
C
            ELSEIF (IDCOPY(LTWCEN,IPAIRI).NE.0) THEN
C
                 CALL TWC_MORDEN(LTWCEN,ITPNMX,IGRAIN,IPAIRI)
C
             END IF
C
          END DO
C
      END IF
C
C=======================================================================
C        DOUBLING THE SINGLE-PARTICLE RESULTS IN CASE OF NO ROTATION
C=======================================================================
C
      IF (MREVER.EQ.0) THEN
C
          CALL DBLING(ITPNMX)
C
          ESUM_N=2*ESUM_N
C
      END IF
C
C@@@ HFBTHO -HFBTHO - HFBTHO - HFBTHO - HFBTHO - HFBTHO - HFBTHO
C=======================================================================
C        BY DEFAULT,  HFODD  INITIALIZES THE  MATRIX OF THE  MEAN-FIELD
C        BY  COMPUTING THE  MATRIX ELEMENTS  OF THE  NILSON  POTENTIAL.
C        IN  HFB  MODE IT  INITIALIZES  THE MATRIX OF THE PAIRING FIELD
C        BY COMPUTING THE MATRIX ELEMENTS OF THE  DELTA-PAIRING  INTER-
C        ACTION, WHICH DEPENDS ON THE ISO-SCALAR DENSITY, AND THEREFORE
C        ON BOTH PROTON AND NEUTRON DENSITIES ON THE GAUSS-HERMITE MESH.
C        WHEN RESTARTING FROM HFBTHO, THESE DENSITIES ARE NOT AVAILABLE:
C        THE COMPUTATION OF  ALL  PAIRING OBSERVABLES MUST THEREFORE BE
C        SHIFTED TO  AFTER  THE NEW ISOSCALAR DENSITY HAS BEEN COMPUTED.
C        THIS ONLY AFFECTS THE  FIRST ITERATION, SEE ALSO COMMENT ABOUT
C        NUMITE BELOW.
C=======================================================================
C
      IF (IF_THO.EQ.0.OR.ITERUN.NE.1) THEN
C
C=======================================================================
C        CALCULATING THE NEUTRON HFB PAIRING ENERGY AND AVERAGE DELTA
C=======================================================================
C
          IF (MPAHFB.GE.1)
     *
     *        CALL EPAIRI(IN_FIX,IZ_FIX,ITPNMX,EKEPAI,LDTWCE)
C
C=======================================================================
C        CALCULATING THE NEUTRON LIPKIN-NOGAMI CORRECTION
C=======================================================================
C        WHEN STARTING FROM SCRATCH, THE CODE INITALIZES THE PH AND PP
C        CHANNELS  AT  NUMITE = 0. WHEN  RESTARTING FROM  HFBTHO, THIS
C        INITIALIZATION  MUST BE  SKIPPED,  WHICH IS  DONE BY  SETTING
C        NUMITE = 1. HOWEVER, TO  ENSURE  A  SMOOTH  RESTART OF THE LN
C        LAMBDA_2 PARAMETER,  ONE MUST DO 'AS IF' WE WERE AT THE FIRST
C        ITERATION, HENCE THE TRICK BELOW.
C=======================================================================
C
                           NACTIT=NUMITE
          IF (IF_THO.GE.1) NACTIT=NUMITE-2
C
          IF (LIPKIN.EQ.1) THEN
              EF2NIN=EFER2N
              CALL LIPCOR(GPAIRN,FACTGN,FE2FIN,IF2FIN,I_SLOW,SLOWLI,
     *                                         EFER2N,NACTIT,ICHARG)
              EF2NOU=EFER2N
C
              ELIP_N=-2*EFER2N*DISLIN
C
          END IF
C
C=======================================================================
C        CALCULATING THE NEUTRON PAIRING MATRIX ELEMENTS
C=======================================================================
C
          IF (IDEVAR.EQ.1)
     *
     *        CALL GINTER(ICHARG,MREVER,PRHO_N,PRHODN,POWERN)
C
C=======================================================================
C        PRINTING THE PAIRING RESULTS
C=======================================================================
C
          IF (PRINIT.AND.MPAHFB.GE.1)
     *
     *        CALL PAIPRI(NAMEPN,GPAIRN,EPAI_N,EFERMN,DELTAN,
     *                                  LIPKIN,EFER2N,ELIP_N,
     *                                  MPAHFB,MPABCS,IAVRGG,
     *                           IGOGPA,IREGPA,ISEPPA,ICOUPA)
C
      END IF
C
C@@@ HFBTHO -HFBTHO - HFBTHO - HFBTHO - HFBTHO - HFBTHO - HFBTHO
C=======================================================================
C        CALCULATING THE   N E U T R O N   D E N S I T Y   M A T R I X
C=======================================================================
C        TWO-CENTRE BASIS OPTION:    THREE DIFFERENT BLOCKS ARE COMPUTED
C        IN THE SAME WAY AS THE HAMILTONIAN.   TO OBTAIN THE BIG DENSITY
C        MATRIX (SEE COMMENTS BEFORE INTEGH) TWC_BIGDEN IS USED.
C        ATTENTION: WALEFT IS REFERRED TO THE KET AND WARIGH TO THE BRA.
C=======================================================================

      IF (ITWCEN.EQ.1) THEN
C
          CALL DENMAC(MREVER,ICHARG,ISIMPY,MPAHFB,WARIGH,WARIGH,1)
C
      ELSEIF (ITWCEN.EQ.2) THEN
C
          DO LTWCEN=1,NDTWBL
C
             WARIGH(:,:,:)=SARIGH(:,:,:,ICHARG,IND2HL(LTWCEN))
             WALEFT(:,:,:)=SARIGH(:,:,:,ICHARG,IND2HR(LTWCEN))
C
             CALL DENMAC(MREVER,ICHARG,ISIMPY,MPAHFB,WALEFT,WARIGH,
     *                                                      LTWCEN)
C
             CALL TWCCOP(ICHARG,LTWCEN)
C
          END DO
C
          CALL TWC_BIGDEN(ICHARG)
C
      END IF
C
      IF (ITWCEN.EQ.2.AND.IQPSTA.EQ.0.AND.MPAHFB.EQ.1)
     *  CALL TWC_CANQUZ(ESUM_N)
C
C=======================================================================
C        CALCULATING THE   N E U T R O N   P A I R I N G   T E N S O R
C=======================================================================
C
      IF (MPAHFB.EQ.1.AND.((COR_CM.OR.CORROT).OR.
     *    ICOUPA.GE.1.OR.MAXVAL(IFSTPA).GE.1.OR.
     *    IFRAGM.EQ.1.OR.
C    *    KETAJ2.EQ.1.OR.KETAT2.EQ.1.OR.
     *    IGOGPA.GE.1.OR.IREGPA.GE.1.OR.ISEPPA.GE.1))
     *
     *    CALL PAIMAC(ICHARG,ISIMPY,WARIGH,WARIGH,IKERNE)
C
C=======================================================================
C        ADDING THE NEUTRON DENSITY MATRIX TO THE BROYDEN VECTOR
C=======================================================================
C@@@ HFBTHO -HFBTHO - HFBTHO - HFBTHO - HFBTHO - HFBTHO - HFBTHO
                       NACTIT=NUMITE
      IF (IF_THO.GE.1) NACTIT=NUMITE-2
C@@@ HFBTHO -HFBTHO - HFBTHO - HFBTHO - HFBTHO - HFBTHO - HFBTHO
C
      IF (LIPKIN.EQ.1.AND.IBROYD.GE.1.AND.MIXMAT.EQ.0)
     *    CALL LIP_IN(ISIMPY,ICHARG,LIPKIN,LIPKIP,EF2NIN,EF2NOU,
     *                                                   NACTIT)
C
C=======================================================================
C        SLOWING DOWN AND SAVING THE NEUTRON DENSITY MATRIX FOR
C        LIPKIN-NOGAMI
C=======================================================================
C            ATTENTION: BETWEEN  VERSIONS  (2.38G)  AND   (2.78B),   THE
C                       LIPKIN-NOGAMI CALCULATIONS WERE  PERFORMED  WITH
C                       DENSITY  MATRIX  SLOWED  DOWN   WITH   PARAMETER
C                       "SLOWLI". THIS FACT  CONTRADICTED  THE  INTENDED
C                       USE OF "SLOWLI", AS SPECIFIED IN SECTION 3.3  OF
C                       CPC 180-2361, WHERE IT WAS MEANT  TO  SLOW  DOWN
C                       THE LIPKIN-NOGAMI PARAMETERS ONLY. THIS BUG  WAS
C                       CORRECTED ON 12/10/2016 IN VERSIONS (2.73Y)  AND
C                       (2.78C) BY ADDING A DEDICATED PARAMETER "SLOWLD"
C                       WHICH IS USED TO SLOW DOWN  THE  DENSITY  MATRIX
C                       FOR USE IN THE LIPKIN-NOGAMI METHOD.
C=======================================================================
C         ATTENTION: BETWEEN VERSIONS (2.97J) AND (3.07B), THE CONDITION
C                    TO CALL  "SAVLIP"  DID  NOT  INCLUDE  THE  TEST  OF
C                    "MPAHFB".  AS  A  RESULT,  AFTER  IMPLEMENTING  THE
C                    DYNAMIC DOWNGRADE OF HFB TO HF, "SAVLIP"  COULD  BE
C                    CALLED IN AN HF RUN, WHICH WAS CAUSING THE CODE  TO
C                    CRASH  ON  THE  SEGMENTATION  FAULT. THIS  BUG  WAS
C                    CORRECTED ON 25/09/2021 IN VERSIONS (3.07C).
C=======================================================================
C
      IF (MPAHFB.EQ.1.AND.LIPKIN.EQ.1) THEN
                           MIXDEN=0
          IF (IBROYD.LT.1) MIXDEN=1
C
          CALL SAVLIP(ISIMPY,ICHARG,SLOWLD,MIXDEN)
C
      END IF
C
C=======================================================================
C        SLOWING DOWN THE NEUTRON DENSITY MATRIX  AND  PAIRING
C        TENSOR FOR THE LIPKIN METHOD
C        ATTENTION: IF THE LIPKIN METHOD IS USED TOGETHER WITH
C                   FINITE-RANGE FORCES, COULOMB, OR  TWO-BODY
C                   CENTER-OF-MASS CORRECTION, CALLS TO SAVDEN
C                   AND SAVPAI, WHICH ARE EXECUTED LATER, WILL
C                   O V E R W R I T E  THE SLOWED-DOWN DENSITY
C                   MARIX AND PAIRING TENSOR THAT ARE  WRITTEN
C                   BY SAVLPM BELOW.
C=======================================================================
C
      IF (IRENMA.GE.1.OR.IRENIN.GE.1) THEN
C
                           MIXDEN=0
          IF (NACTIT.GT.0) MIXDEN=1
C
          CALL SAVLPM(ICHARG,ISIMPY,MPAIRI,SLOWLM,MIXDEN)
C
      END IF
C
C=======================================================================
C        SAVING THE NEUTRON DENSITY MATRIX
C=======================================================================
C
      IF (I_YUKA.GE.1.OR.I_GOGA.GE.1.OR.I_REGA.GE.1.OR.I_SEPA.GE.1.OR.
     *    I_COUA.GE.1.OR.MAXVAL(I_FSTA).GE.1.OR.MAXVAL(MAG2BC).GE.1.OR.
     *    ICOUDI.EQ.2.OR.ICOUEX.EQ.2.OR.
     *    COR_CM.OR.CORROT.OR.IFRAGM.EQ.1.OR.
     *    JETACM.GE.1.OR.KETA_R.GE.1)
     *
     *    CALL SAVDEN(ISIMPY,ICHARG)
C
C=======================================================================
C        SAVING THE NEUTRON PAIRING TENSOR
C=======================================================================
C
      IF (IGOGPA.GE.1.OR.IREGPA.GE.1.OR.ISEPPA.GE.1.OR.
     *    ICOUPA.GE.1.OR.MAXVAL(IFSTPA).GE.1.OR.
     *  ((COR_CM.OR.CORROT).AND.MPAHFB.GE.1))
     *
     *    CALL SAVPAI(ISIMPY,ICHARG)
C
C=======================================================================
C         CALCULATING   D I R E C T   YUKAWA ENERGIES FOR NEUTRONS
C=======================================================================
C
      IF (PRIYUK)
     *
     *    CALL YUKAWD(ISIMPY,ICHARG)
C
C=======================================================================
C        CALCULATING THE   N E U T R O N    K I N E T I C    E N E R G Y
C=======================================================================
C
      CALL EKINET(EKIN_N,DLINSN(0),EKEKIN,DKINSN(0),ITWCEN)
C
C=======================================================================
C        CALCULATING THE   N E U T R O N    POTENTIAL   HO   E N E R G Y
C=======================================================================
C
      EPOT_N =0.0D0
C
      IF (IPOTHO.EQ.1) THEN
        CALL EPOTHO(EPOT_N)
      END IF
C
C=======================================================================
C        CALCULATING THE   N E U T R O N    M U L T I P O L E    MOMENTS
C=======================================================================
C
      ISHIFY=0
C
      CALL MOMETS(ISIMPY,ISIGNY,ISIQTY,QMUL_N,QMUT_N,
     *                   COMULT,KMULMO,ISHIFY,ITWCEN)
      CALL MOMSIF(ISIMPY,ISIGNY,ISIQTY,SMUL_N,SMUT_N,
     *                                 COMULT,KMULSI)
      IF (ISCHIF.EQ.1)
     *CALL MOMSCH(SMUL_N,SMUT_N,KMULSI,QMUL_N,QMUT_N,KMULMO)
      CALL MOMVMU(ISIMPY,VMUL_N,COMULT,KMULSI)
      IF (IDOPLM.EQ.1)
     *CALL MOMPLM(ISIMPY,ISIGNY,ISIQTY,PMUL_N,COMULT,KMULSI)
C
      IF (PRINIT.AND.IPRI_N.EQ.1) THEN
C
          CALL MOMPRI(ISIMPY,NAMMUL,NAMHAR,NAMEPN,QMUL_N,KMULMO,'Q')
          IF (KMULSI.GT.0)
     *    CALL MOMPRI(ISIMPY,NAMSIF,NAMHAR,NAMEPN,SMUL_N,KMULSI,'S')
          IF (KMULSI.GT.0.AND.IDOPLM.EQ.1)
     *    CALL MOMPRI(ISIMPY,NAMPLM,NAMHAR,NAMEPN,PMUL_N,KMULSI,'P')
C
      END IF
C
C=======================================================================
C         IN THE CASE OF SINGLE-PARTICLE BLOCKING, THE BLOCKED STATE CAN
C         BE EITHER A PARTICLE OR A HOLE. THEREFORE, HERE WE TEST IF THE
C         REQUESTED AND OBTAINED PARTICLE NUMBERS AGREE.
C=======================================================================
C
      IF (MAXVAL(IDSIQN).EQ.2.OR.MAXVAL(IDSIZN).EQ.2) THEN
C
          IF (ABS(QMUL_N(0,0)-IN_FIX).GT.1.0D-06) THEN
C
              WRITE(NFIPRI,'(/,1X,20(1H/),
     *             '' INCONSISTENT NUMBERS OF NEUTRONS'',1X,20(1H/),/,
     *                         1X,20(1H/),
     *             '' Q00='',D17.10,'' IN_FIX='',I3,     1X,20(1H/),/)')
     *
     *             QMUL_N(0,0),IN_FIX
C
              STOP ' INCONSISTENT NUMBERS OF NEUTRONS IN MAIN'
C
          END IF
C
      END IF
C
C=======================================================================
C        CALCULATING THE    N E U T R O N     M A G N E T I C    MOMENTS
C=======================================================================
C
      CALL MAGMOM(ISIMPY,IROTAT,ICHARG,AMUL_N,AMUT_N,KMULMA,NMAORD)
C
      IF (PRINIT.AND.IPRI_N.EQ.1) THEN
C
          CALL MAGPRI(IROTAT,NAMMAG,NAMHAR,NAMEPN,AMUL_N,KMULMA,NMAORD,
     *                                                             'M')
C
      END IF
C
C=======================================================================
C        CALCULATING THE    N E U T R O N    S P I N - ASYMMETRY MOMENTS
C=======================================================================
C
      CALL ASMMOM(ISIMPY,IROTAT,WMUL_N,WMUT_N,KMULAS,NASORD)
C
      IF (PRINIT.AND.IPRI_N.EQ.1) THEN
C
          CALL MAGPRI(IROTAT,NAMASM,NAMHAR,NAMEPN,WMUL_N,KMULAS,NASORD,
     *                                                             'A')
C
      END IF
C
C=======================================================================
C        CALCULATING THE   N E U T R O N    R M S    R A D I I
C=======================================================================
C
      CALL RMSQUA(RADI_N,RMSRAN,IN_FIX,NRAORD,ITWCEN)
C
      IF (PRINIT.AND.IPRI_N.EQ.1)
     *
     *    CALL RADPRI(NAMEPN,RADI_N,RMSRAN,NRAORD)
C
C=======================================================================
C        CALCULATING THE   N E U T R O N    D E F O R M A T I O N S
C=======================================================================
C
      IF (PRIBET.AND.IPRI_N.EQ.1)
     *
     *    CALL BOHDEF(ISIMPY,NEXBET,IPRIBE,IPRIBL,NAMHAR,NAMEPN,
     *                              RADI_N,QMUL_N,BMUL_N,KMULMO)
C
C=======================================================================
C        CALCULATING THE   N E U T R O N   S P I N
C=======================================================================
C
      CALL SPIMOM(ISIMPY,IROTAT,ANGU_N,SPIN_N,ITWCEN)
C
C=======================================================================
C        CALCULATING THE   N E U T R O N   L I N E A R   M O M E N T A
C=======================================================================
C         ATTENTION! BETWEEN VERSIONS (2.78H) AND (3.22S), BUT  ALSO  IN
C                    THE PUBLISHED VERSION (2.73Y), SUBROUTINE ZDOTU  IN
C                    MODULES  "HFODD_LIPCORR_NN.F90"  WAS  CALLED   WITH
C                    INCORRECT ARGUMENTS AND THUS  COULD  WORK  PROPERLY
C                    ONLY FOR LDBASE=NDBASE. THIS  BUG  WAS  ERRATICALLY
C                    CAUSING SEGMENTATION FAULT FOR CALCULATIONS DONE IN
C                    SUBROUTINES  "LINAVR"  AND  "ROTAVR"  BELOW.  AFTER
C                    REMOVING ALL CALLS TO ZDOTU, THIS BUG WAS CORRECTED
C                    ON  06/02/2024  IN  VERSION  (3.22T),  WHICH   USES
C                    MODULE HFODD_LIPCORR_53.F90.
C=======================================================================
      IF (COR_CM)
     *
     *    CALL LINAVR(ISIMPY,ISIGNY,ISIQTY,
     *                MPAHFB,ICHARG,JETACM,IROTAT,MREVER,COR_CM,IKERNE,
     *                DLINSN,ELINSN,PLINSN,TLINSN,ALINLN,PLINLN,PLINKN,
     *                DKINSN,EKINSN,PKINSN,TKINSN,AKINLN,PKINLN,PKINKN)
C
C=======================================================================
C        CALCULATING THE   N E U T R O N   A N G U L A R   M O M E N T A
C=======================================================================
C
C     IF (CORROT.OR.KETAJ2.EQ.1)
      IF (CORROT)
     *
     *    CALL ROTAVR(ISIMPY,ISIGNY,ISIQTY,
     *                MPAHFB,ICHARG,KETA_R,IROTAT,MREVER,CORROT,IKERNE,
     *                DROTSN,EROTSN,PROTSN,TROTSN,AROTLN,PROTLN,PROTKN,
     *                DKOTSN,EKOTSN,PKOTSN,TKOTSN,AKOTLN,PKOTLN,PKOTKN)
C
C=======================================================================
C        CALCULATING PROPERTIES OF THE FRAGMENTS (TWO-CENTER BASIS)
C=======================================================================
C
      ENEFRN=0.0D0
      IF (ITWCEN.EQ.2) THEN
C
              CALL TWC_FRGENE(ICHARG,ITWCEN,ENEFRN)
              CALL TWC_FRGMOM(KMULMO,QFRA_N)
C
      END IF
C
C=======================================================================
C         CALCULATIONS FOR  MOMENTS OF INERTIA
C         AND MASS PARAMETERS (NEUTRON PART)
C=======================================================================
C
      if (TERMNT) then
C
          if (imominer.eq.1) then
                  call momsiner(icharg,ipahfb,jpabcs)
          endif
          if (imaspar.eq.1) then
                call maspar_v0(ipahfb,jpabcs,icharg,mrever)
          endif
C
      endif  ! TERMNT
C
C=======================================================================
C         HERE ENDS THE BLOCK FOR   N E U T R O N S
C=======================================================================
C
 8970 CONTINUE
C
C=======================================================================
C         FOR IZ_FIX=0 WE DO NOT PERFORM ANY CALCULATIONS FOR PROTONS
C=======================================================================
C
      IF (IZ_FIX.EQ.0) GO TO 8971
C
C=======================================================================
C         HERE STARTS THE BLOCK FOR  P R O T O N S
C=======================================================================
C
      NAMEPN=' PROTONS'
C
      ICHARG=1
      ITPNMX=1
C
C=======================================================================
C         SETTING THE SWITCHES THAT DOWNGRADE HFB TO HF IF NEEDED
C=======================================================================
C
      IF (IPA2HF(ICHARG).EQ.1.OR.
     *    IPA2HF(ICHARG).EQ.2.AND.ABS(DELTAP).LT.DEL2HF(ICHARG)) THEN
C
          IF (IPA2HF(ICHARG).EQ.2.AND.ABS(DELTAP).LT.DEL2HF(ICHARG).AND.
     *        IND2HF(ICHARG).NE.1) THEN
C
              WRITE(NFIPRI,'(                                 79(1H*),/,
     *              1H*,7X,'' FROM NOW ON, THE HFB MODE FOR  PROTONS'',
     *                     '' IS SWITCHED OVER TO HF '',      7X,1H* ,/,
     *                                                        79(1H*))')
              IND2HF(ICHARG)=1
C
          END IF
C
          MPAHFB=0
          MPABCS=0
          MPAIRI=0
      ELSE
          MPAHFB=IPAHFB
          MPABCS=JPABCS
          MPAIRI=IPAIRI
C
      END IF
C
      KPAHFB(ICHARG)=MPAHFB
C
C=======================================================================
C         CALCULATING THE MATRIX ELEMENTS OF THE PROTON MEAN FIELD
C=======================================================================
C         TWO-CENTRE BASIS OPTION: SEE COMMENTS IN NEUTRON BLOCK
C=======================================================================
C
      IF (NUMITE.GT.0) THEN
C
          IF (NUMITE.GT.ITESTA.OR.(IFCONT.NE.1.AND.IF_THO.EQ.0)) THEN
C
              DO LTWCEN=1,NBLDEN
C
                 INNERI=IND2HL(LTWCEN)
                 INNERJ=IND2HR(LTWCEN)
C
                 DO INNERK=1,ITWCEN
                    DO INNERL=1,ITWCEN
C
                       INDCOE=INTWHE(INNERI,INNERJ,INNERK,INNERL)

                       CALL INTEGH(IMOVAX,ITILAX,ITISAX,NO_ORB,
     *                      IPNMIX,ITPNMX,IROTAT,ICHARG,ISIMPY,
     *                             MPAHFB,IPOTHO,ISCHIF,IOCONT,
     *                                           NMUCON,NSICON,
     *                             I_YUKA,I_GOGA,I_REGA,I_SEPA,
     *                                    ITWOLI,JETACM,ALINLT,
     *                                           KETA_R,AROTLT,
     *                                           ICOUDI,ICOUEX,
     *                                           LIPKIN,LIPKIP,
     *                                           EFER2N,EFER2P,
     *                                                  IF_RPA,
     *                                           ILIPON,ILIPOP,
     *                                                  NEWGOG,
     *                                           LTWCEN,ITWCEN,
     *                                                  INDCOE)
C
                    END DO
                 END DO
C
                 IF (NUMITE.GT.ITESTA.OR.
     *              (IFCONT.EQ.1.OR.IF_THO.EQ.1)) THEN
C
                     IF (I_SLOW.EQ.1)
     *               CALL MIXFIL(ISIMPY,ICHARG,SLOWAL,ITWCEN,LTWCEN)
C
                 END IF
C
                 IF (ITWCEN.EQ.2) THEN
C
                     CALL TWCCOP(ICHARG,LTWCEN)
                     IF (I_SLOW.EQ.1) CALL TWC_SAVFIL(0,ICHARG,LTWCEN)
C
                 END IF
C
              END DO
C
          ELSE
C
              CALL GETFIL(ISIMPY,ICHARG)
C
          END IF
C
          SPMODL='HARTREE-FOCK  '
C
C=======================================================================
C        CALCULATING THE MATRIX ELEMENTS OF THE PROTON PAIRING FIELD
C=======================================================================
C
          IF (MPAHFB.GE.1) THEN
C
              IF (NUMITE.GT.ITESTA.OR.(IFCONT.NE.1.AND.IF_THO.EQ.0))
     *        THEN
C
                  DO LTWCEN=1,NBLDEN
C
                     INNERI=IND2HL(LTWCEN)
                     INNERJ=IND2HR(LTWCEN)
C
C=======================================================================
C        TWO-CENTRE BASIS OPTION: SEE COMMENT IN NEUTRON BLOCK.
C=======================================================================
C
                                                      ITWCE2=     1
                     IF (IDEFIN.EQ.0.AND.ITWCEN.EQ.2) ITWCE2=ITWCEN
C
                     DO INNERK=1,ITWCE2
                        DO INNERL=1,ITWCE2
C
                           INDCOE=INTWHE(INNERI,INNERJ,INNERK,INNERL)
C
                           CALL INTEGD(ITPNMX,ISIMPY,ICHARG,
     *                           DELFIN,DELFIP,IDEFIN,IDEFIP,
     *                                         JETACM,KETA_R,
     *                           IGOGPA,IREGPA,ISEPPA,ICOUPA,
     *                                         NEWGOG,NEWCOU,
     *                                  LTWCEN,ITWCEN,INDCOE)
C
                        END DO
                     END DO
C
                     IF (NUMITE.GT.ITESTA.OR.
     *                  (IFCONT.EQ.1.OR.IF_THO.EQ.1)) THEN
                         IF (I_SLOW.EQ.1) CALL MIXPAI(ICHARG,REA2PP,
     *                                         SLOWAL,ITWCEN,LTWCEN)
C
                     END IF
C
                     IF (ITWCEN.EQ.2) THEN
C
                         CALL TWDECO(ICHARG,LTWCEN)
                         IF (I_SLOW.EQ.1)
     *                   CALL TWC_SAVFIL(1,ICHARG,LTWCEN)
C
                     END IF
C
                  END DO
C
              ELSE
C
                  CALL GETPAI(ICHARG,REA2PP)
C
              END IF
C
              IF (IMFHFB.EQ.1) THEN
C
                  SPMODL='HFB MEAN FIELD'
              ELSE
                  SPMODL='CANONICAL     '
C
              END IF
C
          END IF
C
      ELSE
C
C=======================================================================
C        INITIALIZING THE MATRIX ELEMENTS OF THE PROTON MEAN FIELD
C=======================================================================
C
          IF (IREAWS.EQ.1) THEN
C
              CALL WSHAMI(ITILAX,ITISAX,NO_ORB,ICHARG,ISIMPY)
C
              SPMODL='WOODS-SAXON   '
C
          ELSE
C
              DO LTWCEN=1,ITWCEN
C
                 CALL NILSON(ITILAX,ITISAX,NO_ORB,INNUMB,IZNUMB,
     *                              ICHARG,NAMEPN,HOMEGA,ISIMPY,
     *                                            ITWCEN,LTWCEN)
                 SPMODL='NILSSON       '
C
                 IF (ITWCEN.EQ.2) THEN
C
                     CALL TWCCOP(ICHARG,LTWCEN)
                     IF (I_SLOW.EQ.1) CALL TWC_SAVFIL(0,ICHARG,LTWCEN)
C
                  END IF
C
              END DO
C
          END IF
C
C=======================================================================
C        INITIALIZING THE MATRIX ELEMENTS OF THE PROTON PAIRING FIELD
C=======================================================================
C
          IF (MPAHFB.GE.1) THEN
C
              CALL INIPAI(ITPNMX,IPNMIX,ITWCEN,LDTWCE)
C
              IF (JETACM.EQ.2) CALL ZERLIN(ISIMPY,MPAIRI)
              IF (KETA_R.EQ.2) CALL ZERROT(ISIMPY,MPAIRI)
C
              DO LTWCEN=1,ITWCEN
C
                 INNERI=IND2HL(LTWCEN)
                 INNERJ=IND2HR(LTWCEN)
C
                                                  ITWCE2=     1
                 IF (IDEFIN.EQ.0.AND.ITWCEN.EQ.2) ITWCE2=ITWCEN
C
                 DO INNERK=1,ITWCE2
                    DO INNERL=1,ITWCE2

C
                       INDCOE=INTWHE(INNERI,INNERJ,INNERK,INNERL)
C
                       CALL INTEGD(ITPNMX,ISIMPY,ICHARG,
     *                      DELFIN,DELFIP,IDEFIN,IDEFIP,
     *                                    JETACM,KETA_R,
     *                      IGOGPA,IREGPA,ISEPPA,ICOUPA,
     *                                    NEWGOG,NEWCOU,
     *                             LTWCEN,ITWCEN,INDCOE)
C
                    END DO
                 END DO
C
                 IF (ITWCEN.EQ.2) THEN
C
                     CALL TWDECO(ICHARG,LTWCEN)
                     IF (I_SLOW.EQ.1) CALL TWC_SAVFIL(1,ICHARG,LTWCEN)
C
                 END IF
C
              END DO
C
          END IF
C
      END IF
C
C=======================================================================
C        MIXING OF THE MATRIX ELEMENTS OF THE HFB MATRIX. USUAL LINEAR
C        MIXING IS HANDLED BY THE ROUTINE DOBROY_MATRIX(), THE BROYDEN
C        CORRECTION BEING SIMPLY NOT ADDED
C=======================================================================
C
      IF (MIXMAT.EQ.1) THEN
C
          IF (ITERUN.GT.1) THEN
C
              CALL HPH_IN(ISIMPY,MREVER,ICHARG)
              IF (MPAHFB.GE.1) CALL DEL_IN(MREVER,IROTAT,ICHARG)
C
C              Evolving the Broyden and affecting the ouput
C
              CALL DOBROY_MATRIX(ITERUN,NSWBRP,ITAK_P,
     *                           NOICAN,SLOWEV,ESTABN,
     *                           EFERMP,EFEPIN,EFEPOU,
     *                           EFER2P,EF2PIN,EF2POU,
     *                           LIPKIP,NOFBRP,ICHARG,
     *                                         MPAHFB)
C
              CALL HPH_OU(ISIMPY,MREVER,ICHARG)
              CALL GETFIL(ISIMPY,ICHARG)
C
              IF (MPAHFB.GE.1) THEN
                  CALL DEL_OU(MREVER,IROTAT,ICHARG)
                  CALL GETPAI(ICHARG,REA2PP)
              END IF
C
          ELSE
              CALL SAVFIL(ISIMPY,MPAHFB,ICHARG,REA2PP)
          END IF
C
      END IF
C
C=======================================================================
C        SAVING  THE   P R O T O N   MEAN FIELDS
C=======================================================================
C
      IF ((IWRIFI.NE.-1.OR.I_SLOW.EQ.1).AND.MIXMAT.EQ.0.AND.ITWCEN.EQ.1)
     *    CALL SAVFIL(ISIMPY,MPAHFB,ICHARG,REA2PP)
C
C=======================================================================
C        DIAGONALIZING THE MATRIX OF THE  PROTON   H F B   HAMILTONIAN
C=======================================================================
C
      IF (MPAHFB.GE.1) THEN
C
          IREMQB(:)=0
          INUMQB(:)=0
          JNUMQB(:)=0
C
          IF (ISIMPY.EQ.1) THEN
C
              IF (ISIGNY.EQ.1) THEN
C
                  CALL HFBSIG(EFERMP,ECUTOF,LIMQUA,LAMCUT,ICHARG,IMFHFB,
     *                               FERALP,IFERAP,PARNUP,IZ_FIX,
     *                                             ITWOBA,IWRIQU,
     *                               INSIGP,IPSIGP,ISSIGP,IDSIGP,
     *                                             IFIBLP,ISABLP,
     *                               IREQPB,INUQPB,JNUQPB,IF_RPA)
C
                  IREMQB(1)=IREQPB
                  INUMQB(1)=INUQPB
                  JNUMQB(1)=JNUQPB
C
              ELSE
C
                  IF (IFERAP.EQ.1) STOP ' ALM METHD NOT IMPLEMENTED YET'
C
                  CALL HFBSIM(EFERMP,ECUTOF,LIMQUA,LAMCUT,ICHARG,IMFHFB,
     *                               FERALP,IFERAP,PARNUP,IZ_FIX,
     *                                             ITWOBA,IWRIQU,
     *                                      INSIMP,IRSIMP,IDSIMP,
     *                                             IFIBLP,ISABLP,
     *                               IREQPB,INUQPB,JNUQPB,IF_RPA)
C
                  IREMQB(1)=IREQPB
                  INUMQB(1)=INUQPB
                  JNUMQB(1)=JNUQPB
C
              END IF
C
          ELSE
C
              IF (ISIQTY.EQ.1) THEN
C
                  IF (IFERAP.EQ.1) STOP ' ALM METHD NOT IMPLEMENTED YET'
C
                  CALL HFBSIQ(EFERMP,ECUTOF,LIMQUA,LAMCUT,ICHARG,IMFHFB,
     *                               FERALP,IFERAP,PARNUP,IZ_FIX,
     *                                             ITWOBA,NUQEVE,
     *                                      INSIQP,IPSIQP,IDSIQP,
     *                                             IFIBLP,ISABLP,
     *                                      IREQPB,INUQPB,JNUQPB)
C
                  IREMQB(1)=IREQPB
                  INUMQB(1)=INUQPB
                  JNUMQB(1)=JNUQPB
C
              ELSE
C
                  IF (IFERAP.EQ.1) STOP ' ALM METHD NOT IMPLEMENTED YET'
C
                  IF (ITWCEN.EQ.1) THEN
C
                  CALL HFBSIZ(EFERMP,ECUTOF,LIMQUA,LAMCUT,ICHARG,IMFHFB,
     *                               FERALP,IFERAP,PARNUP,IZ_FIX,
     *                                             ITWOBA,NUQEVE,
     *                                             INSIZP,IDSIZP,
     *                                             IFIBLP,ISABLP,
     *                               IREMQB,INUMQB,JNUMQB,ISAOCC)
C
                  ELSEIF (ITWCEN.EQ.2) THEN
C
                      CALL TWCSIZ_NATBAS(ICHARG,LDMEFI,MPAHFB,EFERMP,
     *                                   ECUTOF,LAMCUT,INSIZP,IDSIZP,
     *                                   IFIBLP,ISABLP,IREMQB,INUMQB,
     *                                                        JNUMQB)
C
                  END IF
C
              END IF
C
          END IF
C
#if(USE_MPI==1)
          IF (escapeSignal.Eq.1) THEN
C
              WRITE(6,'(''Process '',i6,
     *                  '' - HFBSIM failed for protons. '',
     *                  ''Closing all files and exiting...'')')
     *                    WorldRank
C
              ! Properly close all files that could have been left
              ! opened (with the exclusion of the output unit NFIPRI)
              CALL IOCLOS(NFIWOO,NFIREP,NFIREV,NFIREC,NFICOU,NFIWAV,
     *                    NFIKER,NFIYUP,NFIYUC,NFIGOC,NFIGOP,NFIGPC,
     *                    NFIGPP,NFIROP,NFIROC,NFILIP,NFILIC,NFIFIP,
     *                    NFIFIC,NFIISO,NFIQUA,NFIRED,NFIBAC,NFIBAP)
C
              EXIT procLoop
C
          END IF
#endif
          EFEPIN=EFERMP
C
          CALL QUABCS(EFERMP,IZ_FIX,FERFIP,IFEFIP,ICHARG,
     *                       IDSIGP,IDSIMP,IDSIQP,IDSIZP,
     *                              IPRGCM,NUQEVE,ITWOBA,
     *                              FERALP,IFERAP,PARNUP,
     *                              IREMQB,INUMQB,JNUMQB,
     *                                     ISIMPY,ISIQTY)
C
#if(USE_MPI==1)
          IF (escapeSignal.Eq.1) THEN
C
              WRITE(6,'(''Process '',i6,
     *                  '' - QUABCS failed for protons. '',
     *                  ''Closing all files and exiting...'')')
     *                    WorldRank
C
              ! Properly close all files that could have been left
              ! opened (with the exclusion of the output unit NFIPRI)
              CALL IOCLOS(NFIWOO,NFIREP,NFIREV,NFIREC,NFICOU,NFIWAV,
     *                    NFIKER,NFIYUP,NFIYUC,NFIGOC,NFIGOP,NFIGPC,
     *                    NFIGPP,NFIROP,NFIROC,NFILIP,NFILIC,NFIFIP,
     *                    NFIFIC,NFIISO,NFIQUA,NFIRED,NFIBAC,NFIBAP)
C
              EXIT procLoop
C
          END IF
#endif
C
          EFEPOU=EFERMP
C
          IF (PRINIT) THEN
C
              IF (IQUNIL.GE.1) CALL NILAQP(NOSCIL,MREVER,ICHARG,
     *                                            ISIMPY,NILXYZ)
C
              CALL SPTQUA(EMAXQU,ICHARG,NAMEPN,NILXYZ,
     *                    IQUNIL,ISIGNY,ISIMPY,ISIQTY,
     *                    IDSIGP,IDSIMP,IDSIQP,IDSIZP,
     *                           IREMQB,INUMQB,JNUMQB)
C
          END IF
C
      END IF
C
C=======================================================================
C        DIAGONALIZING THE MATRIX OF THE   P R O T O N   MEAN FIELD
C=======================================================================
C
      DISLIP=0.0D0
C
      IF (MPAHFB.GE.1) THEN
C
          IF (ITWCEN.EQ.1) THEN
C
              IF (ISIMPY.EQ.1) THEN
C
                  CALL CANQUA(MREVER,ICHARG,IMFHFB,IREQPB,
     *                        LIPNOP,PARLIP,DISLIP,ESUM_P)
              ELSE
                  CALL CANQUZ(ICHARG,IMFHFB,LIPNOP,PARLIP,DISLIP,ESUM_P)
C
              END IF
C
          END IF
C
      ELSE
C
          LIMPAR=0
          IF (ISIMPY.EQ.1) THEN
C
              IF (ISIGNY.EQ.1) THEN
C
                  CALL DIASIG(MREVER,ICHARG,LIMPAR,ECUTOF)
C
              ELSE
C
                  CALL DIASIM(MREVER,ICHARG,LIMPAR,ECUTOF)
C
              END IF
C
          ELSE
C
              IF (ISIQTY.EQ.1) THEN
C
                  CALL DIASIQ(ICHARG,LIMPAR,ECUTOF)
C
              ELSE
C
                  IF (ITWCEN.EQ.1) THEN
C
                      CALL DIASIZ(ICHARG,LIMPAR,ECUTOF,LDMEFI,ISAOCC)
C
                  ELSEIF(ITWCEN.EQ.2) THEN
C
                      CALL TWCSIZ_NATBAS(ICHARG,LDMEFI,MPAHFB,EFERMP,
     *                                   ECUTOF,LAMCUT,INSIZP,IDSIZP,
     *                                   IFIBLP,ISABLP,IREMQB,INUMQB,
     *                                                        JNUMQB)
C
                  END IF
C
              END IF
C
          END IF
C
      END IF
C
C=======================================================================
C        CALCULATING VARIOUS SINGLE-PARTICLE AVERAGES FOR PROTONS
C=======================================================================
C=======================================================================
C        SEE COMMENTS TO THE PREVIOUS CALL TO AVANGY
C=======================================================================
C
      IF (ITWCEN.EQ.1) THEN
C
          IF((ISIMPY.EQ.1.AND.IFLIPI.NE.0.AND.ICHFLI.EQ.ICHARG)     .OR.
     *
     *   (ISIMPY.EQ.1.AND.ISIGNY.EQ.1.AND.(NOFLIG(0,0,ICHARG).NE.0  .OR.
     *                                     NOFLIG(0,1,ICHARG).NE.0  .OR.
     *                                     NOFLIG(1,0,ICHARG).NE.0  .OR.
     *                                     NOFLIG(1,1,ICHARG).NE.0)).OR.
     *
     *   (ISIMPY.EQ.1.AND.ISIGNY.NE.1.AND.(NOFLIM(  0,ICHARG).NE.0  .OR.
     *                                     NOFLIM(  1,ICHARG).NE.0)).OR.
     *
     *   (ISIMPY.NE.1.AND.ISIQTY.EQ.1.AND.(NOFLIQ(  0,ICHARG).NE.0  .OR.
     *                                     NOFLIQ(  1,ICHARG).NE.0)).OR.
     *
     *   (ISIMPY.NE.1.AND.ISIQTY.NE.1.AND.(NOFLIZ(    ICHARG).NE.0)).OR.
     *
     *    IS_CON.EQ.1                                               .OR.
     *
     *    IS_PIN.EQ.1                                               .OR.
     *
     *    IS_CHA.EQ.1                                               .OR.
     *
     *    TERMNT                                                    .OR.
     *
     *    PRINIT)                                                   THEN
C
          CALL AVOBSE(MREVER,ICHARG,IPNMIX,NRAORD)
C
          END IF
C
      END IF
C
      CALL AVANGY(MREVER,ICHARG,IPNMIX,ISIMPY,ITWCEN)
C
C=======================================================================
C        CALCULATING SINGLE-PARTICLE AVERAGES FOR PROTONS
C=======================================================================
C
      IF (ITWCEN.EQ.1) THEN
C
          CALL AVPARI(MREVER,ICHARG,IPNMIX)
C
          IF (TERMNT.OR.PRINIT) THEN
C
              CALL AVSIMP(MREVER,ICHARG,IPNMIX)
C
              CALL NILASP(NOSCIL,MREVER,ICHARG,ISIMPY,NILXYZ)
C
          END IF
C
      END IF
C
C=======================================================================
C        CALCULATING THE PROTON  PAIRING AND DEFINING OCCUPATION FACTORS
C=======================================================================
C
      EPAI_P=0.0
      EREA_P=0.0
      ELIP_P=0.0
C
      IF (MPAIRI.EQ.1) THEN
C
          IF (MPABCS.GT.0) THEN
C
              IF (MPABCS.EQ.1.OR.
     *           (MPABCS.EQ.3.AND.ITERUN.EQ.1))  THEN
C
                  IF (IAVRGG.NE.1) THEN
C
                      CALL SETPAI(IN_FIX,IZ_FIX,FACTGP,ICHARG,GPAIRP)
C
                  ELSE
C
                      CALL GAVRAG(IN_FIX,IZ_FIX,FACTGP,ICHARG,GPAIRP)
C
                  END IF
C
              END IF
C
              EFEPIN=EFERMP
              CALL DELPAI (ICHARG,MREVER,MPABCS,IZ_FIX,ITERUN,
     *                     DELFIP,GPAIRP,EPAI_P,EFERMP,DELTAP)
              EFEPOU=EFERMP
C
              IF (PRINIT)
     *
     *            CALL PAIPRI(NAMEPN,GPAIRP,EPAI_P,EFERMP,DELTAP,
     *                                      LIPKIP,EFER2P,ELIP_P,
     *                                      MPAHFB,MPABCS,IAVRGG,
     *                               IGOGPA,IREGPA,ISEPPA,ICOUPA)
C
          END IF
C
      ELSE
C
          IF (ISIMPY.EQ.1) THEN
C
              IF (ISIGNY.EQ.1) THEN
C
                  CALL CONSIG(MREVER,ICHARG,IZ_FIX,EFERMP,
     *                               ICHFLI,IPAFLI,IREFLI,
     *                               ISPFLI,ISHFLI,IFLIPI)
              ELSE
C
                  CALL CONSIM(MREVER,ICHARG,IZ_FIX,EFERMP,
     *                               ICHFLI,       IREFLI,
     *                               ISPFLI,ISHFLI,IFLIPI)
C
              END IF
C
          ELSE
C
              IF (ISIQTY.EQ.1) THEN
C
                  CALL CONSIQ(ICHARG,IZ_FIX,EFERMP,
     *                        ICHFLI,IPAFLI,
     *                        INSIQP,IPSIQP,IDSIQP,
     *                               IFIBLP,ISABLP,
     *                        ISPFLI,ISHFLI,IFLIPI,
     *                               NLSIQP,MXALIP)
              ELSE
C
                  CALL CONSIZ(ICHARG,IZ_FIX,EFERMP,
     *                        ICHFLI,INSIZP,IDSIZP,
     *                               IFIBLP,ISABLP,
     *                        ISPFLI,ISHFLI,IFLIPI,
     *                               NLSIZP,MXALIP,
     *                                      ISAOCC,
     *                                      ITWCEN)
C
              END IF
C
          END IF
C
          DELTAP=0.0D0
C
      END IF
C
C=======================================================================
C        PRINTING SINGLE-PARTICLE SPECTRA FOR PROTONS
C=======================================================================
C
      IF (PRINIT) THEN
C
          CALL SPTALL(EMINAL,EMAXAL,SPMODL,NAMEPN,
     *                ISIGNY,ISIMPY,ISIQTY,MPAHFB,
     *                       MREVER,ICHARG,NILXYZ,
     *                IDSIGP,IDSIMP,IDSIQP,IDSIZP,NRAORD
     *                                           ,ITWCEN)
C
      END IF
C
C=======================================================================
C        CALCULATING THE SUM OF  PROTON SINGLE-PARTICLE ENERGIES
C=======================================================================
C
      IF (MPAHFB.LT.1)
     *
     *    CALL SPENSU(MREVER,ESUM_P,ICHARG,ISIMPY,ITWCEN)
C
C=======================================================================
C        CALCULATING THE SUM OF  PROTON QUASIPARTICLE ENERGIES
C=======================================================================
C
      IF (MPAHFB.GE.1.AND.IQPSTA.EQ.1)
     *
     *    CALL QPENSU(MREVER,ESUM_P,EFERMP,ICHARG)
C
C=======================================================================
C         ZEROING THE PROTON DENSITIES
C=======================================================================
C
      CALL ZEDENS(ITPNMX)
C
C=======================================================================
C        CALCULATING THE PROTON DENSITIES AND CURRENTS
C=======================================================================
C        TWO-CENTRE BASIS OPTION: SEE COMMENTS IN NEUTRON BLOCK
C=======================================================================
C
      IF (ITWCEN.EQ.2) THEN
C
          ISAWAV=1
          IKERNE=0
C
      END IF
C
      CALL DENSHF(ISIMTX,JSIMTY,ISIMTZ,
     *            ISIGNY,ISIMPY,ISIQTY,MPAHFB,MREVER,ICHARG,
     *                                 MIN_QP,IPNMIX,ITPNMX,
     *                   ITIREP,NAMEPN,PRINIT,IDEVAR,ITERUN,
     *            ISYMDE,INIROT,INIINV,INIKAR,ISAWAV,IKERNE,
     *                                             ITWCEN,1)
C
      IF (ITWCEN.EQ.2) THEN
C
          CALL DENSHF(ISIMTX,JSIMTY,ISIMTZ,
     *            ISIGNY,ISIMPY,ISIQTY,MPAHFB,MREVER,ICHARG,
     *                                 MIN_QP,IPNMIX,ITPNMX,
     *                   ITIREP,NAMEPN,PRINIT,IDEVAR,ITERUN,
     *            ISYMDE,INIROT,INIINV,INIKAR,ISAWAV,IKERNE,
     *                                        ITWCEN,NDTWHE)
C
          IKERNE=1
          ISAWAV=0
C
          IALLOC=0
C
          IF (.NOT.ALLOCATED(WALEFT)) THEN
          ALLOCATE (WALEFT(1:NDBASE,1:4*NDSTAT,0:NDSPIN),
     *                                                   STAT=IALLOC)
          IF (IALLOC.NE.0) CALL NOALLO('WALEFT','HFODD ')
          END IF
C
          IF (ITWCEN.GT.NDTWCE) STOP ' ITWCEN.GT.NDTWCE IN HFODD'
C
          DO LTWCEN=1,LDTWDD
C
             IF (LTWCEN.EQ.1.OR.LTWCEN.EQ.16) CYCLE
C
             IF (IDCOPY(LTWCEN,IPAIRI).EQ.0) THEN
C
                 WALEFT(:,:,:)=SARIGH(:,:,:,ICHARG,IND4HK(LTWCEN))
                 WARIGH(:,:,:)=SARIGH(:,:,:,ICHARG,IND4HL(LTWCEN))
C
                 CALL DENSHF(ISIMTX,JSIMTY,ISIMTZ,
     *            ISIGNY,ISIMPY,ISIQTY,MPAHFB,MREVER,ICHARG,
     *                                 MIN_QP,IPNMIX,ITPNMX,
     *                   ITIREP,NAMEPN,PRINIT,IDEVAR,ITERUN,
     *            ISYMDE,INIROT,INIINV,INIKAR,ISAWAV,IKERNE,
     *                                        ITWCEN,LTWCEN)
C
             ELSEIF (IDCOPY(LTWCEN,IPAIRI).NE.0) THEN
C
                 CALL TWC_MORDEN(LTWCEN,ITPNMX,IGRAIN,IPAIRI)
C
             END IF
C
          END DO
C
      END IF
C
C=======================================================================
C         DOUBLING SINGLE-PARTICLE RESULTS IN CASE OF NO ROTATION
C=======================================================================
C
      IF (MREVER.EQ.0) THEN
C
          CALL DBLING(ITPNMX)
C
          ESUM_P=2*ESUM_P
C
      END IF
C
C@@@ HFBTHO - HFBTHO - HFBTHO - HFBTHO - HFBTHO - HFBTHO - HFBTHO
C=======================================================================
C        BY DEFAULT,  HFODD  INITIALIZES THE  MATRIX OF THE  MEAN-FIELD
C        BY  COMPUTING THE  MATRIX ELEMENTS  OF THE  NILSON  POTENTIAL.
C        IN  HFB  MODE IT  INITIALIZES  THE MATRIX OF THE PAIRING FIELD
C        BY COMPUTING THE MATRIX ELEMENTS OF THE  DELTA-PAIRING  INTER-
C        ACTION, WHICH DEPENDS ON THE ISO-SCALAR DENSITY, AND THEREFORE
C        ON BOTH PROTON AND NEUTRON DENSITIES ON THE GAUSS-HERMITE MESH.
C        WHEN RESTARTING FROM HFBTHO, THESE DENSITIES ARE NOT AVAILABLE:
C        THE COMPUTATION OF  ALL  PAIRING OBSERVABLES MUST THEREFORE BE
C        SHIFTED TO  AFTER  THE NEW ISOSCALAR DENSITY HAS BEEN COMPUTED.
C        THIS ONLY AFFECTS THE  FIRST ITERATION, SEE ALSO COMMENT ABOUT
C        NUMITE BELOW.
C=======================================================================
C
      IF (IF_THO.EQ.0.OR.ITERUN.NE.1) THEN
C
C=======================================================================
C        CALCULATING THE  PROTON HFB PAIRING ENERGY AND AVERAGE DELTA
C=======================================================================
C
          IF (MPAHFB.GE.1)
     *
     *        CALL EPAIRI(IN_FIX,IZ_FIX,ITPNMX,EKEPAI,LDTWCE)
C
C=======================================================================
C        CALCULATING THE PROTON LIPKIN-NOGAMI CORRECTION
C=======================================================================
C        WHEN STARTING FROM SCRATCH, THE CODE INITALIZES THE PH AND PP
C        CHANNELS  AT  NUMITE = 0. WHEN  RESTARTING FROM  HFBTHO, THIS
C        INITIALIZATION  MUST BE  SKIPPED,  WHICH IS  DONE BY  SETTING
C        NUMITE = 1. HOWEVER, TO  ENSURE  A  SMOOTH  RESTART OF THE LN
C        LAMBDA_2 PARAMETER,  ONE MUST DO 'AS IF' WE WERE AT THE FIRST
C        ITERATION, HENCE THE TRICK BELOW.
C=======================================================================
C
                           NACTIT=NUMITE
          IF (IF_THO.GE.1) NACTIT=NUMITE-2
C
          IF (LIPKIP.EQ.1) THEN
              EF2PIN=EFER2P
              CALL LIPCOR(GPAIRP,FACTGP,FE2FIP,IF2FIP,I_SLOW,SLOWLI,
     *                                         EFER2P,NACTIT,ICHARG)
              EF2POU=EFER2P
C
              ELIP_P=-2*EFER2P*DISLIP
C
          END IF
C
C=======================================================================
C        CALCULATING THE PROTON PAIRING MATRIX ELEMENTS
C=======================================================================
C
          IF (IDEVAR.EQ.1)
     *
     *        CALL GINTER(ICHARG,MREVER,PRHO_P,PRHODP,POWERP)
C
C=======================================================================
C        PRINTING THE PAIRING RESULTS
C=======================================================================
C
          IF (PRINIT.AND.MPAHFB.GE.1)
     *
     *        CALL PAIPRI(NAMEPN,GPAIRP,EPAI_P,EFERMP,DELTAP,
     *                                  LIPKIP,EFER2P,ELIP_P,
     *                                  MPAHFB,MPABCS,IAVRGG,
     *                           IGOGPA,IREGPA,ISEPPA,ICOUPA)
C
      END IF
C
C@@@ HFBTHO - HFBTHO - HFBTHO - HFBTHO - HFBTHO - HFBTHO - HFBTHO
C=======================================================================
C        CALCULATING THE   P R O T O N   D E N S I T Y   M A T R I X
C=======================================================================
C        TWO-CENTRE BASIS OPTION: SEE COMMENTS IN NEUTRON BLOCK
C=======================================================================
C
      IF (ITWCEN.EQ.1) THEN
C
          CALL DENMAC(MREVER,ICHARG,ISIMPY,MPAHFB,WARIGH,WARIGH,1)
C
      ELSEIF (ITWCEN.EQ.2) THEN
C
          DO LTWCEN=1,NDTWBL
C
             WARIGH(:,:,:)=SARIGH(:,:,:,ICHARG,IND2HL(LTWCEN))
             WALEFT(:,:,:)=SARIGH(:,:,:,ICHARG,IND2HR(LTWCEN))
C
             CALL DENMAC(MREVER,ICHARG,ISIMPY,MPAHFB,WALEFT,WARIGH,
     *                                                      LTWCEN)
C
             CALL TWCCOP(ICHARG,LTWCEN)
C
          END DO
C
          CALL TWC_BIGDEN(ICHARG)
C
      END IF
C
      IF (ITWCEN.EQ.2.AND.IQPSTA.EQ.0.AND.MPAHFB.EQ.1)
     *  CALL TWC_CANQUZ(ESUM_P)
C
C=======================================================================
C        CALCULATING THE   P R O T O N   P A I R I N G   T E N S O R
C=======================================================================
C
      IF (MPAHFB.EQ.1.AND.((COR_CM.OR.CORROT).OR.
     *    ICOUPA.GE.1.OR.MAXVAL(IFSTPA).GE.1.OR.
     *    IFRAGM.EQ.1.OR.
C    *    KETAJ2.EQ.1.OR.KETAT2.EQ.1.OR.
     *    IGOGPA.GE.1.OR.IREGPA.GE.1.OR.ISEPPA.GE.1))
     *
     *    CALL PAIMAC(ICHARG,ISIMPY,WARIGH,WARIGH,IKERNE)
C
C=======================================================================
C        ADDING THE PROTON DENSITY MATRIX TO THE BROYDEN VECTOR
C=======================================================================
C@@@ HFBTHO - HFBTHO - HFBTHO - HFBTHO - HFBTHO - HFBTHO - HFBTHO
                       NACTIT=NUMITE
      IF (IF_THO.GE.1) NACTIT=NUMITE-2
C@@@ HFBTHO - HFBTHO - HFBTHO - HFBTHO - HFBTHO - HFBTHO - HFBTHO
C
      IF (LIPKIP.EQ.1.AND.IBROYD.GE.1.AND.MIXMAT.EQ.0)
     *    CALL LIP_IN(ISIMPY,ICHARG,LIPKIN,LIPKIP,EF2PIN,EF2POU,
     *                                                   NACTIT)
C
C=======================================================================
C        SLOWING DOWN AND SAVING THE PROTON DENSITY MATRIX FOR
C        LIPKIN-NOGAMI
C=======================================================================
C            ATTENTION: SEE THE COMMENTS FOR NEUTRONS AVOVE
C=======================================================================
C
      IF (MPAHFB.EQ.1.AND.LIPKIP.EQ.1) THEN
                           MIXDEN=0
          IF (IBROYD.LT.1) MIXDEN=1
C
          CALL SAVLIP(ISIMPY,ICHARG,SLOWLD,MIXDEN)
C
      END IF
C
C=======================================================================
C        SLOWING DOWN THE PROTON DENSITY MATRIX AND PAIRING TENSOR
C        FOR THE LIPKIN METHOD
C        ATTENTION: SEE THE COMMENT FOR NEUTRONS
C=======================================================================
C
      IF (IRENMA.GE.1.OR.IRENIN.GE.1) THEN
C
                           MIXDEN=0
          IF (NACTIT.GT.0) MIXDEN=1
C
          CALL SAVLPM(ICHARG,ISIMPY,MPAIRI,SLOWLM,MIXDEN)
C
      END IF
C
C=======================================================================
C        SAVING THE PROTON DENSITY MATRIX
C=======================================================================
C
      IF (I_YUKA.GE.1.OR.I_GOGA.GE.1.OR.I_REGA.GE.1.OR.I_SEPA.GE.1.OR.
     *    I_COUA.GE.1.OR.MAXVAL(I_FSTA).GE.1.OR.MAXVAL(MAG2BC).GE.1.OR.
     *    ICOUDI.EQ.2.OR.ICOUEX.EQ.2.OR.
     *    COR_CM.OR.CORROT.OR.IFRAGM.EQ.1.OR.
     *    JETACM.GE.1.OR.KETA_R.GE.1)
     *
     *    CALL SAVDEN(ISIMPY,ICHARG)
C
C=======================================================================
C        SAVING THE PROTON PAIRING TENSOR
C=======================================================================
C
      IF (IGOGPA.GE.1.OR.IREGPA.GE.1.OR.ISEPPA.GE.1.OR.
     *    ICOUPA.GE.1.OR.MAXVAL(IFSTPA).GE.1.OR.
     *  ((COR_CM.OR.CORROT).AND.MPAHFB.GE.1))
     *
     *    CALL SAVPAI(ISIMPY,ICHARG)
C
C=======================================================================
C         CALCULATING   D I R E C T   YUKAWA ENERGIES FOR PROTONS
C=======================================================================
C
      IF (PRIYUK)
     *
     *    CALL YUKAWD(ISIMPY,ICHARG)
C
C=======================================================================
C        CALCULATING THE   P R O T O N     K I N E T I C     E N E R G Y
C=======================================================================
C
      CALL EKINET(EKIN_P,DLINSP(0),EKEKIN,DKINSP(0),ITWCEN)

C=======================================================================
C        CALCULATING THE   P R O T O N      POTENTIAL   HO   E N E R G Y
C=======================================================================
C
      EPOT_P =0.0D0
C
      IF (IPOTHO.EQ.1) THEN
        CALL EPOTHO(EPOT_P)
      END IF
C
C=======================================================================
C        CALCULATING THE   P R O T O N     M U L T I P O L E     MOMENTS
C=======================================================================
C
      ISHIFY=0
C
      CALL MOMETS(ISIMPY,ISIGNY,ISIQTY,QMUL_P,QMUT_P,
     *                   COMULT,KMULMO,ISHIFY,ITWCEN)
      CALL MOMSIF(ISIMPY,ISIGNY,ISIQTY,SMUL_P,SMUT_P,
     *                                 COMULT,KMULSI)
      IF (ISCHIF.EQ.1)
     *CALL MOMSCH(SMUL_P,SMUT_P,KMULSI,QMUL_P,QMUT_P,KMULMO)
      CALL MOMVMU(ISIMPY,VMUL_P,COMULT,KMULSI)
      IF (IDOPLM.EQ.1)
     *CALL MOMPLM(ISIMPY,ISIGNY,ISIQTY,PMUL_P,COMULT,KMULSI)
C
      IF (PRINIT.AND.IPRI_P.EQ.1) THEN
C
          CALL MOMPRI(ISIMPY,NAMMUL,NAMHAR,NAMEPN,QMUL_P,KMULMO,'Q')
          IF (KMULSI.GT.0)
     *    CALL MOMPRI(ISIMPY,NAMSIF,NAMHAR,NAMEPN,SMUL_P,KMULSI,'S')
          IF (KMULSI.GT.0.AND.IDOPLM.EQ.1)
     *    CALL MOMPRI(ISIMPY,NAMPLM,NAMHAR,NAMEPN,PMUL_P,KMULSI,'P')
C
      END IF
C
C=======================================================================
C         IN THE CASE OF SINGLE-PARTICLE BLOCKING, THE BLOCKED STATE CAN
C         BE EITHER A PARTICLE OR A HOLE. THEREFORE, HERE WE TEST IF THE
C         REQUESTED AND OBTAINED PARTICLE NUMBERS AGREE.
C=======================================================================
C
      IF (MAXVAL(IDSIQP).EQ.2.OR.MAXVAL(IDSIZP).EQ.2) THEN
C
          IF (ABS(QMUL_P(0,0)-IZ_FIX).GT.1.0D-06) THEN
C
              WRITE(NFIPRI,'(/,1X,20(1H/),
     *             '' INCONSISTENT NUMBERS OF  PROTONS'',1X,20(1H/),/,
     *                         1X,20(1H/),
     *             '' Q00='',D17.10,'' IZ_FIX='',I3,     1X,20(1H/),/)')
     *
     *             QMUL_P(0,0),IZ_FIX
C
              STOP ' INCONSISTENT NUMBERS OF PROTONS IN MAIN'
C
          END IF
C
      END IF
C
C=======================================================================
C
C      From now on, proton multipole moments have been computed and
C      are available for the Coulomb INTCOU() routine
      ISQPRO=1
C
C=======================================================================
C        CALCULATING THE   P R O T O N   M A G N E T I C   M O M E N T S
C=======================================================================
C
      CALL MAGMOM(ISIMPY,IROTAT,ICHARG,AMUL_P,AMUT_P,KMULMA,NMAORD)
C
      IF (PRINIT.AND.IPRI_P.EQ.1) THEN
C
          CALL MAGPRI(IROTAT,NAMMAG,NAMHAR,NAMEPN,AMUL_P,KMULMA,NMAORD,
     *                                                             'M')
C
      END IF
C
C=======================================================================
C        CALCULATING THE     P R O T O N     S P I N - ASYMMETRY MOMENTS
C=======================================================================
C
      CALL ASMMOM(ISIMPY,IROTAT,WMUL_P,WMUT_P,KMULAS,NASORD)
C
      IF (PRINIT.AND.IPRI_N.EQ.1) THEN
C
          CALL MAGPRI(IROTAT,NAMASM,NAMHAR,NAMEPN,WMUL_P,KMULAS,NASORD,
     *                                                             'A')
C
      END IF
C
C=======================================================================
C         CALCULATING   P R O T O N    R M S    R A D I I
C=======================================================================
C
      CALL RMSQUA(RADI_P,RMSRAP,IZ_FIX,NRAORD,ITWCEN)
C
      IF (PRINIT.AND.IPRI_P.EQ.1)
     *
     *    CALL RADPRI(NAMEPN,RADI_P,RMSRAP,NRAORD)
C
C=======================================================================
C        CALCULATING THE   P R O T O N    D E F O R M A T I O N S
C=======================================================================
C
      IF (PRIBET.AND.IPRI_P.EQ.1)
     *
     *    CALL BOHDEF(ISIMPY,NEXBET,IPRIBE,IPRIBL,NAMHAR,NAMEPN,
     *                              RADI_P,QMUL_P,BMUL_P,KMULMO)
C
C=======================================================================
C         CALCULATING   P R O T O N   S P I N
C=======================================================================
C
      CALL SPIMOM(ISIMPY,IROTAT,ANGU_P,SPIN_P,ITWCEN)
C
C=======================================================================
C        CALCULATING THE   P R O T O N   L I N E A R   M O M E N T A
C=======================================================================
C
      IF (COR_CM)
     *
     *    CALL LINAVR(ISIMPY,ISIGNY,ISIQTY,
     *                MPAHFB,ICHARG,JETACM,IROTAT,MREVER,COR_CM,IKERNE,
     *                DLINSP,ELINSP,PLINSP,TLINSP,ALINLP,PLINLP,PLINKP,
     *                DKINSP,EKINSP,PKINSP,TKINSP,AKINLP,PKINLP,PKINKP)
C
C=======================================================================
C        CALCULATING THE   P R O T O N   A N G U L A R   M O M E N T A
C=======================================================================
C
C     IF (CORROT.OR.KETAJ2.EQ.1)
      IF (CORROT)
     *
     *    CALL ROTAVR(ISIMPY,ISIGNY,ISIQTY,
     *                MPAHFB,ICHARG,KETA_R,IROTAT,MREVER,CORROT,IKERNE,
     *                DROTSP,EROTSP,PROTSP,TROTSP,AROTLP,PROTLP,PROTKP,
     *                DKOTSP,EKOTSP,PKOTSP,TKOTSP,AKOTLP,PKOTLP,PKOTKP)
C
C=======================================================================
C        CALCULATING PROPERTIES OF THE FRAGMENTS (TWO-CENTER BASIS)
C=======================================================================
C
      ENEFRP=0.0D0
      IF (ITWCEN.EQ.2) THEN
C
              CALL TWC_FRGENE(ICHARG,ITWCEN,ENEFRP)
              CALL TWC_FRGMOM(KMULMO,QFRA_P)
C
      END IF
C
C=======================================================================
C          CALCULATING   T R U E   CHARGE DENSITY
C=======================================================================
C
      CALL TRUCHD
C
C=======================================================================
C          ZEROING THE COULOMB ENERGIES
C=======================================================================
C
      EKECOD=C_ZERO
      EKECOE=C_ZERO
      EKESCA=C_ZERO
      EKEVEC=C_ZERO
      EKPSCA=C_ZERO
      EKPVEC=C_ZERO
C
C=======================================================================
C          CALCULATING THE DIRECT COULOMB ENERGIES AND FIELDS BY THE
C          GREEN-FUNCTION METHOD
C=======================================================================
C
      IF (ICOUDI.EQ.1) THEN
C
          CALL COUMAT(NUMCOU,BOUCOU,ISIMPY,IKERNE)
C
          CALL COULOD(ISIMPY,EKECOD)
C
      END IF
C
C=======================================================================
C          CALCULATING SLATER EXCHANGE COULOMB ENERGY
C=======================================================================
C
      IF (ICOUEX.EQ.1) THEN
C
          CALL COULOE(EKECOE)
C
      END IF
C
C=======================================================================
C          CALCULATING THE DIRECT, EXCHANGE AND PAIRING COULOMB ENERGIES
C          AND FIELDS BY THE METHOD OF EXPANDING IN GAUSSIANS
C=======================================================================
C
      IF (ICOUDI.EQ.2.OR.ICOUEX.EQ.2.OR.I_COUA.GE.1) THEN
C
          IF (NEWCOU.EQ.0) THEN
C
              CALL COUENE(ISIMPY,
     *                    ICOTYP,ICOUDI,ICOUEX,
     *                                  IDOTHC,
     *                    EKECOD,EKESCA,EKEVEC)
C
          ELSE
C
              CALL CO2ENE(ISIMPY,ICOTYP,ICOUDI,ICOUEX,ICOUPA,
     *                    EKECOD,EKESCA,EKEVEC,ITWCEN,LDTWCE)
C
          END IF
C
          IF (ICOUEX.EQ.2) EKECOE=EKESCA+EKEVEC
C
      END IF
C
      ECOULD=REAL(EKECOD)
      ECOULE=REAL(EKECOE)*COUSCA
      ECOULS=REAL(EKESCA)
      ECOULV=REAL(EKEVEC)
C
C=======================================================================
C         CALCULATIONS FOR  MOMENTS OF INERTIA
C         AND MASS PARAMETERS (PROTON PART)
C=======================================================================
C
      if (TERMNT) then
C
          if (imominer.eq.1) then
                  call momsiner(icharg,ipahfb,jpabcs)
          endif
C
          if (imaspar.eq.1) then
                call maspar_v0(ipahfb,jpabcs,icharg,mrever)
          endif
C
          if ((imominer.eq.1).and.(imaspar.eq.1)) then
                call datatobh(innumb,iznumb,r0parm,numite,estabc,if_rpa)
          endif
C
      endif  ! TERMNT
C
C=======================================================================
C         HERE ENDS THE BLOCK FOR  P R O T O N S
C=======================================================================
C
 8971 CONTINUE
C
C=======================================================================
C         HERE ENDS THE CALCULATION WITHOUT THE PROTON-NEUTRON MIXING
C=======================================================================
C
 8972 CONTINUE
C
C=======================================================================
C         HERE STARTS THE CALCULATION FOR THE NEUTRON-PROTON MIXING
C=======================================================================
C
      IF (IPNMIX.NE.1) GO TO 8973
C
      NAMEPN='NEUT-PRO'
C
C=======================================================================
C        SECURITY DEFINITION OF MPAHFB - THIS OPTION DOES NOT APPLY HERE
C=======================================================================
C
      MPAHFB=10
C
C=======================================================================
C        CALCULATING THE MATRIX ELEMENTS OF THE MEAN  FIELD.
C        IN THE FIRST ITERATION AND FOR IFCONT>0, THE MATRIX
C        ELEMENTS ARE SUPPOSED TO BE ALREADY IN MEMORY.
C=======================================================================
C
      IF (NUMITE.GT.0) THEN
C
          IF (NUMITE.GT.ITESTA.OR.(IFCONT.NE.1.AND.IF_THO.EQ.0)) THEN
C
              DO ITPNMX=0,2
C
                 ICHARG=ITPNMX
C
                 IF (ITWCEN.GT.1)
     *               STOP ' INTEGH NOT READY FOR IPNMIX=1 IN HFODD'
C
                 CALL INTEGH(IMOVAX,ITILAX,ITISAX,NO_ORB,
     *                IPNMIX,ITPNMX,IROTAT,ICHARG,ISIMPY,
     *                       MPAHFB,IPOTHO,ISCHIF,IOCONT,
     *                                     NMUCON,NSICON,
     *                       I_YUKA,I_GOGA,I_REGA,I_SEPA,
     *                              ITWOLI,JETACM,ALINLT,
     *                                     KETA_R,AROTLT,
     *                                     ICOUDI,ICOUEX,
     *                                     LIPKIN,LIPKIP,
     *                                     EFER2N,EFER2P,
     *                                            IF_RPA,
     *                                     ILIPON,ILIPOP,
     *                                            NEWGOG,
     *                                               1,1,
     *                                                 1)
C
                 IF (NUMITE.GT.ITESTA.OR.(IFCONT.EQ.1.OR.IF_THO.EQ.1))
     *                                                              THEN
C
                     IF (I_SLOW.EQ.1)
     *               CALL MIXFIL(ISIMPY,ICHARG,SLOWAL,1,1)
C
                 END IF
C
                 CALL PNMCOP(IPNMIX,ITPNMX,ISIMPY)
C
              END DO
C
          END IF
C
          SPMODL='HARTREE-FOCK  '
C
C=======================================================================
C        CALCULATING THE MATRIX ELEMENTS OF THE PAIRING FIELD
C=======================================================================
C
          IF (IPAHFB.GE.1) THEN
C
              STOP 'NOT READY YET 1'
C
              CALL INTEGD(ITPNMX,ISIMPY,ICHARG,
     *                    DELFIN,DELFIP,IDEFIN,IDEFIP,
     *                                  JETACM,KETA_R,
     *                    IGOGPA,IREGPA,ISEPPA,ICOUPA,
     *                                  NEWGOG,NEWCOU,
     *                                          1,1,1)
C
              IF (NUMITE.GT.ITESTA.OR.(IFCONT.EQ.1.OR.IF_THO.EQ.1)) THEN
C
                  IF (I_SLOW.EQ.1) CALL MIXPAI(ICHARG,REA2PP,SLOWAL,1,1)
C
              END IF
C
              IF (IMFHFB.EQ.1) THEN
C
                  SPMODL='HFB MEAN FIELD'
              ELSE
                  SPMODL='CANONICAL     '
C
              END IF
C
          END IF
C
      ELSE
C
C=======================================================================
C        INITIALIZING THE MATRIX ELEMENTS OF THE MEAN FIELD
C=======================================================================
C
          DO ITPNMX=0,1
C
             ICHARG=ITPNMX
C
             IF (IREAWS.EQ.1) THEN
C
                 CALL WSHAMI(ITILAX,ITISAX,NO_ORB,ICHARG,ISIMPY)
C
                 SPMODL='WOODS-SAXON   '
C
             ELSE
C
            IF (ITWCEN.EQ.1) THEN
C
              CALL NILSON(ITILAX,ITISAX,NO_ORB,INNUMB,IZNUMB,
     *                           ICHARG,NAMEPN,HOMEGA,ISIMPY,
     *                                                  1,1)
C
                 SPMODL='NILSSON       '
             ELSE
               STOP 'TWO CENTER INCOMPATIBLE WITH PN MIXING'
             END IF
C
            END IF
C
             CALL PNMCOP(IPNMIX,ITPNMX,ISIMPY)
C
          END DO
C
C=======================================================================
C        INITIALIZING THE MATRIX ELEMENTS OF THE PAIRING FIELD
C=======================================================================
C
          IF (IPAHFB.GE.1) THEN
C
              STOP 'NOT READY YET 2'
C
              CALL INIPAI(ITPNMX,IPNMIX,ITWCEN,1)
C
              IF (JETACM.EQ.2) CALL ZERLIN(ISIMPY,MPAIRI)
              IF (KETA_R.EQ.2) CALL ZERROT(ISIMPY,MPAIRI)
C
              CALL INTEGD(ITPNMX,ISIMPY,ICHARG,
     *                    DELFIN,DELFIP,IDEFIN,IDEFIP,
     *                                  JETACM,KETA_R,
     *                    IGOGPA,IREGPA,ISEPPA,ICOUPA,
     *                                  NEWGOG,NEWCOU,
     *                                          1,1,1)
C
              IF (NUMITE.GT.ITESTA.OR.(IFCONT.EQ.1.OR.IF_THO.EQ.1)) THEN
C
                  IF (I_SLOW.EQ.1) CALL MIXPAI(ICHARG,REA2PP,SLOWAL,1,1)
C
              END IF
C
          END IF
C
      END IF
C
C=======================================================================
C        DIAGONALIZING THE MATRIX OF THE   H F B   HAMILTONIAN
C=======================================================================
C
      IF (IPAHFB.GE.1) THEN
C
          IREMQB(:)=0
          INUMQB(:)=0
          JNUMQB(:)=0
C
          IF (ISIMPY.EQ.1) THEN
C
              STOP 'NOT READY YET 3'
C
              IF (ISIGNY.EQ.1) THEN
C
                  CALL HFBSIG(EFERMP,ECUTOF,LIMQUA,LAMCUT,ICHARG,IMFHFB,
     *                               FERALP,IFERAP,PARNUP,IZ_FIX,
     *                                             ITWOBA,IWRIQU,
     *                               INSIGP,IPSIGP,ISSIGP,IDSIGP,
     *                                             IFIBLP,ISABLP,
     *                               IREQPB,INUQPB,JNUQPB,IF_RPA)
C
                  IREMQB(1)=IREQPB
                  INUMQB(1)=INUQPB
                  JNUMQB(1)=JNUQPB
C
              ELSE
C
                  CALL HFBSIM(EFERMP,ECUTOF,LIMQUA,LAMCUT,ICHARG,IMFHFB,
     *                               FERALP,IFERAP,PARNUP,IZ_FIX,
     *                                             ITWOBA,IWRIQU,
     *                                      INSIMP,IRSIMP,IDSIMP,
     *                                             IFIBLP,ISABLP,
     *                               IREQPB,INUQPB,JNUQPB,IF_RPA)
C
                  IREMQB(1)=IREQPB
                  INUMQB(1)=INUQPB
                  JNUMQB(1)=JNUQPB
C
             END IF
C
          ELSE
C
              IF (ISIQTY.EQ.1) THEN
C
                  STOP 'NOT READY YET 4'
C
                  CALL HFBSIQ(EFERMP,ECUTOF,LIMQUA,LAMCUT,ICHARG,IMFHFB,
     *                               FERALP,IFERAP,PARNUP,IZ_FIX,
     *                                             ITWOBA,NUQEVE,
     *                                      INSIQP,IPSIQP,IDSIQP,
     *                                             IFIBLP,ISABLP,
     *                                      IREQPB,INUQPB,JNUQPB)
C
                  IREMQB(1)=IREQPB
                  INUMQB(1)=INUQPB
                  JNUMQB(1)=JNUQPB
C
              ELSE

                  CALL HFBMIZ(EFERMA,ECUTOF,LIMQUA,LAMCUT,IMFHFB,
     *                                             PARNUA,IA_FIX,
     *                                             ITWOBA,NUQEVE,
     *                                             INMIZA,IDMIZA,
     *                                             IFIBLA,ISABLA,
     *                               IREQPB,INUQPB,JNUQPB,ISAOCC)
C
                  IREMQB(1)=IREQPB
                  INUMQB(1)=INUQPB
                  JNUMQB(1)=JNUQPB
C
              END IF
C
          END IF
C
          EFEPIN=EFERMA
C
C=======================================================================
C        ATTENTION: WE USE ICHARG=0 TO ACCOMODATE ALL PROTON-NEUTRON
C                   MIXED QUASIPARTICLES
C=======================================================================
C
          ICHARG=0
C
C=======================================================================
C
          CALL QUABCS(EFERMA,IA_FIX,FERFIP,IFEFIP,ICHARG,
     *                       IDMIGA,IDMIMA,IDMIQA,IDMIZA,
     *                              IPRGCM,NUQEVE,ITWOBA,
     *                              FERALA,IFERAA,PARNUA,
     *                              IREMQB,INUMQB,JNUMQB,
     *                                     ISIMPY,ISIQTY)
C
          EFEPOU=EFERMA
C
          IF (PRINIT) CALL SPTQUA(EMAXQU,ICHARG,NAMEPN,NILXYZ,
     *                            IQUNIL,ISIGNY,ISIMPY,ISIQTY,
     *                            IDMIGA,IDMIMA,IDMIQA,IDMIZA,
     *                                   IREMQB,INUMQB,JNUMQB)
C
      END IF
C
C=======================================================================
C        DIAGONALIZING THE DENSITY MATRIX OR MATRIX OF THE MEAN FIELD
C=======================================================================
C
      DISLIA=0.0D0
C
      ICHARG=0
C
      IF (IPAHFB.GE.1) THEN
C
          ICHARG=0
C
          IF (ISIMPY.EQ.1) THEN
C
              STOP ' HFB WITH IPNMIX=1 AND ISIMPY=1 NOT IMPLEMENTED YET'
C
              CALL CANQUA(MREVER,ICHARG,IMFHFB,IREQPB,
     *                    LIPNOA,PARLIP,DISLIA,ESUM_P)
          ELSE
C
              CALL CANMIZ(ICHARG,IMFHFB,LIPNOA,PARLIA,DISLIA,ESUM_A)
C
          END IF
C
      ELSE
C
          IF (ISIMPY.EQ.1) THEN
C
              IF (ISIGNY.EQ.1) THEN
C
                  CALL DIAMIG(MREVER)
C
              ELSE
C
                  CALL DIAMIM(MREVER)
C
              END IF
C
          ELSE
C
              IF (ISIQTY.EQ.1) THEN
C
                  CALL DIAMIQ
C
              ELSE
C
                  LIMPAR=0
C
                  IF (ITWCEN.EQ.1) THEN
C
                      CALL DIAMIZ(LIMPAR,ECUTOF,LDMEFI)
C
                  ELSEIF(ITWCEN.EQ.2) THEN
C
                      STOP ' TWO-CENTRE BASIS NOT IMPLMNTD FOR IPNMIX=1'
C
                  END IF
C
              END IF
C
          END IF
C
      END IF
C
C=======================================================================
C        CALCULATING VARIOUS SINGLE-PARTICLE AVERAGES
C=======================================================================
C=======================================================================
C        SEE COMMENTS TO THE PREVIOUS CALL TO AVANGY
C=======================================================================
C
      IF((ISIMPY.EQ.1.AND.IFLIPI.NE.0)                              .OR.
     *
     *   (ISIMPY.EQ.1.AND.ISIGNY.EQ.1.AND.(NOMLIG(0,0       ).NE.0  .OR.
     *                                     NOMLIG(0,1       ).NE.0  .OR.
     *                                     NOMLIG(1,0       ).NE.0  .OR.
     *                                     NOMLIG(1,1       ).NE.0)).OR.
     *
     *   (ISIMPY.EQ.1.AND.ISIGNY.NE.1.AND.(NOMLIM(  0       ).NE.0  .OR.
     *                                     NOMLIM(  1       ).NE.0)).OR.
     *
     *   (ISIMPY.NE.1.AND.ISIQTY.EQ.1.AND.(NOMLIQ(  0       ).NE.0  .OR.
     *                                     NOMLIQ(  1       ).NE.0)).OR.
     *
     *   (ISIMPY.NE.1.AND.ISIQTY.NE.1.AND.(NOMLIZ            .NE.0)).OR.
     *
     *    IS_CON.EQ.1                                               .OR.
     *
     *    IS_PIN.EQ.1                                               .OR.
     *
     *    IS_CHA.EQ.1                                               .OR.
     *
     *    TERMNT                                                    .OR.
     *
     *    PRINIT)                                                   THEN
C
          CALL AVANGY(MREVER,ICHARG,IPNMIX,ISIMPY,ITWCEN)
C
          CALL AVOBSE(MREVER,ICHARG,IPNMIX,NRAORD)
C
          CALL AVISOS(MREVER)
C
      END IF
C
C=======================================================================
C        CALCULATING AND PRINTING SINGLE-PARTICLE AVERAGES
C=======================================================================
C
      CALL AVPARI(MREVER,ICHARG,IPNMIX)
C
      IF (TERMNT.OR.PRINIT) THEN
C
          CALL AVSIMP(MREVER,ICHARG,IPNMIX)
C
          CALL NILAPN(NOSCIL,MREVER,ISIMPY,NILXYZ)
C
      END IF
C
C=======================================================================
C        PRINTING THE SINGLE-PARTICLE SPECTRUM
C=======================================================================
C
      IF (PRINIT) THEN
C
          CALL PNTALL(EMINAL,EMAXAL,SPMODL,NAMEPN,
     *                       ISIGNY,ISIMPY,ISIQTY,
     *                       MREVER,       NILXYZ)
C
      END IF
C
C=======================================================================
C        CALCULATING PAIRING AND DEFINING OCCUPATION FACTORS
C=======================================================================
C
      EPAI_T=0.0
      EREA_T=0.0
      ELIP_T=0.0
C
      IF (IPAIRI.EQ.1) THEN
C
          IF (JPABCS.GT.0) THEN
C
              STOP ' BCS WITH IPNMIX=1 NOT IMPLEMENTED'
C
              IF (JPABCS.EQ.1.OR.
     *           (JPABCS.EQ.3.AND.ITERUN.EQ.1))  THEN
C
                  IF (IAVRGG.NE.1) THEN
C
                     CALL SETPAI(IN_FIX,IZ_FIX,FACTGP,ICHARG,GPAIRP)
C
                  ELSE
C
                     CALL GAVRAG(IN_FIX,IZ_FIX,FACTGP,ICHARG,GPAIRP)
C
                  END IF
C
              END IF
C
              EFEPIN=EFERMA
              CALL DELPAI (ICHARG,MREVER,JPABCS,IA_FIX,ITERUN,
     *                     DELFIA,GPAIRA,EPAI_A,EFERMA,DELTAA)
              EFEPOU=EFERMA
C
              IF (PRINIT)
     *
     *            CALL PAIPRI(NAMEPN,GPAIRP,EPAI_P,EFERMP,DELTAP,
     *                                      LIPKIP,EFER2P,ELIP_P,
     *                                      IPAHFB,JPABCS,IAVRGG,
     *                               IGOGPA,IREGPA,ISEPPA,ICOUPA)
C
          END IF
C
      ELSE
C
          IF (ISIMPY.EQ.1) THEN
C
              IF (ISIGNY.EQ.1) THEN
C
                  CALL CONMIG(MREVER,IN_FIX,IZ_FIX,EFERMA,
     *                                      IPAFLI,IREFLI,
     *                               ISPFLI,ISHFLI,IFLIPI)
              ELSE
C
                  CALL CONMIM(MREVER,IN_FIX,IZ_FIX,EFERMA,
     *                                             IREFLI,
     *                               ISPFLI,ISHFLI,IFLIPI)
C
              END IF
C
          ELSE
C
              IF (ISIQTY.EQ.1) THEN
C
                  CALL CONMIQ(IN_FIX,IZ_FIX,EFERMA,
     *                        IPAFLI,
     *                        ISPFLI,ISHFLI,IFLIPI)
              ELSE
C
                  CALL CONMIZ(IN_FIX,IZ_FIX,EFERMA,
     *                        ISPFLI,ISHFLI,IFLIPI)
C
              END IF
C
          END IF
C
          DELTAN=0.0D0
          DELTAP=0.0D0
          DELTAA=0.0D0
C
      END IF
C
C=======================================================================
C        CALCULATING THE SUM OF SINGLE-PARTICLE ENERGIES
C=======================================================================
C
      IF (IPAHFB.LT.1)
     *
     *    CALL PNENSU(MREVER,ESUM_T,ISIMPY)
C
C=======================================================================
C        CALCULATING THE SUM OF QUASIPARTICLE ENERGIES
C=======================================================================
C
      IF (IPAHFB.GE.1.AND.IQPSTA.EQ.1)
     *
     *    STOP ' FOR IPNMIX=1, IQPSTA=1 NOT YET IMPLEMENTED'
C    *    CALL PNQPSU(MREVER,ESUM_T,EFERMI)
C
C=======================================================================
C
      DO ITPNMX=0,2
C
C=======================================================================
C         ZEROING DENSITIES
C=======================================================================
C
         CALL ZEDENS(ITPNMX)
C
C=======================================================================
C        PREPARING CALCULATION OF DENSITIES AND CURRENTS
C=======================================================================
C
         IF (ITPNMX.EQ.0) THEN
C
             IKERNE=0
             ICHARG=0
             ISAWAV=1
C
         END IF
C
         IF (ITPNMX.EQ.1) THEN
C
             IKERNE=0
             ICHARG=1
             ISAWAV=1
C
         END IF
C
         IF (ITPNMX.EQ.2) THEN
C
             IKERNE=1
             ICHARG=0
             ISAWAV=0
C
C=======================================================================
C         FETCHING THE LEFT  WAVE FUNCTIONS FOR NEUTRONS AND
C         FETCHING THE RIGHT WAVE FUNCTIONS FOR PROTONS
C=======================================================================
C
             IALLOC=0
C
             IF (.NOT.ALLOCATED(WALEFT)) THEN
                 ALLOCATE (WALEFT(1:NDBASE,1:4*NDSTAT,0:NDSPIN),
     *                                                      STAT=IALLOC)
                 IF (IALLOC.NE.0) CALL NOALLO('WALEFT','HFODD ')
             END IF
C
C=======================================================================
C
             WALEFT(:,:,:)=SARIGH(:,:,:,0,1)
             WARIGH(:,:,:)=SARIGH(:,:,:,1,1)
C
         END IF
C
C=======================================================================
C        CALCULATING DENSITIES AND CURRENTS
C=======================================================================
C
         CALL DENSHF(ISIMTX,JSIMTY,ISIMTZ,
     *               ISIGNY,ISIMPY,ISIQTY,IPAHFB,MREVER,ICHARG,
     *                                    MIN_QP,IPNMIX,ITPNMX,
     *                      ITIREP,NAMEPN,PRINIT,IDEVAR,ITERUN,
     *               ISYMDE,INIROT,INIINV,INIKAR,ISAWAV,IKERNE,
     *                                           ITWCEN,1)
C
C=======================================================================
C         DOUBLING SINGLE-PARTICLE RESULTS IN CASE OF NO ROTATION
C=======================================================================
C
         IF (IPAHFB.EQ.0) THEN
C
             IF (MREVER.EQ.0)
     *
     *       CALL DBLING(ITPNMX)
         ELSE
             STOP ' DBLING NOT IMPLEMENTED YET FOR IPAHFB>0'
C
         END IF
C
C=======================================================================
C         COPYING THE DENSITIES FROM THE NP BLOCK INTO THE PN BLOCK
C=======================================================================
C
         IF (ITPNMX.EQ.2) THEN
C
             DE_RHO(1:NDXHRM,1:NDYHRM,1:NDZHRM,3,1:LDTWCE)
     *            =CONJG(DE_RHO(1:NDXHRM,1:NDYHRM,1:NDZHRM,2,1:LDTWCE))
             DE_TAU(1:NDXHRM,1:NDYHRM,1:NDZHRM,3,1:LDTWCE)
     *            =CONJG(DE_TAU(1:NDXHRM,1:NDYHRM,1:NDZHRM,2,1:LDTWCE))
             DE_LPR(1:NDXHRM,1:NDYHRM,1:NDZHRM,3,1:LDTWCE)
     *            =CONJG(DE_LPR(1:NDXHRM,1:NDYHRM,1:NDZHRM,2,1:LDTWCE))
             DE_DIV(1:NDXHRM,1:NDYHRM,1:NDZHRM,3,1:LDTWCE)
     *            =CONJG(DE_DIV(1:NDXHRM,1:NDYHRM,1:NDZHRM,2,1:LDTWCE))
C
             DE_SPI(1:NDXHRM,1:NDYHRM,1:NDZHRM,1:NDKART,3,1:LDTWCE)
     *            =CONJG(DE_SPI(1:NDXHRM,1:NDYHRM,1:NDZHRM,1:NDKART,2
     *                                                      ,1:LDTWCE))
             DE_KIS(1:NDXHRM,1:NDYHRM,1:NDZHRM,1:NDKART,3,1:LDTWCE)
     *            =CONJG(DE_KIS(1:NDXHRM,1:NDYHRM,1:NDZHRM,1:NDKART,2
     *                                                      ,1:LDTWCE))
             DE_GRR(1:NDXHRM,1:NDYHRM,1:NDZHRM,1:NDKART,3,1:LDTWCE)
     *            =CONJG(DE_GRR(1:NDXHRM,1:NDYHRM,1:NDZHRM,1:NDKART,2
     *                                                      ,1:LDTWCE))
             DE_LPS(1:NDXHRM,1:NDYHRM,1:NDZHRM,1:NDKART,3,1:LDTWCE)
     *            =CONJG(DE_LPS(1:NDXHRM,1:NDYHRM,1:NDZHRM,1:NDKART,2
     *                                                      ,1:LDTWCE))
             DE_ROS(1:NDXHRM,1:NDYHRM,1:NDZHRM,1:NDKART,3,1:LDTWCE)
     *            =CONJG(DE_ROS(1:NDXHRM,1:NDYHRM,1:NDZHRM,1:NDKART,2
     *                                                      ,1:LDTWCE))
             DE_ROC(1:NDXHRM,1:NDYHRM,1:NDZHRM,1:NDKART,3,1:LDTWCE)
     *            =CONJG(DE_ROC(1:NDXHRM,1:NDYHRM,1:NDZHRM,1:NDKART,2
     *                                                      ,1:LDTWCE))
             DE_CUR(1:NDXHRM,1:NDYHRM,1:NDZHRM,1:NDKART,3,1:LDTWCE)
     *            =CONJG(DE_CUR(1:NDXHRM,1:NDYHRM,1:NDZHRM,1:NDKART,2
     *                                                      ,1:LDTWCE))
             DE_KIF(1:NDXHRM,1:NDYHRM,1:NDZHRM,1:NDKART,3,1:LDTWCE)
     *            =CONJG(DE_KIF(1:NDXHRM,1:NDYHRM,1:NDZHRM,1:NDKART,2
     *                                                      ,1:LDTWCE))
C
             DE_SCU(1:NDXHRM,1:NDYHRM,1:NDZHRM,1:NDKART,1:NDKART,3,
     *                                                    1:LDTWCE)
     *            = CONJG(DE_SCU(1:NDXHRM,1:NDYHRM,1:NDZHRM,1:NDKART,
     *                                          1:NDKART,2,1:LDTWCE))
             DE_DES(1:NDXHRM,1:NDYHRM,1:NDZHRM,1:NDKART,1:NDKART,3,
     *                                                    1:LDTWCE)
     *            = CONJG(DE_DES(1:NDXHRM,1:NDYHRM,1:NDZHRM,1:NDKART,
     *                                          1:NDKART,2,1:LDTWCE))
C
C        ADD PAIRING DENSITIES !!!!
C
         END IF
C
      END DO
C
C=======================================================================
C
      IF (MREVER.EQ.0) THEN
C
          ESUM_T=2*ESUM_T
C
      END IF
C
C=======================================================================
C        CALCULATING THE   N E U T R O N   D E N S I T Y   M A T R I X
C=======================================================================
C        ATTENTION: FOR THE PROTON-NEUTRON MIXING, COUNTERS:
C                   LDTOTS, LDSTAT, LDUPPE, AND LDTIMU
C                   MUST BE SET AND EQUAL FOR BOTH ICHARG=0 AND ICHARG=1
C=======================================================================
C
      ICHARG=0
      ITPNMX=0
      IKERNE=0
C
      NAMEPN='NEUTRONS'
C
      WALEFT(:,:,:)=SARIGH(:,:,:,ICHARG,1)

      CALL DENMAC(MREVER,ICHARG,ISIMPY,IPAHFB,WALEFT,WALEFT,1)
C
C=======================================================================
C        SAVING  THE   N E U T R O N   D E N S I T Y   M A T R I X
C=======================================================================
C
      IF (I_YUKA.GE.1.OR.I_GOGA.GE.1.OR.I_REGA.GE.1.OR.I_SEPA.GE.1.OR.
     *    I_COUA.GE.1.OR.MAXVAL(I_FSTA).GE.1.OR.MAXVAL(MAG2BC).GE.1.OR.
     *    COR_CM.OR.CORROT.OR.IFRAGM.EQ.1.OR.
     *    JETACM.GE.1.OR.KETA_R.GE.1)
     *
     *    CALL SAVDEN(ISIMPY,ITPNMX)
C
C=======================================================================
C        CALCULATING THE   N E U T R O N   P A I R I N G   T E N S O R
C=======================================================================
C
      IF (MPAHFB.EQ.1.AND.((COR_CM.OR.CORROT).OR.
     *    ICOUPA.GE.1.OR.MAXVAL(IFSTPA).GE.1.OR.
     *    IFRAGM.EQ.1.OR.
C    *    KETAJ2.EQ.1.OR.KETAT2.EQ.1.OR.
     *    IGOGPA.GE.1.OR.IREGPA.GE.1.OR.ISEPPA.GE.1)) THEN
C
          CALL PAIMAC(ICHARG,ISIMPY,WALEFT,WALEFT,IKERNE)
C
          CALL SAVPAI(ISIMPY,ITPNMX)
C
      END IF
C
C=======================================================================
C        CALCULATING THE NEUTRON HFB PAIRING ENERGY AND AVERAGE DELTA
C=======================================================================
C        ATTENTION: PAIRING ENERGIES WITH P-N MIXING NOT FINISHED YET
C=======================================================================
C
      IF (IPAHFB.GE.1)
     *
     *    CALL EPAIRI(IN_FIX,IZ_FIX,ITPNMX,EKEPAI,1)
C
C=======================================================================
C         CALCULATING   D I R E C T   YUKAWA ENERGIES FOR NEUTRONS
C=======================================================================
C
      IF (PRIYUK)
     *
     *    CALL YUKAWD(ISIMPY,ICHARG)
C
C=======================================================================
C        CALCULATING THE   N E U T R O N    K I N E T I C    E N E R G Y
C=======================================================================
C
      CALL EKINET(EKIN_N,DLINSN(0),EKEKIN,DKINSN(0),1)
C
C=======================================================================
C        CALCULATING THE   N E U T R O N    POTENTIAL   HO   E N E R G Y
C=======================================================================
C
      EPOT_N =0.0D0
C
      IF (IPOTHO.EQ.1) THEN
        CALL EPOTHO(EPOT_N)
      END IF
C
C=======================================================================
C        CALCULATING THE   N E U T R O N    M U L T I P O L E    MOMENTS
C=======================================================================
C
      ISHIFY=0
C
      CALL MOMETS(ISIMPY,ISIGNY,ISIQTY,QMUL_N,QMUT_N,
     *                        COMULT,KMULMO,ISHIFY,1)
      CALL MOMSIF(ISIMPY,ISIGNY,ISIQTY,SMUL_N,SMUT_N,
     *                                 COMULT,KMULSI)
      IF (ISCHIF.EQ.1)
     *CALL MOMSCH(SMUL_N,SMUT_N,KMULSI,QMUL_N,QMUT_N,KMULMO)
      CALL MOMVMU(ISIMPY,VMUL_N,COMULT,KMULSI)
      IF (IDOPLM.EQ.1)
     *CALL MOMPLM(ISIMPY,ISIGNY,ISIQTY,PMUL_N,COMULT,KMULSI)
C
      IF (PRINIT.AND.IPRI_N.EQ.1) THEN
C
          CALL MOMPRI(ISIMPY,NAMMUL,NAMHAR,NAMEPN,QMUL_N,KMULMO,'Q')
          IF (KMULSI.GT.0)
     *    CALL MOMPRI(ISIMPY,NAMSIF,NAMHAR,NAMEPN,SMUL_N,KMULSI,'S')
          IF (KMULSI.GT.0.AND.IDOPLM.EQ.1)
     *    CALL MOMPRI(ISIMPY,NAMPLM,NAMHAR,NAMEPN,PMUL_N,KMULSI,'P')
C
      END IF
C
C=======================================================================
C        CALCULATING THE    N E U T R O N     M A G N E T I C    MOMENTS
C=======================================================================
C
      CALL MAGMOM(ISIMPY,IROTAT,ICHARG,AMUL_N,AMUT_N,KMULMA,NMAORD)
C
      IF (PRINIT.AND.IPRI_N.EQ.1) THEN
C
          CALL MAGPRI(IROTAT,NAMMAG,NAMHAR,NAMEPN,AMUL_N,KMULMA,NMAORD,
     *                                                             'M')
C
      END IF
C
C=======================================================================
C        CALCULATING THE    N E U T R O N    S P I N - ASYMMETRY MOMENTS
C=======================================================================
C
      CALL ASMMOM(ISIMPY,IROTAT,WMUL_N,WMUT_N,KMULAS,NASORD)
C
      IF (PRINIT.AND.IPRI_N.EQ.1) THEN
C
          CALL MAGPRI(IROTAT,NAMASM,NAMHAR,NAMEPN,WMUL_N,KMULAS,NASORD,
     *                                                             'A')
C
      END IF
C
C=======================================================================
C        CALCULATING THE   N E U T R O N    R M S    R A D I I
C=======================================================================
C
      CALL RMSQUA(RADI_N,RMSRAN,IN_FIX,NRAORD,ITWCEN)
C
      IF (PRINIT.AND.IPRI_N.EQ.1)
     *
     *    CALL RADPRI(NAMEPN,RADI_N,RMSRAN,NRAORD)
C
C=======================================================================
C        CALCULATING THE   N E U T R O N    D E F O R M A T I O N S
C=======================================================================
C
      IF (PRIBET.AND.IPRI_N.EQ.1)
     *
     *    CALL BOHDEF(ISIMPY,NEXBET,IPRIBE,IPRIBL,NAMHAR,NAMEPN,
     *                              RADI_N,QMUL_N,BMUL_N,KMULMO)
C
C=======================================================================
C        CALCULATING THE   N E U T R O N   S P I N
C=======================================================================
C
      CALL SPIMOM(ISIMPY,IROTAT,ANGU_N,SPIN_N,ITWCEN)
C
C=======================================================================
C        CALCULATING THE   N E U T R O N   L I N E A R   M O M E N T A
C=======================================================================
C
      IF (COR_CM)
     *
     *    CALL LINAVR(ISIMPY,ISIGNY,ISIQTY,
     *                IPAHFB,ICHARG,JETACM,IROTAT,MREVER,COR_CM,IKERNE,
     *                DLINSN,ELINSN,PLINSN,TLINSN,ALINLN,PLINLN,PLINKN,
     *                DKINSN,EKINSN,PKINSN,TKINSN,AKINLN,PKINLN,PKINKN)
C
C=======================================================================
C        CALCULATING THE   N E U T R O N   A N G U L A R   M O M E N T A
C=======================================================================
C
C     IF (CORROT.OR.KETAJ2.EQ.1)
      IF (CORROT)
     *
     *    CALL ROTAVR(ISIMPY,ISIGNY,ISIQTY,
     *                IPAHFB,ICHARG,KETA_R,IROTAT,MREVER,CORROT,IKERNE,
     *                DROTSN,EROTSN,PROTSN,TROTSN,AROTLN,PROTLN,PROTKN,
     *                DKOTSN,EKOTSN,PKOTSN,TKOTSN,AKOTLN,PKOTLN,PKOTKN)
C
C=======================================================================
C        CALCULATING THE  P R O T O N   D E N S I T Y   M A T R I X
C=======================================================================
C        ATTENTION: FOR THE PROTON-NEUTRON MIXING, COUNTERS:
C                   LDTOTS, LDSTAT, LDUPPE, AND LDTIMU
C                   MUST BE SET AND EQUAL FOR BOTH ICHARG=0 AND ICHARG=1
C=======================================================================
C
      ICHARG=1
      ITPNMX=1
      IKERNE=0
C
      NAMEPN=' PROTONS'
C
      WARIGH(:,:,:)=SARIGH(:,:,:,ICHARG,1)

C=======================================================================
      CALL DENMAC(MREVER,ICHARG,ISIMPY,IPAHFB,WARIGH,WARIGH,1)
C
C=======================================================================
C        SAVING  THE    P R O T O N    D E N S I T Y   M A T R I X
C=======================================================================
C
      IF (I_YUKA.GE.1.OR.I_GOGA.GE.1.OR.I_REGA.GE.1.OR.I_SEPA.GE.1.OR.
     *    I_COUA.GE.1.OR.MAXVAL(I_FSTA).GE.1.OR.MAXVAL(MAG2BC).GE.1.OR.
     *    ICOUDI.EQ.2.OR.ICOUEX.EQ.2.OR.
     *    COR_CM.OR.CORROT.OR.IFRAGM.EQ.1.OR.
     *    JETACM.GE.1.OR.KETA_R.GE.1)
     *
     *    CALL SAVDEN(ISIMPY,ITPNMX)
C
C=======================================================================
C        CALCULATING THE   P R O T O N S   P A I R I N G   T E N S O R
C=======================================================================
C
      IF (MPAHFB.EQ.1.AND.((COR_CM.OR.CORROT).OR.
     *    ICOUPA.GE.1.OR.MAXVAL(IFSTPA).GE.1.OR.
     *    IFRAGM.EQ.1.OR.
C    *    KETAJ2.EQ.1.OR.KETAT2.EQ.1.OR.
     *    IGOGPA.GE.1.OR.IREGPA.GE.1.OR.ISEPPA.GE.1)) THEN
C
          CALL PAIMAC(ICHARG,ISIMPY,WARIGH,WARIGH,IKERNE)
C
          CALL SAVPAI(ISIMPY,ITPNMX)
C
      END IF
C
C=======================================================================
C         CALCULATING   D I R E C T   YUKAWA ENERGIES FOR PROTONS
C=======================================================================
C
      IF (PRIYUK)
     *
     *    CALL YUKAWD(ISIMPY,ICHARG)
C
C=======================================================================
C        CALCULATING THE   P R O T O N     K I N E T I C     E N E R G Y
C=======================================================================
C
      CALL EKINET(EKIN_P,DLINSP(0),EKEKIN,DKINSP(0),1)
C
C=======================================================================
C        CALCULATING THE   P R O T O N      POTENTIAL   HO   E N E R G Y
C=======================================================================
C
      EPOT_P =0.0D0
C
      IF (IPOTHO.EQ.1) THEN
        CALL EPOTHO(EPOT_P)
      END IF
C
C=======================================================================
C        CALCULATING THE   P R O T O N     M U L T I P O L E     MOMENTS
C=======================================================================
C
      ISHIFY=0
C
      CALL MOMETS(ISIMPY,ISIGNY,ISIQTY,QMUL_P,QMUT_P,
     *                        COMULT,KMULMO,ISHIFY,1)
      CALL MOMSIF(ISIMPY,ISIGNY,ISIQTY,SMUL_P,SMUT_P,
     *                                 COMULT,KMULSI)
      IF (ISCHIF.EQ.1)
     *CALL MOMSCH(SMUL_P,SMUT_P,KMULSI,QMUL_P,QMUT_P,KMULMO)
      CALL MOMVMU(ISIMPY,VMUL_P,COMULT,KMULSI)
      IF (IDOPLM.EQ.1)
     *CALL MOMPLM(ISIMPY,ISIGNY,ISIQTY,PMUL_P,COMULT,KMULSI)
C
      IF (PRINIT.AND.IPRI_P.EQ.1) THEN
C
          CALL MOMPRI(ISIMPY,NAMMUL,NAMHAR,NAMEPN,QMUL_P,KMULMO,'Q')
          IF (KMULSI.GT.0)
     *    CALL MOMPRI(ISIMPY,NAMSIF,NAMHAR,NAMEPN,SMUL_P,KMULSI,'S')
          IF (KMULSI.GT.0.AND.IDOPLM.EQ.1)
     *    CALL MOMPRI(ISIMPY,NAMPLM,NAMHAR,NAMEPN,PMUL_P,KMULSI,'P')
C
      END IF
C
C      From now on, proton multipole moments have been computed and
C      are available for the Coulomb INTCOU() routine
      ISQPRO=1
C
C=======================================================================
C        CALCULATING THE   P R O T O N   M A G N E T I C   M O M E N T S
C=======================================================================
C
      CALL MAGMOM(ISIMPY,IROTAT,ICHARG,AMUL_P,AMUT_P,KMULMA,NMAORD)
C
      IF (PRINIT.AND.IPRI_P.EQ.1) THEN
C
          CALL MAGPRI(IROTAT,NAMMAG,NAMHAR,NAMEPN,AMUL_P,KMULMA,NMAORD,
     *                                                             'M')
C
      END IF
C
C=======================================================================
C        CALCULATING THE     P R O T O N     S P I N - ASYMMETRY MOMENTS
C=======================================================================
C
      CALL ASMMOM(ISIMPY,IROTAT,WMUL_P,WMUT_P,KMULAS,NASORD)
C
      IF (PRINIT.AND.IPRI_N.EQ.1) THEN
C
          CALL MAGPRI(IROTAT,NAMASM,NAMHAR,NAMEPN,WMUL_P,KMULAS,NASORD,
     *                                                             'A')
C
      END IF
C
C=======================================================================
C         CALCULATING   P R O T O N    R M S    R A D I I
C=======================================================================
C
      CALL RMSQUA(RADI_P,RMSRAP,IZ_FIX,NRAORD,ITWCEN)
C
      IF (PRINIT.AND.IPRI_P.EQ.1)
     *
     *    CALL RADPRI(NAMEPN,RADI_P,RMSRAP,NRAORD)
C
C=======================================================================
C        CALCULATING THE   P R O T O N    D E F O R M A T I O N S
C=======================================================================
C
      IF (PRIBET.AND.IPRI_P.EQ.1)
     *
     *    CALL BOHDEF(ISIMPY,NEXBET,IPRIBE,IPRIBL,NAMHAR,NAMEPN,
     *                              RADI_P,QMUL_P,BMUL_P,KMULMO)
C
C=======================================================================
C         CALCULATING   P R O T O N   S P I N
C=======================================================================
C
      CALL SPIMOM(ISIMPY,IROTAT,ANGU_P,SPIN_P,ITWCEN)
C
C=======================================================================
C        CALCULATING THE   P R O T O N   L I N E A R   M O M E N T A
C=======================================================================
C
      IF (COR_CM)
     *
     *    CALL LINAVR(ISIMPY,ISIGNY,ISIQTY,
     *                IPAHFB,ICHARG,JETACM,IROTAT,MREVER,COR_CM,IKERNE,
     *                DLINSP,ELINSP,PLINSP,TLINSP,ALINLP,PLINLP,PLINKP,
     *                DKINSP,EKINSP,PKINSP,TKINSP,AKINLP,PKINLP,PKINKP)
C
C=======================================================================
C        CALCULATING THE   P R O T O N   A N G U L A R   M O M E N T A
C=======================================================================
C
C     IF (CORROT.OR.KETAJ2.EQ.1)
      IF (CORROT)
     *
     *    CALL ROTAVR(ISIMPY,ISIGNY,ISIQTY,
     *                IPAHFB,ICHARG,KETA_R,IROTAT,MREVER,CORROT,IKERNE,
     *                DROTSP,EROTSP,PROTSP,TROTSP,AROTLP,PROTLP,PROTKP,
     *                DKOTSP,EKOTSP,PKOTSP,TKOTSP,AKOTLP,PKOTLP,PKOTKP)
C
C=======================================================================
C          CALCULATING   T R U E   CHARGE DENSITY
C=======================================================================
C
      CALL TRUCHD
C
C=======================================================================
C          ZEROING THE COULOMB ENERGIES
C=======================================================================
C
      EKECOD=C_ZERO
      EKECOE=C_ZERO
      EKESCA=C_ZERO
      EKEVEC=C_ZERO
      EKPSCA=C_ZERO
      EKPVEC=C_ZERO
C
C=======================================================================
C          CALCULATING THE DIRECT COULOMB ENERGIES AND FIELDS BY THE
C          GREEN-FUNCTION METHOD
C=======================================================================
C
      IF (ICOUDI.EQ.1) THEN
C
          CALL COUMAT(NUMCOU,BOUCOU,ISIMPY,IKERNE)
C
          CALL COULOD(ISIMPY,EKECOD)
C
      END IF
C
C=======================================================================
C          CALCULATING SLATER EXCHANGE COULOMB ENERGY
C=======================================================================
C
      IF (ICOUEX.EQ.1) THEN
C
          CALL COULOE(EKECOE)
C
      END IF
C
C=======================================================================
C          CALCULATING THE DIRECT, EXCHANGE AND PAIRING COULOMB ENERGIES
C          AND FIELDS BY THE METHOD OF EXPANDING IN GAUSSIANS
C=======================================================================
C
      IF (ICOUDI.EQ.2.OR.ICOUEX.EQ.2.OR.I_COUA.GE.1) THEN
C
          IF (NEWCOU.EQ.0) THEN
C
              CALL COUENE(ISIMPY,
     *                    ICOTYP,ICOUDI,ICOUEX,
     *                                  IDOTHC,
     *                    EKECOD,EKESCA,EKEVEC)
C
          ELSE
C
              CALL CO2ENE(ISIMPY,ICOTYP,ICOUDI,ICOUEX,ICOUPA,
     *                    EKECOD,EKESCA,EKEVEC,ITWCEN,LDTWCE)
C
          END IF
C
          IF (ICOUEX.EQ.2) EKECOE=EKESCA+EKEVEC
C
      END IF
C
      ECOULD=REAL(EKECOD)
      ECOULE=REAL(EKECOE)*COUSCA
      ECOULS=REAL(EKESCA)
      ECOULV=REAL(EKEVEC)
C
C=======================================================================
C        CALCULATING THE NEUTRON-PROTON   D E N S I T Y   M A T R I X
C=======================================================================
C        ATTENTION: FOR THE PROTON-NEUTRON MIXING, COUNTERS:
C                   LDTOTS, LDSTAT, LDUPPE, AND LDTIMU
C                   MUST BE SET AND EQUAL FOR BOTH ICHARG=0 AND ICHARG=1
C=======================================================================
C
      ICHARG=0
      ITPNMX=2
      IKERNE=1
C
      NAMEPN='NEU-PROT'
C
      WALEFT(:,:,:)=SARIGH(:,:,:,0,1)
      WARIGH(:,:,:)=SARIGH(:,:,:,1,1)
C
C=======================================================================
C
      CALL DENMAC(MREVER,ICHARG,ISIMPY,IPAHFB,WALEFT,WARIGH,1)
C
C=======================================================================
C        SAVING  THE  NEUTRON-PROTON   D E N S I T Y   M A T R I X
C=======================================================================
C
      IF (I_YUKA.GE.1.OR.I_GOGA.GE.1.OR.I_REGA.GE.1.OR.I_SEPA.GE.1.OR.
     *    I_COUA.GE.1.OR.MAXVAL(I_FSTA).GE.1.OR.MAXVAL(MAG2BC).GE.1.OR.
     *    ICOUDI.EQ.2.OR.ICOUEX.EQ.2.OR.
     *    COR_CM.OR.CORROT.OR.IFRAGM.EQ.1.OR.
     *    JETACM.GE.1.OR.KETA_R.GE.1)
     *
     *    CALL SAVDEN(ISIMPY,ITPNMX)
C
C=======================================================================
C        CALCULATING THE    NEUTRON-PROTON   P A I R I N G   T E N S O R
C=======================================================================
C
      IF (MPAHFB.EQ.1.AND.((COR_CM.OR.CORROT).OR.
     *    ICOUPA.GE.1.OR.MAXVAL(IFSTPA).GE.1.OR.
     *    IFRAGM.EQ.1.OR.
C    *    KETAJ2.EQ.1.OR.KETAT2.EQ.1.OR.
     *    IGOGPA.GE.1.OR.IREGPA.GE.1.OR.ISEPPA.GE.1)) THEN
C
          CALL PAIMAC(ICHARG,ISIMPY,WALEFT,WARIGH,IKERNE)
C
          CALL SAVPAI(ISIMPY,ITPNMX)
C
      END IF
C
C=======================================================================
C        CALCULATING THE AVERAGE ISOSPINS
C=======================================================================
C
C     CALL AVISP2(MREVER,IN_FIX,IZ_FIX,ISIMPY)
C
      CALL AVISO2(MREVER,IN_FIX,IZ_FIX,ISIMPY)
C
C     CALL AVISOT(QMUT_I)
C
C=======================================================================
C         HERE ENDS THE CALCULATION FOR THE NEUTRON-PROTON MIXING
C=======================================================================
C
 8973 CONTINUE
C
C=======================================================================
C          CALCULATING THE "DIV S" DENSITIES FOR NEUTRONS AND PROTONS
C=======================================================================
C
      CALL SAVDIS
C
C=======================================================================
C          CALCULATING THE  D I R E C T  YUKAWA POTENTIALS
C=======================================================================
C
      IF (I_YUKA.GE.1) THEN
C
       CALL YUKMAT(PIMASS,NUMCOU,BOUCOU,ISIMPY)
C
      END IF
C
C=======================================================================
C          CALCULATING THE DIRECT AND EXCHANGE YUKAWA ENERGIES AND
C          FIELDS
C=======================================================================
C
      IF (I_YUKA.GE.1) THEN
C
          CALL YUKENE(PIMASS,PNMASS,IYUTYP,I_YUKA,YUKAGT,YUKAG0,
     *                                     YUKAG1,YUKAG2,ISIMPY)
C
      END IF
C
C=======================================================================
C          CALCULATING   T R U E   TOTAL DENSITY
C=======================================================================
C
      CALL TRUTOD(ITWCEN,LDTWCE)
C
C=======================================================================
C          CALCULATING  T H E   G O G N Y   E N E R G Y
C=======================================================================
C
      IF (I_GOGA.GE.1.AND.NEWGOG.EQ.0) THEN
C
          CALL GOGENE(I_SLOW,SLOWEV,ISGOGA,I_GOGA,ISIMPY,EKEGOG)
C
      END IF
C
C=======================================================================
C          CALCULATING  T H E   G O G N Y   P A I R I N G   E N E R G Y
C=======================================================================
C
      IF ((IGOGPA.EQ.1.OR.IGOGPA.EQ.2).AND.NEWGOG.EQ.0) THEN
C
          CALL GOGPAI(I_SLOW,SLOWPA,ISGOGP,IGOGPA,ISIMPY,IN_FIX,IZ_FIX)
C
      END IF
C
C=======================================================================
C          CALCULATING  T H E   REGULARIZED-SKYRME OR GOGNY  E N E R G Y
C=======================================================================
C          ATTENTION: A SIMULTANEOUS USE OF REGULARIZED  A  N  D   GOGNY
C                     IS NOT PERMITTED YET
C=======================================================================
C
      IF (I_REGA.GE.1.AND.NEWGOG.EQ.0.OR.
     *    I_GOGA.GE.1.AND.NEWGOG.EQ.1) THEN
C
          CALL REGENE(I_SLOW,SLOWEV,SLOWPA,
     *                I_REGA,IREGPA,ISREGA,ISREGP,
     *                I_GOGA,IGOGPA,ISGOGA,ISGOGP,
     *                N3LORD,ISIMPY,IN_FIX,IZ_FIX,EKEREG,NEWGOG)
C
      END IF
C
C=======================================================================
C          CALCULATING  T H E   SEPARABLE-FORCE   E N E R G Y
C=======================================================================
C
      IF (I_SEPA.GE.1.OR.ISEPPA.GE.1) THEN
C
          IF (IPNMIX.NE.1) THEN
C
           CALL SEPENE(ISSEPA,I_SEPA,SLOWPA,ISSEPP,ISEPPA,
     *                 N3SERD,ISIMPY,IN_FIX,IZ_FIX,EKESEP,
     *                               I_SLOW,SLOWEV,LDPNMX)
C
          ELSE
C
          CALL SEPMIE(ISSEPA,I_SEPA,SLOWPA,ISSEPP,ISEPPA,
     *                N3SERD,ISIMPY,IN_FIX,IZ_FIX,EKESEP,
     *                              I_SLOW,SLOWEV,LDPNMX)
C
          END IF
C
      END IF
C
C=======================================================================
C          CALCULATING THE FINITE-RANGE SPIN-ORBIT AND TENSOR ENERGIES
C=======================================================================
C
      IF (MAXVAL(I_FSTA).GE.1.OR.MAXVAL(IFSTPA).GE.1) THEN
C
          CALL FSTENE(I_SLOW,SLOWEV,ISFSTA,
     *                       SLOWPA,ISFSTP,
     *                       ISIMPY,IN_FIX,IZ_FIX,
     *                       EKEFSO,EKEFTO,EKEFTE)
C
      END IF
C
C@@@ HFBTHO - HFBTHO - HFBTHO - HFBTHO - HFBTHO - HFBTHO - HFBTHO
C=======================================================================
C        BY DEFAULT,  HFODD  INITIALIZES THE  MATRIX OF THE  MEAN-FIELD
C        BY  COMPUTING THE  MATRIX ELEMENTS  OF THE  NILSON  POTENTIAL.
C        IN  HFB  MODE IT  INITIALIZES  THE MATRIX OF THE PAIRING FIELD
C        BY COMPUTING THE MATRIX ELEMENTS OF THE  DELTA-PAIRING  INTER-
C        ACTION, WHICH DEPENDS ON THE ISO-SCALAR DENSITY, AND THEREFORE
C        ON BOTH PROTON AND NEUTRON DENSITIES ON THE GAUSS-HERMITE MESH.
C        WHEN RESTARTING FROM HFBTHO, THESE DENSITIES ARE NOT AVAILABLE:
C        THE COMPUTATION OF  ALL  PAIRING OBSERVABLES MUST THEREFORE BE
C        SHIFTED TO  AFTER  THE NEW ISOSCALAR DENSITY HAS BEEN COMPUTED.
C        THIS ONLY AFFECTS THE  FIRST ITERATION, SEE ALSO COMMENT ABOUT
C        NUMITE EARLIER.
C=======================================================================
C
      IF (IF_THO.GE.1.AND.ITERUN.EQ.1) THEN
C
          CALL THOPAI
C
          NACTIT=NUMITE-2
C
C          Pairing energy and Lipkin-Nogami correction for neutrons
C
          NAMEPN='NEUTRONS'
C
          ICHARG=0
          ITPNMX=0
C
          IF (IPAHFB.GE.1) THEN
              CALL EPAIRI(IN_FIX,IZ_FIX,ITPNMX,EKEPAI,1)
          END IF
C
          IF (LIPKIN.EQ.1) THEN
              EF2NIN=EFER2N
              CALL LIPCOR(GPAIRN,FACTGN,FE2FIN,IF2FIN,I_SLOW,SLOWLI,
     *                                         EFER2N,NACTIT,ICHARG)
              EF2NOU=EFER2N
C
              ELIP_N=-2*EFER2N*DISLIN
C
          END IF
C
          IF (IDEVAR.EQ.1)
     *        CALL GINTER(ICHARG,MREVER,PRHO_N,PRHODN,POWERN)
C
          IF (PRINIT.AND.IPAHFB.GE.1)
     *
     *        CALL PAIPRI(NAMEPN,GPAIRN,EPAI_N,EFERMN,DELTAN,
     *                                  LIPKIN,EFER2N,ELIP_N,
     *                                  IPAHFB,JPABCS,IAVRGG,
     *                           IGOGPA,IREGPA,ISEPPA,ICOUPA)
C
C          Pairing energy and Lipkin-Nogami correction for protons
C
          NAMEPN='PROTONS '
C
          ICHARG=1
          ITPNMX=1
C
          IF (IPAHFB.GE.1) THEN
              CALL EPAIRI(IN_FIX,IZ_FIX,ITPNMX,EKEPAI,1)
          END IF
C
          IF (LIPKIP.EQ.1) THEN
              EF2PIN=EFER2P
              CALL LIPCOR(GPAIRP,FACTGP,FE2FIP,IF2FIP,I_SLOW,SLOWLI,
     *                                         EFER2P,NACTIT,ICHARG)
              EF2POU=EFER2P
C
              ELIP_P=-2*EFER2P*DISLIP
C
          END IF
C
          IF (IDEVAR.EQ.1)
     *        CALL GINTER(ICHARG,MREVER,PRHO_P,PRHODP,POWERP)
C
          IF (PRINIT.AND.IPAHFB.GE.1)
     *
     *        CALL PAIPRI(NAMEPN,GPAIRP,EPAI_P,EFERMP,DELTAP,
     *                                  LIPKIP,EFER2P,ELIP_P,
     *                                  IPAHFB,JPABCS,IAVRGG,
     *                           IGOGPA,IREGPA,ISEPPA,ICOUPA)
C
      END IF
C
C@@@ HFBTHO - HFBTHO - HFBTHO - HFBTHO - HFBTHO - HFBTHO - HFBTHO
C
C=======================================================================
C         CALCULATING THE THREE-BODY-GRADIENT DENSITIES BASED
C         ON THE EV4 SUBROUTINES
C=======================================================================
C
      IF (IGRAIN.EQ.1) CALL TRADEN
C
C=======================================================================
C          CALCULATING  T H E   S K Y R M E   E N E R G Y
C=======================================================================
C
         CALL ESKYRM(ENESKY,ENEVEN,ENEODD,ENREAR,ENE_W0,EEVEW0,EODDW0,
     *                                                  EKESKY,LDPNMX,
     *                                                  IVIPRI,LDTWCE)
C
      IF (IPNMIX.EQ.1)
     *
     *    CALL ESKYNP(ENESKY,ENEVEN,ENEODD,ENREAR,ENE_W0,EEVEW0,
     *                                     EODDW0,EKESKY,LDPNMX)
C
      IF (PRINIT)
     *
     *    CALL PRIFUN(IROTAT,PRIYUK,I_GOGA,IGOGPA,I_REGA,IREGPA,
     *                                     NEWGOG,I_SEPA,ISEPPA,
     *                       JETA_T,JETAPA,IVIPRI,N3LORD,N3SERD)
C
C@@@ NECK - NECK - NECK - NECK - NECK - NECK - NECK - NECK - NECK
C=======================================================================
C          CALCULATING THE NUMBER OF PARTICLES IN THE NECK
C=======================================================================
C
      IF (IFNECK.GE.1) THEN
C
C          We find the position of the neck
          CALL QNFIND(NXHERM,NYHERM,NZHERM,SLOWOD,ITERUN,ISIMPY,
     *                                            ISIGNY,IPARTY)
C
      END IF
C
C@@@ NECK - NECK - NECK - NECK - NECK - NECK - NECK - NECK - NECK
C=======================================================================
C         CALCULATING THE LINEAR CONSTRAINT CORRELATION MATRIX
C=======================================================================
C
      IF (IPAIRI.EQ.1.AND.IPAHFB.GE.1.AND.
     *    ISIMPY.EQ.1.AND.IF_RPA.EQ.1) THEN
C
          CALL QMULCM(COMULT,IBROYD,MIXMAT,SLOWEV,
     *                       SLOWOD,NUMITE,NZMAXX)
C
      END IF
C
C=======================================================================
C         DETERMINING THE LINEAR MIXING FACTORS
C=======================================================================
C
      CALL LINMIX(ITERUN,NUMITE,IPCONT,IWRIOL,TERMNT,IF_THO,
     *                          I_SLOW,SLOWEV,SLOWOD,SLOWPA,
     *                                 XOLDEV,XOLDOD,XOLDPA)
C
C=======================================================================
C         CALCULATING THE FIELDS CORRESPONDING TO SKYRME HAMILTONIAN
C=======================================================================
C         TWO-CENTRE BASIS OPTION: SIXTEEN FIELDS ARE BUILT FROM THE
C         SIXTEEN DENSITIES FROM DENSHF+TWC_MORDEN
C=======================================================================
C
      IF (IBROYD.GE.1.AND.MIXMAT.EQ.0)
     *
     *    CALL SKF_IN(IROTAT)
C
      DO LTWCEN=1,LDTWCE
C
         CALL SKFILD(XOLDEV,XOLDOD,IPNMIX,ITWCEN,LTWCEN)
C
      END DO
C
      IF (IPNMIX.EQ.1)
     *
     *    CALL SKFINP(XOLDEV,XOLDOD,LDPNMX)
C
      IF (IBROYD.GE.1.AND.MIXMAT.EQ.0)
     *
     *    CALL SKF_OU(IROTAT)
C
C=======================================================================
C         CALCULATING THE PAIRING FIELDS
C=======================================================================
C
      IF (IPAHFB.GE.1) THEN
C
          IF (IBROYD.GE.1.AND.MIXMAT.EQ.0)
     *
     *        CALL SKP_IN
C
          DO LTWCEN=1,LDTWCE
C
             CALL SKPAIR(XOLDPA,LTWCEN)
C
          END DO
C
          IF (IBROYD.GE.1.AND.MIXMAT.EQ.0)
     *
     *        CALL SKP_OU
C
      END IF
C
C=======================================================================
C         CALCULATING THE THREE-BODY GRADIENT FIELDS
C         ATTENTION! BOTH P-H AND P-P FIELDS ARE HERE ADDED.
C=======================================================================
C
      IF (IGRAIN.EQ.1) CALL TRAFLD
C
C=======================================================================
C
      IF (IBROYD.GE.1.AND.MIXMAT.EQ.0.AND.
     *  ((NUMITE.GT.2.AND.IF_THO.GE.1).OR.
     *   (NUMITE.GT.0.AND.IF_THO.EQ.0)))
     *
     *    CALL DOBROY_FIELDS(ITERUN,NOFBRO,NSWBRO,ITAKEN,IROTAT,
     *                       IPAHFB,SLOWEV,ESTABN,IF_RPA,LDPNMX)
C
C      After the first iteration, IF_THO flag is not relevant anymore
      IF (ITERUN.EQ.1) IF_THO=0
C
C=======================================================================
C        READING THE NEW DENSITY MATRICES AFTER THE BROYDEN PROCEDURE
C=======================================================================
C            ATTENTION: BETWEEN VERSIONS (2.39Y) AND (2.78), AFTER  CALL
C                       TO "DOBROY", PARAMETERS  "EFER2N"  AND  "EFER2P"
C                       WERE AGAIN SLOWED DOWN WITH PARAMETER  "SLOWLI".
C                       THIS DUPPLICATED THE IDENTICAL SLOWING DOWN THAT
C                       IS PERFORMED IN "LIPCOR", AND THUS HAD AN EFFECT
C                       OF THE FINAL SLOWING DOWN BEING PERFORMED WITH A
C                       FACTOR OF  (2-SLOWLI)*SLOWLI,  WHICH  IS  ALWAYS
C                       LARGER THAN SLOWLI. THIS BUG  WAS  CORRECTED  ON
C                       11/10/2016 IN VERSION (2.78A).
C=======================================================================
C
      IF ((LIPKIN.EQ.1.OR.LIPKIP.EQ.1).AND.IBROYD.GE.1
     *                                .AND.MIXMAT.EQ.0)
     *    CALL LIP_OU(ISIMPY,LIPKIN,LIPKIP,EFER2N,EFER2P)
C
C=======================================================================
C          A D D I N G   THE  PROTON   AND   NEUTRON   CONTRIBUTIONS
C=======================================================================
C
      NAMEPN='   TOTAL'
C
      CALL NPLUSP(IN_FIX,IZ_FIX,IDOPLM,NRAORD,ITWCEN)
C
C=======================================================================
C          PRINTING THE MULTIPOLE CONSTRAINTS FOR THE AUGMENTED
C          LAGRANGE METHOD
C=======================================================================
C
      IF (PRINIT) CALL FINPRI(NMUCON,NSICON,ISCHIF)
C
C=======================================================================
C          PRINTING THE SPIN CONSTRAINTS FOR THE AUGMENTED
C          LAGRANGE METHOD
C=======================================================================
C
      IF (PRINIT) CALL FINSPI
C
C=======================================================================
C          PRINTING THE ISOSPIN CONSTRAINTS FOR THE AUGMENTED
C          LAGRANGE METHOD
C=======================================================================
C
      IF (PRINIT.AND.IPNMIX.EQ.1) CALL FINISO
C
C=======================================================================
C          CALCULATING THE CENTER-OF-MASS COORDINATES. SWITCH "ISHIFT"
C          IS SET TO ISHIFT=1 IF THE SYMMETRY CONDITIONS ALLOW  FOR  A
C          SHIFT BETWEEN THE C-O-M AND LABORATORY FRAMES.
C=======================================================================
C
      CALL COMASS(ISIMPY,ISIGNY,ISIQTY,QMUL_T,KMULMO,ISHIFT)
C
      IF (PRINIT.AND.ISHIFT.EQ.1)
     *
     *    CALL CMSPRI(NAMEPN)
C
C=======================================================================
C          CALCULATING MOMENTS AND RADII IN THE CENTER-OF-MASS FRAME
C=======================================================================
C          ATTENTION!  CALCULATION OF  THE  SCHIFF  MOMENTS  IN  THE
C                      CENTER-OF-MASS FRAME IS  NOT  YET  PROGRAMMED
C                      AND THEREFORE THEY WILL NOT BE LATER PRINTED.
C=======================================================================
C
      CALL SHICOE(KMULMO,KSHIMO,ISHIFT)
      CALL SHIMOM(KMULMO,KSHIMO,ISHIFT)
C
      CALL SHICOE(KMULSI,KSHISI,ISHIFT)
      CALL SHISIF(KMULSI,KSHISI,ISHIFT)
C
      CALL SHIRMS(KMULMO,ISHIFT)
      CALL SHIMAG(KMULMA,KSHIMA,ISHIFT,NOSHIM)
C
C=======================================================================
C          PRINTING THE RESULTS IN THE CENTER-OF-MASS FRAME FOR NEUTRONS
C=======================================================================
C
      IF (PRINIT.AND.IPRI_N.EQ.1) THEN
C
          NAMEPN='NEUTRONS'
C
          IF (ISHIFT.EQ.1.AND.KSHIMO.GT.0) THEN
C
              CALL MOMPRI(ISIMPY,NAMMUL,NAMSHI,NAMEPN,QSHI_N,KSHIMO,'Q')
C
              IF (KMULSI.GT.0.AND.ISCHIF.LT.1)
     *        CALL MOMPRI(ISIMPY,NAMSIF,NAMSHI,NAMEPN,SSHI_N,KMULSI,'S')
C
              IF (PRIBET)
     *        CALL BOHDEF(ISIMPY,NEXBET,IPRIBE,IPRIBL,NAMSHI,NAMEPN,
     *                                  RSHI_N,QSHI_N,BSHI_N,KSHIMO)
          END IF
C
          IF (ISHIFT.EQ.1.AND.NOSHIM.NE.1)
     *
     *        CALL MAGPRI(IROTAT,NAMMAG,NAMSHI,NAMEPN,ASHIXN,KMULMA,0,
     *                                                             'M')
C
          NAMEPN='   TOTAL'
C
      END IF
C
C=======================================================================
C          PRINTING THE RESULTS IN THE CENTER-OF-MASS FRAME FOR PROTONS
C=======================================================================
C
      IF (PRINIT.AND.IPRI_P.EQ.1) THEN
C
          NAMEPN=' PROTONS'
C
          IF (ISHIFT.EQ.1.AND.KSHIMO.GT.0) THEN
C
              NAMEPN=' PROTONS'
              CALL MOMPRI(ISIMPY,NAMMUL,NAMSHI,NAMEPN,QSHI_P,KSHIMO,'Q')
C
              IF (KMULSI.GT.0.AND.ISCHIF.LT.1)
     *        CALL MOMPRI(ISIMPY,NAMSIF,NAMSHI,NAMEPN,SSHI_P,KMULSI,'S')
C
              IF (PRIBET)
     *        CALL BOHDEF(ISIMPY,NEXBET,IPRIBE,IPRIBL,NAMSHI,NAMEPN,
     *                                  RSHI_P,QSHI_P,BSHI_P,KSHIMO)
          END IF
C
          IF (ISHIFT.EQ.1.AND.NOSHIM.NE.1)
     *
     *        CALL MAGPRI(IROTAT,NAMMAG,NAMSHI,NAMEPN,ASHIXP,KMULMA,0,
     *                                                             'M')
C
          NAMEPN='   TOTAL'
C
      END IF
C
C=======================================================================
C     CALCULATING THE EULER ANGLES OF THE PRINCIPAL-AXES FRAME. THEY ARE
C     DETERMINED IRRESPECTIVE OF ANY SYMMETRY CONDITIONS,  BECAUSE  EVEN
C     IN THE SIGNATURE/PARITY CASE, THE INTRINSIC FRAME CAN DIFFER  FROM
C     THE LABORATORY FRAME DUE TO THE BRINGING OF THE INTRINSIC FRAME TO
C     THE FIRST SECTOR OF BOHR'S VARIABLE 0<=GAMMA<=60. BECAUSE  OF  THE
C     SAME REASON, ALL MOMENTS IN THE INTRINSIC FRAME ARE ALWAYS PRINTED
C     UNLESS THE INPUT DATA SWITCH INTRIP=0 IS SET.
C=======================================================================
C
      CALL EULROT(KSHIMO,KROTMO)
C
      IF (PRINIT) CALL EULPRI(NAMEPN)
C
C=======================================================================
C          CALCULATING MULTIPOLE MOMENTS IN THE PRINCIPAL-AXES FRAME
C=======================================================================
C
      CALL PAXMOM(KSHIMO,KROTMO,QUNITS,QSHI_N,QSHI_P,QSHI_T,
     *            ALPEUL,BETEUL,GAMEUL,QROT_N,QROT_P,QROT_T)
      CALL PAXMOM(KSHISI,KROTSI,SUNITS,SSHI_N,SSHI_P,SSHI_T,
     *            ALPEUL,BETEUL,GAMEUL,SROTNN,SROTNP,SROTNT)
      CALL PAXMOM(KSHIMA,KROTMA,AUNITS,ASHI_N,ASHI_P,ASHI_T,
     *            ALPEUL,BETEUL,GAMEUL,AROTNN,AROTNP,AROTNT)
C
C=======================================================================
C          CALCULATING THE TWO-BODY-CURRENT CONTRIBUTIONS TO THE  DIPOLE
C          MAGNETIC MOMENTS
C=======================================================================
C
      IF (PRINIT.AND.MAXVAL(MAG2BC).GE.1) THEN
C
          CALL ADD2BC(ISIMPY)
C
          AMUL_T(1,-1,0)=AMUL_T(1,-1,0)+REAL(A2BCIN(-1))
     *                                 +REAL(A2BCSA(-1))
          AMUL_T(1, 0,0)=AMUL_T(1, 0,0)+REAL(A2BCIN( 0))
     *                                 +REAL(A2BCSA( 0))
          AMUL_T(1,+1,0)=AMUL_T(1,+1,0)+REAL(A2BCIN(+1))
     *                                 +REAL(A2BCSA(+1))
C
      END IF
C
C=======================================================================
C          THE TRANSFER OF MOMENTS BELOW IS USED FOR PRINTING ONLY
C=======================================================================
C
      AROTXN(:,:,0)=AROTNN(:,:)
      AROTXP(:,:,0)=AROTNP(:,:)
      AROTXT(:,:,0)=AROTNT(:,:)
C
C=======================================================================
C          PRINTING THE RESULTS FOR NUCLEONS
C=======================================================================
C
      IF (PRINIT.AND.IPRI_T.EQ.1) THEN
C
          CALL RADPRI(NAMEPN,RADI_T,RMSRAT,NRAORD)
C
          CALL MOMPRI(ISIMPY,NAMMUL,NAMHAR,NAMEPN,QMUL_T,KMULMO,'Q')
C
          IF (KMULSI.GT.0)
     *    CALL MOMPRI(ISIMPY,NAMSIF,NAMHAR,NAMEPN,SMUL_T,KMULSI,'S')
          IF (KMULSI.GT.0.AND.IDOPLM.EQ.1)
     *    CALL MOMPRI(ISIMPY,NAMPLM,NAMHAR,NAMEPN,PMUL_T,KMULSI,'P')
C
          CALL MAGPRI(IROTAT,NAMMAG,NAMHAR,NAMEPN,AMUL_T,KMULMA,NMAORD,
     *                                                             'M')
C
          CALL TBCPRI
C
          CALL MAGPRI(IROTAT,NAMASM,NAMHAR,NAMEPN,WMUL_T,KMULAS,NASORD,
     *                                                             'A')
C
          IF (PRIBET.OR.IWRIBA.NE.-1)
     *    CALL BOHDEF(ISIMPY,NEXBET,IPRIBE,IPRIBL,NAMHAR,NAMEPN,
     *                              RADI_T,QMUL_T,BMUL_T,KMULMO)
C
          IF (ISHIFT.EQ.1.AND.KSHIMO.GT.0) THEN
C
              CALL MOMPRI(ISIMPY,NAMMUL,NAMSHI,NAMEPN,QSHI_T,KSHIMO,'Q')
C
              IF (KMULSI.GT.0.AND.ISCHIF.LT.1)
     *        CALL MOMPRI(ISIMPY,NAMSIF,NAMSHI,NAMEPN,SSHI_T,KMULSI,'S')
C
              IF (PRIBET)
     *        CALL BOHDEF(ISIMPY,NEXBET,IPRIBE,IPRIBL,NAMSHI,NAMEPN,
     *                                  RSHI_T,QSHI_T,BSHI_T,KSHIMO)
          END IF
C
          IF (ISHIFT.EQ.1.AND.NOSHIM.NE.1)
     *
     *        CALL MAGPRI(IROTAT,NAMMAG,NAMSHI,NAMEPN,ASHIXT,KMULMA,0,
     *                                                             'M')
C
          IF (KROTMO.GT.0.AND.INTRIP.NE.0) THEN
C
C=======================================================================
C         HERE WE ENFORCE PRINTING ALL COMPONENTS OF THE ROTATED MOMENTS
C=======================================================================
C
              ISIMPP=0
C
              CALL MOMPRI(ISIMPP,NAMMUL,NAMROT,NAMEPN,QROT_T,KROTMO,'Q')
C
              IF (KMULSI.GT.0.AND.ISCHIF.LT.1)
     *        CALL MOMPRI(ISIMPP,NAMSIF,NAMROT,NAMEPN,SROTNT,KMULSI,'S')
C
              IF (PRIBET)
     *        CALL BOHDEF(ISIMPP,NEXBET,IPRIBE,IPRIBL,NAMROT,NAMEPN,
     *                                  RSHI_T,QROT_T,BROT_T,KROTMO)
          END IF
C
          IF (NOSHIM.NE.1.AND.INTRIP.NE.0)
     *        CALL MAGPRI(IROTAT,NAMMAG,NAMROT,NAMEPN,AROTXT,KMULMA,0,
     *                                                             'M')
C
          IF (COR_CM.OR.
     *       (IROTAT.EQ.1.AND.((ISIMPY.EQ.1.AND.ISIGNY.NE.1).OR.
     *                         (ISIMPY.NE.1.AND.ISIQTY.NE.1)))) THEN
C
              CALL LINPRI(NAMEPN,COR_CM,ALINLT,TLINST(0))
C
          END IF
C
          IF (CORROT) THEN
C
              CALL ROTPRI(NAMEPN,CORROT,AROTLT,TROTST)
C
          END IF
C
          IF (IPNMIX.EQ.1) THEN
C
              CALL ISOPRI
C
          END IF
C
      END IF
C
      IF (PRINIT) THEN
C
          IF (IROTAT.EQ.1) THEN
C
C=======================================================================
C           CALCULATING ALL ANGULAR MOMENTA IN THE C-O-M AND INTRINSIC
C           FRAMES.
C=======================================================================
C
              CALL ANGSHI(ALINLN,ANGU_N,ANGS_N)
              CALL ANGSHI(ALINLP,ANGU_P,ANGS_P)
              CALL ANGSHI(ALINLT,ANGU_T,ANGS_T)
C
              CALL ANGROT(ALPEUL,BETEUL,GAMEUL,ANGS_N,ANGS_P,ANGS_T,
     *                                         ANGR_N,ANGR_P,ANGR_T)
              CALL ANGROT(ALPEUL,BETEUL,GAMEUL,SPIN_N,SPIN_P,SPIN_T,
     *                                         SPIR_N,SPIR_P,SPIR_T)
C
              CALL ANGPRI(IMOVAX,ISIMPY,ISHIFT,INTRIP)
C
          END IF
C
C=======================================================================
C         PRINTING THE BLOCKED STATES
C=======================================================================
C
          CALL BLOPRI(SPMODL,ISIGNY,ISIMPY,ISIQTY,NILXYZ)
C
C=======================================================================
C         PRINTING THE CONFIGURATION DATA
C=======================================================================
C      ATTENTION! UP TO VERSION (2.80G), THE CODE PRINTED THE  REQUESTED
C                 AND NOT THE REALIZED CONFIGURATONS, WHICH COULD DIFFER
C                 FROM ONE ANOTHER WHEN DIABATIC BLOCKING WAS ACTIVE. ON
C                 29/04/2017  IN  VERSION  (2.80H),  THE   PRINTING   OF
C                 CONFIGURATONS AFTER DIABATIC BLOCKING WAS IMPLEMENTED.
C                 NOTE HOWEVER, THAT FOR THE PROTON-NEUTRON MIXING,  THE
C                 CORRESPONDING IMPLEMENTATION IS STILL MISSING.
C=======================================================================
C
          IF (IPAIRI.NE.1.OR.MINVAL(KPAHFB).EQ.0) THEN
C
              IF (IPNMIX.NE.1) THEN
C
                  IF (ISIMPY.EQ.1) THEN
C
                      IF (ISIGNY.EQ.1) THEN
C
                          CALL TABSIG(ICHFLI,IPAFLI,IREFLI,
     *                                ISPFLI,ISHFLI,IFLIPI,
     *                                MREVER,IPAIRI,KPAHFB)
                      ELSE
C
                          CALL TABSIM(ICHFLI,       IREFLI,
     *                                ISPFLI,ISHFLI,IFLIPI,
     *                                MREVER,IPAIRI,KPAHFB)
                      END IF
C
                  ELSE
C
                      IF (ISIQTY.EQ.1) THEN
C
                          CALL TABSIQ(ICHFLI,IPAFLI,
     *                                ISPFLI,ISHFLI,IFLIPI,
     *                                       IPAIRI,KPAHFB)
                      ELSE
C
                          CALL TABSIZ(ICHFLI,
     *                                ISPFLI,ISHFLI,IFLIPI,
     *                                       IPAIRI,KPAHFB)
                      END IF
C
                  END IF
C
              ELSE
C
                  IF (ISIMPY.EQ.1) THEN
C
                      IF (ISIGNY.EQ.1) THEN
C
                          CALL TABMIG(MREVER,       IPAFLI,IREFLI,
     *                                       ISPFLI,ISHFLI,IFLIPI)
                      ELSE
C
                          CALL TABMIM(MREVER,       IREFLI,
     *                                ISPFLI,ISHFLI,IFLIPI)
                      END IF
C
                  ELSE
C
                      IF (ISIQTY.EQ.1) THEN
C
                          CALL TABMIQ(IPAFLI,
     *                                ISPFLI,ISHFLI,IFLIPI)
                      ELSE
C
                          CALL TABMIZ(
     *                                ISPFLI,ISHFLI,IFLIPI)
                      END IF
C
                  END IF
C
              END IF
C
          END IF
C
      END IF
C
C=======================================================================
C          C A L C U L A T I N G  MULTIPOLE-CONSTRAINT   E N E R G I E S
C=======================================================================
C
      IF (KMULMO.LT.NMUCON) STOP 'KMULMO.LT.NMUCON IN MAIN HFODD'
C
      CALL QCNTRS(NMUCON,EMULCO,EMUSLO,EMUREA,IF_RPA,ITWCEN)
C
C=======================================================================
C          C A L C U L A T I N G    SURFACE-CONSTRAINT   E N E R G I E S
C=======================================================================
C
      IF (KMULSI.LT.NSICON) STOP 'KMULSI.LT.NSICON IN MAIN HFODD'
C
      CALL SCNTRS(NSICON,ESIFCO,ESISLO,ESIREA)
C
C=======================================================================
C          C A L C U L A T I N G     SPIN-CONSTRAINT     E N E R G I E S
C=======================================================================
C
      CALL ICNTRS(ITILAX,ITISAX,XOLDOD,ESPICO,ESPSLO,ESPREA)
C
C=======================================================================
C          C A L C U L A T I N G   ISOSPIN-CONSTRAINT    E N E R G I E S
C=======================================================================
C
      IF (IPNMIX.EQ.1) CALL TCNTRS(XOLDEV,XOLDOD,EISOCO,EISSLO,EISREA)
C
C=======================================================================
C          C A L C U L A T I N G   THE STABILITY
C=======================================================================
C
      IF (IPNMIX.NE.1) ESUM_T=ESUM_N+ESUM_P
C
      EKIN_T=EKIN_N+EKIN_P
C
      EPOT_T=EPOT_N+EPOT_P
C
      ESIN_T=0.5D0*(ESUM_T+EKIN_T+EPOT_T)
C
C=======================================================================
C          BELOW WE CORRECT FOR THE LIPKIN-NOGAMI ONE-BODY TERM, WHICH
C          IS EQUAL TO -2*LAMBDA2*IDENTITY. THIS TERM MUST BE ADDED TO
C          THE KINETIC-ENERGY OPERATOR. IN THE SUBROUTINE "INTEGH"  IT
C          IS ADDED TO THE MEAN-FIELD OPERATOR. HOWEVER, BELOW WE  USE
C          THE EXPRESSION FOR THE TOTAL ENERGY AS EQUAL TO HALF OF THE
C          SUM OF AVERAGE VALUES OF THE KINETIC-ENERGY AND  MEAN-FIELD
C          OPERATORS. THEREFORE, AT THIS POINT, THE AVERAGE  VALUE  OF
C          THE KINETIC-ENERGY OPERATOR MUST BE CORRECTED BY -LAMBDA2*N
C          WHERE N IS THE NUMBER OF PARTICLES, THAT  IS,  THE TRACE OF
C          THE IDENTITY AND DENSITY MATRIX.
C=======================================================================
C
      IF (LIPKIN.EQ.1) ESIN_T=ESIN_T-EFER2N*PARLIN
      IF (LIPKIP.EQ.1) ESIN_T=ESIN_T-EFER2P*PARLIP
C
C=======================================================================
C
      IF (ILIPON.GE.2) ESIN_T=ESIN_T- LAM2_N*IN_FIX
C
      IF (ILIPON.GE.4) ESIN_T=ESIN_T+ELAM4N
      IF (ILIPON.GE.6) ESIN_T=ESIN_T+ELAM6N
C
      IF (ILIPOP.GE.2) ESIN_T=ESIN_T- LAM2_P*IZ_FIX
C
      IF (ILIPOP.GE.4) ESIN_T=ESIN_T+ELAM4P
      IF (ILIPOP.GE.6) ESIN_T=ESIN_T+ELAM6P
C
C=======================================================================
C
      IF (JETACM.EQ.2) THEN
C
          DO KARTEZ=1,NDKART
C
             ESIN_T=ESIN_T+0.5D0*HBMREN(KARTEZ)*DLINST(KARTEZ)
C
             IF (IPAHFB.GE.1.AND.IQPSTA.NE.1)
     *           ESIN_T=ESIN_T+HBMREN(KARTEZ)*PLINST(KARTEZ)
C
          END DO
C
      END IF
C
      IF (KETA_R.EQ.2) THEN
C
          DO KARTEZ=1,NDKART
C
             ESIN_T=ESIN_T+0.5D0*ROTREN(KARTEZ)*DROTST(KARTEZ)
C
             IF (IPAHFB.GE.1.AND.IQPSTA.NE.1)
     *           ESIN_T=ESIN_T+ROTREN(KARTEZ)*PROTST(KARTEZ)
C
          END DO
C
      END IF
C
      IF (IPNMIX.EQ.1)
     *
     *    ESIN_T=ESIN_T+0.5D0*FERISO(0)*(QMUL_N(0,0)+QMUL_P(0,0))
C
      ECOULT=ECOULD+ECOULE
C
      IF (IGOGPA.GE.1.AND.NEWGOG.EQ.0) THEN
          EPAI_N=EPAI_N+REAL(EGOGSP(0)+EGOGVP(0))
          EPAI_P=EPAI_P+REAL(EGOGSP(1)+EGOGVP(1))
      END IF
      IF (IREGPA.GE.1.OR.(IGOGPA.GE.1.AND.NEWGOG.EQ.1)) THEN
          EPAI_N=EPAI_N+REAL(EREGSP(0)+EREGVP(0))
          EPAI_P=EPAI_P+REAL(EREGSP(1)+EREGVP(1))
      END IF
      IF (ICOUPA.GE.1) THEN
          EPAI_P=EPAI_P+REAL(EKPSCA+EKPVEC)
      END IF
      IF (ISEPPA.GE.1) THEN
          EPAI_N=EPAI_N+REAL(ESEPSP(0)+ESEPVP(0))
          EPAI_P=EPAI_P+REAL(ESEPSP(1)+ESEPVP(1))
      END IF
      IF (MAXVAL(IFSTPA).GE.1) THEN
          EPAI_N=EPAI_N+REAL(EFSOSP(0))+REAL(EFTOSP(0))+REAL(EFTESP(0))
          EPAI_P=EPAI_P+REAL(EFSOSP(1))+REAL(EFTOSP(1))+REAL(EFTESP(1))
      END IF
C
      EPAI_T=EPAI_N+EPAI_P
C
      IF (IGRAIN.EQ.1) EPAI_T=EPAI_T+ETGRAP
C
      EREA_T=EREA_N+EREA_P
C
      ELIP_T=ELIP_N+ELIP_P
C
      ECOREA=0.0D0
      IF (ICOUEX.EQ.1) ECOREA=-ECOULE/3
C
      FTHREE=REAL(E3BEVE+E3BODD)
      IF (IGRAIN.EQ.1) FTHREE=FTHREE+ETGRAF
C
      FFOURB=REAL(E4BEVE+E4BODD)
C
      ETOTSP=ESIN_T-ENREAR-ECOREA-EMUREA-ESIREA
     *      -ESPREA-EISREA-EREA_T-FTHREE/2-FFOURB
C
      IF (IPAHFB.GE.1.AND.IQPSTA.EQ.1) THEN
C
          ETOTSP=ETOTSP-(EPAI3N+EPAI3P)/2-ETGRAP/2-EPAI4N-EPAI4P
C
      ELSE
          ETOTSP=ETOTSP+EPAI_T
C
      ENDIF
C
      IF (ITWCEN.EQ.2) ETOTSP=ETOTSP-ENEFRN-ENEFRP
C
      ETOTFU=ENESKY+EKIN_T+EPOT_T+ECOULT+EPAI_T+FTHREE+FFOURB
     *      +REAL(FR2CBR)+REAL(FS2CBR)+REAL(FR3CBR)+REAL(FS3CBR)
     *      +REAL(FT2CBR)+REAL(FK2CBR)+REAL(FT3CBR)+REAL(FK3CBR)
     *      +REAL(FL2CBR)+REAL(FP2CBR)+REAL(FL3CBR)+REAL(FP3CBR)
     *      +REAL(FC2CBR)+REAL(FJ2CBR)+REAL(FC3CBR)+REAL(FJ3CBR)
C
      IF (I_YUKA.EQ.2.OR.I_YUKA.EQ.3) ETOTFU=ETOTFU+EYUKDT
      IF (I_YUKA.EQ.2.OR.I_YUKA.EQ.4) ETOTFU=ETOTFU+EYUKET
C
      IF ((I_GOGA.EQ.2.OR.I_GOGA.EQ.3).AND.NEWGOG.EQ.0)
     *                                ETOTFU=ETOTFU+EGOGDT
      IF ((I_GOGA.EQ.2.OR.I_GOGA.EQ.4).AND.NEWGOG.EQ.0)
     *                                ETOTFU=ETOTFU+EGOGET
C
      IF ((I_REGA.EQ.2.OR.I_REGA.EQ.3).OR.
     *   ((I_GOGA.EQ.2.OR.I_GOGA.EQ.3).AND.NEWGOG.EQ.1))
     *                                ETOTFU=ETOTFU+EREGDT
      IF ((I_REGA.EQ.2.OR.I_REGA.EQ.4).OR.
     *   ((I_GOGA.EQ.2.OR.I_GOGA.EQ.3).AND.NEWGOG.EQ.1))
     *                                 ETOTFU=ETOTFU+EREGET
C
      IF (I_SEPA.EQ.2.OR.I_SEPA.EQ.3) ETOTFU=ETOTFU+ESEPDT
      IF (I_SEPA.EQ.2.OR.I_SEPA.EQ.4) ETOTFU=ETOTFU+ESEPET
C
      IF (I_FSTA(1).EQ.2.OR.I_FSTA(1).EQ.3) ETOTFU=ETOTFU+EFSODT
      IF (I_FSTA(1).EQ.2.OR.I_FSTA(1).EQ.4) ETOTFU=ETOTFU+EFSOET
C
      IF (I_FSTA(2).EQ.2.OR.I_FSTA(2).EQ.3) ETOTFU=ETOTFU+EFTODT
      IF (I_FSTA(2).EQ.2.OR.I_FSTA(2).EQ.4) ETOTFU=ETOTFU+EFTOET
C
      IF (I_FSTA(3).EQ.2.OR.I_FSTA(3).EQ.3) ETOTFU=ETOTFU+EFTEDT
      IF (I_FSTA(3).EQ.2.OR.I_FSTA(3).EQ.4) ETOTFU=ETOTFU+EFTEET
C
C=======================================================================
C          BELOW WE ADD THE LIPKIN-NOGAMI CORRECTION TO THE TOTAL ENERGY
C          -2*Tr[RHO*(1-RHO)]
C          DENSITY MATRICES RHO THAT DEFINE THE LIPKIN-NOGAMI  TERM  ARE
C          DETERMINED IN SUBROUTINES "CANQUA" AND "CANQUZ". THAT IS  WHY
C          THE CORRESPONDING CORRECTIONS TO  ENERGY  ARE  BASED  ON  THE
C          PARTICLE-NUMBER DISPERSIONS CALCULATED THERE.
C=======================================================================
C
      IF (LIPKIN.EQ.1) ETOTFU=ETOTFU+ELIP_N
      IF (LIPKIP.EQ.1) ETOTFU=ETOTFU+ELIP_P
C
C=======================================================================
C          BELOW WE ADD THE LIPKIN CORRECTION TO THE TOTAL ENERGY
C=======================================================================
C
      IF (ILIPON.EQ.2) ETOTFU=ETOTFU+ELIP2N
C
      IF (ILIPON.EQ.4) ETOTFU=ETOTFU+ELIP4N
C
      IF (ILIPON.EQ.6) ETOTFU=ETOTFU+ELIP6N
C
      IF (ILIPOP.EQ.2) ETOTFU=ETOTFU+ELIP2P
C
      IF (ILIPOP.EQ.4) ETOTFU=ETOTFU+ELIP4P
C
      IF (ILIPOP.EQ.6) ETOTFU=ETOTFU+ELIP6P
C
      ECORCM=0.0D0
C
      IF (COR_CM) THEN
C
          DO KARTEZ=1,NDKART
C
             ECORCM=ECORCM+HBMREN(KARTEZ)*TLINST(KARTEZ)
C
          END DO
C
      END IF
C
      ECOR_R=0.0D0
C
      IF (CORROT) THEN
C
          DO KARTEZ=1,NDKART
C
             ECOR_R=ECOR_R+ROTREN(KARTEZ)*TROTST(KARTEZ)
C
          END DO
C
      END IF
C
      ETOTFU=ETOTFU+ECORCM+ECOR_R
C
      ESTABN=ETOTSP-ETOTFU
C
      IF (JETACM.EQ.1) ESTABN=ESTABN+ECORCM
      IF (KETA_R.EQ.1) ESTABN=ESTABN+ECOR_R
C
C@@@ FISSION - FISSION - FISSION - FISSION - FISSION - FISSION - FISSION
C=======================================================================
C         CALCULATING THE MASSES OF THE LEFT AND RIGHT FRAGMENTS
C         ASSUMING THE NECK IS AT ZPOINT
C=======================================================================
C
      IF (IFRAGM.EQ.1 .AND. TERMNT) THEN
C
#if(USE_MPI==1)
          IF ( NUDATA.EQ.number_batch ) THEN
#endif
C
C          This flag is used in DENSHF to symmetrize (True) or not
C          the Skyrme densities
          do_symmetrize = .False.
C
C          Doing a backup of all HFODD densities, since we will write
C          them on disk afterward
          CALL backup_density()
C
C          Allocating various arrays used to characterize fragments
          CALL allocate_loc(MIN_QP)
C
C          Initializing a bunch of arrays relevant to the localization
C          of qp at T>0
          IF (MIN_QP.EQ.1.AND.IFTEMP.GE.0) THEN
              CALL allocate_qp(NDBASE)
          END IF
C
C          Finding the position of the neck
          CALL QNFIND(NXHERM,NYHERM,NZHERM,SLOWOD,ITERUN,ISIMPY,
     *                                            ISIGNY,IPARTY)
C
C          Computing the auxiliary summation over z, SFACTO(MZ,NZ),
C          in [zN, +\infty[
          ALLOCATE(SFACTO(0:NZMAXX,0:NZMAXX))
          CALL DEFMAS(NZHERM,NZMAXX,Z_NECK,SFACTO)
C
C          Passing some inout variables to fission module
          IF (MIN_QP.EQ.1) THEN
              CALL fission_wrapper(DELTAE,XLOCMX,V2_MIN,ITRMAX,NTHETA)
          END IF
C
C          Computing the mass and charge of the fragments
          CALL RFRAGM(NZHERM,NZMAXX,Z_NECK,RIGMAS,RIGCHA)
C
          ICHARG=0
C
C          Defining the localization of the q.p. (neutrons)
          CALL wave_localization(NZHERM,NZMAXX,Z_NECK,ICHARG,SFACTO)
          CALL print_localization(EFERMN,ICHARG)
C
C          Minimizing the tails of the wave-functions (neutrons)
          IF (MIN_QP.EQ.1) THEN
              CALL minimize_tails(EFERMN,NZHERM,NZMAXX,Z_NECK,ICHARG)
              CALL print_rotation(EFERMN,ICHARG)
          END IF
C
          ICHARG=1
C
C          Defining the localization of the q.p. (protons)
          CALL wave_localization(NZHERM,NZMAXX,Z_NECK,ICHARG,SFACTO)
          CALL print_localization(EFERMP,ICHARG)
C
C          Minimizing the tails of the wave-functions (protons)
          IF (MIN_QP.EQ.1) THEN
              CALL minimize_tails(EFERMP,NZHERM,NZMAXX,Z_NECK,ICHARG)
              CALL print_rotation(EFERMP,ICHARG)
          END IF
C
C          Computes the positions of the centers of mass of the
C          left and right fragments
          CALL center_of_mass(NXHERM,NYHERM,NZHERM,Z_NECK,
     *                                      CENLEF,CENRIG)
C
C          Computing the multipole moments of the fragments
          QLMTOT(:,:,:) = 0.0D0
          QLMPRO(:,:,:) = 0.0D0
          QLMNEU(:,:,:) = 0.0D0
C
          DO LAMBDA=0,NMUPRI
             DO MIU=0,LAMBDA
C
                IF (MIU.EQ.0.OR.(LAMBDA.EQ.2.AND.MIU.EQ.2)) THEN
C
C                    Calculating multipole moments in the intrinsic
C                    frame of each fragment
C
                    I_TYPE=1
C
                    CALL QLMFRA(NXHERM,NYHERM,NZHERM,Z_NECK,LAMBDA,
     *                                           MIU,QLMLEF,QLMRIG,
     *                                               CENLEF,CENRIG,
     *                                                      I_TYPE)
C
                    QLMTOT(LAMBDA,MIU,0) = QLMLEF
                    QLMTOT(LAMBDA,MIU,1) = QLMRIG
C
                    I_TYPE=2
C
                    CALL QLMFRA(NXHERM,NYHERM,NZHERM,Z_NECK,LAMBDA,
     *                                           MIU,QLMLEF,QLMRIG,
     *                                               CENLEF,CENRIG,
     *                                                      I_TYPE)
C
                    QLMPRO(LAMBDA,MIU,0) = QLMLEF
                    QLMPRO(LAMBDA,MIU,1) = QLMRIG
C
C                    Calculating multipole moments in the intrinsic
C                    frame of the compound nucleus (= the original
C                    reference frame)
C
                    I_TYPE=1
                    CEFLEF=0.0D0
C
                    CALL QLMFRA(NXHERM,NYHERM,NZHERM,Z_NECK,LAMBDA,
     *                                           MIU,QLMLEF,QLMRIG,
     *                                               CEFLEF,CEFLEF,
     *                                                      I_TYPE)
C
                    QORTOT(LAMBDA,MIU,0) = QLMLEF
                    QORTOT(LAMBDA,MIU,1) = QLMRIG
C
                    I_TYPE=2
C
                    CALL QLMFRA(NXHERM,NYHERM,NZHERM,Z_NECK,LAMBDA,
     *                                           MIU,QLMLEF,QLMRIG,
     *                                               CEFLEF,CEFLEF,
     *                                                      I_TYPE)
C
                    QORPRO(LAMBDA,MIU,0) = QLMLEF
                    QORPRO(LAMBDA,MIU,1) = QLMRIG
C
                END IF
C
             END DO
          END DO
C
          ! Artificially enforces the calculation of the density in
          ! full space because densities for the fragments may have
          ! arbitrary symmetries (or lack thereof)
          IGOGNY=2
C
C          Computes the nuclear and Coulomb energies of the fragments,
C          and the interaction energy between the fragments
C          Note: proton multipole moments for the fragments are necessary
C                to evaluate the Coulomb energy and interaction energy.
C
          CALL interaction_energy_total(ICOUDI,ICOUEX,I_YUKA,NXHERM,
     *                                  NYHERM,NZHERM,ISIMTX,JSIMTY,
     *                                  ISIMTZ,ISIGNY,ISIMPY,ISIQTY,
     *                                  IPAHFB,MREVER,IGOGNY,IGOGPA,
     *                                  NAMEPN,PRINIT,IDEVAR,ITERUN,
     *                                  ISYMDE,INIROT,INIINV,INIKAR,
     *                                  ISAWAV,IKERNE,NUMCOU,BOUCOU,
     *                                  IN_FIX,IZ_FIX,IPAIRI,JETACM,
     *                                  IROTAT,EFERMN,EFERMP,INDJOB,
     *                                  IDEALL,IDELOC,IDECON,IPNMIX,
     *                                  ITIREP,MIN_QP,I_REGA)
     *
C
C          Computing the distance between the 2 fragments (rather, their
C          respective centers of mass)
          DISFRA = ABS(CENRIG - CENLEF)
C
C          Printing out the mass, charge and deformations of the
C          fragments
          CALL PRIFRA(IN_FIX,IZ_FIX,Z_NECK,Q_NECK,RIGMAS,RIGCHA,
     *                              QLMTOT,QORTOT,DISFRA,NMUPRI)
C
C          Restoring the localization flag so as to take all q.p.
          F_FLAG(:,:,:)=1.0D0
C
          DEALLOCATE(SFACTO)
C
C          Deallocating arrays relevant to the localization of qp at T>0
          IF (MIN_QP.EQ.1.AND.IFTEMP.GE.0) THEN
              CALL deallocate_qp()
          END IF
C
C          Deallocating arrays used to characterize fragments
          CALL deallocate_loc(MIN_QP)
C
C          Restoring all HFODD densities from the backup copy
          CALL restore_density()
C
C          Restore the symmetrization flag to True (default)
          do_symmetrize = .True.
C
#if(USE_MPI==1)
      END IF
#endif
      END IF
C
C@@@ FISSION - FISSION - FISSION - FISSION - FISSION - FISSION - FISSION
C@@@ SHELL - SHELL - SHELL - SHELL - SHELL - SHELL - SHELL
C=======================================================================
C         CALCULATING THE SHELL CORRECTIONS FROM THE EQUIVALENT
C         SIGNLE-PARTICLE SPECTRUM
C=======================================================================
C
      IF (IFSHEL.EQ.1 .AND. TERMNT) THEN
C
          DO I=1,NDNUCL
             DSHELN(I)=0.0D0
             DSHELP(I)=0.0D0
          END DO
C
          IN_LOW=IN_FIX
          NOSTPN=1
          INSTEP=2
C
          IZ_LOW=IZ_FIX
          NOSTPZ=1
          IZSTEP=2
C
          CALL WSHELL(IN_FIX,IZ_FIX,IFSHEL,MREVER,IPAHFB,IMFHFB,
     *                IZ_LOW,NOSTPZ,IZSTEP,IN_LOW,NOSTPN,INSTEP,
     *                       IZNUCL,INNUCL,LDNUCL,DSHELP,DSHELN,
     *                                     EFERMP,EFERMN,NDBASE)
C
          IF (IPAHFB.EQ.0) THEN
              WRITE(NFIPRI,'(79(''*''),/,''*'',77X,''*'',/,
     *          ''*      SHELL CORRECTION (BASED ON HARTREE-FOCK'',
     *          '' SINGLE-PARTICLE ENERGIES)      *'')')
          END IF
          IF (IPAHFB.EQ.1) THEN
              IF (IMFHFB.EQ.0) THEN
                  WRITE(NFIPRI,'(79(''*''),/,''*'',77X,''*'',/,
     *          ''*           SHELL CORRECTION (BASED ON HFB'',
     *          '' EQUIVALENT SPECTRUM)               *'')')
              END IF
              IF (IMFHFB.EQ.1) THEN
                  WRITE(NFIPRI,'(79(''*''),/,''*'',77X,''*'',/,
     *          ''*           SHELL CORRECTION (BASED ON HFB'',
     *          '' CANONICAL SPECTRUM)                *'')')
              END IF
          END IF
C
          WRITE(NFIPRI,'(''*'',77X,''*'',/,
     *          ''*  SHELL CORR. - NEUTRONS:  '',F9.4,41X,
     *          ''*'',/,''*  SHELL CORR. - PROTONS :  '',
     *                F9.4,41X,''*'',/,''*'',77X,''*'')')
     *
     *              DSHELN(1),DSHELP(1)
C
      END IF
C
C=======================================================================
C   NICOLA: CALCULATION OF THE KINETIC ENERGY EIGENVALUES
C=======================================================================
C
      IF (IFSHEL.EQ.2.AND.TERMNT) THEN
C
          ISHELL=2
C
          DO I=1,NDNUCL
             DSHELN(I)=0.0D0
             DSHELP(I)=0.0D0
          END DO
C
          IN_LOW=IN_FIX
          NOSTPN=1
          INSTEP=2
C
          IZ_LOW=IZ_FIX
          NOSTPZ=1
          IZSTEP=2
C
          IF (ISIMPY.EQ.1) THEN
C
              CALL KINSIG(NUMCOU,BOUCOU,IKERNE,ISIMPY,ISIGNY,ISIQTY,
     *                    0,KMULMO,ISHIFY,MREVER)
C
              CALL KINSIG(NUMCOU,BOUCOU,IKERNE,ISIMPY,ISIGNY,ISIQTY,
     *                    1,KMULMO,ISHIFY,MREVER)
C
          ELSE
C
              CALL KINSIZ(NUMCOU,BOUCOU,IKERNE,ISIMPY,ISIGNY,ISIQTY,
     *                    0,KMULMO,ISHIFY0)
C
              CALL KINSIZ(NUMCOU,BOUCOU,IKERNE,ISIMPY,ISIGNY,ISIQTY,
     *                    1,KMULMO,ISHIFY)
C
          END IF
C
          CALL WSHELL(IN_FIX,IZ_FIX,IFSHEL,MREVER,IPAHFB,IMFHFB,
     *                IZ_LOW,NOSTPZ,IZSTEP,IN_LOW,NOSTPN,INSTEP,
     *                       IZNUCL,INNUCL,LDNUCL,DSHELP,DSHELN,
     *                                     EFERMP,EFERMN,NDBASE)
C
          IF (IPAHFB.EQ.0) THEN
              WRITE(NFIPRI,'(79(''*''),/,
     *          ''*      SHELL CORRECTION (BASED ON HARTREE-FOCK'',
     *          '' SINGLE-PARTICLE ENERGIES)     *'')')
          END IF
          IF (IPAHFB.EQ.1) THEN
              IF (IMFHFB.EQ.0) THEN
                  WRITE(NFIPRI,'(79(''*''),/,''*'',77X,''*'',/,
     *          ''*           SHELL CORRECTION (BASED ON HFB'',
     *          '' EQUIVALENT SPECTRUM)               *'')')
              END IF
              IF (IMFHFB.EQ.1) THEN
                  WRITE(NFIPRI,'(79(''*''),/,''*'',77X,''*'',/,
     *          ''*           SHELL CORRECTION (BASED ON HFB'',
     *          '' CANONICAL SPECTRUM)                *'')')
              END IF
          END IF
C
          WRITE(NFIPRI,'(''*'',77X,''*'',/,
     *          ''*  SHELL CORR. - NEUTRONS:  '',F9.4,41X,
     *          ''*'',/,''*  SHELL CORR. - PROTONS :  '',
     *                F9.4,41X,''*'')')
     *
     *              DSHELN(1),DSHELP(1)
C
      END IF
C
C@@@ SHELL -SHELL - SHELL - SHELL - SHELL - SHELL - SHELL
C=======================================================================
C         P R I N T I N G   T H E    E N E R G I E S
C=======================================================================
C
      IF (PRINIT) THEN
C
          CALL PRIENE(JETACM,KETA_R,IPOTHO,I_YUKA,I_GOGA,IGOGPA,
     *                                            I_REGA,IREGPA,
     *                                            I_SEPA,ISEPPA,
     *                                                   ICOUPA,
     *                                            LIPKIN,LIPKIP,
     *                                                   NEWGOG,
     *                                                   ICOUEX,
     *                                                   JETA_T)
C
          IF (TERMNT) THEN
              IF (IPAHFB.GE.1.AND.ISIMPY.EQ.1.AND.IFTEMP.EQ.1) THEN
                  CALL PRI_FT()
              END IF
          END IF
C
          IF (ITWCEN.EQ.2) CALL TWC_PRIFRA(KMULMO)
C
      END IF
C
C=======================================================================
C         S T O R I N G   T H E   C O N V E R G E N C E   R E P O R T
C=======================================================================
C
      IF (ITERUN.LE.NDITER+1) THEN
C
          ETOTFI(ITERUN)=ETOTFU
          ETOTSI(ITERUN)=ETOTSP
          ESTABI(ITERUN)=ESTABN
          QUA20I(ITERUN)=QMUL_T(2,0)
          QUA22I(ITERUN)=QMUL_T(2,2)
          ANGUTI(ITERUN)=ANGU_T(2)
C
      ELSE
C
          WRITE(NFIPRI,'(/,1X,19(1H/),
     *          ''  NO PLACE TO STORE ITERATION NO.='',
     *              I5,2X,19(1H/),/)') ITERUN
C
      END IF
C
C=======================================================================
C         SAVING THE WAVE FUNCTIONS FOR CALCULATION OF THE GCM KERNELS
C=======================================================================
C
      IF (TERMNT.AND.IWRWAV.EQ.1) THEN
C
          IWRBLO=1
C
C=======================================================================
C         ATTENTION: BETWEEN VERSIONS (3.11A) AND  (3.15H), THE ARGUMENT
C                    "ISIMPY" WAS NOT TRANSFERRED TO SUBROUTINE "SAVEWF"
C                    THIS  BUG  WAS  CORRECTED  IN  VERSION  (3.15I)  ON
C                    05/11/2022.
C=======================================================================
C
          CALL SAVEWF(NFIWAV,ITOWAV,FILWAV,IWRBLO,
     *                                        1,1,
     *                       KPROJE,ISIQTY,ISIMPY,
     *                IDSIQN,IDSIQP,IDSIZN,IDSIZP)
C
      END IF
C
C=======================================================================
C     CALCULATING THE LIPKIN VAPNP PARAMETERS AND CORRESPONDING ENERGY
C     CORRECTION
C=======================================================================
C
      IF (ILIPON.GT.1.OR.ILIPOP.GT.1) THEN
C
          ISAWAV=0
          IKERNE=1
C
          IF (ILIPON.GT.1)
     *        CALL LIPNAP(IN_FIX,ILIPON,GAUSHI,ISIMPY,MREVER,0)
C
          IF (ILIPOP.GT.1)
     *        CALL LIPNAP(IZ_FIX,ILIPOP,GAUSHI,ISIMPY,MREVER,1)
C
          CALL LIPVAP(IN_FIX,IZ_FIX,ILIPON,ILIPOP,
     *                                     GAUSHI,
     *                       ISIMTX,JSIMTY,ISIMTZ,
     *                       ISIGNY,ISIMPY,ISIQTY,
     *                IPAHFB,MREVER,IPNMIX,NUMCOU,
     *                BOUCOU,ICOTYP,ICOUDI,ICOUEX,
     *                                     IDOTHC,
     *                COUSCA,NAMEPN,PRINIT,IDEVAR,
     *                ITERUN,ISYMDE,INIROT,INIINV,
     *                       INIKAR,ISAWAV,IKERNE,
     *                                     MIN_QP,
     *                                     ITWCEN)
C
       END IF
C
C=======================================================================
C         PROJECTING THE ANGULAR MOMENTUM
C=======================================================================
C
      IF (TERMNT.AND.IPRGCM.EQ.1) THEN
C
          IDIAGO=1
          ISAWAV=0
          IKERNE=1
          KONMIX=0
          N_CALL=1
C
          INDBRA=1
          INDKET=1
C
          INLWAV=INLKER
          INRWAV=INRKER
C
          INUWAV=ITOWAV
C
          KPLEFT=KPROJE
C
          NMRMIX=0
          LMRMIX=0
          NMURMI=0
          LMURMI=0
          I_PASS=0
C
          IDIMUR=0
C
          IPROAN=1
C
          CALL PROANG(  IPROAN,
     *                  ISIMTX,JSIMTY,ISIMTZ,
     *                  ISIGNY,ISIMPY,ISIQTY,
     *           IPAHFB,IROTAT,ITIREP,MREVER,
     *                                IPNMIX,
     *                         IDEVAR,ITERUN,
     *                         NMUCOU,ISHIFY,
     *           INLWAV,INRWAV,ICOMIX,EPSMIX,
     *           INDBRA,INDKET,KONMIX,ICMPRI,
     *           IDIAGO,IDIMUR,IPROMI,IPROMA,
     *                  NATKNO,NBTKNO,ISOSTZ,
     *           NPNKNO,NTZKNO,NPAKNO,IPAPRO,
     *           ISOSMI,ISOSMA,EPSISO,ICSKIP,
     *           NUAKNO,NUBKNO,KPROJE,KPLEFT,
     *                  INUWAV,ITOWAV,IWRWAV,
     *           ISAKER,ICHKER,NFIKER,FILKER,
     *           IPAKER,IPAK3D,IPAALL,KFIKER,
     *           NUASTA,NUASTO,NUGSTA,NUGSTO,
     *           NATSTA,NATSTO,NGTSTA,NGTSTO,
     *           NUBSTA,NUBSTO,NUTSTA,NUTSTO,
     *           NMUMAX,NMAMAX,NSIMAX,NASMAX,
     *                         NMAORD,NASORD,
     *    ISCHIF,NMURED,NMARED,NASRED,NSIRED,
     *                  ICUTOV,CUTOVE,CUTOVF,
     *                  IONISH,ISLPRI,ISUPRI,
     *                  IENPRI,ISRPRI,IMIPRI,
     *                  IKEPRI,IRMPRI,IELPRI,
     *                         IWRIRM,NFIRED,
     *           QMUCUT,QMACUT,QASCUT,QSICUT,
     *                         NUMCOU,BOUCOU,
     *                  ICOTYP,ICOUDI,ICOUEX,
     *                                IDOTHC,
     *           ISYMDE,INIROT,INIINV,INIKAR,
     *                         ISAWAV,IKERNE,
     *                                IBETME,
     *                         NFIWAV,FILWAV,
     *                         I_SLOW,SLOWEV,
     *                         NEWGOG,NEWCOU,
     *           I_GOGA,IGOGPA,I_REGA,IREGPA,
     *                         I_SEPA,ISEPPA,
     *                         I_COUA,ICOUPA,
     *                         N3LORD,N3SERD,
     *                         LDPNMX,MIN_QP,
     *                         IN_FIX,IZ_FIX,
     *                  NFIFER,FILFER,N_CALL,
     *                         ISOADD,NBTKNT,
     *                         JETACM,KETA_R,
     *                         KETAJ2,KETAT2,
     *                         IDSIQN,IDSIQP,
     *                         IDSIZN,IDSIZP,
     *    NMRMIX,LMRMIX,NMURMI,LMURMI,I_PASS,
     *                         ISWIND,NUANGU,
     *                         IVIPRI,ITWCEN)
C
      END IF
C
C=======================================================================
C         PROJECTING PARTICLE NUMBERS
C=======================================================================
C
      IF (TERMNT.AND.IPNPRJ.EQ.1) THEN
          CALL PNPROJ(IN_FIX,IZ_FIX,NPPNPN,NPPNPP,
     *                ISIMTX,JSIMTY,ISIMTZ,ISIGNY,ISIMPY,ISIQTY,
     *                                            IPAHFB,MREVER,
     *                                            MIN_QP,IDOTHC,
     *                IPNMIX,NUMCOU,BOUCOU,ICOTYP,ICOUDI,ICOUEX,
     *                COUSCA,NAMEPN,PRINIT,IDEVAR,ITERUN,
     *                ISYMDE,INIROT,INIINV,INIKAR,ISAWAV,EPNPRJ)
      END IF
C
C=======================================================================
C         CALCULATING THE GCM KERNELS (VERSION NO.1, FIXED LEFT STATE)
C=======================================================================
C
      IF (TERMNT.AND.IPRGCM.EQ.2) THEN
C
          IDIAGO=0
          ISAWAV=0
          IKERNE=1
          KONMIX=0
          N_CALL=1
C
          INDBRA=1
          INDKET=1
C
          INLWAV=INLKER
          INRWAV=INRKER
C
          NMRMIX=0
          LMRMIX=0
          NMURMI=0
          LMURMI=0
          I_PASS=0
C
          IDIMUR=0
C
          DO INUWAV=IABS(IFRWAV),ITOWAV
C
             IWRBLO=1
C
             CALL READWF(NFIWAV,INUWAV,FILWAV,IWRBLO,1,1,KPLEFT)
C
             IPROAN=2
C
             CALL PROANG(IPROAN,
     *                   ISIMTX,JSIMTY,ISIMTZ,
     *                   ISIGNY,ISIMPY,ISIQTY,
     *            IPAHFB,IROTAT,ITIREP,MREVER,
     *                                 IPNMIX,
     *                          IDEVAR,ITERUN,
     *                          NMUCOU,ISHIFY,
     *            INLWAV,INRWAV,ICOMIX,EPSMIX,
     *            INDBRA,INDKET,KONMIX,ICMPRI,
     *            IDIAGO,IDIMUR,IPROMI,IPROMA,
     *                   NATKNO,NBTKNO,ISOSTZ,
     *            NPNKNO,NTZKNO,NPAKNO,IPAPRO,
     *            ISOSMI,ISOSMA,EPSISO,ICSKIP,
     *            NUAKNO,NUBKNO,KPROJE,KPLEFT,
     *                   INUWAV,ITOWAV,IWRWAV,
     *            ISAKER,ICHKER,NFIKER,FILKER,
     *            IPAKER,IPAK3D,IPAALL,KFIKER,
     *            NUASTA,NUASTO,NUGSTA,NUGSTO,
     *            NATSTA,NATSTO,NGTSTA,NGTSTO,
     *            NUBSTA,NUBSTO,NUTSTA,NUTSTO,
     *            NMUMAX,NMAMAX,NSIMAX,NASMAX,
     *                          NMAORD,NASORD,
     *     ISCHIF,NMURED,NMARED,NASRED,NSIRED,
     *                   ICUTOV,CUTOVE,CUTOVF,
     *                   IONISH,ISLPRI,ISUPRI,
     *                   IENPRI,ISRPRI,IMIPRI,
     *                   IKEPRI,IRMPRI,IELPRI,
     *                          IWRIRM,NFIRED,
     *            QMUCUT,QMACUT,QASCUT,QSICUT,
     *                          NUMCOU,BOUCOU,
     *                   ICOTYP,ICOUDI,ICOUEX,
     *                                 IDOTHC,
     *            ISYMDE,INIROT,INIINV,INIKAR,
     *                          ISAWAV,IKERNE,
     *                                 IBETME,
     *                          NFIWAV,FILWAV,
     *                          I_SLOW,SLOWEV,
     *                          NEWGOG,NEWCOU,
     *            I_GOGA,IGOGPA,I_REGA,IREGPA,
     *                          I_SEPA,ISEPPA,
     *                          I_COUA,ICOUPA,
     *                          N3LORD,N3SERD,
     *                          LDPNMX,MIN_QP,
     *                          IN_FIX,IZ_FIX,
     *                   NFIFER,FILFER,N_CALL,
     *                          ISOADD,NBTKNT,
     *                          JETACM,KETA_R,
     *                          KETAJ2,KETAT2,
     *                          IDSIQN,IDSIQP,
     *                          IDSIZN,IDSIZP,
     *     NMRMIX,LMRMIX,NMURMI,LMURMI,I_PASS,
     *                          ISWIND,NUANGU,
     *                          IVIPRI,ITWCEN)
C
             IF (IFRWAV.LT.0) GO TO 5555
C
          END DO
C
 5555     CONTINUE
C
      END IF
C
C=======================================================================
C         SETTINGS TO CALCULATE OFF-DIAGONAL KERNELS
C         (VERSION NO.2, ALL LEFT AND RIGHT STATES):
C=======================================================================
C
      IF (TERMNT.AND.IPRGCM.EQ.3) THEN
C
          IDIAGO=0
          ISAWAV=0
          IKERNE=1
          KONMIX=0
          N_CALL=1
C
          KPLEFT=KPROJE
C
          NMRMIX=0
          LMRMIX=0
          NMURMI=0
          LMURMI=0
          I_PASS=0
C
          IDIMUR=0
C
C=======================================================================
C        SETTINGS TO CALCULATE CONFIGURATION MIXING:
C=======================================================================
C
          IF (ICOMIX.EQ.1) THEN
C
              INLMIN=IFRWAV
              INLMAX=ITOWAV
C
              INDBRA=0
              DO INDWAV=IFRWAV,ITOWAV
                 IF (INDWAV.GT.ND_EXC) STOP 'INCREASE ND_EXC'
                 IF (IN_EXC(INDWAV).GT.0) THEN
                    DO INDSTA=1,IN_EXC(INDWAV)
                       INDBRA=INDBRA+1
                       IF (INDBRA.GT.NDCONF) STOP 'INCREASE NDCONF'
                       MIXIND(INDBRA,1)=INDWAV
                       MIXIND(INDBRA,2)=INDSTA
                    END DO
                 END IF
              END DO
C
              MIXDIM=INDBRA
C
              WRITE(*,769)
  769            FORMAT(79(1H*),/,1H*,77X,1H*,/,
     *           1H*,26X,'CONFIGURATION ASSIGNMENT',27X,1H*,/,
     *           1H*,22X,'STATE No',4X,'KERNEL No',4X,
     *                   'EXCIT No',22X,1H*)
C
              DO INDBRA=1,MIXDIM
              WRITE(*,770) INDBRA,MIXIND(INDBRA,1),MIXIND(INDBRA,2)
  770            FORMAT(1H*,22X,I5,7X,I5,8X,I5,25X,1H*)
              END DO
C
          END IF
C
C=======================================================================
C         SETTINGS TO CALCULATE OFF-DIAGONAL KERNELS:
C=======================================================================
C
          IF (ICOMIX.EQ.0) THEN
C
              MIXDIM=1
C
          END IF
C
C=======================================================================
C
          DO INDBRA=1,MIXDIM
C
             IF (ICOMIX.EQ.1) THEN
                INLWAV=MIXIND(INDBRA,1)
                INLSTA=MIXIND(INDBRA,2)
             ELSE
                INLWAV=INLKER
                INLSTA=1
             END IF
C
             CALL REA_WL(NFIWAV,INLWAV,INLSTA,FILWAV,
     *                   ISOMIL,ISOMAL,ISOTZL)
C
             EIGINI(INDBRA)=EIGE_L
C
             WRITE(*,771) INDBRA,INLWAV,INLSTA,ISOMIL,ISOMAL,ISOTZL,
     *                    IIFERL,EIGE_L
  771        FORMAT(1H*,2X,'LEFT  STATE:',7I3,5X,'EBRA =',F12.6,
     *                                                  19X,1H*)
             DO MPROJE=-IIFERL,IIFERL,2
                DO IT=1,IDIM_L
                   C_KT_L(MPROJE,IT,INDBRA)=F_KT_L(MPROJE,IT,0)
                   IF (ICMPRI.GE.2)
     *                WRITE(*,772) MPROJE,IT,F_KT_L(MPROJE,IT,0)
  772                 FORMAT(1H*,14X,2I3,6X,2F16.10,19X,1H*)
                END DO
             END DO
C
             DO INDKET=INDBRA,MIXDIM
C
                IF (ICOMIX.EQ.1) THEN
                   INRWAV=MIXIND(INDKET,1)
                   INRSTA=MIXIND(INDKET,2)
                ELSE
                   INRWAV=INRKER
                   INRSTA=1
                END IF
C
                CALL REA_WR(NFIWAV,INRWAV,INRSTA,FILWAV,
     *                      ISOMIR,ISOMAR,ISOTZR)
C
                WRITE(*,773) INDKET,INRWAV,INRSTA,ISOMIR,ISOMAR,ISOTZR,
     *                       IIFERR,EIGE_R
  773           FORMAT(1H*,2X,'RIGHT STATE:',7I3,5X,'EKET =',F12.6,
     *                                                     19X,1H*)
                IF (ICMPRI.GE.2) THEN
                   DO MPROJE=-IIFERR,IIFERR,2
                      DO IT=1,IDIM_R
                         WRITE(*,772) MPROJE,IT,F_KT_R(MPROJE,IT,0)
                      END DO
                   END DO
                END IF
C=======================================================================
C                      BASIC CROSS-CHECKS OF INPUT DATA
C=======================================================================
                IF (IIFERL.NE.IIFERR.OR.IIFERL.NE.IIFERR) THEN
                   WRITE(*,774) IIFERL,IIFERR,IIFERR
  774              FORMAT(1H*,12X,'STOP: IIFERL.NE.IIFERR',
     *                            '  OR  IIFERL.NE.IIFERR',3I3,12X,1H*)
                   STOP
                END IF
C
                IF (ISOMIL.NE.ISOMIR.OR.ISOMIL.NE.ISOSMI) THEN
                   WRITE(*,775) ISOMIL,ISOMIR,ISOSMI
  775              FORMAT(1H*,12X,'STOP: ISOMIL.NE.ISOMIR',
     *                            '  OR  ISOMIL.NE.ISOSMI',3I3,12X,1H*)
                   STOP
                END IF
C
                IF (ISOMAL.NE.ISOMAR.OR.ISOMAL.NE.ISOSMA) THEN
                   WRITE(*,776) ISOMAL,ISOMAR,ISOSMA
  776              FORMAT(1H*,12X,'STOP: ISOMAL.NE.ISOMAR',
     *                            '  OR  ISOMAL.NE.ISOSMA',3I3,12X,1H*)
                   STOP
                END IF
C
                IF (ISOTZL.NE.ISOTZR.OR.ISOTZL.NE.ISOSTZ) THEN
                   WRITE(*,777) ISOTZL,ISOTZR,ISOSTZ
  777              FORMAT(1H*,12X,'STOP: ISOTZL.NE.ISOTZR',
     *                            '  OR  ISOTZL.NE.ISOSTZ',3I3,12X,1H*)
                   STOP
                END IF
C=======================================================================
C
                WRITE(*,778)
  778           FORMAT(1H*,77(1H*),1H*)
C
                IF (ICOMIX.EQ.1.AND.INDBRA.EQ.MIXDIM
     *                         .AND.INDKET.EQ.MIXDIM) KONMIX=1
C
                IPROAN=3
C
                CALL PROANG(IPROAN,
     *                      ISIMTX,JSIMTY,ISIMTZ,
     *                      ISIGNY,ISIMPY,ISIQTY,
     *               IPAHFB,IROTAT,ITIREP,MREVER,
     *                                    IPNMIX,
     *                             IDEVAR,ITERUN,
     *                             NMUCOU,ISHIFY,
     *               INLWAV,INRWAV,ICOMIX,EPSMIX,
     *               INDBRA,INDKET,KONMIX,ICMPRI,
     *               IDIAGO,IDIMUR,IPROMI,IPROMA,
     *                      NATKNO,NBTKNO,ISOSTZ,
     *               NPNKNO,NTZKNO,NPAKNO,IPAPRO,
     *               ISOSMI,ISOSMA,EPSISO,ICSKIP,
     *               NUAKNO,NUBKNO,KPROJE,KPLEFT,
     *                      INUWAV,ITOWAV,IWRWAV,
     *               ISAKER,ICHKER,NFIKER,FILKER,
     *               IPAKER,IPAK3D,IPAALL,KFIKER,
     *               NUASTA,NUASTO,NUGSTA,NUGSTO,
     *               NATSTA,NATSTO,NGTSTA,NGTSTO,
     *               NUBSTA,NUBSTO,NUTSTA,NUTSTO,
     *               NMUMAX,NMAMAX,NSIMAX,NASMAX,
     *                             NMAORD,NASORD,
     *        ISCHIF,NMURED,NMARED,NASRED,NSIRED,
     *                      ICUTOV,CUTOVE,CUTOVF,
     *                      IONISH,ISLPRI,ISUPRI,
     *                      IENPRI,ISRPRI,IMIPRI,
     *                      IKEPRI,IRMPRI,IELPRI,
     *                             IWRIRM,NFIRED,
     *               QMUCUT,QMACUT,QASCUT,QSICUT,
     *                             NUMCOU,BOUCOU,
     *                      ICOTYP,ICOUDI,ICOUEX,
     *                                    IDOTHC,
     *               ISYMDE,INIROT,INIINV,INIKAR,
     *                             ISAWAV,IKERNE,
     *                                    IBETME,
     *                             NFIWAV,FILWAV,
     *                             I_SLOW,SLOWEV,
     *                             NEWGOG,NEWCOU,
     *               I_GOGA,IGOGPA,I_REGA,IREGPA,
     *                             I_SEPA,ISEPPA,
     *                             I_COUA,ICOUPA,
     *                             N3LORD,N3SERD,
     *                             LDPNMX,MIN_QP,
     *                             IN_FIX,IZ_FIX,
     *                      NFIFER,FILFER,N_CALL,
     *                             ISOADD,NBTKNT,
     *                             JETACM,KETA_R,
     *                             KETAJ2,KETAT2,
     *                             IDSIQN,IDSIQP,
     *                             IDSIZN,IDSIZP,
     *        NMRMIX,LMRMIX,NMURMI,LMURMI,I_PASS,
     *                             ISWIND,NUANGU,
     *                             IVIPRI,ITWCEN)
C
                N_CALL=N_CALL+1
C
             END DO
          END DO
C
      END IF
C
C=======================================================================
C         SETTINGS TO PERFORM MULTI-REFERENCE MIXING
C=======================================================================
C
      IF (TERMNT.AND.IPRGCM.EQ.4) THEN
C
          IDIAGO=0
          ISAWAV=0
          IKERNE=1
          KONMIX=0
C
          NMRMIX=0
          LMRMIX=0
          NMURMI=0
          LMURMI=0
          I_PASS=1
C
          IDIMUR=1
C
C=======================================================================
C        SETTINGS TO CALCULATE CONFIGURATION MIXING:
C=======================================================================
C
 5349     CONTINUE
C
          N_CALL=1
          IWRBLO=1
C
          MIXCOL(:,:,:)=0
C
          DO INDKET=1,MIXNUM
C
             INRWAV=MICONF(INDKET)
C
C=======================================================================
C            BELOW THE WAVE FUNCTIONS ARE READ FOR THE SOLE  PURPOSE  OF
C            DEFINING KPRIGH AND KPLEFT.
C            ATTENTION: FOR IPROAN=4, VALUE OF KPRIGH IS TRANSMITTED  TO
C            PROANG INSTEAD OF KPROJE.
C=======================================================================
C
             CALL READWF(NFIWAV,INRWAV,FILWAV,IWRBLO,1,1,KPRIGH)
C
C=======================================================================
C            HERE THE INDEX OF THE LEFT SINGLE-REFERENCE STATE  (THE BRA
C            STATE) IS SMALLER THAN  THAT  OF  THE  RIGHT STATE (THE KET
C            STATE), THAT IS, WE ARE GOING TO CALCULATE ONLY  THE  UPPER
C            TRIANGLE OF THE OVERLAP AND HAMILTONIAN MATRICES.
C=======================================================================
C
            DO INDBRA=1,INDKET
C
                INLWAV=MICONF(INDBRA)
C
                CALL READWF(NFIWAV,INLWAV,FILWAV,IWRBLO,1,1,KPLEFT)
C
                IF (INDBRA.EQ.MIXNUM.AND.INDKET.EQ.INDBRA) KONMIX=1
C
                IPROAN=4
C
                CALL PROANG(IPROAN,
     *                      ISIMTX,JSIMTY,ISIMTZ,
     *                      ISIGNY,ISIMPY,ISIQTY,
     *               IPAHFB,IROTAT,ITIREP,MREVER,
     *                                    IPNMIX,
     *                             IDEVAR,ITERUN,
     *                             NMUCOU,ISHIFY,
     *               INLWAV,INRWAV,ICOMIX,EPSMIX,
     *               INDBRA,INDKET,KONMIX,ICMPRI,
     *               IDIAGO,IDIMUR,IPROMI,IPROMA,
     *                      NATKNO,NBTKNO,ISOSTZ,
     *               NPNKNO,NTZKNO,NPAKNO,IPAPRO,
     *               ISOSMI,ISOSMA,EPSISO,ICSKIP,
     *               NUAKNO,NUBKNO,KPRIGH,KPLEFT,
     *                      INLWAV,INRWAV,IWRWAV,
     *               ISAKER,ICHKER,NFIKER,FILKER,
     *               IPAKER,IPAK3D,IPAALL,KFIKER,
     *               NUASTA,NUASTO,NUGSTA,NUGSTO,
     *               NATSTA,NATSTO,NGTSTA,NGTSTO,
     *               NUBSTA,NUBSTO,NUTSTA,NUTSTO,
     *               NMUMAX,NMAMAX,NSIMAX,NASMAX,
     *                             NMAORD,NASORD,
     *        ISCHIF,NMURED,NMARED,NASRED,NSIRED,
     *                      ICUTOV,CUTOVE,CUTOVF,
     *                      IONISH,ISLPRI,ISUPRI,
     *                      IENPRI,ISRPRI,IMIPRI,
     *                      IKEPRI,IRMPRI,IELPRI,
     *                             IWRIRM,NFIRED,
     *               QMUCUT,QMACUT,QASCUT,QSICUT,
     *                             NUMCOU,BOUCOU,
     *                      ICOTYP,ICOUDI,ICOUEX,
     *                                    IDOTHC,
     *               ISYMDE,INIROT,INIINV,INIKAR,
     *                             ISAWAV,IKERNE,
     *                                    IBETME,
     *                             NFIWAV,FILWAV,
     *                             I_SLOW,SLOWEV,
     *                             NEWGOG,NEWCOU,
     *               I_GOGA,IGOGPA,I_REGA,IREGPA,
     *                             I_SEPA,ISEPPA,
     *                             I_COUA,ICOUPA,
     *                             N3LORD,N3SERD,
     *                             LDPNMX,MIN_QP,
     *                             IN_FIX,IZ_FIX,
     *                      NFIFER,FILFER,N_CALL,
     *                             ISOADD,NBTKNT,
     *                             JETACM,KETA_R,
     *                             KETAJ2,KETAT2,
     *                             IDSIQN,IDSIQP,
     *                             IDSIZN,IDSIZP,
     *        NMRMIX,LMRMIX,NMURMI,LMURMI,I_PASS,
     *                             ISWIND,NUANGU,
     *                             IVIPRI,ITWCEN)
C
                N_CALL=N_CALL+1
C
             END DO
          END DO
C
          IF (I_PASS.EQ.2) GO TO 5349
C
      END IF
C
C=======================================================================
C         ADIABATIC CALCULATIONS
C=======================================================================
C
      IF (TERMNT.AND.IADBAT.EQ.1) THEN
C
          CALL PUSH_DSI_PARA(
     *                    ISIMTX,JSIMTY,ISIMTZ,ISIGNY,ISIMPY,ISIQTY,
     *                    IPAHFB,MREVER,MIN_QP,IPNMIX,ITPNMX,ITIREP,
     *                    IDEVAR,ITERUN,ISYMDE,INIROT,INIINV,INIKAR,
     *                    ISAWAV,IKERNE,IMOVAX,ITILAX,ITISAX,NO_ORB,
     *                    IROTAT,MPAHFB,IPOTHO,ISCHIF,IOCONT,NMUCON,
     *                    NSICON,I_YUKA,I_GOGA,I_REGA,I_SEPA,ITWOLI,
     *                    JETACM,KETA_R,ICOUDI,ICOUEX,LIPKIN,LIPKIP,
     *                    IF_RPA,ILIPON,ILIPOP,NEWGOG,NEWCOU,
     *                    ITWCEN,LTWCEN,LDTWCE,ICOTYP,IDOTHC,INDCOE,
     *                    IDEFIN,IDEFIP,IGOGPA,IREGPA,ISEPPA,ICOUPA,
     *                    ISREGA,ISREGP,N3LORD,I_SLOW,ISGOGA,ISGOGP,
     *                                                IN_FIX,IZ_FIX,
     *                                                       NAMEPN,
     *             AROTLT,ALINLT,PRINIT,XOLDEV,XOLDOD,EFER2N,EFER2P,
     *                                  SLOWEV,SLOWPA,DELFIN,DELFIP)
C
          CALL ADBATI(IPAHFB)
C
      END IF
C
C=======================================================================
C         RENORMALIZING THE MASS
C=======================================================================
C
      IF (IRENMA.GE.1) THEN
C
          IF (IPRGCM.GE.1) STOP ' IRENMA>0 NOT ALLOWED FOR IPRGCM>0'
C
          ISAWAV=0
          IKERNE=1
C ICANTP=1 :USE CANONICAL BASIS INSIDE RENMAS
          ICANTP=0
C
          CALL RENMAS(MIN_QP,IRENMA,IDOGOA,ISIMTX,JSIMTY,ISIMTZ,
     *                                     ISIGNY,ISIMPY,ISIQTY,
     *                              IPAHFB,IROTAT,ITIREP,MREVER,
     *                                                   IPNMIX,
     *                                            IDEVAR,ITERUN,
     *                                            NMUCOU,ISHIFY,
     *                                            NUMCOU,BOUCOU,
     *                              ISYMDE,INIROT,INIINV,INIKAR,
     *                                            ISAWAV,IKERNE,
     *                NOSCIL,NUMETA,NFICOU,FILCOU,ICOULI,ICOULO,
     *                       IN_FIX,IZ_FIX,ICANTP,I_SLOW,SLOWTP)
C
          IF (PRINIT.AND.IPRI_T.EQ.1)
     *
     *        CALL REMPRI(NAMEPN,TRAMAS,IDOGOA)
C
      END IF
C
C=======================================================================
C         RENORMALIZING THE INERTIA
C=======================================================================
C
      IF (IRENIN.GE.1) THEN
C
          IF (IPRGCM.GE.1) STOP ' IRENIN>0 NOT ALLOWED FOR IPRGCM>0'
C
          ISAWAV=0
          IKERNE=1
C ICANRP=1 :USE CANONICAL BASIS INSIDE RENINE
          ICANRP=0
C
          CALL RENINE(MIN_QP,IRENIN,IDOGOA,ISIMTX,JSIMTY,ISIMTZ,
     *                                     ISIGNY,ISIMPY,ISIQTY,
     *                              IPAHFB,IROTAT,ITIREP,MREVER,
     *                                                   IPNMIX,
     *                                            IDEVAR,ITERUN,
     *                                            NMUCOU,ISHIFY,
     *                                            NUMCOU,BOUCOU,
     *                              ISYMDE,INIROT,INIINV,INIKAR,
     *                                            ISAWAV,IKERNE,
     *                NOSCIL,NUMETA,NFICOU,FILCOU,ICOULI,ICOULO,
     *                                            IN_FIX,IZ_FIX,
     *                                     ICANRP,I_SLOW,SLOWRP)
C
          IF (PRINIT.AND.IPRI_T.EQ.1)
     *
     *        CALL REIPRI(NAMEPN,IDOGOA)
C
      END IF
C
C=======================================================================
C
      IF (IWRISO.EQ.1)  CALL IWRPRI(NFIISO)
C
C=======================================================================
C=======================================================================
C          P R I N T I N G   T H E   C O N V E R G E N C E   R E P O R T
C=======================================================================
C=======================================================================
C
      IF (NUMITE.EQ.ITESTA.AND..NOT.TERMNT) THEN
C
          IF (ICONTI.EQ.1) THEN
C
              WRITE(NFIPRI,'(79(1H*),/,1H*,77X,1H*,/,
     *            1H*,1X,'' ITERATION RESTARTED FROM THE DISC,'',
     *                   '' THE FOLLOWING FILE(S) READ:'',  13X,1H*,/,
     *            1H*,2X,A68,''VER='',I2,                    1X,1H*)')
     *
     *        FILREP,IVEREP
C
              IF (IYCONT.EQ.1.AND.IFCONT.NE.1)
     *
     *            WRITE(NFIPRI,'(1H*,2X,A68,7X,1H*)') FILYUP
C
              IF (IGCONT.EQ.1)
     *
     *            WRITE(NFIPRI,'(1H*,2X,A68,7X,1H*)') FILGOP
C
              IF (IGPCON.EQ.1)
     *
     *            WRITE(NFIPRI,'(1H*,2X,A68,7X,1H*)') FILGPP
C
              IF (IECONT.EQ.1)
     *
     *            WRITE(NFIPRI,'(1H*,2X,A68,7X,1H*)') FILROP
C
              IF (ILCONT.EQ.1.AND.IFCONT.NE.1)
     *
     *            WRITE(NFIPRI,'(1H*,2X,A68,7X,1H*)') FILLIP
C
              IF (IFCONT.EQ.1)
     *
     *            WRITE(NFIPRI,'(1H*,2X,A68,''VER='',I2,1X,1H*)')
     *                                                FILFIP,IVEFIP
C
              WRITE(NFIPRI,'(1H*,77X,1H*)')
C
          END IF
C
      END IF
C
C=======================================================================
C
      IF (.NOT.TERMNT) THEN
C
C=======================================================================
C         PRINTING THE HEADER
C=======================================================================
C
          IF (I1LINE.EQ.1.AND.(NUMITE.EQ.ITESTA.OR.IPRMID.EQ.1))
     *
     *        WRITE(NFIPRI,'(79(1H*),/,1H*,77X,1H*,/,
     *             1H*,1X,''CONVERGENCE REPORT'',       37X,
     *                    ''                     '',        1H*,/,
     *             1H*,77X,1H*,/,79(1H*),/,         1H*,77X,1H*,/,
     *             1H*,1X,''ITER     ENERGY     STABILITY    Q_2    '',
     *                    ''GAMMA   SPIN  OMEGA   ANGLE   EPAIR'',
     *                                 1X,1H*,/,    1H*,77X,1H*)')
C
          IF (I1LINE.EQ.2.AND.(NUMITE.EQ.ITESTA.OR.IPRMID.EQ.1))
     *
     *        WRITE(NFIPRI,'(79(1H*),/,1H*,77X,1H*,/,
     *             1H*,1X,''CONVERGENCE REPORT'',       37X,
     *                    ''                     '',        1H*,/,
     *             1H*,77X,1H*,/,79(1H*),/,         1H*,77X,1H*,/,
     *             1H*,1X,''ITER     ENERGY     STABILITY    Q_2  '',
     *                    ''DELTAN DELTAP  LAMBD2N LAMBD2P  EPAIR'',
     *                                 1X,1H*,/,    1H*,77X,1H*)')
C
          IF (I1LINE.EQ.3.AND.(NUMITE.EQ.ITESTA.OR.IPRMID.EQ.1))
     *
     *        WRITE(NFIPRI,'(79(1H*),/,1H*,77X,1H*,/,
     *             1H*,1X,''CONVERGENCE REPORT'',       37X,
     *                    ''                     '',        1H*,/,
     *             1H*,77X,1H*,/,79(1H*),/,         1H*,77X,1H*,/,
     *             1H*,1X,''ITER     ENERGY   STABILITY    Q_2  '',
     *                  '' GAMMA   S   lam_n  lamb_p  EpN    EpP '',
     *                                 1X,1H*,/,    1H*,77X,1H*)')
C
          IF (I1LINE.GE.4.AND.I1LINE.LE.6.AND.
     *       (NUMITE.EQ.ITESTA.OR.IPRMID.EQ.1))
     *
     *        WRITE(NFIPRI,'(79(1H*),/,1H*,77X,1H*,/,
     *             1H*,1X,''CONVERGENCE REPORT'',       37X,
     *                    ''                     '',        1H*,/,
     *             1H*,77X,1H*,/,79(1H*),/,         1H*,77X,1H*,/,
     *             1H*,1X,''ITER     ENERGY     STABILITY    Q_2   '',
     *                    ''GAMMA      ISOSPIN  FERMI EN.  EPAIR'',
     *                                 1X,1H*,/,    1H*,77X,1H*)')
C
C=======================================================================
C         CALCULATING THE SCALAR TOTAL QUADRUPOLE MOMENT
C=======================================================================
C
          QROT2T=SQRT(QROT_T(2,0)**2+QROT_T(2,2)**2)
C
C=======================================================================
C         CALCULATING THE BOHR GAMMA ANGLE IN THE INTRINSIC FRAME
C=======================================================================
C
          IF (ABS(QROT_T(2,0)).GT.1.0D-30) THEN
C
              GAMMMA=ATAN(QROT_T(2,2)/QROT_T(2,0))*45.0/ATAN(1.0D0)
C
              IF (QROT_T(2,0).LT.0) GAMMMA=GAMMMA+180.0
C
          ELSE
C
              IF (QROT_T(2,2).GE.0.0) THEN
                  GAMMMA= 90.0
              ELSE
                  GAMMMA=-90.0
              END IF
C
          END IF
C
C=======================================================================
C         CALCULATING THE LENGTHS OF THE ANGULAR MOMENTUM AND ROTATIONAL
C         FREQUENCY VECTORS AND THE ANGLE BETWEEN THEM
C=======================================================================
C
          IF (ISIMPY.EQ.1) THEN
C
              OMETOT=OMOVAY
              ANGTOT=ANGU_T(2)
              ANGLET=0.0
C
          ELSE
C
              OMETOT=OMOVAX   **2+OMOVAY   **2+OMOVAZ   **2
              ANGTOT=ANGU_T(1)**2+ANGU_T(2)**2+ANGU_T(3)**2
              ANGLET=0.0
C
              IF (OMETOT.GT.0.0.AND.ANGTOT.GT.0.0) THEN
C
                  SINANG=1-( OMOVAX*ANGU_T(1)
     *                      +OMOVAY*ANGU_T(2)
     *                      +OMOVAZ*ANGU_T(3))**2/OMETOT/ANGTOT
C
                  IF (ABS(SINANG).LE.1.0D0)
     *
     *                ANGLET=ASIN(SINANG)*45.0D0/ATAN(1.0D0)
C
              END IF
C
              OMETOT=SQRT(OMETOT)
              ANGTOT=SQRT(ANGTOT)
C
          END IF
C
C=======================================================================
C
          IF (ABS(ANGLET).GE.1E-2.OR.ANGLET.EQ.0.0) THEN
C
              WRITE(ANGLEC,'(F8.3)')     ANGLET
          ELSE
              WRITE(ANGLEC,'((1PE8.1))') ANGLET
C
          END IF
C
C=======================================================================
C
          IF (ABS(ESTABN).GE.1E-5.AND.ABS(ESTABN).LT.1E+3) THEN
C
              WRITE(ESTABC,'(F12.6)')     ESTABN
          ELSE
              WRITE(ESTABC,'((1PE12.2))') ESTABN
C
          END IF
C
C=======================================================================
C
          IF (ABS(QROT2T).GE.1E-5.AND.ABS(QROT2T).LT.1E+3) THEN
C
              WRITE(QROT2C,'(F8.3)')     QROT2T
          ELSE
              WRITE(QROT2C,'((1PE8.1))') QROT2T
C
          END IF
C
C=======================================================================
C         PRINTING THE ONE-LINE REPORT FOR THE CURRENT ITERATION
C=======================================================================
C
          IF (NUMITE.LT.100) THEN
C
              IF (I1LINE.EQ.1)
     *            WRITE(NFIPRI,'(1H*,I4,1X,F13.6,A12,A8,
     *                               F8.2,F7.2,F7.3,A8,F8.2,1X,1H*)')
     *            NUMITE,ETOTFU,ESTABC,QROT2C,
     *            GAMMMA,ANGTOT,OMETOT,ANGLEC,EPAI_T
C
              IF (I1LINE.EQ.2)
     *            WRITE(NFIPRI,'(1H*,I4,1X,F13.6,A12,A8,
     *                               F7.3,F7.3,F8.3,F8.3,F8.2,1X,1H*)')
     *            NUMITE,ETOTFU,ESTABC,QROT2C,
     *            DELTAN,DELTAP,EFER2N,EFER2P,EPAI_T
C
              IF (I1LINE.EQ.3.AND.IPNMIX.EQ.1.AND.IPAHFB.EQ.1)
     *            STOP ' I1LINE.EQ.3 IS INCOMP. WITH IPNMIX/IPAHFB.EQ.1'
C
              IF (I1LINE.EQ.3)
     *            WRITE(NFIPRI,'(1H*,I4,1X,F11.4,A12,A8,
     *                      F6.1,F6.2,1X,F6.2,1X,F6.2,2F7.2,1X,1H*)')
     *            NUMITE,ETOTFU,ESTABC,QROT2C,
     *            GAMMMA,ENTRPY(0)+ENTRPY(1),
     *                  EFERMN,EFERMP,EPAI_N,EPAI_P
C
              IF (I1LINE.EQ.4)
     *            WRITE(NFIPRI,'(1H*,I4,1X,F13.6,A12,A8,
     *                      F7.2,'' X'',F11.6,F11.6,F7.2,1X,1H*)')
     *            NUMITE,ETOTFU,ESTABC,QROT2C,
     *            GAMMMA,TOTISO(1),FERMOV(1),EPAI_T
C
              IF (I1LINE.EQ.5)
     *            WRITE(NFIPRI,'(1H*,I4,1X,F13.6,A12,A8,
     *                      F7.2,'' Y'',F11.6,F11.6,F7.2,1X,1H*)')
     *            NUMITE,ETOTFU,ESTABC,QROT2C,
     *            GAMMMA,TOTISO(2),FERMOV(2),EPAI_T
C
              IF (I1LINE.EQ.6)
     *            WRITE(NFIPRI,'(1H*,I4,1X,F13.6,A12,A8,
     *                      F7.2,'' Z'',F11.6,F11.6,F7.2,1X,1H*)')
     *            NUMITE,ETOTFU,ESTABC,QROT2C,
     *            GAMMMA,TOTISO(3),FERMOV(3),EPAI_T
C
          ELSE
C
              IF (I1LINE.EQ.1)
     *            WRITE(NFIPRI,'(1H*,I5,F13.6,A12,A8,
     *                               F8.2,F7.2,F7.3,A8,F8.2,1X,1H*)')
     *            NUMITE,ETOTFU,ESTABC,QROT2C,
     *            GAMMMA,ANGTOT,OMETOT,ANGLEC,EPAI_T
C
              IF (I1LINE.EQ.2)
     *            WRITE(NFIPRI,'(1H*,I5,F13.6,A12,A8,
     *                               F7.3,F7.3,F8.3,F8.3,F8.2,1X,1H*)')
     *            NUMITE,ETOTFU,ESTABC,QROT2C,
     *            DELTAN,DELTAP,EFER2N,EFER2P,EPAI_T
C
              IF (I1LINE.EQ.3.AND.IPNMIX.EQ.1.AND.IPAHFB.EQ.1)
     *            STOP ' I1LINE.EQ.3 IS INCOMP. WITH IPNMIX/IPAHFB.EQ.1'
C
              IF (I1LINE.EQ.3)
     *            WRITE(NFIPRI,'(1H*,I5,F11.4,A12,A8,
     *                        F6.1,F6.2,1X,F6.2,1X,F6.2,2F7.2,1X,1H*)')
     *            NUMITE,ETOTFU,ESTABC,QROT2C,
     *            GAMMMA,ENTRPY(0)+ENTRPY(1),
     *                  EFERMN,EFERMP,EPAI_N,EPAI_P
C
              IF (I1LINE.EQ.4)
     *            WRITE(NFIPRI,'(1H*,I5,F13.6,A12,A8,
     *                      F7.2,'' X'',F11.6,F11.6,F7.2,1X,1H*)')
     *            NUMITE,ETOTFU,ESTABC,QROT2C,
     *            GAMMMA,TOTISO(1),FERMOV(1),EPAI_T
C
              IF (I1LINE.EQ.5)
     *            WRITE(NFIPRI,'(1H*,I5,F13.6,A12,A8,
     *                      F7.2,'' Y'',F11.6,F11.6,F7.2,1X,1H*)')
     *            NUMITE,ETOTFU,ESTABC,QROT2C,
     *            GAMMMA,TOTISO(2),FERMOV(2),EPAI_T
C
              IF (I1LINE.EQ.6)
     *            WRITE(NFIPRI,'(1H*,I5,F13.6,A12,A8,
     *                      F7.2,'' Z'',F11.6,F11.6,F7.2,1X,1H*)')
     *            NUMITE,ETOTFU,ESTABC,QROT2C,
     *            GAMMMA,TOTISO(3),FERMOV(3),EPAI_T
C
          END IF
C
          IF (IPRMID.EQ.1)
     *
     *        WRITE(NFIPRI,'(1H*,77X,1H*,/,79(1H*),/)')
C
      END IF
C
C=======================================================================
C         RECORDING THE    F I E L D S   AFTER THIS  I T E R A T I O N
C=======================================================================
C
      IENDPR=0
C
      IF ((TERMNT.OR.IWRIRE.EQ.1).AND.IWRIRE.NE.-1) THEN
C
          IENDPR=1
C
          IF (TERMNT)
     *        WRITE(NFIPRI,'(79(1H*),/,1H*,77X,1H*,/,
     *         1H*,''  CALLING SUBROUTINE "RECORD" TO SAVE'',
     *             '' THE RECORD FILE CONTAINING THE RESULTS'',1X,1H*,/,
     *         1H*,2X,A68,                                     7X,1H*)')
     *
     *         FILREC
C
          IF (TERMNT) THEN
              IF (IWRIOL.EQ.1) THEN
                  WRITE(NFIPRI,'(
     *            1H*,''  THE MEAN FIELDS IN SPACE FROM THE'',
     *                ''  LAST-BUT-ONE ITERATION HAVE BEEN STORED'',
     *                                                         1X,1H*)')
              ELSE
                  WRITE(NFIPRI,'(
     *            1H*,''  THE MEAN FIELDS IN SPACE FROM THE'',
     *                ''  L  A  S  T   ITERATION HAVE BEEN STORED'',
     *                                                         1X,1H*)')
              END IF
          END IF
C
C=======================================================================
C          ATTENTION!  BETWEEN VERSIONS (1.78 hf78.f)  AND  (3.03K), THE
C                      VARIABLES:
C                                   REFERN,REFERP,
C                                   REDELN,REDELP,
C                                   REFE2N,REFE2P,
C
C                      WERE STORED ON THE RECORD FILE INSTEAD OF
C                      VARIABLES:
C                                   EFERMN,EFERMP,
C                                   DELTAN,DELTAP,
C                                   EFER2N,EFER2P,
C
C                      AS  A  RESULT,  FOR  CALCULATIONS WITH   PAIRING,
C                      A SMOOTH CONTINUATION OF  ITERATIONS  COULD  HAVE
C                      BEEN  IMPOSSIBLE.  THIS  BUG  WAS  CORRECTED   ON
C                      26/02/2021 IN VERSION (3.03L).
C=======================================================================
C
          INPFLD=0
          IERROR=0
C
          CALL RECORD(NFIREP,NFIREC,INPFLD,NUMITE,
     *                IVEREP,NXHERM,NYHERM,NZHERM,
     *                              IPCONT,ILCONT,
     *                       ISCONT,ITCONT,IACONT,
     *                              IMCONT,IRCONT,
     *                              IRENMA,IRENIN,
     *                              LIPKIN,LIPKIP,
     *                              EFERMN,EFERMP,
     *                              DELTAN,DELTAP,
     *                              EFER2N,EFER2P,
     *                              IDSIGN,IDSIGP,
     *                              IDSIMN,IDSIMP,
     *                              IDSIQN,IDSIQP,
     *                              IDSIZN,IDSIZP,
     *                                     INIBLN,
     *                                     INIBLP,
     *                              NMUMAX,NSIMAX,
     *                              IPNMIX,ISHIFT,
     *                              JETA_T,JETAPA,IERROR,
     *                                     LDTWCE,LDTWDD,
     *                                            IFRCNT)
C
C=======================================================================
C          ATTENTION!  BETWEEN VERSIONS  (2.59)  AND  (2.69O),  THE  TWO
C                      LINES BELOW HAVE  BEEN  COMMENTED  OUT.  ON  SOME
C                      COMPILERS  (E.G.  "GFORTRAN")  THIS  WAS  CAUSING
C                      PROBLEMS WITH THE OUTSTANDING BUFFERS OF THE  REC
C                      FILE  NOT  BEING  WRITTEN  TO  DISC  AFTER   EACH
C                      ITERATION,  WHICH  WAS  RENDERING  THE  REC  FILE
C                      UNUSABLE. THIS BUG WAS CORRECTED ON 14/04/2014 IN
C                      VERSION (2.69P).
C=======================================================================
C
          CLOSE(NFIREC)
C
          OPEN(NFIREC,FILE=FILREC,STATUS='OLD',FORM='UNFORMATTED')
C
      END IF
C
C=======================================================================
C
      IF ((TERMNT.OR.IWRIYU.EQ.1).AND.IWRIYU.NE.-1.AND.I_YUKA.GE.2) THEN
C
          IF (TERMNT.AND.IENDPR.EQ.0) WRITE(NFIPRI,'(79(1H*))')
C
          IENDPR=1
C
          IF (TERMNT)
     *        WRITE(NFIPRI,'(1H*,77X,1H*,/,
     *         1H*,''  CALLING SUBROUTINE "RECYUK" TO SAVE'',
     *             '' THE YUKAWA FILE CONTAINING THE RESULTS'',1X,1H*,/,
     *         1H*,2X,A68,                                     7X,1H*)')
     *
     *         FILYUC
C
          INPYUK=0
C
          CALL RECYUK(NFIYUP,NFIYUC,INPYUK)
C
          CLOSE(NFIYUC)
C
          OPEN(NFIYUC,FILE=FILYUC,STATUS='OLD',FORM='UNFORMATTED')
C
      END IF
C
C=======================================================================
C
      IF ((TERMNT.OR.IWRIGO.EQ.1).AND.IWRIGO.NE.-1.AND.
     *                               (I_GOGA.GE.2.AND.NEWGOG.EQ.0)) THEN
C
          IF (TERMNT.AND.IENDPR.EQ.0) WRITE(NFIPRI,'(79(1H*))')
C
          IENDPR=1
C
          IF (TERMNT)
     *        WRITE(NFIPRI,'(1H*,77X,1H*,/,
     *         1H*,''  CALLING SUBROUTINE "RECGOG" TO SAVE'',
     *             '' THE GOGNY  FILE CONTAINING THE RESULTS'',1X,1H*,/,
     *         1H*,2X,A68,                                     7X,1H*)')
     *
     *         FILGOC
C
          INPGOG=0
C
          CALL RECGOG(NFIGOP,NFIGOC,INPGOG)
C
          CLOSE(NFIGOC)
C
          OPEN(NFIGOC,FILE=FILGOC,STATUS='OLD',FORM='UNFORMATTED')
C
      END IF
C
C=======================================================================
C
      IF ((TERMNT.OR.IWRIGO.EQ.1).AND.IWRIGO.NE.-1.AND.
     *                               (IGOGPA.GE.2.AND.NEWGOG.EQ.0)) THEN
C
          IF (TERMNT.AND.IENDPR.EQ.0) WRITE(NFIPRI,'(79(1H*))')
C
          IENDPR=1
C
          IF (TERMNT)
     *        WRITE(NFIPRI,'(1H*,77X,1H*,/,
     *         1H*,''  CALLING SUBROUTINE "RECGPA" TO SAVE'',
     *             '' THE GOGNY  FILE CONTAINING THE RESULTS'',1X,1H*,/,
     *         1H*,2X,A68,                                     7X,1H*)')
     *
     *         FILGPC
C
          INPGPA=0
C
          CALL RECGPA(NFIGPP,NFIGPC,INPGPA)
C
          CLOSE(NFIGPC)
C
          OPEN(NFIGPC,FILE=FILGPC,STATUS='OLD',FORM='UNFORMATTED')
C
      END IF
C
C=======================================================================
C
      IF ((TERMNT.OR.IWRIRO.EQ.1).AND.IWRIRO.NE.-1.AND.
     *              ((I_GOGA.GE.2.AND.NEWGOG.EQ.1).OR.I_REGA.GE.2)) THEN
C
          IF (TERMNT.AND.IENDPR.EQ.0) WRITE(NFIPRI,'(79(1H*))')
C
          IENDPR=1
C
          IF (TERMNT)
     *        WRITE(NFIPRI,'(1H*,77X,1H*,/,
     *         1H*,''  CALLING SUBROUTINE "RECREG" TO SAVE'',
     *             '' THE REGUL  FILE CONTAINING THE RESULTS'',1X,1H*,/,
     *         1H*,2X,A68,                                     7X,1H*)')
     *
     *         FILROC
C
          INPREG=0
C
          CALL RECREG(NFIROP,NFIROC,INPREG)
C
          CLOSE(NFIROC)
C
          OPEN(NFIROC,FILE=FILROC,STATUS='OLD',FORM='UNFORMATTED')
C
      END IF
C
C=======================================================================
C
      IF ((TERMNT.OR.IWRILI.EQ.1).AND.IWRILI.NE.-1.AND.
     *    (IWRILI.NE.1.OR.IWRIFI.EQ.-1).AND.
     *    (LIPKIN.EQ.1.OR.LIPKIP.EQ.1)) THEN
C
          IF (TERMNT.AND.IENDPR.EQ.0) WRITE(NFIPRI,'(79(1H*))')
C
          IENDPR=1
C
          IF (TERMNT)
     *        WRITE(NFIPRI,'(1H*,77X,1H*,/,
     *         1H*,''  CALLING SUBROUTINE "RECLIP" TO SAVE'',
     *             '' THE LIPKIN FILE CONTAINING THE RESULTS'',1X,1H*,/,
     *         1H*,2X,A68,                                     7X,1H*)')
     *
     *         FILLIC
C
          INPLIP=0
C
          CALL RECLIP(NFILIP,NFILIC,INPLIP,ISIMPY)
C
          CLOSE(NFILIC)
C
          OPEN(NFILIC,FILE=FILLIC,STATUS='OLD',FORM='UNFORMATTED')
C
      END IF
C
C=======================================================================
C
      IF ((TERMNT.OR.IWRIFI.EQ.1).AND.IWRIFI.NE.-1) THEN
C
          IF (TERMNT.AND.IENDPR.EQ.0) WRITE(NFIPRI,'(79(1H*))')
C
          IENDPR=1
C
          IF (TERMNT)
     *        WRITE(NFIPRI,'(1H*,77X,1H*,/,
     *         1H*,''  CALLING SUBROUTINE "RECFIL" TO SAVE'',
     *             '' THE FIELDS FILE CONTAINING THE RESULTS'',1X,1H*,/,
     *         1H*,2X,A68,                                     7X,1H*)')
     *
     *         FILFIC
C
          INPFIL=0
          IFWTHO=0
C
          CALL RECFIL(NFIFIP,NFIFIC,INPFIL,ISIMPY,IPAHFB,
     *                              IPNMIX,NOSCIL,NUMITE,
     *                       EFERMN,EFERMP,EFER2N,EFER2P,
     *                              DELTAN,DELTAP,IFWTHO,
     *                                     NLIMIT,FILTHO,
     *                       ISGOGP,ISREGP,REA2PP,IVEFIP)
C
          CLOSE(NFIFIC)
C
          OPEN(NFIFIC,FILE=FILFIC,STATUS='OLD',FORM='UNFORMATTED')
C
      END IF
C
C=======================================================================
C
      IF ((TERMNT.OR.IWRIQU.EQ.1).AND.IWRIQU.NE.-1) THEN
C
          IF (TERMNT.AND.IENDPR.EQ.0) WRITE(NFIPRI,'(79(1H*))')
C
          IENDPR=1
C
          WRITE(NFIPRI,'(1H*,77X,1H*,/,
     *         1H*,''  CALLING SUBROUTINE "RECQUA" TO SAVE'',
     *             '' THE FILE CONTAINING QUASIPARTICLE W-FS'',1X,1H*,/,
     *         1H*,2X,A68,                                     7X,1H*)')
     *
     *         FILQUA
C
          CALL RECQUA(NFIQUA,ISIMPY,IPAHFB,IPNMIX)
C
          CLOSE(NFIQUA)
C
          OPEN(NFIQUA,FILE=FILQUA,STATUS='OLD',FORM='UNFORMATTED')
C
      END IF
C
C=======================================================================
C         RECORDING THE BASIS DEFORMATION AFTER THIS  I T E R A T I O N
C=======================================================================
C
      IF ((TERMNT.OR.IWRIBA.EQ.1).AND.IWRIBA.NE.-1) THEN
C
          IENDPR=1
C
          IF (TERMNT)
     *        WRITE(NFIPRI,'(1H*,77X,1H*,/,
     *         1H*,''  CALLING SUBROUTINE "RECBAS" TO SAVE'',
     *             '' THE BASIS  FILE CONTAINING THE RESULTS'',1X,1H*,/,
     *         1H*,2X,A68,                                     7X,1H*)')
     *
     *         FILBAC
C
          INPFLD=0
          IERROR=0
C
          CALL RECBAS(NFIBAP,NFIBAC,INPFLD,IERROR)
C
          CLOSE(NFIBAC)
C
          OPEN(NFIBAC,FILE=FILBAC,STATUS='OLD',FORM='FORMATTED')
C
      END IF
C
C=======================================================================
C
      IF (TERMNT.AND.IENDPR.EQ.1)WRITE(NFIPRI,'(1H*,77X,1H*,/,79(1H*))')
C
C=======================================================================
C
      IF (.NOT.TERMNT) THEN
C
          CALL CNVRGE(ESTABN,EPSITE,IS_YES,ITERUN,NULAST,
     *                              EPSCON,IS_CON,NUCONS)
C
          IF (IS_YES.EQ.1.OR.NUMITE+1.GE.ITESTO) THEN
C
C=======================================================================
C             HERE WE DEAL WITH THE SITUATION WHEN EITHER THE
C             CONVERGENCE HAS BEEN ACHIEVED, OR THE LIMIT  OF
C             ALLOWED ITERATIONS IS ABOUT TO BE EXCEEDED. THE
C             NEXT INTERATION WILL BE THE TERMINAL ONE.
C=======================================================================
C
              WRITE(NFIPRI,'(1H*,77X,1H*,/,79(1H*),/)')
C
              TERMNT=.TRUE.
C
          ELSE
C
              IF (IS_CON.EQ.1) THEN
C
C=======================================================================
C             HERE WE DEAL WITH THE SITUATION WHEN CONSTANT-STABILITY
C             CONDITION HAS BEEN DETECTED IN THE PREVIOUS ITARATION.
C             THE NEXT INTERATION WILL BE THE TERMINAL ONE.
C=======================================================================
C
                  WRITE(NFIPRI,'(1H*,77X,1H*,/,79(1H*),/)')
C
                  WRITE(NFIPRI,'(79(1H*),/,1H*,77X,1H*,/,
     *                  1H*,1X,''CONSTANT STAB. COND.'',
     *                         '' DETECTED, ITERATIO'',
     *                         ''N FOR THIS DATA SET'',
     *                         '' IS BEING ABORTED '',1H*,/,
     *                  1H*,77X,1H*,/,79(1H*),/)')
C
                  TERMNT=.TRUE.
C
              END IF
C
              IF (IS_PIN.EQ.1) THEN
C
C=======================================================================
C             HERE WE DEAL WITH THE SITUATION  WHEN  THE  PING-PONG
C             CONDITION HAS BEEN DETECTED IN THE PREVIOUS ITARATION.
C             THE NEXT INTERATION WILL BE THE TERMINAL ONE.
C=======================================================================
C
                  WRITE(NFIPRI,'(1H*,77X,1H*,/,79(1H*),/)')
C
                  WRITE(NFIPRI,'(79(1H*),/,1H*,77X,1H*,/,
     *                  1H*,1X,''PING-PONG CONDITION'',
     *                         '' DETECTED, ITERATIO'',
     *                         ''N FOR THIS DATA SET'',
     *                         '' IS BEING  ABORTED '',1H*,/,
     *                  1H*,77X,1H*,/,79(1H*),/)')
C
                  TERMNT=.TRUE.
C
              ELSE
C
C=======================================================================
C             HERE WE DEAL WITH THE  SITUATION  WHEN  THE  PING-PONG
C             CONDITION HAS NOT YET BEEN DETECTED. IF IT IS DETECTED
C             NOW, WE SHOULD CONTINUE AS IF NOTHING HAPPENED BECAUSE
C             IN  THE  NEXT  ITERATION  WE  HAVE  TO  CALCULATE  THE
C             SINGLE-PARTICLE PROPERTIES REQUIRED BY FLISIG, FLISIM,
C             FLISIQ, OR FLISIZ
C=======================================================================
C
                  CALL PINGPO(EPSPNG,IS_PIN,ITERUN,NUPING)
C
              END IF
C
              IF (IS_CHA.EQ.1) THEN
C
C=======================================================================
C             HERE WE DEAL WITH  THE  SITUATION  PERTAINING  TO  THE
C             CHAOTIC-DIVERGENCE CONDITION DETECTED IN THE  PREVIOUS
C             ITERATION. THE NEXT INTERATION WILL BE TERMINAL.
C=======================================================================
C
                  WRITE(NFIPRI,'(1H*,77X,1H*,/,79(1H*),/)')
C
                  WRITE(NFIPRI,'(79(1H*),/,1H*,77X,1H*,/,
     *                  1H*,1X,''CHAOTIC  DIVERGENCE'',
     *                         '' DETECTED, ITERATIO'',
     *                         ''N FOR THIS DATA SET'',
     *                         '' IS BEING  ABORTED '',1H*,/,
     *                  1H*,77X,1H*,/,79(1H*),/)')
C
                  TERMNT=.TRUE.
C
              ELSE
C
C=======================================================================
C             HERE WE DEAL WITH  THE  SITUATION  PERTAINING  TO  THE
C             CHAOTIC-DIVERGENCE CONDITION NOT YET DETECTED  IN  THE
C             PREVIOUS ITARATION. IF IT IS DETECTED NOW,  WE  SHOULD
C             CONTINUE AS IF NOTHING HAPPENED  BECAUSE  IN  THE  THE
C             NEXT INTERATION WE HAVE TO CALCULATE THE
C             S I N G L E - P A R T I C L E      P R O P E R T I E S
C=======================================================================
C
                  CALL CHAODI(IS_CHA,ITERUN,NUCHAO)
C
              END IF
C
          END IF
C
          GO TO 1
C
      ELSE
C
          IF (IS_CON.EQ.1) THEN
C
              WRITE(NFIPRI,'(//,79(1H*),/,1H*,77X,1H*,/,
     *          ''*  WARNING! ITERATION WAS ABORTED BECAUSE '',
     *          ''OF THE "CONSTANT STABILITY CONDIT"  *'',/,
     *          ''*  WARNING! ITERATION WAS ABORTED BECAUSE '',
     *          ''OF THE "CONSTANT STABILITY CONDIT"  *'',/,
     *            1H*,77X,1H*,/,79(1H*),/,1H*,77X,1H*)')
C
          END IF
C
          IF (IS_PIN.EQ.1) THEN
C
              WRITE(NFIPRI,'(//,79(1H*),/,1H*,77X,1H*,/,
     *          ''*  WARNING! ITERATION WAS ABORTED BECAUSE '',
     *          ''OF THE "PING-PONG"-TYPE DIVERGENCE  *'',/,
     *          ''*  WARNING! ITERATION WAS ABORTED BECAUSE '',
     *          ''OF THE "PING-PONG"-TYPE DIVERGENCE  *'',/,
     *            1H*,77X,1H*,/,79(1H*),/,1H*,77X,1H*)')
C
              IF (IPNMIX.NE.1) THEN
C
                  IF (ISIMPY.EQ.1) THEN
C
                      IF (ISIGNY.EQ.1) THEN
C
                          CALL FLISIG(MREVER)
                      ELSE
                          CALL FLISIM(MREVER)
C
                      END IF
C
                  ELSE
C
                      IF (ISIQTY.EQ.1) THEN
C
                          CALL FLISIQ
                      ELSE
                          CALL FLISIZ
C
                      END IF
C
                  END IF
C
              ELSE
C
                  IF (ISIMPY.EQ.1) THEN
C
                      IF (ISIGNY.EQ.1) THEN
C
                          CALL FLIMIG(MREVER)
                      ELSE
                          CALL FLIMIM(MREVER)
C
                      END IF
C
                  ELSE
C
                      IF (ISIQTY.EQ.1) THEN
C
                          CALL FLIMIQ
                      ELSE
                          CALL FLIMIZ
C
                      END IF
C
                  END IF
C
              END IF
C
          END IF
C
          IF (IS_CHA.EQ.1) THEN
C
              WRITE(NFIPRI,'(//,79(1H*),/,1H*,77X,1H*,/,
     *          ''*   WARNING! ITERATION WAS ABORTED BECAUSE'',
     *          '' OF THE "C H A O T I C" DIVERGENCE  *'',/,
     *          ''*   WARNING! ITERATION WAS ABORTED BECAUSE'',
     *          '' OF THE "C H A O T I C" DIVERGENCE  *'',/,
     *            1H*,77X,1H*,/,79(1H*),/,1H*,77X,1H*)')
C
          END IF
C
          CALL CNVRGE(ESTABN,EPSITE,IS_YES,ITERUN,NULAST,
     *                              EPSCON,IS_CON,NUCONS)
C
          IF (IS_YES.NE.1.AND.EPSITE.GT.0.0.AND.
     *                        NUMITE.GE.ITESTO) THEN
C
              WRITE(NFIPRI,'(//,79(1H*),/,1H*,77X,1H*,/,
     *              ''* WARNING! THE STABILITY REQUIRED WAS NOT '',
     *              ''ACHIEVED. NO-OF-ITERATIONS EXCEEDED *'',/,
     *              ''* WARNING! THE STABILITY REQUIRED WAS NOT '',
     *              ''ACHIEVED. NO-OF-ITERATIONS EXCEEDED *'',/,
     *                1H*,77X,1H*,/,79(1H*),/,1H*,77X,1H*)')
C
          END IF
C
C=======================================================================
C         STORING THE REVIEW OF RESULTS FOR THIS DATA SET
C=======================================================================
C
C
          IF (ABS(IREVIE).GE.8.AND.ITWCEN.EQ.2)
     *    CALL TWC_REVDEN(ISIMTX,JSIMTY,ISIMTZ,
     *            ISIGNY,ISIMPY,ISIQTY,MPAHFB,MREVER,
     *                                 MIN_QP,IPNMIX,
     *                   ITIREP,PRINIT,IDEVAR,ITERUN,
     *            ISYMDE,INIROT,INIINV,INIKAR,ITWCEN)
C
          IF (IREVIE.NE.0)
     *        CALL REVIEW(NFIREV,VERSIO,IN_FIX,IZ_FIX,
     *                           SKYRME,GOGNAM,ISTAND,
     *             KETA_J,KETA_W,KETACM,KETA_M,KETA_P,KETA_T,KETAPA,
     *                                         NOZEPA,
     *             JETA_J,JETA_W,JETACM,JETA_M,JETA_P,JETA_T,JETAPA,
     *                                  ITWOLI,KETA_R,
     *             LANODD,LANSCA,HBMSAT,RHOSAT,EFFSAT,
     *                    NMUMAX,NMUCON,NMUCOU,NMUPRI,
     *                    ISCHIF,NSIMAX,NSICON,NSIPRI,
     *                    NMAMAX,NMACON,NMAPRI,NMAORD,
     *                    NASMAX,NASCON,NASPRI,NASORD,
     *                                         NRAORD,
     *                    NMURED,NMARED,NASRED,NSIRED,
     *                           LAMMAX,NOSCIL,NLIMIT,
     *                    DELFIN,DELFIP,IDEFIN,IDEFIP,
     *                    FERFIN,FERFIP,IFEFIN,IFEFIP,
     *                    FE2FIN,FE2FIP,IF2FIN,IF2FIP,
     *                    FERALN,FERALP,IFERAN,IFERAP,
     *                                         NUQEVE,
     *                    INSIGN,IPSIGN,ISSIGN,IDSIGN,
     *                    INSIGP,IPSIGP,ISSIGP,IDSIGP,
     *                           INSIMN,IRSIMN,IDSIMN,
     *                           INSIMP,IRSIMP,IDSIMP,
     *                           INSIQN,IPSIQN,IDSIQN,
     *                           INSIQP,IPSIQP,IDSIQP,
     *                                  INSIZN,IDSIZN,
     *                                  INSIZP,IDSIZP,
     *                                  IFIBLN,INIBLN,
     *                                  IFIBLP,INIBLP,
     *                                  IQUNIL,NILXYZ,
     *                           ECUTOF,LIMQUA,LAMCUT,
     *                                         IPOTHO,
     *             IPAIRI,IPAHFB,ITWOBA,JPABCS,IMFHFB,
     *                                  LIPKIN,LIPKIP,
     *                                  LIPNON,LIPNOP,
     *             IROTAT,ITIREP,IREVIE,IQPSTA,MREVER,
     *                    FILREP,FILREC,FILWOO,
     *                    FILREV,FILCOU,FILWAV,FILKER,
     *                    FILYUP,FILYUC,
     *                    FILGOP,FILGOC,
     *                    FILGPP,FILGPC,
     *                    FILROP,FILROC,
     *                    FILLIP,FILLIC,
     *                    FILFIP,FILFIC,
     *                    FILQUA,FILRED,
     *                    FILBAP,FILBAC,
     *                    CMSXFC,CMSYFC,CMSZFC,
     *                    XMOMFC,YMOMFC,ZMOMFC,
     *                    EPSHER,
     *                    ICOMIX,INLKER,INRKER,
     *                    ICMPRI,IN_EXC,EPSMIX,
     *                           ISOADD,NBTKNT,
     *                    HOMEGA,FCHOM0,ENECUT,
     *                    CVOLFC,R0PARM,
     *                                  ISOTRO,
     *                    NUMCOU,NUMETA,FURMAX,
     *                    ICOTYP,ICOUDI,ICOUEX,
     *             PIMASS,PNMASS,IYUTYP,I_YUKA,
     *             YUKAGT,YUKAG0,YUKAG1,YUKAG2,
     *                           I_GOGA,IGOGPA,
     *                           I_REGA,IREGPA,
     *                           I_SEPA,ISEPPA,
     *                           I_COUA,ICOUPA,
     *                    N3LORD,N3SERD,IDOTHC,
     *                    ISPHER,ISIMPY,ISIGNY,
     *                           IPARTY,ISIQTY,
     *                    ISIMTX,JSIMTY,ISIMTZ,
     *             NULAST,EPSITE,NUCONS,EPSCON,
     *                    INIROT,INIINV,INIKAR,
     *                    NUCHAO,NUPING,EPSPNG,
     *                    ICHFLI,IPAFLI,IREFLI,
     *                    ISPFLI,ISHFLI,IFLIPI,
     *             SLOWEV,SLOWOD,SLOWPA,SLOWLI,
     *                           I_SLOW,SLOWAL,
     *             SLOWLD,SLOWTP,SLOWRP,SLOWLM,
     *             IMOVAX,ITILAX,ITISAX,NO_ORB,
     *                    IS_YES,IS_PIN,IS_CHA,
     *      NLSIGN,NLSIMN,NLSIQN,NLSIZN,MXALIN,
     *      NLSIGP,NLSIMP,NLSIQP,NLSIZP,MXALIP,
     *                           LASTAN,LASTAP,
     *                    IAXIAP,KAPASY,INUNIL,
     *                                  ITWCEN)
C
C=======================================================================
C         HERE ENDS THE SUCCESSFUL CALCULATION STEP
C=======================================================================
C
          WRITE(NFIPRI,'(79(1H*),/,             1H*,77X,1H*,/,
     *             1H*,2X,''CALCULATION OF THE DATA SET NO.'',
     *                 I3,'' HAS BEEN SUCCESSFULLY COMPLETED'',
     *                                           9X,1H*,/,
     *                                      1H*,77X,1H*,/,
     *                                          79(1H*),/)')
     *
     *                                           NUDATA
C
C=======================================================================
C         DEALLOCATING BIG ARRAYS ALLOCATED IN ALLODE,  ALLORH,  ALLOKA,
C         AND ALLOVF
C=======================================================================
C
          CALL DEALDE
          CALL DEALVF
C
C=======================================================================
          JUMFIT=0
#if(USE_FITS==1)
          CALL FITOUT(PAROUT,NUMOUT)
          CALL CPUTIM('HFODD ', 0)
          JUMFIT=1
#endif
C=======================================================================
C         THE FOLLOWING "GO TO 3" CORRESPONDS TO A NEW READ "NAMELI"
C=======================================================================
C
#if(USE_MPI==0)
          IF (JUMFIT.EQ.0) GO TO 3
#endif
C
      END IF ! end of TERMNT.EQ.TRUE
C
C=======================================================================
C         GATHERING EXECUTION TIMES FROM ALL PROCESSORS AND
C         CLOSING MPI ENVIRONMENT
C=======================================================================
C
#if(USE_MPI==1)
C
               NUDATA=NUDATA+1
C
C               Move back to the next point in the batch sequence
               IF (NUDATA.GT.number_batch) EXIT
C
            END DO ! end DO (NUDATA<=number_batch)
C
            ! Properly close all files that could have been left
            ! opened (with the exclusion of the output unit NFIPRI)
            CALL IOCLOS(NFIWOO,NFIREP,NFIREV,NFIREC,NFICOU,NFIWAV,
     *                  NFIKER,NFIYUP,NFIYUC,NFIGOC,NFIGOP,NFIGPC,
     *                  NFIGPP,NFIROP,NFIROC,NFILIP,NFILIC,NFIFIP,
     *                  NFIFIC,NFIISO,NFIQUA,NFIRED,NFIBAC,NFIBAP)
C
            ! In batch mode, copy all common restart/rec files in from the
            ! ./restart/ directory to the ./rec/ directory
            IF (batch_mode.EQ.1) THEN
                Write(optimal,'("./restart/HFODD_",I8.8,".REC")')
     *                INDFIL
                Write(optimal,'("./rec/HFODD_",I8.8,".REC")')
     *                INDFIL
                commande = 'cp '//Trim(optimal)//' '//Trim(courant)
                Call system(commande)
            END IF
C
         END IF ! end of 'if (worldRank.eq.mod(...))'
C
      END DO procLoop ! end of job loop (name: procLoop)
C
      ! Switching off the time counters
      CALL CPUTIM('HFODD ',0)
C
      ! Printing all times by local routines
      CALL TIMPRI
C
      CALL DATE_AND_TIME(MYDATE,MYTIME,MYZONE,MYVALU)
C
      WRITE(NFIPRI,'(1H*,77X,1H*,/,1H*,2X,
     *      ''EXECUTION ENDS ON '',A4,''.'',A2,''.'',A2,'' AT '',
     *                               A2,'':'',A2,'':'',A6,
     *                              31X,1H*,/,1H*,77X,1H*,/,79(1H*))')
     *
     *      MYDATE(1:4),MYDATE(5:6),MYDATE(7:8),
     *      MYTIME(1:2),MYTIME(3:4),MYTIME(5:10)
C
      ! closing the unit containing the output file
      CLOSE(NFIPRI)
C
      ! Record system and CPU starting times
      call cpu_time(cput_end)
      call system_clock(syst_cnt, syst_rate)
      syst_end = real(syst_cnt)
     *         / real(syst_rate)
C
      my_evals(0) = counter_eval
      my_cputime(0) = cput_end  - cput_start
C
      call mpi_gather(my_evals, 1, MPI_INTEGER, all_evals, 1,
     *                MPI_INTEGER, 0, MPI_COMM_WORLD, mpi_err)
C
      if (mpi_err .NE. 0) then
          if ( worldRank == 0 ) then
              write(nfisum,'(''Error when gathering evaluations '',
     *                       ''counters'')')
              write(nfisum,'(''Error code: mpi_err = '',i12)') mpi_err
          end if
      end if
C
      call mpi_gather(my_cputime, 1, MPI_DOUBLE_PRECISION, all_cputimes,
     *                            1, MPI_DOUBLE_PRECISION,
     *                            0, MPI_COMM_WORLD, mpi_err)
C
      if (mpi_err .NE. 0) then
          if ( worldRank == 0 ) then
              write(nfisum,'(''Error when gathering CPU times'')')
              write(nfisum,'(''Error code: mpi_err = '',i12)') mpi_err
          end if
      end if
C
      deallocate(my_cputime, my_evals)
C
      if ( worldRank == 0 ) then
C
          write(nfisum,'(''  Rank     Evals  CPU time'')')
          write(nfisum,'(28(''-''))')
C
          do mpi_rank = 0, worldSize-1
             write(nfisum,'(1x,i7,i10,f10.3)')
     *             mpi_rank, all_evals(mpi_rank),
     *                       all_cputimes(mpi_rank)
          end do
          write(nfisum,'(''System time = '',F20.14)')
     *                     syst_end - syst_start
C
          close(nfisum)
C
          ! In batch mode, we remove the restart directory, the content
          ! of which has been copied to rec/, and rename our backup
          ! directory. At the end, we thus have the following structure:
          !  - ./rec/ contains all record files
          !  - ./restart/ contains the restart files associated with each
          !    of the record files in rec/
          !  - ./restart_old/ contains the original set of restart files.
          IF (batch_mode.EQ.1) THEN
              commande = 'rm -rf restart'
              Call system(commande)
              commande = 'mv restart_tmp restart'
              Call system(commande)
          END IF
C
      end if
C
C=======================================================================
C         CLOSING MPI ENVIRONMENT
C=======================================================================
C
      CALL mpi_barrier(MPI_COMM_WORLD, mpi_err)
C
#if(USE_SCALAPACK==1)
      CALL BLACS_EXIT(1)
#endif
C
      ! Close MPI environment
      CALL mpi_finalize(mpi_err)
C
#endif
C
      END
C
C=======================================================================
C
      SUBROUTINE PROANG(IPROAN,
     *                  ISIMTX,JSIMTY,ISIMTZ,
     *                  ISIGNY,ISIMPY,ISIQTY,
     *           IPAHFB,IROTAT,ITIREP,MREVER,
     *                                IPNMIX,
     *                         IDEVAR,ITERUN,
     *                         NMUCOU,ISHIFY,
     *           INLWAV,INRWAV,ICOMIX,EPSMIX,
     *           INDBRA,INDKET,KONMIX,ICMPRI,
     *           IDIAGO,IDIMUR,IPROMI,IPROMA,
     *                  NATKNO,NBTKNO,ISOSTZ,
     *           NPNKNO,NTZKNO,NPAKNO,IPAPRO,
     *           ISOSMI,ISOSMA,EPSISO,ICSKIP,
     *           NUAKNO,NUBKNO,KPROJE,KPLEFT,
     *                  ILFWAV,IRGWAV,IWRWAV,
     *           ISAKER,ICHKER,NFIKER,FILKER,
     *           IPAKER,IPAK3D,IPAALL,KFIKER,
     *           NUASTA,NUASTO,NUGSTA,NUGSTO,
     *           NATSTA,NATSTO,NGTSTA,NGTSTO,
     *           NUBSTA,NUBSTO,NUTSTA,NUTSTO,
     *           NMUMAX,NMAMAX,NSIMAX,NASMAX,
     *                         NMAORD,NASORD,
     *    ISCHIF,NMURED,NMARED,NASRED,NSIRED,
     *                  ICUTOV,CUTOVE,CUTOVF,
     *                  IONISH,ISLPRI,ISUPRI,
     *                  IENPRI,ISRPRI,IMIPRI,
     *                  IKEPRI,IRMPRI,IELPRI,
     *                         IWRIRM,NFIRED,
     *           QMUCUT,QMACUT,QASCUT,QSICUT,
     *                         NUMCOU,BOUCOU,
     *                  ICOTYP,ICOUDI,ICOUEX,
     *                                IDOTHC,
     *           ISYMDE,INIROT,INIINV,INIKAR,
     *                         ISAWAV,IKERNE,
     *                                IBETME,
     *                         NFIWAV,FILWAV,
     *                         I_SLOW,SLOWEV,
     *                         NEWGOG,NEWCOU,
     *           I_GOGA,IGOGPA,I_REGA,IREGPA,
     *                         I_SEPA,ISEPPA,
     *                         I_COUA,ICOUPA,
     *                         N3LORD,N3SERD,
     *                         LDPNMX,MIN_QP,
     *                         IN_FIX,IZ_FIX,
     *                  NFIFER,FILFER,N_CALL,
     *                         ISOADD,NBTKNT,
     *                         JETACM,KETA_R,
     *                         KETAJ2,KETAT2,
     *                         IDSIQN,IDSIQP,
     *                         IDSIZN,IDSIZP,
     *    NMRMIX,LMRMIX,NMURMI,LMURMI,I_PASS,
     *                         ISWIND,NUANGU,
     *                         IVIPRI,ITWCEN)
C
C=======================================================================
      USE SAVLEF
      USE SAVRIG
      USE WAVR_L
      USE REDMOM
C=======================================================================
      USE MAT_PP
      USE MAT_PM
      USE OVRHFB
      USE BLOSAV
      USE TXXX_Y
      USE HAMMIX
      USE MURMIX
C=======================================================================
      USE hfodd_sizes
C=======================================================================
      PARAMETER (NDMORD=3)
      PARAMETER (NDCOLE=1)
      PARAMETER (NDF2BC=5)
C=======================================================================
      CHARACTER
     *          FILKER*68,FILWAV*68,FILACT*83,FILINP*83,FILFER*68
      CHARACTER
     *          FILLEF*68,FILRIG*68
      CHARACTER
     *          FILAC2*149,FILIN2*149,FILHE2*15
      CHARACTER
     *          NAMEPN*8
      CHARACTER
     *          CHALF_*2
      CHARACTER
     *          NAMMUL*45,NAMSUR*45,NAMSCH*45,NAMMAG*45,NAMMAR*45,
     *                                        NAMASM*45,NAMASR*45
      CHARACTER
     *          NAMWRK*45
      CHARACTER
     *          HAFLIN*38
      CHARACTER
     *          LINE_0*1,LINE_1*1,LINE_2*1,LINE_3*1
      CHARACTER
     *          REEFIC*9
C
      LOGICAL
     *          PRINIT
      LOGICAL
     *          BORROT
C
      COMPLEX
     *          SOURCE
      COMPLEX
     *          Q00T,Q10T,Q1PT,Q1MT
      COMPLEX
     *          EKEKIN,EKEPAI,EKESKY,EKECOD,EKECOE,EKESCA,EKEVEC,EKEGOG,
     *          EKEREG,EKESEP
      COMPLEX
     *          OVRLAP
      COMPLEX
     *          AUXDIA,C_ZERO,C_UNIT,UNIT_I
      COMPLEX
     *          DETWRK
      COMPLEX
     *          WARAUX,TARIGH,TALEFT
      COMPLEX
     *          CD0000,CD0010,CD001P,CD001M,CD1010,CD101P,
     *                        CD101M,CD1P1M,CD1P1P,CD1M1M,
     *          CX0000,CX0010,CX001P,CX001M,CX1010,CX101P,
     *                        CX101M,CX1P1M,CX1P1P,CX1M1M
      COMPLEX
     *          QPKERN,ATKERN,WTKERN,SPKERN
      COMPLEX
C TER*          TEKERN,
     *          OVKERN,SKKERN,EKKERN,EPKERN,
     *          CDKERN,CDKE10,CDKE1P,
     *          CXKERN,CXKE10,CXKE1P,
     *          CDKE1M,CDKE20,CDK21P,
     *          CDK21M,CDK22P,CDK22M,
     *          CXKE1M,CXKE20,CXK21P,
     *          CXK21M,CXK22P,CXK22M,
     *          PNKE00,PNKE10,PNKE1P,PNKE1M,
     *          TZKERN,T2KERN,
     *          BZKERN,B2KERN
      COMPLEX
C TER*          TETERN,
     *          OVTERN,SKTERN,EKTERN,EPTERN,
     *          CDTERN,CDTE10,CDTE1P,
     *          CXTERN,CXTE10,CXTE1P,
     *          CDTE1M,CDTE20,CDT21P,
     *          CDT21M,CDT22P,CDT22M,
     *          CXTE1M,CXTE20,CXT21P,
     *          CXT21M,CXT22P,CXT22M,
     *          PNTE00,PNTE10,PNTE1P,PNTE1M,
     *          TZTERN,T2TERN,
     *          BZTERN,B2TERN
      COMPLEX
     *          FACINT,FACI1P,FACI1M,FACI2P,FACI2M,
     *          FACMOM
      COMPLEX
     *          QMUT_N,QMUT_P,QMUT_T
      COMPLEX
     *          AMUT_N,AMUT_P,AMUT_T
      COMPLEX
     *          WMUT_N,WMUT_P,WMUT_T
      COMPLEX
     *          SMUT_N,SMUT_P,SMUT_T
      COMPLEX
     *          A2BCIN,A2BCSA
      COMPLEX
     *          EPROJE,OPROJE
      COMPLEX
     *          ZMUL_P,ZMAG_T,ZASM_T,ZSIF_P
      COMPLEX
C TER*          UTER_T,
     *          UKER_T,USKY_T,UKIN_N,UKIN_P,UCOU_D,UCOU_X,
     *                 UPAI_N,UPAI_P,UC10_D,UC1P_D,UC1M_D,
     *                               UC10_X,UC1P_X,UC1M_X,
     *                               UC20_D,UC21PD,UC21MD,UC22PD,UC22MD,
     *                               UC20_X,UC21PX,UC21MX,UC22PX,UC22MX,
     *                               UPNU00,UPNU10,UPNU1P,UPNU1M,
     *                               UTZISO,UT2ISO,UBZROT,UB2ROT
      COMPLEX
C TER*          WTER_T,
     *          WKER_T,WSKY_T,WKIN_N,WKIN_P,WCOU_D,WCOU_X,
     *                 WPAI_N,WPAI_P,WC10_D,WC1P_D,WC1M_D,
     *                               WC10_X,WC1P_X,WC1M_X,
     *                               WC20_D,WC21PD,WC21MD,WC22PD,WC22MD,
     *                               WC20_X,WC21PX,WC21MX,WC22PX,WC22MX,
     *                               WPNU00,WPNU10,WPNU1P,WPNU1M,
     *                               WTZISO,WT2ISO,WBZROT,WB2ROT
      COMPLEX
C TER*          CTER_T,
     *          CKER_T,CSKY_T,CKIN_N,CKIN_P,CCOU_D,CCOU_X,CMUL_P,CMAG_T,
     *                                                           CASM_T,
     *          CPAI_N,CPAI_P,CSIF_P,CC10_D,CC1P_D,CC1M_D,
     *                               CC10_X,CC1P_X,CC1M_X,
     *                               CC20_D,CC21PD,CC21MD,CC22PD,CC22MD,
     *                               CC20_X,CC21PX,CC21MX,CC22PX,CC22MX,
     *                               CPNU00,CPNU10,CPNU1P,CPNU1M,
     *                               CTZISO,CT2ISO,CBZROT,CB2ROT
      COMPLEX
     *          TMUL_P,TMAG_T,TASM_T,TSIF_P
      COMPLEX
     *          RKER_T,RSKY_T,RKIN_T,RCOU_D,RCOU_X,RPAI_T,
     *          RMUL_P,RMAG_T,RASM_T,RSIF_P,
     *          RPARTN,RISOSP,
     *          RTZISO,RT2ISO,
     *          RBZROT,RB2ROT
      COMPLEX
     *          BNN_PP,BNN_PM,BNP_PP,BNP_PM,
     *          BPP_PP,BPP_PM,BPN_PP,BPN_PM
      COMPLEX
     *          DKINSQ
C     COMPLEX
C    *          ECC_NP,ECCALL
      COMPLEX
     *          F_KT_L,F_KT_R,OCNMIX,HCNMIX,OVEMIX,ESKMIX
      COMPLEX
     *          TKEISO,TKEIS2
      COMPLEX
     *          PREPFA,TREPFA,PFAWRK,
     *          BTAPLF,BTAPRG,TBTALF,TBTARG,
     *          WARITP
      COMPLEX
     *          PREONI,TREONI,ONIWRK
      COMPLEX
     *          DKOTSN,DKOTSP,DKOTST,
     *          EKOTSN,EKOTSP,EKOTST,
     *          PKOTSN,PKOTSP,PKOTST,
     *          TKOTSN,TKOTSP,TKOTST,
     *          AKOTLN,AKOTLP,AKOTLT,
     *          PKOTLN,PKOTLP,PKOTLT,
     *          PKOTKN,PKOTKP,PKOTKT
      COMPLEX
     *          FACGAP,FACOVT,FACOVR(0:NDISOS)
      COMPLEX
     *          DENSIC,DENCHC,DENSIU
      COMPLEX
     *          QMRMIY,AMRMIY,WMRMIY,SMRMIY
C
C=======================================================================
C          ATTENTION!  BEGINNING WITH VERSION 2.54N, PARAMETER  "NDPROT"
C                      ACQUIRES MODIFIED MEANING, NAMELY, IT NOW DENOTES
C                      THE  MAXIMUM  ALLOWED  VALUE  OF  THE   PROJECTED
C                      ISOSPIN. NOTE THAT  PARAMETER  "NDPROT"  MUST  BE
C                      PROPERLY SET IN ACCORDANCE WITH THE ACTUAL  VALUE
C                      OF ISOSMA, EVEN IF IN  A  GIVEN  RUN  NO  ISOSPIN
C                      PROJECTION IS PERFORMED.
C                      NOTE ALSO THAT BEFORE THE FULL TRANSITION TO  THE
C                      NEW MEANING  IS  FULLY  IMPLEMENTED,  THE  LOWEST
C                      ALLOWED VALUE IS NDPROT=1.
C=======================================================================
C
      DIMENSION
     *          HAMEIG(1:NDPROT)
      DIMENSION
     *          LINE_0(NUMCOL+1),LINE_1(NUMCOL+1),
     *          LINE_2(NUMCOL+1),LINE_3(NUMCOL+1)
C
C=======================================================================
      ALLOCATABLE BNN_PP(:,:,:)
      ALLOCATABLE BNN_PM(:,:,:)
      ALLOCATABLE BNP_PP(:,:,:)
      ALLOCATABLE BNP_PM(:,:,:)
      ALLOCATABLE BPP_PP(:,:,:)
      ALLOCATABLE BPP_PM(:,:,:)
      ALLOCATABLE BPN_PP(:,:,:)
      ALLOCATABLE BPN_PM(:,:,:)
C=======================================================================
      ALLOCATABLE OVRLAP(:,:)
      ALLOCATABLE WARAUX(:,:)
      ALLOCATABLE TARIGH(:,:,:)
      ALLOCATABLE TALEFT(:,:,:)
C=======================================================================
      DIMENSION
     *          AUXDIA(1:4*NDSTAT),IAUXDI(1:4*NDSTAT)
      DIMENSION
     *          DETWRK(2)
C
      COMMON /KNOTS/
     *          XA_PNT(1:NDAKNO),XA_WGT(1:NDAKNO),
     *          XB_PNT(1:NDBKNO),XB_WGT(1:NDBKNO),
     *          XAT_PN(1:NDATKN),XAT_WG(1:NDATKN),
     *          XBT_PN(1:NDBTKN),XBT_WG(1:NDBTKN)
      COMMON /GKNOTS/
     *          XG_PNT(1:NDGAUG),XG_WGT(1:NDGAUG),
     *                           XP_WGT(1:     2)
      COMMON /TKNOTS/
     *          XT_PNT(1:NDGAUG),XT_WGT(1:NDGAUG)
      DIMENSION
     *          ISALGA(1:NDAKNO,1:NDAKNO),
     *          IS_ISO(1:NDATKN,1:NDBTKN),
     *          IS_PRO(1:NDAKNO,1:NDAKNO),
     *          ISAALL(1:NDAKNO,1:NDBKNO,1:NDAKNO,1:NDBTKN),
     *          ISPOIN(1:NDAKNO,1:NDBKNO,1:NDAKNO,
     *                 1:NDATKN,1:NDBTKN,1:NDATKN)
      DIMENSION
     *          HAFLIN(2)
      DIMENSION
     *          KPAHFB(0:NDISOS)
C=======================================================================
C --> PFAFFIAN/ONISHI
      DIMENSION
     *          IDSIZN(1:NDBLOC),
     *          IDSIZP(1:NDBLOC),
     *          LDBLOR(0:NDISOS)
      DIMENSION
     *          IDSIQN(1:NDBLOC),
     *          IDSIQP(1:NDBLOC)
      DIMENSION
     *          IBLQPL(0:1,1:NDBLOC),IBLQPR(0:1,1:NDBLOC)
      DIMENSION
     *          PREPFA(2),PFAWRK(2),TREPFA(2,0:NDISOS)
      DIMENSION
     *          PREONI(2),ONIWRK(2),TREONI(2,0:NDISOS)
      ALLOCATABLE
     *          BTAPLF(:,:),BTAPRG(:,:),TBTALF(:,:,:),TBTARG(:,:,:)
      ALLOCATABLE
     *          WARITP(:,:,:)
C=======================================================================
C --> OVERLAP, SKYRME, AND KINETIC ENRGY KERNELS:
      ALLOCATABLE QPKERN(:,:,:,:)
      ALLOCATABLE ATKERN(:,:,:,:,:)
      ALLOCATABLE WTKERN(:,:,:,:,:)
      ALLOCATABLE SPKERN(:,:,:,:)
C
      ALLOCATABLE TMUL_P(:,:)
      ALLOCATABLE TMAG_T(:,:,:)
      ALLOCATABLE TASM_T(:,:,:)
      ALLOCATABLE TSIF_P(:,:)
C
C TER ALLOCATABLE TEKERN(:,:,:,:,:,:,:)
      ALLOCATABLE OVKERN(:,:,:,:,:,:)
      ALLOCATABLE SKKERN(:,:,:,:,:,:)
      ALLOCATABLE EKKERN(:,:,:,:,:,:)
C
      ALLOCATABLE EPKERN(:,:,:,:,:,:)
C
      ALLOCATABLE CDKERN(:,:,:,:,:,:)
      ALLOCATABLE CDKE10(:,:,:,:,:,:)
      ALLOCATABLE CDKE1P(:,:,:,:,:,:)
      ALLOCATABLE CDKE1M(:,:,:,:,:,:)
      ALLOCATABLE CDKE20(:,:,:,:,:,:)
      ALLOCATABLE CDK21P(:,:,:,:,:,:)
      ALLOCATABLE CDK21M(:,:,:,:,:,:)
      ALLOCATABLE CDK22P(:,:,:,:,:,:)
      ALLOCATABLE CDK22M(:,:,:,:,:,:)
      ALLOCATABLE CXKERN(:,:,:,:,:,:)
      ALLOCATABLE CXKE10(:,:,:,:,:,:)
      ALLOCATABLE CXKE1P(:,:,:,:,:,:)
      ALLOCATABLE CXKE1M(:,:,:,:,:,:)
      ALLOCATABLE CXKE20(:,:,:,:,:,:)
      ALLOCATABLE CXK21P(:,:,:,:,:,:)
      ALLOCATABLE CXK21M(:,:,:,:,:,:)
      ALLOCATABLE CXK22P(:,:,:,:,:,:)
      ALLOCATABLE CXK22M(:,:,:,:,:,:)
      ALLOCATABLE PNKE00(:,:,:,:,:,:)
      ALLOCATABLE PNKE10(:,:,:,:,:,:)
      ALLOCATABLE PNKE1P(:,:,:,:,:,:)
      ALLOCATABLE PNKE1M(:,:,:,:,:,:)
      ALLOCATABLE TZKERN(:,:,:,:,:,:)
      ALLOCATABLE T2KERN(:,:,:,:,:,:)
      ALLOCATABLE BZKERN(:,:,:,:,:,:)
      ALLOCATABLE B2KERN(:,:,:,:,:,:)
C=======================================================================
C TER ALLOCATABLE TETERN(:,:,:,:,:)
      ALLOCATABLE OVTERN(:,:,:,:)
      ALLOCATABLE SKTERN(:,:,:,:)
      ALLOCATABLE EKTERN(:,:,:,:)
C
      ALLOCATABLE EPTERN(:,:,:,:)
C
      ALLOCATABLE CDTERN(:,:,:,:)
      ALLOCATABLE CDTE10(:,:,:,:)
      ALLOCATABLE CDTE1P(:,:,:,:)
      ALLOCATABLE CDTE1M(:,:,:,:)
      ALLOCATABLE CDTE20(:,:,:,:)
      ALLOCATABLE CDT21P(:,:,:,:)
      ALLOCATABLE CDT21M(:,:,:,:)
      ALLOCATABLE CDT22P(:,:,:,:)
      ALLOCATABLE CDT22M(:,:,:,:)
      ALLOCATABLE CXTERN(:,:,:,:)
      ALLOCATABLE CXTE10(:,:,:,:)
      ALLOCATABLE CXTE1P(:,:,:,:)
      ALLOCATABLE CXTE1M(:,:,:,:)
      ALLOCATABLE CXTE20(:,:,:,:)
      ALLOCATABLE CXT21P(:,:,:,:)
      ALLOCATABLE CXT21M(:,:,:,:)
      ALLOCATABLE CXT22P(:,:,:,:)
      ALLOCATABLE CXT22M(:,:,:,:)
      ALLOCATABLE PNTE00(:,:,:,:)
      ALLOCATABLE PNTE10(:,:,:,:)
      ALLOCATABLE PNTE1P(:,:,:,:)
      ALLOCATABLE PNTE1M(:,:,:,:)
      ALLOCATABLE TZTERN(:,:,:,:)
      ALLOCATABLE T2TERN(:,:,:,:)
      ALLOCATABLE BZTERN(:,:,:,:)
      ALLOCATABLE B2TERN(:,:,:,:)
C=======================================================================
C TER ALLOCATABLE CTER_T(:,:,:,:)
      ALLOCATABLE CKER_T(:,:,:)
      ALLOCATABLE CSKY_T(:,:,:)
      ALLOCATABLE CKIN_N(:,:,:)
      ALLOCATABLE CKIN_P(:,:,:)
C
      ALLOCATABLE CPAI_N(:,:,:)
      ALLOCATABLE CPAI_P(:,:,:)
C
      ALLOCATABLE CCOU_D(:,:,:)
      ALLOCATABLE CC10_D(:,:,:)
      ALLOCATABLE CC1P_D(:,:,:)
      ALLOCATABLE CC1M_D(:,:,:)
      ALLOCATABLE CC20_D(:,:,:)
      ALLOCATABLE CC21PD(:,:,:)
      ALLOCATABLE CC21MD(:,:,:)
      ALLOCATABLE CC22PD(:,:,:)
      ALLOCATABLE CC22MD(:,:,:)
      ALLOCATABLE CCOU_X(:,:,:)
      ALLOCATABLE CC10_X(:,:,:)
      ALLOCATABLE CC1P_X(:,:,:)
      ALLOCATABLE CC1M_X(:,:,:)
      ALLOCATABLE CC20_X(:,:,:)
      ALLOCATABLE CC21PX(:,:,:)
      ALLOCATABLE CC21MX(:,:,:)
      ALLOCATABLE CC22PX(:,:,:)
      ALLOCATABLE CC22MX(:,:,:)
      ALLOCATABLE CPNU00(:,:,:)
      ALLOCATABLE CPNU10(:,:,:)
      ALLOCATABLE CPNU1P(:,:,:)
      ALLOCATABLE CPNU1M(:,:,:)
      ALLOCATABLE CTZISO(:,:,:)
      ALLOCATABLE CT2ISO(:,:,:)
      ALLOCATABLE CBZROT(:,:,:)
      ALLOCATABLE CB2ROT(:,:,:)
      ALLOCATABLE ZMUL_P(:,:,:)
      ALLOCATABLE ZMAG_T(:,:,:,:)
      ALLOCATABLE ZASM_T(:,:,:,:)
      ALLOCATABLE ZSIF_P(:,:,:)
      ALLOCATABLE CMUL_P(:,:,:)
      ALLOCATABLE CMAG_T(:,:,:,:)
      ALLOCATABLE CASM_T(:,:,:,:)
      ALLOCATABLE CSIF_P(:,:,:)
C
C=======================================================================
C
      DIMENSION
     *          RMUL_P(0:NDMULR,-NDMULR:NDMULR),
     *          RMAG_T(0:NDMULR,-NDMULR:NDMULR),
     *          RASM_T(0:NDMULR,-NDMULR:NDMULR),
     *          RSIF_P(0:NDMULR,-NDMULR:NDMULR)
      DIMENSION
     *          QDUM_P(0:NDMULT,-NDMULT:NDMULT)
      DIMENSION
     *          ADUM_N(0:NDMULT,-NDMULT:NDMULT,0:NDMORD),
     *          ADUM_P(0:NDMULT,-NDMULT:NDMULT,0:NDMORD)
      DIMENSION
     *          SDUM_P(0:NDMULT,-NDMULT:NDMULT)
      DIMENSION
C TER*          UTER_T(1:NDATKN,-NDPROT:NDPROT,2*NDCOUT),
     *          UKER_T(1:NDATKN,-NDPROT:NDPROT),
     *          USKY_T(1:NDATKN,-NDPROT:NDPROT),
     *          UKIN_N(1:NDATKN,-NDPROT:NDPROT),
     *          UKIN_P(1:NDATKN,-NDPROT:NDPROT),
C
     *          UPAI_N(1:NDATKN,-NDPROT:NDPROT),
     *          UPAI_P(1:NDATKN,-NDPROT:NDPROT),
C
     *          UCOU_D(1:NDATKN,-NDPROT:NDPROT),
     *          UC10_D(1:NDATKN,-NDPROT:NDPROT),
     *          UC1P_D(1:NDATKN,-NDPROT:NDPROT),
     *          UC1M_D(1:NDATKN,-NDPROT:NDPROT),
     *          UC20_D(1:NDATKN,-NDPROT:NDPROT),
     *          UC21PD(1:NDATKN,-NDPROT:NDPROT),
     *          UC21MD(1:NDATKN,-NDPROT:NDPROT),
     *          UC22PD(1:NDATKN,-NDPROT:NDPROT),
     *          UC22MD(1:NDATKN,-NDPROT:NDPROT),
     *          UCOU_X(1:NDATKN,-NDPROT:NDPROT),
     *          UC10_X(1:NDATKN,-NDPROT:NDPROT),
     *          UC1P_X(1:NDATKN,-NDPROT:NDPROT),
     *          UC1M_X(1:NDATKN,-NDPROT:NDPROT),
     *          UC20_X(1:NDATKN,-NDPROT:NDPROT),
     *          UC21PX(1:NDATKN,-NDPROT:NDPROT),
     *          UC21MX(1:NDATKN,-NDPROT:NDPROT),
     *          UC22PX(1:NDATKN,-NDPROT:NDPROT),
     *          UC22MX(1:NDATKN,-NDPROT:NDPROT),
     *          UPNU00(1:NDATKN,-NDPROT:NDPROT),
     *          UPNU10(1:NDATKN,-NDPROT:NDPROT),
     *          UPNU1P(1:NDATKN,-NDPROT:NDPROT),
     *          UPNU1M(1:NDATKN,-NDPROT:NDPROT),
     *          UTZISO(1:NDATKN,-NDPROT:NDPROT),
     *          UT2ISO(1:NDATKN,-NDPROT:NDPROT),
     *          UBZROT(1:NDATKN,-NDPROT:NDPROT),
     *          UB2ROT(1:NDATKN,-NDPROT:NDPROT)
      DIMENSION
C TER*          WTER_T(-NDPROT:NDPROT,-NDPROT:NDPROT,2*NDCOUT),
     *          WKER_T(-NDPROT:NDPROT,-NDPROT:NDPROT),
     *          WSKY_T(-NDPROT:NDPROT,-NDPROT:NDPROT),
     *          WKIN_N(-NDPROT:NDPROT,-NDPROT:NDPROT),
     *          WKIN_P(-NDPROT:NDPROT,-NDPROT:NDPROT),
C
     *          WPAI_N(-NDPROT:NDPROT,-NDPROT:NDPROT),
     *          WPAI_P(-NDPROT:NDPROT,-NDPROT:NDPROT),
C
     *          WCOU_D(-NDPROT:NDPROT,-NDPROT:NDPROT),
     *          WC10_D(-NDPROT:NDPROT,-NDPROT:NDPROT),
     *          WC1P_D(-NDPROT:NDPROT,-NDPROT:NDPROT),
     *          WC1M_D(-NDPROT:NDPROT,-NDPROT:NDPROT),
     *          WC20_D(-NDPROT:NDPROT,-NDPROT:NDPROT),
     *          WC21PD(-NDPROT:NDPROT,-NDPROT:NDPROT),
     *          WC21MD(-NDPROT:NDPROT,-NDPROT:NDPROT),
     *          WC22PD(-NDPROT:NDPROT,-NDPROT:NDPROT),
     *          WC22MD(-NDPROT:NDPROT,-NDPROT:NDPROT),
     *          WCOU_X(-NDPROT:NDPROT,-NDPROT:NDPROT),
     *          WC10_X(-NDPROT:NDPROT,-NDPROT:NDPROT),
     *          WC1P_X(-NDPROT:NDPROT,-NDPROT:NDPROT),
     *          WC1M_X(-NDPROT:NDPROT,-NDPROT:NDPROT),
     *          WC20_X(-NDPROT:NDPROT,-NDPROT:NDPROT),
     *          WC21PX(-NDPROT:NDPROT,-NDPROT:NDPROT),
     *          WC21MX(-NDPROT:NDPROT,-NDPROT:NDPROT),
     *          WC22PX(-NDPROT:NDPROT,-NDPROT:NDPROT),
     *          WC22MX(-NDPROT:NDPROT,-NDPROT:NDPROT),
     *          WPNU00(-NDPROT:NDPROT,-NDPROT:NDPROT),
     *          WPNU10(-NDPROT:NDPROT,-NDPROT:NDPROT),
     *          WPNU1P(-NDPROT:NDPROT,-NDPROT:NDPROT),
     *          WPNU1M(-NDPROT:NDPROT,-NDPROT:NDPROT),
     *          WTZISO(-NDPROT:NDPROT,-NDPROT:NDPROT),
     *          WT2ISO(-NDPROT:NDPROT,-NDPROT:NDPROT),
     *          WBZROT(-NDPROT:NDPROT,-NDPROT:NDPROT),
     *          WB2ROT(-NDPROT:NDPROT,-NDPROT:NDPROT)
      COMMON
     *       /ALLENE/ EKIN_N,EKIN_P,EKIN_T,
     *                EPOT_N,EPOT_P,EPOT_T,
     *                ESUM_N,ESUM_P,ESUM_T,
     *                EPAI_N,EPAI_P,EPAI_T,
     *                EREA_N,EREA_P,EREA_T,
     *                ELIP_N,ELIP_P,ELIP_T,
     *
     *                ECOULD,ECOULE,ECOULT,
     *                       ECOULS,ECOULV,
     *
     *                EMULCO,EMUSLO,EMUREA,
     *                ESIFCO,ESISLO,ESIREA,
     *                ESPICO,ESPSLO,ESPREA,
     *
     *                ENREAR,ECORCM,ECOR_R,
     *
     *                EEVEW0,EODDW0,ENE_W0,
     *                ENEVEN,ENEODD,ENESKY,
     *                ESTABN,ETOTSP,ETOTFU
C TER COMMON
C TER*       /ECCPNM/ ECC_NP(NDCOUT)
C TER COMMON
C TER*       /ECCSKY/ ECCALL(NDCOUT)
      COMMON
     *       /C_SOUR/ SOURCE(NDXHRM,NDYHRM,NDZHRM)
      COMMON
     *       /QMUTTI/ QMUT_N(0:NDMULT,-NDMULT:NDMULT),
     *                QMUT_P(0:NDMULT,-NDMULT:NDMULT),
     *                QMUT_T(0:NDMULT,-NDMULT:NDMULT)
      COMMON
     *       /QMULTI/ QMUL_N(0:NDMULT,-NDMULT:NDMULT),
     *                QMUL_P(0:NDMULT,-NDMULT:NDMULT),
     *                QMUL_T(0:NDMULT,-NDMULT:NDMULT)
      COMMON
     *       /AMUTTI/ AMUT_N(0:NDMULT,-NDMULT:NDMULT,0:NDMORD),
     *                AMUT_P(0:NDMULT,-NDMULT:NDMULT,0:NDMORD),
     *                AMUT_T(0:NDMULT,-NDMULT:NDMULT,0:NDMORD)
      COMMON
     *       /AMULTI/ AMUL_N(0:NDMULT,-NDMULT:NDMULT,0:NDMORD),
     *                AMUL_P(0:NDMULT,-NDMULT:NDMULT,0:NDMORD),
     *                AMUL_T(0:NDMULT,-NDMULT:NDMULT,0:NDMORD)
      COMMON
     *       /WMUTTI/ WMUT_N(0:NDMULT,-NDMULT:NDMULT,0:NDMORD),
     *                WMUT_P(0:NDMULT,-NDMULT:NDMULT,0:NDMORD),
     *                WMUT_T(0:NDMULT,-NDMULT:NDMULT,0:NDMORD)
      COMMON
     *       /WMULTI/ WMUL_N(0:NDMULT,-NDMULT:NDMULT,0:NDMORD),
     *                WMUL_P(0:NDMULT,-NDMULT:NDMULT,0:NDMORD),
     *                WMUL_T(0:NDMULT,-NDMULT:NDMULT,0:NDMORD)
      COMMON
     *       /SMUTTI/ SMUT_N(0:NDMULT,-NDMULT:NDMULT),
     *                SMUT_P(0:NDMULT,-NDMULT:NDMULT),
     *                SMUT_T(0:NDMULT,-NDMULT:NDMULT)
      COMMON
     *       /SMULTI/ SMUL_N(0:NDMULT,-NDMULT:NDMULT),
     *                SMUL_P(0:NDMULT,-NDMULT:NDMULT),
     *                SMUL_T(0:NDMULT,-NDMULT:NDMULT)
      COMMON
     *       /A2BCTI/ A2BCIN(-1:+1),A2BCSA(-1:+1)
      COMMON
     *       /FOR2BC/ MAG2BC(NDF2BC)
      COMMON
     *       /ANGANG/ ANGU_N(1:NDKART),ANGU_P(1:NDKART),ANGU_T(1:NDKART)
      COMMON
     *       /OURUNI/ QUNITS(0:NDMULT,0:NDMULT)
      COMMON
     *       /SIFUNI/ SUNITS(0:NDMULT,0:NDMULT)
      COMMON
     *       /MAGUNI/ AUNITS(0:NDMULT,0:NDMULT)
      COMMON
     *       /ASMUNI/ BUNITS(0:NDMULT,0:NDMULT)
      COMMON
     *       /COEMUL/ COMULT(0:NDMULT,0:NDOSCI,0:NDOSCI,1:NDKART)
      COMMON
     *       /RANGLE/ ALPROT,BETROT,GAMROT
      COMMON
     *       /RANISO/ ALPISO,BETISO,GAMISO
      COMMON
     *       /GANGLE/ PHIGAU
      COMMON
     *       /GTZANG/ PHI_TZ
      COMMON
     *       /DIMENS/ LDBASE
      COMMON
     *       /DIMSTA/ LDTOTS(0:NDISOS),LDSTAT(0:NDISOS),
     *                LDUPPE(0:NDISOS),LDTIMU(0:NDISOS)
      COMMON
     *       /APROJE/ EPROJE(NDPROM,NDISOM),OPROJE(NDPROM,NDISOM)
      COMMON
     *       /CFIPRI/ NFIPRI
      COMMON
     *       /CHARGE/ ECHAR2
      COMMON
     *       /EXCHAN/ COULEX
      COMMON
     *       /LDUNKI/ ECH2_O,COEX_O
      COMMON
     *       /PROIND/ IROMAT(NDPROM),LROMAT(NDPROM),KROMAT(NDPROM)
      COMMON
     *       /PREIND/ IREMAT(NDPROM),LREMAT(NDPROM),KREMAT(NDPROM)
      COMMON
     *       /ISOIND/ ISOMAT(NDISOM),LSOMAT(NDISOM),KSOMAT(NDISOM)
      COMMON
     *       /IMKIND/ INDIMK(0:NDPROI,-NDPROI:NDPROI,-NDPROI:NDPROI)
      COMMON
     *       /IMKRED/ IREIMK(0:NDPROI,-NDPROI:NDPROI,-NDPROI:NDPROI)
      COMMON
     *       /TMKIND/ INDTMK(0:NDPROT,-NDPROT:NDPROT,-NDPROT:NDPROT)
      COMMON
     *       /ISOTOK/ TKEISO(0:NDKART),TKEIS2(0:NDKART)
      COMMON
     *       /ISOTOT/ TOTISO(0:NDKART),TOTIS2(0:NDKART)
      COMMON
     *       /IKETRA/ IKEINV,IKEKAR
      COMMON
     *       /NEWIGN/ NEWWIG
      COMMON
     *       /ROTMOM/ DROTSN(0:NDKART),DROTSP(0:NDKART),DROTST(0:NDKART)
     *               ,EROTSN(0:NDKART),EROTSP(0:NDKART),EROTST(0:NDKART)
     *               ,TROTSN(0:NDKART),TROTSP(0:NDKART),TROTST(0:NDKART)
     *               ,AROTLN(0:NDKART),AROTLP(0:NDKART),AROTLT(0:NDKART)
      COMMON
     *       /KOTMOM/ DKOTSN(0:NDKART),DKOTSP(0:NDKART),DKOTST(0:NDKART)
     *               ,EKOTSN(0:NDKART),EKOTSP(0:NDKART),EKOTST(0:NDKART)
     *               ,TKOTSN(0:NDKART),TKOTSP(0:NDKART),TKOTST(0:NDKART)
     *               ,AKOTLN(0:NDKART),AKOTLP(0:NDKART),AKOTLT(0:NDKART)
      COMMON
     *       /ROTPAI/ PROTSN(0:NDKART),PROTSP(0:NDKART),PROTST(0:NDKART)
     *               ,PROTLN(0:NDKART),PROTLP(0:NDKART),PROTLT(0:NDKART)
     *               ,PROTKN(0:NDKART),PROTKP(0:NDKART),PROTKT(0:NDKART)
      COMMON
     *       /KOTPAI/ PKOTSN(0:NDKART),PKOTSP(0:NDKART),PKOTST(0:NDKART)
     *               ,PKOTLN(0:NDKART),PKOTLP(0:NDKART),PKOTLT(0:NDKART)
     *               ,PKOTKN(0:NDKART),PKOTKP(0:NDKART),PKOTKT(0:NDKART)
      COMMON
     *       /JPA2HF/ DEL2HF(0:NDISOS),IPA2HF(0:NDISOS)
      COMMON
     *       /DATPAN/ GPAIRN,FACTGN,EFERMN,DELTAN,EFER2N
     *       /DATPAP/ GPAIRP,FACTGP,EFERMP,DELTAP,EFER2P
      COMMON
     *       /FERMIL/ F_KT_L(-NDPROI:NDPROI,0:NDPROT,-NDPROT:NDPROT),
     *                EIGE_L,IDIM_L,IIFERL,ITFERL,ISFERL
      COMMON
     *       /FERMIR/ F_KT_R(-NDPROI:NDPROI,0:NDPROT,-NDPROT:NDPROT),
     *                EIGE_R,IDIM_R,IIFERR,ITFERR,ISFERR
      COMMON
     *       /KONFIG/ OCNMIX(NDCONF,NDCONF),HCNMIX(NDCONF,NDCONF),
     *                OVEMIX(NDKERN,NDKERN,NDRZUT,NDRZUT,NDPROT)
      COMMON
     *       /ENEMIX/ ESKMIX(NDKERN,NDKERN,NDRZUT,NDRZUT,NDPROT)
      COMMON
     *       /DENTOC/ DENSIC(NDXHRM,NDYHRM,NDZHRM,NDTWHE),
     *                DENCHC(NDXHRM,NDYHRM,NDZHRM)
      COMMON
     *       /DENTOU/ DENSIU(NDXHRM,NDYHRM,NDZHRM)
      COMMON
     *       /IDENTU/ IDENSU,JDENSU
      COMMON
     *       /IPRIAM/ ILIMAM,IALLAM
      COMMON
     *       /KERNAM/ FILLEF(NDCONF),FILRIG(NDCONF),NUCONF,NAMKER
      COMMON
     *       /ALCONF/ INCONF(NDCONF),ILCONF,MICONF(NDCONF),MIXNUM
      COMMON
     *       /ALLPRO/ NUMPRO(0:NDPROI,0:NDISOM)
      COMMON
     *       /ALLLEF/ NUMLEF(0:NDPROI,0:NDISOM)
      COMMON
     *       /COLMIX/ MIXCOL(0:NDPROI,0:NDISOM,NDCONF)
      COMMON
     *       /GYROSC/ GYRORP,GYRSPN,GYRSPP,IGYROS
      COMMON
     *       /GEF2BC/ GIN2BC,GSA2BC,IGY2BC
      COMMON
     *       /GAUMAX/ NXHERM,NYHERM,NZHERM
C=======================================================================
      DATA
     *       NAMMUL /'MULTIPOLE MOMENTS [UNITS:  (10 FERMI)^LAMBDA]'/,
     *       NAMSUR /'SURFACE MOMENTS, UNITS: (10 FERMI)^(LAMBDA+2)'/,
     *       NAMSCH /'SCHIFF MOMENTS,  UNITS: (10 FERMI)^(LAMBDA+2)'/,
     *       NAMMAG /'P+N MAGNETIC MOMENTS [MGNTN*FERMI^(LAMBDA-1)]'/,
     *       NAMMAR /'P+N MAGNETIC MOMENTS [MTN*FERMI^(N+LAMBDA-1)]'/,
     *       NAMASM /'P+N SPIN-ASM MOMENTS [MGNTN*FERMI^(LAMBDA+1)]'/,
     *       NAMASR /'P+N SPIN-ASM MOMENTS [MTN*FERMI^(N+LAMBDA+1)]'/
      DATA
     *      IVERKE/13/,IVERK2/12/
C
      KPRSTA(IPRDUM)=IAXIAL*KPROJE-(1-IAXIAL)*IPRDUM
      KPRSTO(IPRDUM)=IAXIAL*KPROJE+(1-IAXIAL)*IPRDUM
C
      LPRSTA(IPRDUM)=IAXIAL*KPLEFT-(1-IAXIAL)*IPRDUM
      LPRSTO(IPRDUM)=IAXIAL*KPLEFT+(1-IAXIAL)*IPRDUM
C
      KSOSTA(IPRDUM)=IAXIAT*ISOSTZ-(1-IAXIAT)*IPRDUM
      KSOSTO(IPRDUM)=IAXIAT*ISOSTZ+(1-IAXIAT)*IPRDUM
C
      IND_LM(LAMDUM,MIUDUM)=LAMDUM**2+LAMDUM+MIUDUM+1
      IND_IK(IPRDUM,KPRDUM)=(IPRDUM**2-IHALF_)/4+(IPRDUM+KPRDUM)/2+1
C
      CALL CPUTIM('PROANG',1)
C
C=======================================================================
C
      IALLOC=0
C
      IF (.NOT.ALLOCATED(WARIGH)) THEN
          ALLOCATE (WARIGH(1:NDBASE,1:4*NDSTAT,0:NDSPIN),STAT=IALLOC)
          IF (IALLOC.NE.0) CALL NOALLO('WARIGH','PROANG')
      END IF
C=======================================================================
      IF (.NOT.ALLOCATED(WALEFT)) THEN
          ALLOCATE (WALEFT(1:NDBASE,1:4*NDSTAT,0:NDSPIN),STAT=IALLOC)
          IF (IALLOC.NE.0) CALL NOALLO('WALEFT','PROANG')
      END IF
C=======================================================================
      IF (.NOT.ALLOCATED(REDQ_P)) THEN
          ALLOCATE (REDQ_P(0:NDREDU),STAT=IALLOC)
          IF (IALLOC.NE.0) CALL NOALLO('REDQ_P','PROANG')
      END IF
C=======================================================================
      IF (.NOT.ALLOCATED(REDM_P)) THEN
          ALLOCATE (REDM_P(0:NDREDU,0:NMAORD),STAT=IALLOC)
          IF (IALLOC.NE.0) CALL NOALLO('REDM_P','PROANG')
      END IF
C=======================================================================
      IF (.NOT.ALLOCATED(REDA_T).AND.NASORD.GE.0) THEN
          ALLOCATE (REDA_T(0:NDREDU,0:NASORD),STAT=IALLOC)
          IF (IALLOC.NE.0) CALL NOALLO('REDA_T','PROANG')
      END IF
C=======================================================================
      IF (.NOT.ALLOCATED(REDS_P)) THEN
          ALLOCATE (REDS_P(0:NDREDU),STAT=IALLOC)
          IF (IALLOC.NE.0) CALL NOALLO('REDS_P','PROANG')
      END IF
C=======================================================================
      IF (.NOT.ALLOCATED(INDRED)) THEN
          ALLOCATE (INDRED(NDPROK,0:NDMULR,NDPROK),STAT=IALLOC)
          IF (IALLOC.NE.0) CALL NOALLO('INDRED','PROANG')
      END IF
C=======================================================================
      ALLOCATE (OVRLAP(1:4*NDSTAT,1:4*NDSTAT),STAT=IALLOC)
      IF (IALLOC.NE.0) CALL NOALLO('OVRLAP','PROANG')
C=======================================================================
      ALLOCATE (WARAUX(1:4*NDSTAT,0:NDSPIN),STAT=IALLOC)
      IF (IALLOC.NE.0) CALL NOALLO('WARAUX','PROANG')
C=======================================================================
C WHEN PAIRIING IS ON, THE DIMENSION SHOULD BE DOUBLED
      IF(IPAHFB.EQ.0)THEN
         ALLOCATE (TARIGH(1:2*NDBASE,1:4*NDSTAT,0:NDSPIN),STAT=IALLOC)
         IF (IALLOC.NE.0) CALL NOALLO('TARIGH','PROANG')
C=======================================================================
         ALLOCATE (TALEFT(1:2*NDBASE,1:4*NDSTAT,0:NDSPIN),STAT=IALLOC)
         IF (IALLOC.NE.0) CALL NOALLO('TALEFT','PROANG')
C=======================================================================
      ELSE
         ALLOCATE (TARIGH(1:2*NDBASE,1:8*NDSTAT,0:NDSPIN),STAT=IALLOC)
         IF (IALLOC.NE.0) CALL NOALLO('TARIGH','PROANG')
C=======================================================================
         ALLOCATE (TALEFT(1:2*NDBASE,1:8*NDSTAT,0:NDSPIN),STAT=IALLOC)
         IF (IALLOC.NE.0) CALL NOALLO('TALEFT','PROANG')
C=======================================================================
         ALLOCATE (WARITP(1:NDBASE,1:4*NDSTAT,0:NDSPIN),STAT=IALLOC)
         IF (IALLOC.NE.0) CALL NOALLO('WARITP','PROANG')
      END IF
C=======================================================================
      ALLOCATE (BNN_PP(1:NDBASE,1:NDBASE,0:NDREVE),STAT=IALLOC)
      IF (IALLOC.NE.0) CALL NOALLO('BNN_PP','PROANG')
      ALLOCATE (BNP_PP(1:NDBASE,1:NDBASE,0:NDREVE),STAT=IALLOC)
      IF (IALLOC.NE.0) CALL NOALLO('BNP_PP','PROANG')
      ALLOCATE (BPP_PP(1:NDBASE,1:NDBASE,0:NDREVE),STAT=IALLOC)
      IF (IALLOC.NE.0) CALL NOALLO('BPP_PP','PROANG')
      ALLOCATE (BPN_PP(1:NDBASE,1:NDBASE,0:NDREVE),STAT=IALLOC)
      IF (IALLOC.NE.0) CALL NOALLO('BPN_PP','PROANG')
C=======================================================================
      IF (ISIMPY.NE.1) THEN
          ALLOCATE (BNN_PM(1:NDBASE,1:NDBASE,0:NDREVE),STAT=IALLOC)
          IF (IALLOC.NE.0) CALL NOALLO('BNN_PM','PROANG')
          ALLOCATE (BNP_PM(1:NDBASE,1:NDBASE,0:NDREVE),STAT=IALLOC)
          IF (IALLOC.NE.0) CALL NOALLO('BNP_PM','PROANG')
          ALLOCATE (BPP_PM(1:NDBASE,1:NDBASE,0:NDREVE),STAT=IALLOC)
          IF (IALLOC.NE.0) CALL NOALLO('BPP_PM','PROANG')
          ALLOCATE (BPN_PM(1:NDBASE,1:NDBASE,0:NDREVE),STAT=IALLOC)
          IF (IALLOC.NE.0) CALL NOALLO('BPN_PM','PROANG')
      END IF
C=======================================================================
      ALLOCATE (ZMUL_P(1:NDAKNO,-NDPROI:NDPROI,NDMULM),
     *                                          STAT=IALLOC)
      IF (IALLOC.NE.0) CALL NOALLO('ZMUL_P','PROANG')
      ALLOCATE (ZMAG_T(1:NDAKNO,-NDPROI:NDPROI,NDMULM,0:NMAORD),
     *                                          STAT=IALLOC)
      IF (IALLOC.NE.0) CALL NOALLO('ZMAG_T','PROANG')
      ALLOCATE (ZSIF_P(1:NDAKNO,-NDPROI:NDPROI,NDMULM),
     *                                          STAT=IALLOC)
      IF (IALLOC.NE.0) CALL NOALLO('ZSIF_P','PROANG')
      IF (NASORD.GE.0)
     *ALLOCATE (ZASM_T(1:NDAKNO,-NDPROI:NDPROI,NDMULM,0:NASORD),
     *                                          STAT=IALLOC)
      IF (IALLOC.NE.0) CALL NOALLO('ZASM_T','PROANG')
C=======================================================================
      ALLOCATE (CMUL_P(-NDPROI:NDPROI,-NDPROI:NDPROI,NDMULM),
     *                                          STAT=IALLOC)
      IF (IALLOC.NE.0) CALL NOALLO('CMUL_P','PROANG')
      ALLOCATE (CMAG_T(-NDPROI:NDPROI,-NDPROI:NDPROI,NDMULM,0:NMAORD),
     *                                          STAT=IALLOC)
      IF (IALLOC.NE.0) CALL NOALLO('CMAG_T','PROANG')
      ALLOCATE (CSIF_P(-NDPROI:NDPROI,-NDPROI:NDPROI,NDMULM),
     *                                          STAT=IALLOC)
      IF (IALLOC.NE.0) CALL NOALLO('CSIF_P','PROANG')
      IF (NASORD.GE.0)
     *ALLOCATE (CASM_T(-NDPROI:NDPROI,-NDPROI:NDPROI,NDMULM,0:NASORD),
     *                                          STAT=IALLOC)
      IF (IALLOC.NE.0) CALL NOALLO('CASM_T','PROANG')
C=======================================================================
C
      IF(MREVER.EQ.0) STOP
     *   'MREVER=0 NOT ALLOWED IN PROANG (SEE DENSHF)'
C
C=======================================================================
C        THE SUBROUTINE CALCULATES THE OVERLAPS AND KERNELS OF OPERATORS
C        FOR STATES PROJECTED ON THE ANGULAR  MOMENTUM  AND/OR  ISOSPIN.
C
C        IT CAN BE CALLED IN THREE BASIC VARIANTS: (COMMENTS UNFINISHED)
C
C=======================================================================
C     ATTENTION!  STARTING FROM VERSION 2.79G, THE CODE  CALCULATES  THE
C                 TOTAL (PROTON+NEUTRON) MAGNETIC MOMENTS. CONSEQUENTLY,
C                 THE TOTAL MAGNETIC MOMENTS ARE STORED  ON  THE  KERNEL
C                 FILES. THEREFORE, BY READING THE OLD KERNEL FILES WITH
C                 IVERKE<10 OR IVERK2<3, ONE WILL HAVE  PROTON  MAGNETIC
C                 MOMENTS CALCULATED AND PRINTED INSTEAD  OF  THE  TOTAL
C                 ONES.
C                 THIS MODIFICATION WAS IMPLEMENTED ON 14/04/2017.
C=======================================================================
C     ATTENTION!  STARTING FROM VERSION 2.89L, THE CODE STORES ON THE
C                 KERNEL FILES ALL THE CALCULATED KERNELS. UP TO THAT
C                 VERSION, FOR NBTKNO=1 ONLY SOME KERNELS WERE STORED
C                 REGARDLESS OF THE FACT THAT THOSE NOT  STORED  WERE
C                 LATER USED. THIS WAS  CAUSING  ERRACTIC  PRINTOUNTS
C                 AND DIFFERENCES BETWEEN RESULTS  OBTAINED  IN  RUNS
C                 WHERE  KERNELS  WERE  CALCULATED  AND  THOSE  WHERE
C                 KERNELS WERE READ.
C                 THIS MODIFICATION WAS IMPLEMENTED ON 24/03/2019.
C=======================================================================
C     ATTENTION!  CALCULATION  OF  THE  PAIRING  KERNELS,  WHICH  WAS
C                 IMPLEMENTED IN VERSION 2.65F, WAS  NOT  ACCOMPANIED
C                 BY STORING  THEM  ON  THE  KERNEL  FILE.  THIS  WAS
C                 CAUSING ERRACTIC PRINTOUNTS AND DIFFERENCES BETWEEN
C                 RESULTS  OBTAINED  IN  RUNS  WHERE   KERNELS   WERE
C                 CALCULATED  AND  THOSE  WHERE  KERNELS  WERE  READ.
C                 THIS BUG WAS NOT CORRECTED ON 24/03/2019 ABOVE, BUT
C                 IT WAS CORRECTED ON 21/05/2019 IN VERSION 2.90J.
C=======================================================================
C
C          VERIFY COULOMB CALCULATION VARIANT
C
C=======================================================================
C
                                       ICOUVE=0
      IF (ICOUDI.EQ.0.AND.ICOUEX.EQ.0) ICOUVE=1
      IF (ICOUDI.EQ.1.AND.ICOUEX.EQ.1) ICOUVE=1
      IF (ICOUDI.EQ.2.AND.ICOUEX.EQ.2) ICOUVE=1
      IF (ICOUVE.EQ.0) THEN
      WRITE (*,467) ICOUDI, ICOUEX
 467  FORMAT (2X,'COULOMB VERSION ICOUDI=',I2,' ICOUEX=',I2,
     *             ' IS NOT SUPPORTED IN PROANG')
      STOP
      END IF
C
CWS      ECHAR2=1.43986
      ECHAR2 = ECH2_O
      COULEX = COEX_O
C
      PI=4.0D0*ATAN(1.0D0)
C
      C_ZERO=CMPLX(0.0D0,0.0D0)
      C_UNIT=CMPLX(1.0D0,0.0D0)
      UNIT_I=CMPLX(0.0D0,1.0D0)
C
      NAMEPN='DUMMY   '
      PRINIT=.FALSE.
C
      I_YUKA=0
      ISGOGA=0
      ISREGA=0
      ISSEPA=0
C
      IF (NBTKNO.GT.1.AND.LDPNMX.NE.3)
     *    STOP ' NBTKNO.GT.1 REQUIRES LDPNMX=3 IN PROANG'
C
      JMULMO=MAX(NMUCOU,NMURED)
      JSIFMO=NSIRED
C
C=======================================================================
C     ATTENTION!  STARTING FROM VERSION 2.49T, THE CODE  CAN  CALCULATE
C                 THE TRANSITION MATRIX ELEMENTS OF THE SURFACE MOMENTS
C                 FOR LAMBDA=0. THIS MEANS THAT NSIRED=0 DOES  NOT  ANY
C                 MORE SWITCHES THE CALCULATION OF THE SURFACE  MOMENTS
C                 OFF. TO SWITCH THEM OFF, ONE MUST SET NSIRED=-1.  FOR
C                 COMPATIBILITY  REASONS,  THE  SURFACE   MOMENTS   ARE
C                 CALCULATED STARTING FROM LAMBDA=NSIMIN, WHERE  NSIMIN
C                 IS SET TO 1 IF THE OLD (FOR IVERKE<8) KERNEL FILE  IS
C                 READ.
C=======================================================================
C         ATTENTION: BETWEEN VERSIONS (2.49T) AND  (3.12A),  CALCULATION
C                    OF THE TRANSITION MATRIX ELEMENTS  OF  THE  SURFACE
C                    MOMENTS FOR LAMBDA=0 WAS  IMPLEMENTED  INCORRECTLY,
C                    BECAUSE SUBROUTINE MOMSIF WAS NOT SET TO  CALCULATE
C                    THEM. THIS  BUG  WAS  CORRECTED IN VERSION  (3.12D)
C                    ON 24/04/2022.
C=======================================================================
C
      NSIMIN=0
C
C=======================================================================
C        HERE WE SET THE SWITCH THAT INDICATES WHETHER SPIN AND  ISOSPIN
C        ARE INTEGER OR HALF-INTEGER. IN THE CASE WHERE THERE IS NEITHER
C        SPIN NOR ISOSPIN PROJECTION, WE ARBITRARILY SET THIS SWITCH  AS
C        DICTATED BY THE SPIN PROJECTION PARAMETER "IPROMA".
C=======================================================================
C            ATTENTION: BETWEEN VERSIONS (2.65B) AND (2.75G), THE  LOGIC
C                       BELOW WAS INCORRECT AND THUS IN THE CASE  OF  NO
C                       SPIN  AND  ISOSPIN  PROJECTION,  THE  CODE   WAS
C                       STOPPED FOR NO REASON. THIS  BUG  WAS  CORRECTED
C                       IN VERSION (2.75H) ON 13/12/2015.
C=======================================================================
C
      IHALFI=MOD(IPROMA,2)
      IHALFT=MOD(ISOSMA,2)
      IHALF_=-1
C
      IF (NUBKNO.GT.1.AND.NBTKNO.GT.1) THEN
C
          IF (IHALFI.NE.IHALFT)
     *        STOP 'INCOMPATIBLE IHALFI AND IHALFT IN PROANG'
C
          IHALF_=IHALFI
C
      ELSE
C
          IF (NUBKNO.GT.1.AND.NBTKNO.EQ.1) IHALF_=IHALFI
          IF (NUBKNO.EQ.1.AND.NBTKNO.GT.1) IHALF_=IHALFT
          IF (NUBKNO.EQ.1.AND.NBTKNO.EQ.1) IHALF_=IHALFI
C
      END IF
C
      IF (IHALF_.EQ.-1) STOP 'IHALF_ NOT SET IN PROANG'
C
                       CHALF_='  '
      IF (IHALF_.EQ.1) CHALF_='/2'
C
      IEVEN_=2/(IHALF_+1)
C
      IF (ICOMIX.EQ.0) WRITE(NFIPRI,'(79(1H*),/,1H*,77X,1H*)')
C
C=======================================================================
C        HERE WE SET SWITCHES THAT HAVE THE FOLLOWING MEANING:
C        LPROJJ=1(0) MEANS THAT THERE IS (IS NOT) PROJECTION ON SPIN
C        LPROJT=1(0) MEANS THAT THERE IS (IS NOT) PROJECTION ON ISOSPIN
C=======================================================================
C                   VERIFY PROJECTION VARIANT
C=======================================================================
C
      LPROJT=1
      LPROJJ=1
      IF (NUAKNO*NUBKNO.EQ.1.AND.NBTKNO.GT.1) LPROJJ=0
      IF (                       NBTKNO.EQ.1) LPROJT=0
C
      IF (N_CALL.EQ.1.AND.ICOMIX.EQ.0) THEN
C
          IF (NBTKNO.GT.1.AND.NATKNO.EQ.1)
     *        WRITE (*,'(1H*,20X,''AXIAL ISOSPIN '',
     *                           ''PROJECTION IS PERFORMED'', 20X,1H*)')
          IF (NBTKNO.GT.1.AND.NATKNO.GT.1)
     *        WRITE (*,'(1H*,23X,''3D ISOSPIN '',
     *                           ''PROJECTION IS PERFORMED'', 20X,1H*)')
          IF (NUBKNO.GT.1.AND.NUAKNO.EQ.1)
     *        WRITE (*,'(1H*,11X,''AXIAL ANGULAR-MOMENTUM '',
     *                           ''PROJECTION IS PERFORMED'', 20X,1H*)')
          IF (NUBKNO.GT.1.AND.NUAKNO.GT.1)
     *        WRITE (*,'(1H*,14X,''3D ANGULAR-MOMENTUM '',
     *                           ''PROJECTION IS PERFORMED'', 20X,1H*)')
          IF (NPNKNO.GT.1)
     *        WRITE (*,'(1H*,12X,''TOTAL PARTICLE-NUMBER '',
     *                           ''PROJECTION IS PERFORMED'',1X,
     *                           ''ON A ='',I3,               10X,1H*)')
     *        IN_FIX+IZ_FIX
C
          IF (NTZKNO.GT.1)
     *        WRITE (*,'(1H*,12X,''TOTAL ISOVECTR-NUMBER '',
     *                           ''PROJECTION IS PERFORMED'',1X,
     *                           ''ON 2*TZ='',I3,              8X,1H*)')
     *        IN_FIX-IZ_FIX
C
          IF (NPAKNO.GT.1) THEN
              IF (IPAPRO.EQ.+1)
     *        WRITE (*,'(1H*,27X,''PARITY '',
     *                           ''PROJECTION IS PERFORMED'',1X,
     *                           ''ON PI=+1'',                11X,1H*)')
              IF (IPAPRO.EQ.-1)
     *        WRITE (*,'(1H*,27X,''PARITY '',
     *                           ''PROJECTION IS PERFORMED '',
     *                           ''ON PI=-1'',                11X,1H*)')
          END IF
C
          IF (ICSKIP.NE.0.AND.ICOUDI.NE.0) WRITE (*,69)
 69       FORMAT(1H*,9X,
     *    'TEST RUN WITH THE COULOMB INTERACTION SET TO ZERO IN PROANG',
     *     9X,1H*)
C
          WRITE (*,'(1H*,77X,1H*)')
C
      END IF
C
      JCSKIP=ICSKIP
      IF (ICOUDI.EQ.0.AND.ICOUEX.EQ.0) JCSKIP=1
C
C=======================================================================
C       VERIFY CONSITENCY BETWEEN COULOMB AND PROJECTON VARIANTS
C=======================================================================
C
      IF (LPROJT.EQ.1.AND.ICOUDI.EQ.1.AND.ICOUEX.EQ.1) THEN
      WRITE(*,70)
 70   FORMAT(1H*,77X,1H*,/,
     *       1H*,5X,'ISOSPIN PROJECTION IS NOT SUPPORTED FOR ',
     *              'ICOUDI.EQ.1 AND ICOUEX.EQ.1',5X,1H*,/,
     *       1H*,77X,1H*,/,79(1H*))
      STOP
      ENDIF
C
C=======================================================================
C       VERIFY CONSITENCY WITH C-O-M AND ROTATIONAL CORRECTIONS
C=======================================================================
C
      IF (KETA_R.EQ.1.OR.KETA_R.EQ.2)
     *    WRITE(NFIPRI,'(
     *             1H*,20(1H/),'' WARNING!  WARNING  WARNING '',
     *                      '' WARNING'',       1X,20(1H/),1H*,/,
     *             1H*,20(1H/),'' ROTATIONAL CORRECTION HAS'',
     *                      '' _NOT_ YET'',     1X,20(1H/),1H*,/,
     *             1H*,20(1H/),'' BEEN IMPLEMENTED IN PROANG '',
     *                      ''        '',       1X,20(1H/),1H*,/,
     *                                             1H*,77X,1H*)')
C
      IF (JETACM.EQ.1.OR.JETACM.EQ.2)
     *    WRITE(NFIPRI,'(
     *             1H*,20(1H/),'' WARNING!  WARNING  WARNING '',
     *                      '' WARNING'',       1X,20(1H/),1H*,/,
     *             1H*,20(1H/),'' CEN-O-MASS CORRECTION HAS'',
     *                      '' _NOT_ YET'',     1X,20(1H/),1H*,/,
     *             1H*,20(1H/),'' BEEN IMPLEMENTED IN PROANG '',
     *                      ''        '',       1X,20(1H/),1H*,/,
     *                                             1H*,77X,1H*)')
C
C=======================================================================
C         HERE WE SET LIMITS ON THE GAUSS KNOTS IN CASE OF THE
C         PARALLEL CALCULATION
C=======================================================================
C
      IF (IPAKER.EQ.1) THEN
C
          NUABEG=NUASTA
          NUAEND=NUASTO
          NUGBEG=NUGSTA
          NUGEND=NUGSTO
C
          IF (IPAALL.EQ.1) THEN
C
              NUBBEG=NUBSTA
              NUBEND=NUBSTO
              NBTBEG=NUTSTA
              NBTEND=NUTSTO
C
          ELSE
C
              NUBBEG=1
              NUBEND=NUBKNO
              NBTBEG=1
              NBTEND=NBTKNO
C
          END IF
C
          IF (IPAK3D.EQ.1) THEN
C
              NATBEG=NATSTA
              NATEND=NATSTO
              NGTBEG=NGTSTA
              NGTEND=NGTSTO
C
          ELSE
C
              NATBEG=1
              NATEND=NATKNO
              NGTBEG=1
              NGTEND=NATKNO
C
          END IF
C
      ELSE
C
          NUABEG=1
          NUAEND=NUAKNO
          NUGBEG=1
          NUGEND=NUAKNO
C
          NATBEG=1
          NATEND=NATKNO
          NGTBEG=1
          NGTEND=NATKNO
C
          NUBBEG=1
          NUBEND=NUBKNO
          NBTBEG=1
          NBTEND=NBTKNO
C
      END IF
C
C=======================================================================
C         CALCULATION OF KNOTS AND WEIGHTS  FOR  THE  GAUSS-LEGENDRE
C         QUADRATURE TO BE USED FOR THE INTEGRATION OVER  THE  EULER
C         ANGLE BETA
C
C         THE INTEGRAL OVER BETA WITHIN [0,PI] LIMITS IS REPLACED BY
C                      I = INTEGRAL[-1,1] dx W_n (x)
C         WHERE  x=COS(BETA) AND W_n IS A POLYNOMIAL.
C
C         HENCE, THE GAUSS-LEGENDRE FORMULA TO BE USED IS
C                      I = SUM_J XB_WGT(J)*d^I_MK(XB_PNT(J))
C                        * KERNEL{XA_PNT(I),XB_PNT(J),XA_PNT(K)}
C=======================================================================
C
      IF (NUBKNO.EQ.1) THEN
C
         XB_WGT(1)=1.0D0
         XB_PNT(1)=0.0D0
C
      ELSE
C
          CALL GAULEG(-1.D0,1.D0,XB_PNT,XB_WGT,NUBKNO)
C
          DO I=1,NUBKNO
C
             XB_PNT(I)=ACOS(XB_PNT(I))
C
          END DO
C
      END IF
C
C=======================================================================
C         CALCULATION OF KNOTS AND WEIGHTS  FOR  THE  GAUSS-TCHEBYSCHEV
C         QUADRATURE TO BE USED FOR  THE  INTEGRATION  OVER  THE  EULER
C         ANGLES ALPHA AND GAMMA
C
C         THE GAUSS-TCHEBYSCHEV FORMULA TO BE USED IS
C          I =SUM_I XA_WGT(I) * EXP(-iM*XA_PNT(I))
C                             * KERNEL{XA_PNT(I),XB_PNT(J),XA_PNT(K)}
C
C         FOR NUAKNO=1, THE INTEGRATIONS OVER ALPHA AND GAMMA  ARE  NOT
C         PERFORMED AND THE STATE IS ASSUMED AXIAL WITH THE  PROJECTION
C         ON THE Z AXIS EQUAL KPROJE/2.
C=======================================================================
C
      IF (NUAKNO.EQ.1) THEN
C
          IAXIAL=1
          IF (LPROJJ.EQ.0) IAXIAL=0
C
          XA_WGT(1)=2*PI
          XA_PNT(1)=0.0D0
C
          IF (ABS(KPROJE-2*ANGU_T(3)).GT.0.001.AND.IDIAGO.EQ.1) THEN
C
              WRITE(NFIPRI,'(
     *                 1H*,20(1H/),'' WARNING!  WARNING  WARNING '',
     *                          '' WARNING'',       1X,20(1H/),1H*,/,
     *                 1H*,20(1H/),''                            '',
     *                          ''        '',       1X,20(1H/),1H*,/,
     *                 1H*,20(1H/),'' VALUE OF KPROJE ='',I3,
     *                          '' FOR 1D ANGULAR'',1X,20(1H/),1H*,/,
     *                 1H*,20(1H/),'' MOMENTUM PROJECTION SHOULD BE'',
     *                          '' EQUAL'',         1X,20(1H/),1H*,/,
     *                 1H*,20(1H/),'' TO TWICE PROJECTION ON  THE'',
     *                          '' Z-AXIS,'',       1X,20(1H/),1H*,/,
     *                 1H*,20(1H/),'' WHICH NOW EQUALS'',F9.5,
     *                            '' IN PROANG'',   1X,20(1H/),1H*,/,
     *                                                 1H*,77X,1H*)')
     *         KPROJE,ANGU_T(3)
C
C             STOP ' INCORRECT VALUE OF KPROJE IN PROANG'
C
          END IF
C
      ELSE
C
          IAXIAL=0
C
          DO I=1,NUAKNO
C
             XA_WGT(I)=2*PI/NUAKNO
             XA_PNT(I)=(2*I-1)*PI/NUAKNO
C
          END DO
C
      END IF
C
C=======================================================================
C         CALCULATION OF KNOTS AND WEIGHTS  FOR  THE  GAUSS-LEGENDRE
C         QUADRATURE TO BE USED FOR THE INTEGRATION OVER  THE  EULER
C         ANGLE BETA_T IN CASE OF ISOSPIN PROJECTION
C
C         THE INTEGRAL OVER BETA WITHIN [0,PI] LIMITS IS REPLACED BY
C                      I = INTEGRAL[-1,1] dx W_n (x)
C         WHERE  x=COS(BETA_T) AND W_n IS A POLYNOMIAL.
C
C         HENCE, THE GAUSS-LEGENDRE FORMULA TO BE USED IS
C                      I = SUM_J XBT_WG(J)*d^T_TzTz(XBT_PN(J))
C                        * KERNEL{XBT_PN(J)}
C         IN ANALOGY TO THE AMP
C=======================================================================
C
      IF (NBTKNO.EQ.1) THEN
C
          XBT_WG(1)=1.0D0
          XBT_PN(1)=0.0D0
C
      ELSE
C
          CALL GAULEG(-1.D0,1.D0,XBT_PN,XBT_WG,NBTKNO)
C
          DO I=1,NBTKNO
C
             XBT_PN(I)=ACOS(XBT_PN(I))
C
          END DO
C
      END IF
C
      IF (NATKNO.EQ.1) THEN
C
          IAXIAT=1
CJD ???   IF (LPROJT.EQ.0) IAXIAT=0
C
          XAT_WG(1)=2*PI
          XAT_PN(1)=0.0D0
C
      ELSE
C
          IAXIAT=0
C
          DO I=1,NATKNO
C
             XAT_WG(I)=2*PI/NATKNO
             XAT_PN(I)=(2*I-1)*PI/NATKNO
C
          END DO
C
      END IF
C
C=======================================================================
C         CALCULATION OF KNOTS AND WEIGHTS  FOR  THE  GAUSS-TCHEBYSCHEV
C         QUADRATURE TO BE USED FOR  THE  INTEGRATION  OVER  THE  GAUGE
C         ANGLES PHI
C
C         THE GAUSS-TCHEBYSCHEV FORMULA TO BE USED IS
C          I =SUM_I XG_WGT(I) * EXP(-iA*XG_PNT(I))
C                             * KERNEL{XG_PNT(I)}
C
C         FOR NPNKNO=1, THE INTEGRATION OVER  THE  GAUGE  ANGLE  IS  NOT
C         PERFORMED.
C=======================================================================
C
      IF (NPNKNO.GT.NDGAUG) STOP 'INCREASE NDGAUG FOR NPNKNO IN PROANG'
      IF (NTZKNO.GT.NDGAUG) STOP 'INCREASE NDGAUG FOR NTZKNO IN PROANG'
C
C=======================================================================
C            ATTENTION: BETWEEN VERSIONS (2.994) AND  (3.01D),  VARIABLE
C            "NPNPAR" BELOW WAS SET WHEN READING KERNELS FROM THE KERNEL
C            FILE ONLY. AS A RESULT, THE PARTICLE-NUMBER PROJECTION  WAS
C            INCORRECT WHEN PERFORMED WITHOUT READING THE  KERNEL  FILE.
C            THIS BUG WAS CORRECTED IN VERSION (3.02E) ON 30/11/2020.
C=======================================================================
C
      NPNPAR=IN_FIX+IZ_FIX
C
      IF (NPNKNO.EQ.1) THEN
C
          XG_WGT(1)=1.0D0
          XG_PNT(1)=0.0D0
C
      ELSE
C
          DO I=1,NPNKNO
C
             XG_WGT(I)=   1.0D0/NPNKNO
             XG_PNT(I)=(I-1)*PI/NPNKNO
C
          END DO
C
      END IF
C
C=======================================================================
C         CALCULATION OF KNOTS AND WEIGHTS  FOR  THE  GAUSS-TCHEBYSCHEV
C         QUADRATURE TO BE USED FOR  THE  INTEGRATION  OVER  THE  GAUGE
C         ANGLE PHIT CORRESPONDING TO THE TZ-PARTICLE-NUMBER PROJECTION
C=======================================================================
C
      NTZPAR=IN_FIX-IZ_FIX
C
      IF (NTZKNO.EQ.1) THEN
C
          XT_WGT(1)=1.0D0
          XT_PNT(1)=0.0D0
C
      ELSE
C
          DO I=1,NTZKNO
C
             XT_WGT(I)=   1.0D0/NTZKNO
             XT_PNT(I)=(I-1)*PI/NTZKNO
C
          END DO
C
      END IF
C
C=======================================================================
C         FOR CONSISTENCY, HERE WE DEFINE THE WEIGHT FACTORS
C         CORRESPONDING TO THE PARITY PROJECTION
C=======================================================================
C
      IF (NPAKNO.EQ.1) THEN
C
          XP_WGT(1)=1.00D0
C
      ELSE
C
          XP_WGT(1)=1.00D0/2.0D0
          XP_WGT(2)=IPAPRO/2.0D0
C
      END IF
C
C=======================================================================
C         HERE WE SET THE LIMITS OF ANGULAR MOMENTA  FOR  WHICH  THE
C         PROJECTION IS PERFORMED. FOR AXIAL INTEGRATION, THE  LOWER
C         LIMIT CANNOT BE LOWER THAN THE PROJECTION ON THE INTRINSIC
C         AXIS "KPROJE".
C
C         FOR ISOSPIN PROJECTION ALL IS DONE IN THE SAME WAY
C=======================================================================
C
      IF (IAXIAL.EQ.1) THEN
C
          JPROMI=MAX(ABS(KPROJE),IPROMI)
          JPROMA=IPROMA
      ELSE
          JPROMI=IPROMI
          JPROMA=IPROMA
C
      END IF
C
      IF (IAXIAT.EQ.1) THEN
C
          JSOSMI=MAX(ABS(ISOSTZ),ISOSMI)
          JSOSMA=ISOSMA
      ELSE
          JSOSMI=ISOSMI
          JSOSMA=ISOSMA
C
      END IF
C
CJD CZY TO PONIZEJ BEDZIE DOBRZE DLA MOMENTU PEDU?
C
      IF (LPROJJ.EQ.0) THEN
C
          JPROMI=ABS(KPROJE)
          JPROMA=ABS(KPROJE)
C
      END IF
C
      IF (LPROJT.EQ.0) THEN
C
          JSOSMI=ABS(ISOSTZ)
          JSOSMA=ABS(ISOSTZ)
C
      END IF
C
      IERROR=0
C
      IF (JPROMA.GT.NDPROI) THEN
C
          WRITE(NFIPRI,'(
     *          1H*,20(1H/),2X,''TOO SMALL VALUE OF NDPROI ='',I6,
     *                                        2X,20(1H/),1H*,/,
     *          1H*,20(1H/),2X,''SHOULD BE EQUAL  AT LEAST ='',I6,
     *                                        2X,20(1H/),1H*,/,
     *          1H*,20(1H/),2X,''IN PROANG                  '',6X,
     *                                        2X,20(1H/),1H*,/,
     *                                           1H*,77X,1H*)')
     *          NDPROI,JPROMA
C
          IERROR=1
C
      END IF
C
      IF (JSOSMA.GT.NDPROT) THEN
C
          WRITE(NFIPRI,'(
     *          1H*,20(1H/),2X,''TOO SMALL VALUE OF NDPROT ='',I6,
     *                                        2X,20(1H/),1H*,/,
     *          1H*,20(1H/),2X,''SHOULD BE EQUAL  AT LEAST ='',I6,
     *                                        2X,20(1H/),1H*,/,
     *          1H*,20(1H/),2X,''IN PROANG                  '',6X,
     *                                        2X,20(1H/),1H*,/,
     *                                           1H*,77X,1H*)')
     *          NDPROT,JSOSMA
C
          IERROR=1
C
      END IF
C
      IF ((JPROMA+1)*(JSOSMA+1).GT.NDPROD) THEN
C
          WRITE(NFIPRI,'(
     *          1H*,20(1H/),2X,''TOO SMALL VALUE OF NDPROD ='',I6,
     *                                        2X,20(1H/),1H*,/,
     *          1H*,20(1H/),2X,''SHOULD BE EQUAL  AT LEAST ='',I6,
     *                                        2X,20(1H/),1H*,/,
     *          1H*,20(1H/),2X,''IN PROANG                  '',6X,
     *                                        2X,20(1H/),1H*,/,
     *                                           1H*,77X,1H*)')
     *          NDPROD,(JPROMA+1)*(JSOSMA+1)
C
          IERROR=1
      END IF
C
C
      IF (IERROR.EQ.1)
     *    STOP ' INCORRECT NDPROI, NDPROT, OR NDPROD IN PROANG'
C
C=======================================================================
C         HERE WE DEFINE COLLECTIVE INDICES IMK FOR THE ANGULAR-MOMENTUM
C         PROJECTION.
C         ARRAYS INDIMK,IROMAT,LROMAT, AND KROMAT  ARE  USED FOR  SCALAR
C         OPERATORS, AND THUS FOR AXIAL PROJECTION THEY CAN  BE  REDUCED
C         TO CONTAIN ONLY MATRIX ELEMENTS WITH FIXED K-PROJECTIONS.
C         ARRAYS IREIMK,IREMAT,LREMAT, AND KREMAT ARE USED FOR NONSCALAR
C         OPERATORS, AND THUS, EVEN FOR AXIAL PROJECTION,  THEY  CONTAIN
C         MATRIX ELEMENTS FOR ALL POSSIBLE K-PROJECTIONS.
C=======================================================================
C
      INDIMK=0
      INDPRO=0
C
      DO IPROAC=JPROMI,JPROMA,2
         DO LPROAC=LPRSTA(IPROAC),LPRSTO(IPROAC),2
            DO KPROAC=KPRSTA(IPROAC),KPRSTO(IPROAC),2
C
               IF (IABS(LPROAC).LE.IPROAC.AND.
     *             IABS(KPROAC).LE.IPROAC) THEN
C
                   INDPRO=INDPRO+1
C
                   IROMAT(INDPRO)=IPROAC
                   LROMAT(INDPRO)=LPROAC
                   KROMAT(INDPRO)=KPROAC
C
                   INDIMK(IPROAC,LPROAC,KPROAC)=INDPRO
C
               END IF
C
            END DO
         END DO
      END DO
C
      IREIMK=0
      IREPRO=0
C
      IF (IKEPRI.EQ.1.OR.IRMPRI.EQ.1) THEN
C
          DO IPROAC=JPROMI,JPROMA,2
             DO LPROAC=-IPROAC,IPROAC,2
                DO KPROAC=KPRSTA(IPROAC),KPRSTO(IPROAC),2
C
                   IREPRO=IREPRO+1
C
                   IREMAT(IREPRO)=IPROAC
                   LREMAT(IREPRO)=LPROAC
                   KREMAT(IREPRO)=KPROAC
C
                   IREIMK(IPROAC,LPROAC,KPROAC)=IREPRO
C
                END DO
             END DO
          END DO
C
      END IF
C
      IF (INDPRO.GT.NDPROM.OR.IREPRO.GT.NDPROM) THEN
C
          WRITE(NFIPRI,'(
     *          1H*,20(1H/),2X,''TOO SMALL VALUE OF NDPROM ='',I6,
     *                                        2X,20(1H/),1H*,/,
     *          1H*,20(1H/),2X,''SHOULD BE EQUAL  AT LEAST ='',I6,
     *                                        2X,20(1H/),1H*,/,
     *          1H*,20(1H/),2X,''IN PROANG                  '',6X,
     *                                        2X,20(1H/),1H*,/,
     *                                           1H*,77X,1H*)')
     *          NDPROM,MAX(INDPRO,IREPRO)
C
          STOP ' TOO SMALL VALUE OF NDPROM IN PROANG'
C
      END IF
C
      IF (LPROJJ.EQ.0) THEN
C
          NUPROM=1
          NUPREM=1
      ELSE
          NUPROM=INDPRO
          NUPREM=IREPRO
C
      END IF
C
C=======================================================================
C         HERE WE DEFINE COLLECTIVE INDICES IMK FOR THE ISOSPIN
C         PROCECTION
C=======================================================================
C
      INDTMK=0
      INDISO=0
C
      DO ISOSAC=JSOSMI,JSOSMA,2
         DO LSOSAC=KSOSTA(ISOSAC),KSOSTO(ISOSAC),2
            DO KSOSAC=KSOSTA(ISOSAC),KSOSTO(ISOSAC),2
C
               INDISO=INDISO+1
C
               ISOMAT(INDISO)=ISOSAC
               LSOMAT(INDISO)=LSOSAC
               KSOMAT(INDISO)=KSOSAC
C
               INDTMK(ISOSAC,LSOSAC,KSOSAC)=INDISO
C
            END DO
         END DO
      END DO
C
      IF (INDISO.GT.NDISOM) THEN
C
          WRITE(NFIPRI,'(
     *          1H*,20(1H/),2X,''TOO SMALL VALUE OF NDISOM ='',I6,
     *                                        2X,20(1H/),1H*,/,
     *          1H*,20(1H/),2X,''SHOULD BE EQUAL  AT LEAST ='',I6,
     *                                        2X,20(1H/),1H*,/,
     *          1H*,20(1H/),2X,''IN PROANG                  '',6X,
     *                                        2X,20(1H/),1H*,/,
     *                                           1H*,77X,1H*)')
     *           NDISOM,INDISO
C
          STOP ' TOO SMALL VALUE OF NDISOM IN PROANG'
C
      END IF
C
      IF (LPROJT.EQ.0) THEN
C
          NUISOM=1
      ELSE
          NUISOM=INDISO
C
      END IF
C
C=======================================================================
C         SETTING SWITCHES "KPAHFB", WHICH INDICATE IF THE HFB OR HF
C         CALCULATIONS WILL BE PERFORMED FOR THE GIVEN ISOSPIN.
C=======================================================================
C
      DO ICHARG=0,NDISOS
C
         IF (ICHARG.EQ.0) DELTAX=DELTAN
         IF (ICHARG.EQ.1) DELTAX=DELTAP
C
         IF (IPA2HF(ICHARG).EQ.1.OR.
     *       IPA2HF(ICHARG).EQ.2.AND.
     *       ABS(DELTAX).LT.DEL2HF(ICHARG)) THEN
C
             KPAHFB(ICHARG)=0
         ELSE
             KPAHFB(ICHARG)=IPAHFB
C
         END IF
C
      END DO
C
C=======================================================================
C         ZEROING THE ARRAY  "ISALGA" WHICH CONTAINS FLAGS 0(1) DENOTING
C         THE KNOTS IN ALPHA AND GAMMA THAT HAVE NOT YET BEEN CALCULATED
C         (HAVE ALREADY BEEN CALCULATED)
C=======================================================================
C
      DO I=1,NUAKNO
         DO K=1,NUAKNO
C
            ISALGA(I,K)=0
C
         END DO
      END DO
C
C=======================================================================
C         ZEROING THE ARRAY  "ISAALL" WHICH CONTAINS FLAGS 0(1) DENOTING
C         ALL KNOTS IN ALPHA, GAMMA, BETA, BETA_T THAT HAVE NOT YET BEEN
C         CALCULATED (HAVE ALREADY BEEN CALCULATED)
C=======================================================================
C
      ISAALL=0
C
C=======================================================================
C         ZEROING THE ARRAY  "ISPOIN" WHICH CONTAINS FLAGS 0(1) DENOTING
C         ALL KNOTS THAT HAVE NOT YET BEEN CALCULATED
C         (HAVE ALREADY BEEN CALCULATED)
C=======================================================================
C
      ISPOIN=0
C
C=======================================================================
C         ALLOCATING ARRAYS WITH KERNELS
C=======================================================================
      ALLOCATE (QPKERN(1:NDASAV,1:NDBKNO,1:NDASAV,NDMULM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('QPKERN','PROANG')
      ALLOCATE (ATKERN(1:NDASAV,1:NDBKNO,1:NDASAV,NDMULM,0:NMAORD),
     *                                                    STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('ATKERN','PROANG')
      ALLOCATE (SPKERN(1:NDASAV,1:NDBKNO,1:NDASAV,NDMULM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('SPKERN','PROANG')
      IF (NASORD.GE.0)
     *ALLOCATE (WTKERN(1:NDASAV,1:NDBKNO,1:NDASAV,NDMULM,0:NASORD),
     *                                                    STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('WTKERN','PROANG')
C=======================================================================
C TER ALLOCATE (TEKERN(1:NDASAV,1:NDBKNO,1:NDASAV,
C TER*                 1:NDASAT,1:NDBTKN,1:NDASAT,
C TER*                 2*NDCOUT),STAT=IALLOC)
C TER IF (IALLOC.NE.0) CALL NOALLO('TEKERN','PROANG')
C=======================================================================
      ALLOCATE (OVKERN(1:NDASAV,1:NDBKNO,1:NDASAV,
     *                 1:NDASAT,0:NDBTKN,1:NDASAT),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('OVKERN','PROANG')
      ALLOCATE (SKKERN(1:NDASAV,1:NDBKNO,1:NDASAV,
     *                 1:NDASAT,1:NDBTKN,1:NDASAT),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('SKKERN','PROANG')
      ALLOCATE (EKKERN(1:NDASAV,1:NDBKNO,1:NDASAV,
     *                 1:NDASAT,0:NDBTKN,1:NDASAT),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('EKKERN','PROANG')
      ALLOCATE (EPKERN(1:NDASAV,1:NDBKNO,1:NDASAV,
     *                 1:NDASAT,0:NDBTKN,1:NDASAT),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('EPKERN','PROANG')
      ALLOCATE (CDKERN(1:NDASAV,1:NDBKNO,1:NDASAV,
     *                 1:NDASAT,1:NDBTKN,1:NDASAT),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('CDKERN','PROANG')
      ALLOCATE (CDKE10(1:NDASAV,1:NDBKNO,1:NDASAV,
     *                 1:NDASAT,1:NDBTKN,1:NDASAT),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('CDKE10','PROANG')
      ALLOCATE (CDKE1P(1:NDASAV,1:NDBKNO,1:NDASAV,
     *                 1:NDASAT,1:NDBTKN,1:NDASAT),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('CDKE1P','PROANG')
      ALLOCATE (CDKE1M(1:NDASAV,1:NDBKNO,1:NDASAV,
     *                 1:NDASAT,1:NDBTKN,1:NDASAT),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('CDKE1M','PROANG')
      ALLOCATE (CDKE20(1:NDASAV,1:NDBKNO,1:NDASAV,
     *                 1:NDASAT,1:NDBTKN,1:NDASAT),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('CDKE20','PROANG')
      ALLOCATE (CDK21P(1:NDASAV,1:NDBKNO,1:NDASAV,
     *                 1:NDASAT,1:NDBTKN,1:NDASAT),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('CDK21P','PROANG')
      ALLOCATE (CDK21M(1:NDASAV,1:NDBKNO,1:NDASAV,
     *                 1:NDASAT,1:NDBTKN,1:NDASAT),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('CDK21M','PROANG')
      ALLOCATE (CDK22P(1:NDASAV,1:NDBKNO,1:NDASAV,
     *                 1:NDASAT,1:NDBTKN,1:NDASAT),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('CDK22P','PROANG')
      ALLOCATE (CDK22M(1:NDASAV,1:NDBKNO,1:NDASAV,
     *                 1:NDASAT,1:NDBTKN,1:NDASAT),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('CDK22M','PROANG')
      ALLOCATE (CXKERN(1:NDASAV,1:NDBKNO,1:NDASAV,
     *                 1:NDASAT,1:NDBTKN,1:NDASAT),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('CXKERN','PROANG')
      ALLOCATE (CXKE10(1:NDASAV,1:NDBKNO,1:NDASAV,
     *                 1:NDASAT,1:NDBTKN,1:NDASAT),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('CXKE10','PROANG')
      ALLOCATE (CXKE1P(1:NDASAV,1:NDBKNO,1:NDASAV,
     *                 1:NDASAT,1:NDBTKN,1:NDASAT),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('CXKE1P','PROANG')
      ALLOCATE (CXKE1M(1:NDASAV,1:NDBKNO,1:NDASAV,
     *                 1:NDASAT,1:NDBTKN,1:NDASAT),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('CXKE1M','PROANG')
      ALLOCATE (CXKE20(1:NDASAV,1:NDBKNO,1:NDASAV,
     *                 1:NDASAT,1:NDBTKN,1:NDASAT),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('CXKE20','PROANG')
      ALLOCATE (CXK21P(1:NDASAV,1:NDBKNO,1:NDASAV,
     *                 1:NDASAT,1:NDBTKN,1:NDASAT),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('CXK21P','PROANG')
      ALLOCATE (CXK21M(1:NDASAV,1:NDBKNO,1:NDASAV,
     *                 1:NDASAT,1:NDBTKN,1:NDASAT),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('CXK21M','PROANG')
      ALLOCATE (CXK22P(1:NDASAV,1:NDBKNO,1:NDASAV,
     *                 1:NDASAT,1:NDBTKN,1:NDASAT),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('CXK22P','PROANG')
      ALLOCATE (CXK22M(1:NDASAV,1:NDBKNO,1:NDASAV,
     *                 1:NDASAT,1:NDBTKN,1:NDASAT),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('CXK22M','PROANG')
      ALLOCATE (PNKE00(1:NDASAV,1:NDBKNO,1:NDASAV,
     *                 1:NDASAT,1:NDBTKN,1:NDASAT),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('PNKE00','PROANG')
      ALLOCATE (PNKE10(1:NDASAV,1:NDBKNO,1:NDASAV,
     *                 1:NDASAT,1:NDBTKN,1:NDASAT),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('PNKE10','PROANG')
      ALLOCATE (PNKE1P(1:NDASAV,1:NDBKNO,1:NDASAV,
     *                 1:NDASAT,1:NDBTKN,1:NDASAT),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('PNKE1P','PROANG')
      ALLOCATE (PNKE1M(1:NDASAV,1:NDBKNO,1:NDASAV,
     *                 1:NDASAT,1:NDBTKN,1:NDASAT),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('PNKE1M','PROANG')
      ALLOCATE (TZKERN(1:NDASAV,1:NDBKNO,1:NDASAV,
     *                 1:NDASAT,1:NDBTKN,1:NDASAT),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('TZKERN','PROANG')
      ALLOCATE (T2KERN(1:NDASAV,1:NDBKNO,1:NDASAV,
     *                 1:NDASAT,1:NDBTKN,1:NDASAT),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('T2KERN','PROANG')
      ALLOCATE (BZKERN(1:NDASAV,1:NDBKNO,1:NDASAV,
     *                 1:NDASAT,1:NDBTKN,1:NDASAT),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('BZKERN','PROANG')
      ALLOCATE (B2KERN(1:NDASAV,1:NDBKNO,1:NDASAV,
     *                 1:NDASAT,1:NDBTKN,1:NDASAT),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('B2KERN','PROANG')
C=======================================================================
C TER ALLOCATE (TETERN(1:NDASAV,1:NDBKNO,1:NDASAV,
C TER*                 1:NUISOM,2*NDCOUT),STAT=IALLOC)
C TER       IF (IALLOC.NE.0) CALL NOALLO('TETERN','PROANG')
C=======================================================================
      ALLOCATE (OVTERN(1:NDASAV,1:NDBKNO,1:NDASAV,
     *                 0:NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('OVTERN','PROANG')
      ALLOCATE (SKTERN(1:NDASAV,1:NDBKNO,1:NDASAV,
     *                 1:NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('SKTERN','PROANG')
      ALLOCATE (EKTERN(1:NDASAV,1:NDBKNO,1:NDASAV,
     *                 0:NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('EKTERN','PROANG')
      ALLOCATE (EPTERN(1:NDASAV,1:NDBKNO,1:NDASAV,
     *                 0:NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('EPTERN','PROANG')
      ALLOCATE (CDTERN(1:NDASAV,1:NDBKNO,1:NDASAV,
     *                 1:NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('CDTERN','PROANG')
      ALLOCATE (CDTE10(1:NDASAV,1:NDBKNO,1:NDASAV,
     *                 1:NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('CDTE10','PROANG')
      ALLOCATE (CDTE1P(1:NDASAV,1:NDBKNO,1:NDASAV,
     *                 1:NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('CDTE1P','PROANG')
      ALLOCATE (CDTE1M(1:NDASAV,1:NDBKNO,1:NDASAV,
     *                 1:NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('CDTE1M','PROANG')
      ALLOCATE (CDTE20(1:NDASAV,1:NDBKNO,1:NDASAV,
     *                 1:NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('CDTE20','PROANG')
      ALLOCATE (CDT21P(1:NDASAV,1:NDBKNO,1:NDASAV,
     *                 1:NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('CDT21P','PROANG')
      ALLOCATE (CDT21M(1:NDASAV,1:NDBKNO,1:NDASAV,
     *                 1:NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('CDT21M','PROANG')
      ALLOCATE (CDT22P(1:NDASAV,1:NDBKNO,1:NDASAV,
     *                 1:NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('CDT22P','PROANG')
      ALLOCATE (CDT22M(1:NDASAV,1:NDBKNO,1:NDASAV,
     *                 1:NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('CDT22M','PROANG')
      ALLOCATE (CXTERN(1:NDASAV,1:NDBKNO,1:NDASAV,
     *                 1:NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('CXTERN','PROANG')
      ALLOCATE (CXTE10(1:NDASAV,1:NDBKNO,1:NDASAV,
     *                 1:NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('CXTE10','PROANG')
      ALLOCATE (CXTE1P(1:NDASAV,1:NDBKNO,1:NDASAV,
     *                 1:NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('CXTE1P','PROANG')
      ALLOCATE (CXTE1M(1:NDASAV,1:NDBKNO,1:NDASAV,
     *                 1:NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('CXTE1M','PROANG')
      ALLOCATE (CXTE20(1:NDASAV,1:NDBKNO,1:NDASAV,
     *                 1:NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('CXTE20','PROANG')
      ALLOCATE (CXT21P(1:NDASAV,1:NDBKNO,1:NDASAV,
     *                 1:NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('CXT21P','PROANG')
      ALLOCATE (CXT21M(1:NDASAV,1:NDBKNO,1:NDASAV,
     *                 1:NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('CXT21M','PROANG')
      ALLOCATE (CXT22P(1:NDASAV,1:NDBKNO,1:NDASAV,
     *                 1:NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('CXT22P','PROANG')
      ALLOCATE (CXT22M(1:NDASAV,1:NDBKNO,1:NDASAV,
     *                 1:NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('CXT22M','PROANG')
      ALLOCATE (PNTE00(1:NDASAV,1:NDBKNO,1:NDASAV,
     *                 1:NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('PNTE00','PROANG')
      ALLOCATE (PNTE10(1:NDASAV,1:NDBKNO,1:NDASAV,
     *                 1:NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('PNTE10','PROANG')
      ALLOCATE (PNTE1P(1:NDASAV,1:NDBKNO,1:NDASAV,
     *                 1:NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('PNTE1P','PROANG')
      ALLOCATE (PNTE1M(1:NDASAV,1:NDBKNO,1:NDASAV,
     *                 1:NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('PNTE1M','PROANG')
      ALLOCATE (TZTERN(1:NDASAV,1:NDBKNO,1:NDASAV,
     *                 1:NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('TZTERN','PROANG')
      ALLOCATE (T2TERN(1:NDASAV,1:NDBKNO,1:NDASAV,
     *                 1:NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('T2TERN','PROANG')
      ALLOCATE (BZTERN(1:NDASAV,1:NDBKNO,1:NDASAV,
     *                 1:NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('BZTERN','PROANG')
      ALLOCATE (B2TERN(1:NDASAV,1:NDBKNO,1:NDASAV,
     *                 1:NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('B2TERN','PROANG')
C=======================================================================
C         ZEROING ARRAYS WITH KERNELS
C=======================================================================
C
      QPKERN(:,:,:,:)  =C_ZERO
      ATKERN(:,:,:,:,:)=C_ZERO
      SPKERN(:,:,:,:)  =C_ZERO
      IF (NASORD.GE.0)
     *WTKERN(:,:,:,:,:)=C_ZERO
C
C TER TEKERN=C_ZERO
      OVKERN=C_ZERO
      SKKERN=C_ZERO
      EKKERN=C_ZERO
C
      EPKERN=C_ZERO
C
      CDKERN=C_ZERO
      CDKE10=C_ZERO
      CDKE1P=C_ZERO
      CDKE1M=C_ZERO
      CDKE20=C_ZERO
      CDK21P=C_ZERO
      CDK21M=C_ZERO
      CDK22P=C_ZERO
      CDK22M=C_ZERO
      CXKERN=C_ZERO
      CXKE10=C_ZERO
      CXKE1P=C_ZERO
      CXKE1M=C_ZERO
      CXKE20=C_ZERO
      CXK21P=C_ZERO
      CXK21M=C_ZERO
      CXK22P=C_ZERO
      CXK22M=C_ZERO
      PNKE00=C_ZERO
      PNKE10=C_ZERO
      PNKE1P=C_ZERO
      PNKE1M=C_ZERO
      TZKERN=C_ZERO
      T2KERN=C_ZERO
      BZKERN=C_ZERO
      B2KERN=C_ZERO
C===========================================================
C TER TETERN(:,:,:,:,:)=C_ZERO
      OVTERN(:,:,:,:)=C_ZERO
      SKTERN(:,:,:,:)=C_ZERO
      EKTERN(:,:,:,:)=C_ZERO
      EPTERN(:,:,:,:)=C_ZERO
      CDTERN(:,:,:,:)=C_ZERO
      CDTE10(:,:,:,:)=C_ZERO
      CDTE1P(:,:,:,:)=C_ZERO
      CDTE1M(:,:,:,:)=C_ZERO
      CDTE20(:,:,:,:)=C_ZERO
      CDT21P(:,:,:,:)=C_ZERO
      CDT21M(:,:,:,:)=C_ZERO
      CDT22P(:,:,:,:)=C_ZERO
      CDT22M(:,:,:,:)=C_ZERO
      CXTERN(:,:,:,:)=C_ZERO
      CXTE10(:,:,:,:)=C_ZERO
      CXTE1P(:,:,:,:)=C_ZERO
      CXTE1M(:,:,:,:)=C_ZERO
      CXTE20(:,:,:,:)=C_ZERO
      CXT21P(:,:,:,:)=C_ZERO
      CXT21M(:,:,:,:)=C_ZERO
      CXT22P(:,:,:,:)=C_ZERO
      CXT22M(:,:,:,:)=C_ZERO
      PNTE00(:,:,:,:)=C_ZERO
      PNTE10(:,:,:,:)=C_ZERO
      PNTE1P(:,:,:,:)=C_ZERO
      PNTE1M(:,:,:,:)=C_ZERO
      TZTERN(:,:,:,:)=C_ZERO
      T2TERN(:,:,:,:)=C_ZERO
      BZTERN(:,:,:,:)=C_ZERO
      B2TERN(:,:,:,:)=C_ZERO
C
C=======================================================================
C         READING THE OLD FILES WITH KERNELS
C=======================================================================
C         COMPILE WITH IWRKER=1 TO PRINT THE KERNELS READ FROM FILE(S)
C=======================================================================
C
      IWRKER=0
C
C=======================================================================
C
      IF (ISAKER.EQ.1) THEN
C
          WRITE(NFIPRI,'(
     *          1H*,20(1H/),2X,''ATTENTION: OLD VERSIONS OF KERNEL'',
     *                                              2X,20(1H/),1H*,/,
     *          1H*,20(1H/),2X,''FILES WILL BE WRITTEN/READ. USAGE'',
     *                                              2X,20(1H/),1H*,/,
     *          1H*,20(1H/),2X,''OF  NEW  VERSIONS  IS  RECOMENDED'',
     *                                              2X,20(1H/),1H*,/,
     *          1H*,20(1H/),2X,''BY RERUNNING CODE WITH ISAKER = 2'',
     *                                              2X,20(1H/),1H*,/,
     *                                                 1H*,77X,1H*)')
C
          IFIKER=0
          JFIKER=0
          MVERKE=0
C
    8     IFIKER=IFIKER+1
C
C=======================================================================
C         OPENING THE FILE
C=======================================================================
C
          IF (IPROAN.EQ.1.OR.IPROAN.EQ.2) THEN
C
              WRITE(FILACT(01:05),'(''N'',I3,''-'')') IFIKER
              WRITE(FILACT(06:10),'(''L'',I3,''-'')') ILFWAV
              WRITE(FILACT(11:15),'(''R'',I3,''-'')') IRGWAV
C
          ELSE IF (IPROAN.EQ.3) THEN
C
              WRITE(FILACT(01:05),'(''N'',I3,''-'')') IFIKER
              WRITE(FILACT(06:10),'(''L'',I3,''-'')') INLWAV
              WRITE(FILACT(11:15),'(''R'',I3,''-'')') INRWAV
C
          ELSE
c
              STOP ' WRONG IPROAN USED FOR ISAKER=1 IN PROANG'
C
          END IF
C
          DO NUCHAR=1,15
C
             IF (FILACT(NUCHAR:NUCHAR).EQ.' ') FILACT(NUCHAR:NUCHAR)='0'
C
          END DO
C
          FILACT(16:83)=FILKER
C
          OPEN(NFIKER,FILE=FILACT,STATUS='OLD',ERR=7,FORM='UNFORMATTED')
C
          NUALGA=0
          NUAALL=0
C
          I_MINI=NUAKNO
          I_MAXI=1
          K_MINI=NUAKNO
          K_MAXI=1
C
C=======================================================================
C         READING THE FILE
C=======================================================================
C
   6      READ (NFIKER,END=5,ERR=15) I,K,LVERKE
C
          INEWFI=1
C
          JFIKER=JFIKER+1
C
          IF (JFIKER.GT.1.AND.LVERKE.NE.MVERKE) THEN
C
              WRITE(NFIPRI,'(/,1X,10(1H/),
     *                  ''  CANNOT READ MIXED-VERSION KERNEL FILES'',
     *                  3X,10(1H/),/)')
C
              STOP '  WRONG MIXED-VERSION KERNEL FILES IN PROANG'
          ELSE
              MVERKE=LVERKE
          END IF
C
          GO TO 16
C
  15      INEWFI=0
C
          MVERKE=1
C
  16      CONTINUE
C
          IF (JFIKER.EQ.1.AND.ICOMIX.EQ.0)
     *        WRITE(NFIPRI,'(79(1H*),/,1H*,77X,1H*,/,
     *        1H*,1X,'' THE GCM KERNELS IN FUNCTION OF THE EULER'',
     *               '' ANGLES READ FROM OLD FILES FILKER'',  1X,1H*,/,
     *        1H*,2X,A68,''VER='',I2,                         1X,1H*,/,
     *                                                   1H*,77X,1H*,/,
     *                                         79(1H*),/,1H*,77X,1H*)')
     *
     *        FILKER,MVERKE
C
          IF (MVERKE.GT.IVERKE) THEN
C
              WRITE(NFIPRI,'(/,1X,10(1H/),
     *                  ''  CANNOT READ THE KERNEL FILE VERSION:'',
     *                  I3,2X,10(1H/),/)') MVERKE
C
              STOP '  WRONG MVERKE IN PROANG'
C
          END IF
C
          IF (I.LT.1.OR.I.GT.NUAKNO) STOP ' WRONG I READ IN PROANG'
          IF (K.LT.1.OR.K.GT.NUAKNO) STOP ' WRONG K READ IN PROANG'
C
          IF (MVERKE.LE.7) NSIMIN=1
C
          IF (MVERKE.GE.3) THEN
C
              IF (MVERKE.GE.7) THEN
C
                  READ (NFIKER,END=5,ERR=8915) MPAALL,J,L
C
                  IF (MPAALL.NE.IPAALL)
     *                               STOP ' WRONG IPAALL READ IN PROANG'
                  IF ((J.LT.1.OR.J.GT.NUBKNO).AND.IPAALL.EQ.1)
     *                               STOP ' WRONG J READ IN PROANG'
                  IF ((L.LT.1.OR.L.GT.NBTKNO).AND.IPAALL.EQ.1)
     *                               STOP ' WRONG L READ IN PROANG'
C
                  GO TO 8916
C
 8915             STOP ' ERROR READING IVERKE.GE.7 FILE IN PROANG'
C
 8916             CONTINUE
C
              END IF
C
              READ (NFIKER,END=5,ERR=5) FILINP
C
              IF (FILINP.NE.FILACT.AND.ICHKER.EQ.1) THEN
C
                  WRITE(NFIPRI,'(//,87(1H/),/,1H/,85X,1H/,/,
     *
     *                1H/,'' THE NAME OF THE KERNEL FILE: '',55X,1H/,/,
     *                                                   1H/,85X,1H/,/,
     *                1H/,1X,A83,                             1X,1H/,/,
     *                                                   1H/,85X,1H/,/,
     *                1H/,'' IS DIFFERENT THAN THE NAME RECORDED'',
     *                    '' IN THE KERNEL FILE:    '',      25X,1H/,/,
     *                                                   1H/,85X,1H/,/,
     *                1H/,1X,A83,                             1X,1H/,/,
     *                                                   1H/,85X,1H/,/,
     *                1H/,'' CORRECT THE DATABASE OF YOUR KERNEL'',
     *                    '' FILES AND START AGAIN'',
     *                    '' OR OTHERWISE SET ICHKER=0'',     1X,1H/,/,
     *                                                   1H/,85X,1H/,/,
     *                                                        87(1H/))')
     *
     *            FILACT,FILINP
C
              STOP ' NAME OF THE KERNEL FILE IS DIFFERENT THAN RECORDED'
C
              END IF
C
          END IF
C
          I_MINI=MIN(I_MINI,I)
          I_MAXI=MAX(I_MAXI,I)
          K_MINI=MIN(K_MINI,K)
          K_MAXI=MAX(K_MAXI,K)
C
C=======================================================================
C         THE TRICK BELOW IS INTRODUCED IN ORDER TO SAVE MEMORY WHEN
C         A PARALLEL CALCULATION IS  PERFORMED  (IPAKER=1)  AND  THE
C         CALCULATED KERNELS WILL NOT BE INTEGRATED. IN SUCH A  CASE
C         WE DO NOT HAVE TO KEEP THEM IN MEMORY, AND ALL ARE  STORED
C         IN THE LOCATION NORMALLY USED FOR THE FIRST KNOT IN  ALPHA
C         AND GAMMA, AND THE CODE CAN BE COMPILED WITH IPARAL=1.
C         THE SAME RULES CONCERN THE ISOSPIN AND IPARAT=1.
C=======================================================================
C
                           M=I
          IF (IPAKER.EQ.1) M=1
                           N=K
          IF (IPAKER.EQ.1) N=1
C
C=======================================================================
C
          IF (INEWFI.EQ.1) THEN
C
              IF (MVERKE.LE.3) THEN
C
                  READ (NFIKER,END=5,ERR=5) MUBKNO,MMURED,MMARED
                  MSIRED=0
C
              ELSE
C
                  IF (MVERKE.LE.5) THEN
C
                      READ (NFIKER,END=5,ERR=5) MUBKNO,MMURED,MMARED,
     *                                                        MSIRED
                      MBTKNO=1
C
                  ELSE
C
                      READ (NFIKER,END=5,ERR=5) MUBKNO,MBTKNO,
     *                                          MMURED,MMARED,MSIRED
C
                  END IF
C
              END IF
C
              IF (MUBKNO.NE.NUBKNO) STOP ' WRONG NUBKNO READ IN PROANG'
              IF (MBTKNO.NE.NBTKNO) STOP ' WRONG NBTKNO READ IN PROANG'
              IF (MMURED.NE.NMURED) STOP ' WRONG NMURED READ IN PROANG'
              IF (MMARED.NE.NMARED) STOP ' WRONG NMARED READ IN PROANG'
              IF (MSIRED.NE.NSIRED) STOP ' WRONG NSIRED READ IN PROANG'
C
              IF (IPAALL.EQ.1) THEN
C
                     READ (NFIKER,END=5,ERR=5) JJ,
     *                OVKERN(M,J,N,1,0,1),OVKERN(M,J,N,1,L,1),
     *                EKKERN(M,J,N,1,0,1),EKKERN(M,J,N,1,L,1),
     *                CDKERN(M,J,N,1,L,1),
     *                CXKERN(M,J,N,1,L,1),
     *                SKKERN(M,J,N,1,L,1),
     *               ((QPKERN(M,J,N,IND_LM(LAMBDA,MIU)),
     *                             MIU=-LAMBDA,LAMBDA),LAMBDA=0,NMURED),
     *               ((ATKERN(M,J,N,IND_LM(LAMBDA,MIU),0),
     *                             MIU=-LAMBDA,LAMBDA),LAMBDA=1,NMARED),
     *               ((SPKERN(M,J,N,IND_LM(LAMBDA,MIU)),
     *                             MIU=-LAMBDA,LAMBDA),
     *                                            LAMBDA=NSIMIN,NSIRED)
C
                     IF (J.NE.JJ)
     *                         STOP ' WRONG J READ IN PROANG (IPAALL=1)'
C
                     IF (IWRKER.EQ.1) WRITE(*,7878) M,J,N,1,L,1,
     *                                       OVKERN(M,J,N,1,L,1),
     *                                   ABS(OVKERN(M,J,N,1,L,1)),
     *                                       SKKERN(M,J,N,1,L,1),
     *                                   ABS(SKKERN(M,J,N,1,L,1)),
     *                                       CDKERN(M,J,N,1,L,1),
     *                                   ABS(CDKERN(M,J,N,1,L,1)),
     *                                       CXKERN(M,J,N,1,L,1),
     *                                   ABS(CXKERN(M,J,N,1,L,1)),
     *                                       SKKERN(M,J,N,1,L,1)*
     *                                       OVKERN(M,J,N,1,L,1),
     *                                   ABS(SKKERN(M,J,N,1,L,1)*
     *                                       OVKERN(M,J,N,1,L,1))
C
                     IF (NBTKNO.GT.1.OR.MVERKE.GE.11)
     *
     *                   READ (NFIKER,END=5,ERR=5)
     *                      CDKE10(M,J,N,1,L,1),
     *                      CDKE1P(M,J,N,1,L,1),
     *                      CXKE10(M,J,N,1,L,1),
     *                      CXKE1P(M,J,N,1,L,1),
     *                      CDKE1M(M,J,N,1,L,1),
     *                      CDKE20(M,J,N,1,L,1),
     *                      CDK21P(M,J,N,1,L,1),
     *                      CDK21M(M,J,N,1,L,1),
     *                      CDK22P(M,J,N,1,L,1),
     *                      CDK22M(M,J,N,1,L,1),
     *                      CXKE1M(M,J,N,1,L,1),
     *                      CXKE20(M,J,N,1,L,1),
     *                      CXK21P(M,J,N,1,L,1),
     *                      CXK21M(M,J,N,1,L,1),
     *                      CXK22P(M,J,N,1,L,1),
     *                      CXK22M(M,J,N,1,L,1),
     *                      PNKE00(M,J,N,1,L,1),
     *                      PNKE10(M,J,N,1,L,1),
     *                      PNKE1P(M,J,N,1,L,1),
     *                      PNKE1M(M,J,N,1,L,1)
C
                         IF (MVERKE.GE.9) THEN
C
                             READ (NFIKER,END=5,ERR=5)
     *                         (TZKERN(M,J,N,1,L1,1),L1=1,NBTKNO),
     *                         (T2KERN(M,J,N,1,L1,1),L1=1,NBTKNO)
C
                         ELSE
C
                             DO L1=1,NBTKNO
C
                                TZKERN(M,J,N,1,L1,1)=C_ZERO
                                T2KERN(M,J,N,1,L1,1)=C_ZERO
C
                             END DO
C
                         END IF
C
                         IF (MVERKE.GE.12) THEN
C
                             READ (NFIKER,END=5,ERR=5)
     *                         (EPKERN(M,J,N,1,L1,1),L1=0,NBTKNO)
C
                         ELSE
C
                             DO L1=0,NBTKNO
C
                                EPKERN(M,J,N,1,L1,1)=C_ZERO
C
                             END DO
C
                         END IF
C
                         IF (MVERKE.GE.13) THEN
C
                             READ (NFIKER,END=5,ERR=5)
     *                         (BZKERN(M,J,N,1,L1,1),L1=1,NBTKNO),
     *                         (B2KERN(M,J,N,1,L1,1),L1=1,NBTKNO)
C
                         ELSE
C
                             DO L1=1,NBTKNO
C
                                BZKERN(M,J,N,1,L1,1)=C_ZERO
                                B2KERN(M,J,N,1,L1,1)=C_ZERO
C
                             END DO
C
                         END IF
C
                  ISAALL(I,J,K,L)=ISAALL(I,J,K,L)+1
                  NUAALL=NUAALL+1
C
              ELSE
C
                  DO J=1,NUBKNO
C
                     READ (NFIKER,END=5,ERR=5) JJ,
     *                (OVKERN(M,J,N,1,L,1),L=0,NBTKNO),
     *                (EKKERN(M,J,N,1,L,1),L=0,NBTKNO),
     *                (CDKERN(M,J,N,1,L,1),L=1,NBTKNO),
     *                (CXKERN(M,J,N,1,L,1),L=1,NBTKNO),
     *                (SKKERN(M,J,N,1,L,1),L=1,NBTKNO),
     *               ((QPKERN(M,J,N,IND_LM(LAMBDA,MIU)),
     *                             MIU=-LAMBDA,LAMBDA),LAMBDA=0,NMURED),
     *               ((ATKERN(M,J,N,IND_LM(LAMBDA,MIU),0),
     *                             MIU=-LAMBDA,LAMBDA),LAMBDA=1,NMARED),
     *               ((SPKERN(M,J,N,IND_LM(LAMBDA,MIU)),
     *                             MIU=-LAMBDA,LAMBDA),
     *                                            LAMBDA=NSIMIN,NSIRED)
C
                     IF (J.NE.JJ)
     *                         STOP ' WRONG J READ IN PROANG (IPAALL=0)'
C
                     IF (IWRKER.EQ.1) WRITE(*,7878) M,J,N,1,1,1,
     *                                       OVKERN(M,J,N,1,0,1),
     *                                   ABS(OVKERN(M,J,N,1,0,1)),
     *                                       OVKERN(M,J,N,1,1,1),
     *                                   ABS(OVKERN(M,J,N,1,1,1)),
     *                                       OVKERN(M,J,N,1,0,1)*
     *                                       OVKERN(M,J,N,1,1,1),
     *                                   ABS(OVKERN(M,J,N,1,0,1)*
     *                                       OVKERN(M,J,N,1,1,1))
C
                     IF (NBTKNO.GT.1.OR.MVERKE.GE.11) THEN
C
                         READ (NFIKER,END=5,ERR=5)
     *                      (CDKE10(M,J,N,1,L,1),L=1,NBTKNO),
     *                      (CDKE1P(M,J,N,1,L,1),L=1,NBTKNO),
     *                      (CXKE10(M,J,N,1,L,1),L=1,NBTKNO),
     *                      (CXKE1P(M,J,N,1,L,1),L=1,NBTKNO),
     *                      (CDKE1M(M,J,N,1,L,1),L=1,NBTKNO),
     *                      (CDKE20(M,J,N,1,L,1),L=1,NBTKNO),
     *                      (CDK21P(M,J,N,1,L,1),L=1,NBTKNO),
     *                      (CDK21M(M,J,N,1,L,1),L=1,NBTKNO),
     *                      (CDK22P(M,J,N,1,L,1),L=1,NBTKNO),
     *                      (CDK22M(M,J,N,1,L,1),L=1,NBTKNO),
     *                      (CXKE1M(M,J,N,1,L,1),L=1,NBTKNO),
     *                      (CXKE20(M,J,N,1,L,1),L=1,NBTKNO),
     *                      (CXK21P(M,J,N,1,L,1),L=1,NBTKNO),
     *                      (CXK21M(M,J,N,1,L,1),L=1,NBTKNO),
     *                      (CXK22P(M,J,N,1,L,1),L=1,NBTKNO),
     *                      (CXK22M(M,J,N,1,L,1),L=1,NBTKNO),
     *                      (PNKE00(M,J,N,1,L,1),L=1,NBTKNO),
     *                      (PNKE10(M,J,N,1,L,1),L=1,NBTKNO),
     *                      (PNKE1P(M,J,N,1,L,1),L=1,NBTKNO),
     *                      (PNKE1M(M,J,N,1,L,1),L=1,NBTKNO)
C
                         IF (MVERKE.GE.9) THEN
C
                             READ (NFIKER,END=5,ERR=5)
     *                         (TZKERN(M,J,N,1,L1,1),L1=1,NBTKNO),
     *                         (T2KERN(M,J,N,1,L1,1),L1=1,NBTKNO)
C
                         ELSE
C
                             DO L1=1,NBTKNO
C
                                TZKERN(M,J,N,1,L1,1)=C_ZERO
                                T2KERN(M,J,N,1,L1,1)=C_ZERO
C
                             END DO
C
                         END IF
C
                         IF (MVERKE.GE.12) THEN
C
                             READ (NFIKER,END=5,ERR=5)
     *                         (EPKERN(M,J,N,1,L1,1),L1=0,NBTKNO)
C
                         ELSE
C
                             DO L1=0,NBTKNO
C
                                EPKERN(M,J,N,1,L1,1)=C_ZERO
C
                             END DO
C
                         END IF
C
                         IF (MVERKE.GE.13) THEN
C
                             READ (NFIKER,END=5,ERR=5)
     *                         (BZKERN(M,J,N,1,L1,1),L1=1,NBTKNO),
     *                         (B2KERN(M,J,N,1,L1,1),L1=1,NBTKNO)
C
                         ELSE
C
                             DO L1=1,NBTKNO
C
                                BZKERN(M,J,N,1,L1,1)=C_ZERO
                                B2KERN(M,J,N,1,L1,1)=C_ZERO
C
                             END DO
C
                         END IF
C
                     END IF
C
                  END DO
C
                  ISALGA(I,K)=ISALGA(I,K)+1
                  NUALGA=NUALGA+1
C
              END IF
C
          ELSE
C
C=======================================================================
C         READING OF FILES IN THE OLD FORMAT IS KEPT FOR SOME TIME
C=======================================================================
C
              READ (NFIKER,END=5,ERR=5) MUBKNO,MMURED,MMARED,MDCOUP
C
              IF (MUBKNO.NE.NUBKNO) STOP ' WRONG NUBKNO READ IN PROANG'
              IF (MMURED.NE.NMURED) STOP ' WRONG NMURED READ IN PROANG'
              IF (MMARED.NE.NMARED) STOP ' WRONG NMARED READ IN PROANG'
C             IF (MDCOUP.NE.NDCOUP) STOP ' WRONG NDCOUP READ IN PROANG'
C
              DO J=1,NUBKNO
C
                 READ (NFIKER,END=5,ERR=5) JJ,
     *             OVKERN(M,J,N,1,0,1),OVKERN(M,J,N,1,1,1),
     *             EKKERN(M,J,N,1,0,1),EKKERN(M,J,N,1,1,1),
     *             CDKERN(M,J,N,1,1,1),CXKERN(M,J,N,1,1,1),
     *             SKKERN(M,J,N,1,1,1),
     *           ((QPKERN(M,J,N,IND_LM(LAMBDA,MIU)),MIU=-LAMBDA,LAMBDA),
     *                                                 LAMBDA=0,NMURED),
     *         ((ATKERN(M,J,N,IND_LM(LAMBDA,MIU),0),MIU=-LAMBDA,LAMBDA),
     *                                               LAMBDA=0,NMARED),
     *            (FACINT,NUCOUP=1,MDCOUP)
C
C
                 IF (J.NE.JJ) STOP ' WRONG J READ IN PROANG'
C
                 IF (IWRKER.EQ.1) WRITE(*,7878) M,J,N,1,1,1,
     *                                   OVKERN(M,J,N,0,1,1),
     *                               ABS(OVKERN(M,J,N,0,1,1)),
     *                                   OVKERN(M,J,N,1,1,1),
     *                               ABS(OVKERN(M,J,N,1,1,1)),
     *                                   OVKERN(M,J,N,0,1,1)*
     *                                   OVKERN(M,J,N,1,1,1),
     *                               ABS(OVKERN(M,J,N,0,1,1)*
     *                                   OVKERN(M,J,N,1,1,1)),
     *                                   SKKERN(M,J,N,1,1,1),
     *                               ABS(SKKERN(M,J,N,1,1,1)),
     *                                   CDKERN(M,J,N,1,1,1),
     *                               ABS(CDKERN(M,J,N,1,1,1)),
     *                                   CXKERN(M,J,N,1,1,1),
     *                               ABS(CXKERN(M,J,N,1,1,1)),
     *                                   SKKERN(M,J,N,1,1,1)*
     *                                   OVKERN(M,J,N,1,1,1),
     *                               ABS(SKKERN(M,J,N,1,1,1)*
     *                                   OVKERN(M,J,N,1,1,1))
C
              END DO
C
              ISALGA(I,K)=ISALGA(I,K)+1
              NUALGA=NUALGA+1
C
          END IF
C
          IF (MVERKE.LT.5) THEN
C
              DO J=1,NUBKNO
C
                 DO LAMBDA=0,NMURED
                    DO MIU=-LAMBDA,LAMBDA
C
                       NIU=IABS(MIU)
C
                       QPKERN(M,J,N,IND_LM(LAMBDA,MIU))=
     *                 QPKERN(M,J,N,IND_LM(LAMBDA,MIU))
     *                             *QUNITS(LAMBDA,NIU)
C
                    END DO
                 END DO
C
                 DO LAMBDA=1,NMARED
                    DO MIU=-LAMBDA,LAMBDA
C
                       NIU=IABS(MIU)
C
                       ATKERN(M,J,N,IND_LM(LAMBDA,MIU),0)=
     *                 ATKERN(M,J,N,IND_LM(LAMBDA,MIU),0)
     *                             *AUNITS(LAMBDA,NIU)
C
                    END DO
                 END DO
C
                 DO LAMBDA=NSIMIN,NSIRED
                    DO MIU=-LAMBDA,LAMBDA
C
                       NIU=IABS(MIU)
C
                       SPKERN(M,J,N,IND_LM(LAMBDA,MIU))=
     *                 SPKERN(M,J,N,IND_LM(LAMBDA,MIU))
     *                             *SUNITS(LAMBDA,NIU)
C
                    END DO
                 END DO
C
              END DO
C
          END IF
C
C=======================================================================
C         HERE JUMP TO READING THE NEXT SET OF BETA KNOTS
C=======================================================================
C
          GO TO 6
C
    5     CLOSE(NFIKER)
C
          MUALGA=(I_MAXI-I_MINI+1)*(K_MAXI-K_MINI+1)
C
          IF (ICOMIX.EQ.0)
     *    WRITE(NFIPRI,'(1H*,2X,A14,     I4,'' <= I <='',I3,
     *                         ''  AND'',I4,'' <= K <='',I3,
     *                         ''; TOT'',I6,'' PNTS OF'',I6,
     *                   1X,1H*)')
     *
     *    FILACT(01:14),I_MINI,I_MAXI,K_MINI,K_MAXI,NUALGA,MUALGA
C
C=======================================================================
C         HERE JUMP TO READING THE NEXT FILE
C=======================================================================
C
          GO TO 8
C
    7     CONTINUE
C
          IF (IFIKER.GT.1.AND.ICOMIX.EQ.0) WRITE(NFIPRI,'(1H*,77X,1H*)')
C
          IF (MVERKE.GT.0.AND.MVERKE.LT.10.AND.MMARED.GE.1)
     *
     *        WRITE(NFIPRI,'(79(1H*),/,1H*,77X,1H*,/,
     *        1H*,1X,'' ATTENTION: PROTON KERNELS OF MAGNETIC MOMENTS'',
     *               '' HAVE BEEN READ FROM DISK   '',  2X,1H*,/,
     *                                                   1H*,77X,1H*)')
C
C=======================================================================
C         HERE WE PRINT THE TABLE OF KNOTS THAT HAVE ALREADY BEEN
C         CALCULATED.
C=======================================================================
C
          IF (ICOMIX.NE.0) GO TO 9238
C
          WRITE(NFIPRI,'(79(1H*),/,1H*,77X,1H*,/,
     *        1H*,1X,'' THE MATRIX OF KERNELS THAT HAVE ALREADY'',
     *               '' BEEN CALCULATED IS AS FOLLOWS:   '',  2X,1H*,/,
     *                                                   1H*,77X,1H*)')
C
          NUABLO=(NUAKNO-MOD(NUAKNO-1,NUMCOL)-1)/NUMCOL+1
C
          IOFSET=0
          ISTART=IOFSET+1
          ISTOPP=NUAKNO
          DO KBLOCK=1,NUABLO
             KOFSET=(KBLOCK-1)*NUMCOL
             KSTART=KOFSET+1
             KSTOPP=MIN(NUAKNO,KOFSET+NUMCOL)
C
             WRITE(NFIPRI,'(79(1H*),/,1H*,77X,1H*)')
C
             DO K=KSTART,KSTOPP
C
                KCOLUM=K-KOFSET
C
                      LINE_0(KCOLUM)='-'
                WRITE(LINE_1(KCOLUM),'(I1)')(MOD(K,1000)-MOD(K,100))/100
                WRITE(LINE_2(KCOLUM),'(I1)')(MOD(K,100) -MOD(K,10))/10
                WRITE(LINE_3(KCOLUM),'(I1)') MOD(K,10)
C
             END DO
C
             KCOLUM=KSTOPP+1-KOFSET
C
             LINE_0(KCOLUM)=' '
             LINE_1(KCOLUM)='|'
             LINE_2(KCOLUM)='|'
             LINE_3(KCOLUM)='|'
C
             DO K=KSTOPP+2,KOFSET+NUMCOL+1
C
                KCOLUM=K-KOFSET
C
                LINE_0(KCOLUM)=' '
                LINE_1(KCOLUM)=' '
                LINE_2(KCOLUM)=' '
                LINE_3(KCOLUM)=' '
C
             END DO
C
             WRITE(NFIPRI,'(
     *         1H*,1X,''   '',   1X,''GAMMA'',66X,1X,1H*,/,
     *         1H*,1X,'' A '','' '',         71A1,1X,1H*,/,
     *         1H*,1X,'' L '',''|'',         71A1,1X,1H*,/,
     *         1H*,1X,'' P '',''|'',         71A1,1X,1H*,/,
     *         1H*,1X,'' H '',''|'',         71A1,1X,1H*,/,
     *         1H*,1X,'' A '','' '',         71A1,1X,1H*)')
     *
     *         LINE_0,LINE_1,LINE_2,LINE_3,LINE_0
C
             DO I=ISTART,ISTOPP
C
                DO K=KSTART,KSTOPP
C
                   KCOLUM=K-KOFSET
C
                   WRITE(LINE_1(KCOLUM),'(I1)') ISALGA(I,K)
C
                END DO
C
                KCOLUM=KSTOPP+1-KOFSET
C
                LINE_1(KCOLUM)='|'
C
                DO K=KSTOPP+2,KOFSET+NUMCOL+1
C
                   KCOLUM=K-KOFSET
C
                   LINE_1(KCOLUM)=' '
C
                END DO
C
                WRITE(NFIPRI,'(1H*,1X,I3,''|'',71A1,1X,1H*)') I,LINE_1
C
             END DO
C
             WRITE(NFIPRI,'(1H*,1X,3X, 1X,71A1,1X,1H*)') LINE_0
             WRITE(NFIPRI,'(1H*,77X,1H*)')
C
          END DO
C
 9238     CONTINUE
C
      END IF
C
C=======================================================================
C         READING THE NEW FILES WITH KERNELS
C=======================================================================
C
      IF (ISAKER.EQ.2) THEN
C
          NUPOIN=0
C
          IF (IPAKER.EQ.1) THEN
C
              IFIBEG=KFIKER
              IFIEND=KFIKER
          ELSE
              IFIBEG=1
              IFIEND=KFIKER
C
          END IF
C
          IFIKER=0
          JFIKER=0
          MVERK2=0
C
          DO KFIACT=IFIBEG,IFIEND
C
             IFIACT=-1
C
 3218        IFIACT=IFIACT+1
C
             IF (IFIACT.GT.9)
     *            STOP ' MORE THAN 10 KERNEL FILES NOT ALOWED IN PROANG'
C
C=======================================================================
C         OPENING THE FILE
C=======================================================================
C
             WRITE(FILHE2(01:06),'(''N'',I5      )') KFIACT
             WRITE(FILHE2(07:08),'(      I1,''-'')') IFIACT
C
             IF (NAMKER.EQ.1) THEN
C
                 FILACT=' '
                 IF (IPROAN.EQ.1.OR.IPROAN.EQ.2) THEN
C
                     WRITE(FILHE2(09:11),'(''L'',I2      )') ILFWAV
                     WRITE(FILHE2(12:15),'(''R'',I2,''-'')') IRGWAV
C
                 ELSE IF (IPROAN.EQ.3.OR.IPROAN.EQ.4.OR.IPROAN.EQ.5)THEN
C
                     WRITE(FILHE2(09:11),'(''L'',I2      )') INLWAV
                     WRITE(FILHE2(12:15),'(''R'',I2,''-'')') INRWAV
C
                 ELSE
c
                     STOP' WRONG IPROAN USED FOR ISAKER=2 IN PROANG'
C
                 END IF
C
                 DO NUCHAR=1,15
                    IF (FILHE2(NUCHAR:NUCHAR).EQ.' ')
     *                  FILHE2(NUCHAR:NUCHAR)='0'
                 END DO
C
                 FILACT( 1:15)=FILHE2
                 FILACT(16:83)=FILKER
C
                 OPEN(NFIKER,FILE=FILACT,STATUS='OLD',ERR=3217,
     *                                               FORM='UNFORMATTED')
             ELSE
C
                 FILAC2=' '
                 FILAC2(1: 8)=FILHE2(1: 8)
C
                 DO NUCHAR=1,8
                    IF (FILAC2(NUCHAR:NUCHAR).EQ.' ')
     *                  FILAC2(NUCHAR:NUCHAR)='0'
                 END DO
C
                 FILAC2(9:77)=TRIM(FILLEF(ILFWAV))//'+'
                 LENACT=LEN_TRIM(FILAC2)
C                WRITE (*,*) ILFWAV,LENACT,FILAC2
                 IF (LENACT+68.GT.149) STOP ' TOO LONG FILAC2 1'
                 FILAC2(LENACT+1:LENACT+68)=TRIM(FILLEF(IRGWAV))
                 LENACT=LEN_TRIM(FILAC2)
C                WRITE (*,*) IRGWAV,LENACT,FILAC2
                 IF (LENACT+ 4.GT.149) STOP ' TOO LONG FILAC2 2'
                 FILAC2(LENACT+1:LENACT+4)='.ker'
C                WRITE (*,*) LENACT,FILAC2
C
                 OPEN(NFIKER,FILE=FILAC2,STATUS='OLD',ERR=3217,
     *                                               FORM='UNFORMATTED')
             END IF
C
             IFIKER=IFIKER+1
C
C=======================================================================
C         READING THE FILE
C=======================================================================
C
 3216        READ (NFIKER,END=3219,ERR=3219) I,K,LVERK2
C
             JFIKER=JFIKER+1
C
             IF (JFIKER.EQ.1.AND.ICOMIX.EQ.0) THEN
C
                 IF (NAMKER.EQ.1) THEN
C
                     WRITE(NFIPRI,'(79(1H*),/,1H*,77X,1H*,/,
     *         1H*,1X,'' THE GCM KERNELS IN FUNCTION OF THE EULER'',
     *                '' ANGLES READ FROM NEW FILES FILKER'',  1X,1H*,/,
     *         1H*,2X,A68,''VER='',I2,                         1X,1H*,/,
     *                                                    1H*,77X,1H*,/,
     *                                          79(1H*),/,1H*,77X,1H*)')
     *
     *               FILKER,LVERK2
C
                 ELSE
C
                     WRITE(NFIPRI,'(79(1H*),/,1H*,77X,1H*,/,
     *         1H*,1X,'' THE GCM KERNELS IN FUNCTION OF THE EULER'',
     *                '' ANGLES READ FROM NEW FILES FILAC2'',  1X,1H*,/,
     *         1H*,2X,A149,''VER='',I2,                        1X,1H*,/,
     *                                                    1H*,77X,1H*,/,
     *                                          79(1H*),/,1H*,77X,1H*)')
     *
     *               FILAC2,LVERK2
C
                 ENDIF
C
              ENDIF
C
             IF (JFIKER.GT.1.AND.LVERK2.NE.MVERK2) THEN
C
                 WRITE(NFIPRI,'(/,1X,10(1H/),
     *                  ''  CANNOT READ MIXED-VERSION KERNEL FILES'',
     *                  3X,10(1H/),/)')
C
                 STOP '  WRONG MIXED-VERSION KERNEL FILES IN PROANG'
             ELSE
                 MVERK2=LVERK2
             END IF
C
             IF (MVERK2.GT.IVERK2) THEN
C
                 WRITE(NFIPRI,'(/,1X,10(1H/),
     *                     ''  CANNOT READ THE KERNEL FILE VERSION:'',
     *                     I3,2X,10(1H/),/)') MVERK2
C
                 STOP '  WRONG MVERK2 IN PROANG'
C
             END IF
C
             READ (NFIKER,END=3215,ERR=3215) MUAKNO,MUBKNO,MATKNO,MBTKNO
C
             IF (MUAKNO.NE.NUAKNO)STOP' WRONG MUAKNO READ IN PROANG (2)'
             IF (MUBKNO.NE.NUBKNO)STOP' WRONG MUBKNO READ IN PROANG (2)'
             IF (MATKNO.NE.NATKNO)STOP' WRONG MATKNO READ IN PROANG (2)'
             IF (MBTKNO.NE.NBTKNO)STOP' WRONG MBTKNO READ IN PROANG (2)'
C
             IF (I.LT.1.OR.I.GT.NUAKNO)STOP' WRONG I READ IN PROANG (2)'
             IF (K.LT.1.OR.K.GT.NUAKNO)STOP' WRONG K READ IN PROANG (2)'
C
C=======================================================================
C         THE TRICK BELOW IS INTRODUCED IN ORDER TO SAVE MEMORY WHEN
C         A PARALLEL CALCULATION IS  PERFORMED  (IPAKER=1)  AND  THE
C         CALCULATED KERNELS WILL NOT BE INTEGRATED. IN SUCH A  CASE
C         WE DO NOT HAVE TO KEEP THEM IN MEMORY, AND ALL ARE  STORED
C         IN THE LOCATION NORMALLY USED FOR THE FIRST KNOT IN  ALPHA
C         AND GAMMA, AND THE CODE CAN BE COMPILED WITH IPARAL=1.
C         THE SAME RULES CONCERN THE ISOSPIN AND IPARAT=1.
C=======================================================================
C
                              M=I
             IF (IPAKER.EQ.1) M=1
                              N=K
             IF (IPAKER.EQ.1) N=1
C
C=======================================================================
C
             READ (NFIKER,END=3215,ERR=3215) MPAALL,J,L
C
             IF (J.LT.1.OR.J.GT.NUBKNO)STOP' WRONG J READ IN PROANG (2)'
             IF (L.LT.1.OR.L.GT.NBTKNO)STOP' WRONG L READ IN PROANG (2)'
C
             READ (NFIKER,END=3215,ERR=3215) MPAK3D,I_T,K_T
C
             IF (I_T.LT.1.OR.I_T.GT.NATKNO) STOP' WRONG I_T READ PROANG'
             IF (K_T.LT.1.OR.K_T.GT.NATKNO) STOP' WRONG K_T READ PROANG'
C
C=======================================================================
C
                              M_T=I_T
             IF (IPAK3D.EQ.1) M_T=1
                              N_T=K_T
             IF (IPAK3D.EQ.1) N_T=1
C
C=======================================================================
C
             IF (MVERK2.GE.7) THEN
C
                 READ (NFIKER,END=3215,ERR=3215)
     *                 MPNKNO,MPNPAR,MPAKNO,MPAPRO
C
                 NPNPAR=IN_FIX+IZ_FIX
C
                 IF (MPNKNO.NE.NPNKNO.AND.NPNKNO.GT.1)
     *                                     STOP' WRONG MPNKNO IN PROANG'
                 IF (MPNPAR.NE.NPNPAR.AND.NPNKNO.GT.1)
     *                                     STOP' WRONG MPNPAR IN PROANG'
                 IF (MPAKNO.NE.NPAKNO.AND.NPAKNO.GT.1)
     *                                     STOP' WRONG MPAKNO IN PROANG'
                 IF (MPAPRO.NE.IPAPRO.AND.NPAKNO.GT.1)
     *                                     STOP' WRONG MPAPRO IN PROANG'
C
                 READ (NFIKER,END=3215,ERR=3215) MPROJE,MSOSTZ
C
                 IF (MPROJE.NE.KPROJE.AND.NUAKNO.EQ.1.AND.NUBKNO.NE.1)
     *                                     STOP' WRONG MPROJE IN PROANG'
                 IF (MSOSTZ.NE.ISOSTZ.AND.NATKNO.EQ.1.AND.NBTKNO.NE.1)
     *                                     STOP' WRONG MSOSTZ IN PROANG'
             END IF
C
             IF (MVERK2.GE.8) THEN
C
                 READ (NFIKER,END=3215,ERR=3215)
     *                 MTZKNO,MTZPAR
C
                 NTZPAR=IN_FIX-IZ_FIX
C
                 IF (MTZKNO.NE.NTZKNO.AND.NTZKNO.GT.1)
     *                                     STOP' WRONG MTZKNO IN PROANG'
                 IF (MTZPAR.NE.NTZPAR.AND.NTZKNO.GT.1)
     *                                     STOP' WRONG MTZPAR IN PROANG'
C
             END IF
C
             IF (NAMKER.EQ.1) THEN
C
                 READ (NFIKER,END=3215,ERR=3215) FILINP
C
                 IF (FILINP.NE.FILACT.AND.ICHKER.EQ.1) THEN
C
                     WRITE(NFIPRI,'(//,87(1H/),/,1H/,85X,1H/,/,
     *
     *                1H/,'' THE NAME OF THE KERNEL FILE: '',55X,1H/,/,
     *                                                   1H/,85X,1H/,/,
     *                1H/,1X,A83,                             1X,1H/,/,
     *                                                   1H/,85X,1H/,/,
     *                1H/,'' IS DIFFERENT THAN THE NAME RECORDED'',
     *                    '' IN THE KERNEL FILE:    '',      25X,1H/,/,
     *                                                   1H/,85X,1H/,/,
     *                1H/,1X,A83,                             1X,1H/,/,
     *                                                   1H/,85X,1H/,/,
     *                1H/,'' CORRECT THE DATABASE OF YOUR KERNEL'',
     *                    '' FILES AND START AGAIN'',
     *                    '' OR OTHERWISE SET ICHKER=0'',     1X,1H/,/,
     *                                                   1H/,85X,1H/,/,
     *                                                        87(1H/))')
     *
     *               FILACT,FILINP
C
                     STOP ' NAME OF KERNEL FILE IS DIFFERENT'//
     *                    ' THAN RECORDED 1'
C
                 END IF
C
             ELSE
C
                 READ (NFIKER,END=3215,ERR=3215) FILIN2
C
                 IF (FILIN2.NE.FILAC2.AND.ICHKER.EQ.1) THEN
C
                     WRITE(NFIPRI,'(//,152(1H/),/,1H/,150X,1H/,/,
     *
     *                1H/,'' THE NAME OF THE KERNEL FILE: '',120X,1H/,/,
     *                                                   1H/,150X,1H/,/,
     *                1H/,1X,A149,                             1X,1H/,/,
     *                                                   1H/,150X,1H/,/,
     *                1H/,'' IS DIFFERENT THAN THE NAME RECORDED'',
     *                    '' IN THE KERNEL FILE:    '',       90X,1H/,/,
     *                                                   1H/,150X,1H/,/,
     *                1H/,1X,A149,                             1X,1H/,/,
     *                                                   1H/,150X,1H/,/,
     *                1H/,'' CORRECT THE DATABASE OF YOUR KERNEL'',
     *                    '' FILES AND START AGAIN'',
     *                    '' OR OTHERWISE SET ICHKER=0'',     66X,1H/,/,
     *                                                   1H/,150X,1H/,/,
     *                                                       152(1H/))')
     *
     *               FILAC2,FILIN2
C
                     STOP ' NAME OF KERNEL FILE IS DIFFERENT'//
     *                    ' THAN RECORDED 2'
C
                 END IF
C
             END IF
C
             READ (NFIKER,END=3215,ERR=3215) MMURED,MMARED,MSIRED
C
             IF (MMURED.NE.NMURED)   STOP ' WRONG MMURED READ IN PROANG'
             IF (MMARED.NE.NMARED)   STOP ' WRONG MMARED READ IN PROANG'
             IF (MSIRED.NE.NSIRED)   STOP ' WRONG MSIRED READ IN PROANG'
C
             READ (NFIKER,END=3215,ERR=3215)
     *             OVKERN(M,J,N,M_T,0,N_T),OVKERN(M,J,N,M_T,L,N_T),
     *             EKKERN(M,J,N,M_T,0,N_T),EKKERN(M,J,N,M_T,L,N_T),
     *             CDKERN(M,J,N,M_T,L,N_T),
     *             CXKERN(M,J,N,M_T,L,N_T),
     *             SKKERN(M,J,N,M_T,L,N_T),
C TER*            (TEKERN(M,J,N,M_T,L,N_T,NUCOUT),NUCOUT=1,2*NDCOUT),
     *            ((QPKERN(M,J,N,IND_LM(LAMBDA,MIU)),
     *                                         MIU=-LAMBDA,LAMBDA),
     *                                            LAMBDA=0,NMURED),
     *            ((ATKERN(M,J,N,IND_LM(LAMBDA,MIU),0),
     *                                         MIU=-LAMBDA,LAMBDA),
     *                                            LAMBDA=1,NMARED),
     *            ((SPKERN(M,J,N,IND_LM(LAMBDA,MIU)),
     *                                         MIU=-LAMBDA,LAMBDA),
     *                                       LAMBDA=NSIMIN,NSIRED)
C=======================================================================
C         ATTENTION: BETWEEN VERSIONS (3.23F) AND  (3.24O), THE ORDER OF
C                    READING ENTRIES FROM THE KERNEL FILE WAS  CORRUPTED
C                    AND THUS READING OF THE KERNEL FILES  CREATED  WITH
C                    EARLIER VERSIONS BECAME IMPOSSIBLE.  THIS  BUG  WAS
C                    CORRECTED ON 27/04/2022 IN VERSION (3.24P).
C=======================================================================
C         ATTENTION: BETWEEN VERSIONS (3.06A) AND  (3.13N),  INFORMATION
C                    ON THE EFFECTIVE G-FACTORS  ("IGYROS")  USED  IN  A
C                    GIVEN RUN WAS NOT STORED ON THE KERNEL FILE.  AS  A
C                    CONSEQUENCE, THE FOLLOWING RUN THAT WAS READING THE
C                    THE KERNEL FILE AND USING DIFFERENT VALUES  OF  THE
C                    G-FACTORS WAS GIVING THE  PREVIOUS  VALUES  OF  THE
C                    MAGNETIC MOMENTS WITHOUT NOTIFYING  THE  USER. THIS
C                    BUG WAS CORRECTED ON 02/08/2022 IN VERSION (3.13O).
C=======================================================================
C
             IF (MVERK2.GE.10) THEN
C
                 READ (NFIKER,END=3215,ERR=3215)
     *                 RYRORP,RYRSPN,RYRSPP,IRYROS
C
                 IF (IRYROS.NE.IGYROS)STOP' WRONG IGYROS READ IN PROANG'
C
                 IF (IGYROS.EQ.1) THEN
C
                    IF (RYRORP.NE.GYRORP) STOP' WRONG GYRORP IN PROANG'
                    IF (RYRSPN.NE.GYRSPN) STOP' WRONG GYRSPN IN PROANG'
                    IF (RYRSPP.NE.GYRSPP) STOP' WRONG GYRSPP IN PROANG'
C
                 END IF
C
             ELSE
C
             END IF
C
C=======================================================================
C
             IF (MVERK2.GE.12) THEN
C
                 READ (NFIKER,END=3215,ERR=3215)
     *                 RIN2BC,RSA2BC,IRY2BC
C
                 IF (IRY2BC.NE.IGY2BC)STOP' WRONG IGY2BC READ IN PROANG'
C
                 IF (IGY2BC.EQ.1) THEN
C
                    IF (RIN2BC.NE.GIN2BC) STOP' WRONG GIN2BC IN PROANG'
                    IF (RSA2BC.NE.GSA2BC) STOP' WRONG GSA2BC IN PROANG'
C
                 END IF
C
             ELSE
C
                 IF (IGY2BC.EQ.1)STOP' MISSING IGY2BC IN KERNELS/PROANG'
C
             END IF
C
C=======================================================================
C
             IF (MVERK2.GE.9) THEN
C
                 READ (NFIKER,END=3215,ERR=3215) MMAORD
C
                 IF (MMAORD.NE.NMAORD)STOP' WRONG MMAORD READ IN PROANG'
C
                 READ (NFIKER,END=3215,ERR=3215)
     *           (((ATKERN(M,J,N,IND_LM(LAMBDA,MIU),NUMORD),
     *                                         MIU=-LAMBDA,LAMBDA),
     *                                            LAMBDA=1,NMARED),
     *                                            NUMORD=1,MMAORD)
C
             END IF
C
C=======================================================================
C
             IF (MVERK2.GE.11) THEN
C
                 READ (NFIKER,END=3215,ERR=3215) MASRED,MASORD
C
                 IF (MASRED.NE.NASRED) THEN
C
                     WRITE(NFIPRI,'(/,1X,10(1H/),
     *                     '' ERROR READING KERNEL FILE VERSION='',I2,
     *                             21X,10(1H/),/,1X,10(1H/),
     *                     '' WRONG MASRED='',I2,'' READ FROM THE'',
     *                     '' KERNEL FILE FOR NASRED='',I2,
     *                              1X,10(1H/),/)') MVERK2,MASRED,NASRED
C
                     STOP ' WRONG MASRED READ IN PROANG'
C
                 END IF
C
                 IF (MASORD.NE.NASORD) THEN
C
                     WRITE(NFIPRI,'(/,1X,10(1H/),
     *                     '' ERROR READING KERNEL FILE VERSION='',I2,
     *                             21X,10(1H/),/,1X,10(1H/),
     *                     '' WRONG MASORD='',I2,'' READ FROM THE'',
     *                     '' KERNEL FILE FOR NASORD='',I2,
     *                              1X,10(1H/),/)') MVERK2,MASORD,NASORD
C
                     STOP ' WRONG MASORD READ IN PROANG'
C
                 END IF
C
                 IF (NASORD.GE.0) READ (NFIKER,END=3215,ERR=3215)
     *           (((WTKERN(M,J,N,IND_LM(LAMBDA,MIU),NUMORD),
     *                                         MIU=-LAMBDA,LAMBDA),
     *                                            LAMBDA=1,NASRED),
     *                                            NUMORD=0,NASORD)
C
             END IF
C
C=======================================================================
C
             IF (MVERK2.LT.7)
     *           OVKERN(M,J,N,M_T,1,N_T)=
     *           OVKERN(M,J,N,M_T,1,N_T)*OVKERN(M,J,N,M_T,0,N_T)
C
             IF (IWRKER.EQ.1) WRITE(*,7878) M,J,N,M_T,L,N_T,
     *                               OVKERN(M,J,N,M_T,0,N_T),
     *                           ABS(OVKERN(M,J,N,M_T,0,N_T)),
     *                               OVKERN(M,J,N,M_T,L,N_T),
     *                           ABS(OVKERN(M,J,N,M_T,L,N_T)),
     *                               OVKERN(M,J,N,M_T,0,N_T)*
     *                               OVKERN(M,J,N,M_T,L,N_T),
     *                           ABS(OVKERN(M,J,N,M_T,0,N_T)*
     *                               OVKERN(M,J,N,M_T,L,N_T)),
     *                               SKKERN(M,J,N,M_T,L,N_T),
     *                           ABS(SKKERN(M,J,N,M_T,L,N_T)),
     *                               CDKERN(M,J,N,M_T,L,N_T),
     *                           ABS(CDKERN(M,J,N,M_T,L,N_T)),
     *                               CXKERN(M,J,N,M_T,L,N_T),
     *                           ABS(CXKERN(M,J,N,M_T,L,N_T)),
     *                               SKKERN(M,J,N,M_T,L,N_T)*
     *                               OVKERN(M,J,N,M_T,L,N_T),
     *                           ABS(SKKERN(M,J,N,M_T,L,N_T)*
     *                               OVKERN(M,J,N,M_T,L,N_T))
C
 7878        FORMAT(2X,6I3,2X,75D16.8)
C
             IF (NBTKNO.GT.1.OR.MVERK2.GE.4) THEN
C
                 READ (NFIKER,END=3215,ERR=3215)
     *              CDKE10(M,J,N,M_T,L,N_T),
     *              CDKE1P(M,J,N,M_T,L,N_T),
     *              CXKE10(M,J,N,M_T,L,N_T),
     *              CXKE1P(M,J,N,M_T,L,N_T),
     *              CDKE1M(M,J,N,M_T,L,N_T),
     *              CDKE20(M,J,N,M_T,L,N_T),
     *              CDK21P(M,J,N,M_T,L,N_T),
     *              CDK21M(M,J,N,M_T,L,N_T),
     *              CDK22P(M,J,N,M_T,L,N_T),
     *              CDK22M(M,J,N,M_T,L,N_T),
     *              CXKE1M(M,J,N,M_T,L,N_T),
     *              CXKE20(M,J,N,M_T,L,N_T),
     *              CXK21P(M,J,N,M_T,L,N_T),
     *              CXK21M(M,J,N,M_T,L,N_T),
     *              CXK22P(M,J,N,M_T,L,N_T),
     *              CXK22M(M,J,N,M_T,L,N_T),
     *              PNKE00(M,J,N,M_T,L,N_T),
     *              PNKE10(M,J,N,M_T,L,N_T),
     *              PNKE1P(M,J,N,M_T,L,N_T),
     *              PNKE1M(M,J,N,M_T,L,N_T)
C
C=======================================================================
C
                 IF (MVERK2.GE.2) THEN
C
                    READ (NFIKER,END=3215,ERR=3215)
     *              TZKERN(M,J,N,M_T,L,N_T),
     *              T2KERN(M,J,N,M_T,L,N_T)
C
                 ELSE
C
                    TZKERN(M,J,N,M_T,L,N_T)=C_ZERO
                    T2KERN(M,J,N,M_T,L,N_T)=C_ZERO
C
                 END IF
C
C=======================================================================
C
                 IF (MVERK2.GE.5) THEN
C
                    READ (NFIKER,END=3215,ERR=3215)
     *              EPKERN(M,J,N,M_T,0,N_T),EPKERN(M,J,N,M_T,L,N_T)
C
                 ELSE
C
                    EPKERN(M,J,N,M_T,0,N_T)=C_ZERO
                    EPKERN(M,J,N,M_T,L,N_T)=C_ZERO
C
                 END IF
C
C=======================================================================
C
                 IF (MVERK2.GE.6) THEN
C
                    READ (NFIKER,END=3215,ERR=3215)
     *              BZKERN(M,J,N,M_T,L,N_T),
     *              B2KERN(M,J,N,M_T,L,N_T)
C
                 ELSE
C
                    BZKERN(M,J,N,M_T,L,N_T)=C_ZERO
                    B2KERN(M,J,N,M_T,L,N_T)=C_ZERO
C
                 END IF
C
             END IF
C
             ISALGA(I,K)=ISALGA(I,K)+1
C
             ISAALL(I,J,K,L)=ISAALL(I,J,K,L)+1
C
             ISPOIN(I,J,K,I_T,L,K_T)=ISPOIN(I,J,K,I_T,L,K_T)+1
C
             NUPOIN=NUPOIN+1
C
             IPRINT=0
             IF (IPRINT.GT.0)
     *           WRITE(NFIPRI,'(1H*,2X,A14,'' NUPN ='',I7,
     *                            '' I ='',I3,'' J ='',I3,  '' K ='',I3,
     *                          '' I_T ='',I3,'' L ='',I3,'' K_T ='',I3,
     *                          1X,1H*)')
     *
     *           FILACT(01:14),NUPOIN,I,J,K,I_T,L,K_T
C
C=======================================================================
C         HERE JUMP TO READING THE NEXT SET OF GAUSS KNOTS
C=======================================================================
C
             GO TO 3216
C
 3215        IF (NAMKER.EQ.1) THEN
C
                 WRITE (NFIPRI,'('' ERROR READING FILE: '',A)') FILACT
             ELSE
                 WRITE (NFIPRI,'('' ERROR READING FILE: '',A)') FILAC2
C
             END IF
C
 3219        CLOSE(NFIKER)
C
C=======================================================================
C         HERE JUMP TO READING THE NEXT FILE
C=======================================================================
C
             GO TO 3218
C
 3217        CONTINUE
C
          END DO
C
          WRITE(NFIPRI,'(1H*,2X,''NUMBER OF FILES READ ='',I6,'',  '',
     *                         ''NUMBER OF POINTS READ ='',I8,13X,1H*,/,
     *                                    1H*,77X,1H*)')
     *    IFIKER,NUPOIN
C
          IF (MVERK2.GT.0.AND.MVERK2.LT.3.AND.MMARED.GE.1)
     *
     *        WRITE(NFIPRI,'(79(1H*),/,1H*,77X,1H*,/,
     *        1H*,1X,'' ATTENTION: PROTON KERNELS OF MAGNETIC MOMENTS'',
     *               '' HAVE BEEN READ FROM DISK   '',  2X,1H*,/,
     *                                                   1H*,77X,1H*)')
C
C=======================================================================
C         HERE WE PRINT THE TABLE OF SPIN KNOTS THAT HAVE ALREADY BEEN
C         CALCULATED.
C=======================================================================
C
          ISDONE=1
C
          IF (LPROJJ.EQ.1) THEN
C
              WRITE(NFIPRI,'(79(1H*),/,1H*,77X,1H*,/,
     *        1H*,1X,'' THE MATRIX OF ANGULAR-MOMENTUM KERNELS THAT'',
     *               '' HAVE ALREADY BEEN CALCULATED:'',  2X,1H*,/,
     *                                                   1H*,77X,1H*)')
C
              IS_PRO=0
C
              DO I=1,NUAKNO
                 DO K=1,NUAKNO
                    DO J=1,NUBKNO
C
                       NUPOIN=0
C
                       DO I_T=1,NATKNO
                          DO K_T=1,NATKNO
                             DO L=1,NBTKNO
C
                                IF (ISPOIN(I,J,K,I_T,L,K_T).GT.0)
     *                                                   NUPOIN=NUPOIN+1
                             END DO
                          END DO
                       END DO
C
                       IF (NUPOIN.EQ.NATKNO*NATKNO*NBTKNO) THEN
                           IS_PRO(I,K)=IS_PRO(I,K)+1
                       ELSE
                           ISDONE=0
                       END IF
C
                    END DO
                 END DO
              END DO
C
              NUABLO=(NUAKNO-MOD(NUAKNO-1,NUMCOL)-1)/NUMCOL+1
C
              IOFSET=0
              ISTART=IOFSET+1
              ISTOPP=NUAKNO
              DO KBLOCK=1,NUABLO
                 KOFSET=(KBLOCK-1)*NUMCOL
                 KSTART=KOFSET+1
                 KSTOPP=MIN(NUAKNO,KOFSET+NUMCOL)
C
                 WRITE(NFIPRI,'(79(1H*),/,1H*,77X,1H*)')
C
                 DO K=KSTART,KSTOPP
                    KCOLUM=K-KOFSET
C
                     LINE_0(KCOLUM)='-'
               WRITE(LINE_1(KCOLUM),'(I1)') (MOD(K,1000)-MOD(K,100))/100
               WRITE(LINE_2(KCOLUM),'(I1)') (MOD(K,100) -MOD(K,10))/10
               WRITE(LINE_3(KCOLUM),'(I1)')  MOD(K,10)
C
                 END DO
C
                 KCOLUM=KSTOPP+1-KOFSET
C
                 LINE_0(KCOLUM)=' '
                 LINE_1(KCOLUM)='|'
                 LINE_2(KCOLUM)='|'
                 LINE_3(KCOLUM)='|'
C
                 DO K=KSTOPP+2,KOFSET+NUMCOL+1
C
                    KCOLUM=K-KOFSET
C
                    LINE_0(KCOLUM)=' '
                    LINE_1(KCOLUM)=' '
                    LINE_2(KCOLUM)=' '
                    LINE_3(KCOLUM)=' '
C
                 END DO
C
                 WRITE(NFIPRI,'(
     *             1H*,1X,''   '',   1X,''GAMMA'',66X,1X,1H*,/,
     *             1H*,1X,'' A '','' '',         71A1,1X,1H*,/,
     *             1H*,1X,'' L '',''|'',         71A1,1X,1H*,/,
     *             1H*,1X,'' P '',''|'',         71A1,1X,1H*,/,
     *             1H*,1X,'' H '',''|'',         71A1,1X,1H*,/,
     *             1H*,1X,'' A '','' '',         71A1,1X,1H*)')
     *
     *             LINE_0,LINE_1,LINE_2,LINE_3,LINE_0
C
                 DO I=ISTART,ISTOPP
C
                    DO K=KSTART,KSTOPP
                       KCOLUM=K-KOFSET
                       IF (IS_PRO(I,K).LE.9) THEN
                           WRITE(LINE_1(KCOLUM),'(A1)')
     *                                              CHAR(IS_PRO(I,K)+48)
                       ELSE
                           WRITE(LINE_1(KCOLUM),'(A1)')
     *                                              CHAR(IS_PRO(I,K)+55)
                       END IF
                    END DO
C
                    KCOLUM=KSTOPP+1-KOFSET
C
                    LINE_1(KCOLUM)='|'
C
                    DO K=KSTOPP+2,KOFSET+NUMCOL+1
                       KCOLUM=K-KOFSET
                       LINE_1(KCOLUM)=' '
                    END DO
C
                    WRITE(NFIPRI,'(1H*,I4,''|'',71A1,1X,1H*)') I,LINE_1
C
                 END DO
C
                 WRITE(NFIPRI,'(1H*,1X,3X, 1X,71A1,1X,1H*)') LINE_0
                 WRITE(NFIPRI,'(1H*,77X,1H*)')
C
              END DO
C
          END IF
C
C=======================================================================
C         HERE WE PRINT THE TABLE OF ISOSPIN KNOTS THAT HAVE ALREADY
C         BEEN CALCULATED.
C=======================================================================
C
          IF (LPROJT.EQ.1) THEN
C
              WRITE(NFIPRI,'(79(1H*),/,1H*,77X,1H*,/,
     *        1H*,1X,'' THE MATRIX OF ISOSPIN KERNELS THAT'',
     *               '' HAVE ALREADY BEEN CALCULATED:'',  11X,1H*,/,
     *                                                   1H*,77X,1H*)')
C
              IS_ISO=0
C
              DO I_T=1,NATKNO
                 DO K_T=1,NATKNO
                    DO L=1,NBTKNO
C
                       NUPOIN=0
C
                       DO I=1,NUAKNO
                          DO K=1,NUAKNO
                             DO J=1,NUBKNO
C
                                IF (ISPOIN(I,J,K,I_T,L,K_T).GT.0)
     *                                                   NUPOIN=NUPOIN+1
                             END DO
                          END DO
                       END DO
C
                       IF (NUPOIN.EQ.NUAKNO*NUAKNO*NUBKNO) THEN
                           IS_ISO(I_T,K_T)=IS_ISO(I_T,K_T)+1
                       ELSE
                           ISDONE=0
                       END IF
C
                    END DO
                 END DO
              END DO
C
              NUABLO=(NATKNO-MOD(NATKNO-1,NUMCOL)-1)/NUMCOL+1
C
              IOFSET=0
              ISTART=IOFSET+1
              ISTOPP=NATKNO
              DO KBLOCK=1,NUABLO
                 KOFSET=(KBLOCK-1)*NUMCOL
                 KSTART=KOFSET+1
                 KSTOPP=MIN(NATKNO,KOFSET+NUMCOL)
C
                 WRITE(NFIPRI,'(79(1H*),/,1H*,77X,1H*)')
C
                 DO K=KSTART,KSTOPP
                    KCOLUM=K-KOFSET
C
                     LINE_0(KCOLUM)='-'
               WRITE(LINE_1(KCOLUM),'(I1)') (MOD(K,1000)-MOD(K,100))/100
               WRITE(LINE_2(KCOLUM),'(I1)') (MOD(K,100) -MOD(K,10))/10
               WRITE(LINE_3(KCOLUM),'(I1)')  MOD(K,10)
C
                 END DO
C
                 KCOLUM=KSTOPP+1-KOFSET
C
                 LINE_0(KCOLUM)=' '
                 LINE_1(KCOLUM)='|'
                 LINE_2(KCOLUM)='|'
                 LINE_3(KCOLUM)='|'
C
                 DO K=KSTOPP+2,KOFSET+NUMCOL+1
C
                    KCOLUM=K-KOFSET
C
                    LINE_0(KCOLUM)=' '
                    LINE_1(KCOLUM)=' '
                    LINE_2(KCOLUM)=' '
                    LINE_3(KCOLUM)=' '
C
                 END DO
C
                 WRITE(NFIPRI,'(
     *             1H*,1X,''   '',   1X,''GAMMA_T'',64X,1X,1H*,/,
     *             1H*,1X,'' A '','' '',         71A1,1X,1H*,/,
     *             1H*,1X,'' L '',''|'',         71A1,1X,1H*,/,
     *             1H*,1X,'' P '',''|'',         71A1,1X,1H*,/,
     *             1H*,1X,'' H '',''|'',         71A1,1X,1H*,/,
     *             1H*,1X,'' T '','' '',         71A1,1X,1H*)')
     *
     *             LINE_0,LINE_1,LINE_2,LINE_3,LINE_0
C
                 DO I_T=ISTART,ISTOPP
C
                    DO K_T=KSTART,KSTOPP
                       KCOLUM=K_T-KOFSET
                       IF (IS_ISO(I_T,K_T).LE.9) THEN
                           WRITE(LINE_1(KCOLUM),'(A1)')
     *                                          CHAR(IS_ISO(I_T,K_T)+48)
                       ELSE
                           WRITE(LINE_1(KCOLUM),'(A1)')
     *                                          CHAR(IS_ISO(I_T,K_T)+55)
                       END IF
                    END DO
C
                    KCOLUM=KSTOPP+1-KOFSET
C
                    LINE_1(KCOLUM)='|'
C
                    DO K=KSTOPP+2,KOFSET+NUMCOL+1
                       KCOLUM=K-KOFSET
                       LINE_1(KCOLUM)=' '
                    END DO
C
                    WRITE(NFIPRI,'(1H*,I4,''|'',71A1,1X,1H*)')I_T,LINE_1
C
                 END DO
C
                 WRITE(NFIPRI,'(1H*,1X,3X, 1X,71A1,1X,1H*)') LINE_0
                 WRITE(NFIPRI,'(1H*,77X,1H*)')
C
              END DO
C
          END IF
C
          IF (IPAKER.EQ.-1.AND.ISDONE.EQ.0) THEN
C
              WRITE(NFIPRI,'(79(1H*),/,1H*,77X,1H*,/,
     *        1H*,1X,'' PARALLEL CALCULATIONS OF KERNELS'',
     *               '' HAVE NOT YET BEEN COMPLETED.'',  14X,1H*,/,
     *        1H*,1X,'' PLEASE COMPLETE THE PARALLEL CALCULATIONS'',
     *               '' OR RERUN THE JOB WITH IPAKER=0'', 3X,1H*,/,
     *                                      1H*,77X,1H*,/,79(1H*),/)')
C
              GO TO 11
C
          END IF
C
      END IF
C
C=======================================================================
C  IN CASE OF HFB,  THE NORMALISATION FACTORS  FOR BOTH THE PFAFFIAN AND
C  ONISHI FORMULAS FROM WHICH THE OVERLAP KERNEL IS OBTAINED, AS WELL AS
C  SOME BLOCKS OF THE PFAFFIAN MATRIX,  DO  NOT  DEPEND  ON THE SYMMETRY
C  OPERATOR.  ACCORDINGLY,  THEY ARE COMPUTED  HERE  BEFORE ENTERING THE
C  LOOPS OVER THE EULER/EULER-ISO/GAUGE ANGLES. THE NORMALISATION FACTOR
C  ARE CALCULATED BY CALLING  THE PFAFFIAN OR ONISHI ROUNTINES OVRPFA OR
C  OR OVRONI, WHILE THE DIAGONAL BLOCKS OF THE PFAFFIAN MATRIX ARE BUILT
C  IN THE SUBROUTINE PRPFAF. FOR ODD/MULTI-QP STATES, IBLQPY(X,1:NDBLOC)
C  CONTAINS  THE LABELS OF THE UPPER (X=0) AND LOWER (X=1) COMPONENTS OF
C  THE NDBLOC BLOCKED QP IN THE LEFT (Y=L) RIGHT (Y=R) SATES.
C  FROM VERSION 2.99H, THE CUTPFA ROUTINE HAS BEEN REMOVED.
C=======================================================================
C  FOR OFF-DIAGONAL KERNELS, THE NUMBER OF QP LUPPER IS THE SAME FOR THE
C  LEFT AND RIGHT STATES.  THIS IS CHECKED IN THE SUBROUTINE READWF WHEN
C  THE LEFT STATES (SALEFT) ARE READ.
C=======================================================================
C
      IF (IPAHFB.EQ.1) THEN
C
          IF (NBTKNO.NE.1) STOP
     *       'ISO PROJECTION WITH PAIRING IS NOT READY YET IN PROANG'
C
          IF (ISIMPY.EQ.1) STOP
     *       'ISIMPY=1 WITH IPAHFB=1 IS NOT READY YET IN PROANG'
C
          LMAXUR=MAXVAL(LDUPPE(:))+NDBLOC
C
          IF (IONISH.NE.1) THEN
C
             ALLOCATE (TBTALF(1:LMAXUR,1:LMAXUR,0:NDISOS),STAT=IALLOC)
             IF (IALLOC.NE.0) CALL NOALLO('TBTALF','PROANG')
             ALLOCATE (TBTARG(1:LMAXUR,1:LMAXUR,0:NDISOS),STAT=IALLOC)
             IF (IALLOC.NE.0) CALL NOALLO('TBTARG','PROANG')
C
          END IF
C
          DO ICHARG=0,NDISOS
C
             IF (KPAHFB(ICHARG).EQ.0) GO TO 9034
C
C=======================================================================
C         FETCHING THE RIGHT & LEFT WAVE FUNCTIONS FOR THE GIVEN CHARGE.
C         IBLOCR/L INDICATE IF THE  HFB RIGHT/LEFT STATE FOR THE CURRENT
C         ICHARG IS A BLOCKED STATE (1) OR NOT (0).
C=======================================================================
C
             LUPPER=LDUPPE(ICHARG)
             LSTATE=LDTOTS(ICHARG)
             IBLOCR=LPRODR(ICHARG)
             WARIGH(:,:,:)=SARIGH(:,:,:,ICHARG,1)
C
             IF (IDIAGO.EQ.1) THEN
C
                 IBLOCL=IBLOCR
                 WALEFT(:,:,:)=SARIGH(:,:,:,ICHARG,1)
             ELSE
                 IBLOCL=LPRODL(ICHARG)
                 WALEFT(:,:,:)=SALEFT(:,:,:,ICHARG)
C
             END IF
C
C=======================================================================
C         MANAGING THE DATA REQUIRED FOR THE PROJECTION OF  BLOCKED  HFB
C         STATES, WHICH IS POSSIBLE ONLY USING THE  PFAFFIAN FORMULA FOR
C         THE OVERLAPS, I.E. IONISH=0.
C=======================================================================
C         COLLECT IN IBLQPR(Q,:) THE LABELS OF THE UPPER (Q=0) AND LOWER
C         COMPONENTS (Q=1) OF THE BLOCKED QP FOR  RIGHT AND LEFT  STATES
C         AND COUNTS THE NUMBER OF BLOCKED QP.
C         IDBLOR/L COUNT THE NUMBER OF BLCKED QP FOR THE CURRENT ICHARG,
C         AND ARE STORED IN LDBLOR/L.
C=======================================================================
C         FOR NON-BLOCKED STATES,  THE SUBROUTINE  INIADD  IS  CALLED TO
C         INITIALIZE WLABBR, WLABBR.
C=======================================================================
C
             IF (IONISH.EQ.0) THEN
C
                 CALL INIADD
C
                 IBLQPR(0,:)=WLABBR(ICHARG,:)
                 IBLQPR(1,:)=WLABAR(ICHARG,:)
C
                 IF (ISIQTY.EQ.0.AND.ISIMPY.EQ.0) THEN
                   IF (ICHARG.EQ.0) IDBLOR=SUM(ABS(IDSIZN(1:NDBLOC)))
                   IF (ICHARG.EQ.1) IDBLOR=SUM(ABS(IDSIZP(1:NDBLOC)))
C
                 ELSE IF (ISIQTY.EQ.1.AND.ISIMPY.EQ.0) THEN
                   IF (ICHARG.EQ.0) IDBLOR=SUM(ABS(IDSIQN(1:NDBLOC)))
                   IF (ICHARG.EQ.1) IDBLOR=SUM(ABS(IDSIQP(1:NDBLOC)))
                 ELSE
                   STOP ' WRONG SYMMETRY IN PROANG'
                 END IF
C
                 LDBLOR(ICHARG)=IDBLOR
C
                 IF (IDIAGO.EQ.1) THEN
C
                     IDBLOL=IDBLOR
                     IBLQPL(:,:)=IBLQPR(:,:)
                 ELSE
                     IBLQPL(0,:)=WLABBL(ICHARG,:)
                     IBLQPL(1,:)=WLABAL(ICHARG,:)
                     IDBLOL=LDBLOL(ICHARG)
C
                 END IF
C
             ELSE
C
                 IF (IBLOCR.EQ.1.OR.IBLOCL.EQ.1) STOP
     *          'IONISH=1 WITH QP BLOCKING NOT POSSIBLE IN PROANG'
C
             END IF
C
C=======================================================================
C         COMPUTING THE NORM OF THE RIGHT STATE
C=======================================================================
C
             IF (IONISH.EQ.0) THEN
C
                 LDDIAB=LUPPER+NDBLOC
                 ALLOCATE (BTAPRG(1:LDDIAB,1:LDDIAB),STAT=IALLOC)
                 IF (IALLOC.NE.0) CALL NOALLO('BTAPRG','PROANG')
                 ALLOCATE (BTAPLF(1:LDDIAB,1:LDDIAB),STAT=IALLOC)
                 IF (IALLOC.NE.0) CALL NOALLO('BTAPLF','PROANG')
C
                 CALL PRPFAF(LDBASE,LUPPER,IBLOCR,IDBLOR,IBLQPR,
     *                       WARIGH,BTAPLF,BTAPRG)
C
                 PREPFA(1)=C_UNIT
                 PREPFA(2)=C_ZERO
C
                 CALL OVRPFA(LDBASE,LUPPER,IBLOCR,IBLOCR,
     *                       IDBLOR,IDBLOR,IBLQPR,IBLQPR,PREPFA,
     *                       WARIGH,WARIGH,BTAPLF,PFAWRK,ICHARG)
C
             ELSE
C
                 PREONI(1)=C_UNIT
                 PREONI(2)=C_ZERO
C
                 DETWRK(1)=C_UNIT
                 DETWRK(2)=C_ZERO
C
                 CALL OVRONI(LDBASE,LUPPER,PREONI,DETWRK,
     *                       WARIGH,WARIGH,ONIWRK)
C
             END IF
C
C=======================================================================
C          IF IDIAGO=1, STORE THE DIAGONAL BLOCKS AND PREFACTOR.
C=======================================================================
C
             IF (IDIAGO.EQ.1) THEN
C
                 IF (IONISH.EQ.0) THEN
C
                     TBTALF(1:LDDIAB,1:LDDIAB,ICHARG)=
     *                                     BTAPLF(1:LDDIAB,1:LDDIAB)
                     TBTARG(1:LDDIAB,1:LDDIAB,ICHARG)=
     *                                     BTAPRG(1:LDDIAB,1:LDDIAB)
C
                     TREPFA(1,ICHARG)=
     *                             CMPLX(1.0D0/ABS(PFAWRK(1)),0.0D0)
                     TREPFA(2,ICHARG)=-PFAWRK(2)
C
                 ELSE
C
                     TREONI(1,ICHARG)=
     *                             CMPLX(1.0D0/ABS(ONIWRK(1)),0.0D0)
                     TREONI(2,ICHARG)=-ONIWRK(2)
C
                 END IF
C
C=======================================================================
C          IF IDIAGO=0, BUILD THE LEFT STATE CONTRIBUTION.
C=======================================================================
C
             ELSE ! IDIAGO = 0
C
                 IF (IONISH.EQ.0) THEN
C
                     TBTARG(1:LDDIAB,1:LDDIAB,ICHARG)=
     *                                     BTAPRG(1:LDDIAB,1:LDDIAB)
C
                     TREPFA(1,ICHARG)=
     *                       CMPLX(1.0D0/SQRT(ABS(PFAWRK(1))),0.0D0)
                     TREPFA(2,ICHARG)=-0.5D0*PFAWRK(2)
C
                     CALL PRPFAF(LDBASE,LUPPER,IBLOCL,IDBLOL,IBLQPL,
     *                           WALEFT,BTAPLF,BTAPRG)
C
                     PREPFA(1)=C_UNIT
                     PREPFA(2)=C_ZERO
C
                     CALL OVRPFA(LDBASE,LUPPER,IBLOCL,IBLOCL,
     *                           IDBLOL,IDBLOL,IBLQPL,IBLQPL,PREPFA,
     *                           WALEFT,WALEFT,BTAPLF,PFAWRK,ICHARG)
C
                     TBTALF(1:LDDIAB,1:LDDIAB,ICHARG)=
     *                                     BTAPLF(1:LDDIAB,1:LDDIAB)
C
                     TREPFA(1,ICHARG)=TREPFA(1,ICHARG)
     *                      *CMPLX(1.0D0/SQRT(ABS(PFAWRK(1))),0.0D0)
                     TREPFA(2,ICHARG)=TREPFA(2,ICHARG)
     *                               -0.5D0*PFAWRK(2)
C
                 ELSE
C
                     TREONI(1,ICHARG)=
     *                       CMPLX(1.0D0/SQRT(ABS(ONIWRK(1))),0.0D0)
                     TREONI(2,ICHARG)=-0.5D0*ONIWRK(2)
C
                     PREONI(1)=C_UNIT
                     PREONI(2)=C_ZERO
C
                     DETWRK(1)=C_UNIT
                     DETWRK(2)=C_ZERO
C
                     CALL OVRONI(LDBASE,LUPPER,PREONI,DETWRK,
     *                           WALEFT,WALEFT,ONIWRK)
C
                     TREONI(1,ICHARG)=TREONI(1,ICHARG)
     *                      *CMPLX(1.0D0/SQRT(ABS(ONIWRK(1))),0.0D0)
                     TREONI(2,ICHARG)=TREONI(2,ICHARG)
     *                               -0.5D0*ONIWRK(2)
C
                 END IF
C
             END IF
C
             IF (IONISH.EQ.0) DEALLOCATE (BTAPLF,BTAPRG)
C
 9034        CONTINUE
C
          END DO ! ICHARG
      END IF !END IF IPAHFB=1
C
C=======================================================================
C         HERE BEGIN THE LOOPS (NO. 1) OVER THE ALPHA AND GAMMA GAUSS
C         KNOTS.
C=======================================================================
C
      NUALGA=0
      NUAALL=0
      IOPEND=0
C
      DO I=NUABEG,NUAEND
         DO K=NUGBEG,NUGEND
C
            IF (ISALGA(I,K).GE.1.AND.IPAALL.NE.1.AND.ISAKER.EQ.1)GO TO 9
C
            NUALGA=NUALGA+1
C
C=======================================================================
C         THE TRICK BELOW IS INTRODUCED IN ORDER TO SAVE MEMORY,
C         SEE COMMENTS ABOVE
C=======================================================================
C
                             M=I
            IF (IPAKER.EQ.1) M=1
                             N=K
            IF (IPAKER.EQ.1) N=1
C
C=======================================================================
C         HERE BEGINS THE LOOP (NO. 1) OVER THE BETA GAUSS KNOTS.
C=======================================================================
C
            DO J=NUBBEG,NUBEND
C
               ALPROT=XA_PNT(I)
               BETROT=XB_PNT(J)
               GAMROT=XA_PNT(K)
C
C=======================================================================
C         HERE BEGINS THE LOOP (NO. 1) OVER THE BETISO GAUSS KNOTS.
C=======================================================================
C
               DO L=NBTBEG,NBTEND
C
                  IF (ISAALL(I,J,K,L).GE.1.AND.IPAALL.EQ.1.AND.
     *                                         ISAKER.EQ.1) GO TO 899
                  NUAALL=NUAALL+1
C
C=======================================================================
C         HERE BEGIN THE LOOPS (NO. 1) OVER THE ALPHA_T AND GAMMA_T
C         ISOSPIN GAUSS  KNOTS (NOT INDENTED).
C=======================================================================
C
                  DO I_T=NATBEG,NATEND
                     DO K_T=NGTBEG,NGTEND
C
                        ALPISO=XAT_PN(I_T)
                        BETISO=XBT_PN(L)
                        GAMISO=XAT_PN(K_T)
C
                        IF (ISPOIN(I,J,K,I_T,L,K_T).GE.1.AND.
     *                                             ISAKER.EQ.2) GO TO 89
C
C=======================================================================
C         THE TRICK BELOW IS INTRODUCED IN ORDER TO SAVE MEMORY,
C         SEE COMMENTS ABOVE
C=======================================================================
C
                                         M_T=I_T
                        IF (IPAK3D.EQ.1) M_T=1
                                         N_T=K_T
                        IF (IPAK3D.EQ.1) N_T=1
C
C=======================================================================
C         ZEROING ARRAYS WITH KERNELS AGAIN FOR IPAKER=1
C=======================================================================
C         ATTENTION: BETWEEN VERSIONS (2.98B) AND (3.20S), FOR IPAKER=1,
C                    AND AFTER READING THE KERNEL FILES IN "PROANG", THE
C                    KERNEL ARRAYS WERE NOT ZEROED.  HOWEVER,  BEGINNING
C                    WITH VERSION (2.98B), THE KERNELS WERE NOT  DEFINED
C                    BUT ADDITIONALLY SUMMED UP, SO AS TO INTEGRATE OVER
C                    THE PARTICLE NUMBERS AND PARITY. AS A  RESULT,  FOR
C                    IPAKER=1, THEIR VALUES STORED AT M=1 AND  K=1  WERE
C                    ERRONOUSLY PILING UP. THIS BUG WENT UNDETECTED  FOR
C                    A LONG TIME BECAUSE FOR THE  IPAKER=1  CALCULATIONS
C                    PERFORMED FOR SEPARATE VALUES OF M AND K,  THE  BUG
C                    WAS NOT  SHOWING  UP.  THE  BUG  WAS  CORRECTED  ON
C                    28/10/2023 IN VERSION (3.20T).
C=======================================================================
C
      IF (IPAKER.EQ.1) THEN ! NOT INDENTED
C
      QPKERN(:,:,:,:)  =C_ZERO
      ATKERN(:,:,:,:,:)=C_ZERO
      SPKERN(:,:,:,:)  =C_ZERO
      IF (NASORD.GE.0)
     *WTKERN(:,:,:,:,:)=C_ZERO
C
C TER TEKERN=C_ZERO
      OVKERN=C_ZERO
      SKKERN=C_ZERO
      EKKERN=C_ZERO
C
      EPKERN=C_ZERO
C
      CDKERN=C_ZERO
      CDKE10=C_ZERO
      CDKE1P=C_ZERO
      CDKE1M=C_ZERO
      CDKE20=C_ZERO
      CDK21P=C_ZERO
      CDK21M=C_ZERO
      CDK22P=C_ZERO
      CDK22M=C_ZERO
      CXKERN=C_ZERO
      CXKE10=C_ZERO
      CXKE1P=C_ZERO
      CXKE1M=C_ZERO
      CXKE20=C_ZERO
      CXK21P=C_ZERO
      CXK21M=C_ZERO
      CXK22P=C_ZERO
      CXK22M=C_ZERO
      PNKE00=C_ZERO
      PNKE10=C_ZERO
      PNKE1P=C_ZERO
      PNKE1M=C_ZERO
      TZKERN=C_ZERO
      T2KERN=C_ZERO
      BZKERN=C_ZERO
      B2KERN=C_ZERO
C===========================================================
C TER TETERN(:,:,:,:,:)=C_ZERO
      OVTERN(:,:,:,:)=C_ZERO
      SKTERN(:,:,:,:)=C_ZERO
      EKTERN(:,:,:,:)=C_ZERO
      EPTERN(:,:,:,:)=C_ZERO
      CDTERN(:,:,:,:)=C_ZERO
      CDTE10(:,:,:,:)=C_ZERO
      CDTE1P(:,:,:,:)=C_ZERO
      CDTE1M(:,:,:,:)=C_ZERO
      CDTE20(:,:,:,:)=C_ZERO
      CDT21P(:,:,:,:)=C_ZERO
      CDT21M(:,:,:,:)=C_ZERO
      CDT22P(:,:,:,:)=C_ZERO
      CDT22M(:,:,:,:)=C_ZERO
      CXTERN(:,:,:,:)=C_ZERO
      CXTE10(:,:,:,:)=C_ZERO
      CXTE1P(:,:,:,:)=C_ZERO
      CXTE1M(:,:,:,:)=C_ZERO
      CXTE20(:,:,:,:)=C_ZERO
      CXT21P(:,:,:,:)=C_ZERO
      CXT21M(:,:,:,:)=C_ZERO
      CXT22P(:,:,:,:)=C_ZERO
      CXT22M(:,:,:,:)=C_ZERO
      PNTE00(:,:,:,:)=C_ZERO
      PNTE10(:,:,:,:)=C_ZERO
      PNTE1P(:,:,:,:)=C_ZERO
      PNTE1M(:,:,:,:)=C_ZERO
      TZTERN(:,:,:,:)=C_ZERO
      T2TERN(:,:,:,:)=C_ZERO
      BZTERN(:,:,:,:)=C_ZERO
      B2TERN(:,:,:,:)=C_ZERO
C
      END IF ! NOT INDENTED
C
C=======================================================================
C         HERE BEGIN THE LOOPS OF  INTEGRATION  OVER  THE  GAUGE  ANGLES
C         (FOR THE TOTAL-PARTICLE-NUMBER  AND  ISOVECTOR-PARTICLE-NUMBER
C         PROJECTIONS=PNP  AND  IVP)  AND  OVER  THE  PARITY   INVERSION
C         (FOR THE PARITY-SYMMETRY PROJECTION=PSP).
C
C         ATTENTION: THESE THREE LOOPS ARE  N O T  INDENTED.
C
C         ATTENTION: THE TRANSFORMED KERNELS ARE  NOT  STORED,  BUT  THE
C                    INTEGRATION IS PERFORMED ON THE FLY AND  LATER  THE
C                    PNP, IVP, AND/OR PSP PROJECTED KERNELS ARE  STORED.
C                    THIS MEANS THAT PROJECTIONS  ON  ONLY  O_N_E  VALUE
C                    OF THE TOTAL PARTICLE NUMBER "IN_FIX+IZ_FIX", O_N_E
C                    VALUE OF THE ISOV. PARTICLE NUMBER "IN_FIX-IZ_FIX",
C                    AND  ONLY  ON  O_N_E  PARITY  IS  PERFORMED.  THESE
C                    RESTRICTIONS WERE INTRODUCED TO MAINTAIN  THE  SAME
C                    STRUCTURE  OF THE KERNEL  ARRAYS  THAT  BEFORE  HAD
C                    BEEN  IMPLEMENTED  WITHOUT  THE  PNP,  IVP,  AND/OR
C                    PARITY PROJECTIONS.
C=======================================================================
C
                        DO IREFLE=1,NPAKNO
C
                        DO IGAUGE=1,NPNKNO
C
                           PHIGAU=XG_PNT(IGAUGE)
C
                           FACGAP=XP_WGT(IREFLE)*XG_WGT(IGAUGE)*
     *                            EXP(-UNIT_I*PHIGAU*NPNPAR)
C
                        DO IGAUTZ=1,NTZKNO
C
                           PHI_TZ=XT_PNT(IGAUTZ)
C
                           FACGAP=FACGAP        *XT_WGT(IGAUTZ)*
     *                            EXP(-UNIT_I*PHI_TZ*NTZPAR)
C
C=======================================================================
C         BEGINNING THE BLOCK WITHOUT ALPHA_T AND GAMMA_T ROTATION
C=======================================================================
C
                        IF (NATKNO.GT.1) GO TO 6342
C
C    ----->  BEGINNING OF INTERNAL CHARGE LOOP (NO. 1):
C
                        DO ICHARG=0,NDISOS
C
                           MPAHFB=KPAHFB(ICHARG)
C
                           LSTATE=LDTOTS(ICHARG)
                           LUPPER=LDUPPE(ICHARG)
C
C=======================================================================
C         FETCHING THE RIGHT WAVE FUNCTIONS FOR THE GIVEN CHARGE
C=======================================================================
C
                           DO ISTATE=1,LSTATE
                              DO IBASE=1,LDBASE
                                 DO ISPIN=0,NDSPIN
C
                                    WARIGH(IBASE,ISTATE,ISPIN)=
     *                              SARIGH(IBASE,ISTATE,ISPIN,ICHARG,1)
C
                                 END DO
                              END DO
                           END DO
C
C=======================================================================
C  ROTATING THE RIGHT WAVE FUNCTIONS IN SPACE BY THE GIVEN EULER ANGLES
C  AND STORING BOTH NEUTRON AND PROTON SPACE - ROTATED STATES IN TARIGH
C
C          TARIGH CONTAINS RIGHT EIGENVECTOR ROTATED IN SPACE
C                  IN DOUBLE-DIMENSION REPRESENTATION
C
C               |       V_n        |       V_p        |
C               | -----------------| -----------------|
C               |       V_n        |       V_p        |
C
C        SUBSEQUENT ROTATION IN THE ISOSPACE WILL RESULT IN THE
C                  FOLLOWING BETISO ANGLE DEPENDENCE
C
C               | COS(BETISO/2) V_n| -SIN(BETISO/2) V_p|
C               | -----------------| ------------------|
C               | SIN(BETISO/2) V_n|  COS(BETISO/2) V_p|
C
C                      !!!I M P O R T A N T!!!
C        THE BETISO DEPENDENCE WILL BE TAKEN CARE OF EXPLICITELY
C            BOTH IN THE OVERLAP AND THE HAMILTONIAN KERNELS
C=======================================================================
C  NOTE:  WHEN MPAHFB=1, THE ROUTINE ROTWAV ROTATES THE  UPPER COMPONENT
C  OF THE QP  (THAT TRANSFORM AS SINGLE-PARTICLE STATES),  WHILE  ROTLQP
C  ROTATES THE LOWER COMPONENTS (THAT ARE TRANSFORMED VIA R*).
C=======================================================================
C
                           IF (NUAKNO.GT.1.OR.NUBKNO.GT.1) THEN
C
                               IF (MPAHFB.EQ.1) THEN
C
                                  CALL ROTWAV(LUPPER,WARIGH)
                                  CALL ROTLQP(LUPPER,LSTATE,WARIGH)
C
                               ELSE
C
                                  CALL ROTWAV(LSTATE,WARIGH)
C
                               END IF
C
                           END IF
C
                           IF (IKEINV.GE.1.OR.IKEKAR.GE.1)
     *
     *                         CALL INVWAV(LSTATE,IKEINV,IKEKAR,WARIGH)
C
C=======================================================================
C         HERE THE PARITY INVERSION IS PERFORMED
C=======================================================================
C
                           IF (IREFLE.EQ.2)
     *
     *                         CALL INVWAV(LSTATE,1,0,WARIGH)
C
C=======================================================================
C         HERE THE GAUGE ROTATION IS PERFORMED
C=======================================================================
C
                           IF (IGAUGE.GT.1)
     *
     *                         CALL GAUWAV(MPAHFB,LUPPER,LSTATE,WARIGH)
C
C=======================================================================
C         HERE THE TZ GAUGE ROTATION IS PERFORMED
C=======================================================================
C
                           IF (IGAUTZ.GT.1)
     *
     *                         CALL GTZWAV(MPAHFB,LUPPER,LSTATE,WARIGH,
     *                                                          ICHARG)
C
C=======================================================================
C
C
                           DO ISTATE=1,LSTATE
                              DO IBASE=1,LDBASE
                                 JBASE=LDBASE+IBASE
                                 DO ISPIN=0,NDSPIN
C
                                    IF (ICHARG.EQ.0) THEN
                                        TARIGH(IBASE,ISTATE,ISPIN)=
     *                                  WARIGH(IBASE,ISTATE,ISPIN)
C
                                        TARIGH(JBASE,ISTATE,ISPIN)=
     *                                  WARIGH(IBASE,ISTATE,ISPIN)
                                    ELSE
                                        JSTATE=LDTOTS(0)+ISTATE
                                        TARIGH(IBASE,JSTATE,ISPIN)=
     *                                  WARIGH(IBASE,ISTATE,ISPIN)
C
                                        TARIGH(JBASE,JSTATE,ISPIN)=
     *                                  WARIGH(IBASE,ISTATE,ISPIN)
                                    END IF
C
                                 END DO
                              END DO
                           END DO
C
C    ----->  END OF INTERNAL CHARGE LOOP (NO. 1):
C
                        END DO
C
C=======================================================================
C       AT THIS POINT WE ARE IN THE NINE-FOLD LOOP OVER  THE  SIX  EULER
C       ANGLES (THREE THE FOR TOTAL ANGULAR MOMENTUM AND THREE  FOR  THE
C       ISOSPIN) PLUS INVERSION PLUS THE GAUGE AND TZGAUGE ANGLES:
C       ALPHA, GAMMA, BETA, ALPHA_T, GAMMA_T, BETA_T, IREFLE,  PHI, PHIT
C       THAY CORRESPOND TO INDICES:
C           I,     K,    J,    I_T,    K_T,    L, IREFLE, IGAUGE, IGAUTZ
C=======================================================================
C       INDENTATION MOVES BACK FROM THE 25TH TO 12TH COLUMN
C=======================================================================
C       THE FOLLOWING PART OF THE PROGRAM WORKS ONLY IF ISOSPIN
C       PROJECTION IS OFF (NBTKNO=1). IN THIS CASE NEUTRONS AND
C                       PROTONS SEPARATE OUT.
C=======================================================================
C
           IF (NBTKNO.EQ.1) THEN
C
               DO ICHARG=0,NDISOS
C
                  MPAHFB=KPAHFB(ICHARG)
C
                  LSTATE=LDTOTS(ICHARG)
                  LUPPER=LDUPPE(ICHARG)
C
                  IF (MPAHFB.EQ.1)THEN
                      IF (LSTATE.GT.4*NDSTAT)
     *                    STOP ' LSTATE.GT.4*NDSTAT IN PROANG'
                  ELSE
                      IF (LSTATE.GT.2*NDSTAT)
     *                    STOP ' LSTATE.GT.2*NDSTAT IN PROANG'
                  END IF
C
                  DO ISTATE=1,LSTATE
                     DO JSTATE=1,LSTATE
C
                          OVRLAP(ISTATE,JSTATE)=C_ZERO
C
                     END DO
                  END DO
C
C=======================================================================
C         FETCHING THE LEFT WAVE FUNCTIONS FOR THE GIVEN CHARGE
C=======================================================================
C
                  DO ISTATE=1,LSTATE
                     DO IBASE=1,LDBASE
                        DO ISPIN=0,NDSPIN
C
                           IF (IDIAGO.EQ.1) THEN
C
                               WALEFT(IBASE,ISTATE,ISPIN)=
     *                         SARIGH(IBASE,ISTATE,ISPIN,ICHARG,1)
C
                           ELSE
C
                               WALEFT(IBASE,ISTATE,ISPIN)=
     *                         SALEFT(IBASE,ISTATE,ISPIN,ICHARG)
C
                           END IF
C
                        END DO
                     END DO
                  END DO
C
C=======================================================================
C FETCHING THE RIGHT (SPACE ROTATED) WAVE FUNCTIONS FOR THE GIVEN CHARGE
C=======================================================================
C
                  DO ISTATE=1,LSTATE
                     DO IBASE=1,LDBASE
                        JBASE=LDBASE+IBASE
                        DO ISPIN=0,NDSPIN
C
                              IF (ICHARG.EQ.0) THEN
                              WARIGH(IBASE,ISTATE,ISPIN)=
     *                        TARIGH(IBASE,ISTATE,ISPIN)
                              ELSE
                              JSTATE=LDTOTS(0)+ISTATE
                              WARIGH(IBASE,ISTATE,ISPIN)=
     *                        TARIGH(JBASE,JSTATE,ISPIN)
                              END IF
C
                        END DO
                     END DO
                  END DO
C
C=======================================================================
C PREPARE THE WF FOR TRANSITION DENSITIES IN HFB CASE
C=======================================================================
C         CALCULATING THE OVERLAP BETWEEN THE LEFT AND RIGHT STATES
C=======================================================================
C
                  IF (MPAHFB.EQ.1) THEN
C
                      IF (IONISH.EQ.0) THEN
C
                          IBLOCR=LPRODR(ICHARG)
                          IBLQPR(0,:)=WLABBR(ICHARG,:)
                          IBLQPR(1,:)=WLABAR(ICHARG,:)
                          IDBLOR=LDBLOR(ICHARG)

                          IF (IDIAGO.EQ.1) THEN
                              IBLOCL=IBLOCR
                              IBLQPL(:,:)=IBLQPR(:,:)
                              IDBLOL=IDBLOR
                          ELSE
                              IBLOCL=LPRODL(ICHARG)
                              IBLQPL(0,:)=WLABBL(ICHARG,:)
                              IBLQPL(1,:)=WLABAL(ICHARG,:)
                              IDBLOL=LDBLOL(ICHARG)
                          END IF
C
                          PREPFA(:)=TREPFA(:,ICHARG)
C
                          LDDIAB=LUPPER+NDBLOC
                          ALLOCATE (BTAPRG(1:LDDIAB,1:LDDIAB)
     *                                          ,STAT=IALLOC)
                          IF (IALLOC.NE.0)
     *                               CALL NOALLO('BTAPRG','PROANG')
                          ALLOCATE (BTAPLF(1:LDDIAB,1:LDDIAB)
     *                                          ,STAT=IALLOC)
                          IF (IALLOC.NE.0)
     *                               CALL NOALLO('BTAPLF','PROANG')
C
                          BTAPLF(1:LDDIAB,1:LDDIAB)=
     *                    TBTALF(1:LDDIAB,1:LDDIAB,ICHARG)
                          BTAPRG(1:LDDIAB,1:LDDIAB)=
     *                    TBTARG(1:LDDIAB,1:LDDIAB,ICHARG)
C
                          CALL OVRPFA(LDBASE,LUPPER,IBLOCL,IBLOCR,
     *                         IDBLOL,IDBLOR,IBLQPL,IBLQPR,PREPFA,
     *                         WALEFT,WARIGH,BTAPLF,PFAWRK,ICHARG)
C
                          FACOVR(ICHARG)=PFAWRK(1)*
     *                                         10.0D0**REAL(PFAWRK(2))
C
                          DEALLOCATE (BTAPLF,BTAPRG)
C
                      END IF ! END IONISHI=0
C
C=======================================================================
C         CALCULATING THE OVERLAP MATRIX REMOVING FIRST THE RUSSIAN
C         RUSSIAN CONVENTION IN BOTH WALEFT AND WARIGH
C=======================================================================
C
                      CALL RUSSOF(LUPPER,LSTATE,WALEFT)
                      CALL RUSSOF(LUPPER,LSTATE,WARIGH)
C
                      CALL OVRMAT(LDBASE,LUPPER,WALEFT,WARIGH,OVRLAP)
C
C=======================================================================
C         INVERTING THE OVERLAP MATRIX
C=======================================================================
C
                      CALL ZGECO(OVRLAP,4*NDSTAT,LUPPER,IAUXDI,
     *                                          RICOND,AUXDIA)
                      CALL ZGEDI(OVRLAP,4*NDSTAT,LUPPER,IAUXDI,
     *                                          DETWRK,AUXDIA,11)
C
                      IF (ABS(RICOND).LT.1.0D-12) THEN
C
                          WRITE(NFIPRI,*)
     *                    'BE CAREFUL - THE OVERLAP MATRIX ',
     *                    'MAY BE SINGULAR FOR:'
                          WRITE(NFIPRI,'(''  M='',I3,''  J='',I3,
     *                                   ''  N='',I3,
     *                                   ''  ICHARG='',I1,
     *                                   ''  MPAHFB='',I1,
     *                                   ''  RICOND='',E15.5)')
     *                                   M,J,N,ICHARG,MPAHFB,RICOND
C
                      END IF
C
C=======================================================================
C         COMPUTING THE OVERLAP VIA ONISHI
C=======================================================================
C
                      IF (IONISH.EQ.1) THEN
C
                          PREONI(:)=TREONI(:,ICHARG)
C
                          CALL OVRONI(LDBASE,LUPPER,PREONI,DETWRK,
     *                                WALEFT,WARIGH,ONIWRK)

                          FACOVR(ICHARG)=ONIWRK(1)*
     *                                        10.0D0**REAL(ONIWRK(2))
C
                      END IF
C
C=======================================================================
C         MULTIPLYING THE RIGHT WAVE FUNCTIONS BY THE INVERTED OVERLAP
C         MATRIX AND PUTTING BACK THE RUSSIAN CONVENTION
C=======================================================================
C
                      WARITP(:,:,:)=C_ZERO
C
                      DO IBASE=1,LDBASE
                         DO ISTATE=1,LUPPER
                            ISTALO=ISTATE+LUPPER
                            DO ISPIN=0,NDSPIN
                               DO JSTATE=1,LUPPER
                                  JSTALO=JSTATE+LUPPER
C
                                  WARITP(IBASE,ISTATE,ISPIN)=
     *                            WARITP(IBASE,ISTATE,ISPIN)
     *                           +WARIGH(IBASE,JSTATE,ISPIN)
     *                           *OVRLAP(JSTATE,ISTATE)
C
                                  WARITP(IBASE,ISTALO,ISPIN)=
     *                            WARITP(IBASE,ISTALO,ISPIN)
     *                           +WARIGH(IBASE,JSTALO,ISPIN)
     *                           *OVRLAP(JSTATE,ISTATE)
C
                               END DO
                            END DO
                         END DO
                      END DO
C
                      WARIGH(:,:,:)=WARITP(:,:,:)
C
                      CALL RUSSON(LUPPER,LSTATE,WALEFT)
                      CALL RUSSON(LUPPER,LSTATE,WARIGH)
C
C  ------> STORING RIGHT VECTORS MULTIPLIED BY THE INVERTED OVERLAP
C          MATRIX IN TARIGH.
C
                      IF(ICHARG.EQ.0)THEN
                          TARIGH(1:LDBASE,1:LSTATE,0:NDSPIN)=
     *                    WARIGH(1:LDBASE,1:LSTATE,0:NDSPIN)
C
                          TARIGH(1+LDBASE:2*LDBASE,1:LSTATE,0:NDSPIN)=
     *                    WARIGH(1:LDBASE,1:LSTATE,0:NDSPIN)
                      ELSE
                          JSTATE=LDTOTS(0)
                          TARIGH(1:LDBASE,
     *                         JSTATE+1:JSTATE+LSTATE,0:NDSPIN)=
     *                    WARIGH(1:LDBASE,1:LSTATE,0:NDSPIN)
C
                          TARIGH(1+LDBASE:2*LDBASE,
     *                         JSTATE+1:JSTATE+LSTATE,0:NDSPIN)=
     *                    WARIGH(1:LDBASE,1:LSTATE,0:NDSPIN)
                      END IF
C
C=======================================================================
C PREPARE THE WF FOR TRANSITION DENSITIES IN HF CASE
C=======================================================================
C         CALCULATING THE OVERLAPS BETWEEN THE LEFT AND RIGHT STATES
C=======================================================================
C
                  ELSE ! MPAHFB.EQ.0
C
                      DO ISTATE=1,LSTATE
                         DO JSTATE=1,LSTATE
                            DO IBASE=1,LDBASE
                               DO ISPIN=0,NDSPIN
C
                                  OVRLAP(ISTATE,JSTATE)=
     *                            OVRLAP(ISTATE,JSTATE)
     *                            +CONJG(WALEFT(IBASE,ISTATE,ISPIN))
     *                                  *WARIGH(IBASE,JSTATE,ISPIN)
C
                               END DO
                            END DO
                         END DO
                      END DO
C
C=======================================================================
C         INVERTING THE OVERLAP MATRIX
C=======================================================================
C
C         WRITE (*,773) M,J,N,ICHARG
C 773     FORMAT(1X,'OVERLAP PREPARED FOR:',4I4)
C
                      CALL ZGECO(OVRLAP,4*NDSTAT,LSTATE,IAUXDI,
     *                                           RICOND,AUXDIA)
                      CALL ZGEDI(OVRLAP,4*NDSTAT,LSTATE,IAUXDI,
     *                                           DETWRK,AUXDIA,11)
C
                      FACOVR(ICHARG)=DETWRK(1)
     *                                    *10.0D0**REAL(DETWRK(2))
C
C                     OVKERN(M,J,N,1,ICHARG,1)=FACOVR(ICHARG)
C
                      IF (ABS(RICOND).LT.1.0D-12) THEN
C
                          WRITE(NFIPRI,*)
     *                    'BE CAREFUL - THE OVERLAP MATRIX ',
     *                    'MAY BE SINGULAR FOR:'
                          WRITE(NFIPRI,'(''  M='',I3,''  J='',I3,
     *                                   ''  N='',I3,
     *                                   ''  ICHARG='',I1,
     *                                   ''  MPAHFB='',I1,
     *                                   ''  RICOND='',E15.5)')
     *                                   M,J,N,ICHARG,MPAHFB,RICOND
C
C
                      END IF
C
C         WRITE (*,772) M,J,N,ICHARG
C 772     FORMAT(1X,'OVERLAP INVERTED FOR:',4I4)
C
C=======================================================================
C         MULTIPLYING THE RIGHT WAVE FUNCTIONS BY THE INVERTED OVERLAP
C         MATRIX
C=======================================================================
C
                      DO IBASE=1,LDBASE
                         JBASE=  LDBASE+IBASE
C
                         DO ISTATE=1,LSTATE
                            DO ISPIN=0,NDSPIN
C
                               WARAUX(ISTATE,ISPIN)=C_ZERO
C
                               DO KSTATE=1,LSTATE
C
                                  WARAUX(ISTATE,ISPIN)=
     *                            WARAUX(ISTATE,ISPIN)
     *                           +WARIGH(IBASE,KSTATE,ISPIN)
     *                           *OVRLAP(KSTATE,ISTATE)
C
                               END DO
C
                            END DO
                         END DO
C
                         DO ISTATE=1,LSTATE
                            DO ISPIN=0,NDSPIN
C
C  ------> STORING RIGHT VECTORS MULTIPLIED BY THE INVERTED OVERLAP
C          MATRIX IN TARIGH.
C
                               IF (ICHARG.EQ.0) THEN
                                   TARIGH(IBASE,ISTATE,ISPIN)=
     *                                   WARAUX(ISTATE,ISPIN)
                                   TARIGH(JBASE,ISTATE,ISPIN)=
     *                                   WARAUX(ISTATE,ISPIN)
                               ELSE
                                   KSTATE=LDTOTS(0)+ISTATE
                                   TARIGH(IBASE,KSTATE,ISPIN)=
     *                                   WARAUX(ISTATE,ISPIN)
                                   TARIGH(JBASE,KSTATE,ISPIN)=
     *                                   WARAUX(ISTATE,ISPIN)
                               END IF
C
                            END DO
                         END DO
C
                      END DO
                  END IF!HF CASE END
               END DO
C
C=======================================================================
C    HERE WE DEFINE THE PRODUCT OF NEUTRON AND PROTON OVERLAPS
C=======================================================================
C
               FACOVT=FACOVR(0)*FACOVR(1)*FACGAP
C
               OVKERN(M,J,N,1,0,1)=
     *         OVKERN(M,J,N,1,0,1)+FACOVR(0)*FACGAP
C
               OVKERN(M,J,N,1,1,1)=
     *         OVKERN(M,J,N,1,1,1)+FACOVT
C
           END IF! NBTKNO.EQ.1 END
C
C=======================================================================
C        THE  FOLLOWING  PART  OF  THE  PROGRAM    CALCULATES   OVERLAP,
C        INVERETED   OVERLAP,  AND  MULTIPLIES  RIGHT  VECTORS  BY   THE
C        INVERTED OVERLAP MATRIX IN THE CASE OF AXIAL ISOSPIN PROJECTION
C=======================================================================
C
           IF (NBTKNO.GT.1.AND.NATKNO.EQ.1) THEN
C
               DO ICHARG=0,NDISOS
                  LSTATE=LDTOTS(ICHARG)
C
                  DO ISTATE=1,LSTATE
                     DO IBASE=1,LDBASE
                        JBASE=  LDBASE+IBASE
                        DO ISPIN=0,NDSPIN
C
                          IF (ICHARG.EQ.0) THEN
                          TARIGH(IBASE,ISTATE,ISPIN)=
     *                    TARIGH(IBASE,ISTATE,ISPIN)*
     *                                COS(BETISO/2.)
C
                          TARIGH(JBASE,ISTATE,ISPIN)=
     *                    TARIGH(JBASE,ISTATE,ISPIN)*
     *                                 SIN(BETISO/2.)
                          ELSE
                          JSTATE=LDTOTS(0)+ISTATE
                          TARIGH(IBASE,JSTATE,ISPIN)=
     *                   -TARIGH(IBASE,JSTATE,ISPIN)*
     *                                SIN(BETISO/2.)
C
                          TARIGH(JBASE,JSTATE,ISPIN)=
     *                    TARIGH(JBASE,JSTATE,ISPIN)*
     *                                COS(BETISO/2.)
C
                          END IF
C
                        END DO
                     END DO
                  END DO
C
               END DO
C
               LSTAT2=LDTOTS(0)+LDTOTS(1)
C
               IF (LSTAT2.GT.4*NDSTAT)
     *             STOP ' LSTAT2.GT.4*NDSTAT IN PROANG'
C
               DO ISTATE=1,LSTAT2
                  DO JSTATE=1,LSTAT2
C
                       OVRLAP(ISTATE,JSTATE)=C_ZERO
C
                  END DO
               END DO
C
C-----------------------------------------------------------------------
C           HERE STARTS INTERNAL LOOP OVER CHARGE (NO. 2):
C-----------------------------------------------------------------------
C
               DO ICHARG=0,NDISOS
                  LSTATE=LDTOTS(ICHARG)
C
C=======================================================================
C         FETCHING THE LEFT WAVE FUNCTIONS FOR THE GIVEN CHARGE
C=======================================================================
C
                  DO ISTATE=1,LSTATE
                     DO IBASE=1,LDBASE
                        DO ISPIN=0,NDSPIN
C
                           IF (IDIAGO.EQ.1) THEN
C
                               WALEFT(IBASE,ISTATE,ISPIN)=
     *                         SARIGH(IBASE,ISTATE,ISPIN,ICHARG,1)
C
                           ELSE
C
                               WALEFT(IBASE,ISTATE,ISPIN)=
     *                         SALEFT(IBASE,ISTATE,ISPIN,ICHARG)
C
                           END IF
C
                        END DO
                     END DO
                  END DO
C
C=======================================================================
C
                  IF (ICHARG.EQ.0) THEN
C
                      DO ISTATE=1,LDTOTS(0)
                         DO IBASE=1,LDBASE
                            JBASE=  LDBASE+IBASE
                            DO ISPIN=0,NDSPIN
C
                                  TALEFT(IBASE,ISTATE,ISPIN)=
     *                            WALEFT(IBASE,ISTATE,ISPIN)
C
                                  TALEFT(JBASE,ISTATE,ISPIN)=C_ZERO
C
                            END DO
                         END DO
                     END DO
C
                  ELSE
C
                      DO ISTATE=1,LDTOTS(1)
                         JSTATE=  LDTOTS(0)+ISTATE
                         DO IBASE=1,LDBASE
                            JBASE=  LDBASE+IBASE
                            DO ISPIN=0,NDSPIN
C
                                  TALEFT(JBASE,JSTATE,ISPIN)=
     *                            WALEFT(IBASE,ISTATE,ISPIN)
C
                                  TALEFT(IBASE,JSTATE,ISPIN)=C_ZERO
C
                            END DO
                         END DO
                     END DO
C
                  END IF
C
               END DO
C
C-----------------------------------------------------------------------
C     END OF INTERNAL CHARGE LOOP (NO. 2)- THE OVERLAP MATRIX IS LOADED
C-----------------------------------------------------------------------
C
C-----------------------------------------------------------------------
C     LOADING THE OVERLAP MATRIX:
C-----------------------------------------------------------------------
C
               DO ISTATE=1,LSTAT2
                  DO JSTATE=1,LSTAT2
                     DO IBASE=1,2*LDBASE
                        DO ISPIN=0,NDSPIN
C
                           OVRLAP(ISTATE,JSTATE)=
     *                     OVRLAP(ISTATE,JSTATE)
     *                     +CONJG(TALEFT(IBASE,ISTATE,ISPIN))
     *                           *TARIGH(IBASE,JSTATE,ISPIN)
C
                        END DO
                     END DO
                  END DO
               END DO
C-----------------------------------------------------------------------
C     THE OVERLAP MATRIX IS LOADED
C-----------------------------------------------------------------------
C
C=======================================================================
C                    INVERTING THE OVERLAP MATRIX
C=======================================================================
C
               CALL ZGECO(OVRLAP,4*NDSTAT,LSTAT2,IAUXDI,
     *                                    RICOND,AUXDIA)
               CALL ZGEDI(OVRLAP,4*NDSTAT,LSTAT2,IAUXDI,
     *                                    DETWRK,AUXDIA,11)
C
               FACOVT=DETWRK(1)*10.0D0**REAL(DETWRK(2))
     *               *FACGAP
C
               OVKERN(M,J,N,1,L,1)=
     *         OVKERN(M,J,N,1,L,1)+FACOVT
C
CJD            WRITE(*,7876) M,J,N,L,BETISO,OVKERN(M,J,N,1,L,1)
C7876          FORMAT(2X,4I3,F6.3,2X,2F16.10)
C
               IF (ABS(RICOND).LT.1.0D-12) THEN
C
                   WRITE(NFIPRI,*)
     *             'BE CAREFUL - THE OVERLAP MATRIX ',
     *             'MAY BE SINGULAR FOR:'
                   WRITE(NFIPRI,'(''  M='',I3,''  J='',I3,
     *                            ''  N='',I3,''  L='',I3,
     *                            ''  ICHARG='',I1,''  MPAHFB='',I1,
     *                            ''  RICOND='',E15.5)')
     *                            M,J,N,L,ICHARG,MPAHFB,RICOND
C
               END IF
C
C=======================================================================
C
               DO IBASE=1,2*LDBASE
C
                  DO ISTATE=1,LSTAT2
                     DO ISPIN=0,NDSPIN
C
                        WARAUX(ISTATE,ISPIN)=C_ZERO
C
                        DO KSTATE=1,LSTAT2
C
                           WARAUX(ISTATE,ISPIN)=WARAUX(ISTATE,ISPIN)
     *                                  +TARIGH(IBASE,KSTATE,ISPIN)
     *                                  *OVRLAP(KSTATE,ISTATE)
                        END DO
C
                     END DO
                  END DO
C
                  DO ISTATE=1,LSTAT2
                     DO ISPIN=0,NDSPIN
C
                        TARIGH(IBASE,ISTATE,ISPIN)=
     *                        WARAUX(ISTATE,ISPIN)
C
                     END DO
                  END DO
C
               END DO
C
C
C           ===============================================
C                  RIGHT VECTORS ARE LOADED IN TARIGH
C           ===============================================
C
           END IF
C
C=======================================================================
C         ENDING THE BLOCK FOR AXIAL ISOSPIN PROJECTION
C=======================================================================
C
 6342      CONTINUE
C
C=======================================================================
C        THE  FOLLOWING  PART  OF  THE   PROGRAM   CALCULATES   OVERLAP,
C        INVERETED  OVERLAP,  AND  MULTIPLIES  RIGHT  VECTORS   BY   THE
C        INVERTED OVERLAP MATRIX IN THE CASE OF  3D  ISOSPIN  PROJECTION
C=======================================================================
C        INDENTATION MOVES BACK FROM THE 12TH TO 10TH COLUMN
C=======================================================================
C
         IF (NATKNO.GT.1) THEN
C
C    ----->  BEGINNING OF INTERNAL CHARGE LOOP (NO. 1):
C
             LSTATE=LDTOTS(0)
C
             DO ICHARG=0,NDISOS
C
C=======================================================================
C         FETCHING THE RIGHT WAVE FUNCTIONS FOR THE GIVEN CHARGE
C=======================================================================
C
                DO ISTATE=1,LSTATE
                   DO IBASE=1,LDBASE
                      DO ISPIN=0,NDSPIN
C
                         WARIGH(IBASE,ISTATE,ISPIN)=
     *                   SARIGH(IBASE,ISTATE,ISPIN,ICHARG,1)
C
                      END DO
                   END DO
                END DO
C
C=======================================================================
C  ROTATING THE RIGHT WAVE FUNCTIONS IN SPACE BY THE GIVEN EULER ANGLES
C  AND STORING BOTH NEUTRON AND PROTON SPACE - ROTATED STATES IN TARIGH
C
C          TARIGH CONTAINS RIGHT EIGENVECTOR ROTATED IN SPACE
C                  IN DOUBLE-DIMENSION REPRESENTATION
C
C=======================================================================
C
                IF (NUBKNO.GT.1)
     *
     *              CALL ROTWAV(LSTATE,WARIGH)
C
                IF (IKEINV.GE.1.OR.IKEKAR.GE.1)
     *
     *              CALL INVWAV(LSTATE,IKEINV,IKEKAR,WARIGH)
C
                DO ISTATE=1,LSTATE
                   DO IBASE=1,LDBASE
                      JBASE=  LDBASE+IBASE
                      DO ISPIN=0,NDSPIN
C
                        IF (ICHARG.EQ.0) THEN
                        TARIGH(IBASE,ISTATE,ISPIN)=
     *                  WARIGH(IBASE,ISTATE,ISPIN)
C
                        ELSE
                        TARIGH(JBASE,ISTATE,ISPIN)=
     *                  WARIGH(IBASE,ISTATE,ISPIN)
C
                        END IF
C
                      END DO
                   END DO
                END DO
C
C    ----->  END OF INTERNAL CHARGE LOOP (NO. 1):
             END DO
C
             CALL ROTISO(LSTATE,TARIGH)
C
             LSTAT2=LDTOTS(0)
C
             IF (LSTAT2.GT.4*NDSTAT)
     *           STOP ' LSTAT2.GT.4*NDSTAT IN PROANG 2'
C
             DO ISTATE=1,LSTAT2
                DO JSTATE=1,LSTAT2
C
                     OVRLAP(ISTATE,JSTATE)=C_ZERO
C
                END DO
             END DO
C
C-----------------------------------------------------------------------
C           HERE STARTS INTERNAL LOOP OVER CHARGE (NO. 2):
C-----------------------------------------------------------------------
C
             DO ICHARG=0,NDISOS
C
C=======================================================================
C         FETCHING THE LEFT WAVE FUNCTIONS FOR THE GIVEN CHARGE
C=======================================================================
C
                DO ISTATE=1,LSTATE
                   DO IBASE=1,LDBASE
                      IF (ICHARG.EQ.0) THEN
                          JBASE=IBASE
                      ELSE
                          JBASE=IBASE+LDBASE
                      END IF
                      DO ISPIN=0,NDSPIN
C
                         IF (IDIAGO.EQ.1) THEN
C
                             TALEFT(JBASE,ISTATE,ISPIN)=
     *                       SARIGH(IBASE,ISTATE,ISPIN,ICHARG,1)
C
                         ELSE
C
                             TALEFT(JBASE,ISTATE,ISPIN)=
     *                       SALEFT(IBASE,ISTATE,ISPIN,ICHARG)
C
                             STOP ' NOT READY YET IN PROANG'
C
                         END IF
C
                      END DO
                   END DO
                END DO
C
C-----------------------------------------------------------------------
C            END OF INTERNAL CHARGE LOOP (NO. 2)
C-----------------------------------------------------------------------
C
             END DO
C
C=======================================================================
C         CALCULATING THE OVERLAPS BETWEEN THE LEFT AND RIGHT STATES
C=======================================================================
C
             DO ISTATE=1,LSTATE
                DO JSTATE=1,LSTATE
                   DO IBASE=1,2*LDBASE
                      DO ISPIN=0,NDSPIN
C
                         OVRLAP(ISTATE,JSTATE)=
     *                   OVRLAP(ISTATE,JSTATE)
     *                   +CONJG(TALEFT(IBASE,ISTATE,ISPIN))
     *                         *TARIGH(IBASE,JSTATE,ISPIN)
C
                      END DO
                   END DO
                END DO
             END DO
C
C=======================================================================
C                    INVERTING THE OVERLAP MATRIX
C=======================================================================
C
             CALL ZGECO(OVRLAP,4*NDSTAT,LSTAT2,IAUXDI,
     *                                  RICOND,AUXDIA)
             CALL ZGEDI(OVRLAP,4*NDSTAT,LSTAT2,IAUXDI,
     *                                  DETWRK,AUXDIA,11)
C
             FACOVT=DETWRK(1)*10.0D0**REAL(DETWRK(2))
     *             *FACGAP
C
             OVKERN(M,J,N,M_T,L,N_T)=
     *       OVKERN(M,J,N,M_T,L,N_T)+FACOVT
C
C            WRITE(*,7877) M,J,N, M_T,L,N_T,  I,J,K, I_T,L,K_T,
C    *                     ALPISO,BETISO,GAMISO,
C    *                     OVKERN(M,J,N,M_T,L,N_T),
C    *                 ABS(OVKERN(M,J,N,M_T,L,N_T))
C7877        FORMAT(2X,2(6I3,2X),3F6.3,2X,2F16.10,D18.10)
C
             IF (ABS(RICOND).LT.1.0D-12) THEN
C
                 WRITE(NFIPRI,*)
     *           'BE CAREFUL - THE OVERLAP MATRIX ',
     *           'MAY BE SINGULAR FOR:'
                 WRITE(NFIPRI,'(''  M='',I3,''  J='',I3,
     *                          ''  N='',I3,''  L='',I3,
     *                          ''  ICHARG='',I1,''  MPAHFB='',I1,
     *                          ''  RICOND='',E15.5)')
     *                          M,J,N,L,ICHARG,MPAHFB,RICOND
C
             END IF
C
             DO IBASE=1,2*LDBASE
C
                DO ISTATE=1,LSTATE
                   DO ISPIN=0,NDSPIN
C
                      WARAUX(ISTATE,ISPIN)=C_ZERO
C
                      DO KSTATE=1,LSTATE
C
                         WARAUX(ISTATE,ISPIN)=WARAUX(ISTATE,ISPIN)
     *                                +TARIGH(IBASE,KSTATE,ISPIN)
     *                                *OVRLAP(KSTATE,ISTATE)
                      END DO
C
                   END DO
                END DO
C
                DO ISTATE=1,LSTATE
                   DO ISPIN=0,NDSPIN
C
                      TARIGH(IBASE,ISTATE,ISPIN)=
     *                      WARAUX(ISTATE,ISPIN)
C
                   END DO
                END DO
C
             END DO
C
C=======================================================================
C         ENDING THE BLOCK FOR 3D ISOSPIN PROJECTION
C=======================================================================
C
         END IF
C
C=======================================================================
C
C              HERE STARTS "DENSITIES AND CURRENTS" BLOCK
C
C=======================================================================
C
C=======================================================================
C    NEW "EXTERNAL" CHARGE LOOP (NO. 3) FOR DENSITIS AND CURRENTS BLOCK
C=======================================================================
C
         DO ICHARG=0,NDISOS
C
            MPAHFB=KPAHFB(ICHARG)
C
            LSTATE=LDTOTS(ICHARG)
C
C=======================================================================
C          FETCHING THE LEFT WAVE FUNCTIONS FOR THE GIVEN CHARGE
C=======================================================================
C
            DO ISTATE=1,LSTATE
               DO IBASE=1,LDBASE
                  DO ISPIN=0,NDSPIN
C
                     IF (IDIAGO.EQ.1) THEN
C
                         WALEFT(IBASE,ISTATE,ISPIN)=
     *                   SARIGH(IBASE,ISTATE,ISPIN,ICHARG,1)
C
                     ELSE
C
                         WALEFT(IBASE,ISTATE,ISPIN)=
     *                   SALEFT(IBASE,ISTATE,ISPIN,ICHARG)
C
                     END IF
C
                  END DO
               END DO
            END DO
C
C=======================================================================
C          HERE BEGIN CALCULATIONS OF NEUTRON-NEUTRON AND NEUTRON-PROTON
C                     DENSITIES AND OBSERVABLES
C=======================================================================
C
            IF (ICHARG.EQ.0) THEN
C
                ITPNMX=0
C
C=======================================================================
C                 ZEROING THE NEUTRON DENSITIES
C=======================================================================
C
                CALL ZEDENS(ITPNMX)
C
C=======================================================================
C            FETCHING THE RIGHT WAVE FUNCTIONS TO BE USED TO
C              CALCULATE THE NEUTRON-NEUTRON DENSITIES AND CURRENTS
C=======================================================================
C
                DO IBASE=1,LDBASE
                   DO ISTATE=1,LDTOTS(0)
                      DO ISPIN=0,NDSPIN
                        WARIGH(IBASE,ISTATE,ISPIN)
     *                 =TARIGH(IBASE,ISTATE,ISPIN)
                      END DO
                   END DO
                END DO
C
                CALL DENSHF(ISIMTX,JSIMTY,ISIMTZ,
     *                      ISIGNY,ISIMPY,ISIQTY,MPAHFB,MREVER,ICHARG,
     *                                           MIN_QP,IPNMIX,ITPNMX,
     *                             ITIREP,NAMEPN,PRINIT,IDEVAR,ITERUN,
     *                      ISYMDE,INIROT,INIINV,INIKAR,ISAWAV,IKERNE,
     *                                                         ITWCEN,1)
C
C=======================================================================
C                 CALCULATING THE NEUTRON TRANSITION DENSITY MATRIX
C                 AND TRANSITION  MATRIX  ELEMENTS  OF  OBSERVABLES
C=======================================================================
C
                CALL DENMAC(MREVER,ICHARG,ISIMPY,MPAHFB,WALEFT,WARIGH,1)
C
                CALL SAVDEN(ISIMPY,ITPNMX)
C
                CALL EKINET(ENEKIN,DLINSQ,EKEKIN,DKINSQ,1)
C
                IF (MPAHFB.EQ.1) THEN
C
C=======================================================================
C        CALCULATING THE   N E U T R O N   P A I R I N G   T E N S O R S
C        THAT CORRESPOND TO RIGHT-LEFT AND  LEFT-RIGHT  MATRIX  ELEMENTS
C=======================================================================
C
                    IF (KETAJ2.EQ.1.OR.KETAT2.EQ.1.OR.
     *                  IGOGPA.GE.1.OR.IREGPA.GE.1.OR.
     *                  ISEPPA.GE.1.OR.ICOUPA.GE.1) THEN
C     ACTIVATE WHEN THE PROJECTION OF SPIN-ORBIT AND TENSOR IS DONE
C                   IF (KETAJ2.EQ.1.OR.KETAT2.EQ.1.OR.
C    *                  ICOUPA.GE.1.OR.MAXVAL(IFSTPA).GE.1.OR.
C    *                  IGOGPA.GE.1.OR.IREGPA.GE.1.OR.ISEPPA.GE.1) THEN
C
                        CALL PAIMAC(ICHARG,ISIMPY,
     *                              WARIGH,WALEFT,IKERNE)
C
                        CALL STO2ND(ISIMPY)
C
                        CALL PAIMAC(ICHARG,ISIMPY,
     *                              WALEFT,WARIGH,IKERNE)
C
                        CALL SAVPAI(ISIMPY,ITPNMX)
C
                    END IF
C
                END IF
C
C=======================================================================
C               FOR NBTKNO.EQ.1 KERNELS ARE STORED AT TWO VALUES OF
C                               ICHARG=0 AND 1
C               FOR NBTKNO.NE.1 KERNELS ARE SUMMED-UP FOR THE TWO VALUES
C                               OF ICHARGE=0 AND 1 AND STORED AT L
C=======================================================================
C
                IF (NBTKNO.EQ.1) THEN
                    EKKERN(M,J,N,M_T,ICHARG,N_T)=
     *              EKKERN(M,J,N,M_T,ICHARG,N_T)+EKEKIN
     *                                          *FACOVT
                ELSE
                    EKKERN(M,J,N,M_T,L,N_T     )=
     *              EKKERN(M,J,N,M_T,L,N_T     )+EKEKIN
     *                                          *FACOVT
                END IF
C
C=======================================================================
C        CALCULATING THE ANGULAR MOMENTUM TRANSITION KERNELS
C        FOR NEUTRONS
C=======================================================================
C
                IF (KETAJ2.EQ.1) THEN
C
                    META_R=1
                    BORROT=.TRUE.
C
                    CALL ROTAVR(ISIMPY,ISIGNY,ISIQTY,
     *                 MPAHFB,ICHARG,META_R,IROTAT,MREVER,BORROT,IKERNE,
     *                 DROTSN,EROTSN,PROTSN,TROTSN,AROTLN,PROTLN,PROTKN,
     *                 DKOTSN,EKOTSN,PKOTSN,TKOTSN,AKOTLN,PKOTLN,PKOTKN)
C
                END IF
C
C=======================================================================
C      SAVE BIG_PP AND BIG_PM REPRESENTING DN_RHO ON THE BASIS
C       IN BNN_PP AND BNN_PM FOR FURTHER COULOMB CALCULATIONS
C=======================================================================
C
                BNN_PP(:,:,:)=BIG_PP(:,:,:)
                IF (ISIMPY.NE.1) THEN
                    BNN_PM(:,:,:)=BIG_PM(:,:,:)
                END IF
C
                IF (NBTKNO.EQ.1) GOTO 77
C
                ITPNMX=2
C
C=======================================================================
C                 ZEROING THE NEUTRON-PROTON DENSITIES
C=======================================================================
C
                CALL ZEDENS(ITPNMX)
C
C=======================================================================
C            FETCHING THE RIGHT WAVE FUNCTIONS TO BE USED TO
C           CALCULATE THE NEUTRON-PROTON DENSITIES AND CURRENTS
C=======================================================================
C
                DO IBASE=1,LDBASE
                   JBASE=IBASE+LDBASE
                   DO ISTATE=1,LDTOTS(0)
                      DO ISPIN=0,NDSPIN
                         WARIGH(IBASE,ISTATE,ISPIN)
     *                  =TARIGH(JBASE,ISTATE,ISPIN)
                      END DO
                   END DO
                END DO
C
                CALL DENSHF(ISIMTX,JSIMTY,ISIMTZ,
     *                      ISIGNY,ISIMPY,ISIQTY,IPAHFB,MREVER,ICHARG,
     *                                           MIN_QP,IPNMIX,ITPNMX,
     *                             ITIREP,NAMEPN,PRINIT,IDEVAR,ITERUN,
     *                      ISYMDE,INIROT,INIINV,INIKAR,ISAWAV,IKERNE,
     *                                                         ITWCEN,1)
C
C=======================================================================
C                 CALCULATING THE NEUTRON TRANSITION DENSITY MATRIX
C                 AND TRANSITION MATRIX ELEMENTS OF THE KINETIC ENE.
C=======================================================================
C
                CALL DENMAC(MREVER,ICHARG,ISIMPY,IPAHFB,WALEFT,WARIGH,1)
C
                CALL SAVDEN(ISIMPY,ITPNMX)
C
C=======================================================================
C      SAVE BIG_PP AND BIG_PM REPRESENTING DNPRHO ON THE BASIS
C       IN BNP_PP AND BNP_PM FOR FURTHER COULOMB CALCULATIONS
C=======================================================================
C
                BNP_PP(:,:,:)=BIG_PP(:,:,:)
                IF (ISIMPY.NE.1) THEN
                    BNP_PM(:,:,:)=BIG_PM(:,:,:)
                END IF
C
  77            CONTINUE
C
                IF (NBTKNO.GT.1) GOTO 810
C
C=======================================================================
C                 CALCULATING TRANSITION MATRIX ELEMENTS OF NEUTRON
C                 MAGNETIC OPERATORS (CALCULATED ONLY FOR LPROJT=0).
C=======================================================================
C                 ATTENTION! ARRAY  "ATKERN" ORGANISED AS "QPKERN" BELOW
C=======================================================================
C                 ATTENTION! TO NOT TO MODIFY THE  UNPROJECTED  MOMENTS,
C                            WHICH HAS ALREADY BEEN CALCULATED IN  ARRAY
C                            "AMUL_N", IN THE CALL BELOW, A DUMMY  ARRAY
C                            "ADUM_N" IS USED (COMMENT 1).
C=======================================================================
C
                CALL MAGMOM(ISIMPY,IROTAT,ICHARG,ADUM_N,AMUT_N,NMARED,
     *                                                           NMAORD)
C
                DO LAMBDA=1,NMARED
                   DO MIU=-LAMBDA,LAMBDA
                      DO NUMORD=0,NMAORD
C
                         IF (MIU.GT.0)
     *                       ATKERN(M,J,N,IND_LM(LAMBDA, MIU),NUMORD)=
     *                       ATKERN(M,J,N,IND_LM(LAMBDA, MIU),NUMORD)+
     *                                   (AMUT_N(LAMBDA, MIU ,NUMORD)
     *                  -UNIT_I*(-1)**MIU*AMUT_N(LAMBDA,-MIU ,NUMORD))
     *                                                           *FACOVT
C
                         IF (MIU.EQ.0)
     *                       ATKERN(M,J,N,IND_LM(LAMBDA, MIU),NUMORD)=
     *                       ATKERN(M,J,N,IND_LM(LAMBDA, MIU),NUMORD)+
     *                                    AMUT_N(LAMBDA, MIU ,NUMORD)
     *                                                           *FACOVT
C
                         IF (MIU.LT.0)
     *                       ATKERN(M,J,N,IND_LM(LAMBDA, MIU),NUMORD)=
     *                       ATKERN(M,J,N,IND_LM(LAMBDA, MIU),NUMORD)+
     *                         ((-1)**MIU*AMUT_N(LAMBDA,-MIU ,NUMORD)
     *                            +UNIT_I*AMUT_N(LAMBDA, MIU ,NUMORD))
     *                                                           *FACOVT
C
                      END DO
                   END DO
                END DO
C
C=======================================================================
C                 CALCULATING TRANSITION MATRIX ELEMENTS OF NEUTRON
C                 SPIN-ASYMM. OPERATORS (CALCULATED ONLY FOR LPROJT=0).
C=======================================================================
C                 ATTENTION! ARRAY  "WTKERN" ORGANISED AS "QPKERN" BELOW
C=======================================================================
C                 ATTENTION! TO NOT TO MODIFY THE  UNPROJECTED  MOMENTS,
C                            WHICH HAVE ALREADY BEEN CALCULATED IN ARRAY
C                            "WMUL_N", IN THE CALL BELOW, A DUMMY  ARRAY
C                            "ADUM_N" IS USED (COMMENT 1).
C=======================================================================
C
                CALL ASMMOM(ISIMPY,IROTAT,ADUM_N,WMUT_N,NASRED,NASORD)
C
                DO LAMBDA=1,NASRED
                   DO MIU=-LAMBDA,LAMBDA
                      DO NUMORD=0,NASORD
C
                         WTKERN(M,J,N,IND_LM(LAMBDA, MIU),NUMORD)=
     *                   WTKERN(M,J,N,IND_LM(LAMBDA, MIU),NUMORD)+
     *                                WMUT_N(LAMBDA, MIU ,NUMORD)*FACOVT
                      END DO
                   END DO
                END DO
C
  810           CONTINUE
C
            END IF
C
C=======================================================================
C           HERE BEGIN CALCULATIONS OF PROTON AND PROTON-NEUTRON
C                      DENSITIES AND OBSERVABLES
C=======================================================================
C
            IF (ICHARG.EQ.1) THEN
C
                ITPNMX=1
C
C=======================================================================
C                 ZEROING THE PROTON DENSITIES
C=======================================================================
C
                CALL ZEDENS(ITPNMX)
C
C=======================================================================
C            FETCHING THE RIGHT WAVE FUNCTIONS TO BE USED TO
C          CALCULATE THE PROTON DENSITIES AND CURRENTS IN DENSHF
C=======================================================================
C
                IF (IPNMIX.EQ.1) THEN
C
                    LSHIFT=0
                ELSE
                    LSHIFT=LDTOTS(0)
C
                END IF
C
                DO IBASE=1,LDBASE
                   JBASE=  LDBASE+IBASE
                   DO ISTATE=1,LDTOTS(1)
                      JSTATE=LSHIFT+ISTATE
                      DO ISPIN=0,NDSPIN
                        WARIGH(IBASE,ISTATE,ISPIN)
     *                 =TARIGH(JBASE,JSTATE,ISPIN)
                      END DO
                   END DO
                END DO
C
C=======================================================================
C                 CALCULATING THE PROTON DENSITIES AND CURRENTS
C=======================================================================
C
                CALL DENSHF(ISIMTX,JSIMTY,ISIMTZ,
     *                      ISIGNY,ISIMPY,ISIQTY,MPAHFB,MREVER,ICHARG,
     *                                           MIN_QP,IPNMIX,ITPNMX,
     *                             ITIREP,NAMEPN,PRINIT,IDEVAR,ITERUN,
     *                      ISYMDE,INIROT,INIINV,INIKAR,ISAWAV,IKERNE,
     *                                                         ITWCEN,1)
C
C=======================================================================
C                 CALCULATING THE PROTON TRANSITION DENSITY MATRIX
C               AND THE TRANSITION MATRIX ELEMENTS OF THE KINETIC ENE.
C=======================================================================
C
                CALL DENMAC(MREVER,ICHARG,ISIMPY,MPAHFB,WALEFT,WARIGH,1)
C
                CALL SAVDEN(ISIMPY,ITPNMX)
C
                CALL EKINET(ENEKIN,DLINSQ,EKEKIN,DKINSQ,1)
C
                IF (MPAHFB.EQ.1) THEN
C
C=======================================================================
C        CALCULATING THE    P R O T O N    P A I R I N G   T E N S O R S
C        THAT CORRESPOND TO RIGHT-LEFT AND  LEFT-RIGHT  MATRIX  ELEMENTS
C=======================================================================
C
                    IF (KETAJ2.EQ.1.OR.KETAT2.EQ.1.OR.
     *                  IGOGPA.GE.1.OR.IREGPA.GE.1.OR.
     *                  ISEPPA.GE.1.OR.ICOUPA.GE.1) THEN
C
                        CALL PAIMAC(ICHARG,ISIMPY,
     *                              WARIGH,WALEFT,IKERNE)
C
                        CALL STO2ND(ISIMPY)
C
                        CALL PAIMAC(ICHARG,ISIMPY,
     *                              WALEFT,WARIGH,IKERNE)
C
                        CALL SAVPAI(ISIMPY,ITPNMX)
C
                    END IF
C
                END IF
C
C=======================================================================
C        CALCULATING THE ANGULAR MOMENTUM TRANSITION KERNELS
C        FOR PROTONS
C=======================================================================
C
                IF (KETAJ2.EQ.1) THEN
C
                    META_R=1
                    BORROT=.TRUE.
C
                    CALL ROTAVR(ISIMPY,ISIGNY,ISIQTY,
     *                 MPAHFB,ICHARG,META_R,IROTAT,MREVER,BORROT,IKERNE,
     *                 DROTSP,EROTSP,PROTSP,TROTSP,AROTLP,PROTLP,PROTKP,
     *                 DKOTSP,EKOTSP,PKOTSP,TKOTSP,AKOTLP,PKOTLP,PKOTKP)
C
                END IF
C
C=======================================================================
C     CALCULATING THE PROTON KINETIC ENERGY AND COULOMB TRANSITION
C          MATRIX ELEMENTS IN A RUN WITHOUT ISOSPIN PROJECTION
C=======================================================================
C
                IF (NBTKNO.EQ.1) THEN
C
                    EKKERN(M,J,N,M_T,ICHARG,N_T)=
     *              EKKERN(M,J,N,M_T,ICHARG,N_T)+EKEKIN
     *                                          *FACOVT
C
C=======================================================================
C            ATTENTION: BETWEEN VERSIONS (2.22N) AND (2.32) THE CALL  TO
C                       "COUMAT" BELOW WAS PERFORMED WITH  AN  UNDEFINED
C                       VALUE OF  "IKERNE"  INSTEAD  OF  IKERNE=1.  THIS
C                       RESULTED (IN "INTCOU") IN CALCULATIONS PERFORMED
C                       FOR REAL PARTS OF TRANSITION MULTIPOLE  MOMENTS.
C                       THIS BUG WAS CORRECTED ON 23/11/2007 IN  VERSION
C                       (2.32A).
C=======================================================================
C
                    IF (ICOUDI.EQ.1.AND.ICOUEX.EQ.1) THEN
C
C  =====================================================================
C  ---> GREEN FUNCTION METHOD IS USED FOR THE DIRECT TERM WHILE SLATER
C       IS APPLIED TO CALCULATE EXCHANGE COULOMB IN THE AMP RUN:
C  =====================================================================
C
                        CALL COUMAT(NUMCOU,BOUCOU,ISIMPY,IKERNE)
C
                        CALL COULOD(ISIMPY,EKECOD)
C
                        CDKERN(M,J,N,1,1,1)=
     *                  CDKERN(M,J,N,1,1,1)+EKECOD
     *                                     *FACOVT
C
                        CALL TRUCHD
C
                        CALL COULOE(EKECOE)
C
                        CXKERN(M,J,N,1,1,1)=
     *                  CXKERN(M,J,N,1,1,1)+EKECOE
     *                                     *FACOVT
C
                    END IF
C
                    IF (ICOUDI.EQ.2.AND.ICOUEX.EQ.2) THEN
C
C  =====================================================================
C  ---> GAUSSIAN EXPANSION METHOD IS USED FOR BOTH THE DIRECT
C       AND EXCHANGE COULOMB IN THE AMP RUN:
C  =====================================================================
C
                        CALL SAVDEN(ISIMPY,1)
C
                        CALL COUENE(ISIMPY,
     *                              ICOTYP,ICOUDI,ICOUEX,
     *                                            IDOTHC,
     *                              EKECOD,EKESCA,EKEVEC)
C
                        EKECOE = EKESCA+EKEVEC
C
                        CDKERN(M,J,N,1,1,1)=
     *                  CDKERN(M,J,N,1,1,1)+EKECOD
     *                                     *FACOVT
                        CXKERN(M,J,N,1,1,1)=
     *                  CXKERN(M,J,N,1,1,1)+EKECOE
     *                                     *FACOVT
C
                    END IF
C
                ELSE
C
                    EKKERN(M,J,N,M_T,L,N_T)=EKKERN(M,J,N,M_T,L,N_T)
     *                                     +EKEKIN
     *                                     *FACOVT
                END IF
C
C=======================================================================
C      SAVE BIG_PP AND BIG_PM REPRESENTING DE_RHO ON THE BASIS
C       IN BPP_PP AND BPP_PM FOR FURTHER COULOMB CALCULATIONS
C=======================================================================
C
                BPP_PP(:,:,:)=BIG_PP(:,:,:)
                IF (ISIMPY.NE.1) THEN
                    BPP_PM(:,:,:)=BIG_PM(:,:,:)
                END IF
C
                IF (NBTKNO.EQ.1) GO TO 78
C
                ITPNMX=3
C
C=======================================================================
C                 ZEROING THE PROTON-NEUTRON DENSITIES
C=======================================================================
C
                CALL ZEDENS(ITPNMX)
C
C=======================================================================
C            FETCHING THE RIGHT WAVE FUNCTIONS TO BE USED TO
C      CALCULATE THE PROTON-NEUTRON DENSITIES AND CURRENTS IN DENSHF
C=======================================================================
C
                IF (IPNMIX.EQ.1) THEN
C
                    LSHIFT=0
                ELSE
                    LSHIFT=LDTOTS(0)
C
                END IF
C
                DO IBASE=1,LDBASE
                   DO ISTATE=1,LDTOTS(1)
                      JSTATE=LSHIFT+ISTATE
                      DO ISPIN=0,NDSPIN
                        WARIGH(IBASE,ISTATE,ISPIN)
     *                 =TARIGH(IBASE,JSTATE,ISPIN)
                      END DO
                   END DO
                END DO
C
C=======================================================================
C         CALCULATING THE PROTON-NEUTRON DENSITIES AND CURRENTS
C=======================================================================
C
                CALL DENSHF(ISIMTX,JSIMTY,ISIMTZ,
     *                      ISIGNY,ISIMPY,ISIQTY,IPAHFB,MREVER,ICHARG,
     *                                           MIN_QP,IPNMIX,ITPNMX,
     *                             ITIREP,NAMEPN,PRINIT,IDEVAR,ITERUN,
     *                      ISYMDE,INIROT,INIINV,INIKAR,ISAWAV,IKERNE,
     *                                                         ITWCEN,1)
C
C=======================================================================
C                 CALCULATING THE PROTON TRANSITION DENSITY MATRIX
C                 AND TRANSITION MATRIX  ELEMENTS  OF  OBSERVABLES
C=======================================================================
C
                CALL DENMAC(MREVER,ICHARG,ISIMPY,IPAHFB,WALEFT,WARIGH,1)
C
                CALL SAVDEN(ISIMPY,ITPNMX)
C
C=======================================================================
C      SAVE BIG_PP AND BIG_PM REPRESENTING DPNRHO ON THE BASIS
C       IN BPN_PP AND BPN_PM FOR FURTHER COULOMB CALCULATIONS
C=======================================================================
C
                BPN_PP(:,:,:)=BIG_PP(:,:,:)
                IF (ISIMPY.NE.1) THEN
                    BPN_PM(:,:,:)=BIG_PM(:,:,:)
                END IF
C
  78            CONTINUE
C
                IF (NBTKNO.GT.1) GOTO 81
C
C=======================================================================
C                 CALCULATING TRANSITION MATRIX ELEMENTS OF PROTON
C                 MULTIPOLE OPERATORS (CALCULATED ONLY FOR LPROJT=0).
C=======================================================================
C                 ATTENTION!
C                 ARRAY  "QPKERN" FOR INDICES (LAMBDA,MIU) CONTAINS  THE
C                 MATRIX ELEMENTS OF THE  COMPLETE  (COMPLEX)  MULTIPOLE
C                 OPERATOR WITHOUT PUTTING ITS REAL AND IMAGINARY  PARTS
C                 INTO THE MAGNETIC COMPONENTS WITH  MIU>=0  AND  MIU<0,
C                 RESPECTIVELY, AS IS THE CASE ELSEWHERE IN THE CODE.
C=======================================================================
C                 ATTENTION! SEE "COMMENT 1" ABOVE.
C=======================================================================
C
                CALL MOMETS(ISIMPY,ISIGNY,ISIQTY,QDUM_P,QMUT_P,
     *                                    COMULT,JMULMO,ISHIFY,1)
C
                DO LAMBDA=0,NMURED
                   DO MIU=-LAMBDA,LAMBDA
C
                      IF (MIU.GT.0)
     *                    QPKERN(M,J,N,IND_LM(LAMBDA,MIU))=
     *                    QPKERN(M,J,N,IND_LM(LAMBDA,MIU))+
     *                                            (QMUT_P(LAMBDA, MIU)
     *                           -UNIT_I*(-1)**MIU*QMUT_P(LAMBDA,-MIU))
     *                                            *FACOVT
C
                      IF (MIU.EQ.0)
     *                    QPKERN(M,J,N,IND_LM(LAMBDA,MIU))=
     *                    QPKERN(M,J,N,IND_LM(LAMBDA,MIU))+
     *                                             QMUT_P(LAMBDA, MIU)
     *                                            *FACOVT
C
                      IF (MIU.LT.0)
     *                    QPKERN(M,J,N,IND_LM(LAMBDA,MIU))=
     *                    QPKERN(M,J,N,IND_LM(LAMBDA,MIU))+
     *                                  ((-1)**MIU*QMUT_P(LAMBDA,-MIU)
     *                                     +UNIT_I*QMUT_P(LAMBDA, MIU))
     *                                            *FACOVT
C
                   END DO
                END DO
C
C=======================================================================
C                 CALCULATING TRANSITION MATRIX ELEMENTS OF PROTON
C                 MAGNETIC OPERATORS AND ADDING THEM TO THOSE FOR
C                 NEUTRONS, WHICH HAVE BEEN CALCULATED ABOVE.
C=======================================================================
C                 ATTENTION! ARRAY  "ATKERN" ORGANISED AS "QPKERN" ABOVE
C=======================================================================
C                 ATTENTION! SEE "COMMENT 1" ABOVE.
C=======================================================================
C
                CALL MAGMOM(ISIMPY,IROTAT,ICHARG,ADUM_P,AMUT_P,NMARED,
     *                                                           NMAORD)
C=======================================================================
C               ADDING THE TWO-BODY-CURRENT CONTRIBUTIONS TO THE  DIPOLE
C               MAGNETIC MOMENTS
C=======================================================================
C               ATTENTION: FOR NOW, THE  TWO-BODY-CURRENT  CONTRIBUTIONS
C                          TO  THE  DIPOLE MAGNETIC  MOMENTS  ARE  ADDED
C                          TO THE STANDARD  ONES  WITHOUT  STORING  THAT
C                          INFORMATION ON THE KERNEL FILE. THE  USER  IS
C                          RESPONSIBLE  FOR  READING  THE  KERNEL   FILE
C                          WITHIN EXACTLY THE SAME CONDITIONS WITH WHICH
C                          IT HAS BEEN CREATED.
C=======================================================================
C
                IF (MAXVAL(MAG2BC).GE.1) THEN
C
                    CALL ADD2BC(ISIMPY)
C
                    AMUT_P(1,-1,0)=AMUT_P(1,-1,0)+A2BCIN(-1)+A2BCSA(-1)
                    AMUT_P(1, 0,0)=AMUT_P(1, 0,0)+A2BCIN( 0)+A2BCSA( 0)
                    AMUT_P(1,+1,0)=AMUT_P(1,+1,0)+A2BCIN(+1)+A2BCSA(+1)
C
                END IF
C
C=======================================================================
C
                DO LAMBDA=1,NMARED
                   DO MIU=-LAMBDA,LAMBDA
                      DO NUMORD=0,NMAORD
C
                         IF (MIU.GT.0)
     *                       ATKERN(M,J,N,IND_LM(LAMBDA, MIU),NUMORD)=
     *                       ATKERN(M,J,N,IND_LM(LAMBDA, MIU),NUMORD)+
     *                                   (AMUT_P(LAMBDA, MIU ,NUMORD)
     *                  -UNIT_I*(-1)**MIU*AMUT_P(LAMBDA,-MIU ,NUMORD))
     *                                                           *FACOVT
C
                         IF (MIU.EQ.0)
     *                       ATKERN(M,J,N,IND_LM(LAMBDA, MIU),NUMORD)=
     *                       ATKERN(M,J,N,IND_LM(LAMBDA, MIU),NUMORD)+
     *                                    AMUT_P(LAMBDA, MIU ,NUMORD)
     *                                                           *FACOVT
C
                         IF (MIU.LT.0)
     *                       ATKERN(M,J,N,IND_LM(LAMBDA, MIU),NUMORD)=
     *                       ATKERN(M,J,N,IND_LM(LAMBDA, MIU),NUMORD)+
     *                         ((-1)**MIU*AMUT_P(LAMBDA,-MIU ,NUMORD)
     *                            +UNIT_I*AMUT_P(LAMBDA, MIU ,NUMORD))
     *                                                           *FACOVT
C
                      END DO
                   END DO
                END DO
C
C=======================================================================
C                 CALCULATING TRANSITION MATRIX ELEMENTS OF PROTON
C                 SPIN-ASYMMETRY OPERATORS AND ADDING THEM TO THOSE FOR
C                 NEUTRONS, WHICH HAVE BEEN CALCULATED ABOVE.
C=======================================================================
C                 ATTENTION! ARRAY  "WTKERN" ORGANISED AS "QPKERN" ABOVE
C=======================================================================
C                 ATTENTION! SEE "COMMENT 1" ABOVE.
C=======================================================================
C
                CALL ASMMOM(ISIMPY,IROTAT,ADUM_P,WMUT_P,NASRED,NASORD)
C
                DO LAMBDA=1,NASRED
                   DO MIU=-LAMBDA,LAMBDA
                      DO NUMORD=0,NASORD
C
                         WTKERN(M,J,N,IND_LM(LAMBDA, MIU),NUMORD)=
     *                   WTKERN(M,J,N,IND_LM(LAMBDA, MIU),NUMORD)+
     *                                WMUT_P(LAMBDA, MIU ,NUMORD)*FACOVT
                      END DO
                   END DO
                END DO
C
C=======================================================================
C                 CALCULATING TRANSITION MATRIX  ELEMENTS  OF  MULTIPOLE
C                 SURFACE OR SCHIFF OPERATORS.
C=======================================================================
C                 ATTENTION! SEE "COMMENT 1" ABOVE.
C=======================================================================
C
                CALL MOMSIF(ISIMPY,ISIGNY,ISIQTY,SDUM_P,SMUT_P,
     *                                           COMULT,JSIFMO)
C
C=======================================================================
C                 ATTENTION! THE PRESENT DEFINITION OF THE SCHIFF MOMETS
C                            IN MOMSCH IS INCOMPATIBLE  WITH  PROJECTION
C                            AND CANNOT BE USED. HOWEVER,  FOR ISCHIF=2,
C                            THE  CODE  EVALUATES  AND  PRINTS   CORRECT
C                            REDUCED MATRIX ELEMENTS OF  SCHIFF  MOMENTS
C                            BASED ON THE SURFACE MOMENTS  OF  PROJECTED
C                            STATES.
C=======================================================================
C                 ATTENTION! SEE "COMMENT 1" ABOVE.
C=======================================================================
C
                IF (ISCHIF.EQ.1)
     *          CALL MOMSCH(SDUM_P,SMUT_P,JSIFMO,QDUM_P,QMUT_P,JMULMO)
C
C=======================================================================
C                 ATTENTION! ARRAY  "SPKERN" ORGANISED AS "QPKERN" ABOVE
C=======================================================================
C
                DO LAMBDA=NSIMIN,NSIRED
                   DO MIU=-LAMBDA,LAMBDA
C
                      IF (MIU.GT.0)
     *                    SPKERN(M,J,N,IND_LM(LAMBDA,MIU))=
     *                    SPKERN(M,J,N,IND_LM(LAMBDA,MIU))+
     *                                            (SMUT_P(LAMBDA, MIU)
     *                           -UNIT_I*(-1)**MIU*SMUT_P(LAMBDA,-MIU))
     *                                            *FACOVT
C
                      IF (MIU.EQ.0)
     *                    SPKERN(M,J,N,IND_LM(LAMBDA,MIU))=
     *                    SPKERN(M,J,N,IND_LM(LAMBDA,MIU))+
     *                                             SMUT_P(LAMBDA, MIU)
     *                                            *FACOVT
C
                      IF (MIU.LT.0)
     *                    SPKERN(M,J,N,IND_LM(LAMBDA,MIU))=
     *                    SPKERN(M,J,N,IND_LM(LAMBDA,MIU))+
     *                                  ((-1)**MIU*SMUT_P(LAMBDA,-MIU)
     *                                     +UNIT_I*SMUT_P(LAMBDA, MIU))
     *                                            *FACOVT
C
                   END DO
                END DO
C
  81            CONTINUE
C
            END IF
C
C=======================================================================
C                 HERE END CALCULATIONS FOR NEUTRONS AND PROTONS
C                     END OF "EXTERNAL" CHARGE LOOP (NO. 3)
C=======================================================================
C
         END DO
C
C=======================================================================
C        CALCULATING  T H E   I S O S P I N  TRANSITION  KERNELS
C=======================================================================
C
         IF (KETAT2.EQ.1) THEN
C
             CALL KEISP2(MREVER,ISIMPY,
     *                   BNN_PP,BNN_PM,BNP_PP,BNP_PM,
     *                   BPP_PP,BPP_PM,BPN_PP,BPN_PM)
C
             TZKERN(M,J,N,M_T,L,N_T)=
     *       TZKERN(M,J,N,M_T,L,N_T)+TKEISO(3)
     *                              *FACOVT
             T2KERN(M,J,N,M_T,L,N_T)=
     *       T2KERN(M,J,N,M_T,L,N_T)+TKEIS2(0)
     *                              *FACOVT
C
         END IF
C
C=======================================================================
C        CALCULATING  THE  ANGULAR MOMENTUM  TRANSITION  KERNELS
C        SUMMING UP NEUTRON AND PROTON CONTRIBUTIONS TO ANGULAR MOMENTA
C=======================================================================
C
         IF (KETAJ2.EQ.1) THEN
C
             CALL TOTANG
C
             BZKERN(M,J,N,M_T,L,N_T)=
     *       BZKERN(M,J,N,M_T,L,N_T)+AKOTLT(3)
     *                              *FACOVT
             B2KERN(M,J,N,M_T,L,N_T)=
     *       B2KERN(M,J,N,M_T,L,N_T)+TKOTST(0)
     *                              *FACOVT
C
         END IF
C
C=======================================================================
C        CALCULATING  T H E   C O U L O M B  TRANSITION  KERNELS
C                     FOR THE I S O S P I N PROJECTION
C=======================================================================
C
         Q00T=C_ZERO
         Q10T=C_ZERO
         Q1PT=C_ZERO
         Q1MT=C_ZERO
C
C=======================================================================
C            NEUTRON AND PROTON <--> NEUTRON AND PROTON
C=======================================================================
C
         BIG_PP(:,:,:)=BNN_PP(:,:,:)
         IF (ISIMPY.NE.1) THEN
             BIG_PM(:,:,:)=BNN_PM(:,:,:)
         END IF
C
         CALL SAVDEN(ISIMPY,0)
C
         BIG_PP(:,:,:)=BPP_PP(:,:,:)
         IF (ISIMPY.NE.1) THEN
             BIG_PM(:,:,:)=BPP_PM(:,:,:)
         END IF
C
         CALL SAVDEN(ISIMPY,1)
C
C=======================================================================
C          CALCULATING  T H E   G O G N Y   E N E R G Y
C=======================================================================
C
         IF (I_GOGA.GE.1.AND.NEWGOG.EQ.0) THEN
C
             CALL GOGENE(I_SLOW,SLOWEV,ISGOGA,I_GOGA,ISIMPY,EKEGOG)
C
             IF (NBTKNO.EQ.1) THEN
C
C                CHECK WHY L=1 IS USED HERE AND IF FACOVT SHOULD BE USED
C
                 SKKERN(M,J,N,1,1,1)=SKKERN(M,J,N,1,1,1)+EKEGOG
     *                                                  *FACOVT
             ELSE
                 SKKERN(M,J,N,M_T,L,N_T)=SKKERN(M,J,N,M_T,L,N_T)+EKEGOG
     *                                                          *FACOVT
C
             END IF
C
         END IF
C
C=======================================================================
C          CALCULATING  T H E   REGULARIZED-SKYRME OR GOGNY  E N E R G Y
C=======================================================================
C          ATTENTION: A SIMULTANEOUS USE OF REGULARIZED  A  N  D   GOGNY
C                     IS NOT PERMITTED IN "PROANG" YET
C=======================================================================
C
         IF (I_REGA.GE.1.AND.NEWGOG.EQ.0.OR.
     *       I_GOGA.GE.1.AND.NEWGOG.EQ.1) THEN
C
             CALL REGENE(I_SLOW,SLOWEV,SLOWPA,
     *                   I_REGA,IREGPA,ISREGA,ISREGP,
     *                   I_GOGA,IGOGPA,ISGOGA,ISGOGP,
     *                   N3LORD,ISIMPY,IN_FIX,IZ_FIX,EKEREG,NEWGOG)
C
             IF (NBTKNO.EQ.1) THEN
C
                 SKKERN(M,J,N,1,1,1)=SKKERN(M,J,N,1,1,1)+EKEREG
     *                                                  *FACOVT
             ELSE
                 SKKERN(M,J,N,M_T,L,N_T)=SKKERN(M,J,N,M_T,L,N_T)+EKEREG
     *                                                          *FACOVT
C
             END IF
C
         END IF
C
C=======================================================================
C          CALCULATING  T H E   SEPARABLE-FORCE   E N E R G Y
C=======================================================================
C
         IF (I_SEPA.GE.1.OR.ISEPPA.GE.1) THEN
C
             IF (IPNMIX.NE.1) THEN
C
              CALL SEPENE(ISSEPA,I_SEPA,SLOWPA,ISSEPP,ISEPPA,
     *                    N3SERD,ISIMPY,IN_FIX,IZ_FIX,EKESEP,
     *                                  I_SLOW,SLOWEV,LDPNMX)
C
             ELSE
C
              CALL SEPMIE(ISSEPA,I_SEPA,SLOWPA,ISSEPP,ISEPPA,
     *                    N3SERD,ISIMPY,IN_FIX,IZ_FIX,EKESEP,
     *                                  I_SLOW,SLOWEV,LDPNMX)
C
             END IF
C
             IF (NBTKNO.EQ.1) THEN
C
                 SKKERN(M,J,N,1,1,1)=SKKERN(M,J,N,1,1,1)+EKESEP
     *                                                  *FACOVT
             ELSE
                 SKKERN(M,J,N,M_T,L,N_T)=SKKERN(M,J,N,M_T,L,N_T)+EKESEP
     *                                                          *FACOVT
C
             END IF
C
         END IF
C
         IF (NBTKNO.GT.1) THEN
C
C=======================================================================
C            NEUTRON AND PROTON <--> NEUTRON-PROTON AND PROTON-NEUTRON
C=======================================================================
C
             BIG_PP(:,:,:)=BNP_PP(:,:,:)
             IF (ISIMPY.NE.1) THEN
                 BIG_PM(:,:,:)=BNP_PM(:,:,:)
             END IF
C
             CALL SAVDEN(ISIMPY,0)
C
             BIG_PP(:,:,:)=BPN_PP(:,:,:)
             IF (ISIMPY.NE.1) THEN
                 BIG_PM(:,:,:)=BPN_PM(:,:,:)
             END IF
C
             CALL SAVDEN(ISIMPY,1)
C
C=======================================================================
C          CALCULATING  T H E   G O G N Y   E N E R G Y
C=======================================================================
C
             IF (I_GOGA.GE.1) THEN
C
C                CALL GOGENP(I_SLOW,SLOWEV,ISGOGA,I_GOGA,ISIMPY,EKEGOG)
C
                 IF (NBTKNO.EQ.1) THEN
C
                     SKKERN(M,J,N,1,1,1)=SKKERN(M,J,N,1,1,1)+EKEGOG
     *                                                      *FACOVT
                 ELSE
                     SKKERN(M,J,N,M_T,L,N_T)=SKKERN(M,J,N,M_T,L,N_T)
     *                                                      +EKEGOG
     *                                                      *FACOVT
C
                 END IF
C
                 STOP ' NP MIXING FOR GOGENP NOT YET IMPLEMENTED'
C
             END IF
C
C=======================================================================
C          CALCULATING  T H E   REGULARIZED-SKYRME   E N E R G Y
C=======================================================================
C
             IF (I_REGA.GE.1) THEN
C
                 IF (N3LORD.GE.0) THEN
C
                  CALL REGENP(I_SLOW,SLOWEV,ISREGA,I_REGA,N3LORD,
     *                                             ISIMPY,EKEREG)
                 ELSE
C                 CALL SKGENP(I_SLOW,SLOWEV,ISREGA,I_REGA,N3LORD,
C    *                                             ISIMPY,EKEREG)
C
                     STOP ' NP MIXING FOR SKGENP NOT YET IMPLEMENTED'
C
                 END IF
C
                 IF (NBTKNO.EQ.1) THEN
C
                     SKKERN(M,J,N,1,1,1)=SKKERN(M,J,N,1,1,1)+EKEREG
     *                                                      *FACOVT
                 ELSE
                     SKKERN(M,J,N,M_T,L,N_T)=SKKERN(M,J,N,M_T,L,N_T)
     *                                                      +EKEREG
     *                                                      *FACOVT
C
                 END IF
C
             END IF
C
C=======================================================================
C          CALCULATING  T H E   SEPARABLE-FORCE   E N E R G Y
C=======================================================================
C
             IF (I_SEPA.GE.1.OR.ISEPPA.GE.1) THEN
C
                 IF (N3SERD.GE.0) THEN
C
                     STOP ' WRONG N3SERD IN PROANG'
C
                 ELSE
C                 CALL SEPENP(I_SLOW,SLOWEV,ISSEPA,I_SEPA,N3SERD,
C    *                                             ISIMPY,EKESEP)
C
                     STOP ' NP MIXING FOR SEPENP NOT YET IMPLEMENTED'
C
                 END IF
C
                 IF (NBTKNO.EQ.1) THEN
C
                     SKKERN(M,J,N,1,1,1)=SKKERN(M,J,N,1,1,1)+EKESEP
     *                                                      *FACOVT
                 ELSE
                     SKKERN(M,J,N,M_T,L,N_T)=SKKERN(M,J,N,M_T,L,N_T)
     *                                                      +EKESEP
     *                                                      *FACOVT
C
                 END IF
C
             END IF
C
         END IF
C
C=======================================================================
C          CALCULATING  T H E   COULOMB   E N E R G Y
C=======================================================================
C=======================================================================
C            MONOPOLE '00' SOURCE <--> MONOPOLE '00' TRACE
C=======================================================================
C
         BIG_PP(:,:,:)=BNN_PP(:,:,:)+BPP_PP(:,:,:)
         IF (ISIMPY.NE.1) THEN
             BIG_PM(:,:,:)=BNN_PM(:,:,:)+BPP_PM(:,:,:)
         END IF
C
         DO IBRA=1,LDBASE
            Q00T=Q00T+(BIG_PP(IBRA,IBRA,0)
     *                +BIG_PP(IBRA,IBRA,1))
         END DO
C
         PNKE00(M,J,N,M_T,L,N_T)=
     *   PNKE00(M,J,N,M_T,L,N_T)+Q00T
     *                          *FACOVT
C
CWS         WRITE(*,7878) M,J,N,M_T,L,N_T,PNKE00(M,J,N,M_T,L,N_T)
CWS 7878    FORMAT(2X,'-->',6I4,2F16.10)
C
         IF (NBTKNO.EQ.1.OR.JCSKIP.NE.0) GOTO 821
C
         CALL SAVDEN(ISIMPY,1)
C
         CALL COUENE(ISIMPY,
     *               ICOTYP,ICOUDI,ICOUEX,
     *                             IDOTHC,
     *               EKECOD,EKESCA,EKEVEC)
C
         EKECOE=EKESCA+EKEVEC
         CD0000=EKECOD
         CX0000=EKECOE
C
 821     CONTINUE
C
C=======================================================================
C             DIPOLE '10' SOURCE   <-->   DIPOLE '10' TRACE
C=======================================================================
C
         BIG_PP(:,:,:)=BNN_PP(:,:,:)-BPP_PP(:,:,:)
         IF (ISIMPY.NE.1) THEN
             BIG_PM(:,:,:)=BNN_PM(:,:,:)-BPP_PM(:,:,:)
         END IF
C
         DO IBRA=1,LDBASE
            Q10T=Q10T+(BIG_PP(IBRA,IBRA,0)
     *                +BIG_PP(IBRA,IBRA,1))
         END DO
C
         PNKE10(M,J,N,M_T,L,N_T)=
     *   PNKE10(M,J,N,M_T,L,N_T)+Q10T
     *                          *FACOVT
C
CWS         WRITE(*,7878) M,J,N,M_T,L,N_T,PNKE10(M,J,N,M_T,L,N_T)
C
         IF (NBTKNO.EQ.1.OR.JCSKIP.NE.0) GOTO 822
C
         CALL SAVDEN(ISIMPY,1)
C
         CALL COUENE(ISIMPY,
     *               ICOTYP,ICOUDI,ICOUEX,
     *                             IDOTHC,
     *               EKECOD,EKESCA,EKEVEC)
C
         EKECOE=EKESCA+EKEVEC
         CD1010=EKECOD
         CX1010=EKECOE
C
 822     CONTINUE
C
C=======================================================================
C           DIPOLE '1+1' SOURCE <--> DIPOLE '1+1' TRACE
C=======================================================================
C
         BIG_PP(:,:,:)=-SQRT(2.D0)*BPN_PP(:,:,:)
         IF (ISIMPY.NE.1) THEN
             BIG_PM(:,:,:)=-SQRT(2.D0)*BPN_PM(:,:,:)
         END IF
C
         DO IBRA=1,LDBASE
            Q1PT=Q1PT+(BIG_PP(IBRA,IBRA,0)
     *                +BIG_PP(IBRA,IBRA,1))
         END DO
C
         PNKE1M(M,J,N,M_T,L,N_T)=
     *   PNKE1M(M,J,N,M_T,L,N_T)-Q1PT
     *                          *FACOVT
C
         IF (NBTKNO.EQ.1.OR.JCSKIP.NE.0) GOTO 823
C
         CALL SAVDEN(ISIMPY,1)
C
         CALL COUENE(ISIMPY,
     *               ICOTYP,ICOUDI,ICOUEX,
     *                             IDOTHC,
     *               EKECOD,EKESCA,EKEVEC)
C
         EKECOE=EKESCA+EKEVEC
         CD1P1P=EKECOD
         CX1P1P=EKECOE
C
 823     CONTINUE
C
C=======================================================================
C          DIPOLE '1-1' SOURCE   <-->   DIPOLE '1-1' TRACE
C=======================================================================
C
         BIG_PP(:,:,:)=SQRT(2.D0)*BNP_PP(:,:,:)
         IF (ISIMPY.NE.1) THEN
             BIG_PM(:,:,:)=SQRT(2.D0)*BNP_PM(:,:,:)
         END IF
C
         DO IBRA=1,LDBASE
            Q1MT=Q1MT+(BIG_PP(IBRA,IBRA,0)
     *                +BIG_PP(IBRA,IBRA,1))
         END DO
C
         PNKE1P(M,J,N,M_T,L,N_T)=
     *   PNKE1P(M,J,N,M_T,L,N_T)-Q1MT
     *                          *FACOVT
C
         IF (NBTKNO.EQ.1.OR.JCSKIP.NE.0) GOTO 82
C
         CALL SAVDEN(ISIMPY,1)
C
         CALL COUENE(ISIMPY,
     *               ICOTYP,ICOUDI,ICOUEX,
     *                             IDOTHC,
     *               EKECOD,EKESCA,EKEVEC)
C
         EKECOE=EKESCA+EKEVEC
         CD1M1M=EKECOD
         CX1M1M=EKECOE
C
C=======================================================================
C      MIXED '[00 + 10]/2' SOURCE  <--> MIXED '[00 + 10]/2' TRACE
C=======================================================================
C
         BIG_PP(:,:,:)=BNN_PP(:,:,:)
         IF (ISIMPY.NE.1) THEN
             BIG_PM(:,:,:)=BNN_PM(:,:,:)
         END IF
C
         CALL SAVDEN(ISIMPY,1)
C
         CALL COUENE(ISIMPY,
     *               ICOTYP,ICOUDI,ICOUEX,
     *                             IDOTHC,
     *               EKECOD,EKESCA,EKEVEC)
C
         EKECOE=EKESCA+EKEVEC
         CD0010=(4.0D0*EKECOD-CD0000-CD1010)/2.0D0
         CX0010=(4.0D0*EKECOE-CX0000-CX1010)/2.0D0
C
C=======================================================================
C        MIXED '00 + 1+1' SOURCE  <--> MIXED '00 + 1+1' TRACE
C=======================================================================
C
         BIG_PP(:,:,:)=BNN_PP(:,:,:)+BPP_PP(:,:,:)
     *                   -SQRT(2.D0)*BPN_PP(:,:,:)
         IF (ISIMPY.NE.1) THEN
             BIG_PM(:,:,:)=BNN_PM(:,:,:)+BPP_PM(:,:,:)
     *                       -SQRT(2.D0)*BPN_PM(:,:,:)
         END IF
C
         CALL SAVDEN(ISIMPY,1)
C
         CALL COUENE(ISIMPY,
     *               ICOTYP,ICOUDI,ICOUEX,
     *                             IDOTHC,
     *               EKECOD,EKESCA,EKEVEC)
C
         EKECOE=EKESCA+EKEVEC
         CD001P=(EKECOD-CD0000-CD1P1P)/2.0D0
         CX001P=(EKECOE-CX0000-CX1P1P)/2.0D0
C
C=======================================================================
C        MIXED '00 + 1-1' SOURCE  <--> MIXED '00 + 1-1' TRACE
C=======================================================================
C
         BIG_PP(:,:,:)=BNN_PP(:,:,:)+BPP_PP(:,:,:)
     *                   +SQRT(2.D0)*BNP_PP(:,:,:)
         IF (ISIMPY.NE.1) THEN
             BIG_PM(:,:,:)=BNN_PM(:,:,:)+BPP_PM(:,:,:)
     *                       +SQRT(2.D0)*BNP_PM(:,:,:)
         END IF
C
         CALL SAVDEN(ISIMPY,1)
C
         CALL COUENE(ISIMPY,
     *               ICOTYP,ICOUDI,ICOUEX,
     *                             IDOTHC,
     *               EKECOD,EKESCA,EKEVEC)
C
         EKECOE=EKESCA+EKEVEC
         CD001M=(EKECOD-CD0000-CD1M1M)/2.0D0
         CX001M=(EKECOE-CX0000-CX1M1M)/2.0D0
C
C=======================================================================
C        MIXED '10 + 1+1' SOURCE  <--> MIXED '10 + 1+1' TRACE
C=======================================================================
C
         BIG_PP(:,:,:)=BNN_PP(:,:,:)-BPP_PP(:,:,:)
     *                   -SQRT(2.D0)*BPN_PP(:,:,:)
         IF (ISIMPY.NE.1) THEN
             BIG_PM(:,:,:)=BNN_PM(:,:,:)-BPP_PM(:,:,:)
     *                       -SQRT(2.D0)*BPN_PM(:,:,:)
         END IF
C
         CALL SAVDEN(ISIMPY,1)
C
         CALL COUENE(ISIMPY,
     *               ICOTYP,ICOUDI,ICOUEX,
     *                             IDOTHC,
     *               EKECOD,EKESCA,EKEVEC)
C
         EKECOE=EKESCA+EKEVEC
         CD101P=(EKECOD-CD1010-CD1P1P)/2.0D0
         CX101P=(EKECOE-CX1010-CX1P1P)/2.0D0
C
C=======================================================================
C        MIXED '10 + 1-1' SOURCE  <--> MIXED '10 + 1-1' TRACE
C=======================================================================
C
         BIG_PP(:,:,:)=BNN_PP(:,:,:)-BPP_PP(:,:,:)
     *                   +SQRT(2.D0)*BNP_PP(:,:,:)
         IF (ISIMPY.NE.1) THEN
             BIG_PM(:,:,:)=BNN_PM(:,:,:)-BPP_PM(:,:,:)
     *                       +SQRT(2.D0)*BNP_PM(:,:,:)
         END IF
C
         CALL SAVDEN(ISIMPY,1)
C
         CALL COUENE(ISIMPY,
     *               ICOTYP,ICOUDI,ICOUEX,
     *                             IDOTHC,
     *               EKECOD,EKESCA,EKEVEC)
C
         EKECOE=EKESCA+EKEVEC
         CD101M=(EKECOD-CD1010-CD1M1M)/2.0D0
         CX101M=(EKECOE-CX1010-CX1M1M)/2.0D0
C
C=======================================================================
C      MIXED '1+1 + 1-1' SOURCE  <--> MIXED '1+1 + 1-1' TRACE
C=======================================================================
C
         BIG_PP(:,:,:)=-SQRT(2.D0)*(BNP_PP(:,:,:)-BPN_PP(:,:,:))
         IF (ISIMPY.NE.1) THEN
             BIG_PM(:,:,:)=-SQRT(2.D0)*(BNP_PM(:,:,:)-BPN_PM(:,:,:))
         END IF
C
         CALL SAVDEN(ISIMPY,1)
C
         CALL COUENE(ISIMPY,
     *               ICOTYP,ICOUDI,ICOUEX,
     *                             IDOTHC,
     *               EKECOD,EKESCA,EKEVEC)
C
         EKECOE=EKESCA+EKEVEC
         CD1P1M=(EKECOD-CD1P1P-CD1M1M)/2.0D0
         CX1P1M=(EKECOE-CX1P1P-CX1M1M)/2.0D0
C
C=======================================================================
C
C    ONE AND TWO BODY (COVARIANT) TENSORS USED HERE ARE DEFINED AS
C    FOLLOWS (STANDARD TEXTBOOK DEFINITION):
C
C                 T_10  =  \tau_z;
C                 T_1+1 =-[\tau_x + i\tau_y]/sqrt2
C                 T_1-1 =+[\tau_x - i\tau_y]/sqrt2
C
C=======================================================================
C    MISSING FACTORS 1/2 AND -1/4 IN FRONT OF DIRECT AND EXCHANGE TERMS
C    ARE EXPLICITLY INCLUDED IN COUENE
C=======================================================================
C
                  CDKERN(M,J,N,M_T,L,N_T)=
     *            CDKERN(M,J,N,M_T,L,N_T)+
     *                 (CD0000+CD1010/3.D0-2.D0*CD1P1M/3.D0)/4.D0
     *                 *FACOVT
                  CDKE10(M,J,N,M_T,L,N_T)=
     *            CDKE10(M,J,N,M_T,L,N_T)-
     *                  CD0010/2.D0
     *                 *FACOVT
                  CDKE1P(M,J,N,M_T,L,N_T)=
     *            CDKE1P(M,J,N,M_T,L,N_T)+
     *                  CD001M/2.D0
     *                 *FACOVT
                  CDKE1M(M,J,N,M_T,L,N_T)=
     *            CDKE1M(M,J,N,M_T,L,N_T)+
     *                  CD001P/2.D0
     *                 *FACOVT
                  CDKE20(M,J,N,M_T,L,N_T)=
     *            CDKE20(M,J,N,M_T,L,N_T)+
     *                 (CD1010+CD1P1M)/6.D0
     *                 *FACOVT
                  CDK21P(M,J,N,M_T,L,N_T)=
     *            CDK21P(M,J,N,M_T,L,N_T)-
     *                  CD101M/SQRT(3.D0)/2.D0
     *                 *FACOVT
                  CDK21M(M,J,N,M_T,L,N_T)=
     *            CDK21M(M,J,N,M_T,L,N_T)-
     *                  CD101P/SQRT(3.D0)/2.D0
     *                 *FACOVT
                  CDK22P(M,J,N,M_T,L,N_T)=
     *            CDK22P(M,J,N,M_T,L,N_T)+
     *                  CD1M1M/SQRT(6.D0)/2.D0
     *                 *FACOVT
                  CDK22M(M,J,N,M_T,L,N_T)=
     *            CDK22M(M,J,N,M_T,L,N_T)+
     *                  CD1P1P/SQRT(6.D0)/2.D0
     *                 *FACOVT
C
                  CXKERN(M,J,N,M_T,L,N_T)=
     *            CXKERN(M,J,N,M_T,L,N_T)+
     *                 (CX0000+CX1010/3.D0-2.D0*CX1P1M/3.D0)/4.D0
     *                 *FACOVT
                  CXKE10(M,J,N,M_T,L,N_T)=
     *            CXKE10(M,J,N,M_T,L,N_T)-
     *                  CX0010/2.D0
     *                 *FACOVT
                  CXKE1P(M,J,N,M_T,L,N_T)=
     *            CXKE1P(M,J,N,M_T,L,N_T)+
     *                  CX001M/2.D0
     *                 *FACOVT
                  CXKE1M(M,J,N,M_T,L,N_T)=
     *            CXKE1M(M,J,N,M_T,L,N_T)+
     *                  CX001P/2.D0
     *                 *FACOVT
                  CXKE20(M,J,N,M_T,L,N_T)=
     *            CXKE20(M,J,N,M_T,L,N_T)+
     *                 (CX1010+CX1P1M)/6.D0
     *                 *FACOVT
                  CXK21P(M,J,N,M_T,L,N_T)=
     *            CXK21P(M,J,N,M_T,L,N_T)-
     *                  CX101M/SQRT(3.D0)/2.D0
     *                 *FACOVT
                  CXK21M(M,J,N,M_T,L,N_T)=
     *            CXK21M(M,J,N,M_T,L,N_T)-
     *                  CX101P/SQRT(3.D0)/2.D0
     *                 *FACOVT
                  CXK22P(M,J,N,M_T,L,N_T)=
     *            CXK22P(M,J,N,M_T,L,N_T)+
     *                  CX1M1M/SQRT(6.D0)/2.D0
     *                 *FACOVT
                  CXK22M(M,J,N,M_T,L,N_T)=
     *            CXK22M(M,J,N,M_T,L,N_T)+
     *                  CX1P1P/SQRT(6.D0)/2.D0
     *                 *FACOVT
C
  82     CONTINUE
C
C=======================================================================
C      CALCULATING  T H E   S K Y R M E   TRANSITION  E N E R G Y
C=======================================================================
C            ATTENTION: IN VERSIONS FROM 2.55Y TO 2.56H, FOR NBTKNO.NE.1
C                       THE CALL TO "TRUTOD" BELOW  WAS  NOT  PERFORMED.
C                       AS  A  RESULT,  FOR   DENSITY-DEPENDENT   FORCES
C                       SIMULTANEOUS PROJECTION ON SPIN AND ISOSPIN  WAS
C                       NOT GIVING CORRECT RESULTS. THIS  BUG  HAS  BEEN
C                       CORRECTED ON 03/01/2013 IN VERSION (2.56I).
C=======================================================================
C            ATTENTION: LDTWCE NOT TRANSFERED INTO PROANG
C=======================================================================
         IF (IDENSU.EQ.1.AND.(NPNKNO.GT.1.OR.NTZKNO.GT.1)) THEN
C
             IF (IGAUGE.EQ.1.AND.IGAUTZ.EQ.1) THEN
                 JDENSU=0
                 CALL TRUTOD(1,1)
                 DENSIU(:,:,:)=DENSIC(:,:,:,1)
             ELSE
                 JDENSU=1
                 CALL TRUTOD(1,1)
             END IF
C
         ELSE
C
             JDENSU=0
             CALL TRUTOD(1,1)
C
         END IF
C
         CALL ESKYRM(ENDUMM,ENDUMM,ENDUMM,ENDUMM,ENDUMM,ENDUMM,ENDUMM,
     *                                                  EKESKY,LDPNMX,
     *                                                         IVIPRI,1)
C
         IF (NBTKNO.EQ.1) THEN
C
             SKKERN(M,J,N,1,1,1)=SKKERN(M,J,N,1,1,1)+EKESKY
     *                                              *FACOVT
C
         ELSE
C
             CALL ESKYNP(ENDUMM,ENDUMM,ENDUMM,ENDUMM,ENDUMM,ENDUMM,
     *                                        ENDUMM,EKESKY,LDPNMX)
C
             SKKERN(M,J,N,M_T,L,N_T)=SKKERN(M,J,N,M_T,L,N_T)+EKESKY
     *                                                      *FACOVT
C
C TER        DO NUCOUT=1,NDCOUT
C TER           TEKERN(M,J,N,M_T,L,N_T,NUCOUT       )=ECCALL(NUCOUT)
C TER           TEKERN(M,J,N,M_T,L,N_T,NUCOUT+NDCOUT)=ECC_NP(NUCOUT)
C TER        END DO
         END IF
C
C=======================================================================
C        CALCULATING THE NEUTRON AND PROTON PAIRING  ENERGIES.
C=======================================================================
C        TO PROPERLY TAKE INTO ACCOUNT THE  DENSITY-DEPENDENT
C        TERM OF THE PAIRING FORCE, CALLS FOR  BOTH  NEUTRONS
C        AND PROTONS MUST BE PERFORMED OUTSIDE  THE  "ICHARG"
C        LOOP.
C=======================================================================
C
         DO ICHARG=0,NDISOS
C
            IF (KPAHFB(ICHARG).EQ.1) THEN
C
                CALL EPAIRI(IN_FIX,IZ_FIX,ICHARG,EKEPAI,1)
C
                EPKERN(M,J,N,M_T,ICHARG,N_T)=
     *          EPKERN(M,J,N,M_T,ICHARG,N_T)+EKEPAI
     *                                      *FACOVT
            END IF
C
         END DO
C
C=======================================================================
C         HERE END THE LOOPS OVER GAUGE ANGLE AND REFLECTION
C=======================================================================
C
         END DO ! END OF LOOP FOR TZ.NUM. PROJECTION (NO INDENTATION)
         END DO ! END OF LOOP FOR PA.NUM. PROJECTION (NO INDENTATION)
         END DO ! END OF LOOP FOR PARITY  PROJECTION (NO INDENTATION)
C
C=======================================================================
C         HERE WE CALCULATE THE  PARTICLE-NUMBER-  AND  PARITY-PROJECTED
C         KERNELS BY DIVIDING THE PROJECTED MATRIX ELEMENTS BY PROJECTED
C         OVERLAPS
C=======================================================================
C
         IF (NBTKNO.EQ.1) THEN
C
             DO LAMBDA=0,NMURED
                DO MIU=-LAMBDA,LAMBDA
C
                   QPKERN(M,J,N,IND_LM(LAMBDA,MIU))=
     *             QPKERN(M,J,N,IND_LM(LAMBDA,MIU))/
     *             OVKERN(M,J,N,M_T,1,N_T)
C
                   ATKERN(M,J,N,IND_LM(LAMBDA,MIU),:)=
     *             ATKERN(M,J,N,IND_LM(LAMBDA,MIU),:)/
     *             OVKERN(M,J,N,M_T,1,N_T)
C
                   SPKERN(M,J,N,IND_LM(LAMBDA,MIU))=
     *             SPKERN(M,J,N,IND_LM(LAMBDA,MIU))/
     *             OVKERN(M,J,N,M_T,1,N_T)
C
                   IF (NASORD.GE.0)
     *             WTKERN(M,J,N,IND_LM(LAMBDA,MIU),:)=
     *             WTKERN(M,J,N,IND_LM(LAMBDA,MIU),:)/
     *             OVKERN(M,J,N,M_T,1,N_T)
C
                END DO
             END DO
C
         END IF
C
         SKKERN(M,J,N,M_T,L,N_T)=SKKERN(M,J,N,M_T,L,N_T)/
     *                           OVKERN(M,J,N,M_T,L,N_T)
C
C=======================================================================
C        ATTENTION: BETWEEN VERSIONS 2.98C  AND  3.01F,  ARRAY  "EPKERN"
C                   BELOW WAS DIVIDED UNDER AN INCORRECT CONDITION. AS A
C                   RESULT, IN CASE OF HYBRID PAIRING VANISHING FOR  ONE
C                   TYPE OF PARTICLES ONLY, PROJECTION COULD  NOT  WORK.
C                   THIS BUG WAS CORRECTED ON 4/12/2020 IN VERSION 3.01G
C=======================================================================
C
         IF (NBTKNO.EQ.1) THEN
C
             EKKERN(M,J,N,M_T,0,N_T)=EKKERN(M,J,N,M_T,0,N_T)/
     *                               OVKERN(M,J,N,M_T,1,N_T)
             EKKERN(M,J,N,M_T,1,N_T)=EKKERN(M,J,N,M_T,1,N_T)/
     *                               OVKERN(M,J,N,M_T,1,N_T)
             EPKERN(M,J,N,M_T,0,N_T)=EPKERN(M,J,N,M_T,0,N_T)/
     *                               OVKERN(M,J,N,M_T,1,N_T)
             EPKERN(M,J,N,M_T,1,N_T)=EPKERN(M,J,N,M_T,1,N_T)/
     *                               OVKERN(M,J,N,M_T,1,N_T)
         ELSE
C
             EKKERN(M,J,N,M_T,L,N_T)=EKKERN(M,J,N,M_T,L,N_T)/
     *                               OVKERN(M,J,N,M_T,L,N_T)
             EPKERN(M,J,N,M_T,L,N_T)=EPKERN(M,J,N,M_T,L,N_T)/
     *                               OVKERN(M,J,N,M_T,L,N_T)
         END IF
C
         CDKERN(M,J,N,M_T,L,N_T)=CDKERN(M,J,N,M_T,L,N_T)/
     *                           OVKERN(M,J,N,M_T,L,N_T)
         CDKE10(M,J,N,M_T,L,N_T)=CDKE10(M,J,N,M_T,L,N_T)/
     *                           OVKERN(M,J,N,M_T,L,N_T)
         CDKE1P(M,J,N,M_T,L,N_T)=CDKE1P(M,J,N,M_T,L,N_T)/
     *                           OVKERN(M,J,N,M_T,L,N_T)
         CDKE1M(M,J,N,M_T,L,N_T)=CDKE1M(M,J,N,M_T,L,N_T)/
     *                           OVKERN(M,J,N,M_T,L,N_T)
         CDKE20(M,J,N,M_T,L,N_T)=CDKE20(M,J,N,M_T,L,N_T)/
     *                           OVKERN(M,J,N,M_T,L,N_T)
         CDK21P(M,J,N,M_T,L,N_T)=CDK21P(M,J,N,M_T,L,N_T)/
     *                           OVKERN(M,J,N,M_T,L,N_T)
         CDK21M(M,J,N,M_T,L,N_T)=CDK21M(M,J,N,M_T,L,N_T)/
     *                           OVKERN(M,J,N,M_T,L,N_T)
         CDK22P(M,J,N,M_T,L,N_T)=CDK22P(M,J,N,M_T,L,N_T)/
     *                           OVKERN(M,J,N,M_T,L,N_T)
         CDK22M(M,J,N,M_T,L,N_T)=CDK22M(M,J,N,M_T,L,N_T)/
     *                           OVKERN(M,J,N,M_T,L,N_T)
         CXKERN(M,J,N,M_T,L,N_T)=CXKERN(M,J,N,M_T,L,N_T)/
     *                           OVKERN(M,J,N,M_T,L,N_T)
         CXKE10(M,J,N,M_T,L,N_T)=CXKE10(M,J,N,M_T,L,N_T)/
     *                           OVKERN(M,J,N,M_T,L,N_T)
         CXKE1P(M,J,N,M_T,L,N_T)=CXKE1P(M,J,N,M_T,L,N_T)/
     *                           OVKERN(M,J,N,M_T,L,N_T)
         CXKE1M(M,J,N,M_T,L,N_T)=CXKE1M(M,J,N,M_T,L,N_T)/
     *                           OVKERN(M,J,N,M_T,L,N_T)
         CXKE20(M,J,N,M_T,L,N_T)=CXKE20(M,J,N,M_T,L,N_T)/
     *                           OVKERN(M,J,N,M_T,L,N_T)
         CXK21P(M,J,N,M_T,L,N_T)=CXK21P(M,J,N,M_T,L,N_T)/
     *                           OVKERN(M,J,N,M_T,L,N_T)
         CXK21M(M,J,N,M_T,L,N_T)=CXK21M(M,J,N,M_T,L,N_T)/
     *                           OVKERN(M,J,N,M_T,L,N_T)
         CXK22P(M,J,N,M_T,L,N_T)=CXK22P(M,J,N,M_T,L,N_T)/
     *                           OVKERN(M,J,N,M_T,L,N_T)
         CXK22M(M,J,N,M_T,L,N_T)=CXK22M(M,J,N,M_T,L,N_T)/
     *                           OVKERN(M,J,N,M_T,L,N_T)
         PNKE00(M,J,N,M_T,L,N_T)=PNKE00(M,J,N,M_T,L,N_T)/
     *                           OVKERN(M,J,N,M_T,L,N_T)
         PNKE10(M,J,N,M_T,L,N_T)=PNKE10(M,J,N,M_T,L,N_T)/
     *                           OVKERN(M,J,N,M_T,L,N_T)
         PNKE1P(M,J,N,M_T,L,N_T)=PNKE1P(M,J,N,M_T,L,N_T)/
     *                           OVKERN(M,J,N,M_T,L,N_T)
         PNKE1M(M,J,N,M_T,L,N_T)=PNKE1M(M,J,N,M_T,L,N_T)/
     *                           OVKERN(M,J,N,M_T,L,N_T)
         TZKERN(M,J,N,M_T,L,N_T)=TZKERN(M,J,N,M_T,L,N_T)/
     *                           OVKERN(M,J,N,M_T,L,N_T)
         T2KERN(M,J,N,M_T,L,N_T)=T2KERN(M,J,N,M_T,L,N_T)/
     *                           OVKERN(M,J,N,M_T,L,N_T)
         BZKERN(M,J,N,M_T,L,N_T)=BZKERN(M,J,N,M_T,L,N_T)/
     *                           OVKERN(M,J,N,M_T,L,N_T)
         B2KERN(M,J,N,M_T,L,N_T)=B2KERN(M,J,N,M_T,L,N_T)/
     *                           OVKERN(M,J,N,M_T,L,N_T)
C
C=======================================================================
C         HERE WE HANDLE THE SAVING OF IPAALL=1 KERNELS ON DISK
C=======================================================================
C         IDENTATION MOVES FORWARD FROM THE 10TH TO 13TH COLUMN
C=======================================================================
C
            IF (ISAKER.EQ.1.AND.IPAALL.EQ.1) THEN
C
C=======================================================================
C         SEARCHING FOR THE NEXT AVAILABLE KERNEL FILE
C=======================================================================
C
                IF (IOPEND.NE.1) THEN
C
                    IF (KFIKER.LE.0) THEN
C
                       IFIBEG=001
                       IFIEND=999
                    ELSE
                       IFIBEG=KFIKER
                       IFIEND=KFIKER
C
                    END IF
C
                    DO IFIKER=IFIBEG,IFIEND
C
                       WRITE(FILACT(01:05),'(''N'',I3,''-'')') IFIKER
C
                       DO NUCHAR=02,04
C
                          IF (FILACT(NUCHAR:NUCHAR).EQ.' ')
     *                        FILACT(NUCHAR:NUCHAR)='0'
C
                       END DO
C
                       OPEN(NFIKER,FILE=FILACT,STATUS='NEW',ERR=8919,
     *                             FORM='UNFORMATTED')
C
                       CLOSE(NFIKER)
C
C=======================================================================
C         THE NEXT AVAILABLE KERNEL FILE FILE FOUND
C=======================================================================
C
                       IOPEND=1
C
                       GO TO 8918
C
 8919                  CONTINUE
C
                    END DO
C
C                   STOP' ALL KERNEL FILES N001-N999 ARE ALREADY IN USE'
C
                    FILACT(02:04)='000'
C
                    OPEN(NFIKER,FILE=FILACT,STATUS='NEW',
     *                          FORM='UNFORMATTED')
C
                    CLOSE(NFIKER)
C
 8918               CONTINUE
C
                END IF
C
C=======================================================================
C         OPENING THE FILE
C=======================================================================
C
                OPEN(NFIKER,FILE=FILACT,STATUS='OLD',
     *                      POSITION='APPEND',FORM='UNFORMATTED')
C
C=======================================================================
C         WRITING THE FILE
C=======================================================================
C
                WRITE(NFIKER) I,K,IVERKE
C
                WRITE(NFIKER) IPAALL,J,L
C
                WRITE(NFIKER) FILACT
C
                WRITE(NFIKER) NUBKNO,NBTKNO,NMURED,NMARED,NSIRED
C
                   WRITE(NFIKER) J,
     *                OVKERN(M,J,N,1,0,1),OVKERN(M,J,N,1,L,1),
     *                EKKERN(M,J,N,1,0,1),EKKERN(M,J,N,1,L,1),
     *                CDKERN(M,J,N,1,L,1),
     *                CXKERN(M,J,N,1,L,1),
     *                SKKERN(M,J,N,1,L,1),
     *               ((QPKERN(M,J,N,IND_LM(LAMBDA,MIU)),
     *                                            MIU=-LAMBDA,LAMBDA),
     *                                               LAMBDA=0,NMURED),
     *               ((ATKERN(M,J,N,IND_LM(LAMBDA,MIU),0),
     *                                            MIU=-LAMBDA,LAMBDA),
     *                                               LAMBDA=1,NMARED),
     *               ((SPKERN(M,J,N,IND_LM(LAMBDA,MIU)),
     *                                            MIU=-LAMBDA,LAMBDA),
     *                                          LAMBDA=NSIMIN,NSIRED)
                   WRITE(NFIKER)
     *                CDKE10(M,J,N,1,L,1),
     *                CDKE1P(M,J,N,1,L,1),
     *                CXKE10(M,J,N,1,L,1),
     *                CXKE1P(M,J,N,1,L,1),
     *                CDKE1M(M,J,N,1,L,1),
     *                CDKE20(M,J,N,1,L,1),
     *                CDK21P(M,J,N,1,L,1),
     *                CDK21M(M,J,N,1,L,1),
     *                CDK22P(M,J,N,1,L,1),
     *                CDK22M(M,J,N,1,L,1),
     *                CXKE1M(M,J,N,1,L,1),
     *                CXKE20(M,J,N,1,L,1),
     *                CXK21P(M,J,N,1,L,1),
     *                CXK21M(M,J,N,1,L,1),
     *                CXK22P(M,J,N,1,L,1),
     *                CXK22M(M,J,N,1,L,1),
     *                PNKE00(M,J,N,1,L,1),
     *                PNKE10(M,J,N,1,L,1),
     *                PNKE1P(M,J,N,1,L,1),
     *                PNKE1M(M,J,N,1,L,1)
C
                   WRITE(NFIKER)
     *                TZKERN(M,J,N,1,L,1),
     *                T2KERN(M,J,N,1,L,1)
C
                   WRITE(NFIKER)
     *                EPKERN(M,J,N,0,L,1),
     *                EPKERN(M,J,N,1,L,1)
C
                   WRITE(NFIKER)
     *                BZKERN(M,J,N,1,L,1),
     *                B2KERN(M,J,N,1,L,1)
C
                CLOSE(NFIKER)
C
            END IF
C
C=======================================================================
C         HERE WE HANDLE THE SAVING OF ISAKER=2 KERNELS ON DISK
C=======================================================================
C
            IF (ISAKER.EQ.2) THEN
C
C=======================================================================
C         SEARCHING FOR THE NEXT AVAILABLE KERNEL FILE
C=======================================================================
C
                IF (IOPEND.NE.1) THEN
C
                    IFIBEG=0
                    IFIEND=9
C
                    DO IFIKER=IFIBEG,IFIEND
C
                       IF (NAMKER.EQ.1) THEN
C
                           WRITE(FILACT(07:07),'(I1)') IFIKER
                           OPEN(NFIKER,FILE=FILACT,STATUS='NEW',
     *                             ERR=3229,FORM='UNFORMATTED')
                       ELSE
                           WRITE(FILAC2(07:07),'(I1)') IFIKER
                           OPEN(NFIKER,FILE=FILAC2,STATUS='NEW',
     *                             ERR=3229,FORM='UNFORMATTED')
                       END IF
C
                       CLOSE(NFIKER)
C
C=======================================================================
C         THE NEXT AVAILABLE KERNEL FILE FILE FOUND
C=======================================================================
C
                       IOPEND=1
C
                       GO TO 3228
C
 3229                  CONTINUE
C
                    END DO
C
                    STOP' ALL KERNEL FILES 0-9 ARE ALREADY IN USE'
C
 3228               CONTINUE
C
                END IF
C
C=======================================================================
C         OPENING THE FILE
C=======================================================================
C
                IF (NAMKER.EQ.1) THEN
C
                    WRITE(FILACT(07:07),'(I1)') IFIKER
                    OPEN(NFIKER,FILE=FILACT,STATUS='OLD',
     *               POSITION='APPEND',FORM='UNFORMATTED')
                ELSE
                    WRITE(FILAC2(07:07),'(I1)') IFIKER
                    OPEN(NFIKER,FILE=FILAC2,STATUS='OLD',
     *               POSITION='APPEND',FORM='UNFORMATTED')
C
                END IF
C
C=======================================================================
C         WRITING THE FILE
C=======================================================================
C
                WRITE(NFIKER) I,K,IVERK2
C
                WRITE(NFIKER) NUAKNO,NUBKNO,NATKNO,NBTKNO
C
                WRITE(NFIKER) IPAALL,J,L
C
                WRITE(NFIKER) IPAK3D,I_T,K_T
C
                WRITE(NFIKER) NPNKNO,IN_FIX+IZ_FIX,NPAKNO,IPAPRO
C
                WRITE(NFIKER) KPROJE,ISOSTZ
C
                WRITE(NFIKER) NTZKNO,IN_FIX-IZ_FIX
C
                IF (NAMKER.EQ.1) THEN
C
                    WRITE(NFIKER) FILACT
                ELSE
                    WRITE(NFIKER) FILAC2
C
                END IF
C
                WRITE(NFIKER) NMURED,NMARED,NSIRED
C
                WRITE(NFIKER)
     *                OVKERN(M,J,N,M_T,0,N_T),OVKERN(M,J,N,M_T,L,N_T),
     *                EKKERN(M,J,N,M_T,0,N_T),EKKERN(M,J,N,M_T,L,N_T),
     *                CDKERN(M,J,N,M_T,L,N_T),
     *                CXKERN(M,J,N,M_T,L,N_T),
     *                SKKERN(M,J,N,M_T,L,N_T),
C TER*               (TEKERN(M,J,N,M_T,L,N_T,NUCOUT),NUCOUT=1,2*NDCOUT),
     *               ((QPKERN(M,J,N,IND_LM(LAMBDA,MIU)),
     *                                            MIU=-LAMBDA,LAMBDA),
     *                                               LAMBDA=0,NMURED),
     *               ((ATKERN(M,J,N,IND_LM(LAMBDA,MIU),0),
     *                                            MIU=-LAMBDA,LAMBDA),
     *                                               LAMBDA=1,NMARED),
     *               ((SPKERN(M,J,N,IND_LM(LAMBDA,MIU)),
     *                                            MIU=-LAMBDA,LAMBDA),
     *                                          LAMBDA=NSIMIN,NSIRED)
C
                WRITE(NFIKER) GYRORP,GYRSPN,GYRSPP,IGYROS
C
                WRITE(NFIKER) GIN2BC,GSA2BC,IGY2BC
C
                WRITE(NFIKER) NMAORD
C
                WRITE(NFIKER)
     *              (((ATKERN(M,J,N,IND_LM(LAMBDA,MIU),NUMORD),
     *                                            MIU=-LAMBDA,LAMBDA),
     *                                               LAMBDA=1,NMARED),
     *                                               NUMORD=1,NMAORD)
C
                WRITE(NFIKER) NASRED,NASORD
C
                IF (NASORD.GE.0) WRITE(NFIKER)
     *              (((WTKERN(M,J,N,IND_LM(LAMBDA,MIU),NUMORD),
     *                                            MIU=-LAMBDA,LAMBDA),
     *                                               LAMBDA=1,NASRED),
     *                                               NUMORD=0,NASORD)
C
                WRITE(NFIKER)
     *             CDKE10(M,J,N,M_T,L,N_T),
     *             CDKE1P(M,J,N,M_T,L,N_T),
     *             CXKE10(M,J,N,M_T,L,N_T),
     *             CXKE1P(M,J,N,M_T,L,N_T),
     *             CDKE1M(M,J,N,M_T,L,N_T),
     *             CDKE20(M,J,N,M_T,L,N_T),
     *             CDK21P(M,J,N,M_T,L,N_T),
     *             CDK21M(M,J,N,M_T,L,N_T),
     *             CDK22P(M,J,N,M_T,L,N_T),
     *             CDK22M(M,J,N,M_T,L,N_T),
     *             CXKE1M(M,J,N,M_T,L,N_T),
     *             CXKE20(M,J,N,M_T,L,N_T),
     *             CXK21P(M,J,N,M_T,L,N_T),
     *             CXK21M(M,J,N,M_T,L,N_T),
     *             CXK22P(M,J,N,M_T,L,N_T),
     *             CXK22M(M,J,N,M_T,L,N_T),
     *             PNKE00(M,J,N,M_T,L,N_T),
     *             PNKE10(M,J,N,M_T,L,N_T),
     *             PNKE1P(M,J,N,M_T,L,N_T),
     *             PNKE1M(M,J,N,M_T,L,N_T)
C
                WRITE(NFIKER)
     *             TZKERN(M,J,N,M_T,L,N_T),
     *             T2KERN(M,J,N,M_T,L,N_T)
C
                WRITE(NFIKER)
     *             EPKERN(M,J,N,M_T,0,N_T),
     *             EPKERN(M,J,N,M_T,L,N_T)
C
                WRITE(NFIKER)
     *             BZKERN(M,J,N,M_T,L,N_T),
     *             B2KERN(M,J,N,M_T,L,N_T)
C
                CLOSE(NFIKER)
C
            END IF
C
            ISPOIN(I,J,K,I_T,L,K_T)=ISPOIN(I,J,K,I_T,L,K_T)+1
C
C=======================================================================
C           INDENTATION MOVES FORWARD FROM THE 13TH TO THE CORRECT
C           25TH COLUMN
C=======================================================================
C
 89                     CONTINUE
C
C=======================================================================
C         HERE END THE LOOPS (NO. 1) OVER THE ISOSPIN ALPHA_T AND BETA_T
C         ISOSPIN GAUSS KNOTS.
C=======================================================================
C
                     END DO
                  END DO
C
                  ISAALL(I,J,K,L)=ISAALL(I,J,K,L)+1
C
 899              CONTINUE
C
C=======================================================================
C         HERE ENDS THE LOOP (NO. 1) OVER THE BETA_T ISOSPIN GAUSS KNOTS
C=======================================================================
C
               END DO
C
C=======================================================================
C         HERE ENDS THE LOOP (NO. 1) OVER THE BETA GAUSS KNOTS
C=======================================================================
C
            END DO
C
            ISALGA(I,K)=ISALGA(I,K)+1
C
C=======================================================================
C         HERE WE HANDLE THE SAVING OF IPAALL=0 KERNELS ON DISK
C=======================================================================
C
            IF (ISAKER.EQ.1.AND.IPAALL.NE.1) THEN
C
C=======================================================================
C         SEARCHING FOR THE NEXT AVAILABLE KERNEL FILE
C=======================================================================
C
                IF (IOPEND.NE.1) THEN
C
                    IF (KFIKER.LE.0) THEN
C
                       IFIBEG=001
                       IFIEND=999
                    ELSE
                       IFIBEG=KFIKER
                       IFIEND=KFIKER
C
                    END IF
C
                    DO IFIKER=IFIBEG,IFIEND
C
                       WRITE(FILACT(01:05),'(''N'',I3,''-'')') IFIKER
C
                       DO NUCHAR=02,04
C
                          IF (FILACT(NUCHAR:NUCHAR).EQ.' ')
     *                        FILACT(NUCHAR:NUCHAR)='0'
C
                       END DO
C
                       OPEN(NFIKER,FILE=FILACT,STATUS='NEW',ERR=19,
     *                             FORM='UNFORMATTED')
C
                       CLOSE(NFIKER)
C
C=======================================================================
C         THE NEXT AVAILABLE KERNEL FILE FOUND
C=======================================================================
C
                       IOPEND=1
C
                       GO TO 18
C
   19                  CONTINUE
C
                    END DO
C
C                   STOP' ALL KERNEL FILES N001-N999 ARE ALREADY IN USE'
C
                    FILACT(02:04)='000'
C
                    OPEN(NFIKER,FILE=FILACT,STATUS='NEW',
     *                          FORM='UNFORMATTED')
C
                    CLOSE(NFIKER)
C
   18               CONTINUE
C
                END IF
C
C=======================================================================
C         OPENING THE FILE
C=======================================================================
C
                OPEN(NFIKER,FILE=FILACT,STATUS='OLD',
     *                      POSITION='APPEND',FORM='UNFORMATTED')
C
C=======================================================================
C         WRITING THE FILE
C=======================================================================
C
                WRITE(NFIKER) I,K,IVERKE
C
                WRITE(NFIKER) IPAALL,0,0
C
                WRITE(NFIKER) FILACT
C
                WRITE(NFIKER) NUBKNO,NBTKNO,NMURED,NMARED,NSIRED
C
                DO J=1,NUBKNO
C
                   WRITE(NFIKER) J,
     *                (OVKERN(M,J,N,1,L,1),L=0,NBTKNO),
     *                (EKKERN(M,J,N,1,L,1),L=0,NBTKNO),
     *                (CDKERN(M,J,N,1,L,1),L=1,NBTKNO),
     *                (CXKERN(M,J,N,1,L,1),L=1,NBTKNO),
     *                (SKKERN(M,J,N,1,L,1),L=1,NBTKNO),
     *               ((QPKERN(M,J,N,IND_LM(LAMBDA,MIU)),
     *                                            MIU=-LAMBDA,LAMBDA),
     *                                               LAMBDA=0,NMURED),
     *               ((ATKERN(M,J,N,IND_LM(LAMBDA,MIU),0),
     *                                            MIU=-LAMBDA,LAMBDA),
     *                                               LAMBDA=1,NMARED),
     *               ((SPKERN(M,J,N,IND_LM(LAMBDA,MIU)),
     *                                            MIU=-LAMBDA,LAMBDA),
     *                                          LAMBDA=NSIMIN,NSIRED)
C
                   WRITE(NFIKER)
     *                (CDKE10(M,J,N,1,L,1),L=1,NBTKNO),
     *                (CDKE1P(M,J,N,1,L,1),L=1,NBTKNO),
     *                (CXKE10(M,J,N,1,L,1),L=1,NBTKNO),
     *                (CXKE1P(M,J,N,1,L,1),L=1,NBTKNO),
     *                (CDKE1M(M,J,N,1,L,1),L=1,NBTKNO),
     *                (CDKE20(M,J,N,1,L,1),L=1,NBTKNO),
     *                (CDK21P(M,J,N,1,L,1),L=1,NBTKNO),
     *                (CDK21M(M,J,N,1,L,1),L=1,NBTKNO),
     *                (CDK22P(M,J,N,1,L,1),L=1,NBTKNO),
     *                (CDK22M(M,J,N,1,L,1),L=1,NBTKNO),
     *                (CXKE1M(M,J,N,1,L,1),L=1,NBTKNO),
     *                (CXKE20(M,J,N,1,L,1),L=1,NBTKNO),
     *                (CXK21P(M,J,N,1,L,1),L=1,NBTKNO),
     *                (CXK21M(M,J,N,1,L,1),L=1,NBTKNO),
     *                (CXK22P(M,J,N,1,L,1),L=1,NBTKNO),
     *                (CXK22M(M,J,N,1,L,1),L=1,NBTKNO),
     *                (PNKE00(M,J,N,1,L,1),L=1,NBTKNO),
     *                (PNKE10(M,J,N,1,L,1),L=1,NBTKNO),
     *                (PNKE1P(M,J,N,1,L,1),L=1,NBTKNO),
     *                (PNKE1M(M,J,N,1,L,1),L=1,NBTKNO)
C
                   WRITE(NFIKER)
     *                (TZKERN(M,J,N,1,L,1),L=1,NBTKNO),
     *                (T2KERN(M,J,N,1,L,1),L=1,NBTKNO)
C
                   WRITE(NFIKER)
     *                (EPKERN(M,J,N,1,L,1),L=0,NBTKNO)
C
                   WRITE(NFIKER)
     *                (BZKERN(M,J,N,1,L,1),L=1,NBTKNO),
     *                (B2KERN(M,J,N,1,L,1),L=1,NBTKNO)
C
                END DO
C
                CLOSE(NFIKER)
C
            END IF
C
C=======================================================================
C         HERE END THE LOOPS (NO.1) OVER THE ALPHA AND GAMMA GAUSS KNOTS
C=======================================================================
C
    9       CONTINUE
C
         END DO
      END DO
C
      IF (ISAKER.EQ.1.AND.IPAALL.NE.1) THEN
C
          IF (IOPEND.EQ.1) THEN
C
              WRITE(NFIPRI,'(79(1H*),/,1H*,77X,1H*,/,
     *        1H*,1X,'' THE GCM KERNELS IN FUNCTION OF THE EULER'',
     *               '' ANGLES ARE SAVED; FILE (FILKER):'',   2X,1H*,/,
     *        1H*,2X,A68,                                     7X,1H*,/,
     *                                                   1H*,77X,1H*,/,
     *                                         79(1H*),/,1H*,77X,1H*,/,
     *              1H*,2X,A14,     I4,'' <= I <='',   I3,
     *                    ''  AND'',I4,'' <= K <='',   I3,
     *                    ''; TOT'',I6,'' PNTS ARE SAVD'',    1X,1H*,/,
     *                                                   1H*,77X,1H*,/,
     *                                                        79(1H*))')
     *
     *            FILKER,
     *            FILACT(01:14),NUABEG,NUAEND,NUGBEG,NUGEND,NUALGA
C
          ELSE
C
              IF (ICOMIX.EQ.0) WRITE(NFIPRI,'(79(1H*))')
C
          END IF
C
      END IF
C
C=======================================================================
C
      IPRKER=0
C
      IF (IPRKER.EQ.1) THEN
C
          AKKMAX=0.0D0
          JKKMAX=0
          IKKMAX=0
          KKKMAX=0
          LKKMAX=0
C
CJD? DOROBIC PETLE IZOSPINOWE DO DRUKOWANIA
C
          DO I=1,NUAKNO
             DO J=1,NUBKNO
                DO K=1,NUAKNO
C
                   IF (NBTKNO.EQ.1) THEN
C
                       WRITE(NFIPRI,1001) I,J,K,1,ISALGA(I,K),
     *                                          ISAALL(I,J,K,1),
     *              'ON',OVKERN(I,J,K,1,0,1),'OP',OVKERN(I,J,K,1,1,1),
     *              'KN',EKKERN(I,J,K,1,0,1),'KP',EKKERN(I,J,K,1,1,1),
     *              'CD',CDKERN(I,J,K,1,1,1),
C    *              'CD',CDKERN(I,J,K,1,1,1),'CX',CXKERN(I,J,K,1,1,1),
     *              'SK',SKKERN(I,J,K,1,1,1)
 1001                  FORMAT(6I3,6(1X,A2,1PE9.2,1PE9.2))
C
                   ELSE
C
                       DO L=1,NBTKNO
C
                          WRITE(NFIPRI,2001) I,J,K,L,ISALGA(I,K),
     *                                               ISAALL(I,J,K,L),
     *                   'OV',OVKERN(I,J,K,1,L,1),
     *                   'EN',EKKERN(I,J,K,1,L,1)+CDKERN(I,J,K,1,L,1)
     *                       +CXKERN(I,J,K,1,L,1)+SKKERN(I,J,K,1,L,1),
     *                   'KI',EKKERN(I,J,K,1,L,1),
     *                   'CD',CDKERN(I,J,K,1,L,1),
     *                   'CX',CXKERN(I,J,K,1,L,1),
     *                   'SK',SKKERN(I,J,K,1,L,1)
 2001                     FORMAT(6I3,6(1X,A2,1PE9.2,1PE9.2))
C
                          IF (AKKMAX.LT.
     *                ABS(EKKERN(I,J,K,1,L,1)+CDKERN(I,J,K,1,L,1)
     *                   +CXKERN(I,J,K,1,L,1)+SKKERN(I,J,K,1,L,1))) THEN
C
                     AKKMAX=ABS(EKKERN(I,J,K,1,L,1)+CDKERN(I,J,K,1,L,1)
     *                         +CXKERN(I,J,K,1,L,1)+SKKERN(I,J,K,1,L,1))
                             JKKMAX=J
                             IKKMAX=I
                             KKKMAX=K
                             LKKMAX=L
C
                          END IF
C
                       END DO
C
                   END IF
C
                END DO
             END DO
          END DO
C
          IF (NBTKNO.NE.1) THEN
C
              WRITE(NFIPRI,'(/,1X,4I3,1PE13.6,/)')
     *              IKKMAX,JKKMAX,KKKMAX,LKKMAX,AKKMAX
C
          END IF
C
      END IF
C
C=======================================================================
C         ZEROING VARIABLES THAT ARE USED FOR CALCULATION OF SUM RULES
C=======================================================================
C
      RKER_T=C_ZERO
      RSKY_T=C_ZERO
      RKIN_T=C_ZERO
      RPAI_T=C_ZERO
      RCOU_D=C_ZERO
      RCOU_X=C_ZERO
      RPARTN=C_ZERO
      RISOSP=C_ZERO
      RTZISO=C_ZERO
      RT2ISO=C_ZERO
      RBZROT=C_ZERO
      RB2ROT=C_ZERO
C
      DO LAMBDA=0,NDMULR
         DO MIU=-LAMBDA,LAMBDA
C
            RMUL_P(LAMBDA,MIU)=C_ZERO
            RMAG_T(LAMBDA,MIU)=C_ZERO
            RSIF_P(LAMBDA,MIU)=C_ZERO
            RASM_T(LAMBDA,MIU)=C_ZERO
C
         END DO
      END DO
C
C=======================================================================
C         THIS JUMP SUSPENDS INTEGRATION OF KERNELS FOR A PARALLEL RUN
C=======================================================================
C
      IF (IPAKER.EQ.1) GO TO 10
C
C=======================================================================
C                          KERNELS ARE LOADED
C                   HERE STARTS THE "INTEGRATION" BLOCK
C=======================================================================
C
C=======================================================================
C         ALLOCATING ARRAYS FOR INTEGRATION OVER THE SPIN EULER ANGLES
C=======================================================================
C         ATTENTION: BETWEEN VERSIONS 2.96D AND 2.990, THE ARRAYS  BELOW
C                    WERE  ALLOCATED   WITH  INVERTED   DIMENSIONS   OF
C                       "NUISOM,0:NUPROM" INSTEAD OF "NUPROM,0:NUISOM"
C                    THIS BUG, WHICH  FOR  THE  ISOSPIN  PROJECTION  WAS
C                    CAUSING THE SEGMENTATION-FAULT ERROR, WAS CORRECTED
C                    ON 28/09/2020 IN VERSION 2.991.
C=======================================================================
C
      ALLOCATE (TKE_TT(NUPROM,0:NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('TKE_TT','PROANG')
      ALLOCATE (TSK_TT(NUPROM,0:NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('TSK_TT','PROANG')
      ALLOCATE (TKI_NT(NUPROM,0:NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('TKI_NT','PROANG')
      ALLOCATE (TKI_PT(NUPROM,0:NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('TKI_PT','PROANG')
      ALLOCATE (TCO_DT(NUPROM,0:NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('TCO_DT','PROANG')
      ALLOCATE (TCO_XT(NUPROM,0:NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('TCO_XT','PROANG')
      ALLOCATE (TPA_NT(NUPROM,0:NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('TPA_NT','PROANG')
      ALLOCATE (TPA_PT(NUPROM,0:NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('TPA_PT','PROANG')
      ALLOCATE (TPN_00(NUPROM,0:NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('TPN_00','PROANG')
      ALLOCATE (TPN_10(NUPROM,0:NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('TPN_10','PROANG')
      ALLOCATE (TPN_1P(NUPROM,0:NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('TPN_1P','PROANG')
      ALLOCATE (TPN_1M(NUPROM,0:NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('TPN_1M','PROANG')
      ALLOCATE (TTZ_IS(NUPROM,0:NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('TTZ_IS','PROANG')
      ALLOCATE (TT2_IS(NUPROM,0:NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('TT2_IS','PROANG')
      ALLOCATE (TBZ_RO(NUPROM,0:NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('TBZ_RO','PROANG')
      ALLOCATE (TB2_RO(NUPROM,0:NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('TB2_RO','PROANG')
      ALLOCATE (TC1_D0(NUPROM,0:NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('TC1_D0','PROANG')
      ALLOCATE (TC1_DP(NUPROM,0:NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('TC1_DP','PROANG')
      ALLOCATE (TC1_DM(NUPROM,0:NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('TC1_DM','PROANG')
      ALLOCATE (TC2_D0(NUPROM,0:NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('TC2_D0','PROANG')
      ALLOCATE (TC21DP(NUPROM,0:NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('TC21DP','PROANG')
      ALLOCATE (TC21DM(NUPROM,0:NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('TC21DM','PROANG')
      ALLOCATE (TC22DP(NUPROM,0:NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('TC22DP','PROANG')
      ALLOCATE (TC22DM(NUPROM,0:NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('TC22DM','PROANG')
      ALLOCATE (TC1_X0(NUPROM,0:NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('TC1_X0','PROANG')
      ALLOCATE (TC1_XP(NUPROM,0:NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('TC1_XP','PROANG')
      ALLOCATE (TC1_XM(NUPROM,0:NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('TC1_XM','PROANG')
      ALLOCATE (TC2_X0(NUPROM,0:NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('TC2_X0','PROANG')
      ALLOCATE (TC21XP(NUPROM,0:NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('TC21XP','PROANG')
      ALLOCATE (TC21XM(NUPROM,0:NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('TC21XM','PROANG')
      ALLOCATE (TC22XP(NUPROM,0:NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('TC22XP','PROANG')
      ALLOCATE (TC22XM(NUPROM,0:NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('TC22XM','PROANG')
C
C=======================================================================
C         ZEROING ARRAYS FOR INTEGRATION OVER THE SPIN EULER ANGLES
C=======================================================================
C
C TER TTE_TT=C_ZERO
      TKE_TT(:,:)=C_ZERO
      TSK_TT(:,:)=C_ZERO
      TKI_NT(:,:)=C_ZERO
      TKI_PT(:,:)=C_ZERO
      TCO_DT(:,:)=C_ZERO
      TCO_XT(:,:)=C_ZERO
      TPA_NT(:,:)=C_ZERO
      TPA_PT(:,:)=C_ZERO
      TPN_00(:,:)=C_ZERO
      TPN_10(:,:)=C_ZERO
      TPN_1P(:,:)=C_ZERO
      TPN_1M(:,:)=C_ZERO
      TTZ_IS(:,:)=C_ZERO
      TT2_IS(:,:)=C_ZERO
      TBZ_RO(:,:)=C_ZERO
      TB2_RO(:,:)=C_ZERO
      TC1_D0(:,:)=C_ZERO
      TC1_DP(:,:)=C_ZERO
      TC1_DM(:,:)=C_ZERO
      TC2_D0(:,:)=C_ZERO
      TC21DP(:,:)=C_ZERO
      TC21DM(:,:)=C_ZERO
      TC22DP(:,:)=C_ZERO
      TC22DM(:,:)=C_ZERO
      TC1_X0(:,:)=C_ZERO
      TC1_XP(:,:)=C_ZERO
      TC1_XM(:,:)=C_ZERO
      TC2_X0(:,:)=C_ZERO
      TC21XP(:,:)=C_ZERO
      TC21XM(:,:)=C_ZERO
      TC22XP(:,:)=C_ZERO
      TC22XM(:,:)=C_ZERO
C
      OPROJE=C_ZERO
      EPROJE=C_ZERO
C
C=======================================================================
C         ALLOCATING ARRAYS OF MULTIPOLE, MAGNETIC, AND SPIN-ASY MOMENTS
C=======================================================================
C
      ALLOCATE (TMUL_P(NDMULM,NUPREM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('TMUL_P','PROANG')
      ALLOCATE (TMAG_T(NDMULM,NUPREM,0:NMAORD),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('TMAG_T','PROANG')
      ALLOCATE (TSIF_P(NDMULM,NUPREM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('TSIF_P','PROANG')
      IF (NASORD.GE.0)
     *ALLOCATE (TASM_T(NDMULM,NUPREM,0:NASORD),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('TASM_T','PROANG')
C
C=======================================================================
C         ZEROING ARRAYS OF MULTIPOLE, MAGNETIC, AND SPIN-ASY MOMENTS
C=======================================================================
C
      TMUL_P(:,:)=C_ZERO
      TMAG_T(:,:,:)=C_ZERO
      TSIF_P(:,:)=C_ZERO
      IF (NASORD.GE.0)
     *TASM_T(:,:,:)=C_ZERO
C
C=======================================================================
C         ALLOCATING ARRAYS FOR INTEGRATION OVER THE ISOSPIN EULR ANGLES
C=======================================================================
C
      ALLOCATE (TKER_T(NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('TKER_T','PROANG')
      ALLOCATE (TSKY_T(NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('TSKY_T','PROANG')
      ALLOCATE (TKIN_N(NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('TKIN_N','PROANG')
      ALLOCATE (TKIN_P(NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('TKIN_P','PROANG')
      ALLOCATE (TCOU_D(NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('TCOU_D','PROANG')
      ALLOCATE (TCOU_X(NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('TCOU_X','PROANG')
      ALLOCATE (TPAI_N(NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('TPAI_N','PROANG')
      ALLOCATE (TPAI_P(NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('TPAI_P','PROANG')
      ALLOCATE (TPNU00(NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('TPNU00','PROANG')
      ALLOCATE (TPNU10(NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('TPNU10','PROANG')
      ALLOCATE (TPNU1P(NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('TPNU1P','PROANG')
      ALLOCATE (TPNU1M(NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('TPNU1M','PROANG')
      ALLOCATE (TTZISO(NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('TTZISO','PROANG')
      ALLOCATE (TT2ISO(NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('TT2ISO','PROANG')
      ALLOCATE (TBZROT(NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('TBZROT','PROANG')
      ALLOCATE (TB2ROT(NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('TB2ROT','PROANG')
      ALLOCATE (TC10_D(NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('TC10_D','PROANG')
      ALLOCATE (TC1P_D(NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('TC1P_D','PROANG')
      ALLOCATE (TC1M_D(NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('TC1M_D','PROANG')
      ALLOCATE (TC20_D(NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('TC20_D','PROANG')
      ALLOCATE (TC21PD(NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('TC21PD','PROANG')
      ALLOCATE (TC21MD(NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('TC21MD','PROANG')
      ALLOCATE (TC22PD(NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('TC22PD','PROANG')
      ALLOCATE (TC22MD(NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('TC22MD','PROANG')
      ALLOCATE (TC10_X(NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('TC10_X','PROANG')
      ALLOCATE (TC1P_X(NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('TC1P_X','PROANG')
      ALLOCATE (TC1M_X(NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('TC1M_X','PROANG')
      ALLOCATE (TC20_X(NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('TC20_X','PROANG')
      ALLOCATE (TC21PX(NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('TC21PX','PROANG')
      ALLOCATE (TC21MX(NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('TC21MX','PROANG')
      ALLOCATE (TC22PX(NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('TC22PX','PROANG')
      ALLOCATE (TC22MX(NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('TC22MX','PROANG')
C
C=======================================================================
C    HERE START THE LOOPS OVER THE BETA (J), ALPHA (I), GAMMA (K), AND
C                        BETISO (L) GAUSS KNOTS
C                 INTEGRATION OVER ALPHA_T AND GAMMA_T COMES FIRST
C             IT IS FOLLOWED BY INTEGRATION OVER BETISO (L)
C        THEN IT IS FOLLOWED BY INTEGRATION OVER GAMMA AND ALPHA.
C                   FINAL INTEGRATION GOES OVER BETA
C=======================================================================
C
      DO J=1,NUBKNO
        DO I=1,NUAKNO
          DO K=1,NUAKNO
C
C=======================================================================
C         ZEROING ARRAYS FOR INTEGRATION OVER THE ISOSPIN EULER ANGLES
C=======================================================================
C
C TER        TTER_T=C_ZERO
             TKER_T(:)=C_ZERO
             TSKY_T(:)=C_ZERO
             TKIN_N(:)=C_ZERO
             TKIN_P(:)=C_ZERO
             TCOU_D(:)=C_ZERO
             TCOU_X(:)=C_ZERO
             TPAI_N(:)=C_ZERO
             TPAI_P(:)=C_ZERO
             TPNU00(:)=C_ZERO
             TPNU10(:)=C_ZERO
             TPNU1P(:)=C_ZERO
             TPNU1M(:)=C_ZERO
             TTZISO(:)=C_ZERO
             TT2ISO(:)=C_ZERO
             TBZROT(:)=C_ZERO
             TB2ROT(:)=C_ZERO
             TC10_D(:)=C_ZERO
             TC1P_D(:)=C_ZERO
             TC1M_D(:)=C_ZERO
             TC20_D(:)=C_ZERO
             TC21PD(:)=C_ZERO
             TC21MD(:)=C_ZERO
             TC22PD(:)=C_ZERO
             TC22MD(:)=C_ZERO
             TC10_X(:)=C_ZERO
             TC1P_X(:)=C_ZERO
             TC1M_X(:)=C_ZERO
             TC20_X(:)=C_ZERO
             TC21PX(:)=C_ZERO
             TC21MX(:)=C_ZERO
             TC22PX(:)=C_ZERO
             TC22MX(:)=C_ZERO
C
C=======================================================================
C
             DO L=1,NBTKNO
C
C TER          UTER_T=C_ZERO
               UKER_T=C_ZERO
C
               USKY_T=C_ZERO
               UKIN_N=C_ZERO
               UKIN_P=C_ZERO
C
               UPAI_N=C_ZERO
               UPAI_P=C_ZERO
C
               UCOU_D=C_ZERO
               UC10_D=C_ZERO
               UC1P_D=C_ZERO
               UC1M_D=C_ZERO
               UC20_D=C_ZERO
               UC21PD=C_ZERO
               UC21MD=C_ZERO
               UC22PD=C_ZERO
               UC22MD=C_ZERO
C
               UCOU_X=C_ZERO
               UC10_X=C_ZERO
               UC1P_X=C_ZERO
               UC1M_X=C_ZERO
               UC20_X=C_ZERO
               UC21PX=C_ZERO
               UC21MX=C_ZERO
               UC22PX=C_ZERO
               UC22MX=C_ZERO
C
               UPNU00=C_ZERO
               UPNU10=C_ZERO
               UPNU1P=C_ZERO
               UPNU1M=C_ZERO
C
               UTZISO=C_ZERO
               UT2ISO=C_ZERO
C
               UBZROT=C_ZERO
               UB2ROT=C_ZERO
C
               DO I_T=1,NATKNO
C
                  DO KSOSAC=KSOSTA(JSOSMA),KSOSTO(JSOSMA),2
C
C=======================================================================
C         BELOW WE INTEGRATE KERNELS OVER THE GAMMA_T EULER ANGLE AND
C         AT THE SAME TIME WE MULTIPLY THEM BY THE  GAUSS  WEIGHTS
C=======================================================================
C
                     DO K_T=1,NATKNO
C
                        GAMM_K=XAT_PN(K_T)*0.5D0*KSOSAC
C
                        FACINT=XAT_WG(K_T)
     *                                 *(COS(GAMM_K)+UNIT_I*SIN(GAMM_K))
C
                        IF (NBTKNO.EQ.1) THEN
                            FACINT=FACINT*XBT_WG(L)*OVKERN(I,J,K,1,1,1)
                        ELSE
                            FACINT=FACINT*XBT_WG(L)
     *                                          *OVKERN(I,J,K,I_T,L,K_T)
                        END IF
C
                        FACI1M=FACINT
                        FACI1P=FACINT
                        FACI2M=FACINT
                        FACI2P=FACINT
C
C=======================================================================
C            INTEGRATING THE NORM, ENERGY AND COULOMB KERNELS
C=======================================================================
C
                        UKER_T(I_T,KSOSAC)=UKER_T(I_T,KSOSAC)+FACINT
C
                        IF (NBTKNO.EQ.1) THEN
C
                            UKIN_N(I_T,KSOSAC)=UKIN_N(I_T,KSOSAC)
     *                                       +FACINT*EKKERN(I,J,K,1,0,1)
                            UKIN_P(I_T,KSOSAC)=UKIN_P(I_T,KSOSAC)
     *                                       +FACINT*EKKERN(I,J,K,1,1,1)
C
                            UPAI_N(I_T,KSOSAC)=UPAI_N(I_T,KSOSAC)
     *                                    +FACINT*EPKERN(I,J,K,1,0,1)
                            UPAI_P(I_T,KSOSAC)=UPAI_P(I_T,KSOSAC)
     *                                    +FACINT*EPKERN(I,J,K,1,1,1)
                         ELSE
C
                            UKIN_N(I_T,KSOSAC)=UKIN_N(I_T,KSOSAC)
     *                                   +FACINT*EKKERN(I,J,K,I_T,L,K_T)
                            UKIN_P(I_T,KSOSAC)=C_ZERO
                         END IF
C
C TER        DO NUCOUT=1,2*NDCOUT
C TER                UTER_T(I_T,KSOSAC,NUCOUT)=UTER_T(I_T,KSOSAC,NUCOUT)
C TER*                            +FACINT*TEKERN(I,J,K,I_T,L,K_T,NUCOUT)
C TER        END DO
C
C                  T E S T I N G
C
C JD              DATA IDUPA/0/
C                 IF (IDUPA.EQ.0) WRITE(*,*) ' TYLKO ISOSKALAR'
C JD              IF (IDUPA.EQ.0) WRITE(*,*) ' BEZ KULOMBA    '
C JD              IDUPA=1
C
C JD              CDKERN(I,J,K,I_T,L,K_T)=C_ZERO
C JD              CDKE10(I,J,K,I_T,L,K_T)=C_ZERO
C JD              CDKE1P(I,J,K,I_T,L,K_T)=C_ZERO
C JD              CDKE1M(I,J,K,I_T,L,K_T)=C_ZERO
C JD              CDKE20(I,J,K,I_T,L,K_T)=C_ZERO
C JD              CDK21P(I,J,K,I_T,L,K_T)=C_ZERO
C JD              CDK21M(I,J,K,I_T,L,K_T)=C_ZERO
C JD              CDK22P(I,J,K,I_T,L,K_T)=C_ZERO
C JD              CDK22M(I,J,K,I_T,L,K_T)=C_ZERO
C
C JD              CXKERN(I,J,K,I_T,L,K_T)=C_ZERO
C JD              CXKE10(I,J,K,I_T,L,K_T)=C_ZERO
C JD              CXKE1P(I,J,K,I_T,L,K_T)=C_ZERO
C JD              CXKE1M(I,J,K,I_T,L,K_T)=C_ZERO
C JD              CXKE20(I,J,K,I_T,L,K_T)=C_ZERO
C JD              CXK21P(I,J,K,I_T,L,K_T)=C_ZERO
C JD              CXK21M(I,J,K,I_T,L,K_T)=C_ZERO
C JD              CXK22P(I,J,K,I_T,L,K_T)=C_ZERO
C JD              CXK22M(I,J,K,I_T,L,K_T)=C_ZERO
C
                         USKY_T(I_T,KSOSAC)=USKY_T(I_T,KSOSAC)
     *                                   +FACINT*SKKERN(I,J,K,I_T,L,K_T)
                         UCOU_D(I_T,KSOSAC)=UCOU_D(I_T,KSOSAC)
     *                                   +FACINT*CDKERN(I,J,K,I_T,L,K_T)
                         UC10_D(I_T,KSOSAC)=UC10_D(I_T,KSOSAC)
     *                                   +FACINT*CDKE10(I,J,K,I_T,L,K_T)
                         UC1P_D(I_T,KSOSAC)=UC1P_D(I_T,KSOSAC)
     *                                   +FACI1P*CDKE1P(I,J,K,I_T,L,K_T)
                         UC1M_D(I_T,KSOSAC)=UC1M_D(I_T,KSOSAC)
     *                                   +FACI1M*CDKE1M(I,J,K,I_T,L,K_T)
                         UC20_D(I_T,KSOSAC)=UC20_D(I_T,KSOSAC)
     *                                   +FACINT*CDKE20(I,J,K,I_T,L,K_T)
                         UC21PD(I_T,KSOSAC)=UC21PD(I_T,KSOSAC)
     *                                   +FACI1P*CDK21P(I,J,K,I_T,L,K_T)
                         UC21MD(I_T,KSOSAC)=UC21MD(I_T,KSOSAC)
     *                                   +FACI1M*CDK21M(I,J,K,I_T,L,K_T)
                         UC22PD(I_T,KSOSAC)=UC22PD(I_T,KSOSAC)
     *                                   +FACI2P*CDK22P(I,J,K,I_T,L,K_T)
                         UC22MD(I_T,KSOSAC)=UC22MD(I_T,KSOSAC)
     *                                   +FACI2M*CDK22M(I,J,K,I_T,L,K_T)
C
                         UCOU_X(I_T,KSOSAC)=UCOU_X(I_T,KSOSAC)
     *                                   +FACINT*CXKERN(I,J,K,I_T,L,K_T)
                         UC10_X(I_T,KSOSAC)=UC10_X(I_T,KSOSAC)
     *                                   +FACINT*CXKE10(I,J,K,I_T,L,K_T)
                         UC1P_X(I_T,KSOSAC)=UC1P_X(I_T,KSOSAC)
     *                                   +FACI1P*CXKE1P(I,J,K,I_T,L,K_T)
                         UC1M_X(I_T,KSOSAC)=UC1M_X(I_T,KSOSAC)
     *                                   +FACI1M*CXKE1M(I,J,K,I_T,L,K_T)
                         UC20_X(I_T,KSOSAC)=UC20_X(I_T,KSOSAC)
     *                                   +FACINT*CXKE20(I,J,K,I_T,L,K_T)
                         UC21PX(I_T,KSOSAC)=UC21PX(I_T,KSOSAC)
     *                                   +FACI1P*CXK21P(I,J,K,I_T,L,K_T)
                         UC21MX(I_T,KSOSAC)=UC21MX(I_T,KSOSAC)
     *                                   +FACI1M*CXK21M(I,J,K,I_T,L,K_T)
                         UC22PX(I_T,KSOSAC)=UC22PX(I_T,KSOSAC)
     *                                   +FACI2P*CXK22P(I,J,K,I_T,L,K_T)
                         UC22MX(I_T,KSOSAC)=UC22MX(I_T,KSOSAC)
     *                                   +FACI2M*CXK22M(I,J,K,I_T,L,K_T)
C
                         UPNU00(I_T,KSOSAC)=UPNU00(I_T,KSOSAC)
     *                                   +FACINT*PNKE00(I,J,K,I_T,L,K_T)
                         UPNU10(I_T,KSOSAC)=UPNU10(I_T,KSOSAC)
     *                                   +FACINT*PNKE10(I,J,K,I_T,L,K_T)
                         UPNU1P(I_T,KSOSAC)=UPNU1P(I_T,KSOSAC)
     *                                   +FACI1P*PNKE1P(I,J,K,I_T,L,K_T)
                         UPNU1M(I_T,KSOSAC)=UPNU1M(I_T,KSOSAC)
     *                                   +FACI1M*PNKE1M(I,J,K,I_T,L,K_T)
C
                         UTZISO(I_T,KSOSAC)=UTZISO(I_T,KSOSAC)
     *                                   +FACINT*TZKERN(I,J,K,I_T,L,K_T)
                         UT2ISO(I_T,KSOSAC)=UT2ISO(I_T,KSOSAC)
     *                                   +FACINT*T2KERN(I,J,K,I_T,L,K_T)
C
                         UBZROT(I_T,KSOSAC)=UBZROT(I_T,KSOSAC)
     *                                   +FACINT*BZKERN(I,J,K,I_T,L,K_T)
                         UB2ROT(I_T,KSOSAC)=UB2ROT(I_T,KSOSAC)
     *                                   +FACINT*B2KERN(I,J,K,I_T,L,K_T)
C
C=======================================================================
C           HERE END THE LOOPS  OVER THE  GAMMA_T  GAUSS  KNOTS
C         AND THE LOOP OVER THE K_T PROJECTION ON THE INTRINSIC AXIS
C=======================================================================
C
                      END DO
                  END DO
C
C=======================================================================
C           HERE END THE LOOP OVER THE  ALPHA_T  GAUSS  KNOTS
C=======================================================================
C
               END DO
C
C=======================================================================
C         ZEROING AUXILIARY ARRAYS OF OVERLAP AND ENERGY KERNELS
C=======================================================================
C
C TER          WTER_T=C_ZERO
               WKER_T=C_ZERO
C
               WSKY_T=C_ZERO
               WKIN_N=C_ZERO
               WKIN_P=C_ZERO
C
               WPAI_N=C_ZERO
               WPAI_P=C_ZERO
C
               WCOU_D=C_ZERO
               WC10_D=C_ZERO
               WC1P_D=C_ZERO
               WC1M_D=C_ZERO
               WC20_D=C_ZERO
               WC21PD=C_ZERO
               WC21MD=C_ZERO
               WC22PD=C_ZERO
               WC22MD=C_ZERO
C
               WCOU_X=C_ZERO
               WC10_X=C_ZERO
               WC1P_X=C_ZERO
               WC1M_X=C_ZERO
               WC20_X=C_ZERO
               WC21PX=C_ZERO
               WC21MX=C_ZERO
               WC22PX=C_ZERO
               WC22MX=C_ZERO
C
               WPNU00=C_ZERO
               WPNU10=C_ZERO
               WPNU1P=C_ZERO
               WPNU1M=C_ZERO
C
               WTZISO=C_ZERO
               WT2ISO=C_ZERO
C
               WBZROT=C_ZERO
               WB2ROT=C_ZERO
C
               DO LSOSAC=KSOSTA(JSOSMA),KSOSTO(JSOSMA),2
C
                  DO KSOSAC=KSOSTA(JSOSMA),KSOSTO(JSOSMA),2
C
                     DO I_T=1,NATKNO
C
                        ALPH_L=XAT_PN(I_T)*0.5D0*LSOSAC
C
                        FACINT=XAT_WG(I_T)
     *                        *(COS(ALPH_L)+UNIT_I*SIN(ALPH_L))
C
C TER        DO NUCOUT=1,2*NDCOUT
C TER          WTER_T(LSOSAC,KSOSAC,NUCOUT)=WTER_T(LSOSAC,KSOSAC,NUCOUT)
C TER*                                 +FACINT*UTER_T(I_T,KSOSAC,NUCOUT)
C TER        END DO
                        WKER_T(LSOSAC,KSOSAC)=WKER_T(LSOSAC,KSOSAC)
     *                                        +FACINT*UKER_T(I_T,KSOSAC)
C
                        WSKY_T(LSOSAC,KSOSAC)=WSKY_T(LSOSAC,KSOSAC)
     *                                        +FACINT*USKY_T(I_T,KSOSAC)
                        WKIN_N(LSOSAC,KSOSAC)=WKIN_N(LSOSAC,KSOSAC)
     *                                        +FACINT*UKIN_N(I_T,KSOSAC)
                        WKIN_P(LSOSAC,KSOSAC)=WKIN_P(LSOSAC,KSOSAC)
     *                                        +FACINT*UKIN_P(I_T,KSOSAC)
C
                        WPAI_N(LSOSAC,KSOSAC)=WPAI_N(LSOSAC,KSOSAC)
     *                                     +FACINT*UPAI_N(I_T,KSOSAC)
                        WPAI_P(LSOSAC,KSOSAC)=WPAI_P(LSOSAC,KSOSAC)
     *                                        +FACINT*UPAI_P(I_T,KSOSAC)
C
                        WCOU_D(LSOSAC,KSOSAC)=WCOU_D(LSOSAC,KSOSAC)
     *                                        +FACINT*UCOU_D(I_T,KSOSAC)
                        WC10_D(LSOSAC,KSOSAC)=WC10_D(LSOSAC,KSOSAC)
     *                                        +FACINT*UC10_D(I_T,KSOSAC)
                        WC1P_D(LSOSAC,KSOSAC)=WC1P_D(LSOSAC,KSOSAC)
     *                                        +FACINT*UC1P_D(I_T,KSOSAC)
                        WC1M_D(LSOSAC,KSOSAC)=WC1M_D(LSOSAC,KSOSAC)
     *                                        +FACINT*UC1M_D(I_T,KSOSAC)
                        WC20_D(LSOSAC,KSOSAC)=WC20_D(LSOSAC,KSOSAC)
     *                                        +FACINT*UC20_D(I_T,KSOSAC)
                        WC21PD(LSOSAC,KSOSAC)=WC21PD(LSOSAC,KSOSAC)
     *                                        +FACINT*UC21PD(I_T,KSOSAC)
                        WC21MD(LSOSAC,KSOSAC)=WC21MD(LSOSAC,KSOSAC)
     *                                        +FACINT*UC21MD(I_T,KSOSAC)
                        WC22PD(LSOSAC,KSOSAC)=WC22PD(LSOSAC,KSOSAC)
     *                                        +FACINT*UC22PD(I_T,KSOSAC)
                        WC22MD(LSOSAC,KSOSAC)=WC22MD(LSOSAC,KSOSAC)
     *                                        +FACINT*UC22MD(I_T,KSOSAC)
C
                        WCOU_X(LSOSAC,KSOSAC)=WCOU_X(LSOSAC,KSOSAC)
     *                                        +FACINT*UCOU_X(I_T,KSOSAC)
                        WC10_X(LSOSAC,KSOSAC)=WC10_X(LSOSAC,KSOSAC)
     *                                        +FACINT*UC10_X(I_T,KSOSAC)
                        WC1P_X(LSOSAC,KSOSAC)=WC1P_X(LSOSAC,KSOSAC)
     *                                        +FACINT*UC1P_X(I_T,KSOSAC)
                        WC1M_X(LSOSAC,KSOSAC)=WC1M_X(LSOSAC,KSOSAC)
     *                                        +FACINT*UC1M_X(I_T,KSOSAC)
                        WC20_X(LSOSAC,KSOSAC)=WC20_X(LSOSAC,KSOSAC)
     *                                        +FACINT*UC20_X(I_T,KSOSAC)
                        WC21PX(LSOSAC,KSOSAC)=WC21PX(LSOSAC,KSOSAC)
     *                                        +FACINT*UC21PX(I_T,KSOSAC)
                        WC21MX(LSOSAC,KSOSAC)=WC21MX(LSOSAC,KSOSAC)
     *                                        +FACINT*UC21MX(I_T,KSOSAC)
                        WC22PX(LSOSAC,KSOSAC)=WC22PX(LSOSAC,KSOSAC)
     *                                        +FACINT*UC22PX(I_T,KSOSAC)
                        WC22MX(LSOSAC,KSOSAC)=WC22MX(LSOSAC,KSOSAC)
     *                                        +FACINT*UC22MX(I_T,KSOSAC)
C
                        WPNU00(LSOSAC,KSOSAC)=WPNU00(LSOSAC,KSOSAC)
     *                                        +FACINT*UPNU00(I_T,KSOSAC)
                        WPNU10(LSOSAC,KSOSAC)=WPNU10(LSOSAC,KSOSAC)
     *                                        +FACINT*UPNU10(I_T,KSOSAC)
                        WPNU1P(LSOSAC,KSOSAC)=WPNU1P(LSOSAC,KSOSAC)
     *                                        +FACINT*UPNU1P(I_T,KSOSAC)
                        WPNU1M(LSOSAC,KSOSAC)=WPNU1M(LSOSAC,KSOSAC)
     *                                        +FACINT*UPNU1M(I_T,KSOSAC)
C
                        WTZISO(LSOSAC,KSOSAC)=WTZISO(LSOSAC,KSOSAC)
     *                                        +FACINT*UTZISO(I_T,KSOSAC)
                        WT2ISO(LSOSAC,KSOSAC)=WT2ISO(LSOSAC,KSOSAC)
     *                                        +FACINT*UT2ISO(I_T,KSOSAC)
C
                        WBZROT(LSOSAC,KSOSAC)=WBZROT(LSOSAC,KSOSAC)
     *                                        +FACINT*UBZROT(I_T,KSOSAC)
                        WB2ROT(LSOSAC,KSOSAC)=WB2ROT(LSOSAC,KSOSAC)
     *                                        +FACINT*UB2ROT(I_T,KSOSAC)
C
C=======================================================================
C         HERE ENDS THE LOOP OVER THE ALPHA_T GAUSS KNOTS (I_T), AND THE
C         LOOPS OVER THE L AND K ISOSPIN PROJECTIONS
C=======================================================================
C
                     END DO
C
                  END DO
               END DO
C
C=======================================================================
C
C              DO ISOSAC=JSOSMI,JSOSMA,2
C                 DO LSOSAC=KSOSTA(ISOSAC),KSOSTO(ISOSAC),2
C                    DO KSOSAC=KSOSTA(ISOSAC),KSOSTO(ISOSAC),2
C
               DO INDISO=1,NUISOM
C
                  ISOSAC=ISOMAT(INDISO)
                  LSOSAC=LSOMAT(INDISO)
                  KSOSAC=KSOMAT(INDISO)
C
                        FACINT=C_UNIT
                        FACI1M=C_ZERO
                        FACI1P=C_ZERO
                        FACI2M=C_ZERO
                        FACI2P=C_ZERO
C
                        IF (NBTKNO.GT.1) THEN
C
                           FACINT=DSMALH(ISOSAC,LSOSAC,KSOSAC,
     *                                   XBT_PN(L),NEWWIG,ISWIND,NUANGU)
C
                        IF (NATKNO.EQ.1) THEN
C
                           IF(LSOSAC-2.GE.-ISOSAC)
     *                        FACI1P=DSMALH(ISOSAC,LSOSAC-2,KSOSAC,
     *                                   XBT_PN(L),NEWWIG,ISWIND,NUANGU)
                           IF(LSOSAC+2.LE. ISOSAC)
     *                        FACI1M=DSMALH(ISOSAC,LSOSAC+2,KSOSAC,
     *                                   XBT_PN(L),NEWWIG,ISWIND,NUANGU)
                           IF(LSOSAC-4.GE.-ISOSAC)
     *                        FACI2P=DSMALH(ISOSAC,LSOSAC-4,KSOSAC,
     *                                   XBT_PN(L),NEWWIG,ISWIND,NUANGU)
                           IF(LSOSAC+4.LE. ISOSAC)
     *                        FACI2M=DSMALH(ISOSAC,LSOSAC+4,KSOSAC,
     *                                   XBT_PN(L),NEWWIG,ISWIND,NUANGU)
C
                        ELSE
C
                           FACI1M=FACINT
                           FACI1P=FACINT
                           FACI2M=FACINT
                           FACI2P=FACINT
C
                        END IF
C
                        END IF
C
C=======================================================================
C            INTEGRATING THE NORM, ENERGY AND COULOMB KERNELS
C=======================================================================
C
C TER        DO NUCOUT=1,2*NDCOUT
C TER                   TTER_T(INDISO,NUCOUT)=
C TER*                  TTER_T(INDISO,NUCOUT)+
C TER*                         FACINT*WTER_T(LSOSAC,KSOSAC,NUCOUT)
C TER        END DO
                        TKER_T(INDISO)=
     *                  TKER_T(INDISO)+
     *                         FACINT*WKER_T(LSOSAC,KSOSAC)
C
                        IF (NBTKNO.EQ.1) THEN
C
                            TKIN_N(INDISO)=
     *                      TKIN_N(INDISO)+
     *                             FACINT*WKIN_N(LSOSAC,KSOSAC)
                            TKIN_P(INDISO)=
     *                      TKIN_P(INDISO)+
     *                             FACINT*WKIN_P(LSOSAC,KSOSAC)
C
                            TPAI_N(INDISO)=
     *                      TPAI_N(INDISO)+
     *                             FACINT*WPAI_N(LSOSAC,KSOSAC)
                            TPAI_P(INDISO)=
     *                      TPAI_P(INDISO)+
     *                             FACINT*WPAI_P(LSOSAC,KSOSAC)
C
                        ELSE
C
                            TKIN_N(INDISO)=
     *                      TKIN_N(INDISO)+
     *                             FACINT*WKIN_N(LSOSAC,KSOSAC)
                            TKIN_P(INDISO)=
     *                      C_ZERO
C
                        END IF
C
                        TSKY_T(INDISO)=
     *                  TSKY_T(INDISO)+
     *                         FACINT*WSKY_T(LSOSAC,KSOSAC)
                        TCOU_D(INDISO)=
     *                  TCOU_D(INDISO)+
     *                         FACINT*WCOU_D(LSOSAC,KSOSAC)
                        TC10_D(INDISO)=
     *                  TC10_D(INDISO)+
     *                         FACINT*WC10_D(LSOSAC,KSOSAC)
                        TC1P_D(INDISO)=
     *                  TC1P_D(INDISO)+
     *                         FACI1P*WC1P_D(LSOSAC,KSOSAC)
                        TC1M_D(INDISO)=
     *                  TC1M_D(INDISO)+
     *                         FACI1M*WC1M_D(LSOSAC,KSOSAC)
                        TC20_D(INDISO)=
     *                  TC20_D(INDISO)+
     *                         FACINT*WC20_D(LSOSAC,KSOSAC)
                        TC21PD(INDISO)=
     *                  TC21PD(INDISO)+
     *                         FACI1P*WC21PD(LSOSAC,KSOSAC)
                        TC21MD(INDISO)=
     *                  TC21MD(INDISO)+
     *                         FACI1M*WC21MD(LSOSAC,KSOSAC)
                        TC22PD(INDISO)=
     *                  TC22PD(INDISO)+
     *                         FACI2P*WC22PD(LSOSAC,KSOSAC)
                        TC22MD(INDISO)=
     *                  TC22MD(INDISO)+
     *                         FACI2M*WC22MD(LSOSAC,KSOSAC)
C
                        TCOU_X(INDISO)=
     *                  TCOU_X(INDISO)+
     *                         FACINT*WCOU_X(LSOSAC,KSOSAC)
                        TC10_X(INDISO)=
     *                  TC10_X(INDISO)+
     *                         FACINT*WC10_X(LSOSAC,KSOSAC)
                        TC1P_X(INDISO)=
     *                  TC1P_X(INDISO)+
     *                         FACI1P*WC1P_X(LSOSAC,KSOSAC)
                        TC1M_X(INDISO)=
     *                  TC1M_X(INDISO)+
     *                         FACI1M*WC1M_X(LSOSAC,KSOSAC)
                        TC20_X(INDISO)=
     *                  TC20_X(INDISO)+
     *                         FACINT*WC20_X(LSOSAC,KSOSAC)
                        TC21PX(INDISO)=
     *                  TC21PX(INDISO)+
     *                         FACI1P*WC21PX(LSOSAC,KSOSAC)
                        TC21MX(INDISO)=
     *                  TC21MX(INDISO)+
     *                         FACI1M*WC21MX(LSOSAC,KSOSAC)
                        TC22PX(INDISO)=
     *                  TC22PX(INDISO)+
     *                         FACI2P*WC22PX(LSOSAC,KSOSAC)
                        TC22MX(INDISO)=
     *                  TC22MX(INDISO)+
     *                         FACI2M*WC22MX(LSOSAC,KSOSAC)
C
                        TPNU00(INDISO)=
     *                  TPNU00(INDISO)+
     *                         FACINT*WPNU00(LSOSAC,KSOSAC)
                        TPNU10(INDISO)=
     *                  TPNU10(INDISO)+
     *                         FACINT*WPNU10(LSOSAC,KSOSAC)
                        TPNU1P(INDISO)=
     *                  TPNU1P(INDISO)+
     *                         FACI1P*WPNU1P(LSOSAC,KSOSAC)
                        TPNU1M(INDISO)=
     *                  TPNU1M(INDISO)+
     *                         FACI1M*WPNU1M(LSOSAC,KSOSAC)
C
                        TTZISO(INDISO)=
     *                  TTZISO(INDISO)+
     *                         FACINT*WTZISO(LSOSAC,KSOSAC)
                        TT2ISO(INDISO)=
     *                  TT2ISO(INDISO)+
     *                         FACINT*WT2ISO(LSOSAC,KSOSAC)
C
                        TBZROT(INDISO)=
     *                  TBZROT(INDISO)+
     *                         FACINT*WBZROT(LSOSAC,KSOSAC)
                        TB2ROT(INDISO)=
     *                  TB2ROT(INDISO)+
     *                         FACINT*WB2ROT(LSOSAC,KSOSAC)
C
C=======================================================================
C        HERE END THE LOOPS OVER BETA_T ISOSPIN GAUSS KNOTS AND THE
C        ISOSPIN QUANTUM NUMBERS ISOSAC,KSOSAC,LSOSAC
C=======================================================================
C
C                    END DO
C                 END DO
               END DO
            END DO
C
            DO INDISO=1,NUISOM
C
C TER        DO NUCOUT=1,2*NDCOUT
C TER          TETERN(I,J,K,INDISO,NUCOUT)=TTER_T(INDISO,NUCOUT)
C TER        END DO
               OVTERN(I,J,K,INDISO)=TKER_T(INDISO)
               SKTERN(I,J,K,INDISO)=TSKY_T(INDISO)
C
               IF (NBTKNO.EQ.1) THEN
                   EKTERN(I,J,K,0)=TKIN_N(INDISO)
                   EKTERN(I,J,K,1)=TKIN_P(INDISO)
C
                   EPTERN(I,J,K,0)=TPAI_N(INDISO)
                   EPTERN(I,J,K,1)=TPAI_P(INDISO)
C
               ELSE
                   EKTERN(I,J,K,INDISO)=TKIN_N(INDISO)
               END IF
C
               CDTERN(I,J,K,INDISO)=TCOU_D(INDISO)
               CDTE10(I,J,K,INDISO)=TC10_D(INDISO)
               CDTE1P(I,J,K,INDISO)=TC1P_D(INDISO)
               CDTE1M(I,J,K,INDISO)=TC1M_D(INDISO)
               CDTE20(I,J,K,INDISO)=TC20_D(INDISO)
               CDT21P(I,J,K,INDISO)=TC21PD(INDISO)
               CDT21M(I,J,K,INDISO)=TC21MD(INDISO)
               CDT22P(I,J,K,INDISO)=TC22PD(INDISO)
               CDT22M(I,J,K,INDISO)=TC22MD(INDISO)
C
               CXTERN(I,J,K,INDISO)=TCOU_X(INDISO)
               CXTE10(I,J,K,INDISO)=TC10_X(INDISO)
               CXTE1P(I,J,K,INDISO)=TC1P_X(INDISO)
               CXTE1M(I,J,K,INDISO)=TC1M_X(INDISO)
               CXTE20(I,J,K,INDISO)=TC20_X(INDISO)
               CXT21P(I,J,K,INDISO)=TC21PX(INDISO)
               CXT21M(I,J,K,INDISO)=TC21MX(INDISO)
               CXT22P(I,J,K,INDISO)=TC22PX(INDISO)
               CXT22M(I,J,K,INDISO)=TC22MX(INDISO)
C
               PNTE00(I,J,K,INDISO)=TPNU00(INDISO)
               PNTE10(I,J,K,INDISO)=TPNU10(INDISO)
               PNTE1P(I,J,K,INDISO)=TPNU1P(INDISO)
               PNTE1M(I,J,K,INDISO)=TPNU1M(INDISO)
C
               TZTERN(I,J,K,INDISO)=TTZISO(INDISO)
               T2TERN(I,J,K,INDISO)=TT2ISO(INDISO)
C
               BZTERN(I,J,K,INDISO)=TBZROT(INDISO)
               B2TERN(I,J,K,INDISO)=TB2ROT(INDISO)
C
            END DO
C
          END DO
        END DO
      END DO
C
C=======================================================================
C         ALLOCATING ARRAYS FOR INTEGRATION OVER THE ISOSPIN EULR ANGLES
C=======================================================================
C
      ALLOCATE (ZKER_T(1:NDAKNO,-NDPROI:NDPROI,1:NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('ZKER_T','PROANG')
      ALLOCATE (ZSKY_T(1:NDAKNO,-NDPROI:NDPROI,1:NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('ZSKY_T','PROANG')
      ALLOCATE (ZKIN_N(1:NDAKNO,-NDPROI:NDPROI,1:NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('ZKIN_N','PROANG')
      ALLOCATE (ZKIN_P(1:NDAKNO,-NDPROI:NDPROI,1:NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('ZKIN_P','PROANG')
      ALLOCATE (ZPAI_N(1:NDAKNO,-NDPROI:NDPROI,1:NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('ZPAI_N','PROANG')
      ALLOCATE (ZPAI_P(1:NDAKNO,-NDPROI:NDPROI,1:NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('ZPAI_P','PROANG')
      ALLOCATE (ZCOU_D(1:NDAKNO,-NDPROI:NDPROI,1:NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('ZCOU_D','PROANG')
      ALLOCATE (ZC10_D(1:NDAKNO,-NDPROI:NDPROI,1:NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('ZC10_D','PROANG')
      ALLOCATE (ZC1P_D(1:NDAKNO,-NDPROI:NDPROI,1:NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('ZC1P_D','PROANG')
      ALLOCATE (ZC1M_D(1:NDAKNO,-NDPROI:NDPROI,1:NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('ZC1M_D','PROANG')
      ALLOCATE (ZC20_D(1:NDAKNO,-NDPROI:NDPROI,1:NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('ZC20_D','PROANG')
      ALLOCATE (ZC21PD(1:NDAKNO,-NDPROI:NDPROI,1:NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('ZC21PD','PROANG')
      ALLOCATE (ZC21MD(1:NDAKNO,-NDPROI:NDPROI,1:NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('ZC21MD','PROANG')
      ALLOCATE (ZC22PD(1:NDAKNO,-NDPROI:NDPROI,1:NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('ZC22PD','PROANG')
      ALLOCATE (ZC22MD(1:NDAKNO,-NDPROI:NDPROI,1:NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('ZC22MD','PROANG')
      ALLOCATE (ZCOU_X(1:NDAKNO,-NDPROI:NDPROI,1:NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('ZCOU_X','PROANG')
      ALLOCATE (ZC10_X(1:NDAKNO,-NDPROI:NDPROI,1:NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('ZC10_X','PROANG')
      ALLOCATE (ZC1P_X(1:NDAKNO,-NDPROI:NDPROI,1:NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('ZC1P_X','PROANG')
      ALLOCATE (ZC1M_X(1:NDAKNO,-NDPROI:NDPROI,1:NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('ZC1M_X','PROANG')
      ALLOCATE (ZC20_X(1:NDAKNO,-NDPROI:NDPROI,1:NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('ZC20_X','PROANG')
      ALLOCATE (ZC21PX(1:NDAKNO,-NDPROI:NDPROI,1:NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('ZC21PX','PROANG')
      ALLOCATE (ZC21MX(1:NDAKNO,-NDPROI:NDPROI,1:NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('ZC21MX','PROANG')
      ALLOCATE (ZC22PX(1:NDAKNO,-NDPROI:NDPROI,1:NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('ZC22PX','PROANG')
      ALLOCATE (ZC22MX(1:NDAKNO,-NDPROI:NDPROI,1:NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('ZC22MX','PROANG')
      ALLOCATE (ZPNU00(1:NDAKNO,-NDPROI:NDPROI,1:NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('ZPNU00','PROANG')
      ALLOCATE (ZPNU10(1:NDAKNO,-NDPROI:NDPROI,1:NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('ZPNU10','PROANG')
      ALLOCATE (ZPNU1P(1:NDAKNO,-NDPROI:NDPROI,1:NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('ZPNU1P','PROANG')
      ALLOCATE (ZPNU1M(1:NDAKNO,-NDPROI:NDPROI,1:NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('ZPNU1M','PROANG')
      ALLOCATE (ZTZISO(1:NDAKNO,-NDPROI:NDPROI,1:NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('ZTZISO','PROANG')
      ALLOCATE (ZT2ISO(1:NDAKNO,-NDPROI:NDPROI,1:NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('ZT2ISO','PROANG')
      ALLOCATE (ZBZROT(1:NDAKNO,-NDPROI:NDPROI,1:NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('ZBZROT','PROANG')
      ALLOCATE (ZB2ROT(1:NDAKNO,-NDPROI:NDPROI,1:NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('ZB2ROT','PROANG')
C
C=======================================================================
C           ALLOCATING ARRAYS FOR KERNEL INTEGRATION
C=======================================================================
C
C=======================================================================
C TER ALLOCATE (CTER_T(-NDPROI:NDPROI,-NDPROI:NDPROI,1:NUISOM,2*NDCOUT),
C TER*                                          STAT=IALLOC)
C TER IF (IALLOC.NE.0) CALL NOALLO('CTER_T','PROANG')
      ALLOCATE (CKER_T(-NDPROI:NDPROI,-NDPROI:NDPROI,1:NUISOM),
     *                                          STAT=IALLOC)
      IF (IALLOC.NE.0) CALL NOALLO('CKER_T','PROANG')
      ALLOCATE (CSKY_T(-NDPROI:NDPROI,-NDPROI:NDPROI,1:NUISOM),
     *                                          STAT=IALLOC)
      IF (IALLOC.NE.0) CALL NOALLO('CSKY_T','PROANG')
      ALLOCATE (CKIN_N(-NDPROI:NDPROI,-NDPROI:NDPROI,1:NUISOM),
     *                                          STAT=IALLOC)
      IF (IALLOC.NE.0) CALL NOALLO('CKIN_N','PROANG')
      ALLOCATE (CKIN_P(-NDPROI:NDPROI,-NDPROI:NDPROI,1:NUISOM),
     *                                          STAT=IALLOC)
      IF (IALLOC.NE.0) CALL NOALLO('CKIN_P','PROANG')
C=======================================================================
C FOR PAIRING
      ALLOCATE (CPAI_N(-NDPROI:NDPROI,-NDPROI:NDPROI,1:NUISOM),
     *                                          STAT=IALLOC)
      IF (IALLOC.NE.0) CALL NOALLO('CPAI_N','PROANG')
      ALLOCATE (CPAI_P(-NDPROI:NDPROI,-NDPROI:NDPROI,1:NUISOM),
     *                                          STAT=IALLOC)
      IF (IALLOC.NE.0) CALL NOALLO('CPAI_P','PROANG')
C=======================================================================
      ALLOCATE (CCOU_D(-NDPROI:NDPROI,-NDPROI:NDPROI,1:NUISOM),
     *                                          STAT=IALLOC)
      IF (IALLOC.NE.0) CALL NOALLO('CCOU_D','PROANG')
      ALLOCATE (CC10_D(-NDPROI:NDPROI,-NDPROI:NDPROI,1:NUISOM),
     *                                          STAT=IALLOC)
      IF (IALLOC.NE.0) CALL NOALLO('CC10_D','PROANG')
      ALLOCATE (CC1P_D(-NDPROI:NDPROI,-NDPROI:NDPROI,1:NUISOM),
     *                                          STAT=IALLOC)
      IF (IALLOC.NE.0) CALL NOALLO('CC1P_D','PROANG')
      ALLOCATE (CC1M_D(-NDPROI:NDPROI,-NDPROI:NDPROI,1:NUISOM),
     *                                          STAT=IALLOC)
      IF (IALLOC.NE.0) CALL NOALLO('CC1M_D','PROANG')
      ALLOCATE (CC20_D(-NDPROI:NDPROI,-NDPROI:NDPROI,1:NUISOM),
     *                                          STAT=IALLOC)
      IF (IALLOC.NE.0) CALL NOALLO('CC20_D','PROANG')
      ALLOCATE (CC21PD(-NDPROI:NDPROI,-NDPROI:NDPROI,1:NUISOM),
     *                                          STAT=IALLOC)
      IF (IALLOC.NE.0) CALL NOALLO('CC21PD','PROANG')
      ALLOCATE (CC21MD(-NDPROI:NDPROI,-NDPROI:NDPROI,1:NUISOM),
     *                                          STAT=IALLOC)
      IF (IALLOC.NE.0) CALL NOALLO('CC21MD','PROANG')
      ALLOCATE (CC22PD(-NDPROI:NDPROI,-NDPROI:NDPROI,1:NUISOM),
     *                                          STAT=IALLOC)
      IF (IALLOC.NE.0) CALL NOALLO('CC22PD','PROANG')
      ALLOCATE (CC22MD(-NDPROI:NDPROI,-NDPROI:NDPROI,1:NUISOM),
     *                                          STAT=IALLOC)
      IF (IALLOC.NE.0) CALL NOALLO('CC22MD','PROANG')
      ALLOCATE (CCOU_X(-NDPROI:NDPROI,-NDPROI:NDPROI,1:NUISOM),
     *                                          STAT=IALLOC)
      IF (IALLOC.NE.0) CALL NOALLO('CCOU_X','PROANG')
      ALLOCATE (CC10_X(-NDPROI:NDPROI,-NDPROI:NDPROI,1:NUISOM),
     *                                          STAT=IALLOC)
      IF (IALLOC.NE.0) CALL NOALLO('CC10_X','PROANG')
      ALLOCATE (CC1P_X(-NDPROI:NDPROI,-NDPROI:NDPROI,1:NUISOM),
     *                                          STAT=IALLOC)
      IF (IALLOC.NE.0) CALL NOALLO('CC1P_X','PROANG')
      ALLOCATE (CC1M_X(-NDPROI:NDPROI,-NDPROI:NDPROI,1:NUISOM),
     *                                          STAT=IALLOC)
      IF (IALLOC.NE.0) CALL NOALLO('CC1M_X','PROANG')
      ALLOCATE (CC20_X(-NDPROI:NDPROI,-NDPROI:NDPROI,1:NUISOM),
     *                                          STAT=IALLOC)
      IF (IALLOC.NE.0) CALL NOALLO('CC20_X','PROANG')
      ALLOCATE (CC21PX(-NDPROI:NDPROI,-NDPROI:NDPROI,1:NUISOM),
     *                                          STAT=IALLOC)
      IF (IALLOC.NE.0) CALL NOALLO('CC21PX','PROANG')
      ALLOCATE (CC21MX(-NDPROI:NDPROI,-NDPROI:NDPROI,1:NUISOM),
     *                                          STAT=IALLOC)
      IF (IALLOC.NE.0) CALL NOALLO('CC21MX','PROANG')
      ALLOCATE (CC22PX(-NDPROI:NDPROI,-NDPROI:NDPROI,1:NUISOM),
     *                                          STAT=IALLOC)
      IF (IALLOC.NE.0) CALL NOALLO('CC22PX','PROANG')
      ALLOCATE (CC22MX(-NDPROI:NDPROI,-NDPROI:NDPROI,1:NUISOM),
     *                                          STAT=IALLOC)
      IF (IALLOC.NE.0) CALL NOALLO('CC22MX','PROANG')
      ALLOCATE (CPNU00(-NDPROI:NDPROI,-NDPROI:NDPROI,1:NUISOM),
     *                                          STAT=IALLOC)
      IF (IALLOC.NE.0) CALL NOALLO('CPNU00','PROANG')
      ALLOCATE (CPNU10(-NDPROI:NDPROI,-NDPROI:NDPROI,1:NUISOM),
     *                                          STAT=IALLOC)
      IF (IALLOC.NE.0) CALL NOALLO('CPNU10','PROANG')
      ALLOCATE (CPNU1P(-NDPROI:NDPROI,-NDPROI:NDPROI,1:NUISOM),
     *                                          STAT=IALLOC)
      IF (IALLOC.NE.0) CALL NOALLO('CPNU1P','PROANG')
      ALLOCATE (CPNU1M(-NDPROI:NDPROI,-NDPROI:NDPROI,1:NUISOM),
     *                                          STAT=IALLOC)
      IF (IALLOC.NE.0) CALL NOALLO('CPNU1M','PROANG')
      ALLOCATE (CTZISO(-NDPROI:NDPROI,-NDPROI:NDPROI,1:NUISOM),
     *                                          STAT=IALLOC)
      IF (IALLOC.NE.0) CALL NOALLO('CTZISO','PROANG')
      ALLOCATE (CT2ISO(-NDPROI:NDPROI,-NDPROI:NDPROI,1:NUISOM),
     *                                          STAT=IALLOC)
      IF (IALLOC.NE.0) CALL NOALLO('CT2ISO','PROANG')
      ALLOCATE (CBZROT(-NDPROI:NDPROI,-NDPROI:NDPROI,1:NUISOM),
     *                                          STAT=IALLOC)
      IF (IALLOC.NE.0) CALL NOALLO('CBZROT','PROANG')
      ALLOCATE (CB2ROT(-NDPROI:NDPROI,-NDPROI:NDPROI,1:NUISOM),
     *                                          STAT=IALLOC)
      IF (IALLOC.NE.0) CALL NOALLO('CB2ROT','PROANG')
C
C=======================================================================
C
      DO J=1,NUBKNO
C
      DO INDISO=1,NUISOM
C
        DO I=1,NUAKNO
C
          DO KPROAC=-JPROMA,JPROMA,2
C
C=======================================================================
C         ZEROING AUXILIARY ARRAYS OF OVERLAP AND ENERGY KERNELS
C=======================================================================
C
C TER        DO NUCOUT=1,2*NDCOUT
C TER        ZTER_T(I,KPROAC,INDISO,NUCOUT)=C_ZERO
C TER        END DO
             ZKER_T(I,KPROAC,INDISO)=C_ZERO
C
             ZSKY_T(I,KPROAC,INDISO)=C_ZERO
             ZKIN_N(I,KPROAC,INDISO)=C_ZERO
             ZKIN_P(I,KPROAC,INDISO)=C_ZERO
C
             ZPAI_N(I,KPROAC,INDISO)=C_ZERO
             ZPAI_P(I,KPROAC,INDISO)=C_ZERO
C
             ZCOU_D(I,KPROAC,INDISO)=C_ZERO
             ZC10_D(I,KPROAC,INDISO)=C_ZERO
             ZC1P_D(I,KPROAC,INDISO)=C_ZERO
             ZC1M_D(I,KPROAC,INDISO)=C_ZERO
             ZC20_D(I,KPROAC,INDISO)=C_ZERO
             ZC21PD(I,KPROAC,INDISO)=C_ZERO
             ZC21MD(I,KPROAC,INDISO)=C_ZERO
             ZC22PD(I,KPROAC,INDISO)=C_ZERO
             ZC22MD(I,KPROAC,INDISO)=C_ZERO
C
             ZCOU_X(I,KPROAC,INDISO)=C_ZERO
             ZC10_X(I,KPROAC,INDISO)=C_ZERO
             ZC1P_X(I,KPROAC,INDISO)=C_ZERO
             ZC1M_X(I,KPROAC,INDISO)=C_ZERO
             ZC20_X(I,KPROAC,INDISO)=C_ZERO
             ZC21PX(I,KPROAC,INDISO)=C_ZERO
             ZC21MX(I,KPROAC,INDISO)=C_ZERO
             ZC22PX(I,KPROAC,INDISO)=C_ZERO
             ZC22MX(I,KPROAC,INDISO)=C_ZERO
C
             ZPNU00(I,KPROAC,INDISO)=C_ZERO
             ZPNU10(I,KPROAC,INDISO)=C_ZERO
             ZPNU1P(I,KPROAC,INDISO)=C_ZERO
             ZPNU1M(I,KPROAC,INDISO)=C_ZERO
C
             ZTZISO(I,KPROAC,INDISO)=C_ZERO
             ZT2ISO(I,KPROAC,INDISO)=C_ZERO
C
             ZBZROT(I,KPROAC,INDISO)=C_ZERO
             ZB2ROT(I,KPROAC,INDISO)=C_ZERO
C
C=======================================================================
C         ZEROING AUXILIARY ARRAYS OF MULTIPOLE, MAGNETIC, SPIN-ASY, AND
C         SURFACE OR SCHIFF MOMENTS. THESE ARRAYS WILL BE USED ONLY WHEN
C         THERE IS NO PROJECTION ON THE ISOSPIN
C=======================================================================
C
             IF (NBTKNO.EQ.1) THEN
C
                 DO LAMBDA=0,NDMULR
                    DO MIU=-LAMBDA,LAMBDA
C
                      ZMUL_P(I,KPROAC,IND_LM(LAMBDA,MIU))  =C_ZERO
                      ZMAG_T(I,KPROAC,IND_LM(LAMBDA,MIU),:)=C_ZERO
                      ZSIF_P(I,KPROAC,IND_LM(LAMBDA,MIU))  =C_ZERO
                      IF (NASORD.GE.0)
     *                ZASM_T(I,KPROAC,IND_LM(LAMBDA,MIU),:)=C_ZERO
C
                    END DO
                 END DO
C
             END IF
C
C=======================================================================
C         BELOW WE INTEGRATE KERNELS OVER THE GAMMA EULER ANGLE AND
C         AT THE SAME TIME WE MULTIPLY THEM BY THE  GAUSS  WEIGHTS
C=======================================================================
C
              DO K=1,NUAKNO
C
                 GAMM_K=XA_PNT(K)*0.5D0*KPROAC
C
                 FACINT=XA_WGT(K)*(COS(GAMM_K)+UNIT_I*SIN(GAMM_K))
C
C=======================================================================
C                    INTEGRATING THE NORM KERNEL
C=======================================================================
C
C TER        DO NUCOUT=1,2*NDCOUT
C TER      ZTER_T(I,KPROAC,INDISO,NUCOUT)=ZTER_T(I,KPROAC,INDISO,NUCOUT)
C TER*                               +FACINT*TETERN(I,J,K,INDISO,NUCOUT)
C TER        END DO
                 ZKER_T(I,KPROAC,INDISO)=ZKER_T(I,KPROAC,INDISO)
     *                              +FACINT*OVTERN(I,J,K,INDISO)
C
C=======================================================================
C                    INTEGRATING THE ENERGY KERNELS
C=======================================================================
C
                 ZSKY_T(I,KPROAC,INDISO)=ZSKY_T(I,KPROAC,INDISO)
     *                              +FACINT*SKTERN(I,J,K,INDISO)
C
                 IF (NBTKNO.EQ.1) THEN
                     ZKIN_N(I,KPROAC,INDISO)=ZKIN_N(I,KPROAC,INDISO)
     *                               +FACINT*EKTERN(I,J,K,0)
                     ZKIN_P(I,KPROAC,INDISO)=ZKIN_P(I,KPROAC,INDISO)
     *                               +FACINT*EKTERN(I,J,K,1)
C
                     ZPAI_N(I,KPROAC,INDISO)=ZPAI_N(I,KPROAC,INDISO)
     *                               +FACINT*EPTERN(I,J,K,0)
                     ZPAI_P(I,KPROAC,INDISO)=ZPAI_P(I,KPROAC,INDISO)
     *                               +FACINT*EPTERN(I,J,K,1)
C
                 ELSE
                     ZKIN_N(I,KPROAC,INDISO)=ZKIN_N(I,KPROAC,INDISO)
     *                                  +FACINT*EKTERN(I,J,K,INDISO)
                     ZKIN_P(I,KPROAC,INDISO)=C_ZERO
                 END IF
C
                 ZCOU_D(I,KPROAC,INDISO)=ZCOU_D(I,KPROAC,INDISO)
     *                              +FACINT*CDTERN(I,J,K,INDISO)
                 ZC10_D(I,KPROAC,INDISO)=ZC10_D(I,KPROAC,INDISO)
     *                              +FACINT*CDTE10(I,J,K,INDISO)
                 ZC1P_D(I,KPROAC,INDISO)=ZC1P_D(I,KPROAC,INDISO)
     *                              +FACINT*CDTE1P(I,J,K,INDISO)
                 ZC1M_D(I,KPROAC,INDISO)=ZC1M_D(I,KPROAC,INDISO)
     *                              +FACINT*CDTE1M(I,J,K,INDISO)
                 ZC20_D(I,KPROAC,INDISO)=ZC20_D(I,KPROAC,INDISO)
     *                              +FACINT*CDTE20(I,J,K,INDISO)
                 ZC21PD(I,KPROAC,INDISO)=ZC21PD(I,KPROAC,INDISO)
     *                              +FACINT*CDT21P(I,J,K,INDISO)
                 ZC21MD(I,KPROAC,INDISO)=ZC21MD(I,KPROAC,INDISO)
     *                              +FACINT*CDT21M(I,J,K,INDISO)
                 ZC22PD(I,KPROAC,INDISO)=ZC22PD(I,KPROAC,INDISO)
     *                              +FACINT*CDT22P(I,J,K,INDISO)
                 ZC22MD(I,KPROAC,INDISO)=ZC22MD(I,KPROAC,INDISO)
     *                              +FACINT*CDT22M(I,J,K,INDISO)
C
                 ZCOU_X(I,KPROAC,INDISO)=ZCOU_X(I,KPROAC,INDISO)
     *                              +FACINT*CXTERN(I,J,K,INDISO)
                 ZC10_X(I,KPROAC,INDISO)=ZC10_X(I,KPROAC,INDISO)
     *                              +FACINT*CXTE10(I,J,K,INDISO)
                 ZC1P_X(I,KPROAC,INDISO)=ZC1P_X(I,KPROAC,INDISO)
     *                              +FACINT*CXTE1P(I,J,K,INDISO)
                 ZC1M_X(I,KPROAC,INDISO)=ZC1M_X(I,KPROAC,INDISO)
     *                              +FACINT*CXTE1M(I,J,K,INDISO)
                 ZC20_X(I,KPROAC,INDISO)=ZC20_X(I,KPROAC,INDISO)
     *                              +FACINT*CXTE20(I,J,K,INDISO)
                 ZC21PX(I,KPROAC,INDISO)=ZC21PX(I,KPROAC,INDISO)
     *                              +FACINT*CXT21P(I,J,K,INDISO)
                 ZC21MX(I,KPROAC,INDISO)=ZC21MX(I,KPROAC,INDISO)
     *                              +FACINT*CXT21M(I,J,K,INDISO)
                 ZC22PX(I,KPROAC,INDISO)=ZC22PX(I,KPROAC,INDISO)
     *                              +FACINT*CXT22P(I,J,K,INDISO)
                 ZC22MX(I,KPROAC,INDISO)=ZC22MX(I,KPROAC,INDISO)
     *                              +FACINT*CXT22M(I,J,K,INDISO)
C
                 ZPNU00(I,KPROAC,INDISO)=ZPNU00(I,KPROAC,INDISO)
     *                              +FACINT*PNTE00(I,J,K,INDISO)
                 ZPNU10(I,KPROAC,INDISO)=ZPNU10(I,KPROAC,INDISO)
     *                              +FACINT*PNTE10(I,J,K,INDISO)
                 ZPNU1P(I,KPROAC,INDISO)=ZPNU1P(I,KPROAC,INDISO)
     *                              +FACINT*PNTE1P(I,J,K,INDISO)
                 ZPNU1M(I,KPROAC,INDISO)=ZPNU1M(I,KPROAC,INDISO)
     *                              +FACINT*PNTE1M(I,J,K,INDISO)
C
                 ZTZISO(I,KPROAC,INDISO)=ZTZISO(I,KPROAC,INDISO)
     *                              +FACINT*TZTERN(I,J,K,INDISO)
                 ZT2ISO(I,KPROAC,INDISO)=ZT2ISO(I,KPROAC,INDISO)
     *                              +FACINT*T2TERN(I,J,K,INDISO)
C
                 ZBZROT(I,KPROAC,INDISO)=ZBZROT(I,KPROAC,INDISO)
     *                              +FACINT*BZTERN(I,J,K,INDISO)
                 ZB2ROT(I,KPROAC,INDISO)=ZB2ROT(I,KPROAC,INDISO)
     *                              +FACINT*B2TERN(I,J,K,INDISO)
C
                 IF (NBTKNO.EQ.1) THEN
C
                            FACMOM=OVKERN(I,J,K,1,1,1)*4.0D0*PI*PI
C
C=======================================================================
C             INTEGRATING THE KERNELS OF THE MULTIPOLE MOMENTS
C=======================================================================
C
                     DO LAMBDA=0,NMURED
                        DO MIU=-LAMBDA,LAMBDA
C
                        ZMUL_P(I,KPROAC,IND_LM(LAMBDA,MIU))=
     *                  ZMUL_P(I,KPROAC,IND_LM(LAMBDA,MIU))
     *                                                    +FACINT*FACMOM
     *                                 *QPKERN(I,J,K,IND_LM(LAMBDA,MIU))
C
                        END DO
                     END DO
C
C=======================================================================
C                    INTEGRATING THE KERNELS OF THE MAGNETIC MOMENTS
C=======================================================================
C
                     DO LAMBDA=1,NMARED
                        DO MIU=-LAMBDA,LAMBDA
                           ZMAG_T(I,KPROAC,IND_LM(LAMBDA,MIU),:)=
     *                     ZMAG_T(I,KPROAC,IND_LM(LAMBDA,MIU),:)
     *                                                    +FACINT*FACMOM
     *                       *ATKERN(I,J,K,IND_LM(LAMBDA,MIU),:)
C
C     WRITE (*,'(3I4,I5,I5,I3,4(3X,2D15.7))')
C    *               I,J,K,KPROAC,LAMBDA,MIU,
C    *               FACINT,FACMOM,FACINT*FACMOM,
C    *               ATKERN(I,J,K,IND_LM(LAMBDA,MIU),0)
C
                        END DO
                     END DO
C
C=======================================================================
C                    INTEGRATING THE KERNELS OF THE SPIN-ASYMM. MOMENTS
C=======================================================================
C
                     IF (NASORD.GE.0) THEN
C
                         DO LAMBDA=1,NASRED
                            DO MIU=-LAMBDA,LAMBDA
                               ZASM_T(I,KPROAC,IND_LM(LAMBDA,MIU),:)=
     *                         ZASM_T(I,KPROAC,IND_LM(LAMBDA,MIU),:)
     *                                                    +FACINT*FACMOM
     *                           *WTKERN(I,J,K,IND_LM(LAMBDA,MIU),:)
C
                            END DO
                         END DO
C
                     END IF
C
C=======================================================================
C                    INTEGRATING THE KERNELS OF THE SURFACE OR SCHIFF
C                    MOMENTS
C=======================================================================
C
                     DO LAMBDA=NSIMIN,NSIRED
                        DO MIU=-LAMBDA,LAMBDA
C
                        ZSIF_P(I,KPROAC,IND_LM(LAMBDA,MIU))=
     *                  ZSIF_P(I,KPROAC,IND_LM(LAMBDA,MIU))
     *                                                    +FACINT*FACMOM
     *                                 *SPKERN(I,J,K,IND_LM(LAMBDA,MIU))
C
                        END DO
                     END DO
C
                 END IF
C
C=======================================================================
C           HERE END THE LOOPS  OVER THE  GAMMA  GAUSS  KNOTS
C         AND THE LOOP OVER THE K PROJECTION ON THE INTRINSIC AXIS
C=======================================================================
C
              END DO
           END DO
C
C=======================================================================
C           HERE END THE LOOPS  OVER THE  ALPHA  GAUSS  KNOTS
C=======================================================================
C
        END DO
C
C=======================================================================
C         HERE STARTS THE LOOP OVER THE K' PROJECTION ON THE INTRINSIC
C         AXIS; INDEX "LPROAC", AND OVER THE K PROJECTION ON THE
C         INTRINSIC AXIS; INDEX "KPROAC".
C=======================================================================
C
        DO LPROAC=-JPROMA,JPROMA,2
C
           DO KPROAC=-JPROMA,JPROMA,2
C
C=======================================================================
C         ZEROING AUXILIARY ARRAYS OF OVERLAP AND ENERGY KERNELS
C=======================================================================
C
C TER        DO NUCOUT=1,2*NDCOUT
C TER         CTER_T(LPROAC,KPROAC,INDISO,NUCOUT)=C_ZERO
C TER        END DO
              CKER_T(LPROAC,KPROAC,INDISO)=C_ZERO
C
              CSKY_T(LPROAC,KPROAC,INDISO)=C_ZERO
              CKIN_N(LPROAC,KPROAC,INDISO)=C_ZERO
              CKIN_P(LPROAC,KPROAC,INDISO)=C_ZERO
C
              CPAI_N(LPROAC,KPROAC,INDISO)=C_ZERO
              CPAI_P(LPROAC,KPROAC,INDISO)=C_ZERO
C
              CCOU_D(LPROAC,KPROAC,INDISO)=C_ZERO
              CC10_D(LPROAC,KPROAC,INDISO)=C_ZERO
              CC1P_D(LPROAC,KPROAC,INDISO)=C_ZERO
              CC1M_D(LPROAC,KPROAC,INDISO)=C_ZERO
              CC20_D(LPROAC,KPROAC,INDISO)=C_ZERO
              CC21PD(LPROAC,KPROAC,INDISO)=C_ZERO
              CC21MD(LPROAC,KPROAC,INDISO)=C_ZERO
              CC22PD(LPROAC,KPROAC,INDISO)=C_ZERO
              CC22MD(LPROAC,KPROAC,INDISO)=C_ZERO
C
              CCOU_X(LPROAC,KPROAC,INDISO)=C_ZERO
              CC10_X(LPROAC,KPROAC,INDISO)=C_ZERO
              CC1P_X(LPROAC,KPROAC,INDISO)=C_ZERO
              CC1M_X(LPROAC,KPROAC,INDISO)=C_ZERO
              CC20_X(LPROAC,KPROAC,INDISO)=C_ZERO
              CC21PX(LPROAC,KPROAC,INDISO)=C_ZERO
              CC21MX(LPROAC,KPROAC,INDISO)=C_ZERO
              CC22PX(LPROAC,KPROAC,INDISO)=C_ZERO
              CC22MX(LPROAC,KPROAC,INDISO)=C_ZERO
C
              CPNU00(LPROAC,KPROAC,INDISO)=C_ZERO
              CPNU10(LPROAC,KPROAC,INDISO)=C_ZERO
              CPNU1P(LPROAC,KPROAC,INDISO)=C_ZERO
              CPNU1M(LPROAC,KPROAC,INDISO)=C_ZERO
C
              CTZISO(LPROAC,KPROAC,INDISO)=C_ZERO
              CT2ISO(LPROAC,KPROAC,INDISO)=C_ZERO
C
              CBZROT(LPROAC,KPROAC,INDISO)=C_ZERO
              CB2ROT(LPROAC,KPROAC,INDISO)=C_ZERO
C
C=======================================================================
C         ZEROING AUXILIARY ARRAYS OF MULTIPOLE, MAGNETIC, SPIN-ASY, AND
C         SURFACE MOMENTS
C=======================================================================
C
              IF (NBTKNO.EQ.1) THEN
C
                  DO LAMBDA=0,NDMULR
                     DO MIU=-LAMBDA,LAMBDA
C
                       CMUL_P(LPROAC,KPROAC,IND_LM(LAMBDA,MIU))  =C_ZERO
                       CMAG_T(LPROAC,KPROAC,IND_LM(LAMBDA,MIU),:)=C_ZERO
                       CSIF_P(LPROAC,KPROAC,IND_LM(LAMBDA,MIU))  =C_ZERO
                       IF (NASORD.GE.0)
     *                 CASM_T(LPROAC,KPROAC,IND_LM(LAMBDA,MIU),:)=C_ZERO
C
                     END DO
                  END DO
C
              END IF
C
C=======================================================================
C         HERE WE INTEGRATE THE KERNELS OVER THE ALPHA EULER ANGLE
C=======================================================================
C
              DO I=1,NUAKNO
C
                 ALPH_L=XA_PNT(I)*0.5D0*LPROAC
                 FACINT=XA_WGT(I)*(COS(ALPH_L)+UNIT_I*SIN(ALPH_L))
C
C TER        DO NUCOUT=1,2*NDCOUT
C TER            CTER_T(LPROAC,KPROAC,INDISO,NUCOUT)=
C TER*           CTER_T(LPROAC,KPROAC,INDISO,NUCOUT)
C TER*                            +FACINT*ZTER_T(I,KPROAC,INDISO,NUCOUT)
C TER        END DO
                 CKER_T(LPROAC,KPROAC,INDISO)=
     *           CKER_T(LPROAC,KPROAC,INDISO)
     *                                 +FACINT*ZKER_T(I,KPROAC,INDISO)
C
                 CSKY_T(LPROAC,KPROAC,INDISO)=
     *           CSKY_T(LPROAC,KPROAC,INDISO)
     *                                 +FACINT*ZSKY_T(I,KPROAC,INDISO)
                 CKIN_N(LPROAC,KPROAC,INDISO)=
     *           CKIN_N(LPROAC,KPROAC,INDISO)
     *                                 +FACINT*ZKIN_N(I,KPROAC,INDISO)
                 CKIN_P(LPROAC,KPROAC,INDISO)=
     *           CKIN_P(LPROAC,KPROAC,INDISO)
     *                                 +FACINT*ZKIN_P(I,KPROAC,INDISO)
C
                 CPAI_N(LPROAC,KPROAC,INDISO)=
     *           CPAI_N(LPROAC,KPROAC,INDISO)
     *                                 +FACINT*ZPAI_N(I,KPROAC,INDISO)
                 CPAI_P(LPROAC,KPROAC,INDISO)=
     *           CPAI_P(LPROAC,KPROAC,INDISO)
     *                                 +FACINT*ZPAI_P(I,KPROAC,INDISO)
C
                 CCOU_D(LPROAC,KPROAC,INDISO)=
     *           CCOU_D(LPROAC,KPROAC,INDISO)
     *                                 +FACINT*ZCOU_D(I,KPROAC,INDISO)
                 CC10_D(LPROAC,KPROAC,INDISO)=
     *           CC10_D(LPROAC,KPROAC,INDISO)
     *                                 +FACINT*ZC10_D(I,KPROAC,INDISO)
                 CC1P_D(LPROAC,KPROAC,INDISO)=
     *           CC1P_D(LPROAC,KPROAC,INDISO)
     *                                 +FACINT*ZC1P_D(I,KPROAC,INDISO)
                 CC1M_D(LPROAC,KPROAC,INDISO)=
     *           CC1M_D(LPROAC,KPROAC,INDISO)
     *                                 +FACINT*ZC1M_D(I,KPROAC,INDISO)
                 CC20_D(LPROAC,KPROAC,INDISO)=
     *           CC20_D(LPROAC,KPROAC,INDISO)
     *                                 +FACINT*ZC20_D(I,KPROAC,INDISO)
                 CC21PD(LPROAC,KPROAC,INDISO)=
     *           CC21PD(LPROAC,KPROAC,INDISO)
     *                                 +FACINT*ZC21PD(I,KPROAC,INDISO)
                 CC21MD(LPROAC,KPROAC,INDISO)=
     *           CC21MD(LPROAC,KPROAC,INDISO)
     *                                 +FACINT*ZC21MD(I,KPROAC,INDISO)
                 CC22PD(LPROAC,KPROAC,INDISO)=
     *           CC22PD(LPROAC,KPROAC,INDISO)
     *                                 +FACINT*ZC22PD(I,KPROAC,INDISO)
                 CC22MD(LPROAC,KPROAC,INDISO)=
     *           CC22MD(LPROAC,KPROAC,INDISO)
     *                                 +FACINT*ZC22MD(I,KPROAC,INDISO)
C
                 CCOU_X(LPROAC,KPROAC,INDISO)=
     *           CCOU_X(LPROAC,KPROAC,INDISO)
     *                                 +FACINT*ZCOU_X(I,KPROAC,INDISO)
                 CC10_X(LPROAC,KPROAC,INDISO)=
     *           CC10_X(LPROAC,KPROAC,INDISO)
     *                                 +FACINT*ZC10_X(I,KPROAC,INDISO)
                 CC1P_X(LPROAC,KPROAC,INDISO)=
     *           CC1P_X(LPROAC,KPROAC,INDISO)
     *                                 +FACINT*ZC1P_X(I,KPROAC,INDISO)
                 CC1M_X(LPROAC,KPROAC,INDISO)=
     *           CC1M_X(LPROAC,KPROAC,INDISO)
     *                                 +FACINT*ZC1M_X(I,KPROAC,INDISO)
                 CC20_X(LPROAC,KPROAC,INDISO)=
     *           CC20_X(LPROAC,KPROAC,INDISO)
     *                                 +FACINT*ZC20_X(I,KPROAC,INDISO)
                 CC21PX(LPROAC,KPROAC,INDISO)=
     *           CC21PX(LPROAC,KPROAC,INDISO)
     *                                 +FACINT*ZC21PX(I,KPROAC,INDISO)
                 CC21MX(LPROAC,KPROAC,INDISO)=
     *           CC21MX(LPROAC,KPROAC,INDISO)
     *                                 +FACINT*ZC21MX(I,KPROAC,INDISO)
                 CC22PX(LPROAC,KPROAC,INDISO)=
     *           CC22PX(LPROAC,KPROAC,INDISO)
     *                                 +FACINT*ZC22PX(I,KPROAC,INDISO)
                 CC22MX(LPROAC,KPROAC,INDISO)=
     *           CC22MX(LPROAC,KPROAC,INDISO)
     *                                 +FACINT*ZC22MX(I,KPROAC,INDISO)
C
                 CPNU00(LPROAC,KPROAC,INDISO)=
     *           CPNU00(LPROAC,KPROAC,INDISO)
     *                                 +FACINT*ZPNU00(I,KPROAC,INDISO)
                 CPNU10(LPROAC,KPROAC,INDISO)=
     *           CPNU10(LPROAC,KPROAC,INDISO)
     *                                 +FACINT*ZPNU10(I,KPROAC,INDISO)
                 CPNU1P(LPROAC,KPROAC,INDISO)=
     *           CPNU1P(LPROAC,KPROAC,INDISO)
     *                                 +FACINT*ZPNU1P(I,KPROAC,INDISO)
                 CPNU1M(LPROAC,KPROAC,INDISO)=
     *           CPNU1M(LPROAC,KPROAC,INDISO)
     *                                 +FACINT*ZPNU1M(I,KPROAC,INDISO)
C
                 CTZISO(LPROAC,KPROAC,INDISO)=
     *           CTZISO(LPROAC,KPROAC,INDISO)
     *                                 +FACINT*ZTZISO(I,KPROAC,INDISO)
                 CT2ISO(LPROAC,KPROAC,INDISO)=
     *           CT2ISO(LPROAC,KPROAC,INDISO)
     *                                 +FACINT*ZT2ISO(I,KPROAC,INDISO)
C
                 CBZROT(LPROAC,KPROAC,INDISO)=
     *           CBZROT(LPROAC,KPROAC,INDISO)
     *                                 +FACINT*ZBZROT(I,KPROAC,INDISO)
                 CB2ROT(LPROAC,KPROAC,INDISO)=
     *           CB2ROT(LPROAC,KPROAC,INDISO)
     *                                 +FACINT*ZB2ROT(I,KPROAC,INDISO)
C
C=======================================================================
C                    INTEGRATING KERNELS OF THE MULTIPOLE MOMENTS
C=======================================================================
C
                 IF (NBTKNO.EQ.1) THEN
C
                     DO LAMBDA=0,NMURED
                        DO MIU=-LAMBDA,LAMBDA
C
                        CMUL_P(LPROAC,KPROAC,IND_LM(LAMBDA,MIU))=
     *                  CMUL_P(LPROAC,KPROAC,IND_LM(LAMBDA,MIU))
     *                      +FACINT*ZMUL_P(I,KPROAC,IND_LM(LAMBDA,MIU))
C
                        END DO
                     END DO
C
C=======================================================================
C                    INTEGRATING KERNELS OF THE MAGNETIC MOMENTS
C=======================================================================
C
                     DO LAMBDA=1,NMARED
                        DO MIU=-LAMBDA,LAMBDA
C
                           CMAG_T(LPROAC,KPROAC,IND_LM(LAMBDA,MIU),:)=
     *                     CMAG_T(LPROAC,KPROAC,IND_LM(LAMBDA,MIU),:)
     *                  +FACINT*ZMAG_T(I,KPROAC,IND_LM(LAMBDA,MIU),:)
C
                        END DO
                     END DO
C
C=======================================================================
C                    INTEGRATING KERNELS OF THE SPIN-ASYMMETRY MOMENTS
C=======================================================================
C
                     IF (NASORD.GE.0) THEN
C
                       DO LAMBDA=1,NASRED
                          DO MIU=-LAMBDA,LAMBDA
C
                             CASM_T(LPROAC,KPROAC,IND_LM(LAMBDA,MIU),:)=
     *                       CASM_T(LPROAC,KPROAC,IND_LM(LAMBDA,MIU),:)
     *                    +FACINT*ZASM_T(I,KPROAC,IND_LM(LAMBDA,MIU),:)
C
                          END DO
                       END DO
C
                     END IF
C
C=======================================================================
C                    INTEGRATING KERNELS OF THE SURFACE OR SCHIFF
C                    MOMENTS
C=======================================================================
C
                     DO LAMBDA=NSIMIN,NSIRED
                        DO MIU=-LAMBDA,LAMBDA
C
                        CSIF_P(LPROAC,KPROAC,IND_LM(LAMBDA,MIU))=
     *                  CSIF_P(LPROAC,KPROAC,IND_LM(LAMBDA,MIU))
     *                      +FACINT*ZSIF_P(I,KPROAC,IND_LM(LAMBDA,MIU))
C
                        END DO
                     END DO
C
                 END IF
C
C=======================================================================
C         HERE ENDS THE LOOP OVER THE ALPHA GAUSS KNOTS (I), THE
C         LOOPS OVER THE L AND K PROJECTIONS ON THE INTRINSIC AXIS
C=======================================================================
C
              END DO
C
           END DO
        END DO
C
C=======================================================================
C              HERE STARTS THE LOOP OVER THE ANGULAR MOMENTA
C                 AND FINAL INTEGRATION OVER BETA (J)
C=======================================================================
C
        DO INDPRO=1,NUPROM
C
           IPROAC=IROMAT(INDPRO)
           LPROAC=LROMAT(INDPRO)
           KPROAC=KROMAT(INDPRO)
C
           FACINT=XB_WGT(J)*DSMALH(IPROAC,LPROAC,KPROAC,
     *                                   XB_PNT(J),NEWWIG,ISWIND,NUANGU)
C
C TER        DO NUCOUT=1,2*NDCOUT
C TER      TTE_TT(INDPRO,INDISO,NUCOUT)=TTE_TT(INDPRO,INDISO,NUCOUT)
C TER*                   +FACINT*CTER_T(LPROAC,KPROAC,INDISO,NUCOUT)
C TER        END DO
           TKE_TT(INDPRO,INDISO)=TKE_TT(INDPRO,INDISO)
     *            +FACINT*CKER_T(LPROAC,KPROAC,INDISO)
C
           TSK_TT(INDPRO,INDISO)=TSK_TT(INDPRO,INDISO)
     *            +FACINT*CSKY_T(LPROAC,KPROAC,INDISO)
           TKI_NT(INDPRO,INDISO)=TKI_NT(INDPRO,INDISO)
     *            +FACINT*CKIN_N(LPROAC,KPROAC,INDISO)
           TKI_PT(INDPRO,INDISO)=TKI_PT(INDPRO,INDISO)
     *            +FACINT*CKIN_P(LPROAC,KPROAC,INDISO)
C
           TPA_NT(INDPRO,INDISO)=TPA_NT(INDPRO,INDISO)
     *            +FACINT*CPAI_N(LPROAC,KPROAC,INDISO)
           TPA_PT(INDPRO,INDISO)=TPA_PT(INDPRO,INDISO)
     *            +FACINT*CPAI_P(LPROAC,KPROAC,INDISO)
C
           TCO_DT(INDPRO,INDISO)=TCO_DT(INDPRO,INDISO)
     *            +FACINT*CCOU_D(LPROAC,KPROAC,INDISO)
           TC1_D0(INDPRO,INDISO)=TC1_D0(INDPRO,INDISO)
     *            +FACINT*CC10_D(LPROAC,KPROAC,INDISO)
           TC1_DP(INDPRO,INDISO)=TC1_DP(INDPRO,INDISO)
     *            +FACINT*CC1P_D(LPROAC,KPROAC,INDISO)
           TC1_DM(INDPRO,INDISO)=TC1_DM(INDPRO,INDISO)
     *            +FACINT*CC1M_D(LPROAC,KPROAC,INDISO)
           TC2_D0(INDPRO,INDISO)=TC2_D0(INDPRO,INDISO)
     *            +FACINT*CC20_D(LPROAC,KPROAC,INDISO)
           TC21DP(INDPRO,INDISO)=TC21DP(INDPRO,INDISO)
     *            +FACINT*CC21PD(LPROAC,KPROAC,INDISO)
           TC21DM(INDPRO,INDISO)=TC21DM(INDPRO,INDISO)
     *            +FACINT*CC21MD(LPROAC,KPROAC,INDISO)
           TC22DP(INDPRO,INDISO)=TC22DP(INDPRO,INDISO)
     *            +FACINT*CC22PD(LPROAC,KPROAC,INDISO)
           TC22DM(INDPRO,INDISO)=TC22DM(INDPRO,INDISO)
     *            +FACINT*CC22MD(LPROAC,KPROAC,INDISO)
C
           TCO_XT(INDPRO,INDISO)=TCO_XT(INDPRO,INDISO)
     *            +FACINT*CCOU_X(LPROAC,KPROAC,INDISO)
           TC1_X0(INDPRO,INDISO)=TC1_X0(INDPRO,INDISO)
     *            +FACINT*CC10_X(LPROAC,KPROAC,INDISO)
           TC1_XP(INDPRO,INDISO)=TC1_XP(INDPRO,INDISO)
     *            +FACINT*CC1P_X(LPROAC,KPROAC,INDISO)
           TC1_XM(INDPRO,INDISO)=TC1_XM(INDPRO,INDISO)
     *            +FACINT*CC1M_X(LPROAC,KPROAC,INDISO)
           TC2_X0(INDPRO,INDISO)=TC2_X0(INDPRO,INDISO)
     *            +FACINT*CC20_X(LPROAC,KPROAC,INDISO)
           TC21XP(INDPRO,INDISO)=TC21XP(INDPRO,INDISO)
     *            +FACINT*CC21PX(LPROAC,KPROAC,INDISO)
           TC21XM(INDPRO,INDISO)=TC21XM(INDPRO,INDISO)
     *            +FACINT*CC21MX(LPROAC,KPROAC,INDISO)
           TC22XP(INDPRO,INDISO)=TC22XP(INDPRO,INDISO)
     *            +FACINT*CC22PX(LPROAC,KPROAC,INDISO)
           TC22XM(INDPRO,INDISO)=TC22XM(INDPRO,INDISO)
     *            +FACINT*CC22MX(LPROAC,KPROAC,INDISO)
C
           TPN_00(INDPRO,INDISO)=TPN_00(INDPRO,INDISO)
     *            +FACINT*CPNU00(LPROAC,KPROAC,INDISO)
           TPN_10(INDPRO,INDISO)=TPN_10(INDPRO,INDISO)
     *            +FACINT*CPNU10(LPROAC,KPROAC,INDISO)
           TPN_1P(INDPRO,INDISO)=TPN_1P(INDPRO,INDISO)
     *            +FACINT*CPNU1P(LPROAC,KPROAC,INDISO)
           TPN_1M(INDPRO,INDISO)=TPN_1M(INDPRO,INDISO)
     *            +FACINT*CPNU1M(LPROAC,KPROAC,INDISO)
C
           TTZ_IS(INDPRO,INDISO)=TTZ_IS(INDPRO,INDISO)
     *            +FACINT*CTZISO(LPROAC,KPROAC,INDISO)
           TT2_IS(INDPRO,INDISO)=TT2_IS(INDPRO,INDISO)
     *            +FACINT*CT2ISO(LPROAC,KPROAC,INDISO)
C
           TBZ_RO(INDPRO,INDISO)=TBZ_RO(INDPRO,INDISO)
     *            +FACINT*CBZROT(LPROAC,KPROAC,INDISO)
           TB2_RO(INDPRO,INDISO)=TB2_RO(INDPRO,INDISO)
     *            +FACINT*CB2ROT(LPROAC,KPROAC,INDISO)
C
C=======================================================================
C    HERE END THE FIRST LOOPS OVER THE ANGULAR MOMENTA AND PROJECTIONS
C=======================================================================
C
        END DO
C
C=======================================================================
C                    INTEGRATING KERNELS OF THE MULTIPOLE MOMENTS
C=======================================================================
C
        IF (NBTKNO.EQ.1.AND.(IKEPRI.EQ.1.OR.IRMPRI.EQ.1)) THEN
C
            DO IREPRO=1,NUPREM
C
               IPROAC=IREMAT(IREPRO)
               LPROAC=LREMAT(IREPRO)
               KPROAC=KREMAT(IREPRO)
C
               FACINT=XB_WGT(J)*DSMALH(IPROAC,LPROAC,KPROAC,
     *                                   XB_PNT(J),NEWWIG,ISWIND,NUANGU)
C
               DO LAMBDA=0,NMURED
                  DO MIU=-LAMBDA,LAMBDA
C
                     TMUL_P(IND_LM(LAMBDA,MIU),IREPRO)=
     *               TMUL_P(IND_LM(LAMBDA,MIU),IREPRO)
     *                  +FACINT*CMUL_P(LPROAC,KPROAC,IND_LM(LAMBDA,MIU))
C
                  END DO
               END DO
C
C=======================================================================
C                    INTEGRATING KERNELS OF THE MAGNETIC MOMENTS
C=======================================================================
C
               DO LAMBDA=1,NMARED
                  DO MIU=-LAMBDA,LAMBDA
C
                     TMAG_T(IND_LM(LAMBDA,MIU),IREPRO,:)=
     *               TMAG_T(IND_LM(LAMBDA,MIU),IREPRO,:)
     *                +FACINT*CMAG_T(LPROAC,KPROAC,IND_LM(LAMBDA,MIU),:)
C
                  END DO
               END DO
C
C=======================================================================
C                    INTEGRATING KERNELS OF THE SPIN-ASYMMETRY MOMENTS
C=======================================================================
C
               IF (NASORD.GE.0) THEN
C
                   DO LAMBDA=1,NASRED
                      DO MIU=-LAMBDA,LAMBDA
C
                         TASM_T(IND_LM(LAMBDA,MIU),IREPRO,:)=
     *                   TASM_T(IND_LM(LAMBDA,MIU),IREPRO,:)
     *                +FACINT*CASM_T(LPROAC,KPROAC,IND_LM(LAMBDA,MIU),:)
C
                      END DO
                   END DO
C
               END IF
C
C=======================================================================
C                    INTEGRATING KERNELS OF THE SURFACE OR SCHIFF
C                    MOMENTS
C=======================================================================
C
               DO LAMBDA=NSIMIN,NSIRED
                  DO MIU=-LAMBDA,LAMBDA
C
                     TSIF_P(IND_LM(LAMBDA,MIU),IREPRO)=
     *               TSIF_P(IND_LM(LAMBDA,MIU),IREPRO)
     *                  +FACINT*CSIF_P(LPROAC,KPROAC,IND_LM(LAMBDA,MIU))
C
                  END DO
               END DO
C
C=======================================================================
C    HERE END THE SECOND LOOPS OVER THE ANGULAR MOMENTA AND PROJECTIONS
C=======================================================================
C
           END DO
C
        END IF
C
C=======================================================================
C                  HERE ENDS THE INTERNAL LOOP OVER THE ISOSPIN
C=======================================================================
C
      END DO
C
C=======================================================================
C             HERE ENDS THE LOOP OVER THE BETA GAUSS KNOTS
C=======================================================================
C
      END DO
C
C=======================================================================
C         MULTIPLYING THE INTEGRATED KERNELS BY OVERALL FACTORS
C=======================================================================
C
      DO INDPRO=1,NUPROM
C
         IPROAC=IROMAT(INDPRO)
         LPROAC=LROMAT(INDPRO)
         KPROAC=KROMAT(INDPRO)
C
         IF (NUBKNO.EQ.1) THEN
             FACNOI=             1/( 4.0D0*PI*PI)
         ELSE
             FACNOI=(IPROAC+1.0D0)/( 8.0D0*PI*PI)
         END IF
C
C==================================================================
C                  INTERNAL LOOP OVER THE ISOSPIN
C==================================================================
C
         DO INDISO=1,NUISOM
C
            ISOSAC=ISOMAT(INDISO)
            LSOSAC=LSOMAT(INDISO)
            KSOSAC=KSOMAT(INDISO)
C
            IF (NBTKNO.EQ.1) THEN
                FACNOR=FACNOI               /(4.0D0*PI*PI)
            ELSE
                FACNOR=FACNOI*(ISOSAC+1.0D0)/(8.0D0*PI*PI)
            END IF
C
C TER        DO NUCOUT=1,2*NDCOUT
C TER       TTE_TT(INDPRO,INDISO,NUCOUT)=TTE_TT(INDPRO,INDISO,NUCOUT)
C TER*                           *FACNOR
C TER        END DO
            TKE_TT(INDPRO,INDISO)=
     *      TKE_TT(INDPRO,INDISO)*FACNOR
C
            TSK_TT(INDPRO,INDISO)=
     *      TSK_TT(INDPRO,INDISO)*FACNOR
            TKI_NT(INDPRO,INDISO)=
     *      TKI_NT(INDPRO,INDISO)*FACNOR
            TKI_PT(INDPRO,INDISO)=
     *      TKI_PT(INDPRO,INDISO)*FACNOR
C
            TPA_NT(INDPRO,INDISO)=
     *      TPA_NT(INDPRO,INDISO)*FACNOR
            TPA_PT(INDPRO,INDISO)=
     *      TPA_PT(INDPRO,INDISO)*FACNOR
C
            TCO_DT(INDPRO,INDISO)=
     *      TCO_DT(INDPRO,INDISO)*FACNOR
            TC1_D0(INDPRO,INDISO)=
     *      TC1_D0(INDPRO,INDISO)*FACNOR
            TC1_DP(INDPRO,INDISO)=
     *      TC1_DP(INDPRO,INDISO)*FACNOR
            TC1_DM(INDPRO,INDISO)=
     *      TC1_DM(INDPRO,INDISO)*FACNOR
            TC2_D0(INDPRO,INDISO)=
     *      TC2_D0(INDPRO,INDISO)*FACNOR
            TC21DP(INDPRO,INDISO)=
     *      TC21DP(INDPRO,INDISO)*FACNOR
            TC21DM(INDPRO,INDISO)=
     *      TC21DM(INDPRO,INDISO)*FACNOR
            TC22DP(INDPRO,INDISO)=
     *      TC22DP(INDPRO,INDISO)*FACNOR
            TC22DM(INDPRO,INDISO)=
     *      TC22DM(INDPRO,INDISO)*FACNOR
C
            TCO_XT(INDPRO,INDISO)=
     *      TCO_XT(INDPRO,INDISO)*FACNOR
            TC1_X0(INDPRO,INDISO)=
     *      TC1_X0(INDPRO,INDISO)*FACNOR
            TC1_XP(INDPRO,INDISO)=
     *      TC1_XP(INDPRO,INDISO)*FACNOR
            TC1_XM(INDPRO,INDISO)=
     *      TC1_XM(INDPRO,INDISO)*FACNOR
            TC2_X0(INDPRO,INDISO)=
     *      TC2_X0(INDPRO,INDISO)*FACNOR
            TC21XP(INDPRO,INDISO)=
     *      TC21XP(INDPRO,INDISO)*FACNOR
            TC21XM(INDPRO,INDISO)=
     *      TC21XM(INDPRO,INDISO)*FACNOR
            TC22XP(INDPRO,INDISO)=
     *      TC22XP(INDPRO,INDISO)*FACNOR
            TC22XM(INDPRO,INDISO)=
     *      TC22XM(INDPRO,INDISO)*FACNOR
C
            TPN_00(INDPRO,INDISO)=
     *      TPN_00(INDPRO,INDISO)*FACNOR
            TPN_10(INDPRO,INDISO)=
     *      TPN_10(INDPRO,INDISO)*FACNOR
            TPN_1P(INDPRO,INDISO)=
     *      TPN_1P(INDPRO,INDISO)*FACNOR
            TPN_1M(INDPRO,INDISO)=
     *      TPN_1M(INDPRO,INDISO)*FACNOR
C
            TTZ_IS(INDPRO,INDISO)=
     *      TTZ_IS(INDPRO,INDISO)*FACNOR
            TT2_IS(INDPRO,INDISO)=
     *      TT2_IS(INDPRO,INDISO)*FACNOR
C
            TBZ_RO(INDPRO,INDISO)=
     *      TBZ_RO(INDPRO,INDISO)*FACNOR
            TB2_RO(INDPRO,INDISO)=
     *      TB2_RO(INDPRO,INDISO)*FACNOR
C
            OPROJE(INDPRO,INDISO)=
     *      TKE_TT(INDPRO,INDISO)
C
C=======================================================================
C           MATRIX ELEMENTS OF THE SCALAR-ISOSCALAR PART
C                         OF THE HAMILTONIAN
C=======================================================================
C
            EPROJE(INDPRO,INDISO)=
     *      TSK_TT(INDPRO,INDISO)
     *     +TKI_NT(INDPRO,INDISO)
     *     +TKI_PT(INDPRO,INDISO)
     *     +TCO_DT(INDPRO,INDISO)
     *     +TCO_XT(INDPRO,INDISO)
C
            EPROJE(INDPRO,INDISO)=EPROJE(INDPRO,INDISO)
     *     +TPA_NT(INDPRO,INDISO)+TPA_PT(INDPRO,INDISO)
C
         END DO
C
      END DO
C
      IF (NBTKNO.EQ.1.AND.(IKEPRI.EQ.1.OR.IRMPRI.EQ.1)) THEN
C
C=======================================================================
C           MATRIX ELEMENTS OF MULTIPOLE OPERATORS
C=======================================================================
C
          DO IREPRO=1,NUPREM
C
             IPROAC=IREMAT(IREPRO)
             LPROAC=LREMAT(IREPRO)
             KPROAC=KREMAT(IREPRO)
C
             IF (NUBKNO.EQ.1) THEN
                 FACNOI=             1/( 4.0D0*PI*PI)
             ELSE
                 FACNOI=(IPROAC+1.0D0)/( 8.0D0*PI*PI)
             END IF
C
             FACNOR=FACNOI               /(4.0D0*PI*PI)
C
             DO LAMBDA=0,NMURED
                DO MIU=-LAMBDA,LAMBDA
C
                   TMUL_P(IND_LM(LAMBDA,MIU),IREPRO)=
     *             TMUL_P(IND_LM(LAMBDA,MIU),IREPRO)*FACNOR
C
C=======================================================================
C           ATTENTION: THE SUM RULES BELOW ARE  EVALUATED  FOR  DIAGONAL
C                      MAGNETIC COMPONENTS LPROAC=KPROAC.  IN  ADDITION,
C                      FOR AXIAL CALCULATIONS (IAXIAL=1), WHEN  K  IS  A
C                      GOOD QUANTUM  NUMBER,  WE  MANUALLY  ENFORCE  THE
C                      CORRECT SELECTION RULE OF  MIU = 0.  THIS  IS  SO
C                      BECAUSE ONLY THOSE MARIX ELEMENTS  THAT  DO  OBEY
C                      THE SELECTION RULE ARE THEN REAL,  WHEREAS  THOSE
C                      THAT DO NOT ARE FICTITIOUS.
C=======================================================================
C
                   IF (LPROAC.EQ.KPROAC.AND.(IAXIAL.NE.1.OR.MIU.EQ.0))
     *                 RMUL_P(LAMBDA,MIU)=RMUL_P(LAMBDA,MIU)
     *                            +TMUL_P(IND_LM(LAMBDA,MIU),IREPRO)
C
                END DO
             END DO
C
C     IF (LPROAC.EQ.KPROAC) WRITE (*,'(3I4,2(4X,2D17.8))')
C    *                                 IPROAC,LPROAC,KPROAC,
C    *                                 TMUL_P(IND_LM(0,0),IREPRO),
C    *                                        RMUL_P(0,0)
C
             DO LAMBDA=1,NMARED
                DO MIU=-LAMBDA,LAMBDA
C
                   TMAG_T(IND_LM(LAMBDA,MIU),IREPRO,:)=
     *             TMAG_T(IND_LM(LAMBDA,MIU),IREPRO,:)*FACNOR
C
                   IF (LPROAC.EQ.KPROAC.AND.(IAXIAL.NE.1.OR.MIU.EQ.0))
     *                 RMAG_T(LAMBDA,MIU)=RMAG_T(LAMBDA,MIU)
     *                            +TMAG_T(IND_LM(LAMBDA,MIU),IREPRO,0)
C
C     WRITE (*,'(3I4,I7,3X,2I3,2(4X,2D17.8))')
C    *           IPROAC,LPROAC,KPROAC,IREPRO,LAMBDA,MIU,
C    *           TMAG_T(IND_LM(LAMBDA,MIU),IREPRO,0),
C    *                  RMAG_T(LAMBDA,MIU)
C
                END DO
             END DO
C
             IF (NASORD.GE.0) THEN
C
                 DO LAMBDA=1,NASRED
                    DO MIU=-LAMBDA,LAMBDA
C
                       TASM_T(IND_LM(LAMBDA,MIU),IREPRO,:)=
     *                 TASM_T(IND_LM(LAMBDA,MIU),IREPRO,:)*FACNOR
C
                     IF (LPROAC.EQ.KPROAC.AND.(IAXIAL.NE.1.OR.MIU.EQ.0))
     *                   RASM_T(LAMBDA,MIU)=RASM_T(LAMBDA,MIU)
     *                              +TASM_T(IND_LM(LAMBDA,MIU),IREPRO,0)
C
                    END DO
                 END DO
C
             END IF
C
             DO LAMBDA=NSIMIN,NSIRED
                DO MIU=-LAMBDA,LAMBDA
C
                   TSIF_P(IND_LM(LAMBDA,MIU),IREPRO)=
     *             TSIF_P(IND_LM(LAMBDA,MIU),IREPRO)*FACNOR
C
                   IF (LPROAC.EQ.KPROAC.AND.(IAXIAL.NE.1.OR.MIU.EQ.0))
     *                 RSIF_P(LAMBDA,MIU)=RSIF_P(LAMBDA,MIU)
     *                            +TSIF_P(IND_LM(LAMBDA,MIU),IREPRO)
C
                END DO
             END DO
C
          END DO
C
      END IF
C
C=======================================================================
C        CALCULATING DIAGONAL MATRX ELEMENTS <IMK,TM_TK_T|H|IMK,TM_TK_T>
C        LSOSAC CORRESPONDS TO M_T
C        KSOSAC CORRESPONDS TO K_T
C=======================================================================
C
      I_HEAD=0
C
      DO INDPRO=1,NUPROM
C
         IPROAC=IROMAT(INDPRO)
         LPROAC=LROMAT(INDPRO)
         KPROAC=KROMAT(INDPRO)
C
         DO INDISO=1,NUISOM
C
            ISOSAC=ISOMAT(INDISO)
            LSOSAC=LSOMAT(INDISO)
            KSOSAC=KSOMAT(INDISO)
C
            E10L=CGCOEF(ISOSAC,LSOSAC  ,2, 0,ISOSAC,LSOSAC)
            E20L=CGCOEF(ISOSAC,LSOSAC  ,4, 0,ISOSAC,LSOSAC)
C
            E10K=CGCOEF(ISOSAC,KSOSAC  ,2, 0,ISOSAC,KSOSAC)
            E11P=CGCOEF(ISOSAC,KSOSAC-2,2, 2,ISOSAC,KSOSAC)
            E11M=CGCOEF(ISOSAC,KSOSAC+2,2,-2,ISOSAC,KSOSAC)
            E20K=CGCOEF(ISOSAC,KSOSAC  ,4, 0,ISOSAC,KSOSAC)
            E21P=CGCOEF(ISOSAC,KSOSAC-2,4, 2,ISOSAC,KSOSAC)
            E21M=CGCOEF(ISOSAC,KSOSAC+2,4,-2,ISOSAC,KSOSAC)
            E22P=CGCOEF(ISOSAC,KSOSAC-4,4, 4,ISOSAC,KSOSAC)
            E22M=CGCOEF(ISOSAC,KSOSAC+4,4,-4,ISOSAC,KSOSAC)
C
            E211P=E10L*E11P
            E211M=E10L*E11M
C
            E221P=E20L*E21P
            E221M=E20L*E21M
            E222P=E20L*E22P
            E222M=E20L*E22M
C
            E2_10=E10L*E10K
            E2_20=E20L*E20K
C
            IF(NBTKNO.GT.1.AND.NATKNO.EQ.1) THEN
C
C=======================================================================
C         CALCULATING MATRIX ELEMENTS FOR 1D ISOSPIN PROJECTION
C=======================================================================
C
               EPROJE(INDPRO,INDISO)=
     *         EPROJE(INDPRO,INDISO)
     *        +TC1_D0(INDPRO,INDISO)*E2_10
     *        +TC1_DP(INDPRO,INDISO)*E211P
     *        +TC1_DM(INDPRO,INDISO)*E211M
     *        +TC2_D0(INDPRO,INDISO)*E2_20
     *        +TC21DP(INDPRO,INDISO)*E221P
     *        +TC21DM(INDPRO,INDISO)*E221M
     *        +TC22DP(INDPRO,INDISO)*E222P
     *        +TC22DM(INDPRO,INDISO)*E222M
     *        +TC1_X0(INDPRO,INDISO)*E2_10
     *        +TC1_XP(INDPRO,INDISO)*E211P
     *        +TC1_XM(INDPRO,INDISO)*E211M
     *        +TC2_X0(INDPRO,INDISO)*E2_20
     *        +TC21XP(INDPRO,INDISO)*E221P
     *        +TC21XM(INDPRO,INDISO)*E221M
     *        +TC22XP(INDPRO,INDISO)*E222P
     *        +TC22XM(INDPRO,INDISO)*E222M
C
               INDI1M=INDISO
               INDI1P=INDISO
               INDI2M=INDISO
               INDI2P=INDISO
C
            END IF
C
            IF (NBTKNO.GT.1.AND.NATKNO.GT.1) THEN
C
C=======================================================================
C         CALCULATING MATRIX ELEMENTS FOR 3D ISOSPIN PROJECTION
C=======================================================================
C         ATTENTION:  THE  INDICES   OF   THE   ISOSPIN  PROJECTION  ARE
C                     APPROPRIATELY SHIFTED  ACCORDING  TO  THE  ISOSPIN
C                     COUPLING, SEE NOTES.
C                     WHENEVER THE ISOSPIN PROJECTION  OF  THE  OPERATOR
C                     EQUALS +1/-1 OR  +2/-2,  THE  LEFT  INDEX  OF  THE
C                     MATRIX ELEMENT  IS  SHIFTED  BY  -2/+2  OR  -4/+4.
C                     WHENEVER SUCH SHIFT LEADS TO AN ISOSPIN PROJECTION
C                     NOT  ALLOWED   BY   THE   RANGE   OF   PROJECTIONS
C                     CORRESPONDING TO  THE  GIVEN  TOTAL  ISOSPIN,  THE
C                     INDEX IS SET TO ZERO. THEREFORE, ALL MATRICES  ARE
C                     DIMENSIONNED STARTING FROM ZERO, AND SET TO ZERO.
C=======================================================================
C
                EPROJE(INDPRO,INDISO)=
     *          EPROJE(INDPRO,INDISO)
     *         +TC1_D0(INDPRO,INDISO)*E2_10
     *         +TC2_D0(INDPRO,INDISO)*E2_20
     *         +TC1_X0(INDPRO,INDISO)*E2_10
     *         +TC2_X0(INDPRO,INDISO)*E2_20
C
                INDI1M=0
                KSOS1M=KSOSAC+2
                IF (IABS(KSOS1M).LE.ISOSAC)
     *              INDI1M=INDTMK(ISOSAC,KSOS1M,KSOSAC)
C
                   EPROJE(INDPRO,INDISO)=
     *             EPROJE(INDPRO,INDISO)
     *            +TC1_DM(INDPRO,INDI1M)*E211M
     *            +TC1_XM(INDPRO,INDI1M)*E211M
     *            +TC21DM(INDPRO,INDI1M)*E221M
     *            +TC21XM(INDPRO,INDI1M)*E221M
C
                INDI1P=0
                KSOS1P=KSOSAC-2
                IF (IABS(KSOS1P).LE.ISOSAC)
     *              INDI1P=INDTMK(ISOSAC,KSOS1P,KSOSAC)
C
                   EPROJE(INDPRO,INDISO)=
     *             EPROJE(INDPRO,INDISO)
     *            +TC1_DP(INDPRO,INDI1P)*E211P
     *            +TC1_XP(INDPRO,INDI1P)*E211P
     *            +TC21DP(INDPRO,INDI1P)*E221P
     *            +TC21XP(INDPRO,INDI1P)*E221P
C
                INDI2M=0
                KSOS2M=KSOSAC+4
                IF (IABS(KSOS2M).LE.ISOSAC)
     *              INDI2M=INDTMK(ISOSAC,KSOS2M,KSOSAC)
C
                   EPROJE(INDPRO,INDISO)=
     *             EPROJE(INDPRO,INDISO)
     *            +TC22DM(INDPRO,INDI2M)*E222M
     *            +TC22XM(INDPRO,INDI2M)*E222M
C
                INDI2P=0
                KSOS2P=KSOSAC-4
                IF (IABS(KSOS2P).LE.ISOSAC)
     *              INDI2P=INDTMK(ISOSAC,KSOS2P,KSOSAC)
C
                   EPROJE(INDPRO,INDISO)=
     *             EPROJE(INDPRO,INDISO)
     *            +TC22DP(INDPRO,INDI2P)*E222P
     *            +TC22XP(INDPRO,INDI2P)*E222P
C
            END IF
C
            IPRNDI=0
C
            IF ((LPROAC.EQ.KPROAC.AND.
     *           LSOSAC.EQ.KSOSAC).OR.IPRNDI.EQ.1) THEN
C
C=======================================================================
C                  PRINTING KERNELS AND AVERAGE VALUES
C=======================================================================
C
                IF (I_HEAD.EQ.0.AND.IENPRI.GT.0.AND.IDIAGO.EQ.1) THEN
C
                    IF (LPROJJ.EQ.0)
     *                 WRITE(NFIPRI,'(1H*,77X,1H*,/,
     *                       1H*,4X,'' KERNELS AND AVERAGE VALUES'',
     *                              '' OBTAINED FOR ISOSPIN'',
     *                              '' PROJECTED STATES'',  5X,1H*,/,
     *                                                 1H*,77X,1H*,/,
     *                                       79(1H*),/,1H*,77X,1H*)')
C
                    IF (LPROJJ.NE.0)
     *                 WRITE(NFIPRI,'(1H*,77X,1H*,/,
     *                  1H*,1X,'' KERNELS AND AVERAGE VALUES'',
     *                  '' OBTAINED FOR ANGULAR-MOMENTUM'',
     *                  '' PROJECTED STATES'',  2X,1H*,/,
     *                                     1H*,77X,1H*,/,
     *                           79(1H*),/,1H*,77X,1H*)')
C
                    IF (IPRNDI.EQ.1) THEN
C
                        WRITE(NFIPRI,'(
     *           1H*,1X,'' NON-DIAGONAL KERNELS ARE '',
     *                  '' PRINTED FOR TESTING; TO SWITCH'',
     *                  '' OFF SET IPRNDI=0'',     2X,1H*,/,
     *                                      1H*,77X,1H*)')
C
                    END IF
C
                    IF (IENPRI.EQ.1) THEN
C
                        WRITE(NFIPRI,'(
     *           1H*,1X,''                            '',
     *                  '' REAL(KERNEL)       IMAG(KERNEL)'',
     *                  '' AVERAGE ENERGY'',     1X,1H*,/,
     *                                      1H*,77X,1H*)')
                    ELSE
                        WRITE(NFIPRI,'(
     *           1H*,1X,''                            '',
     *                  '' REAL(KERNEL)       IMAG(KERNEL) '',
     *                  '' AVERAGE VALUE'',      1X,1H*,/,
     *                                      1H*,77X,1H*)')
C
                    END IF
C
                    I_HEAD=1
C
                END IF
C
                IF (IENPRI.EQ.1.AND.IPROAC.GE.ISLPRI
     *                         .AND.IPROAC.LE.ISUPRI
     *                         .AND.LPROJT.EQ.0.AND.IDIAGO.EQ.1)
     *
     *                 WRITE(NFIPRI,'(
     *                   1H*, 1X,'' I,K= '',2(I4,A2),
     *                     ''  NORM = '',F15.12,F16.12,F16.6,
     *                                                   2X,1H*)')
     *
     *             IPROAC/IEVEN_,CHALF_,
     *             LPROAC/IEVEN_,CHALF_,
     *                   TKE_TT(INDPRO,INDISO),
     *              REAL(EPROJE(INDPRO,INDISO))
     *             /REAL(TKE_TT(INDPRO,INDISO))
C
                IF (IENPRI.EQ.1.AND.IPROAC.GE.ISLPRI
     *                         .AND.IPROAC.LE.ISUPRI
     *                         .AND.LPROJT.EQ.1
     *                         .AND.LPROJJ.EQ.1)
     *
     *                 WRITE(NFIPRI,'(
     *                   1H*, 1X,''I,K,T='',3(I3,A2),
     *                     '' NORM= '',F15.12,F16.12,F16.6,
     *                                                   1X,1H*)')
     *
     *             IPROAC/IEVEN_,CHALF_,
     *             LPROAC/IEVEN_,CHALF_,
     *             ISOSAC/IEVEN_,CHALF_,
     *                   TKE_TT(INDPRO,INDISO),
     *              REAL(EPROJE(INDPRO,INDISO))
     *             /REAL(TKE_TT(INDPRO,INDISO))
C
                IF (IENPRI.EQ.1
     *                   .AND.LPROJT.EQ.1
     *                   .AND.LPROJJ.EQ.0)
     *
     *                 WRITE(NFIPRI,'(
     *                   1H*, 3X,''T=    '',I3,A2,5X,
     *                     '' NORM = '',F15.12,F16.12,F16.6,
     *                                                   3X,1H*)')
     *
     *             ISOSAC/IEVEN_,CHALF_,
     *                   TKE_TT(INDPRO,INDISO),
     *              REAL(EPROJE(INDPRO,INDISO))
     *             /REAL(TKE_TT(INDPRO,INDISO))
C
                IF (IENPRI.EQ.2.AND.IPROAC.GE.ISLPRI
     *                         .AND.IPROAC.LE.ISUPRI
     *                         .AND.LPROJT.EQ.0)
     *
     *              WRITE(NFIPRI,'(
     *             1H*, 1X,''I,K='',2(I4,A2),
     *                        '' NORM='',2F19.12,16X,1H*,/,
     *             1H*,14X,''SKYRME  ='',2F19.12,F15.6,1X,1H*,/,
     *             1H*,14X,''EKIN_N  ='',2F19.12,F15.6,1X,1H*,/,
     *             1H*,14X,''EKIN_P  ='',2F19.12,F15.6,1X,1H*,/,
     *             1H*,14X,''COU_DIR ='',2F19.12,16X,1H*,/,
     *             1H*,14X,''COU_EXC ='',2F19.12,16X,1H*,/,
     *             1H*,14X,''COU_TOT ='',2F19.12,F15.6,1X,1H*,/,
     *             1H*,14X,''E_TOTAL ='',2F19.12,F15.6,1X,1H*,/,
     *             1H*,14X,''      A ='',2F19.12,F15.6,1X,1H*,/,
     *             1H*,14X,''    N-Z ='',2F19.12,F15.6,1X,1H*,/,
     *             1H*,14X,''     TZ ='',2F19.12,F15.6,1X,1H*,/,
     *             1H*,14X,''     T2 ='',2F19.12,F15.6,1X,1H*,/,
     *             1H*,14X,''     JZ ='',2F19.12,F15.6,1X,1H*,/,
     *             1H*,14X,''     J2 ='',2F19.12,F15.6,1X,1H*,/,
     *             1H*,14X,''EPAIRN  ='',2F19.12,F15.6,1X,1H*,/,
     *             1H*,14X,''EPAIRP  ='',2F19.12,F15.6,1X,1H*,/,
     *                                            1H*,77X,1H*)')
     *
     *             IPROAC/IEVEN_,CHALF_,
     *             LPROAC/IEVEN_,CHALF_,
     *                 TKE_TT(INDPRO,INDISO),
     *                 TSK_TT(INDPRO,INDISO),
     *            REAL(TSK_TT(INDPRO,INDISO))
     *           /REAL(TKE_TT(INDPRO,INDISO)),
     *                 TKI_NT(INDPRO,INDISO),
     *            REAL(TKI_NT(INDPRO,INDISO))
     *           /REAL(TKE_TT(INDPRO,INDISO)),
     *                 TKI_PT(INDPRO,INDISO),
     *            REAL(TKI_PT(INDPRO,INDISO))
     *           /REAL(TKE_TT(INDPRO,INDISO)),
     *                 TCO_DT(INDPRO,INDISO),
     *                 TCO_XT(INDPRO,INDISO),
     *                 TCO_DT(INDPRO,INDISO)+
     *                 TCO_XT(INDPRO,INDISO),
     *            REAL(TCO_DT(INDPRO,INDISO)+
     *                 TCO_XT(INDPRO,INDISO))
     *           /REAL(TKE_TT(INDPRO,INDISO)),
     *                 EPROJE(INDPRO,INDISO),
     *            REAL(EPROJE(INDPRO,INDISO))
     *           /REAL(TKE_TT(INDPRO,INDISO)),
     *                 TPN_00(INDPRO,INDISO),
     *            REAL(TPN_00(INDPRO,INDISO))
     *           /REAL(TKE_TT(INDPRO,INDISO)),
     *                 TPN_10(INDPRO,INDISO),
     *            REAL(TPN_10(INDPRO,INDISO))
     *           /REAL(TKE_TT(INDPRO,INDISO)),
     *                 TTZ_IS(INDPRO,INDISO),
     *            REAL(TTZ_IS(INDPRO,INDISO))
     *           /REAL(TKE_TT(INDPRO,INDISO)),
     *                 TT2_IS(INDPRO,INDISO),
     *            REAL(TT2_IS(INDPRO,INDISO))
     *           /REAL(TKE_TT(INDPRO,INDISO)),
     *                 TBZ_RO(INDPRO,INDISO),
     *            REAL(TBZ_RO(INDPRO,INDISO))
     *           /REAL(TKE_TT(INDPRO,INDISO)),
     *                 TB2_RO(INDPRO,INDISO),
     *            REAL(TB2_RO(INDPRO,INDISO))
     *           /REAL(TKE_TT(INDPRO,INDISO)),
     *                 TPA_NT(INDPRO,INDISO),
     *            REAL(TPA_NT(INDPRO,INDISO))
     *           /REAL(TKE_TT(INDPRO,INDISO)),
     *                 TPA_PT(INDPRO,INDISO),
     *            REAL(TPA_PT(INDPRO,INDISO))
     *           /REAL(TKE_TT(INDPRO,INDISO))
C
C                ATTENTION: BETWEEN VERSIONS 2.98J AND 2.99K, IN CASE OF
C                           OF IPAHFB=0, ARRAYS  "TPA_NT"  AND  "TPA_PT"
C                           WERE ABOVE PRINTED WITHOUT BEING  ALLOCATED,
C                           WHICH WAS RESULTING THE SEGMENTATION  FAULT.
C                           THIS BUG  WAS  CORRECTED  ON  31/08/2020  IN
C                           VERSION 2.99L.
C
                IF (IENPRI.EQ.2.AND.IPROAC.GE.ISLPRI
     *                         .AND.IPROAC.LE.ISUPRI
     *                         .AND.LPROJT.NE.0)
     *             WRITE(NFIPRI,'(
     *             1H*, 1X,''T,KL,KP,I,KL,KP='',6(I4,A2) ,24X,1H*,/,
     *             1H*,22X,''NORM    ='',F15.6,E15.6,E15.6,1X,1H*,/,
     *             1H*,22X,''SKYRME  ='',F15.6,E15.6,F15.6,1X,1H*,/,
C TER*             1H*,22X,I3,''TERM ='',51F15.6,           1H*,/,
     *             1H*,22X,''EKIN_N  ='',F15.6,E15.6,F15.6,1X,1H*,/,
     *             1H*,22X,''EKIN_P  ='',F15.6,E15.6,F15.6,1X,1H*,/,
     *             1H*,22X,''COUD_00 ='',F15.6,E15.6,     16X,1H*,/,
     *             1H*,22X,''COUE_00 ='',F15.6,E15.6,     16X,1H*,/,
     *             1H*,22X,''COUT_00 ='',F15.6,E15.6,F15.6,1X,1H*,/,
     *             1H*,22X,''COUD_10 ='',F15.6,E15.6,     16X,1H*,/,
     *             1H*,22X,''COUE_10 ='',F15.6,E15.6,     16X,1H*,/,
     *             1H*,22X,''COUT_10 ='',F15.6,E15.6,F15.6,1X,1H*,/,
     *             1H*,22X,''COUD_1+1='',F15.6,E15.6,     16X,1H*,/,
     *             1H*,22X,''COUE_1+1='',F15.6,E15.6,     16X,1H*,/,
     *             1H*,22X,''COUT_1+1='',F15.6,E15.6,F15.6,1X,1H*,/,
     *             1H*,22X,''COUD_1-1='',F15.6,E15.6,     16X,1H*,/,
     *             1H*,22X,''COUE_1-1='',F15.6,E15.6,     16X,1H*,/,
     *             1H*,22X,''COUT_1-1='',F15.6,E15.6,F15.6,1X,1H*,/,
     *             1H*,22X,''COUD_20 ='',F15.6,E15.6,     16X,1H*,/,
     *             1H*,22X,''COUE_20 ='',F15.6,E15.6,     16X,1H*,/,
     *             1H*,22X,''COUT_20 ='',F15.6,E15.6,F15.6,1X,1H*,/,
     *             1H*,22X,''COUD_2+1='',F15.6,E15.6,     16X,1H*,/,
     *             1H*,22X,''COUE_2+1='',F15.6,E15.6,     16X,1H*,/,
     *             1H*,22X,''COUT_2+1='',F15.6,E15.6,F15.6,1X,1H*,/,
     *             1H*,22X,''COUD_2-1='',F15.6,E15.6,     16X,1H*,/,
     *             1H*,22X,''COUE_2-1='',F15.6,E15.6,     16X,1H*,/,
     *             1H*,22X,''COUT_2-1='',F15.6,E15.6,F15.6,1X,1H*,/,
     *             1H*,22X,''COUD_2+2='',F15.6,E15.6,     16X,1H*,/,
     *             1H*,22X,''COUE_2+2='',F15.6,E15.6,     16X,1H*,/,
     *             1H*,22X,''COUT_2+2='',F15.6,E15.6,F15.6,1X,1H*,/,
     *             1H*,22X,''COUD_2-2='',F15.6,E15.6,     16X,1H*,/,
     *             1H*,22X,''COUE_2-2='',F15.6,E15.6,     16X,1H*,/,
     *             1H*,22X,''COUT_2-2='',F15.6,E15.6,F15.6,1X,1H*,/,
     *             1H*,22X,''E_TOTAL ='',30X,        F15.6,1X,1H*,/,
     *             1H*,22X,''PNUMB_00='',F15.6,E15.6,F15.6,1X,1H*,/,
     *             1H*,22X,''PNUMB_10='',F15.6,E15.6,F15.6,1X,1H*,/,
     *             1H*,22X,''PNUMB_1P='',F15.6,E15.6,F15.6,1X,1H*,/,
     *             1H*,22X,''PNUMB_1M='',F15.6,E15.6,F15.6,1X,1H*,/,
     *             1H*,22X,''    N-Z ='',30X,        F15.6,1X,1H*,/,
     *             1H*,22X,''     TZ ='',F15.6,E15.6,F15.6,1X,1H*,
     *                                                 E15.6,/,
     *             1H*,22X,''     T2 ='',F15.6,E15.6,F15.6,1X,1H*,
     *                                                 E15.6,/,
     *             1H*,22X,''     JZ ='',F15.6,E15.6,F15.6,1X,1H*,
     *                                                 E15.6,/,
     *             1H*,22X,''     J2 ='',F15.6,E15.6,F15.6,1X,1H*,
     *                                                          E15.6,/,
     *                                                1H*,77X,1H*)')
     *             ISOSAC/IEVEN_,CHALF_,
     *             LSOSAC/IEVEN_,CHALF_,
     *             KSOSAC/IEVEN_,CHALF_,
     *             IPROAC/IEVEN_,CHALF_,
     *             LPROAC/IEVEN_,CHALF_,
     *             KPROAC/IEVEN_,CHALF_,
     *                 TKE_TT(INDPRO,INDISO),
     *             ABS(TKE_TT(INDPRO,INDISO)),
     *                 TSK_TT(INDPRO,INDISO),
     *            REAL(TSK_TT(INDPRO,INDISO))
     *           /REAL(TKE_TT(INDPRO,INDISO)),
C TER*            REAL(TKI_NT(INDPRO,INDISO))
C TER*           /REAL(TKE_TT(INDPRO,INDISO)),
C TER*            REAL(TKI_PT(INDPRO,INDISO))
C TER*           /REAL(TKE_TT(INDPRO,INDISO)),
C TER*            REAL(EPROJE(INDPRO,INDISO))
C TER*           /REAL(TKE_TT(INDPRO,INDISO)),
C TER*           (REAL(TTE_TT(INDPRO,INDISO,NUCOUT))
C TER*           /REAL(TKE_TT(INDPRO,INDISO)),NUCOUT=1,2*NDCOUT),
     *                 TKI_NT(INDPRO,INDISO),
     *            REAL(TKI_NT(INDPRO,INDISO))
     *           /REAL(TKE_TT(INDPRO,INDISO)),
     *                 TKI_PT(INDPRO,INDISO),
     *            REAL(TKI_PT(INDPRO,INDISO))
     *           /REAL(TKE_TT(INDPRO,INDISO)),
     *                 TCO_DT(INDPRO,INDISO),
     *                 TCO_XT(INDPRO,INDISO),
     *                 TCO_DT(INDPRO,INDISO)+
     *                 TCO_XT(INDPRO,INDISO),
     *            REAL(TCO_DT(INDPRO,INDISO)+
     *                 TCO_XT(INDPRO,INDISO))
     *           /REAL(TKE_TT(INDPRO,INDISO)),
     *                 TC1_D0(INDPRO,INDISO),
     *                 TC1_X0(INDPRO,INDISO),
     *                 TC1_D0(INDPRO,INDISO)+
     *                 TC1_X0(INDPRO,INDISO),
     *      E2_10*REAL(TC1_D0(INDPRO,INDISO)+
     *                 TC1_X0(INDPRO,INDISO))
     *           /REAL(TKE_TT(INDPRO,INDISO)),
     *                 TC1_DP(INDPRO,INDI1P),
     *                 TC1_XP(INDPRO,INDI1P),
     *                 TC1_DP(INDPRO,INDI1P)+
     *                 TC1_XP(INDPRO,INDI1P),
     *      E211P*REAL(TC1_DP(INDPRO,INDI1P)+
     *                 TC1_XP(INDPRO,INDI1P))
     *           /REAL(TKE_TT(INDPRO,INDISO)),
     *                 TC1_DM(INDPRO,INDI1M),
     *                 TC1_XM(INDPRO,INDI1M),
     *                 TC1_DM(INDPRO,INDI1M)+
     *                 TC1_XM(INDPRO,INDI1M),
     *      E211M*REAL(TC1_DM(INDPRO,INDI1M)+
     *                 TC1_XM(INDPRO,INDI1M))
     *           /REAL(TKE_TT(INDPRO,INDISO)),
     *                 TC2_D0(INDPRO,INDISO),
     *                 TC2_X0(INDPRO,INDISO),
     *                 TC2_D0(INDPRO,INDISO)+
     *                 TC2_X0(INDPRO,INDISO),
     *      E2_20*REAL(TC2_D0(INDPRO,INDISO)+
     *                 TC2_X0(INDPRO,INDISO))
     *           /REAL(TKE_TT(INDPRO,INDISO)),
     *                 TC21DP(INDPRO,INDI1P),
     *                 TC21XP(INDPRO,INDI1P),
     *                 TC21DP(INDPRO,INDI1P)+
     *                 TC21XP(INDPRO,INDI1P),
     *      E221P*REAL(TC21DP(INDPRO,INDI1P)+
     *                 TC21XP(INDPRO,INDI1P))
     *           /REAL(TKE_TT(INDPRO,INDISO)),
     *                 TC21DM(INDPRO,INDI1M),
     *                 TC21XM(INDPRO,INDI1M),
     *                 TC21DM(INDPRO,INDI1M)+
     *                 TC21XM(INDPRO,INDI1M),
     *      E221M*REAL(TC21DM(INDPRO,INDI1M)+
     *                 TC21XM(INDPRO,INDI1M))
     *           /REAL(TKE_TT(INDPRO,INDISO)),
     *                 TC22DP(INDPRO,INDI2P),
     *                 TC22XP(INDPRO,INDI2P),
     *                 TC22DP(INDPRO,INDI2P)+
     *                 TC22XP(INDPRO,INDI2P),
     *      E222P*REAL(TC22DP(INDPRO,INDI2P)+
     *                 TC22XP(INDPRO,INDI2P))
     *           /REAL(TKE_TT(INDPRO,INDISO)),
     *                 TC22DM(INDPRO,INDI2M),
     *                 TC22XM(INDPRO,INDI2M),
     *                 TC22DM(INDPRO,INDI2M)+
     *                 TC22XM(INDPRO,INDI2M),
     *      E222M*REAL(TC22DM(INDPRO,INDI2M)+
     *                 TC22XM(INDPRO,INDI2M))
     *           /REAL(TKE_TT(INDPRO,INDISO)),
     *            REAL(EPROJE(INDPRO,INDISO))
     *           /REAL(TKE_TT(INDPRO,INDISO)),
     *                 TPN_00(INDPRO,INDISO),
     *            REAL(TPN_00(INDPRO,INDISO))
     *           /REAL(TKE_TT(INDPRO,INDISO)),
     *                 TPN_10(INDPRO,INDISO),
     *      E2_10*REAL(TPN_10(INDPRO,INDISO))
     *           /REAL(TKE_TT(INDPRO,INDISO)),
     *                 TPN_1P(INDPRO,INDI1P),
     *      E211P*REAL(TPN_1P(INDPRO,INDI1P))
     *           /REAL(TKE_TT(INDPRO,INDISO)),
     *                 TPN_1M(INDPRO,INDI1M),
     *      E211M*REAL(TPN_1M(INDPRO,INDI1M))
     *           /REAL(TKE_TT(INDPRO,INDISO)),
     *     (E2_10*REAL(TPN_10(INDPRO,INDISO))
     *     +E211P*REAL(TPN_1P(INDPRO,INDI1P))
     *     +E211M*REAL(TPN_1M(INDPRO,INDI1M)))
     *           /REAL(TKE_TT(INDPRO,INDISO)),
     *                 TTZ_IS(INDPRO,INDISO),
     *            REAL(TTZ_IS(INDPRO,INDISO))
     *           /REAL(TKE_TT(INDPRO,INDISO)),
     *            REAL(TTZ_IS(INDPRO,INDISO))
     *           /REAL(TKE_TT(INDPRO,INDISO))-LSOSAC/2.0D0,
     *                 TT2_IS(INDPRO,INDISO),
     *            REAL(TT2_IS(INDPRO,INDISO))
     *           /REAL(TKE_TT(INDPRO,INDISO)),
     *            REAL(TT2_IS(INDPRO,INDISO))
     *           /REAL(TKE_TT(INDPRO,INDISO))-ISOSAC/2.0D0
     *                                      *(ISOSAC/2.0D0+1),
     *                 TBZ_RO(INDPRO,INDISO),
     *            REAL(TBZ_RO(INDPRO,INDISO))
     *           /REAL(TKE_TT(INDPRO,INDISO)),
     *            REAL(TBZ_RO(INDPRO,INDISO))
     *           /REAL(TKE_TT(INDPRO,INDISO))-KPROJE/2.0D0,
     *                 TB2_RO(INDPRO,INDISO),
     *            REAL(TB2_RO(INDPRO,INDISO))
     *           /REAL(TKE_TT(INDPRO,INDISO)),
     *            REAL(TB2_RO(INDPRO,INDISO))
     *           /REAL(TKE_TT(INDPRO,INDISO))-IPROAC/2.0D0
     *                                      *(IPROAC/2.0D0+1)
C
C=======================================================================
C         CALCULATING THE SUM RULES FOR DIAGONAL TERMS LPROAC=KPROAC
C=======================================================================
C
                IF (LPROAC.EQ.KPROAC.AND.
     *              LSOSAC.EQ.KSOSAC) THEN
C
                    RKER_T=RKER_T+TKE_TT(INDPRO,INDISO)
C
                    RSKY_T=RSKY_T+TSK_TT(INDPRO,INDISO)
                    RKIN_T=RKIN_T+TKI_NT(INDPRO,INDISO)
     *                           +TKI_PT(INDPRO,INDISO)
C
                    RPAI_T=RPAI_T+TPA_NT(INDPRO,INDISO)
     *                           +TPA_PT(INDPRO,INDISO)
C
                    RCOU_D=RCOU_D
     *                    +TCO_DT(INDPRO,INDISO)
     *                    +TC1_D0(INDPRO,INDISO)
     *                    +TC2_D0(INDPRO,INDISO)
C
                    RCOU_X=RCOU_X
     *                    +TCO_XT(INDPRO,INDISO)
     *                    +TC1_X0(INDPRO,INDISO)
     *                    +TC2_X0(INDPRO,INDISO)
C
                    RPARTN=RPARTN
     *                    +TPN_00(INDPRO,INDISO)
                    RISOSP=RISOSP
     *                    +TPN_10(INDPRO,INDISO)
C
                    RTZISO=RTZISO
     *                    +TTZ_IS(INDPRO,INDISO)
                    RT2ISO=RT2ISO
     *                    +TT2_IS(INDPRO,INDISO)
C
                    RBZROT=RBZROT
     *                    +TBZ_RO(INDPRO,INDISO)
                    RB2ROT=RB2ROT
     *                    +TB2_RO(INDPRO,INDISO)
C
                END IF
C
            END IF
C
C=======================================================================
C              HERE ENDS THE INTERNAL LOOP OVER THE ISOSPIN
C=======================================================================
C
         END DO
C
         IF (LPROJJ.EQ.0.AND.NATKNO.EQ.1) THEN
C
C=======================================================================
C                 REDIAGONALIZATION OF THE COULOMB FIELD
C                    IN A RUN WITHOUT SPIN PROJECTION
C=======================================================================
C
             ALLOCATE (CELMTS(1:((NDPROT+1)*NDPROT)/2),STAT=IALLOC)
             IF (IALLOC.NE.0) CALL NOALLO('CELMTS','PROANG')
             ALLOCATE (HAMWAV(1:NDPROT,1:NDPROT),STAT=IALLOC)
             IF (IALLOC.NE.0) CALL NOALLO('HAMWAV','PROANG')
             ALLOCATE (HAMMAT(1:NDPROT,1:NDPROT),STAT=IALLOC)
             IF (IALLOC.NE.0) CALL NOALLO('HAMMAT','PROANG')
C
             DO INDISO=1,NUISOM
C
                ISOSAC=ISOMAT(INDISO)
C
                IF (ABS(OPROJE(INDPRO,INDISO)).GT.EPSISO) THEN
                    ITTDIM=ISOSAC
                END IF
C
             END DO
C
             ITTD=(ITTDIM-JSOSMI)/2+1
             IF (IENPRI.EQ.3)
     *       WRITE(*,233) EPSISO,ITTD
 233         FORMAT(1H*,77X,1H*,/,1H*,
     *              6X,'CUT-OFF "EPSISO" =  ',F16.14,
     *              1X,'==> GOOD-T BASIS OF DIM = ',I2,6X,1H*,/,
     *              1H*,77X,1H*)
C
             DO IBRA=1,ITTD
C
                ISOBRA=ISOMAT(IBRA)
C
                DO IKET=1,ITTD
C
                   ISOKET=ISOMAT(IKET)
C
                   E_10=CGCOEF(ISOKET,ISOSTZ  ,2, 0,ISOBRA,ISOSTZ)
                   E11P=CGCOEF(ISOKET,ISOSTZ-2,2, 2,ISOBRA,ISOSTZ)
                   E11M=CGCOEF(ISOKET,ISOSTZ+2,2,-2,ISOBRA,ISOSTZ)
                   E_20=CGCOEF(ISOKET,ISOSTZ  ,4, 0,ISOBRA,ISOSTZ)
                   E21P=CGCOEF(ISOKET,ISOSTZ-2,4, 2,ISOBRA,ISOSTZ)
                   E21M=CGCOEF(ISOKET,ISOSTZ+2,4,-2,ISOBRA,ISOSTZ)
                   E22P=CGCOEF(ISOKET,ISOSTZ-4,4, 4,ISOBRA,ISOSTZ)
                   E22M=CGCOEF(ISOKET,ISOSTZ+4,4,-4,ISOBRA,ISOSTZ)
C
                   E211P=E_10*E11P
                   E211M=E_10*E11M
C
                   E221P=E_20*E21P
                   E221M=E_20*E21M
                   E222P=E_20*E22P
                   E222M=E_20*E22M
C
                   E2_10=E_10*E_10
                   E2_20=E_20*E_20
C
                   IF (IBRA.EQ.IKET) THEN
                   HAMMAT(IBRA,IKET)=
     *                      EPROJE(INDPRO,IBRA)
     *                /REAL(OPROJE(INDPRO,IBRA))
C
                   IF (IENPRI.EQ.3)
     *             WRITE(*,234) ISOBRA/IEVEN_,CHALF_,ISOKET/IEVEN_,
     *                  CHALF_,HAMMAT(IBRA,IKET),
     *             REAL(OPROJE(INDPRO,IBRA)),
     *                  EPROJE(INDPRO,IBRA)
C
                   END IF
C
                   IF (IBRA.NE.IKET) THEN
                       HAMMAT(IBRA,IKET)=
     *                 (E2_10*(TC1_D0(INDPRO,IKET)+
     *                         TC1_X0(INDPRO,IKET))
     *                 +E211P*(TC1_DP(INDPRO,IKET)+
     *                         TC1_XP(INDPRO,IKET))
     *                 +E211M*(TC1_DM(INDPRO,IKET)+
     *                         TC1_XM(INDPRO,IKET))
     *                 +E2_20*(TC2_D0(INDPRO,IKET)+
     *                         TC2_X0(INDPRO,IKET))
     *                 +E221P*(TC21DP(INDPRO,IKET)+
     *                         TC21XP(INDPRO,IKET))
     *                 +E221M*(TC21DM(INDPRO,IKET)+
     *                         TC21XM(INDPRO,IKET))
     *                 +E222P*(TC22DP(INDPRO,IKET)+
     *                         TC22XP(INDPRO,IKET))
     *                 +E222M*(TC22DM(INDPRO,IKET)+
     *                         TC22XM(INDPRO,IKET)))
     *              /SQRT(REAL(OPROJE(INDPRO,IBRA)))
     *              /SQRT(REAL(OPROJE(INDPRO,IKET)))
C
                       IF (IENPRI.EQ.3)
     *                 WRITE(*,234) ISOBRA/IEVEN_,CHALF_,ISOKET/IEVEN_,
     *                              CHALF_,HAMMAT(IBRA,IKET),
     *                  SQRT(REAL(OPROJE(INDPRO,IBRA)))
     *                 *SQRT(REAL(OPROJE(INDPRO,IKET))),
     *                     E2_10*(TC1_D0(INDPRO,IKET)+
     *                            TC1_X0(INDPRO,IKET))
     *                    +E211P*(TC1_DP(INDPRO,IKET)+
     *                            TC1_XP(INDPRO,IKET))
     *                    +E211M*(TC1_DM(INDPRO,IKET)+
     *                            TC1_XM(INDPRO,IKET))
     *                    +E2_20*(TC2_D0(INDPRO,IKET)+
     *                            TC2_X0(INDPRO,IKET))
     *                    +E221P*(TC21DP(INDPRO,IKET)+
     *                            TC21XP(INDPRO,IKET))
     *                    +E221M*(TC21DM(INDPRO,IKET)+
     *                            TC21XM(INDPRO,IKET))
     *                    +E222P*(TC22DP(INDPRO,IKET)+
     *                            TC22XP(INDPRO,IKET))
     *                    +E222M*(TC22DM(INDPRO,IKET)+
     *                            TC22XM(INDPRO,IKET))
 234                   FORMAT(1H*,1X,2(I4,A2),(F12.6,F10.6),3X,F12.10,
     *                                          3X,(F12.6,F10.6),2X,1H*)
                   END IF
C
                   IF (IBRA.GE.IKET) THEN
C
                       NCOUNT=IBRA+((2*ITTD-IKET)*(IKET-1))/2
C
                       CELMTS(NCOUNT)=HAMMAT(IBRA,IKET)
C
                   END IF
C
                END DO
             END DO
C
             CALL DIAMAT(CELMTS,HAMEIG,HAMWAV,ITTD,NDPROT,ITTD)
C
             IF (IENPRI.EQ.3) THEN
                 WRITE(*,665)
 665             FORMAT(1H*,77X,1H*)
                 DO II=1,ITTD
                 WRITE(*,666) II, HAMEIG(II)
 666             FORMAT(1H*,2X,I2,'  EIGENENERGY IS:',F16.6,40X,1H*)
                 WRITE(*,667)(  ABS(HAMWAV(JJ,II))**2,JJ=1,
     *                         MIN(5,ITTD))
                 WRITE(*,667)( REAL(HAMWAV(JJ,II))   ,JJ=1,
     *                         MIN(5,ITTD))
                 WRITE(*,667)(AIMAG(HAMWAV(JJ,II))   ,JJ=1,
     *                         MIN(5,ITTD))
 667             FORMAT(1H*,5(4X,F10.6))
                 END DO
                 WRITE(*,665)
             END IF
C
             DEALLOCATE (CELMTS,HAMWAV,HAMMAT)

         END IF
C
         IF (LPROJJ.NE.0.AND.LPROAC.EQ.KPROAC.AND.ICOMIX.EQ.0
     *                                       .AND.IENPRI.EQ.4) THEN
         WRITE(*,991) IPROAC/IEVEN_,CHALF_,KPROAC/IEVEN_,CHALF_,
     *                RKER_T,RSKY_T,RKIN_T,
     *                RCOU_D+RCOU_X,RPARTN,RISOSP,
     *                RTZISO,RT2ISO,RBZROT,RB2ROT
         END IF
C
 991  FORMAT(
     *    1H*,77X,1H*,/,1H*,77('-'),1H*,/,
     *    1H*,1X,'PARTIAL SUM RULES FOR I<=',I3,A2,
     *                                 ' K=',I3,A2,38X,1H*,/,
     *    1H*,1X,'FOR OVERLAP          ',6X,2F16.12,17X,1H*,/,
     *    1H*,1X,'FOR SKYRME ENERGY    ',6X,2F16.6,17X,1H*,/,
     *    1H*,1X,'FOR KINETIC ENERGY   ',6X,2F16.6,17X,1H*,/,
     *    1H*,1X,'FOR PAIRING ENERGY   ',6X,2F16.6,17X,1H*,/,
     *    1H*,1X,'FOR COULOMB ENERGY   ',6X,2F16.6,17X,1H*,/,
     *    1H*,1X,'FOR PARTICLE NUMBER  ',6X,2F16.6,17X,1H*,/,
     *    1H*,1X,'FOR Tz               ',6X,2F16.6,17X,1H*,/,
     *    1H*,1X,'FOR Tz-NEW           ',6X,2F16.6,17X,1H*,/,
     *    1H*,1X,'FOR T2               ',6X,2F16.6,17X,1H*,/,
     *    1H*,1X,'FOR Jz               ',6X,2F16.6,17X,1H*,/,
     *    1H*,1X,'FOR J2               ',6X,2F16.6,17X,1H*,/,
     *    1H*,77('-'),1H*,/,1H*,77X,1H*)
C
C=======================================================================
C              HERE ENDS THE LOOP OVER THE "INDPRO" INDEX
C=======================================================================
C
      END DO
C
      IF (IENPRI.EQ.1.AND.ICOMIX.EQ.0) WRITE(NFIPRI,'(1H*,77X,1H*)')
C
C=======================================================================
C                    PRINTING THE ENERGY SUM RULES
C=======================================================================
C
      IF (ISRPRI.GE.0.AND.ICOMIX.EQ.0)
     *    WRITE(NFIPRI,'(79(1H*),/,1H*,77X,1H*,/,
     *      1H*,1X,'' SUM RULES OBTAINED FOR THE PROJECTED'',
     *             '' STATES AS COMPARED WITH THE HF VALUES'',1X,1H*,/,
     *                                1H*,77X,1H*,/,
     *                      79(1H*),/,1H*,77X,1H*)')
C
      IF (ISRPRI.GE.0.AND.ICOMIX.EQ.0)
     *    WRITE(NFIPRI,'(
     *      1H*,1X,''                           '',
     *             '' REAL(SUM RULE)  IMAG(SUM RULE)  '',
     *             ''      HF VALUE'',      2X,1H*,/,
     *                                 1H*,77X,1H*)')
C
      IF (ISRPRI.GE.0.AND.ICOMIX.EQ.0)
     *    WRITE(NFIPRI,'(
     *      1H*,19X,''    NORM='',F15.12, F16.12,18X,1H*,/,
     *      1H*,19X,''  SKYRME='',F15.6 ,2F16.6 , 2X,1H*,/,
     *      1H*,19X,''  EKIN_T='',F15.6 ,2F16.6 , 2X,1H*,/,
     *      1H*,19X,''  EPAI_T='',F15.6 ,2F16.6 , 2X,1H*,/,
     *      1H*,19X,''  COUL_D='',F15.6 ,2F16.6 , 2X,1H*,/,
     *      1H*,19X,''  COUL_E='',F15.6 ,2F16.6 , 2X,1H*,/,
     *      1H*,19X,''  COUL_T='',F15.6 ,2F16.6 , 2X,1H*,/,
     *      1H*,19X,''      TZ='',F15.6 ,2F16.6 , 2X,1H*,/,
     *      1H*,19X,''      T2='',F15.6 ,2F16.6 , 2X,1H*,/,
     *      1H*,19X,''      JZ='',F15.6 ,2F16.6 , 2X,1H*,/,
     *      1H*,19X,''      J2='',F15.6 ,2F16.6 , 2X,1H*,/,
     *                                       1H*,77X,1H*)')
     *
     *      RKER_T,RSKY_T,ENESKY,RKIN_T,EKIN_T,RPAI_T,EPAI_T,
     *             RCOU_D,ECOULD,RCOU_X,ECOULE,
     *             RCOU_D+RCOU_X,ECOULD+ECOULE,
     *             RTZISO,TOTISO(3),RT2ISO,TOTIS2(0),
     *             RBZROT,00000.000,RB2ROT,00000.000
C
C=======================================================================
C         PRINTING THE MULTIPOLE-MOMENT SUM RULES
C=======================================================================
C
      IF (NMURED.GT.0.AND.NMUMAX.GT.0.AND.ISRPRI.GE.0.AND.NBTKNO.EQ.1
     *                               .AND.ICOMIX.EQ.0) THEN
C
          NAMWRK='MULTIPOLE'
C
          DO LAMBDA=0,MIN(NMURED,NMUMAX)
C
                              MAXMIU=LAMBDA
C            IF (IAXIAL.EQ.1) MAXMIU=0
C
             DO MIU=-MAXMIU,MAXMIU
C
                NIU=IABS(MIU)
C
                WRITE(NFIPRI,'(
     *                1H*,1X,A9,'' L='',I2,'' M='',I2,
     *                    '' QMUL_P='',F15.6 ,2F16.6 , 2X,1H*)')
     *
     *                NAMWRK,LAMBDA,MIU,
     *                RMUL_P(LAMBDA,MIU),
     *                QMUL_P(LAMBDA,MIU)
C
                NAMWRK='         '
C
             END DO
          END DO
C
          WRITE(NFIPRI,'(1H*,77X,1H*)')
C
      END IF
C
C=======================================================================
C         PRINTING THE MAGNETIC-MOMENT SUM RULES
C=======================================================================
C
      IF (NMARED.GT.0.AND.NMAMAX.GT.0.AND.ISRPRI.GE.0.AND.NBTKNO.EQ.1
     *                               .AND.ICOMIX.EQ.0) THEN
C
          NAMWRK='MAGNETIC '
C
          DO LAMBDA=1,MIN(NMARED,NMAMAX)
C
                              MAXMIU=LAMBDA
C            IF (IAXIAL.EQ.1) MAXMIU=0
C
             DO MIU=-MAXMIU,MAXMIU
C
                NIU=IABS(MIU)
C
                WRITE(NFIPRI,'(
     *                1H*,1X,A9,'' L='',I2,'' M='',I2,
     *                    '' AMUL_T='',F15.6 ,2F16.6 , 2X,1H*)')
     *
     *                NAMWRK,LAMBDA,MIU,
     *                RMAG_T(LAMBDA,MIU),
     *                AMUL_T(LAMBDA,MIU,0)
C
                NAMWRK='         '
C
             END DO
          END DO
C
          WRITE(NFIPRI,'(1H*,77X,1H*)')
C
      END IF
C
C=======================================================================
C         PRINTING THE SPIN-ASYMMETRY-MOMENT SUM RULES
C=======================================================================
C
      IF (NASRED.GT.0.AND.NASMAX.GT.0.AND.ISRPRI.GE.0.AND.NBTKNO.EQ.1
     *               .AND.ICOMIX.EQ.0.AND.NASORD.GE.0) THEN
C
          NAMWRK='SPIN-ASYM'
C
          DO LAMBDA=1,MIN(NASRED,NASMAX)
C
                              MAXMIU=LAMBDA
C            IF (IAXIAL.EQ.1) MAXMIU=0
C
             DO MIU=-MAXMIU,MAXMIU
C
                NIU=IABS(MIU)
C
                WRITE(NFIPRI,'(
     *                1H*,1X,A9,'' L='',I2,'' M='',I2,
     *                    '' WMUL_T='',F15.6 ,2F16.6 , 2X,1H*)')
     *
     *                NAMWRK,LAMBDA,MIU,
     *                RASM_T(LAMBDA,MIU),
     *                WMUL_T(LAMBDA,MIU,0)
C
                NAMWRK='         '
C
             END DO
          END DO
C
          WRITE(NFIPRI,'(1H*,77X,1H*)')
C
      END IF
C
C=======================================================================
C         PRINTING THE SURFACE OR SCHIFF MOMENT SUM RULES
C=======================================================================
C
      IF (NSIRED.GE.0.AND.NSIMAX.GE.0.AND.ISRPRI.GE.0.AND.NBTKNO.EQ.1
     *                               .AND.ICOMIX.EQ.0) THEN
C
                           NAMWRK='SURFACE  '
          IF (ISCHIF.EQ.1) NAMWRK='SCHIFF   '
C
          DO LAMBDA=NSIMIN,MIN(NSIRED,NSIMAX)
C
                              MAXMIU=LAMBDA
C            IF (IAXIAL.EQ.1) MAXMIU=0
C
             DO MIU=-MAXMIU,MAXMIU
C
                NIU=IABS(MIU)
C
                WRITE(NFIPRI,'(
     *                1H*,1X,A9,'' L='',I2,'' M='',I2,
     *                    '' SMUL_P='',F15.6 ,2F16.6 , 2X,1H*)')
     *
     *                NAMWRK,LAMBDA,MIU,
     *                RSIF_P(LAMBDA,MIU),
     *                SMUL_P(LAMBDA,MIU)
C
                NAMWRK='         '
C
             END DO
          END DO
C
          WRITE(NFIPRI,'(1H*,77X,1H*)')
C
      END IF
C
      IF (ISRPRI.GE.0.AND.ICOMIX.EQ.0) WRITE(NFIPRI,'(79(1H*))')
C
   10 CONTINUE
C
C=======================================================================
C        HERE WE BEGIN CALCULATION OF THE REDUCED KERNELS OF
C        THE MULTIPOLE  (IN "REDQ_P"), MAGNETIC (IN "REDM_P"),
C        SPIN-ASYMMETRY (IN "REDA_T", ONLY FOR NASORD>-1) , AND
C        SURFACE OR SCHIFF (IN "REDS_P")
C        MOMENTS
C=======================================================================
C
C=======================================================================
C        ZEROING THE ARRAY  "INDRED" CONTAINING THE INDICES OF ARRAYS
C        "REDQ_P", "REDM_P", "REDA_T", AND "REDS_P"
C=======================================================================
C
      DO NPRLEF=1,NDPROK
         DO LAMBDA=0,MAX(NMURED,NMARED,NASRED,NSIRED)
            DO NPRRIG=1,NDPROK
C
               INDRED(NPRLEF,LAMBDA,NPRRIG)=0
C
            END DO
         END DO
      END DO
C
C=======================================================================
C        INITIALIZING THE ARRAYS "REDQ_P", "REDM_P", "REDA_T",
C        AND "REDS_P"
C=======================================================================
C
      NUREDU=0
C
      REDQ_P(NUREDU)  =C_ZERO
      REDM_P(NUREDU,:)=C_ZERO
      REDS_P(NUREDU)  =C_ZERO
      IF (NASORD.GE.0) REDA_T(NUREDU,:)=C_ZERO
C
C=======================================================================
C         THIS JUMP SUSPENDS CALCULATION OF RESULTS FOR A PARALLEL RUN
C=======================================================================
C
      IF (IPAKER.EQ.1) GO TO 11
C
C=======================================================================
C         CALCULATING THE REDUCED  K E R N E L S  OF MULTIPOLE OPERATORS
C=======================================================================
C         ATTENTION!
C         WE CALCULATE THE REDUCED  K E R N E L S  OF COMPLEX-CONJUGATED
C         MULTIPOLE AND MAGNETIC MOMENTS, WHICH ARE  TRUE  CONTRAVARIANT
C         SPHERICAL TENSORS. THIS IS SO BECAUSE ALL MOMENTS USED IN  THE
C         CODE ARE DEFINED IN TERMS OF THE COMPLEX CONJUGATED  SPHERICAL
C         HARMONICS, SEE COMMENTS IN SUBROUTINES "MOMETS" AND  "MAGMOM".
C         AS A RESULT, BELOW WE HAVE THE PHASE FACTOR (-1)**MIU AND  THE
C         NEGATIVE INDEX "-MIU".
C=======================================================================
C         ATTENTION!
C         THE REDUCED  K E R N E L S  FOR INDICES THAT  DO  NOT  FULFILL
C         THE ANGULAR-MOMENTUM SELECTION RULES ARE PUT INTO THE LOCATION
C         NUREDU=0 OF ARRAYS "REDQ_P", "REDM_P", "REDA_T", AND "REDS_P".
C=======================================================================
C         ATTENTION!
C         --> FOR DIAGONAL KERNELS (IDIAGO=1):
C         ONLY THE REDUCED  K E R N E L S  FOR THE "LEFT" (FINAL) SPIN
C         NOT LARGER THAN THE "RIGHT" (INITIAL) SPIN ARE CALCULATED.
C         --> FOR NONDIAGONAL KERNELS (IDIAGO=0) OR BY SETTING IALLAM=1
C         ALL  THE REDUCED  K E R N E L S  ARE CALCULATED.
C=======================================================================
C         FOR ILIMAM=1, THE LOOP BELOW CALCULATES ONLY THOSE  ANGULAR
C                       MOMENTA THAT ARE LATER REQUIRED FOR PRINTING.
C=======================================================================
C         ATTENTION: BETWEEN VERSIONS 2.83M AND 2.95S, THE MAXIMUM INDEX
C                    "MINDIK" BELOW  WAS  CALCULATED  USING  PROJECTIONS
C                    "KPRSTA" AND "KPRSTO" AND  NOT  USING  THE  MAXIMUM
C                    PROJECTION KPRRIG=JPROMA. AS RESULT, IN CASE OF THE
C                    AXIAL PROJECTION, SOME SECURITY  STOPS  BELOW  WERE
C                    UNNECESSARILY ACTIVATED. THIS BUG WAS CORRECTED  ON
C                    05/06/2020 IN VERSION 2.95T.
C=======================================================================
C
      MINDIK=IND_IK(JPROMA,JPROMA)
C
C=======================================================================
C
      DO IPRRIG=JPROMI,JPROMA,2
C
         DO KPRRIG=KPRSTA(IPRRIG),KPRSTO(IPRRIG),2
C
            DO LAMBDA=0,MAX(NMURED,NMARED,NASRED,NSIRED)
C
               MAXMIU=LAMBDA
C
                                      IMXLEF=IPRRIG
               IF (IDIAGO.NE.1.OR.IALLAM.EQ.1)
     *                                IMXLEF=MIN(JPROMA,IPRRIG+2*LAMBDA)
C
               DO IPRLEF=MAX(JPROMI,IPRRIG-2*LAMBDA),IMXLEF,2
C
                  DO KPRLEF=LPRSTA(IPRLEF),LPRSTO(IPRLEF),2
C
                     IF (ILIMAM.NE.1.OR.
     *                   IPRRIG.GE.ISLPRI.AND.IPRRIG.LE.ISUPRI.AND.
     *                   IPRLEF.GE.ISLPRI.AND.IPRLEF.LE.ISUPRI) THEN
C
C=======================================================================
C                    CHECKING IF THE LIST OF THE REDUCED KERNELS
C                    IS NOT TOO LONG
C=======================================================================
C
                         IF (NUREDU.LT.NDREDU) THEN
C
                             NUREDU=NUREDU+1
                         ELSE
                             STOP ' INCREASE NDREDU IN PROANG'
C
                         END IF
C
C=======================================================================
C
                         REDQ_P(NUREDU)  =C_ZERO
                         REDM_P(NUREDU,:)=C_ZERO
                         REDS_P(NUREDU)  =C_ZERO
                         IF (NASORD.GE.0)
     *                   REDA_T(NUREDU,:)=C_ZERO
C
                         INDRED(IND_IK(IPRLEF,KPRLEF),LAMBDA,
     *                          IND_IK(IPRRIG,KPRRIG))=NUREDU
C
                         DO MIU=-MAXMIU,MAXMIU
C
                            NIU=IABS(MIU)
C
                            MPRRIG=KPRLEF-2*MIU
C
                            IF (ABS(MPRRIG).LE.IPRRIG) THEN
C
C=======================================================================
C         ATTENTION: UP TO VERSION (3.10B), FOR PARITY  PROJECTION,  THE
C                    REDUCED MATRIX ELEMENTS OF THE PARITY-ODD MULTIPOLE
C                    OPERATORS (THOSE FOR THE ODD VALUES OF LAMBDA) WERE
C                    INCORRECTLY CALCULATED  INSTEAD  OF  BEING  SET  TO
C                    ZERO. THIS  BUG  WAS  CORRECTED  ON  25/01/2022  IN
C                    VERSION (3.10C).
C=======================================================================
C
                                IF (NPAKNO.EQ.1.OR.MOD(LAMBDA,2).EQ.0)
     *
     *                              REDQ_P(NUREDU)=REDQ_P(NUREDU)
     *                             +SQRT(IPRLEF+1.0D0)*(-1)**MIU
     *                             *CGCOEF(IPRRIG,MPRRIG,2*LAMBDA,2*MIU,
     *                                     IPRLEF,KPRLEF)
     *                             *TMUL_P(IND_LM(LAMBDA,-MIU),
     *                                     IREIMK(IPRRIG,MPRRIG,KPRRIG))
     *                             *QUNITS(LAMBDA,0)/QUNITS(LAMBDA,NIU)
C
C!!!!!!!!!!!!!!!!!!   printing for even spins
C     write (*,'(7I4,E12.4,2(3X,2E12.4))')
C    *          IPRLEF/2,KPRLEF/2,LAMBDA,MIU,IPRRIG/2,MPRRIG/2,KPRRIG/2,
C    *                              CGCOEF(IPRRIG,MPRRIG,2*LAMBDA,2*MIU,
C    *                                     IPRLEF,KPRLEF),
C    *                              TMUL_P(IND_LM(LAMBDA,-MIU),
C    *                                    INDIMK(IPRRIG,MPRRIG,KPRRIG)),
C    *                              REDQ_P(NUREDU)
C!!!!!!!!!!!!!!!!!!
                                IF (LAMBDA.GT.0.AND.LAMBDA.LE.NMARED)
     *                                                              THEN
                                    DO NUMORD=0,NMAORD
C
C=======================================================================
C         ATTENTION: UP TO VERSION (3.10B), FOR PARITY  PROJECTION,  THE
C                    REDUCED MATRIX ELEMENTS OF THE PARITY-EVEN MAGNETIC
C                    OPERATORS (THOSE FOR THE  EVEN  VALUES  OF  LAMBDA)
C                    WERE INCORRECTLY CALCULATED INSTEAD  OF  BEING  SET
C                    TO ZERO. THIS BUG WAS CORRECTED  ON  25/01/2022  IN
C                    VERSION  (3.10C).
C=======================================================================
C
                                       IF (NPAKNO.EQ.1.OR.
     *                                     MOD(LAMBDA,2).EQ.1)
     *
     *                                     REDM_P(NUREDU,NUMORD)=
     *                                     REDM_P(NUREDU,NUMORD)
     *                             +SQRT(IPRLEF+1.0D0)*(-1)**MIU
     *                             *CGCOEF(IPRRIG,MPRRIG,2*LAMBDA,2*MIU,
     *                                     IPRLEF,KPRLEF)
     *                             *TMAG_T(IND_LM(LAMBDA,-MIU),
     *                              IREIMK(IPRRIG,MPRRIG,KPRRIG),NUMORD)
     *                             *AUNITS(LAMBDA,0)/AUNITS(LAMBDA,NIU)
C
                                    END DO
C
                                END IF
C
                                IF (LAMBDA.GT.0.AND.LAMBDA.LE.NASRED)
     *                                                              THEN
                                    DO NUMORD=0,NASORD
C
                                           REDA_T(NUREDU,NUMORD)=
     *                                     REDA_T(NUREDU,NUMORD)
     *                             +SQRT(IPRLEF+1.0D0)*(-1)**MIU
     *                             *CGCOEF(IPRRIG,MPRRIG,2*LAMBDA,2*MIU,
     *                                     IPRLEF,KPRLEF)
     *                             *TASM_T(IND_LM(LAMBDA,-MIU),
     *                              IREIMK(IPRRIG,MPRRIG,KPRRIG),NUMORD)
     *                             *BUNITS(LAMBDA,0)/BUNITS(LAMBDA,NIU)
C
                                    END DO
C
                                END IF
C
                                IF (LAMBDA.GE.NSIMIN.AND.
     *                              LAMBDA.LE.NSIRED) THEN
C
C=======================================================================
C         ATTENTION: UP TO VERSION (3.10B), FOR PARITY  PROJECTION,  THE
C                    REDUCED MATRIX ELEMENTS OF THE  PARITY-ODD  SURFACE
C                    OPERATORS (THOSE FOR THE ODD VALUES OF LAMBDA) WERE
C                    INCORRECTLY CALCULATED  INSTEAD  OF  BEING  SET  TO
C                    ZERO. THIS  BUG  WAS  CORRECTED  ON  25/01/2022  IN
C                    VERSION (3.10C).
C=======================================================================
C
                                    IF (NPAKNO.EQ.1.OR.
     *                                  MOD(LAMBDA,2).EQ.0)
     *
     *                                  REDS_P(NUREDU)=REDS_P(NUREDU)
     *                             +SQRT(IPRLEF+1.0D0)*(-1)**MIU
     *                             *CGCOEF(IPRRIG,MPRRIG,2*LAMBDA,2*MIU,
     *                                     IPRLEF,KPRLEF)
     *                             *TSIF_P(IND_LM(LAMBDA,-MIU),
     *                                     IREIMK(IPRRIG,MPRRIG,KPRRIG))
     *                             *SUNITS(LAMBDA,0)/SUNITS(LAMBDA,NIU)
C
                                END IF
C
                            END IF
C
                         END DO
C
                     END IF
C
                  END DO
               END DO
C
            END DO
         END DO
      END DO
C
      IF (MINDIK.GT.NDPROK) STOP ' INCREASE NDPROK TO RUN PROANG'
C
C=======================================================================
C         PRINTING THE REDUCED KERNELS OF MULTIPOLE OPERATORS
C=======================================================================
C
      NAMWRK=NAMMUL
C
      I_HEAD=0
      I_HALF=0
C
      DO LAMBDA=0,NMURED
C
         DO IPRRIG=JPROMI,JPROMA,2
C
                                   IMXLEF=IPRRIG
            IF (IDIAGO.NE.1.OR.IALLAM.EQ.1)
     *                             IMXLEF=MIN(JPROMA,IPRRIG+2*LAMBDA)
C
            DO KPRRIG=KPRSTA(IPRRIG),KPRSTO(IPRRIG),2
C
               DO IPRLEF=MAX(JPROMI,IPRRIG-2*LAMBDA),IMXLEF,2
C
                  DO KPRLEF=LPRSTA(IPRLEF),LPRSTO(IPRLEF),2
C
                     IF (I_HEAD.EQ.0.AND.IKEPRI.GT.0.AND.
     *                   IPRRIG.GE.ISLPRI.AND.IPRRIG.LE.ISUPRI.AND.
     *                   IPRLEF.GE.ISLPRI.AND.IPRLEF.LE.ISUPRI) THEN
C
                         IF (IEVEN_.EQ.1) THEN
C
                     HAFLIN(1)='    IL    KL  L    IR    KR  <||Q||>  '
C
                         ELSE
C
                     HAFLIN(1)='  IL    KL    L  IR    KR    <||Q||>  '
C
                         END IF
C
                         WRITE(NFIPRI,'(1H*,77X,1H*,/,
     *                      1H*,1X,'' REDUCED  K E R N E L S  OF  '',
     *                                                 A45,2X,1H*,/,
     *                      1H*,1X,'' ONLY RESULTS WITH ABSOLUTE'',
     *                             '' VALUES LARGER THAN'',1PE10.3,
     *                             '' ARE PRINTED BELOW'', 2X,1H*,/,
     *                                                1H*,77X,1H*,/,
     *                      1H*,1X,'' THE TOTAL NUMBER OF  KERNELS '',
     *                             '' CALCULATED IS ='',I7,
     *                             '' AND NDREDU ='',I8,   2X,1H*,/,
     *                                                1H*,77X,1H*,/,
     *                              79(1H*),/,1H*,38X,1H*,38X,1H*,/,
     *                                        1H*,A38,1H*,A38,1H*,/,
     *                                        1H*,38X,1H*,38X,1H*)')
     *                      NAMWRK,QMUCUT,NUREDU,NDREDU,
     *                      HAFLIN(1),HAFLIN(1)
C
                         I_HEAD=1
C
                     END IF
C
                     NUREDU=INDRED(IND_IK(IPRLEF,KPRLEF),LAMBDA,
     *                             IND_IK(IPRRIG,KPRRIG))
C
                     IF (IKEPRI.GT.0.AND.
     *                   IPRRIG.GE.ISLPRI.AND.IPRRIG.LE.ISUPRI.AND.
     *                   IPRLEF.GE.ISLPRI.AND.IPRLEF.LE.ISUPRI.AND.
     *                   ABS(REAL(REDQ_P(NUREDU))).GT.QMUCUT) THEN
C
                         I_HALF=I_HALF+1
C
                         REEFIX=REAL(REDQ_P(NUREDU))
C
                         IF (ABS(REEFIX).GE.1E-3.AND.
     *                       ABS(REEFIX).LT.1E+2) THEN
C
                             WRITE(REEFIC,'(F9.5)')     REEFIX
                         ELSE
                             WRITE(REEFIC,'((1PE9.1))') REEFIX
C
                         END IF
C
                         WRITE(HAFLIN(I_HALF),
     *                         '(2(I4,A2),I3,2(I4,A2),A9,2X)')
     *                      IPRLEF/IEVEN_,CHALF_,
     *                      KPRLEF/IEVEN_,CHALF_,LAMBDA,
     *                      IPRRIG/IEVEN_,CHALF_,
     *                      KPRRIG/IEVEN_,CHALF_,
     *                      REEFIC
C
                         IF (I_HALF.EQ.2) THEN
C
                             I_HALF=0
C
                             WRITE(NFIPRI,'(1H*,A38,1H*,A38,1H*)')
     *                                                          HAFLIN
C
                         END IF
C
                     END IF
C
                  END DO
               END DO
C
            END DO
         END DO
C
         IF (LAMBDA.EQ.NMURED) THEN
C
             IF (I_HALF.EQ.1) WRITE(NFIPRI,'(1H*,A38,1H*,38X,1H*)')
     *                                                         HAFLIN(1)
C
             IF (IKEPRI.GT.0) WRITE(NFIPRI,'(1H*,77X,1H*,/,79(1H*))')
C
         END IF
C
      END DO
C
C=======================================================================
C         PRINTING THE REDUCED KERNELS OF MAGNETIC OPERATORS
C=======================================================================
C
      NAMWRK=NAMMAG
C
C=======================================================================
C         LOOP OVER RADIAL MOMENTS NOT INDENTED
C=======================================================================
C
      DO NUMORD=0,NMAORD
C
      I_HEAD=0
      I_HALF=0
C
      DO LAMBDA=1,NMARED
C
         DO IPRRIG=JPROMI,JPROMA,2
C
                                   IMXLEF=IPRRIG
            IF (IDIAGO.NE.1.OR.IALLAM.EQ.1)
     *                             IMXLEF=MIN(JPROMA,IPRRIG+2*LAMBDA)
C
            DO KPRRIG=KPRSTA(IPRRIG),KPRSTO(IPRRIG),2
C
               DO IPRLEF=MAX(JPROMI,IPRRIG-2*LAMBDA),IMXLEF,2
C
                  DO KPRLEF=LPRSTA(IPRLEF),LPRSTO(IPRLEF),2
C
                     IF (I_HEAD.EQ.0.AND.IKEPRI.GT.0.AND.
     *                   IPRRIG.GE.ISLPRI.AND.IPRRIG.LE.ISUPRI.AND.
     *                   IPRLEF.GE.ISLPRI.AND.IPRLEF.LE.ISUPRI) THEN
C
                         IF (IEVEN_.EQ.1) THEN
C
                     HAFLIN(1)='    IL    KL  L    IR    KR  <||M||>  '
C
                         ELSE
C
                     HAFLIN(1)='  IL    KL    L  IR    KR    <||M||>  '
C
                         END IF
C
                         IF (NUMORD.EQ.0) THEN
C
                             WRITE(NFIPRI,'(1H*,77X,1H*,/,
     *                          1H*,1X,'' REDUCED  K E R N E L S  OF  ''
     *                                                    ,A45,2X,1H*,/,
     *                          1H*,1X,'' ONLY RESULTS WITH ABSOLUTE'',
     *                                 '' VALUES LARGER THAN'',1PE10.3,
     *                                 '' ARE PRINTED BELOW'', 2X,1H*,/,
     *                                                    1H*,77X,1H*,/,
     *                                  79(1H*),/,1H*,38X,1H*,38X,1H*,/,
     *                                            1H*,A38,1H*,A38,1H*,/,
     *                                            1H*,38X,1H*,38X,1H*)')
     *                          NAMWRK,QMACUT,HAFLIN(1),HAFLIN(1)
C
                         ELSE
C
                             WRITE(NFIPRI,'(1H*,77X,1H*,/,
     *                          1H*,1X,'' RADIAL MOMENTS ORDER N='',I1,
     *                                            '' OF '',A45,2X,1H*,/,
     *                                                    1H*,77X,1H*,/,
     *                                  79(1H*),/,1H*,38X,1H*,38X,1H*,/,
     *                                            1H*,A38,1H*,A38,1H*,/,
     *                                            1H*,38X,1H*,38X,1H*)')
     *                          2*NUMORD,NAMMAR,HAFLIN(1),HAFLIN(1)
C
                         END IF
C
                         I_HEAD=1
C
                     END IF
C
                     NUREDU=INDRED(IND_IK(IPRLEF,KPRLEF),LAMBDA,
     *                             IND_IK(IPRRIG,KPRRIG))
C
                     IF (IKEPRI.GT.0.AND.
     *                   IPRRIG.GE.ISLPRI.AND.IPRRIG.LE.ISUPRI.AND.
     *                   IPRLEF.GE.ISLPRI.AND.IPRLEF.LE.ISUPRI.AND.
     *                   ABS(REAL(REDM_P(NUREDU,NUMORD))).GT.QMACUT)THEN
C
                         I_HALF=I_HALF+1
C
                         REEFIX=REAL(REDM_P(NUREDU,NUMORD))
C
                         IF (ABS(REEFIX).GE.1E-3.AND.
     *                       ABS(REEFIX).LT.1E+2) THEN
C
                             WRITE(REEFIC,'(F9.5)')     REEFIX
                         ELSE
                             WRITE(REEFIC,'((1PE9.1))') REEFIX
C
                         END IF
C
                         WRITE(HAFLIN(I_HALF),
     *                         '(2(I4,A2),I3,2(I4,A2),A9,2X)')
     *                      IPRLEF/IEVEN_,CHALF_,
     *                      KPRLEF/IEVEN_,CHALF_,LAMBDA,
     *                      IPRRIG/IEVEN_,CHALF_,
     *                      KPRRIG/IEVEN_,CHALF_,
     *                      REEFIC
C
                         IF (I_HALF.EQ.2) THEN
C
                             I_HALF=0
C
                             WRITE(NFIPRI,'(1H*,A38,1H*,A38,1H*)')
     *                                                          HAFLIN
C
                         END IF
C
                     END IF
C
                  END DO
               END DO
C
            END DO
         END DO
C
         IF (LAMBDA.EQ.NMARED) THEN
C
             IF (I_HALF.EQ.1) WRITE(NFIPRI,'(1H*,A38,1H*,38X,1H*)')
     *                                                         HAFLIN(1)
C
             IF (IKEPRI.GT.0) WRITE(NFIPRI,'(1H*,77X,1H*,/,79(1H*))')
C
         END IF
C
      END DO
C
      END DO
C
C=======================================================================
C         PRINTING THE REDUCED KERNELS OF SPIN-ASYMMETRY OPERATORS
C=======================================================================
C
      NAMWRK=NAMASM
C
C=======================================================================
C         LOOP OVER RADIAL MOMENTS NOT INDENTED
C=======================================================================
C
      DO NUMORD=0,NASORD
C
      I_HEAD=0
      I_HALF=0
C
      DO LAMBDA=1,NASRED
C
         DO IPRRIG=JPROMI,JPROMA,2
C
                                   IMXLEF=IPRRIG
            IF (IDIAGO.NE.1.OR.IALLAM.EQ.1)
     *                             IMXLEF=MIN(JPROMA,IPRRIG+2*LAMBDA)
C
            DO KPRRIG=KPRSTA(IPRRIG),KPRSTO(IPRRIG),2
C
               DO IPRLEF=MAX(JPROMI,IPRRIG-2*LAMBDA),IMXLEF,2
C
                  DO KPRLEF=LPRSTA(IPRLEF),LPRSTO(IPRLEF),2
C
                     IF (I_HEAD.EQ.0.AND.IKEPRI.GT.0.AND.
     *                   IPRRIG.GE.ISLPRI.AND.IPRRIG.LE.ISUPRI.AND.
     *                   IPRLEF.GE.ISLPRI.AND.IPRLEF.LE.ISUPRI) THEN
C
                         IF (IEVEN_.EQ.1) THEN
C
                     HAFLIN(1)='    IL    KL  L    IR    KR  <||M||>  '
C
                         ELSE
C
                     HAFLIN(1)='  IL    KL    L  IR    KR    <||M||>  '
C
                         END IF
C
                         IF (NUMORD.EQ.0) THEN
C
                             WRITE(NFIPRI,'(1H*,77X,1H*,/,
     *                          1H*,1X,'' REDUCED  K E R N E L S  OF  ''
     *                                                    ,A45,2X,1H*,/,
     *                          1H*,1X,'' ONLY RESULTS WITH ABSOLUTE'',
     *                                 '' VALUES LARGER THAN'',1PE10.3,
     *                                 '' ARE PRINTED BELOW'', 2X,1H*,/,
     *                                                    1H*,77X,1H*,/,
     *                                  79(1H*),/,1H*,38X,1H*,38X,1H*,/,
     *                                            1H*,A38,1H*,A38,1H*,/,
     *                                            1H*,38X,1H*,38X,1H*)')
     *                          NAMWRK,QASCUT,HAFLIN(1),HAFLIN(1)
C
                         ELSE
C
                             WRITE(NFIPRI,'(1H*,77X,1H*,/,
     *                          1H*,1X,'' RADIAL MOMENTS ORDER N='',I1,
     *                                            '' OF '',A45,2X,1H*,/,
     *                                                    1H*,77X,1H*,/,
     *                                  79(1H*),/,1H*,38X,1H*,38X,1H*,/,
     *                                            1H*,A38,1H*,A38,1H*,/,
     *                                            1H*,38X,1H*,38X,1H*)')
     *                          2*NUMORD,NAMASR,HAFLIN(1),HAFLIN(1)
C
                         END IF
C
                         I_HEAD=1
C
                     END IF
C
                     NUREDU=INDRED(IND_IK(IPRLEF,KPRLEF),LAMBDA,
     *                             IND_IK(IPRRIG,KPRRIG))
C
                     IF (IKEPRI.GT.0.AND.
     *                   IPRRIG.GE.ISLPRI.AND.IPRRIG.LE.ISUPRI.AND.
     *                   IPRLEF.GE.ISLPRI.AND.IPRLEF.LE.ISUPRI.AND.
     *                   ABS(REAL(REDA_T(NUREDU,NUMORD))).GT.QASCUT)THEN
C
                         I_HALF=I_HALF+1
C
                         REEFIX=REAL(REDA_T(NUREDU,NUMORD))
C
                         IF (ABS(REEFIX).GE.1E-3.AND.
     *                       ABS(REEFIX).LT.1E+2) THEN
C
                             WRITE(REEFIC,'(F9.5)')     REEFIX
                         ELSE
                             WRITE(REEFIC,'((1PE9.1))') REEFIX
C
                         END IF
C
                         WRITE(HAFLIN(I_HALF),
     *                         '(2(I4,A2),I3,2(I4,A2),A9,2X)')
     *                      IPRLEF/IEVEN_,CHALF_,
     *                      KPRLEF/IEVEN_,CHALF_,LAMBDA,
     *                      IPRRIG/IEVEN_,CHALF_,
     *                      KPRRIG/IEVEN_,CHALF_,
     *                      REEFIC
C
                         IF (I_HALF.EQ.2) THEN
C
                             I_HALF=0
C
                             WRITE(NFIPRI,'(1H*,A38,1H*,A38,1H*)')
     *                                                          HAFLIN
C
                         END IF
C
                     END IF
C
                  END DO
               END DO
C
            END DO
         END DO
C
         IF (LAMBDA.EQ.NASRED) THEN
C
             IF (I_HALF.EQ.1) WRITE(NFIPRI,'(1H*,A38,1H*,38X,1H*)')
     *                                                         HAFLIN(1)
C
             IF (IKEPRI.GT.0) WRITE(NFIPRI,'(1H*,77X,1H*,/,79(1H*))')
C
         END IF
C
      END DO
C
      END DO
C
C=======================================================================
C         PRINTING THE REDUCED KERNELS OF SURFACE OPERATORS
C=======================================================================
C
                       NAMWRK=NAMSUR
      IF (ISCHIF.EQ.1) STOP ' ISCHIF=1 NOT ALLOWED IN PROANG'
C
      I_HEAD=0
      I_HALF=0
C
      DO LAMBDA=NSIMIN,NSIRED
C
         DO IPRRIG=JPROMI,JPROMA,2
C
                                   IMXLEF=IPRRIG
            IF (IDIAGO.NE.1.OR.IALLAM.EQ.1)
     *                             IMXLEF=MIN(JPROMA,IPRRIG+2*LAMBDA)
C
            DO KPRRIG=KPRSTA(IPRRIG),KPRSTO(IPRRIG),2
C
               DO IPRLEF=MAX(JPROMI,IPRRIG-2*LAMBDA),IMXLEF,2
C
                  DO KPRLEF=LPRSTA(IPRLEF),LPRSTO(IPRLEF),2
C
                     IF (I_HEAD.EQ.0.AND.IKEPRI.GT.0.AND.
     *                   IPRRIG.GE.ISLPRI.AND.IPRRIG.LE.ISUPRI.AND.
     *                   IPRLEF.GE.ISLPRI.AND.IPRLEF.LE.ISUPRI) THEN
C
                         IF (IEVEN_.EQ.1) THEN
C
                     HAFLIN(1)='    IL    KL  L    IR    KR  <||S||>  '
C
                         ELSE
C
                     HAFLIN(1)='  IL    KL    L  IR    KR    <||S||>  '
C
                         END IF
C
                         WRITE(NFIPRI,'(1H*,77X,1H*,/,
     *                      1H*,1X,'' REDUCED  K E R N E L S  OF  '',
     *                                                 A45,2X,1H*,/,
     *                      1H*,1X,'' ONLY RESULTS WITH ABSOLUTE'',
     *                             '' VALUES LARGER THAN'',1PE10.3,
     *                             '' ARE PRINTED BELOW'', 2X,1H*,/,
     *                                                1H*,77X,1H*,/,
     *                              79(1H*),/,1H*,38X,1H*,38X,1H*,/,
     *                                        1H*,A38,1H*,A38,1H*,/,
     *                                        1H*,38X,1H*,38X,1H*)')
     *                      NAMWRK,QSICUT,HAFLIN(1),HAFLIN(1)
C
                         I_HEAD=1
C
                     END IF
C
                     NUREDU=INDRED(IND_IK(IPRLEF,KPRLEF),LAMBDA,
     *                             IND_IK(IPRRIG,KPRRIG))
C
                     IF (IKEPRI.GT.0.AND.
     *                   IPRRIG.GE.ISLPRI.AND.IPRRIG.LE.ISUPRI.AND.
     *                   IPRLEF.GE.ISLPRI.AND.IPRLEF.LE.ISUPRI.AND.
     *                   ABS(REAL(REDS_P(NUREDU))).GT.QSICUT) THEN
C
                         I_HALF=I_HALF+1
C
                         REEFIX=REAL(REDS_P(NUREDU))
C
                         IF (ABS(REEFIX).GE.1E-3.AND.
     *                       ABS(REEFIX).LT.1E+2) THEN
C
                             WRITE(REEFIC,'(F9.5)')     REEFIX
                         ELSE
                             WRITE(REEFIC,'((1PE9.1))') REEFIX
C
                         END IF
C
                         WRITE(HAFLIN(I_HALF),
     *                         '(2(I4,A2),I3,2(I4,A2),A9,2X)')
     *                      IPRLEF/IEVEN_,CHALF_,
     *                      KPRLEF/IEVEN_,CHALF_,LAMBDA,
     *                      IPRRIG/IEVEN_,CHALF_,
     *                      KPRRIG/IEVEN_,CHALF_,
     *                      REEFIC
C
                         IF (I_HALF.EQ.2) THEN
C
                             I_HALF=0
C
                             WRITE(NFIPRI,'(1H*,A38,1H*,A38,1H*)')
     *                                                          HAFLIN
C
                         END IF
C
                     END IF
C
                  END DO
               END DO
C
            END DO
         END DO
C
         IF (LAMBDA.EQ.NSIRED) THEN
C
             IF (I_HALF.EQ.1) WRITE(NFIPRI,'(1H*,A38,1H*,38X,1H*)')
     *                                                         HAFLIN(1)
C
             IF (IKEPRI.GT.0) WRITE(NFIPRI,'(1H*,77X,1H*,/,79(1H*))')
C
         END IF
C
      END DO
C
C=======================================================================
C                    PRINTING THE SUM RULES
C=======================================================================
C
      IF (MOD(IPRKER/10,10).EQ.1) THEN
C
          WRITE(NFIPRI,892) RKER_T,RSKY_T,RKIN_T,RCOU_D,RCOU_X
 892      FORMAT(/,
     *    'ORTHOGONALITY FOR OVERLAP DECOMPOSITION:',2F16.12,/,
     *    'ORTHOGONALITY FOR SKYRME  DECOMPOSITION:',2F16.6,/,
     *    'ORTHOGONALITY FOR EKINET  DECOMPOSITION:',2F16.6,/,
     *    'ORTHOGONALITY FOR COUL_D  DECOMPOSITION:',2F16.6,/,
     *    'ORTHOGONALITY FOR COUL_X  DECOMPOSITION:',2F16.6,/,
     *       2X,'----------------------------------')
C
          DO LAMBDA=0,NMURED
             DO MIU=-LAMBDA,LAMBDA
C
                NIU=IABS(MIU)
C
                WRITE(NFIPRI,'(2I4,2E22.14,2X,2E22.14)') LAMBDA,MIU,
     *                         RMUL_P(LAMBDA,MIU)*QUNITS(LAMBDA,NIU),
     *                         RMAG_T(LAMBDA,MIU)*AUNITS(LAMBDA,NIU)
C
             END DO
          END DO
C
      END IF
C
C=======================================================================
C
C         ATTENTION: UP TO VERSION 2.91, STATEMENTS BELOW WERE MODIFYING
C                    THE INPUT VARIABLES "CUTOVE"  AND  "CUTOVF",  WHICH
C                    WAS VIOLATING THE INPUT-VARIABLE RULES.THIS BUG WAS
C                    CORRECTED ON 10/07/2019 IN VERSION (2.90A).
C=======================================================================
C
      IF (LPROJJ.EQ.0) THEN
          CUTOWE=EPSISO
          CUTOWF=0
      ELSE
          CUTOWE=CUTOVE
          CUTOWF=CUTOVF
      END IF
C
C=======================================================================
C                     CALCULATING THE MIXING
C=======================================================================
C
      IF (IPROAN.EQ.1.OR.IPROAN.EQ.2) THEN
C
C=======================================================================
C         HERE WE DO THE K-MIXING
C=======================================================================
C
          IF (IDIAGO.EQ.1) THEN
C
C=======================================================================
C         ATTENTION: BETWEEN VERSIONS 2.75M AND 3.04N,  CONDITION  BELOW
C                    WAS INCORRECTLY CODED. AS A RESULT, FOR THE ISOSPIN
C                    PROJECTION, RESULTS  OF  THE  K-MIXING  CALCULATION
C                    WERE INCORRECT. THIS BUG WAS CORRECTED ON 19/4/2021
C                    IN VERSION 3.04O.
C=======================================================================
C
              IF (NATKNO.EQ.1) THEN
C
                  CALL DIAPRO(JPROMI,JPROMA,KPROJE,IAXIAL,IHALF_,
     *                        JSOSMI,JSOSMA,ISOSTZ,LPROJJ,LPROJT,
     *                                      ICUTOV,CUTOWE,CUTOWF,
     *                                      IMIPRI,ISLPRI,ISUPRI,
     *                                             NUISOM,IENPRI,
     *                                             MINDIK,IBETME)
C
                  IF (IWRWAV.EQ.1) THEN
C
                      IWRBLO=2
C
C=======================================================================
C         ATTENTION: BETWEEN VERSIONS (3.11A) AND  (3.15H), THE ARGUMENT
C                    "ISIMPY" WAS NOT TRANSFERRED TO SUBROUTINE "SAVEWF"
C                    THIS  BUG  WAS  CORRECTED  IN  VERSION  (3.15I)  ON
C                    05/11/2022.
C=======================================================================
C
                      CALL SAVEWF(NFIWAV,ILFWAV,FILWAV,IWRBLO,
     *                                          MINDIK,NUISOM,
     *                                   KPROJE,ISIQTY,ISIMPY,
     *                            IDSIQN,IDSIQP,IDSIZN,IDSIZP)
C
                  END IF
C
              ELSE
C
C=======================================================================
C      IN DIAP3D EPROJE CONTAINS ONLY ISOSCALAR PART OF THE TOTAL ENERGY
C      THE ISOVECTOR AND ISOTENSOR PARTS OF COULOMB ARE ADDED IN DIAP3D
C=======================================================================
C
                  DO INDPRO=1,NUPROM
                     DO INDISO=1,NUISOM
C
                        EPROJE(INDPRO,INDISO)=
     *                  TSK_TT(INDPRO,INDISO)
     *                 +TKI_NT(INDPRO,INDISO)
     *                 +TKI_PT(INDPRO,INDISO)
     *                 +TCO_DT(INDPRO,INDISO)
     *                 +TCO_XT(INDPRO,INDISO)
C
                        ISOSAC=ISOMAT(INDISO)
                        LSOSAC=LSOMAT(INDISO)
                        KSOSAC=KSOMAT(INDISO)
C
                     END DO
                  END DO
C
                  CALL DIAP3D(JPROMI,JPROMA,KPROJE,KPLEFT,IAXIAL,LPROJJ,
     *                        JSOSMI,JSOSMA,ISOSTZ,IAXIAT,LPROJT,
     *                               IHALF_,ICUTOV,CUTOWE,CUTOWF,
     *                                      IMIPRI,ISLPRI,ISUPRI,
     *                                                    IENPRI,
     *                                             MINDIK,IBETME)
C
              END IF
C
          END IF
C
C=======================================================================
C         CALCULATING THE REDUCED MATRIX ELEMENTS FOR THE K-MIXED STATES
C=======================================================================
C
          IF (LPROJJ.EQ.1.AND.LPROJT.EQ.0.AND.IRMPRI.EQ.1) THEN
C
              CALL REDPRO(JPROMI,JPROMA,KPROJE,KPLEFT,IAXIAL,IHALF_,
     *                    ISCHIF,NMURED,NMARED,NASRED,NSIRED,NSIMIN,
     *                           ILFWAV,IRGWAV,NFIWAV,FILWAV,
     *                    IDIAGO,IRMPRI,IELPRI,ISLPRI,ISUPRI,
     *                    LPROJJ,IWRIRM,NFIRED,NMAORD,NASORD,
     *                    MINDIK,NUISOM,QMUCUT,QMACUT,QASCUT,QSICUT)
C
          END IF
C
C=======================================================================
C         HERE WE DO THE CONFIGURATION MIXING
C=======================================================================
C
      ELSE IF (IPROAN.EQ.3) THEN
C
          IF (IDIAGO.EQ.0) THEN
C
C=======================================================================
C             PRINT/STORE MATRIX ELEMENTS FOR FURTHER CONFIGURATION
C             MIXING CALCULATIONS:
C=======================================================================
C
C             IT=0
C             DO ISOSAC=ISOSMI,ISOSMA,2
C             IT=IT+1
C
              DO INDISO=1,NUISOM
C
                 ISOSAC=ISOMAT(INDISO)
C
                 LPROIN=0
C
                 DO LPROAC=LPRSTA(IIFERR),LPRSTO(IIFERR),2
C
                    LPROIN=LPROIN+1
                    KPROIN=0
C
                    DO KPROAC=KPRSTA(IIFERR),KPRSTO(IIFERR),2
C
                       KPROIN=KPROIN+1
C
                       IF (ICMPRI.GE.3)
     *                     WRITE(*,631)
     *                     ISOSAC/IEVEN_,CHALF_,IIFERR/IEVEN_,CHALF_,
     *                     LPROAC/IEVEN_,CHALF_,KPROAC/IEVEN_,CHALF_,
     *                     TKE_TT(INDIMK(IIFERR,LPROAC,KPROAC),INDISO),
     *                     EPROJE(INDIMK(IIFERR,LPROAC,KPROAC),INDISO)
C
 631                   FORMAT(1H*,4(I3,A2),4F14.6,1X,1H*)
C
                       IF (ICOMIX.EQ.1) THEN
                           OVEMIX(INLWAV,INRWAV,LPROIN,KPROIN,INDISO)=
     *                      TKE_TT(INDIMK(IIFERR,LPROAC,KPROAC),INDISO)
                           ESKMIX(INLWAV,INRWAV,LPROIN,KPROIN,INDISO)=
     *                      TSK_TT(INDIMK(IIFERR,LPROAC,KPROAC),INDISO)
                           IF (INLWAV.NE.INRWAV)
     *                     OVEMIX(INRWAV,INLWAV,KPROIN,LPROIN,INDISO)=
     *                 CONJG(OVEMIX(INLWAV,INRWAV,LPROIN,KPROIN,INDISO))
                           IF (INLWAV.NE.INRWAV)
     *                     ESKMIX(INRWAV,INLWAV,KPROIN,LPROIN,INDISO)=
     *                 CONJG(ESKMIX(INLWAV,INRWAV,LPROIN,KPROIN,INDISO))
                       END IF
C
                    END DO
                 END DO
              END DO
C
              OCNMIX(INDBRA,INDKET)=C_ZERO
              HCNMIX(INDBRA,INDKET)=C_ZERO
C
C             ITL=0
C             DO ISOSAL=ISOSMI,ISOSMA,2
C             ITL=ITL+1
C
C                ITR=0
C                DO ISOSAR=ISOSMI,ISOSMA,2
C                ITR=ITR+1
C
              DO INDISL=1,NUISOM
C
                 ISOSAL=ISOMAT(INDISL)
C
                 DO INDISR=1,NUISOM
C
                    ISOSAR=ISOMAT(INDISR)
C
                    DO LPROAC=LPRSTA(IIFERR),LPRSTO(IIFERR),2
                       DO KPROAC=KPRSTA(IIFERR),KPRSTO(IIFERR),2
C
                          IF (INDISL.EQ.INDISR) THEN
                              OCNMIX(INDBRA,INDKET)=
     *                        OCNMIX(INDBRA,INDKET)+
     *                        CONJG(F_KT_L(LPROAC,INDISL,0))*
     *                        F_KT_R(KPROAC,INDISR,0)*
     *                      TKE_TT(INDIMK(IIFERR,LPROAC,KPROAC),INDISR)
C
                              HCNMIX(INDBRA,INDKET)=
     *                        HCNMIX(INDBRA,INDKET)+
     *                        CONJG(F_KT_L(LPROAC,INDISL,0))*
     *                        F_KT_R(KPROAC,INDISR,0)*
     *                     (TSK_TT(INDIMK(IIFERR,LPROAC,KPROAC),INDISR)
     *                     +TKI_NT(INDIMK(IIFERR,LPROAC,KPROAC),INDISR)
     *                     +TKI_PT(INDIMK(IIFERR,LPROAC,KPROAC),INDISR)
     *                     +TCO_DT(INDIMK(IIFERR,LPROAC,KPROAC),INDISR)
     *                     +TCO_XT(INDIMK(IIFERR,LPROAC,KPROAC),INDISR))
                          END IF
C
                         E_10=CGCOEF(ISOSAR,ISOSTZ  ,2, 0,ISOSAL,ISOSTZ)
                         E11P=CGCOEF(ISOSAR,ISOSTZ-2,2, 2,ISOSAL,ISOSTZ)
                         E11M=CGCOEF(ISOSAR,ISOSTZ+2,2,-2,ISOSAL,ISOSTZ)
                         E_20=CGCOEF(ISOSAR,ISOSTZ  ,4, 0,ISOSAL,ISOSTZ)
                         E21P=CGCOEF(ISOSAR,ISOSTZ-2,4, 2,ISOSAL,ISOSTZ)
                         E21M=CGCOEF(ISOSAR,ISOSTZ+2,4,-2,ISOSAL,ISOSTZ)
                         E22P=CGCOEF(ISOSAR,ISOSTZ-4,4, 4,ISOSAL,ISOSTZ)
                         E22M=CGCOEF(ISOSAR,ISOSTZ+4,4,-4,ISOSAL,ISOSTZ)
C
                          E211P=E_10*E11P
                          E211M=E_10*E11M
C
                          E221P=E_20*E21P
                          E221M=E_20*E21M
                          E222P=E_20*E22P
                          E222M=E_20*E22M
C
                          E2_10=E_10*E_10
                          E2_20=E_20*E_20
C
                          HCNMIX(INDBRA,INDKET)=HCNMIX(INDBRA,INDKET)+
     *                    CONJG(F_KT_L(LPROAC,INDISL,0))*
     *                    F_KT_R(KPROAC,INDISR,0)*
     *               (TC1_D0(INDIMK(IIFERR,LPROAC,KPROAC),INDISR)*E2_10
     *               +TC1_DP(INDIMK(IIFERR,LPROAC,KPROAC),INDISR)*E211P
     *               +TC1_DM(INDIMK(IIFERR,LPROAC,KPROAC),INDISR)*E211M
     *               +TC2_D0(INDIMK(IIFERR,LPROAC,KPROAC),INDISR)*E2_20
     *               +TC21DP(INDIMK(IIFERR,LPROAC,KPROAC),INDISR)*E221P
     *               +TC21DM(INDIMK(IIFERR,LPROAC,KPROAC),INDISR)*E221M
     *               +TC22DP(INDIMK(IIFERR,LPROAC,KPROAC),INDISR)*E222P
     *               +TC22DM(INDIMK(IIFERR,LPROAC,KPROAC),INDISR)*E222M
     *               +TC1_X0(INDIMK(IIFERR,LPROAC,KPROAC),INDISR)*E2_10
     *               +TC1_XP(INDIMK(IIFERR,LPROAC,KPROAC),INDISR)*E211P
     *               +TC1_XM(INDIMK(IIFERR,LPROAC,KPROAC),INDISR)*E211M
     *               +TC2_X0(INDIMK(IIFERR,LPROAC,KPROAC),INDISR)*E2_20
     *               +TC21XP(INDIMK(IIFERR,LPROAC,KPROAC),INDISR)*E221P
     *               +TC21XM(INDIMK(IIFERR,LPROAC,KPROAC),INDISR)*E221M
     *               +TC22XP(INDIMK(IIFERR,LPROAC,KPROAC),INDISR)*E222P
     *               +TC22XM(INDIMK(IIFERR,LPROAC,KPROAC),INDISR)*E222M)
C
                       END DO
                    END DO
                 END DO
              END DO
C
              OCNMIX(INDKET,INDBRA)=CONJG(OCNMIX(INDBRA,INDKET))
              HCNMIX(INDKET,INDBRA)=CONJG(HCNMIX(INDBRA,INDKET))
C
              IF (ICMPRI.GE.2)
     *            WRITE(*,632) INDBRA,INDKET,OCNMIX(INDBRA,INDKET),
     *                                       HCNMIX(INDBRA,INDKET)
 632              FORMAT(1H*,5X,2(I3),2F16.10,2F14.6,6X,1H*)
C
              IF (KONMIX.EQ.1) CALL CONMIX(INDKET,ICMPRI,NFIFER,FILFER,
     *                                            IEVEN_,CHALF_,JSOSMI,
     *                                     JSOSMA,ISOSTZ,IIFERR,EPSMIX)
C
          END IF
C
C=======================================================================
C         MULTI-REFERENCE DIAGONALIZATION
C=======================================================================
C
      ELSE IF (IPROAN.EQ.4.OR.IPROAN.EQ.5) THEN
C
C=======================================================================
C         FOR IPROAN=4, SUBROUTINE "PROANG" IS CALLED IN THE DOUBLE LOOP
C         OVER THE LEFT AND RIGHT SINGLE-REFERENCE STATES, FOR WHICH ALL
C         KERNELS ARE SUPPOSED TO HAVE ALREADY BEEN CALCULATED.
C         IN THE FIRST CALL  TO  "PROANG",  THE  SIZES  OF  ARRAYS  THAT
C         COLLECT THE DIAGONAL (NMRMIX) OR OFF-DIAGONAL (LMRMIX)  MATRIX
C         ELEMENTS ARE SET EITHER TO:
C         THE PREDEFINED VALUES OF ...... (FOR I_PASS=1) OR TO
C         THE CALCULATED VALUES OF ...... (FOR I_PASS=2).
C         THE LATTER VALUES ARE CALCULATED ONLY IF THE FORMER ONES  TURN
C         OUT TO BE INSUFFICIENT.
C=======================================================================
C         FOR IPROAN=5, SUBROUTINE "PROANG" WILL BE CALLED FOR MULTI
C         MULTI-REFERENCE STATES (NOT IMPLEMENTED YET).
C=======================================================================
C
          IF (IPROAN.EQ.5) STOP 'IPROAN=5 NOT IMPLEMENTED YET'
C
          IF (N_CALL.EQ.1) THEN
              IF (I_PASS.EQ.1) THEN
C
C                 THE PREDEFINED VALUES OF SIZES:
C
                  NMRMIX=3000
                  LMRMIX=10000
C
              ELSE
                  DEALLOCATE (OMRMIX,EMRMIX,QMRMIX,AMRMIX,WMRMIX,SMRMIX)
                  DEALLOCATE (NMATMI,LMATMI)
C
C                 THE CALCULATED VALUES OF SIZES:
C
                  NMRMIX=NMURMI
                  LMRMIX=LMURMI
C
              END IF
C
              NMURMI=0
C
          END IF
C
          IF (.NOT.ALLOCATED(OMRMIX)) THEN
              ALLOCATE (OMRMIX(0:NMRMIX)
     *                                                     ,STAT=IALLOC)
              IF (IALLOC.NE.0) CALL NOALLO('OMRMIX','PROANG')
          END IF
C
          IF (.NOT.ALLOCATED(EMRMIX)) THEN
              ALLOCATE (EMRMIX(0:NMRMIX)
     *                                                     ,STAT=IALLOC)
              IF (IALLOC.NE.0) CALL NOALLO('EMRMIX','PROANG')
          END IF
C
          IF (.NOT.ALLOCATED(NMATMI)) THEN
              ALLOCATE (NMATMI(0:NDPROI,0:NDISOM,
     *                         1:NDCONF,1:NDCONF,
     *                         1:NDCOLE,1:NDCOLE),STAT=IALLOC)
              IF (IALLOC.NE.0) CALL NOALLO('NMATMI','PROANG')
              NMATMI=0
          END IF
C
          IF (.NOT.ALLOCATED(QMRMIX)) THEN
              ALLOCATE (QMRMIX(0:LMRMIX),STAT=IALLOC)
              IF (IALLOC.NE.0) CALL NOALLO('QMRMIX','PROANG')
          END IF
C
          IF (.NOT.ALLOCATED(AMRMIX)) THEN
              ALLOCATE (AMRMIX(0:LMRMIX),STAT=IALLOC)
              IF (IALLOC.NE.0) CALL NOALLO('AMRMIX','PROANG')
          END IF
C
          IF (.NOT.ALLOCATED(WMRMIX)) THEN
              ALLOCATE (WMRMIX(0:LMRMIX),STAT=IALLOC)
              IF (IALLOC.NE.0) CALL NOALLO('WMRMIX','PROANG')
          END IF
C
          IF (.NOT.ALLOCATED(SMRMIX)) THEN
              ALLOCATE (SMRMIX(0:LMRMIX),STAT=IALLOC)
              IF (IALLOC.NE.0) CALL NOALLO('SMRMIX','PROANG')
          END IF
C
          IF (.NOT.ALLOCATED(LMATMI)) THEN
              ALLOCATE (LMATMI(0:NDPROI,0:NDLAMB,0:NDPROI,
     *                         1:NDCONF,1:NDCONF,
     *                         1:NDCOLE,1:NDCOLE),STAT=IALLOC)
              IF (IALLOC.NE.0) CALL NOALLO('LMATMI','PROANG')
              LMATMI=0
          END IF
C
C=======================================================================
C         READING THE K-MIXING COEFFICIENTS. THE WAVE-FUNCTION FILES
C         WITH NUMBERS "INLWAV" AND "INRWAV" MUST CONTAIN PREVIOUSLY
C         SAVED BLOCKS 2.
C=======================================================================
C
          IWRBLO=2
C
          CALL READWF(NFIWAV,INRWAV,FILWAV,IWRBLO,MINDIK,1,KPLEFT)
C
          WAVPRO=WAVLEF
          NUMPRO=NUMLEF
          KPRIGH=KPLEFT
C
          MIXCOL(:,:,INRWAV)=NUMPRO(:,:)
C
          CALL READWF(NFIWAV,INLWAV,FILWAV,IWRBLO,MINDIK,1,KPLEFT)
C
C=======================================================================
C         FILLING ARRAYS "OMRMIX" AND "EMRMIX" WITH OVERLAPS AND  ENERGY
C         MATRIX ELEMENTS, RESPECTIVELY, THAT CORRESPOND TO  THE  MULTI-
C         REFERENCE DIAGONALIZATION
C=======================================================================
C
          OMRMIX(0)=C_ZERO
          EMRMIX(0)=C_ZERO
C
          DO INDISO=1,NUISOM
C
             DO IPROAC=JPROMI,JPROMA,2
C
C=======================================================================
C              HERE WE COUNT THE TOTAL NUMBER OF SINGLE-REFERENCE  RIGHT
C              STATES THAT WILL CONTRIBUTE TO THE MIXING  IN  ALL  SPINS
C=======================================================================
C
                DO INRCOL=1,NUMPRO(IPROAC,INDISO)
C
                   DO INLCOL=1,NUMLEF(IPROAC,INDISO)
C
                      IF (NMURMI.LT.NMRMIX) THEN
C
C                         HERE THE SIZES OF ARRAYS "OMRMIX" AND "EMRMIX"
C                         ARE  STILL  SUFFICIENT  AND  THE  SECOND  PASS
C                         THROUGH THE SINGLE-REFERENCE LOOPS WILL NOT BE
C                         REQUIRED.
C
                          NMURMI=NMURMI+1
                          NINDMI=NMURMI
                          I_PASS=1
C
                      ELSE
C
C                         HERE THE SIZES ABOVE ARE INSUFFICIENT AND  THE
C                         SECOND PASS THROUGH THE SINGLE-REFERENCE LOOPS
C                         WILL BE REQUIRED.
C
                          NMURMI=NMURMI+1
                          NINDMI=0
                          I_PASS=2
C
                      END IF
C
                      IF (IPROAC.GT.NDPROI)
     *                               STOP 'INCRESE NDPROI (1) IN PROANG'
                      IF (INDISO.GT.NDISOM)
     *                               STOP 'INCRESE NDISOM (1) IN PROANG'
                      IF (INLWAV.GT.NDCONF)
     *                               STOP 'INCRESE NDCONF (1) IN PROANG'
                      IF (INRWAV.GT.NDCONF)
     *                               STOP 'INCRESE NDCONF (1) IN PROANG'
                      IF (INLCOL.GT.NDCOLE)
     *                               STOP 'INCRESE NDCOLE (1) IN PROANG'
                      IF (INRCOL.GT.NDCOLE)
     *                               STOP 'INCRESE NDCOLE (1) IN PROANG'
C
                      NMATMI(IPROAC,INDISO,INLWAV,INRWAV,INLCOL,INRCOL)=
     *                                                            NMURMI
                      OMRMIX(NINDMI)=C_ZERO
                      EMRMIX(NINDMI)=C_ZERO
C
                      DO LPROAC=LPRSTA(IPROAC),LPRSTO(IPROAC),2
                         DO KPROAC=KPRSTA(IPROAC),KPRSTO(IPROAC),2
C
                            OMRMIX(NINDMI)=OMRMIX(NINDMI)+
     *                      OPROJE(INDIMK(IPROAC,LPROAC,KPROAC),INDISO)
     *               *CONJG(WAVLEF(IND_IK(IPROAC,LPROAC),INLCOL,INDISO))
     *                     *WAVPRO(IND_IK(IPROAC,KPROAC),INRCOL,INDISO)
C
                            EMRMIX(NINDMI)=EMRMIX(NINDMI)+
     *                      EPROJE(INDIMK(IPROAC,LPROAC,KPROAC),INDISO)
     *               *CONJG(WAVLEF(IND_IK(IPROAC,LPROAC),INLCOL,INDISO))
     *                     *WAVPRO(IND_IK(IPROAC,KPROAC),INRCOL,INDISO)
C
                         END DO
                      END DO
C
                   END DO
                END DO
C
             END DO
C
          END DO
C
C=======================================================================
C         FILLING ARRAYS "QMRMIX", "AMRMIX", "WMRMIX", AND "SMRMIX" WITH
C         REDUCED MATRIX ELEMENTS OF THE ELECTRIC, MAGNETIC, SPIN-ASYMM,
C         AND SURFACE MOMENTS,  RESPECTIVELY,  THAT  CORRESPOND  TO  THE
C         MULTI-REFERENCE STATES.
C=======================================================================
C
          QMRMIX(0)=C_ZERO
          AMRMIX(0)=C_ZERO
          WMRMIX(0)=C_ZERO
          SMRMIX(0)=C_ZERO
C
          INDISO=1
C
          DO IPRRIG=JPROMI,JPROMA,2
C320j WRITE (*,'(''IPRRIG,JPROMI,JPROMA P='',3I3)') IPRRIG,JPROMI,JPROMA
C
             DO LAMBDA=0,MAX(NMURED,NMARED,NASRED,NSIRED)
C320j WRITE (*,'(''LAMBDA,MAX(NMURED,NMARED,NASRED,NSIRED) P='',3I3)')
C320j*             LAMBDA,MAX(NMURED,NMARED,NASRED,NSIRED)
C
                MAXMIU=LAMBDA
C
                IMXLEF=MIN(JPROMA,IPRRIG+2*LAMBDA)
C
                DO IPRLEF=MAX(JPROMI,IPRRIG-2*LAMBDA),IMXLEF,2
C320j WRITE (*,'(''IPRLEF,MAX(JPROMI,IPRRIG-2*LAMBDA),IMXLEF P='',3I3)')
C320j*             IPRLEF,MAX(JPROMI,IPRRIG-2*LAMBDA),IMXLEF
C
                   IF (ILIMAM.NE.1.OR.
     *                 IPRRIG.GE.ISLPRI.AND.IPRRIG.LE.ISUPRI.AND.
     *                 IPRLEF.GE.ISLPRI.AND.IPRLEF.LE.ISUPRI) THEN
C
                       DO INRCOL=1,NUMPRO(IPRRIG,INDISO)
C320j WRITE (*,'(''INRCOL,NUMPRO(IPRRIG,INDISO) P='',3I3)')
C320j*             INRCOL,NUMPRO(IPRRIG,INDISO)
                          DO INLCOL=1,NUMLEF(IPRLEF,INDISO)
C320j WRITE (*,'(''INLCOL,NUMLEF(IPRLEF,INDISO) P='',3I3)')
C320j*             INLCOL,NUMLEF(IPRLEF,INDISO)
C
                             IF (LMURMI.LT.LMRMIX) THEN
C
C=======================================================================
C                         HERE THE SIZES OF ARRAYS  "QMRMIX",  "AMRMIX",
C                         "WMRMIX", AND "SMRMIX" ARE  STILL  SUFFICIENT;
C                         THE SECOND PASS THROUGH  THE  SINGLE-REFERENCE
C                         LOOPS WILL NOT BE REQUIRED.
C=======================================================================
C
                                 LMURMI=LMURMI+1
                                 LINDMI=LMURMI
                                 I_PASS=1
C
                             ELSE
C
C=======================================================================
C                         HERE THE SIZES ABOVE ARE INSUFFICIENT AND  THE
C                         SECOND PASS THROUGH THE SINGLE-REFERENCE LOOPS
C                         WILL BE REQUIRED.
C=======================================================================
C
                                 LMURMI=LMURMI+1
                                 LINDMI=0
                                 I_PASS=2
C
                             END IF
C
                             IF (IPRLEF.GT.NDPROI)
     *                               STOP 'INCRESE NDPROI (2) IN PROANG'
                             IF (LAMBDA.GT.NDLAMB)
     *                               STOP 'INCRESE NDLAMB (2) IN PROANG'
                             IF (IPRRIG.GT.NDPROI)
     *                               STOP 'INCRESE NDPROI (2) IN PROANG'
                             IF (INLWAV.GT.NDCONF)
     *                               STOP 'INCRESE NDCONF (2) IN PROANG'
                             IF (INRWAV.GT.NDCONF)
     *                               STOP 'INCRESE NDCONF (2) IN PROANG'
                             IF (INLCOL.GT.NDCOLE)
     *                               STOP 'INCRESE NDCOLE (2) IN PROANG'
                             IF (INRCOL.GT.NDCOLE)
     *                               STOP 'INCRESE NDCOLE (2) IN PROANG'
C
                             LMATMI(IPRLEF,LAMBDA,IPRRIG,INLWAV,INRWAV,
     *                                            INLCOL,INRCOL)=LMURMI
C
                             QMRMIX(LINDMI)=C_ZERO
                             AMRMIX(LINDMI)=C_ZERO
                             WMRMIX(LINDMI)=C_ZERO
                             SMRMIX(LINDMI)=C_ZERO
C
                             DO KPRLEF=LPRSTA(IPRLEF),
     *                                 LPRSTO(IPRLEF),2
C320j WRITE (*,'(''KPRLEF,LPRSTA(IPRLEF),LPRSTO(IPRLEF) P='',3I3)')
C320j*             KPRLEF,LPRSTA(IPRLEF),LPRSTO(IPRLEF)
                                DO KPRRIG=KPRSTA(IPRRIG),
     *                                    KPRSTO(IPRRIG),2
C320j WRITE (*,'(''KPRRIG,KPRSTA(IPRRIG),KPRSTO(IPRRIG) P='',3I3)')
C320j*             KPRRIG,KPRSTA(IPRRIG),KPRSTO(IPRRIG)
C
                                   NUREDU=INDRED(IND_IK(IPRLEF,KPRLEF),
     *                                    LAMBDA,IND_IK(IPRRIG,KPRRIG))
C
                                   QMRMIX(LINDMI)=QMRMIX(LINDMI)+
     *                             REDQ_P(NUREDU)
     *                            *CONJG(WAVLEF(IND_IK(IPRLEF,KPRLEF),
     *                                                 INLCOL,INDISO))
     *                                  *WAVPRO(IND_IK(IPRRIG,KPRRIG),
     *                                                 INRCOL,INDISO)
C
                                   AMRMIX(LINDMI)=AMRMIX(LINDMI)+
     *                             REDM_P(NUREDU,0)
     *                            *CONJG(WAVLEF(IND_IK(IPRLEF,KPRLEF),
     *                                                 INLCOL,INDISO))
     *                                  *WAVPRO(IND_IK(IPRRIG,KPRRIG),
     *                                                 INRCOL,INDISO)
C
                                   IF (NASORD.GE.0)
     *                             WMRMIX(LINDMI)=WMRMIX(LINDMI)+
     *                             REDA_T(NUREDU,0)
     *                            *CONJG(WAVLEF(IND_IK(IPRLEF,KPRLEF),
     *                                                 INLCOL,INDISO))
     *                                  *WAVPRO(IND_IK(IPRRIG,KPRRIG),
     *                                                 INRCOL,INDISO)
C
                                   SMRMIX(LINDMI)=SMRMIX(LINDMI)+
     *                             REDS_P(NUREDU)
     *                            *CONJG(WAVLEF(IND_IK(IPRLEF,KPRLEF),
     *                                                 INLCOL,INDISO))
     *                                  *WAVPRO(IND_IK(IPRRIG,KPRRIG),
     *                                                 INRCOL,INDISO)
C
C320j WRITE (*,
C320j*'(''I_PASS,IPRRIG,LAMBDA,IPRLEF,INLWAV,INRWAV,INLCOL,INRCOL,'',
C320j*  ''KPRLEF,KPRRIG,NUREDU,LINDMI,LMURMI'',13I4,/,
C320j*    7X,4(''('',2E10.3,'')''))')
C320j*    I_PASS,IPRRIG,LAMBDA,IPRLEF,INLWAV,INRWAV,INLCOL,INRCOL,
C320j*    KPRLEF,KPRRIG,NUREDU,LINDMI,LMURMI,
C320j*    QMRMIX(LINDMI),AMRMIX(LINDMI),WMRMIX(LINDMI),SMRMIX(LINDMI)
C
                                END DO
                             END DO
C
C=======================================================================
C                            HERE WE SYMMETRIZE ARRAYS  OF  THE  REDUCED
C                            MATRIX ELEMENTS FOR SINGLE-REFERENCE STATES
C=======================================================================
C
                             IF (INRWAV.NE.INLWAV) THEN !IF NOT INDENTED
C
                             QMRMIY=QMRMIX(LINDMI)
                             AMRMIY=AMRMIX(LINDMI)
                             WMRMIY=WMRMIX(LINDMI)
                             SMRMIY=SMRMIX(LINDMI)
C
                             IF (LMURMI.LT.LMRMIX) THEN
C
C=======================================================================
C                         HERE THE SIZES OF ARRAYS  "QMRMIX",  "AMRMIX",
C                         "WMRMIX", AND "SMRMIX" ARE  STILL  SUFFICIENT;
C                         THE SECOND PASS THROUGH  THE  SINGLE-REFERENCE
C                         LOOPS WILL NOT BE REQUIRED.
C=======================================================================
C
                                 LMURMI=LMURMI+1
                                 LINDMI=LMURMI
                                 I_PASS=1
C
                             ELSE
C
C=======================================================================
C                         HERE THE SIZES ABOVE ARE INSUFFICIENT AND  THE
C                         SECOND PASS THROUGH THE SINGLE-REFERENCE LOOPS
C                         WILL BE REQUIRED.
C=======================================================================
C
                                 LMURMI=LMURMI+1
                                 LINDMI=0
                                 I_PASS=2
C
                             END IF
C
                             LMATMI(IPRRIG,LAMBDA,IPRLEF,INRWAV,INLWAV,
     *                                            INRCOL,INLCOL)=LMURMI
C
                             QMRMIX(LINDMI)=CONJG(QMRMIY)
                             AMRMIX(LINDMI)=CONJG(AMRMIY)
                             WMRMIX(LINDMI)=CONJG(WMRMIY)
                             SMRMIX(LINDMI)=CONJG(SMRMIY)
C
                             END IF ! IF NOT INDENTED
C
C=======================================================================
C                            END OF SYMMETRIZATION
C=======================================================================
C
                          END DO
                       END DO
C
                   END IF
C
                END DO
C
             END DO
C
          END DO
C
C=======================================================================
C         PERFORMING THE MULTI-REFERENCE DIAGONALIZATION
C=======================================================================
C
          IF (KONMIX.EQ.1.AND.I_PASS.EQ.1) THEN
C
              IF (NATKNO.EQ.1) THEN
C
                  CALL DIAMUR(JPROMI,JPROMA,IHALF_,
     *                        LPROJJ,LPROJT,
     *                        ICUTOV,CUTOWE,CUTOWF,
     *                        IMIPRI,ISLPRI,ISUPRI,
     *                                      NUISOM)
C
              ELSE
                  STOP' DIAMUR NOT READY FOR THE ISOSPIN PROJECTION YET'
              END IF
C
C=======================================================================
C        CALCULATING THE REDUCED MATRIX ELEMENTS FOR THE MULTI-REFERENCE
C        STATES
C=======================================================================
C
              IF (LPROJJ.EQ.1.AND.LPROJT.EQ.0.AND.IRMPRI.EQ.1) THEN
C
                  CALL REDMUR(JPROMI,JPROMA,KPROJE,IAXIAL,IHALF_,
     *                        ISCHIF,NMURED,NMARED,NASRED,NSIRED,NSIMIN,
     *                               IDIMUR,IRMPRI,IELPRI,ISLPRI,ISUPRI,
     *                                      IWRIRM,NFIRED,NMAORD,NASORD,
     *                        MINDIK,NUISOM,QMUCUT,QMACUT,QASCUT,QSICUT)
C
              END IF
C
          END IF
C
      END IF ! IPROAN.EQ.4
C
C=======================================================================
C            SAVE WAVE FUNCTION FOR FURTHER CALCULATION OF
C            THE FERMI AND/OR GAMOW-TELLER MATRIX ELEMENTS
C                        GENERAL  CASE OF
C                < I,T_i,Tz | T(-/+)/GT(-/+) | I,T_f,Tz+/-1>
C=======================================================================
C
      IF (IBETME.EQ.-1) THEN
C
          CALL SAV_WF(NFIWAV,   998,     1,FILWAV,JSOSMI,JSOSMA,ISOSTZ)
C
      ENDIF
C
      IF (IBETME.GE.1) THEN
C
          CALL BETAME(ISIMPY,IROTAT,MREVER,
     *                              IPAHFB,
     *                ISOSTZ,JSOSMI,JSOSMA,
     *                       NFIWAV,FILWAV,
     *                NUBKNO,NUAKNO,NBTKNO,
     *                       IEVEN_,CHALF_,
     *                       ISOADD,NBTKNT)
      ENDIF
C
   11 CONTINUE
C
C=======================================================================
      DEALLOCATE (OVRLAP)
      DEALLOCATE (WARAUX)
      DEALLOCATE (TARIGH)
      DEALLOCATE (TALEFT)
      DEALLOCATE (OVKERN,SKKERN,EKKERN,EPKERN,QPKERN,ATKERN)
      IF (NASORD.GE.0)
     *    DEALLOCATE (WTKERN)
      DEALLOCATE (CDKERN,CXKERN)
      DEALLOCATE (CDKE10,CDKE1P,CDKE1M)
      DEALLOCATE (CDKE20,CDK21P,CDK21M,CDK22P,CDK22M)
      DEALLOCATE (BNN_PP,BNP_PP,BPP_PP,BPN_PP)
      IF (ISIMPY.NE.1)
     *    DEALLOCATE (BNN_PM,BNP_PM,BPP_PM,BPN_PM)
C
      DEALLOCATE (ZMUL_P,ZMAG_T,ZSIF_P,CMUL_P,CMAG_T,CSIF_P)
C
      IF(IPAHFB.EQ.1.AND.IONISH.NE.1)
     *   DEALLOCATE (TBTALF,TBTARG)
      IF(IPAHFB.EQ.1)
     *   DEALLOCATE (WARITP)
C
      DEALLOCATE (OVTERN,SKTERN,EKTERN,EPTERN,CDTERN)
      DEALLOCATE (CDTE10,CDTE1P,CDTE1M,CDTE20,CDT21P,CDT21M,CDT22P)
      DEALLOCATE (CDT22M,CXTERN,CXTE10,CXTE1P,CXTE1M,CXTE20,CXT21P)
      DEALLOCATE (CXT21M,CXT22P,CXT22M)
      DEALLOCATE (PNTE00,PNTE10,PNTE1P,PNTE1M)
      DEALLOCATE (TZTERN,T2TERN,BZTERN,B2TERN)
C
      IF (IPAKER.EQ.1) GO TO 1021
C
      DEALLOCATE (CKER_T,CSKY_T,CKIN_N,CKIN_P,CCOU_D,CC10_D,CC1P_D)
      DEALLOCATE (CC1M_D,CC20_D,CC21PD,CC21MD,CC22PD,CC22MD,CCOU_X)
      DEALLOCATE (CC10_X,CC1P_X,CC1M_X,CC20_X,CC21PX,CC21MX,CC22PX)
      DEALLOCATE (CC22MX,CPNU00,CPNU10,CPNU1P,CPNU1M)
      DEALLOCATE (CTZISO,CT2ISO,CBZROT,CB2ROT)
      DEALLOCATE (CPAI_N,CPAI_P)
C
      DEALLOCATE (ZKER_T,ZSKY_T,ZKIN_N,ZKIN_P,ZCOU_D,ZC10_D,ZC1P_D)
      DEALLOCATE (ZC1M_D,ZC20_D,ZC21PD,ZC21MD,ZC22PD,ZC22MD,ZCOU_X)
      DEALLOCATE (ZC10_X,ZC1P_X,ZC1M_X,ZC20_X,ZC21PX,ZC21MX,ZC22PX)
      DEALLOCATE (ZC22MX,ZPNU00,ZPNU10,ZPNU1P,ZPNU1M)
      DEALLOCATE (ZTZISO,ZT2ISO,ZBZROT,ZB2ROT)
      DEALLOCATE (ZPAI_N,ZPAI_P)
C
      DEALLOCATE (TMUL_P,TMAG_T,TSIF_P)
C
      DEALLOCATE (TKE_TT,TSK_TT,TKI_NT,TKI_PT,TCO_DT,TCO_XT)
      DEALLOCATE (TPA_NT,TPA_PT)
      DEALLOCATE (TPN_00,TPN_10,TPN_1P,TPN_1M,
     *            TTZ_IS,TT2_IS,TBZ_RO,TB2_RO)
      DEALLOCATE (TC1_D0,TC1_DP,TC1_DM,TC2_D0,
     *            TC21DP,TC21DM,TC22DP,TC22DM)
      DEALLOCATE (TC1_X0,TC1_XP,TC1_XM,TC2_X0,
     *            TC21XP,TC21XM,TC22XP,TC22XM)
C
      DEALLOCATE (TKER_T,TSKY_T,TKIN_N,TKIN_P,TCOU_D,TCOU_X)
      DEALLOCATE (TPAI_N,TPAI_P)
      DEALLOCATE (TPNU00,TPNU10,TPNU1P,TPNU1M,
     *            TTZISO,TT2ISO,TBZROT,TB2ROT)
      DEALLOCATE (TC10_D,TC1P_D,TC1M_D,TC20_D,
     *            TC21PD,TC21MD,TC22PD,TC22MD)
      DEALLOCATE (TC10_X,TC1P_X,TC1M_X,TC20_X,
     *            TC21PX,TC21MX,TC22PX,TC22MX)
C=======================================================================
C
 1021 CONTINUE
C
C=======================================================================
C
      CALL CPUTIM('PROANG',0)
C
      RETURN
      END
C
C=======================================================================
C
      SUBROUTINE ADBATI(IPAHFB)
      use ADBATC
C
C=======================================================================
C
      CALL CPUTIM('ADBATI',1)
C
      IF(IPAHFB.EQ.0) CALL atdhf_implementation
      IF(IPAHFB.EQ.1) CALL atdhfb_implementation
C
      CALL CPUTIM('ADBATI',0)
C
      RETURN
      END
C
C=======================================================================
C
      SUBROUTINE CONMIX(IPRDIM,ICMPRI,NFIFER,FILFER,
     *                         IEVEN_,CHALF_,JSOSMI,
     *                         JSOSMA,ISOTZL,IPROAC,EPSMIX)
C=======================================================================
      USE hfodd_sizes
C=======================================================================
      CHARACTER
     *          CHALF_*2
      CHARACTER FILFER*68
C
      COMPLEX CELMTS,OCNMIX,HCNMIX,OVEWAV,HAMWAV,HAMCUT,WAVFUN,FPROJE,
     *        CPROJE,
     *        C_ZERO,FERMAE,FERMTR,CMIX_R,C_KT_L,TCOEFF,OVEMIX,ESKMIX,
     *        ESKCON,GT_RED,GTRMAT
C
      DIMENSION
     *          CELMTS(1:((NDCONF+1)*NDCONF)/2)
C
      DIMENSION
     *          OVEWAV(1:NDCONF,1:NDCONF),OVEEIG(1:NDCONF),
     *          HAMWAV(1:NDCONF,1:NDCONF),HAMEIG(1:NDCONF),
     *          WAVFUN(1:NDCONF,1:NDCONF),FERMTR(1:NDCONF),
     *          FERMAE(1:NDCONF,1:NDCONF),DELTAC(1:NDCONF),
     *          TCOEFF(1:NDPROT,1:NDCONF),FRMOD2(1:NDCONF),
     *          ESKCON(1:NDPROT,1:NDCONF),CMIX_R(1:NDCONF),
     *          GTRMAT(1:NDCONF,1:NDCONF),GT_RED(1:NDCONF),
     *          CONPNC(1:NDCONF,1:NDCONF),GTPROB(1:NDCONF),
     *                                    IT_MAX(1:NDCONF),
     *                                    TT_MAX(1:NDCONF)
C
      COMMON
     *       /FERMLL/ C_KT_L(-NDPROI:NDPROI,NDPROT,NDCONF),
     *                EIGINI(NDCONF),MIXIND(NDCONF,2)
C
      COMMON /KONFIG/ OCNMIX(NDCONF,NDCONF),HCNMIX(NDCONF,NDCONF),
     *                OVEMIX(NDKERN,NDKERN,NDRZUT,NDRZUT,NDPROT)
C
      COMMON /ENEMIX/ ESKMIX(NDKERN,NDKERN,NDRZUT,NDRZUT,NDPROT)
C
      COMMON
     *       /CFIPRI/ NFIPRI
C
C=======================================================================
C
      CALL CPUTIM('CONMIX',1)
C
C=======================================================================
C
      IF (IPRDIM.GT.NDCONF) STOP
C
C     VARIABLE "IPRFRO" IS INTRODUCED TO PREVENT THE COMILER FROM
C     COMPLAINIG FOR NDCONF=1
C
      IPRFRO=2
C
      C_ZERO=CMPLX(0.0D0,0.0D0)
C
      GA_NEU=-1.2701
      GANEU2=GA_NEU**2
C
      IF (ICMPRI.GE.2) THEN
C
      WRITE(*,210)
 210  FORMAT(79(1H*),/,1H*,77X,1H*,/,
     *       1H*,30X,'HAMILTONIAN MATRIX',29X,1H*,/,1H*,77X,1H*,/,
     *       79(1H*))
C
      DO KBRA=1,IPRDIM
         DO KKET=1,IPRDIM
C
             WRITE(*,212) KBRA,KKET,HCNMIX(KBRA,KKET),
     *                    KKET,KBRA,HCNMIX(KKET,KBRA)
 212         FORMAT(1H*,2(2I3,2F16.6),1X,1H*)
C
         END DO
      END DO
C
      END IF
C
      IF (ICMPRI.GE.2) WRITE(*,211)
 211  FORMAT(79(1H*),/,1H*,77X,1H*,/,
     *       1H*,32X,'OVERLAP MATRIX',31X,1H*,/,1H*,77X,1H*,/,
     *       79(1H*))
C
      DO KBRA=1,IPRDIM
         DO KKET=1,IPRDIM
C
             IF (ICMPRI.GE.2)
     *       WRITE(*,209) KBRA,KKET,OCNMIX(KBRA,KKET),
     *                    KKET,KBRA,OCNMIX(KKET,KBRA)
 209         FORMAT(1H*,2(2I3,2F16.10),1X,1H*)
C
             IF (KBRA.GE.KKET) THEN
C
                NCOUNT=KBRA+((2*IPRDIM-KKET)*(KKET-1))/2
                CELMTS(NCOUNT)=OCNMIX(KBRA,KKET)
C
             END IF
C
         END DO
      END DO
C
      CALL DIAMAT(CELMTS,OVEEIG,OVEWAV,IPRDIM,NDCONF,IPRDIM)
C
      WRITE(*,213)
 213  FORMAT(79(1H*),/,1H*,77X,1H*,/,
     *       1H*,20X,'DIAGONALIZATION OF THE OVERLAP MATRIX',20X,1H*,/,
     *       1H*,77X,1H*,/,79(1H*))
C
      ISTA=1
      DO KBRA=1,IPRDIM
         WRITE(*,214) KBRA,OVEEIG(KBRA),ISTA,OVEWAV(ISTA,KBRA)
 214     FORMAT(1H*,7X,I3,2X,F16.10,5X,I3,2X,2F16.10,7X,1H*)
C
         DO KKET=IPRFRO,IPRDIM
            WRITE(*,215) KKET,OVEWAV(KKET,KBRA)
 215        FORMAT(1H*,33X,I3,2X,2F16.10,7X,1H*)
         END DO
C
      END DO
C
      WRITE(*,216)
 216  FORMAT(79(1H*))
C
C=======================================================================
C                    CUTTING-OFF SMALL EIGENVALUES
C=======================================================================
C
       OVEMIN=EPSMIX
       IPRMIN=0
C
             DO ISTATE=IPRDIM,1,-1
C
                IF(OVEEIG(ISTATE).GT.OVEMIN) IPRMIN=ISTATE
C
             END DO
C
             IF (IPRMIN.EQ.0) THEN
C
                 WRITE (*,217)
  217            FORMAT(1H*,21X,'STOP: THE COLLECTIVE SPACE IS EMPTY',
     *                      21X,1H*,/,1H*,77X,1H*,/,79(1H*))
                 STOP
C
             END IF
C
C=======================================================================
C           HERE WE TREAT THE SITUATION WHEN SOME EIGENVECTORS WERE
C           ACCEPTED IN TO THE GCM SPACE
C=======================================================================
C
                 KPRDIM=IPRDIM-IPRMIN+1
C
                 WRITE(*,108) IPRDIM,KPRDIM,EPSMIX
 108             FORMAT(79(1H*),/,1H*,14X,'IPRDIM=',I3,5X,'KPRDIM=',I3,
     *               5X,'EPSMIX=',F12.10,14X,1H*,/,79(1H*))
C
                 DO JBRA=IPRMIN,IPRDIM
                    DO JKET=IPRMIN,IPRDIM
C
                       HAMCUT=C_ZERO
C
                       DO IBRA=1,IPRDIM
                          DO IKET=1,IPRDIM
C
                             HAMCUT=HAMCUT+CONJG(OVEWAV(IBRA,JBRA))
     *                                          *HCNMIX(IBRA,IKET)
     *                                          *OVEWAV(IKET,JKET)
CTMP: CONTROL PRINT-OUT
C           IF (JBRA.EQ.7.AND.JKET.EQ.7) THEN
C           WRITE(*,1888) JBRA,IBRA,JKET,IKET,CONJG(OVEWAV(IBRA,JBRA)),
C     *                   HCNMIX(IBRA,IKET),OVEWAV(IKET,JKET),HAMCUT
C 1888      FORMAT(1H%,4I3,1X,2(F9.5,1X),2(F11.5,1X),
C     *                       2(F9.5,1X),2(F11.5,1X),1H%)
C           END IF
CTMP
                          END DO
                       END DO
C
                       HAMCUT=HAMCUT/SQRT(OVEEIG(JBRA)*OVEEIG(JKET))
C
                       IF (ICMPRI.GE.2)
     *                 WRITE(*,109)
     *                      JBRA,JKET,OVEEIG(JBRA)*OVEEIG(JKET),
     *                      SQRT(OVEEIG(JBRA)*OVEEIG(JKET)),HAMCUT
 109                   FORMAT(1H*,3X,2I3,2X,F12.8,2X,
     *                                      F12.8,5X,2F16.6,3X,1H*)
C
                       KBRA=JBRA-IPRMIN+1
                       KKET=JKET-IPRMIN+1
C
                       IF (KBRA.GE.KKET) THEN
C
                           NCOUNT=KBRA+((2*KPRDIM-KKET)*(KKET-1))/2
C
                           CELMTS(NCOUNT)=HAMCUT
C
                       END IF
C
                    END DO
                 END DO
C
                 CALL DIAMAT(CELMTS,HAMEIG,HAMWAV,KPRDIM,NDCONF,KPRDIM)
C
                 WRITE(*,218)
 218             FORMAT(79(1H*),/,1H*,77X,1H*,/,
     *             1H*,6X,'DIAGONALIZATION OF THE HAMILTONIAN MATRIX',
     *                    ' IN THE COLLECTIVE SPACE',6X,1H*,/,
     *             1H*,77X,1H*,/,79(1H*))
C
                 ISTA=1
                 DO KBRA=1,KPRDIM
                 WRITE(*,214) KBRA,HAMEIG(KBRA),
     *                        ISTA,HAMWAV(ISTA,KBRA)
                    DO KKET=IPRFRO,KPRDIM
                       WRITE(*,215) KKET,HAMWAV(KKET,KBRA)
                    END DO
                 END DO
C
                 WRITE(*,216)
C
C=======================================================================
C  RECALCULATING THE WAVE FUNCTIONS FROM THE COLLECTIVE TO INITIAL BASIS
C                   TOGETHER WITH CALCULATION OF
C        A CONTENT OF NCCI WAVE FUNCTION IN TERMS OF INITIAL KERNELS
C      SEE EQ 3 GAMOW-TELLER RESPONSE PAPER OF KONIECZKA ET AL. 2017
C=======================================================================
C
           DO KBRA=1,KPRDIM
C
             CCPROJ=0.0D0
C
               DO KBBR=1,IPRDIM
C
                  CPROJE=C_ZERO
C
                  DO IKET=1,IPRDIM
C
                     FPROJE=C_ZERO
C
                     DO JBAS=IPRMIN,IPRDIM
                        KBAS=JBAS-IPRMIN+1
C
                        FPROJE=FPROJE+OVEWAV(IKET,JBAS)
     *                                       /SQRT(OVEEIG(JBAS))
     *                                      *HAMWAV(KBAS,KBRA)
C
                     END DO
C
                     WAVFUN(IKET,KBRA)=FPROJE
C
                     CPROJE=CPROJE+WAVFUN(IKET,KBRA)
     *                            *OCNMIX(KBBR,IKET)
C
                  END DO
C
                  CONPNC(KBRA,KBBR)=ABS(CPROJE)**2
                  CCPROJ=CCPROJ+CONPNC(KBRA,KBBR)
C
               END DO
C
               DO KBBR=1,IPRDIM
C
                  CONPNC(KBRA,KBBR)=CONPNC(KBRA,KBBR)/CCPROJ
C
               END DO
C
           END DO
C
C=======================================================================
C            PRINTING THE WAVE FUNCTIONS IN THE INITIAL BASIS
C=======================================================================
C
                 WRITE(*,219)
 219             FORMAT(79(1H*),/,1H*,77X,1H*,/,
     *             1H*,8X,'DIAGONALIZATION OF THE HAMILTONIAN MATRIX',
     *                    ' IN THE INITIAL SPACE',7X,1H*,/,
     *             1H*,21X,'THE BASIS STATES ARE NON-ORTHOGONAL',
     *                 21X,1H*,/,
     *             1H*,77X,1H*,/,79(1H*))
C
                 ISTA=1
                 DO KBRA=1,KPRDIM
                  WRITE(*,314) KBRA,HAMEIG(KBRA),ISTA,WAVFUN(ISTA,KBRA),
     *                        EIGINI(ISTA),CONPNC(KBRA,ISTA)
                    DO KKET=IPRFRO,IPRDIM
                       WRITE(*,315) KKET,WAVFUN(KKET,KBRA),
     *                              EIGINI(KKET),CONPNC(KBRA,KKET)
                    END DO
                 END DO
C
 314             FORMAT(1H*, 1X,I3,2X,F10.3,2X,I3,2X,2F14.8,4X,
     *                                          F10.3,3X,F6.4,3X,1H*)
 315             FORMAT(1H*,18X,I3,2X,2F14.8,4X,F10.3,3X,F6.4,3X,1H*)
                 WRITE(*,216)
C
C=======================================================================
C             CALCULATING ISOSPIN CONTENT AND SKYRME ENERGY
C                    CONTRIBUTIONS IN THE EIGENSTATES
C=======================================================================
C
                 IT=0
                 DO ISOSAC=JSOSMI,JSOSMA,2
                 IT=IT+1
                    DO KSTATE=1,KPRDIM
                    TCOEFF(IT,KSTATE)=C_ZERO
C
                       DO KBASIS=1,IPRDIM
                       KKERNE=MIXIND(KBASIS,1)
                          DO LBASIS=1,IPRDIM
                          LKERNE=MIXIND(LBASIS,1)
C
                             KINDEX=0
                             DO KPROAC=-IPROAC,IPROAC,2
                             KINDEX=KINDEX+1
                             LINDEX=0
                                DO LPROAC=-IPROAC,IPROAC,2
                                LINDEX=LINDEX+1
C
                                 TCOEFF(IT,KSTATE)=TCOEFF(IT,KSTATE)+
     *          CONJG(C_KT_L(KPROAC,IT,KBASIS)*WAVFUN(KBASIS,KSTATE))*
     *                C_KT_L(LPROAC,IT,LBASIS)*WAVFUN(LBASIS,KSTATE)*
     *                        OVEMIX(KKERNE,LKERNE,KINDEX,LINDEX,IT)
C
                                 ESKCON(IT,KSTATE)=ESKCON(IT,KSTATE)+
     *          CONJG(C_KT_L(KPROAC,IT,KBASIS)*WAVFUN(KBASIS,KSTATE))*
     *                C_KT_L(LPROAC,IT,LBASIS)*WAVFUN(LBASIS,KSTATE)*
     *                        ESKMIX(KKERNE,LKERNE,KINDEX,LINDEX,IT)
C
       IF (ICMPRI.GE.3)
     * WRITE(*,888) IT,KSTATE,KKERNE,LKERNE,KBASIS,LBASIS,
     *              KPROAC,LPROAC,
     *              OVEMIX(KKERNE,LKERNE,KINDEX,LINDEX,IT),
     *              TCOEFF(IT,KSTATE)
 888  FORMAT(1H$,4(2I3,1X),4F12.6,1X,1H$)
C
                                END DO
                             END DO
C
                          END DO
                       END DO
C
                    END DO
                 END DO
C
C=======================================================================
C             PRINTING ISOSPIN CONTENT OF THE EIGENSTATES
C=======================================================================
C
                 DO KSTATE=1,KPRDIM
                 IT=1
                 IT_MAX(KSTATE)=JSOSMI
                 TT_MAX(KSTATE)=REAL(TCOEFF(IT,KSTATE))
                    DO ISOSAC=JSOSMI+2,JSOSMA,2
                       IT=IT+1
                       IF (REAL(TCOEFF(IT,KSTATE)).GT.
     *                                     TT_MAX(KSTATE)) THEN
                         IT_MAX(KSTATE)=ISOSAC
                         TT_MAX(KSTATE)=REAL(TCOEFF(IT,KSTATE))
                       END IF
                    END DO
                 END DO
C
                 WRITE(*,413)
 413             FORMAT(1H*,77X,1H*,/,
     *                  1H*,18X,'ISOSPIN DECOMPOSITION OF',
     *                          ' THE EIGENSTATES',19X,1H*,/,
     *                  1H*,77X,1H*,/,79(1H*))
C
                 DO KSTATE=1,KPRDIM
                 IT=1
                 WRITE(*,414) KSTATE,HAMEIG(   KSTATE),
     *                        IT_MAX(KSTATE)/IEVEN_,CHALF_,
     *                        (1-TT_MAX(KSTATE))*100.,
     *                        JSOSMI/IEVEN_,CHALF_,TCOEFF(IT,KSTATE),
     *                                             ESKCON(IT,KSTATE)
                    DO ISOSAC=JSOSMI+2,JSOSMA,2
                       IT=IT+1
                       WRITE(*,415) ISOSAC/IEVEN_,CHALF_,
     *                                             TCOEFF(IT,KSTATE),
     *                                             ESKCON(IT,KSTATE)
                    END DO
                 END DO
C
 414             FORMAT(1H*,1X,I3,1X,F10.3,2X,I2,A2,1X,F6.3,'[%]',
     *                       1X,I2,A2,1X,2F9.6,1X,2F10.3,1X,1H*)
 415             FORMAT(1H*,32X,I2,A2,1X,2F9.6,1X,2F10.3,1X,1H*)
                 WRITE(*,216)
C
C=======================================================================
C         OPENING THE FILFER FILE CONTAINING MATRIX ELEMENTS OF
C         THE FERMI OPEARATOR:
C              <KKET|T_+/-|BRA> WHERE <KKET| DENOTES COMPONENTS
C              OF CONFIGURATION-MIXED SOLUTION IN INITIAL "BASIS"
C=======================================================================
C
          OPEN(NFIFER,FILE=FILFER,STATUS='OLD',ERR=7,FORM='FORMATTED')
C
          WRITE(NFIPRI,'(/,23(1H/),2X,''FERMI AND GT MATRIX ELEMENTS:'',
     *                                                  2X,23(1H/),/,
     *                      3(1H/),2X,68X,              3X, 3(1H/),/,
     *                      3(1H/),2X,A68,              3X, 3(1H/),/,
     *                      3(1H/),2X,68X,              3X, 3(1H/))')
     *                 FILFER
C
          GO TO 1007
C
    7     WRITE(NFIPRI,'(/,1X,26(1H/),2X,''FILE NOT FOUND ON DISC'',
     *                                                     2X,26(1H/),/,
     *                     1X, 3(1H/),2X,68X,              2X, 3(1H/),/,
     *                     1X, 3(1H/),2X,A68,              2X, 3(1H/),/,
     *                     1X, 3(1H/),2X,68X,              2X, 3(1H/),/,
     *                     1X,26(1H/),2X,''FILE NOT FOUND ON DISC'',
     *                                                     2X,26(1H/))')
     *                 FILFER
C
          STOP ' FILE FILFER NOT FOUND ON DISC'
C
 1007     CONTINUE
C
          READ (NFIFER,*) ICLEFT,ICRGHT,IT_KET,ITZKET,II_KET,EN_KET
C
          IF (ICLEFT.NE.IPRDIM) THEN
             WRITE (*,233) ICLEFT,IPRDIM
  233        FORMAT(1H*,16X,'NUMBER OF CONFIGURATIONS DIASGREE:',
     *              I3,'.NE.',I3,17X,1H*)
             STOP
          END IF
C
          IF (IABS(ISOTZL-ITZKET).NE.2) THEN
             WRITE (*,232) ISOTZL,ITZKET
  232        FORMAT(1H*,16X,'WRONG PARTICLE NUMBERS (OR Tz)   :',
     *              I3,' AND',I3,17X,1H*)
             STOP
          END IF
C
          DO IMATRI=1,ICLEFT
             DO JMATRI=1,ICRGHT
C
                READ (NFIFER,*) ICON_L,ICON_R,CMX_RE,CMX_IM,
     *                          FERREA,FERIMA,GTRREA,GTRIMA
C
                FERMAE(ICON_L,ICON_R)=CMPLX(FERREA,FERIMA)
                GTRMAT(ICON_L,ICON_R)=CMPLX(GTRREA,GTRIMA)
                CMIX_R(       ICON_R)=CMPLX(CMX_RE,CMX_IM)
C
                WRITE(*,220) ICON_L,ICON_R,CMIX_R(       ICON_R),
     *               FERMAE(ICON_L,ICON_R),GTRMAT(ICON_L,ICON_R)
 220            FORMAT(1H/,2X,2I4,1X,2F10.6,2X,2F10.6,2X,2F10.6,
     *              2X,1H/)
C
             END DO
          END DO
C
          WRITE(*,234)
 234      FORMAT(3(1H/),73X,3(1H/),/,
     *           3(1H/),2X,69(1H/),2X,3(1H/),/,79(1H*),/,
     *           1H*,77X,1H*,/,
     *           1H*,31X,'ISB CORRECTIONS',31X,1H*,/,
     *           1H*,77X,1H*)
C
      FE_SUM=0
      GT_SUM=0
C
      DO KBRA=1,KPRDIM
C
         FERMTR(KBRA)=C_ZERO
         GT_RED(KBRA)=C_ZERO
C
            DO ICON_L=1,ICLEFT
               DO ICON_R=1,ICRGHT
                  FERMTR(KBRA)=FERMTR(KBRA)+
     *                   CONJG(WAVFUN(ICON_L,KBRA))*
     *                   FERMAE(ICON_L,ICON_R)*CMIX_R(ICON_R)
                  GT_RED(KBRA)=GT_RED(KBRA)+
     *                   CONJG(WAVFUN(ICON_L,KBRA))*
     *                   GTRMAT(ICON_L,ICON_R)*CMIX_R(ICON_R)
CWS               IF (KBRA.EQ.1) THEN
CWS                 WRITE(*,99) ICON_L,ICON_R,FERMTR(KBRA),GT_RED(KBRA)
CWS 99              FORMAT(1H$,2X,2I3,2F16.10,2X,2F16.10,1H$)
CWS               END IF
               END DO
            END DO
C
         FRMOD2(KBRA)=ABS(FERMTR(KBRA))**2
         GTPROB(KBRA)=GANEU2*ABS(GT_RED(KBRA))**2/(II_KET+1)
C
         WRITE(*,222) KBRA,IPROAC,IT_MAX(KBRA),HAMEIG(KBRA),
     *                                II_KET,IT_KET,EN_KET
 222     FORMAT(1H*,1X,I3,' BRA:',2X,I2,2X,I2,2X,F10.3,
     *                    ' KET:',2X,I2,2X,I2,2X,F10.3,23X,1H*)
C
         IF (IT_MAX(KBRA).EQ.IT_KET) THEN
            IF(ITZKET.EQ.ISOTZL+2)
     *         FACT_T=IT_KET*(IT_KET+2)/4.D0-ITZKET*(ITZKET-2)/4.D0
            IF(ITZKET.EQ.ISOTZL-2)
     *         FACT_T=IT_KET*(IT_KET+2)/4.D0-ITZKET*(ITZKET+2)/4.D0
C
            DELTAC(KBRA)=1-FRMOD2(KBRA)/FACT_T
            WRITE(*,223) FERMTR(KBRA),FRMOD2(KBRA),DELTAC(KBRA)*100
 223        FORMAT(1H*,9X,'FERMI:',2X,2F10.6,2X,F10.6,2X,F10.6,'[%]',
     *                                                       13X,1H*)
         ELSE
            WRITE(*,224) FERMTR(KBRA),FRMOD2(KBRA)
 224        FORMAT(1H*,9X,'FERMI:',2X,2F10.6,2X,F10.6,15X,
     *                                                       13X,1H*)
         END IF
C
         WRITE(*,225) GT_RED(KBRA),ABS(GT_RED(KBRA)),GTPROB(KBRA)
 225     FORMAT(1H*,9X,'  G-T:',2X,2F10.6,2X,F10.6,2X,F10.6,
     *                                                    16X,1H*)
C
         FE_SUM=FE_SUM+FRMOD2(KBRA)
         GT_SUM=GT_SUM+GTPROB(KBRA)/GANEU2
C
      END DO
C
      WRITE(*,216)
      WRITE(*,226) FE_SUM,IABS(ITZKET),GT_SUM,3*IABS(ITZKET)
 226  FORMAT(1H*,77X,1H*,/,
     *       1H*,15X,'FERMI SUM RULE',19X,'G - T SUM RULE',15X,1H*,/,
     *       1H*,15X,F10.6,1X,I3,19X,F10.6,1X,I3,15X,1H*,/,1H*,77X,1H*)
      WRITE(*,216)
C
C=======================================================================
C
      CALL CPUTIM('CONMIX',0)
C
      RETURN
      END
C
C=======================================================================
C
      SUBROUTINE BETAME(ISIMPY,IROTAT,MREVER,
     *                                IPAHFB,
     *                  ISOTZR,ISOMIR,ISOMAR,
     *                         NFIWAV,FILWAV,
     *                  NUBKNO,NUAKNO,NBTKNO,
     *                         IEVEN_,CHALF_,
     *                         ISOADD,NBTKNT)
C
C=======================================================================
      USE SAVLEF
      USE SAVRIG
      USE WAVR_L
      USE MAT_PP
      USE MAT_PM
C=======================================================================
      USE hfodd_sizes
C=======================================================================
      CHARACTER
     *          CHALF_*2,FEROPE*2,FERMOP*4,GTOPER*4,GT_OPE*2
      CHARACTER
     *          FILWAV*68
C
      COMPLEX
     *          WARAUX,TARIGH,TALEFT,OVRLAP,OVKERN,
     *          PNKE10,PNKE1P,PNKE1M,
     *          GTKE00,GTKE0P,GTKE0M,
     *          GTKEP0,GTKEPP,GTKEPM,
     *          GTKEM0,GTKEMP,GTKEMM,
     *          CPNU10,CPNU1P,CPNU1M,
     *          CSPU00,CSPU0P,CSPU0M,
     *          CSPUP0,CSPUPP,CSPUPM,
     *          CSPUM0,CSPUMP,CSPUMM,
     *          ZPNU10,ZPNU1P,ZPNU1M,
     *          ZSPU00,ZSPU0P,ZSPU0M,
     *          ZSPUP0,ZSPUPP,ZSPUPM,
     *          ZSPUM0,ZSPUMP,ZSPUMM
      COMPLEX
     *          FACINT,FACI10,FACI1M,FACI1P,
     *          TRNN,TRPP,TRNP,TRPN
      COMPLEX
     *          FER_ME,GT_RED,
     *          F_KT_L,F_KT_R,
     *          GT_KAR
      COMPLEX
     *          TPNU10,TPNU1P,TPNU1M,
     *          TSPU00,TSPU0P,TSPU0M,
     *          TSPUP0,TSPUPP,TSPUPM,
     *          TSPUM0,TSPUMP,TSPUMM,
     *          TPN_10,TPN_1P,TPN_1M,
     *          TSP_00,TSP_0P,TSP_0M,
     *          TSP_P0,TSP_PP,TSP_PM,
     *          TSP_M0,TSP_MP,TSP_MM
      COMPLEX
     *          AUXDIA,C_ZERO,C_UNIT,UNIT_I
      COMPLEX
     *          SPININ,
     *          SPI_NN,SPI_PP,SPI_NP,SPI_PN,
     *          TAUXSP,TAUYSP,TAUZSP
      COMPLEX
     *          DETWRK
C
      DIMENSION
     *                SPININ(1:NDKART),SPI_NN(1:NDKART),
     *                SPI_PP(1:NDKART),SPI_PN(1:NDKART),
     *                SPI_NP(1:NDKART),TAUXSP(1:NDKART),
     *                TAUYSP(1:NDKART),TAUZSP(1:NDKART)
C
      DIMENSION
     *       LDSTAR(0:NDISOS),LDSTAL(0:NDISOS),GT_KAR(3)
C
      COMMON
     *       /RANGLE/ ALPROT,BETROT,GAMROT
C
      COMMON
     *       /FERMIL/ F_KT_L(-NDPROI:NDPROI,0:NDPROT,-NDPROT:NDPROT),
     *                EIGE_L,IDIM_L,IIFERL,ITFERL,ISFERL
      COMMON
     *       /FERMIR/ F_KT_R(-NDPROI:NDPROI,0:NDPROT,-NDPROT:NDPROT),
     *                EIGE_R,IDIM_R,IIFERR,ITFERR,ISFERR
C
      COMMON
     *       /DIMSTA/ LDTOTS(0:NDISOS),LDSTAT(0:NDISOS),
     *                LDUPPE(0:NDISOS),LDTIMU(0:NDISOS)
C
      COMMON
     *       /DIMENS/ LDBASE
      COMMON
     *       /CFIPRI/ NFIPRI
C
C=======================================================================
      ALLOCATABLE OVRLAP(:,:)
      ALLOCATABLE WARAUX(:,:)
      ALLOCATABLE OVKERN(:,:,:,:)
      ALLOCATABLE TARIGH(:,:,:)
      ALLOCATABLE TALEFT(:,:,:)
      ALLOCATABLE PNKE10(:,:,:,:)
      ALLOCATABLE PNKE1P(:,:,:,:)
      ALLOCATABLE PNKE1M(:,:,:,:)
      ALLOCATABLE GTKE00(:,:,:,:)
      ALLOCATABLE GTKE0P(:,:,:,:)
      ALLOCATABLE GTKE0M(:,:,:,:)
      ALLOCATABLE GTKEP0(:,:,:,:)
      ALLOCATABLE GTKEPP(:,:,:,:)
      ALLOCATABLE GTKEPM(:,:,:,:)
      ALLOCATABLE GTKEM0(:,:,:,:)
      ALLOCATABLE GTKEMP(:,:,:,:)
      ALLOCATABLE GTKEMM(:,:,:,:)
C=======================================================================
C
      DIMENSION
     *        CPNU10(-NDPROI:NDPROI,-NDPROI:NDPROI,NDPROT),
     *        CPNU1P(-NDPROI:NDPROI,-NDPROI:NDPROI,NDPROT),
     *        CPNU1M(-NDPROI:NDPROI,-NDPROI:NDPROI,NDPROT),
     *        TPNU10(NDPROT),TPNU1P(NDPROT),TPNU1M(NDPROT),
     *        TPN_10(-NDPROI:NDPROI,-NDPROI:NDPROI,NDPROT),
     *        TPN_1P(-NDPROI:NDPROI,-NDPROI:NDPROI,NDPROT),
     *        TPN_1M(-NDPROI:NDPROI,-NDPROI:NDPROI,NDPROT)
      DIMENSION
     *        CSPU00(-NDPROI:NDPROI,-NDPROI:NDPROI,NDPROT),
     *        CSPU0P(-NDPROI:NDPROI,-NDPROI:NDPROI,NDPROT),
     *        CSPU0M(-NDPROI:NDPROI,-NDPROI:NDPROI,NDPROT),
     *        CSPUP0(-NDPROI:NDPROI,-NDPROI:NDPROI,NDPROT),
     *        CSPUPP(-NDPROI:NDPROI,-NDPROI:NDPROI,NDPROT),
     *        CSPUPM(-NDPROI:NDPROI,-NDPROI:NDPROI,NDPROT),
     *        CSPUM0(-NDPROI:NDPROI,-NDPROI:NDPROI,NDPROT),
     *        CSPUMP(-NDPROI:NDPROI,-NDPROI:NDPROI,NDPROT),
     *        CSPUMM(-NDPROI:NDPROI,-NDPROI:NDPROI,NDPROT),
     *        TSPU00(NDPROT),TSPU0P(NDPROT),TSPU0M(NDPROT),
     *        TSPUP0(NDPROT),TSPUPP(NDPROT),TSPUPM(NDPROT),
     *        TSPUM0(NDPROT),TSPUMP(NDPROT),TSPUMM(NDPROT),
     *        TSP_00(-NDPROI:NDPROI,-NDPROI:NDPROI,NDPROT),
     *        TSP_0P(-NDPROI:NDPROI,-NDPROI:NDPROI,NDPROT),
     *        TSP_0M(-NDPROI:NDPROI,-NDPROI:NDPROI,NDPROT),
     *        TSP_P0(-NDPROI:NDPROI,-NDPROI:NDPROI,NDPROT),
     *        TSP_PP(-NDPROI:NDPROI,-NDPROI:NDPROI,NDPROT),
     *        TSP_PM(-NDPROI:NDPROI,-NDPROI:NDPROI,NDPROT),
     *        TSP_M0(-NDPROI:NDPROI,-NDPROI:NDPROI,NDPROT),
     *        TSP_MP(-NDPROI:NDPROI,-NDPROI:NDPROI,NDPROT),
     *        TSP_MM(-NDPROI:NDPROI,-NDPROI:NDPROI,NDPROT)
      DIMENSION
     *        ZPNU10(NDAKNO,-NDPROI:NDPROI,NDPROT),
     *        ZPNU1P(NDAKNO,-NDPROI:NDPROI,NDPROT),
     *        ZPNU1M(NDAKNO,-NDPROI:NDPROI,NDPROT),
     *        ZSPU00(NDAKNO,-NDPROI:NDPROI,NDPROT),
     *        ZSPU0P(NDAKNO,-NDPROI:NDPROI,NDPROT),
     *        ZSPU0M(NDAKNO,-NDPROI:NDPROI,NDPROT),
     *        ZSPUP0(NDAKNO,-NDPROI:NDPROI,NDPROT),
     *        ZSPUPP(NDAKNO,-NDPROI:NDPROI,NDPROT),
     *        ZSPUPM(NDAKNO,-NDPROI:NDPROI,NDPROT),
     *        ZSPUM0(NDAKNO,-NDPROI:NDPROI,NDPROT),
     *        ZSPUMP(NDAKNO,-NDPROI:NDPROI,NDPROT),
     *        ZSPUMM(NDAKNO,-NDPROI:NDPROI,NDPROT)
C
      DIMENSION
     *        AUXDIA(1:4*NDSTAT),IAUXDI(1:4*NDSTAT)
      DIMENSION
     *        DETWRK(2)
      DIMENSION
     *        YBT_PN(1:NDBTKN),YBT_WG(1:NDBTKN)
      COMMON /KNOTS/
     *        XA_PNT(1:NDAKNO),XA_WGT(1:NDAKNO),
     *        XB_PNT(1:NDBKNO),XB_WGT(1:NDBKNO),
     *        XAT_PN(1:NDATKN),XAT_WG(1:NDATKN),
     *        XBT_PN(1:NDBTKN),XBT_WG(1:NDBTKN)
C
C=======================================================================
C
      CALL CPUTIM('BETAME',1)
C
C=======================================================================
C                     A L L O C A T I O N S
C=======================================================================
C
      IF (.NOT.ALLOCATED(WARIGH)) THEN
          ALLOCATE (WARIGH(1:NDBASE,1:4*NDSTAT,0:NDSPIN),STAT=IALLOC)
          IF (IALLOC.NE.0) CALL NOALLO('WARIGH','BETAME')
      END IF
C=======================================================================
      IF (.NOT.ALLOCATED(WALEFT)) THEN
          ALLOCATE (WALEFT(1:NDBASE,1:4*NDSTAT,0:NDSPIN),STAT=IALLOC)
          IF (IALLOC.NE.0) CALL NOALLO('WALEFT','BETAME')
      END IF
C=======================================================================
      ALLOCATE (WARAUX(1:4*NDSTAT,0:NDSPIN),STAT=IALLOC)
      IF (IALLOC.NE.0) CALL NOALLO('WARAUX','BETAME')
C=======================================================================
      ALLOCATE (TARIGH(1:2*NDBASE,1:8*NDSTAT,0:NDSPIN),STAT=IALLOC)
      IF (IALLOC.NE.0) CALL NOALLO('TARIGH','BETAME')
C=======================================================================
      ALLOCATE (TALEFT(1:2*NDBASE,1:8*NDSTAT,0:NDSPIN),STAT=IALLOC)
      IF (IALLOC.NE.0) CALL NOALLO('TALEFT','BETAME')
C=======================================================================
C
C=======================================================================
      ALLOCATE (OVRLAP(1:4*NDSTAT,1:4*NDSTAT),STAT=IALLOC)
      IF (IALLOC.NE.0) CALL NOALLO('OVRLAP','BETAME')
C=======================================================================
      ALLOCATE (OVKERN(1:NDASAV,1:NDBKNO,1:NDASAV,0:NDBTKN),STAT=IALLOC)
      IF (IALLOC.NE.0) CALL NOALLO('OVKERN','BETAME')
C=======================================================================
      ALLOCATE (PNKE10(1:NDASAV,1:NDBKNO,1:NDASAV,1:NDBTKN),STAT=IALLOC)
      IF (IALLOC.NE.0) CALL NOALLO('PNKE10','BETAME')
C=======================================================================
      ALLOCATE (PNKE1P(1:NDASAV,1:NDBKNO,1:NDASAV,1:NDBTKN),STAT=IALLOC)
      IF (IALLOC.NE.0) CALL NOALLO('PNKE1P','BETAME')
C=======================================================================
      ALLOCATE (PNKE1M(1:NDASAV,1:NDBKNO,1:NDASAV,1:NDBTKN),STAT=IALLOC)
      IF (IALLOC.NE.0) CALL NOALLO('PNKE1M','BETAME')
C=======================================================================
C
C=======================================================================
      ALLOCATE (GTKE00(1:NDASAV,1:NDBKNO,1:NDASAV,0:NDBTKN),STAT=IALLOC)
      IF (IALLOC.NE.0) CALL NOALLO('GTKE00','BETAME')
C=======================================================================
      ALLOCATE (GTKE0P(1:NDASAV,1:NDBKNO,1:NDASAV,0:NDBTKN),STAT=IALLOC)
      IF (IALLOC.NE.0) CALL NOALLO('GTKE0P','BETAME')
C=======================================================================
      ALLOCATE (GTKE0M(1:NDASAV,1:NDBKNO,1:NDASAV,0:NDBTKN),STAT=IALLOC)
      IF (IALLOC.NE.0) CALL NOALLO('GTKE0M','BETAME')
C=======================================================================
      ALLOCATE (GTKEP0(1:NDASAV,1:NDBKNO,1:NDASAV,0:NDBTKN),STAT=IALLOC)
      IF (IALLOC.NE.0) CALL NOALLO('GTKEP0','BETAME')
C=======================================================================
      ALLOCATE (GTKEPP(1:NDASAV,1:NDBKNO,1:NDASAV,0:NDBTKN),STAT=IALLOC)
      IF (IALLOC.NE.0) CALL NOALLO('GTKEPP','BETAME')
C=======================================================================
      ALLOCATE (GTKEPM(1:NDASAV,1:NDBKNO,1:NDASAV,0:NDBTKN),STAT=IALLOC)
      IF (IALLOC.NE.0) CALL NOALLO('GTKEPM','BETAME')
C=======================================================================
      ALLOCATE (GTKEM0(1:NDASAV,1:NDBKNO,1:NDASAV,0:NDBTKN),STAT=IALLOC)
      IF (IALLOC.NE.0) CALL NOALLO('GTKEM0','BETAME')
C=======================================================================
      ALLOCATE (GTKEMP(1:NDASAV,1:NDBKNO,1:NDASAV,0:NDBTKN),STAT=IALLOC)
      IF (IALLOC.NE.0) CALL NOALLO('GTKEMP','BETAME')
C=======================================================================
      ALLOCATE (GTKEMM(1:NDASAV,1:NDBKNO,1:NDASAV,0:NDBTKN),STAT=IALLOC)
      IF (IALLOC.NE.0) CALL NOALLO('GTKEMM','BETAME')
C=======================================================================
C
      PI=4.0D0*ATAN(1.0D0)
C
      C_ZERO=CMPLX(0.0D0,0.0D0)
      C_UNIT=CMPLX(1.0D0,0.0D0)
      UNIT_I=CMPLX(0.0D0,1.0D0)
C
      DO ISOS=0,NDISOS
         LDSTAR(ISOS)=LDSTAT(ISOS)
      ENDDO
C
C=======================================================================
C      READING WAVE FUNCTION OF THE DAUGHTER (LEFT STATE) NUCLEUS:
C=======================================================================
C
      CALL REA_WL(NFIWAV,   998,     1,FILWAV,
     *            ISOMIL,ISOMAL,ISOTZL)
C
      FERMOP='T+/-'
      GTOPER='G+/-'
C
      IFE_SR=1
      IGT_SR=1
C
      IF (IABS(ISOTZL-ISOTZR).NE.2) THEN
C
      WRITE(*, 14) ISFERL,IIFERL/IEVEN_,CHALF_,
     *                    ITFERL/IEVEN_,CHALF_,
     *                    ISOTZL/IEVEN_,CHALF_,FERMOP,
     *             ISFERR,IIFERR/IEVEN_,CHALF_,
     *                    ITFERR/IEVEN_,CHALF_,
     *                    ISOTZR/IEVEN_,CHALF_
C
      WRITE(*, 14) ISFERL,IIFERL/IEVEN_,CHALF_,
     *                    ITFERL/IEVEN_,CHALF_,
     *                    ISOTZL/IEVEN_,CHALF_,GTOPER,
     *             ISFERR,IIFERR/IEVEN_,CHALF_,
     *                    ITFERR/IEVEN_,CHALF_,
     *                    ISOTZR/IEVEN_,CHALF_
C
  14  FORMAT(1H*,77X,1H*,/,
     *       1H*,1X,'< i=',I2,'; I=',I2,A2,', T=',I2,A2,', Tz=',I2,A2,
     *                          ' | ',A4,' | j=',
     *                     I2,'; I=',I2,A2,', T=',I2,A2,', Tz=',I2,A2,
     *                                                 '> = 0',1X,1H*)
      WRITE(*,116)
      WRITE(*,115)
 116  FORMAT(1H*,77X,1H*)
C
      IFE_SR=0
      IGT_SR=0
C
      GO TO 1111
C
      ENDIF
C
      IF (IABS(IIFERL-IIFERR).GT.2) THEN
C
      WRITE(*, 14) ISFERL,IIFERL/IEVEN_,CHALF_,
     *                    ITFERL/IEVEN_,CHALF_,
     *                    ISOTZL/IEVEN_,CHALF_,FERMOP,
     *             ISFERR,IIFERR/IEVEN_,CHALF_,
     *                    ITFERR/IEVEN_,CHALF_,
     *                    ISOTZR/IEVEN_,CHALF_
C
      WRITE(*, 14) ISFERL,IIFERL/IEVEN_,CHALF_,
     *                    ITFERL/IEVEN_,CHALF_,
     *                    ISOTZL/IEVEN_,CHALF_,GTOPER,
     *             ISFERR,IIFERR/IEVEN_,CHALF_,
     *                    ITFERR/IEVEN_,CHALF_,
     *                    ISOTZR/IEVEN_,CHALF_
C
      WRITE(*,116)
      WRITE(*,115)
C
      IFE_SR=0
      IGT_SR=0
C
      GO TO 1111
C
      ENDIF
C
      IF (IABS(IIFERL-IIFERR).NE.0) THEN
C
      WRITE(*, 14) ISFERL,IIFERL/IEVEN_,CHALF_,
     *                    ITFERL/IEVEN_,CHALF_,
     *                    ISOTZL/IEVEN_,CHALF_,FERMOP,
     *             ISFERR,IIFERR/IEVEN_,CHALF_,
     *                    ITFERR/IEVEN_,CHALF_,
     *                    ISOTZR/IEVEN_,CHALF_
C
      WRITE(*,116)
      WRITE(*,115)
C
      IFE_SR=0
C
      ENDIF
C
      IF (IIFERL.EQ.0.AND.IIFERR.EQ.0) THEN
C
      WRITE(*, 14) ISFERL,IIFERL/IEVEN_,CHALF_,
     *                    ITFERL/IEVEN_,CHALF_,
     *                    ISOTZL/IEVEN_,CHALF_,GTOPER,
     *             ISFERR,IIFERR/IEVEN_,CHALF_,
     *                    ITFERR/IEVEN_,CHALF_,
     *                    ISOTZR/IEVEN_,CHALF_
C
      WRITE(*,116)
      WRITE(*,115)
C
      IGT_SR=0
C
      ENDIF
C
                              FEROPE='T+'
      IF (ISOTZR.EQ.ISOTZL+2) FEROPE='T-'
C
                              GT_OPE='G+'
      IF (ISOTZR.EQ.ISOTZL+2) GT_OPE='G-'
C
                              MU_ISO=+2
      IF (ISOTZR.EQ.ISOTZL+2) MU_ISO=-2
C
      DO ISOS=0,NDISOS
         LDSTAL(ISOS)=LDSTAT(ISOS)
      ENDDO
C
C=======================================================================
C         CONTROL PRINTOUT AFTER READING DATA FOR THE LEFT STATE
C=======================================================================
C
      WRITE(*,116)
C
      IF (IFE_SR.EQ.1)
     *WRITE(*, 15) ISFERL,IIFERL/IEVEN_,CHALF_,
     *                    ITFERL/IEVEN_,CHALF_,
     *                    ISOTZL/IEVEN_,CHALF_,FEROPE,
     *             ISFERR,IIFERR/IEVEN_,CHALF_,
     *                    ITFERR/IEVEN_,CHALF_,
     *                    ISOTZR/IEVEN_,CHALF_
C
      IF (IGT_SR.EQ.1)
     *WRITE(*, 15) ISFERL,IIFERL/IEVEN_,CHALF_,
     *                    ITFERL/IEVEN_,CHALF_,
     *                    ISOTZL/IEVEN_,CHALF_,GT_OPE,
     *             ISFERR,IIFERR/IEVEN_,CHALF_,
     *                    ITFERR/IEVEN_,CHALF_,
     *                    ISOTZR/IEVEN_,CHALF_
C
  15  FORMAT(1H*,4X,'< i=',I2,'; I=',I2,A2,', T=',I2,A2,', Tz=',I2,A2,
     *                          ' | ',A2,' | i=',
     *                     I2,'; I=',I2,A2,', T=',I2,A2,', Tz=',I2,A2,
     *                                                     '>',4X,1H*)
      WRITE(*,116)
C
      WRITE(*,117)
 117  FORMAT(1H*,32X,'LEFT STATE',20X,'RIGHT STATE',4X,1H*)
      WRITE(*,116)
C
      WRITE(*,118) ISOMIL/IEVEN_,CHALF_,ISOMAL/IEVEN_,CHALF_,
     *             ISOTZL/IEVEN_,CHALF_,
     *             ISOMIR/IEVEN_,CHALF_,ISOMAR/IEVEN_,CHALF_,
     *             ISOTZR/IEVEN_,CHALF_
 118  FORMAT(1H*,2X,'Tmin/Tmax/Tz ',
     *           9X,3(I4,A2),13X,3(I4,A2),4X,1H*)
      WRITE(*,116)
C
      WRITE(*,119) EIGE_L,EIGE_R
 119  FORMAT(1H*,2X,'       ENERGY',
     *           15X,F12.6,19X,F12.6,4X,1H*)
      WRITE(*,116)
C
      WRITE(*,1667) NUAKNO,NUBKNO,NBTKNO
 1667 FORMAT(1H*,19X,'NUAKNO=',I3,5X,'NUBKNO=',I3,
     *                            5X,'NBTKNO=',I3,18X,1H*)
      WRITE(*,116)
CWS
CWS      DO ISOS=0,NDISOS
CWS      WRITE(*,33) ISOS,LDSTAT(ISOS),LDUPPE(ISOS)
CWS 33   FORMAT(1H*,14X,'ISOS=',I1,5X,'LDSTAT(ISOS)=',I3,5X,
CWS     *                             'LDUPPE(ISOS)=',I3,15X,1H*)
CWS      ENDDO
CWS      WRITE(*,116)
CWS
C
C=======================================================================
C                 END OF CONTROL PRINTOUT BLOCK
C=======================================================================
C
C=======================================================================
C     SET PARAMETERS FOR ISOSPIN DECOMPOSITION OF MEAN FIELD STATES
C             IN CASE OF ANGULAR MOMENTUM PROJECTION
C   THE PARAMETERS WILL BE RESTORED TO THEIR ORIGINAL VALUES AT THE END
C=======================================================================
C
      LPROJT=1
C
      IF (NBTKNO.EQ.1) THEN
C
         LPROJT=0
C
         ISOMAL=ISOMIL+ISOADD
         ISOMAR=ISOMIR+ISOADD
C
         WRITE(*,101) NBTKNT,ISOMAL,ISOMAR
 101     FORMAT (
     *      1H*,13X,'PARAMETERS USED FOR ISOSPIN DECOMPOSITION',
     *              ' IN BETAME',13X,1H*,/,
     *      1H*, 6X,'NBTKNT =',I2,
     *              ' MAXIMUM ISOSPINS (2T) ADMITTED ARE: LEFT =',I2,
     *              ' RIGHT =',I2,6X,1H*)
C
         IF (NBTKNT.GT.NDBTKN) THEN
         WRITE(*,102) NBTKNT,NDBTKN
 102     FORMAT (1H*,77(1H-),1H*,/,
     *           1H*,8X,' STOP:',
     *                  ' RECOMPILE THE CODE WITH LARGER NUMBER',
     *                  ' OF KNOTS - NDBTKN',7X,1H*,/,
     *           1H*,26X,' NBTKNT =',I3,' >',' NDBTKN =',I3,25X,1H*,/,
     *           1H*,77(1H-),1H*)
         STOP
         END IF
C
         CALL GAULEG(-1.D0,1.D0,YBT_PN,YBT_WG,NBTKNT)
C
            DO I=1,NBTKNT
C
               YBT_PN(I)=ACOS(YBT_PN(I))
C
            END DO
C
        ITL=1
        DO ISOSAC = ISOMIL,ISOMAL,2
        ITL=ITL+1
C
           DO LPROJE = -IIFERL,IIFERL,2
              F_KT_L(LPROJE,ITL,0)=F_KT_L(LPROJE,1,0)
           END DO
C
        END DO
C
        ITR=1
        DO ISOSAC = ISOMIR,ISOMAR,2
        ITR=ITR+1
C
           DO KPROJB = -IIFERR,IIFERR,2
              F_KT_R(KPROJB,ITR,0)=F_KT_R(KPROJB,1,0)
           END DO
C
        END DO
C
        END IF
C
C=======================================================================
C             HERE BEGIN THE LOOPS OVER THE GAUSS KNOTS.
C=======================================================================
C
      DO I=1,NUAKNO
         DO K=1,NUAKNO
            DO J=1,NUBKNO
C
               ALPROT=XA_PNT(I)
               BETROT=XB_PNT(J)
               GAMROT=XA_PNT(K)
C
               DO L=1,NBTKNT
C
                 BETISO=YBT_PN(L)
C
                 DO ICHARG=0,NDISOS
C
C=======================================================================
C         FETCHING THE RIGHT WAVE FUNCTIONS FOR THE GIVEN CHARGE
C=======================================================================
C
                  LSTATR=LDSTAR(ICHARG)
C
                  DO ISTATE=1,LSTATR
                     DO IBASE=1,LDBASE
                        DO ISPIN=0,NDSPIN
C
                             WARIGH(IBASE,ISTATE,ISPIN)=
     *                       SARIGH(IBASE,ISTATE,ISPIN,ICHARG,1)
C
                        END DO
                     END DO
                  END DO
C
                  IF (NUAKNO.GT.1.OR.NUBKNO.GT.1)
     *
     *                CALL ROTWAV(LSTATR,WARIGH)
C
                  IF (IKEINV.GE.1.OR.IKEKAR.GE.1)
     *
     *                CALL INVWAV(LSTATR,IKEINV,IKEKAR,WARIGH)
C
                  DO ISTATE=1,LSTATR
                     DO IBASE=1,LDBASE
                        JBASE=  LDBASE+IBASE
                        DO ISPIN=0,NDSPIN
C
                          IF (ICHARG.EQ.0) THEN
                             TARIGH(IBASE,ISTATE,ISPIN)=
     *                       COS(BETISO/2)*WARIGH(IBASE,ISTATE,ISPIN)
C
                             TARIGH(JBASE,ISTATE,ISPIN)=
     *                       SIN(BETISO/2)*WARIGH(IBASE,ISTATE,ISPIN)
C
                          ELSE
C
                             JSTATE=LDSTAR(0)+ISTATE
                             TARIGH(IBASE,JSTATE,ISPIN)=
     *                      -SIN(BETISO/2)*WARIGH(IBASE,ISTATE,ISPIN)
C
                             TARIGH(JBASE,JSTATE,ISPIN)=
     *                       COS(BETISO/2)*WARIGH(IBASE,ISTATE,ISPIN)
C
                          ENDIF
C
                        END DO
                     END DO
                  END DO
C
C=======================================================================
C         FETCHING THE LEFT WAVE FUNCTIONS FOR THE GIVEN CHARGE
C=======================================================================
C
                  LSTATL=LDSTAL(ICHARG)
C
                  DO ISTATE=1,LSTATL
                     DO IBASE=1,LDBASE
                        DO ISPIN=0,NDSPIN
C
                             WALEFT(IBASE,ISTATE,ISPIN)=
     *                       SALEFT(IBASE,ISTATE,ISPIN,ICHARG)
C
                        END DO
                     END DO
                  END DO
C
                  DO ISTATE=1,LSTATL
                     DO IBASE=1,LDBASE
                        JBASE=  LDBASE+IBASE
                        DO ISPIN=0,NDSPIN
C
                          IF (ICHARG.EQ.0) THEN
                             TALEFT(IBASE,ISTATE,ISPIN)=
     *                       WALEFT(IBASE,ISTATE,ISPIN)
C
                             TALEFT(JBASE,ISTATE,ISPIN)=C_ZERO
C
                          ELSE
C
                             JSTATE=LDSTAL(0)+ISTATE
                             TALEFT(IBASE,JSTATE,ISPIN)=C_ZERO
C
                             TALEFT(JBASE,JSTATE,ISPIN)=
     *                       WALEFT(IBASE,ISTATE,ISPIN)
C
                          ENDIF
C
                        END DO
                     END DO
                  END DO
C=======================================================================
C                    ----> END OF CHARGE LOOP <----
C=======================================================================
                 END DO
C
C=======================================================================
C                     CALCULATING THE OVERLAP MATRIX
C=======================================================================
C
                  LSTAT2=LDSTAR(0)+LDSTAR(1)
                  LBASE2=LDBASE   +LDBASE
C
                  IF (LSTAT2.GT.4*NDSTAT)
     *                STOP ' LSTAT2.GT.4*NDSTAT IN BETAME'
C
                  DO ISTATE=1,LSTAT2
                     DO JSTATE=1,LSTAT2
C
                          OVRLAP(ISTATE,JSTATE)=C_ZERO
C
                     END DO
                  END DO
C
                  DO ISTATE=1,LSTAT2
                     DO JSTATE=1,LSTAT2
                        DO IBASE=1,LBASE2
                           DO ISPIN=0,NDSPIN
C
                              OVRLAP(ISTATE,JSTATE)=
     *                        OVRLAP(ISTATE,JSTATE)
     *                        +CONJG(TALEFT(IBASE,ISTATE,ISPIN))
     *                              *TARIGH(IBASE,JSTATE,ISPIN)
C
                           END DO
                        END DO
                     END DO
                  END DO
C
C=======================================================================
C                     INVERTING THE OVERLAP MATRIX
C=======================================================================
C
                  CALL ZGECO(OVRLAP,4*NDSTAT,LSTAT2,IAUXDI,
     *                                       RICOND,AUXDIA)
                  CALL ZGEDI(OVRLAP,4*NDSTAT,LSTAT2,IAUXDI,
     *                                       DETWRK,AUXDIA,11)
C
                  OVKERN(I,J,K,L)=DETWRK(1)*10.0D0**REAL(DETWRK(2))
C
                  IF (ABS(RICOND).LT.1.0D-12.AND.IHEADE.EQ.0) THEN
C
                      WRITE(NFIPRI,*)
     *                'BE CAREFUL - THE OVERLAP MATRIX ',
     *                'MAY BE SINGULAR FOR:'
                      WRITE(NFIPRI,'(''  I='',I3,''  J='',I3,
     *                               ''  K='',I3,''  L='',I3,
     *                               ''  ICHARG='',I1,''  MPAHFB='',I1,
     *                               ''  RICOND='',E15.5)')
     *                               I,J,K,L,ICHARG,MPAHFB,RICOND
C
                      IHEADE=1
C
                  END IF
C
C=======================================================================
C     SUMMING UP RIGHT VECTORS WITH THE INVERSE OF THE OVERLAP MATRIX
C=======================================================================
C
                  DO I_BASE=1,2*LDBASE
C
                     DO ISTATE=1,LSTAT2
C
                        DO ISPIN=0,NDSPIN
C
                           WARAUX(ISTATE,ISPIN)=C_ZERO
C
                           DO KSTATE=1,LSTAT2
C
                              WARAUX(ISTATE,ISPIN)=WARAUX(ISTATE,ISPIN)
     *                                     +TARIGH(I_BASE,KSTATE,ISPIN)
     *                                     *OVRLAP(KSTATE,ISTATE)
                           END DO
C
                        END DO
                     END DO
C
                     DO ISTATE=1,LSTAT2
                        DO ISPIN=0,NDSPIN
C
                           TARIGH(I_BASE,ISTATE,ISPIN)=
     *                            WARAUX(ISTATE,ISPIN)
C
                        END DO
                     END DO
C
                  END DO
C
C=======================================================================
C                      HERE STARTS "KERNEL" BLOCK
C=======================================================================
C
               TRNN=C_ZERO
               TRPP=C_ZERO
               TRNP=C_ZERO
               TRPN=C_ZERO
C
               DO ICHARG=0,NDISOS
                  LSTATE=LDSTAT(ICHARG)
C
C=======================================================================
C          FETCHING THE LEFT WAVE FUNCTIONS FOR THE GIVEN CHARGE
C=======================================================================
C
                  DO ISTATE=1,LSTATE
                     DO IBASE=1,LDBASE
                        DO ISPIN=0,NDSPIN
C
                               WALEFT(IBASE,ISTATE,ISPIN)=
     *                         SALEFT(IBASE,ISTATE,ISPIN,ICHARG)
C
                        END DO
                     END DO
                  END DO
C
                  IF (ICHARG.EQ.0) THEN
C
C=======================================================================
C            FETCHING THE RIGHT WAVE FUNCTIONS TO BE USED TO
C               CALCULATE THE NEUTRON-NEUTRON DENSITY
C=======================================================================
C
                    DO IBASE=1,LDBASE
                       DO ISTATE=1,LSTATE
                          DO ISPIN=0,NDSPIN
C
                               WARIGH(IBASE,ISTATE,ISPIN)=
     *                         TARIGH(IBASE,ISTATE,ISPIN)
C
                          END DO
                       END DO
                    END DO
C
C=======================================================================
C           CALCULATING NEUTRON-NEUTRON TRANSITION DENSITY MATRIX
C=======================================================================
C
                    CALL DENMAC(MREVER,ICHARG,ISIMPY,IPAHFB,
     *                                        WALEFT,WARIGH,1)
C
                    CALL SAVDEN(ISIMPY,ITPNMX)
C
                    DO IBRA=1,LDBASE
                       TRNN=TRNN+(BIG_PP(IBRA,IBRA,0)
     *                           +BIG_PP(IBRA,IBRA,1))
                    END DO
C
                    CALL SPIKER(ISIMPY,IROTAT,SPININ)
C
                    DO ISPI=1,NDKART
                       SPI_NN(ISPI)=SPININ(ISPI)
                    END DO
C
C=======================================================================
C            FETCHING THE RIGHT WAVE FUNCTIONS TO BE USED TO
C                 CALCULATE THE PROTON-NEUTRON DENSITY
C=======================================================================
C
                    DO IBASE=1,LDBASE
                       JBASE=  LDBASE+IBASE
                       DO ISTATE=1,LSTATE
                          DO ISPIN=0,NDSPIN
C
                               WARIGH(IBASE,ISTATE,ISPIN)=
     *                         TARIGH(JBASE,ISTATE,ISPIN)
C
                          END DO
                       END DO
                    END DO
C
C=======================================================================
C             CALCULATING PROTON-NEUTRON TRANSITION DENSITY MATRIX
C=======================================================================
C
                    CALL DENMAC(MREVER,ICHARG,ISIMPY,IPAHFB,
     *                                        WALEFT,WARIGH,1)
C
                    CALL SAVDEN(ISIMPY,ITPNMX)
C
                    DO IBRA=1,LDBASE
                       TRPN=TRPN+(BIG_PP(IBRA,IBRA,0)
     *                           +BIG_PP(IBRA,IBRA,1))
                    END DO
C
                    CALL SPIKER(ISIMPY,IROTAT,SPININ)
C
                    DO ISPI=1,NDKART
                       SPI_PN(ISPI)=SPININ(ISPI)
                    END DO
C
                  ELSE
C
C=======================================================================
C             FETCHING THE RIGHT WAVE FUNCTIONS TO BE USED
C               TO CALCULATE THE PROTON-PROTON DENSITIES
C=======================================================================
C
                    DO IBASE=1,LDBASE
                       JBASE=  LDBASE+IBASE
                       DO ISTATE=1,LDSTAT(1)
                          KSTATE=  LDSTAT(0)+ISTATE
                          DO ISPIN=0,NDSPIN
                            WARIGH(IBASE,ISTATE,ISPIN)
     *                     =TARIGH(JBASE,KSTATE,ISPIN)
                          END DO
                       END DO
                    END DO
C
C=======================================================================
C            CALCULATING PROTON-PROTON TRANSITION DENSITY MATRIX
C=======================================================================
C
                    CALL DENMAC(MREVER,ICHARG,ISIMPY,IPAHFB,
     *                                        WALEFT,WARIGH,1)
C
                    CALL SAVDEN(ISIMPY,ITPNMX)
C
                    DO IBRA=1,LDBASE
                       TRPP=TRPP+(BIG_PP(IBRA,IBRA,0)
     *                           +BIG_PP(IBRA,IBRA,1))
                    END DO
C
                    CALL SPIKER(ISIMPY,IROTAT,SPININ)
C
                    DO ISPI=1,NDKART
                       SPI_PP(ISPI)=SPININ(ISPI)
                    END DO
C
C=======================================================================
C             FETCHING THE RIGHT WAVE FUNCTIONS TO BE USED
C               TO CALCULATE THE NEUTRON-PROTON DENSITIES
C=======================================================================
C
                    DO IBASE=1,LDBASE
                       DO ISTATE=1,LDSTAT(1)
                          KSTATE=  LDSTAT(0)+ISTATE
                          DO ISPIN=0,NDSPIN
                            WARIGH(IBASE,ISTATE,ISPIN)
     *                     =TARIGH(IBASE,KSTATE,ISPIN)
                          END DO
                       END DO
                    END DO
C
C
C=======================================================================
C           CALCULATING NEUTRON-PROTON TRANSITION DENSITY MATRIX
C=======================================================================
C
                    CALL DENMAC(MREVER,ICHARG,ISIMPY,IPAHFB,
     *                                        WALEFT,WARIGH,1)
C
                    CALL SAVDEN(ISIMPY,ITPNMX)
C
                    DO IBRA=1,LDBASE
                       TRNP  =TRNP  +(BIG_PP(IBRA,IBRA,0)
     *                               +BIG_PP(IBRA,IBRA,1))
                    END DO
C
                    CALL SPIKER(ISIMPY,IROTAT,SPININ)
C
                    DO ISPI=1,NDKART
                       SPI_NP(ISPI)=SPININ(ISPI)
                    END DO
C
               END IF
C
               END DO
C
               PNKE10(I,J,K,L)= TRNN-TRPP
               PNKE1M(I,J,K,L)=+SQRT(2.)*TRNP
               PNKE1P(I,J,K,L)=-SQRT(2.)*TRPN
C
CWS: CONTROL OUTPUT
CWS        IF(I.EQ.1.AND.K.EQ.1) THEN
CWS        WRITE(*,201) I,J,K,L,PNKE10(I,J,K,L),
CWS     *               PNKE1M(I,J,K,L),PNKE1P(I,J,K,L)
CWS  201   FORMAT(1H%,2X,4I3,1X,6F10.5,2X,1H%)
CWS        ENDIF
CWS: CONTROL OUTPUT
C
C=======================================================================
C           BUILD MATRIX ELEMENTS OF THE CARTESIAN OPERATORS:
C                         O_ij = TAU_i * SIGMA_j
C=======================================================================
C
               DO ISPI=1,NDKART
C
                  TAUXSP(ISPI) =        2.*(SPI_NP(ISPI)+SPI_PN(ISPI))
                  TAUYSP(ISPI) = UNIT_I*2.*(SPI_NP(ISPI)-SPI_PN(ISPI))
                  TAUZSP(ISPI) =        2.*(SPI_NN(ISPI)-SPI_PP(ISPI))
C
               END DO
C
CWS: CONTROL OUTPUT
CWS               IF (I.EQ.1.AND.J.EQ.1.AND.K.EQ.1) THEN
CWS               WRITE(*,1999) TAUXSP(1),TAUXSP(2),TAUXSP(3),
CWS     *                       TAUYSP(1),TAUYSP(2),TAUYSP(3),
CWS     *                       TAUZSP(1),TAUZSP(2),TAUZSP(3)
CWS 1999          FORMAT(1X,6(F14.5),/,1X,6(F14.5),/,1X,6(F14.5))
CWS               END IF
CWS: CONTROL OUTPUT
C
C=======================================================================
C   REWRITE MATRIX ELEMENTS (KERNELS) TO THE SPHERICAL REPRESENTATION
C                         O_ij = TAU_1\mu * SIGMA_1\nu
C                INDICES \mu AND \nu ARE ENCODED IN THE NAMES
C=======================================================================
C
               GTKE00(I,J,K,L) =   TAUZSP(3)
               GTKE0P(I,J,K,L) = -(TAUZSP(1)+UNIT_I*TAUZSP(2))/SQRT(2.)
               GTKE0M(I,J,K,L) =  (TAUZSP(1)-UNIT_I*TAUZSP(2))/SQRT(2.)
C
               GTKEP0(I,J,K,L) = -(TAUXSP(3)+UNIT_I*TAUYSP(3))/SQRT(2.)
               GTKEPP(I,J,K,L) =  (TAUXSP(1)+UNIT_I*TAUXSP(2)
     *                            -TAUYSP(2)+UNIT_I*TAUYSP(1))/2
               GTKEPM(I,J,K,L) = -(TAUXSP(1)-UNIT_I*TAUXSP(2)
     *                            +TAUYSP(2)+UNIT_I*TAUYSP(1))/2
C
               GTKEM0(I,J,K,L) =  (TAUXSP(3)-UNIT_I*TAUYSP(3))/SQRT(2.)
               GTKEMP(I,J,K,L) = -(TAUXSP(1)+UNIT_I*TAUXSP(2)
     *                            +TAUYSP(2)-UNIT_I*TAUYSP(1))/2
               GTKEMM(I,J,K,L) =  (TAUXSP(1)-UNIT_I*TAUXSP(2)
     *                            -TAUYSP(2)-UNIT_I*TAUYSP(1))/2
CWS: CONTROL OUTPUT
CWS      WRITE(*,1668) I,J,K,L,GTKE00(I,J,K,L),GTKE0P(I,J,K,L),
CWS     *                                      GTKE0M(I,J,K,L)
CWS      WRITE(*,1669) I,J,K,L,GTKEP0(I,J,K,L),GTKEPP(I,J,K,L),
CWS     *                                      GTKEPM(I,J,K,L)
CWS      WRITE(*,1670) I,J,K,L,GTKEM0(I,J,K,L),GTKEMP(I,J,K,L),
CWS     *                                      GTKEMM(I,J,K,L)
CWS 1668 FORMAT(' 00,0P,0M:',4I3,6F12.5)
CWS 1669 FORMAT(' P0,PP,PM:',4I3,6F12.5)
CWS 1670 FORMAT(' M0,MP,MM:',4I3,6F12.5)
CWS: CONTROL OUTPUT
C
C=======================================================================
C               HERE END THE LOOPS OVER THE EULER ANGLES
C=======================================================================
C
               END DO
            END DO
         END DO
      END DO
C
C=======================================================================
C                          KERNELS ARE LOADED
C                   HERE STARTS THE "INTEGRATION" BLOCK
C=======================================================================
C
C ---> IT IS ENOUGH TO TAKE ISOSAC FROM ISOMIR TO ISOMAR
C      (SEE A FORMULA FOR FER_ME BELOW)
C
C      ISOMIN=ISOMIL
C      IF (ISOMIR.LT.ISOMIL) ISOMIN=ISOMIR
C      ISOMAX=ISOMAL
C      IF (ISOMAR.GT.ISOMAL) ISOMAX=ISOMAR
C
      ISOMIN=ISOMIR
      ISOMAX=ISOMAR
C
      IT = 0
      DO ISOSAC=ISOMIR,ISOMAR,2
      IT = IT+1
C
         DO LPROAC=-IIFERR,IIFERR,2
            DO KPROAC=-IIFERR,IIFERR,2
C
            TPN_10(LPROAC,KPROAC,IT)=C_ZERO
            TPN_1P(LPROAC,KPROAC,IT)=C_ZERO
            TPN_1M(LPROAC,KPROAC,IT)=C_ZERO
C
            TSP_00(LPROAC,KPROAC,IT)=C_ZERO
            TSP_0P(LPROAC,KPROAC,IT)=C_ZERO
            TSP_0M(LPROAC,KPROAC,IT)=C_ZERO
C
            TSP_P0(LPROAC,KPROAC,IT)=C_ZERO
            TSP_PP(LPROAC,KPROAC,IT)=C_ZERO
            TSP_PM(LPROAC,KPROAC,IT)=C_ZERO
C
            TSP_M0(LPROAC,KPROAC,IT)=C_ZERO
            TSP_MP(LPROAC,KPROAC,IT)=C_ZERO
            TSP_MM(LPROAC,KPROAC,IT)=C_ZERO
C
            END DO
         END DO
C
      END DO
C
C=======================================================================
C
      DO J=1,NUBKNO
        DO I=1,NUAKNO
          DO K=1,NUAKNO
C
            IT = 0
            DO ISOSAC=ISOMIR,ISOMAR,2
            IT = IT+1
C
            TPNU10(IT)=C_ZERO
            TPNU1P(IT)=C_ZERO
            TPNU1M(IT)=C_ZERO
C
            TSPU00(IT)=C_ZERO
            TSPU0P(IT)=C_ZERO
            TSPU0M(IT)=C_ZERO
C
            TSPUP0(IT)=C_ZERO
            TSPUPP(IT)=C_ZERO
            TSPUPM(IT)=C_ZERO
C
            TSPUM0(IT)=C_ZERO
            TSPUMP(IT)=C_ZERO
            TSPUMM(IT)=C_ZERO
C
               DO L=1,NBTKNT
C
                  FACI10=C_ZERO
                  FACI1M=C_ZERO
                  FACI1P=C_ZERO
C
                  IF (ISOSAC.GE.IABS(ISOTZR)) THEN
                     IF (ISOSAC.GE.IABS(ISOTZL  ))
     *                 FACI10=DSMALH(ISOSAC,ISOTZL  ,ISOTZR,
     *                                   YBT_PN(L),NEWWIG,ISWIND,NUANGU)
                     IF (ISOSAC.GE.IABS(ISOTZL-2))
     *                 FACI1P=DSMALH(ISOSAC,ISOTZL-2,ISOTZR,
     *                                   YBT_PN(L),NEWWIG,ISWIND,NUANGU)
                     IF (ISOSAC.GE.IABS(ISOTZL+2))
     *                 FACI1M=DSMALH(ISOSAC,ISOTZL+2,ISOTZR,
     *                                   YBT_PN(L),NEWWIG,ISWIND,NUANGU)
                  END IF
C
                  FACI10=FACI10*YBT_WG(L)*OVKERN(I,J,K,L)
                  FACI1M=FACI1M*YBT_WG(L)*OVKERN(I,J,K,L)
                  FACI1P=FACI1P*YBT_WG(L)*OVKERN(I,J,K,L)
C
                  TPNU10(IT)=TPNU10(IT)+FACI10*PNKE10(I,J,K,L)
                  TPNU1P(IT)=TPNU1P(IT)+FACI1P*PNKE1P(I,J,K,L)
                  TPNU1M(IT)=TPNU1M(IT)+FACI1M*PNKE1M(I,J,K,L)
C
                  TSPU00(IT)=TSPU00(IT)+FACI10*GTKE00(I,J,K,L)
                  TSPU0P(IT)=TSPU0P(IT)+FACI10*GTKE0P(I,J,K,L)
                  TSPU0M(IT)=TSPU0M(IT)+FACI10*GTKE0M(I,J,K,L)
C
                  TSPUP0(IT)=TSPUP0(IT)+FACI1P*GTKEP0(I,J,K,L)
                  TSPUPP(IT)=TSPUPP(IT)+FACI1P*GTKEPP(I,J,K,L)
                  TSPUPM(IT)=TSPUPM(IT)+FACI1P*GTKEPM(I,J,K,L)
C
                  TSPUM0(IT)=TSPUM0(IT)+FACI1M*GTKEM0(I,J,K,L)
                  TSPUMP(IT)=TSPUMP(IT)+FACI1M*GTKEMP(I,J,K,L)
                  TSPUMM(IT)=TSPUMM(IT)+FACI1M*GTKEMM(I,J,K,L)
C
C=======================================================================
C        HERE END THE LOOPS OVER L (BETISO) GAUSS KNOTS & ISOSPIN
C=======================================================================
C
               END DO
            END DO
C
            IT = 0
            DO ISOSAC=ISOMIR,ISOMAR,2
            IT = IT+1
               PNKE10(I,J,K,IT)=TPNU10(IT)
               PNKE1P(I,J,K,IT)=TPNU1P(IT)
               PNKE1M(I,J,K,IT)=TPNU1M(IT)
C
               GTKE00(I,J,K,IT)=TSPU00(IT)
               GTKE0P(I,J,K,IT)=TSPU0P(IT)
               GTKE0M(I,J,K,IT)=TSPU0M(IT)
C
               GTKEP0(I,J,K,IT)=TSPUP0(IT)
               GTKEPP(I,J,K,IT)=TSPUPP(IT)
               GTKEPM(I,J,K,IT)=TSPUPM(IT)
C
               GTKEM0(I,J,K,IT)=TSPUM0(IT)
               GTKEMP(I,J,K,IT)=TSPUMP(IT)
               GTKEMM(I,J,K,IT)=TSPUMM(IT)
C
            END DO
C
          END DO
        END DO
      END DO
C=======================================================================
C   ----> HERE STARTS INTEGRATION OVER THE ALPHA,BETA,GAMMA ANGLES <----
C=======================================================================
      DO J=1,NUBKNO
C
      IT = 0
      DO ISOSAC=ISOMIR,ISOMAR,2
      IT = IT+1
C
          DO I=1,NUAKNO
C
          DO KPROAC=-IIFERR,IIFERR,2
C
C=======================================================================
C         ZEROING AUXILIARY ARRAYS OF OVERLAP AND ENERGY KERNELS
C=======================================================================
C
          ZPNU10(I,KPROAC,IT)=C_ZERO
          ZPNU1P(I,KPROAC,IT)=C_ZERO
          ZPNU1M(I,KPROAC,IT)=C_ZERO
C
          ZSPU00(I,KPROAC,IT)=C_ZERO
          ZSPU0P(I,KPROAC,IT)=C_ZERO
          ZSPU0M(I,KPROAC,IT)=C_ZERO
C
          ZSPUP0(I,KPROAC,IT)=C_ZERO
          ZSPUPP(I,KPROAC,IT)=C_ZERO
          ZSPUPM(I,KPROAC,IT)=C_ZERO
C
          ZSPUM0(I,KPROAC,IT)=C_ZERO
          ZSPUMP(I,KPROAC,IT)=C_ZERO
          ZSPUMM(I,KPROAC,IT)=C_ZERO
C
C=======================================================================
C         BELOW WE INTEGRATE KERNELS OVER THE GAMMA EULER ANGLE AND
C         AT THE SAME TIME WE MULTIPLY THEM BY THE  GAUSS  WEIGHTS
C=======================================================================
C
              DO K=1,NUAKNO
C
              GAMM_K=XA_PNT(K)*0.5D0*KPROAC
C
              FACINT=XA_WGT(K)*(COS(GAMM_K)+UNIT_I*SIN(GAMM_K))
C
                  ZPNU10(I,KPROAC,IT)=ZPNU10(I,KPROAC,IT)
     *                           +FACINT*PNKE10(I,J,K,IT)
                  ZPNU1P(I,KPROAC,IT)=ZPNU1P(I,KPROAC,IT)
     *                           +FACINT*PNKE1P(I,J,K,IT)
                  ZPNU1M(I,KPROAC,IT)=ZPNU1M(I,KPROAC,IT)
     *                           +FACINT*PNKE1M(I,J,K,IT)
C
                  ZSPU00(I,KPROAC,IT)=ZSPU00(I,KPROAC,IT)
     *                           +FACINT*GTKE00(I,J,K,IT)
                  ZSPU0P(I,KPROAC,IT)=ZSPU0P(I,KPROAC,IT)
     *                           +FACINT*GTKE0P(I,J,K,IT)
                  ZSPU0M(I,KPROAC,IT)=ZSPU0M(I,KPROAC,IT)
     *                           +FACINT*GTKE0M(I,J,K,IT)
C
                  ZSPUP0(I,KPROAC,IT)=ZSPUP0(I,KPROAC,IT)
     *                           +FACINT*GTKEP0(I,J,K,IT)
                  ZSPUPP(I,KPROAC,IT)=ZSPUPP(I,KPROAC,IT)
     *                           +FACINT*GTKEPP(I,J,K,IT)
                  ZSPUPM(I,KPROAC,IT)=ZSPUPM(I,KPROAC,IT)
     *                           +FACINT*GTKEPM(I,J,K,IT)
C
                  ZSPUM0(I,KPROAC,IT)=ZSPUM0(I,KPROAC,IT)
     *                           +FACINT*GTKEM0(I,J,K,IT)
                  ZSPUMP(I,KPROAC,IT)=ZSPUMP(I,KPROAC,IT)
     *                           +FACINT*GTKEMP(I,J,K,IT)
                  ZSPUMM(I,KPROAC,IT)=ZSPUMM(I,KPROAC,IT)
     *                           +FACINT*GTKEMM(I,J,K,IT)
C
C=======================================================================
C          HERE END THE LOOPS  OVER THE  GAMMA (K) GAUSS  KNOTS
C         AND THE LOOP OVER THE K PROJECTION ON THE INTRINSIC AXIS
C=======================================================================
C
              END DO
          END DO
C
C=======================================================================
C           HERE END THE LOOPS  OVER THE  ALPHA (I) GAUSS  KNOTS
C=======================================================================
C
        END DO
C
C
C=======================================================================
C         HERE STARTS THE LOOP OVER THE K' PROJECTION ON THE INTRINSIC
C         AXIS; INDEX "LPROAC", AND OVER THE K PROJECTION ON THE
C         INTRINSIC AXIS; INDEX "KPROAC".
C=======================================================================
C
          DO LPROAC=-IIFERR,IIFERR,2
            DO KPROAC=-IIFERR,IIFERR,2
C
C=======================================================================
C                   ZEROING AUXILIARY ARRAYS
C=======================================================================
C
              CPNU10(LPROAC,KPROAC,IT)=C_ZERO
              CPNU1P(LPROAC,KPROAC,IT)=C_ZERO
              CPNU1M(LPROAC,KPROAC,IT)=C_ZERO
C
              CSPU00(LPROAC,KPROAC,IT)=C_ZERO
              CSPU0P(LPROAC,KPROAC,IT)=C_ZERO
              CSPU0M(LPROAC,KPROAC,IT)=C_ZERO
C
              CSPUP0(LPROAC,KPROAC,IT)=C_ZERO
              CSPUPP(LPROAC,KPROAC,IT)=C_ZERO
              CSPUPM(LPROAC,KPROAC,IT)=C_ZERO
C
              CSPUM0(LPROAC,KPROAC,IT)=C_ZERO
              CSPUMP(LPROAC,KPROAC,IT)=C_ZERO
              CSPUMM(LPROAC,KPROAC,IT)=C_ZERO
C
C=======================================================================
C         HERE WE INTEGRATE THE KERNELS OVER THE ALPHA EULER ANGLE
C=======================================================================
C
              DO I=1,NUAKNO
C
              ALPH_L=XA_PNT(I)*0.5D0*LPROAC
              FACINT=XA_WGT(I)*(COS(ALPH_L)+UNIT_I*SIN(ALPH_L))
C
              CPNU10(LPROAC,KPROAC,IT)=CPNU10(LPROAC,KPROAC,IT)
     *                         +FACINT*ZPNU10(I,     KPROAC,IT)
              CPNU1P(LPROAC,KPROAC,IT)=CPNU1P(LPROAC,KPROAC,IT)
     *                         +FACINT*ZPNU1P(I,     KPROAC,IT)
              CPNU1M(LPROAC,KPROAC,IT)=CPNU1M(LPROAC,KPROAC,IT)
     *                         +FACINT*ZPNU1M(I,     KPROAC,IT)
C
              CSPU00(LPROAC,KPROAC,IT)=CSPU00(LPROAC,KPROAC,IT)
     *                         +FACINT*ZSPU00(I,     KPROAC,IT)
              CSPU0P(LPROAC,KPROAC,IT)=CSPU0P(LPROAC,KPROAC,IT)
     *                         +FACINT*ZSPU0P(I,     KPROAC,IT)
              CSPU0M(LPROAC,KPROAC,IT)=CSPU0M(LPROAC,KPROAC,IT)
     *                         +FACINT*ZSPU0M(I,     KPROAC,IT)
C
              CSPUP0(LPROAC,KPROAC,IT)=CSPUP0(LPROAC,KPROAC,IT)
     *                         +FACINT*ZSPUP0(I,     KPROAC,IT)
              CSPUPP(LPROAC,KPROAC,IT)=CSPUPP(LPROAC,KPROAC,IT)
     *                         +FACINT*ZSPUPP(I,     KPROAC,IT)
              CSPUPM(LPROAC,KPROAC,IT)=CSPUPM(LPROAC,KPROAC,IT)
     *                         +FACINT*ZSPUPM(I,     KPROAC,IT)
C
              CSPUM0(LPROAC,KPROAC,IT)=CSPUM0(LPROAC,KPROAC,IT)
     *                         +FACINT*ZSPUM0(I,     KPROAC,IT)
              CSPUMP(LPROAC,KPROAC,IT)=CSPUMP(LPROAC,KPROAC,IT)
     *                         +FACINT*ZSPUMP(I,     KPROAC,IT)
              CSPUMM(LPROAC,KPROAC,IT)=CSPUMM(LPROAC,KPROAC,IT)
     *                         +FACINT*ZSPUMM(I,     KPROAC,IT)
C
C=======================================================================
C         HERE ENDS THE LOOP OVER THE ALPHA GAUSS KNOTS (I), THE
C         LOOPS OVER THE L AND K PROJECTIONS ON THE INTRINSIC AXIS,
C         AND THE LOOP OVER THE ISOSPIN
C=======================================================================
C
              END DO
C
            END DO
          END DO
C
       END DO
C
C=======================================================================
C               HERE STARTS FINAL INTEGRATION OVER BETA (J)
C=======================================================================
C
            DO LPROAC=-IIFERR,IIFERR,2
C
               DO KPROAC=-IIFERR,IIFERR,2
C
                  FACINT=XB_WGT(J)*DSMALH(IIFERR,LPROAC,KPROAC,
     *                                   XB_PNT(J),NEWWIG,ISWIND,NUANGU)
C
                  IT = 0
                  DO ISOSAC=ISOMIR,ISOMAR,2
                  IT = IT+1
C
                  TPN_10(LPROAC,KPROAC,IT)=
     *            TPN_10(LPROAC,KPROAC,IT)
     *                   +FACINT*CPNU10(LPROAC,KPROAC,IT)
                  TPN_1P(LPROAC,KPROAC,IT)=
     *            TPN_1P(LPROAC,KPROAC,IT)
     *                   +FACINT*CPNU1P(LPROAC,KPROAC,IT)
                  TPN_1M(LPROAC,KPROAC,IT)=
     *            TPN_1M(LPROAC,KPROAC,IT)
     *                   +FACINT*CPNU1M(LPROAC,KPROAC,IT)
C
                  TSP_00(LPROAC,KPROAC,IT)=
     *            TSP_00(LPROAC,KPROAC,IT)
     *                   +FACINT*CSPU00(LPROAC,KPROAC,IT)
                  TSP_0P(LPROAC,KPROAC,IT)=
     *            TSP_0P(LPROAC,KPROAC,IT)
     *                   +FACINT*CSPU0P(LPROAC,KPROAC,IT)
                  TSP_0M(LPROAC,KPROAC,IT)=
     *            TSP_0M(LPROAC,KPROAC,IT)
     *                   +FACINT*CSPU0M(LPROAC,KPROAC,IT)
C
                  TSP_P0(LPROAC,KPROAC,IT)=
     *            TSP_P0(LPROAC,KPROAC,IT)
     *                   +FACINT*CSPUP0(LPROAC,KPROAC,IT)
                  TSP_PP(LPROAC,KPROAC,IT)=
     *            TSP_PP(LPROAC,KPROAC,IT)
     *                   +FACINT*CSPUPP(LPROAC,KPROAC,IT)
                  TSP_PM(LPROAC,KPROAC,IT)=
     *            TSP_PM(LPROAC,KPROAC,IT)
     *                   +FACINT*CSPUPM(LPROAC,KPROAC,IT)
C
                  TSP_M0(LPROAC,KPROAC,IT)=
     *            TSP_M0(LPROAC,KPROAC,IT)
     *                   +FACINT*CSPUM0(LPROAC,KPROAC,IT)
                  TSP_MP(LPROAC,KPROAC,IT)=
     *            TSP_MP(LPROAC,KPROAC,IT)
     *                   +FACINT*CSPUMP(LPROAC,KPROAC,IT)
                  TSP_MM(LPROAC,KPROAC,IT)=
     *            TSP_MM(LPROAC,KPROAC,IT)
     *                   +FACINT*CSPUMM(LPROAC,KPROAC,IT)
C
C=======================================================================
C              HERE ENDS THE INTERNAL LOOP OVER THE ISOSPIN
C=======================================================================
C
              END DO
C=======================================================================
C         HERE END THE LOOPS OVER THE ANGULAR MOMENTUM PROJECTIONS
C=======================================================================
C
               END DO
            END DO
C
C=======================================================================
C              HERE ENDS THE LOOP OVER THE BETA GAUSS KNOTS
C=======================================================================
C
      END DO
C
C=======================================================================
C         MULTIPLYING THE INTEGRATED KERNELS BY OVERALL FACTORS
C=======================================================================
C
         DO LPROAC=-IIFERR,IIFERR,2
C
            DO KPROAC=-IIFERR,IIFERR,2
C
               IF (NUBKNO.EQ.1) THEN
                   FACNOI=             1/( 4.0D0*PI*PI)
               ELSE
                   FACNOI=(IIFERR+1.0D0)/( 8.0D0*PI*PI)
               ENDIF
C
               IT=0
C
                  DO ISOSAC=ISOMIR,ISOMAR,2
C
                  IT=IT+1
C
                  IF (NBTKNT.EQ.1) THEN
                      FACNOR=FACNOI
                  ELSE
                      FACNOR=FACNOI*(ISOSAC+1.0D0)/2.D0
                  ENDIF
C
                  TPN_10(LPROAC,KPROAC,IT)=
     *            TPN_10(LPROAC,KPROAC,IT)*FACNOR
                  TPN_1P(LPROAC,KPROAC,IT)=
     *            TPN_1P(LPROAC,KPROAC,IT)*FACNOR
                  TPN_1M(LPROAC,KPROAC,IT)=
     *            TPN_1M(LPROAC,KPROAC,IT)*FACNOR
C
                  TSP_00(LPROAC,KPROAC,IT)=
     *            TSP_00(LPROAC,KPROAC,IT)*FACNOR
                  TSP_0P(LPROAC,KPROAC,IT)=
     *            TSP_0P(LPROAC,KPROAC,IT)*FACNOR
                  TSP_0M(LPROAC,KPROAC,IT)=
     *            TSP_0M(LPROAC,KPROAC,IT)*FACNOR
C
                  TSP_P0(LPROAC,KPROAC,IT)=
     *            TSP_P0(LPROAC,KPROAC,IT)*FACNOR
                  TSP_PP(LPROAC,KPROAC,IT)=
     *            TSP_PP(LPROAC,KPROAC,IT)*FACNOR
                  TSP_PM(LPROAC,KPROAC,IT)=
     *            TSP_PM(LPROAC,KPROAC,IT)*FACNOR
C
                  TSP_M0(LPROAC,KPROAC,IT)=
     *            TSP_M0(LPROAC,KPROAC,IT)*FACNOR
                  TSP_MP(LPROAC,KPROAC,IT)=
     *            TSP_MP(LPROAC,KPROAC,IT)*FACNOR
                  TSP_MM(LPROAC,KPROAC,IT)=
     *            TSP_MM(LPROAC,KPROAC,IT)*FACNOR
C
               END DO
C
C=======================================================================
C                HERE END THE LOOPS OVER THE PROJECTIONS
C=======================================================================
C
            END DO
         END DO
C
C=======================================================================
C
C        CALCULATE MATRIX ELEMENT OF THE FERMI TRANSITION OPERATOR
C
C=======================================================================
C
         FER_ME=C_ZERO
C
         IF (IFE_SR.EQ.1) THEN
C
         ITL=0
         DO ISOACL=ISOMIL,ISOMAL,2
         ITL=ITL+1
C
            ITR=0
            DO ISOACR=ISOMIR,ISOMAR,2
            ITR=ITR+1
C
               IF (ISOTZR.EQ.ISOTZL+2)
     *         CGALL=CGCOEF(ISOACR,ISOTZR  , 2,-2,ISOACL,ISOTZL)
               IF (ISOTZR.EQ.ISOTZL-2)
     *         CGALL=CGCOEF(ISOACR,ISOTZR  , 2, 2,ISOACL,ISOTZL)
C
               CG_10=CGCOEF(ISOACR,ISOTZL  , 2, 0,ISOACL,ISOTZL)
               CG_1P=CGCOEF(ISOACR,ISOTZL-2, 2, 2,ISOACL,ISOTZL)
               CG_1M=CGCOEF(ISOACR,ISOTZL+2, 2,-2,ISOACL,ISOTZL)
C
               DO LPROJE=-IIFERR,IIFERR,2
               DO KPROJB=-IIFERR,IIFERR,2
C
               FER_ME = FER_ME +
     *           CONJG(F_KT_L(LPROJE,ITL,0))*F_KT_R(KPROJB,ITR,0)*
     *                 CGALL*(CG_10*TPN_10(LPROJE,KPROJB,ITR)+
     *                        CG_1P*TPN_1P(LPROJE,KPROJB,ITR)+
     *                        CG_1M*TPN_1M(LPROJE,KPROJB,ITR))
C
CWS: CONTROL OUTPUT
CWS               WRITE (*,701) LPROJE,KPROJB,
CWS     *                       CG_1P*TPN_1P(LPROJE,KPROJB,ITR),
CWS     *                       CG_1M*TPN_1M(LPROJE,KPROJB,ITR)
CWS 701           FORMAT (1H%,2X,2I4,5X,2F12.6,2F12.6,14X,1H%)
CWS: CONTROL OUTPUT
C
               END DO
               END DO
C
            END DO
         END DO
C
C=======================================================================
C   FER_ME CALCULATED ABOVE CORRESPONDS TO
C           <I, T, Tz | T_{1 +/-1} | I, T', Tz-/+1 >
C   HENCE, THE TRUE FERMI M.E. MUST BE SCALED AS FOLLOWS:
C           <I, T, Tz | T_{+/-} | I, T', Tz-/+1 >  =
C                  -/+ <I, T, Tz| T_{1 +/-1} | I, T', Tz-/+1 > / SQRT(2)
C=======================================================================
C
      IF (ISOTZR.EQ.ISOTZL+2)
     *                  FER_ME= FER_ME/SQRT(2.0D0)
      IF (ISOTZR.EQ.ISOTZL-2)
     *                  FER_ME=-FER_ME/SQRT(2.0D0)
C
      WRITE(*,116)
      WRITE(*,112) FER_ME, ABS(FER_ME)**2
 112  FORMAT(1H*,3X,'FERMI MATRIX ELEMENT:',2F14.10,
     *              ' |MF|^2=',F14.10,3X,1H*)
C
      WRITE(*,116)
C
      IF (ITFERR.EQ.ITFERL) THEN
          IF(ISOTZR.EQ.ISOTZL+2)
     *    FACT_T=ITFERR*(ITFERR+2)/4.D0-ISOTZR*(ISOTZR-2)/4.D0
          IF(ISOTZR.EQ.ISOTZL-2)
     *    FACT_T=ITFERR*(ITFERR+2)/4.D0-ISOTZR*(ISOTZR+2)/4.D0
C
C=======================================================================
C                  CALCULATE COULOMB CORRECTION
C                  |M_F|^2 = FACT_T (1-DELTA_C)
C             see HARDY & TOWNER arXiv:0812.1202  Eq. (6)
C            ---------------------------------------------
C=======================================================================
C
      DELTA_C=1-ABS(FER_ME)**2/FACT_T
C
      WRITE(*,109) DELTA_C*100
 109  FORMAT(1H*,15X,'THE CALCULATED ISOSPIN MIXING IS =',
     *                                F10.6,'[%]',15X,1H*)
      WRITE(*,116)
C
      ENDIF
C
      WRITE(*,115)
 115  FORMAT(79(1H*))
C
      END IF
C=======================================================================
C                  END OF THE FERMI TRANSITION ME BLOCK
C=======================================================================
C
C=======================================================================
C     CALCULATE REDUCED MATRIX ELEMENT OF THE G-T TRANSITION OPERATOR
C=======================================================================
C
         IF (IGT_SR.EQ.1) THEN
C
            ITR=0
            DO ISOACR=ISOMIR,ISOMAR,2
            ITR=ITR+1
C
               DO LPROJE=-IIFERR,IIFERR,2
               DO KPROJB=-IIFERR,IIFERR,2
C
CWS: CONTROL OUTPUT
CWS           WRITE(*,1998) LPROJE,KPROJB,ISOACR,
CWS     *     TSP_00(LPROJE,KPROJB,ITR),TSP_0P(LPROJE,KPROJB,ITR),
CWS     *     TSP_0M(LPROJE,KPROJB,ITR),TSP_P0(LPROJE,KPROJB,ITR),
CWS     *     TSP_PP(LPROJE,KPROJB,ITR),TSP_PM(LPROJE,KPROJB,ITR),
CWS     *     TSP_M0(LPROJE,KPROJB,ITR),TSP_MP(LPROJE,KPROJB,ITR),
CWS     *     TSP_MM(LPROJE,KPROJB,ITR)
CWS 1998      FORMAT(1H&,2X,'L,K,T: ',3I4,56X,1H&,/,
CWS     *                  1H&,2X,6(F12.8),3X,1H&,/,
CWS     *                  1H&,2X,6(F12.8),3X,1H&,/,
CWS     *                  1H&,2X,6(F12.8),3X,1H&)
CWS: CONTROL OUTPUT
C
               END DO
               END DO
C
            END DO
C
         GT_RED=C_ZERO
C
         ITL=0
         DO ISOACL=ISOMIL,ISOMAL,2
         ITL=ITL+1
C
            ITR=0
            DO ISOACR=ISOMIR,ISOMAR,2
            ITR=ITR+1
C
               IF (ISOTZR.EQ.ISOTZL+2)
     *         CGTALL=CGCOEF(ISOACR,ISOTZR  , 2,-2,ISOACL,ISOTZL)
               IF (ISOTZR.EQ.ISOTZL-2)
     *         CGTALL=CGCOEF(ISOACR,ISOTZR  , 2, 2,ISOACL,ISOTZL)
C
               CGT_10=CGCOEF(ISOACR,ISOTZL  , 2, 0,ISOACL,ISOTZL)
               CGT_1P=CGCOEF(ISOACR,ISOTZL-2, 2, 2,ISOACL,ISOTZL)
               CGT_1M=CGCOEF(ISOACR,ISOTZL+2, 2,-2,ISOACL,ISOTZL)
C
               DO LPROJE=-IIFERL,IIFERL,2
               DO KPROJB=-IIFERR,IIFERR,2
C
               CGI_10=CGCOEF(IIFERR,LPROJE  , 2, 0,IIFERL,LPROJE)
               CGI_1P=CGCOEF(IIFERR,LPROJE-2, 2, 2,IIFERL,LPROJE)
               CGI_1M=CGCOEF(IIFERR,LPROJE+2, 2,-2,IIFERL,LPROJE)
C
               IF (IIFERR.GE.IABS(LPROJE))
     *         GT_RED = GT_RED +
     *             CONJG(F_KT_L(LPROJE,ITL,0))*F_KT_R(KPROJB,ITR,0)*
     *             CGTALL*(CGT_10*CGI_10*TSP_00(LPROJE  ,KPROJB,ITR)+
     *                     CGT_1P*CGI_10*TSP_P0(LPROJE  ,KPROJB,ITR)+
     *                     CGT_1M*CGI_10*TSP_M0(LPROJE  ,KPROJB,ITR))
C
               IF (IIFERR.GE.IABS(LPROJE-2))
     *         GT_RED = GT_RED +
     *             CONJG(F_KT_L(LPROJE,ITL,0))*F_KT_R(KPROJB,ITR,0)*
     *             CGTALL*(CGT_10*CGI_1P*TSP_0P(LPROJE-2,KPROJB,ITR)+
     *                     CGT_1P*CGI_1P*TSP_PP(LPROJE-2,KPROJB,ITR)+
     *                     CGT_1M*CGI_1P*TSP_MP(LPROJE-2,KPROJB,ITR))
C
               IF (IIFERR.GE.IABS(LPROJE+2))
     *         GT_RED = GT_RED +
     *             CONJG(F_KT_L(LPROJE,ITL,0))*F_KT_R(KPROJB,ITR,0)*
     *             CGTALL*(CGT_10*CGI_1M*TSP_0M(LPROJE+2,KPROJB,ITR)+
     *                     CGT_1P*CGI_1M*TSP_PM(LPROJE+2,KPROJB,ITR)+
     *                     CGT_1M*CGI_1M*TSP_MM(LPROJE+2,KPROJB,ITR))
C
CWS CONTROL:
CWS      WRITE(*,1997) LPROJE,KPROJB,ISOACL,ISOACR,
CWS     *              CONJG(F_KT_L(LPROJE,ITL,0))*F_KT_R(KPROJB,ITR,0),
CWS     *              CGTALL,CGT_10,CGT_1P,CGT_1M,CGI_10,CGI_1P,CGI_1M,
CWS     *              GT_RED
CWS 1997 FORMAT(1X,'KL,KR,TL,TR,GT:',4I4,5X,2F14.10,/,1X,7F10.6,2F14.10)
CWS CONTROL:
C
               END DO
               END DO
C
            END DO
         END DO
C
C=======================================================================
C                         SUM OVER POLARIZATIONS
C=======================================================================
C
      GT_KAR=C_ZERO
      GT_MAT=0.D0
C
         DO LPROJE=-IIFERL,IIFERL,2
            DO KPROJB=-IIFERR,IIFERR,2
C
            GT_KAR(1)=
     *       (CGCOEF(IIFERR,KPROJB, 2,-2,IIFERL,LPROJE)
     *       -CGCOEF(IIFERR,KPROJB, 2, 2,IIFERL,LPROJE))*GT_RED/2.
C
            GT_KAR(2)=UNIT_I*
     *       (CGCOEF(IIFERR,KPROJB, 2,-2,IIFERL,LPROJE)
     *       +CGCOEF(IIFERR,KPROJB, 2, 2,IIFERL,LPROJE))*GT_RED/2.
C
            GT_KAR(3)=
     *        CGCOEF(IIFERR,KPROJB, 2, 0,IIFERL,LPROJE)*GT_RED/SQRT(2.)
C
            GT_MAT = GT_MAT + ABS(GT_KAR(1))**2+ABS(GT_KAR(2))**2
     *                                         +ABS(GT_KAR(3))**2
C
      WRITE(*,1992) LPROJE,KPROJB,GT_KAR(1),GT_KAR(2),GT_KAR(3),GT_MAT
 1992 FORMAT(1H*,1X,2I4,3(1X,2F9.5),F10.6,1X,1H*)
C
            END DO
        END DO
C
      WRITE(*,1993) SQRT(GT_MAT),GT_MAT/3,GT_MAT/(IIFERL+1)
 1993 FORMAT(1H*,55X,'|GT_MAT|  =',F10.6,1X,1H*,/,
     *       1H*,55X,'|GT_MAT|/3=',F10.6,1X,1H*,/,
     *       1H*,55X,'  B(GT)   =',F10.6,1X,1H*)
      WRITE(*,116)
C
C=======================================================================
C       PROPERLY NORMALIZED REDUCED MATRIX ELEMENT OF THE G-T
C  GT^(+/-)_{1M} = -/+ 1/SQRT(2) * SUM_i [TAU_(1 +/-1) SIGMA_1{M}]
C                   OPERATOR EQUALS [B&M 1A-60]:
C=======================================================================
C
C OVERALL PHASE IS STILL MISSING!!!!
C ----------------------------------
C
      GT_RED = GT_RED/SQRT(2.D0)
C
      GT_RED = SQRT(IIFERL+1.D0)*GT_RED
C
C=======================================================================
C    TOTAL GT PROBABILITY SUMMED UP OVER mu=-1,0,1 AND POLARIZATIONS OF
C    THE FINAL STATE M EQUALS [B&M 1A-67]:
C=======================================================================
C
      GTPROB = ABS(GT_RED)**2/(IIFERR+1)
      GA_NEU =-1.2701
C
      WRITE(*,116)
      WRITE(*,111) GT_RED, ABS(GT_RED), GTPROB, GTPROB*GA_NEU**2
 111  FORMAT(1H*,1X,'GAMOW-TELLER REDUCED ME:',2F14.10,
     *              ' |M_GT|= ',F14.10,1X,1H*,/,
     *       1H*,4X,'B_GT = |M_GT|^2/(2I_i+1) =',F14.10,
     *              '  (g_A)^2*B_GT =',F14.10,3X,1H*)
C
      WRITE(*,116)
      WRITE(*, 78) IIFERL/IEVEN_,CHALF_,IIFERR/IEVEN_,CHALF_,
     *                           GTPROB*(IIFERR+1)/(IIFERL+1),
     *               (GA_NEU)**2*GTPROB*(IIFERR+1)/(IIFERL+1)
  78  FORMAT(1H*,3X,I3,A2,' --->',I3,A2,
     *          ' TRANSITION B_GT: ',F10.6,' AND (g_A)^2*B_GT:',
     *                                            F10.6,3X,1H*)
C
      WRITE(*,116)
      WRITE(*,115)
C
      END IF
C
C=======================================================================
C  RESTORE ISOSPIN PROJECTION PARAMERES TO THEIR INITIAL VALUES IN
C     CASE OF LPROJT.EQ.0 (SEE THE BEGINNING OF THE SUBROUTINE)
C=======================================================================
C
      IF (LPROJT.EQ.0) THEN
C
         ITL=1
         DO ISOSAC = ISOMIL,ISOMAL,2
         ITL=ITL+1
C
            DO LPROJE = -IIFERL,IIFERL,2
               F_KT_L(LPROJE,ITL,0)=C_ZERO
            END DO
C
         END DO
C
         ITR=1
         DO ISOSAC = ISOMIR,ISOMAR,2
         ITR=ITR+1
C
            DO KPROJB = -IIFERR,IIFERR,2
               F_KT_R(KPROJB,ITR,0)=C_ZERO
            END DO
C
         END DO
C
         ISOMAL=ISOMIL
         ISOMAR=ISOMIR
C
      END IF
C
C=======================================================================
      DEALLOCATE (OVRLAP)
      DEALLOCATE (WARAUX)
      DEALLOCATE (TARIGH)
      DEALLOCATE (TALEFT)
      DEALLOCATE (OVKERN,PNKE10,PNKE1P,PNKE1M)
      DEALLOCATE (GTKE00,GTKE0P,GTKE0M)
      DEALLOCATE (GTKEP0,GTKEPP,GTKEPM)
      DEALLOCATE (GTKEM0,GTKEMP,GTKEMM)
C=======================================================================
C
 1111 CONTINUE
C
      CALL CPUTIM('BETAME',0)
C
      RETURN
      END
C
C=======================================================================
C
      SUBROUTINE DIAPRO(JPROMI,JPROMA,KPROJE,IAXIAL,IHALF_,
     *                  JSOSMI,JSOSMA,ISOSTZ,LPROJJ,LPROJT,
     *                                ICUTOV,CUTOWE,CUTOWF,
     *                                IMIPRI,ISLPRI,ISUPRI,
     *                                       NUISOM,IENPRI,
     *                                       MINDIK,IBETME)
C
C=======================================================================
      USE hfodd_sizes
      USE TXXX_Y
      USE HAMMIX
C=======================================================================
C
      CHARACTER
     *          CHALF_*2
      CHARACTER
     *          HAFLIN*38,HAFLIM*38
C
      COMPLEX
     *          EPROJE,OPROJE
      COMPLEX
     *          WFI0T1,WPROI0,F_KT_R
      COMPLEX
     *          C_ZERO,FPROJE,HAMCUT
C
      DIMENSION
     *          OVEEIG(1:NDPROD),HAMEIG(1:NDPROD)
C     DIMENSION
C    *          AVRG_K(0:NDPROI,1:NDPROD,NDISOM)
      DIMENSION
     *          LINDIM(2),HAFLIN(1:NDPROD,2)
C
      COMMON
     *       /TMX0RA/ WPROI0(NDPROT),WFI0T1(NDPROT),E_I0T1
      COMMON
     *       /TMX0RB/ NPROI0(NDPROT),I_I0T1
      COMMON
     *       /FERMIR/ F_KT_R(-NDPROI:NDPROI,0:NDPROT,-NDPROT:NDPROT),
     *                EIGE_R,IDIM_R,IIFERR,ITFERR,ISFERR
      COMMON
     *       /APROJE/ EPROJE(NDPROM,NDISOM),OPROJE(NDPROM,NDISOM)
      COMMON
     *       /ALLPRO/ NUMPRO(0:NDPROI,0:NDISOM)
      COMMON
     *       /ISOIND/ ISOMAT(NDISOM),LSOMAT(NDISOM),KSOMAT(NDISOM)
      COMMON
     *       /IMKIND/ INDIMK(0:NDPROI,-NDPROI:NDPROI,-NDPROI:NDPROI)
      COMMON
     *       /CFIPRI/ NFIPRI
C
      IND_IK(IPRDUM,KPRDUM)=(IPRDUM**2-IHALF_)/4+(IPRDUM+KPRDUM)/2+1
C     INDIMK(IPRDUM,MPRDUM,KPRDUM)=(IPRDUM*(IPRDUM-1)*(IPRDUM+1))/6
C    *      +(IPRDUM+1)*((IPRDUM+MPRDUM)/2)+(IPRDUM+KPRDUM)/2+1
C
      CALL CPUTIM('DIAPRO',1)
C
C=======================================================================
C         THIS SUBROUTINE DIAGONALIZES THE HAMILTONIAN MATRIX FOR
C         THE ANGULAR-MOMENTUM AND 1D-ISOSPIN PROJECTED STATES
C=======================================================================
C         THE SUBROUTINE GIVES THE K-MIXED EIGENVECTORS IN THE  ARRAY
C         "WAVPRO", THEIR EIGEN-ENERGIES IN THE  ARRAY  "ENEPRO"  AND
C         THE NUMBER THEREOF IN THE  ARRAY "NUMPRO". VALUES OF "0" IN
C         NUMPRO  ARRAY MEAN THE ABSENCE OF THE GIVEN SPIN  COMPONENT
C         IN THE HF WAVE FUNCTION; IN THIS CASE "WAVPRO" AND "ENEPRO"
C         ARRAYS ARE NOT DEFINED.
C=======================================================================
C
                       CHALF_='  '
      IF (IHALF_.EQ.1) CHALF_='/2'
C
      IEVEN_=2/(IHALF_+1)
C
      ISTORE=0
C
      C_ZERO=CMPLX(0.0D0,0.0D0)
C
C=======================================================================
C        ALLOCATING LOCAL ARRAYS
C=======================================================================
C
      ALLOCATE (CELMTS(1:((NDPROD+1)*NDPROD)/2),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('CELMTS','DIAPRO')
      ALLOCATE (OVEWAV(1:NDPROD,1:NDPROD),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('OVEWAV','DIAPRO')
      ALLOCATE (HAMWAV(1:NDPROD,1:NDPROD),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('HAMWAV','DIAPRO')
      ALLOCATE (HAMMAT(1:NDPROD,1:NDPROD),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('HAMMAT','DIAPRO')
      ALLOCATE (OVEPRO(0:NDPROI,1:NDPROD,NUISOM),STAT=IALLOC)
            IF (IALLOC.NE.0) CALL NOALLO('OVEPRO','DIAPRO')
C
      IF (.NOT.ALLOCATED(WAVPRO)) THEN
          ALLOCATE (WAVPRO(0:NDPROK,1:NDPROD,NUISOM),STAT=IALLOC)
                IF (IALLOC.NE.0) CALL NOALLO('WAVPRO','DIAPRO')
      END IF
      IF (.NOT.ALLOCATED(ENEPRO)) THEN
          ALLOCATE (ENEPRO(0:NDPROI,1:NDPROD,NUISOM),STAT=IALLOC)
                IF (IALLOC.NE.0) CALL NOALLO('ENEPRO','DIAPRO')
      END IF
C
C=======================================================================
C            HERE STARTS THE LOOP OVER THE 